<nav class="navbar navbar-expand-xl navbar-dark fixed-top navbar-main navbar-single py-0">
    <div class="container-fluid ms-0">
        <a class="navbar-brand d-flex align-items-center me-2" href="{{ action('HomeController@index') }}">
            @if (\Acelle\Model\Setting::get('site_logo_small'))
                <img class="logo" src="{{ action('SettingController@file', \Acelle\Model\Setting::get('site_logo_small')) }}" alt="">
            @else
                <span class="default-app-logo">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 389.3 60.1"><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Layer_2-2" data-name="Layer 2"><g id="Layer_1-2-2" data-name="Layer 1-2"><path d="M38.5,56.4,36.7,43.8H16.9l-7,12.6H0L29.6,6h9.8l8,50.4ZM33.1,16V13.6h-.2a18,18,0,0,1-1.6,3.8L20.6,36.7H35.7l-2.4-19A9.9,9.9,0,0,1,33.1,16Z" style="fill:#fff"/><path d="M82.7,28.9A13.5,13.5,0,0,0,79.4,27a13.2,13.2,0,0,0-4.4-.8,10.4,10.4,0,0,0-6.1,2,14.7,14.7,0,0,0-4.5,5.7,17.5,17.5,0,0,0-1.8,7.8c0,2.9.7,5.1,2,6.6a7,7,0,0,0,5.6,2.3,12.2,12.2,0,0,0,4.6-.9,22.6,22.6,0,0,0,4.4-2.2l-1.5,7.2a22.4,22.4,0,0,1-9.9,2.6c-4.3,0-7.6-1.3-10.1-3.9s-3.6-6.3-3.6-10.9a26,26,0,0,1,2.7-11.6,19.9,19.9,0,0,1,7.6-8.4,20.2,20.2,0,0,1,10.9-3,22.2,22.2,0,0,1,5.1.6,19.7,19.7,0,0,1,4,1.6Z" style="fill:#fff"/><path d="M118.6,29.3a10,10,0,0,1-6,9.5c-4.1,2.1-10.2,3.2-18.4,3.3v1.1a7.4,7.4,0,0,0,2.2,5.6,8.6,8.6,0,0,0,6.1,2.1,22,22,0,0,0,5.7-1,39.9,39.9,0,0,0,5.6-2.5l-1.4,7a25,25,0,0,1-11.7,2.9c-4.7,0-8.3-1.3-10.9-3.9s-4-6.3-4-11a25.6,25.6,0,0,1,2.7-11.5A20.7,20.7,0,0,1,96,22.6a18.4,18.4,0,0,1,10.4-3.1q5.7,0,9,2.7A8.8,8.8,0,0,1,118.6,29.3Zm-8.2.2a3.7,3.7,0,0,0-1.3-2.8,4.9,4.9,0,0,0-3.5-1.1,9.8,9.8,0,0,0-6.8,3.1,15.7,15.7,0,0,0-4,7.5c10.4,0,15.6-2.2,15.6-6.7Z" style="fill:#fff"/><path d="M130.6,57c-2.6,0-4.6-.6-6-1.9a7.5,7.5,0,0,1-2-5.5,60.1,60.1,0,0,1,1.3-8.5c.9-4.1,3.6-16.8,8.1-38h8.6l-8.5,40a35.4,35.4,0,0,0-.8,4.5c0,1.8,1,2.7,3.1,2.7a8.7,8.7,0,0,0,3.2-.6l-1.3,6.5A22.4,22.4,0,0,1,130.6,57Z" style="fill:#fff"/><path d="M151.3,57c-2.6,0-4.6-.6-5.9-1.9a7.1,7.1,0,0,1-2-5.5,48.5,48.5,0,0,1,1.3-8.5c.9-4.1,3.6-16.8,8.1-38h8.5l-8.5,40a23.4,23.4,0,0,0-.7,4.5q0,2.7,3,2.7a8.7,8.7,0,0,0,3.2-.6L157,56.2A22.4,22.4,0,0,1,151.3,57Z" style="fill:#fff"/><path d="M196.3,29.3a10,10,0,0,1-6,9.5c-4,2.1-10.2,3.2-18.4,3.3v1.1a7.3,7.3,0,0,0,2.1,5.6,8.6,8.6,0,0,0,6.1,2.1,22,22,0,0,0,5.7-1,28.1,28.1,0,0,0,5.6-2.5l-1.4,7a25,25,0,0,1-11.7,2.9c-4.7,0-8.3-1.3-10.9-3.9s-3.9-6.3-3.9-11a26.9,26.9,0,0,1,2.6-11.5,20.7,20.7,0,0,1,7.5-8.3,18.7,18.7,0,0,1,10.5-3.1c3.7,0,6.7.9,8.9,2.7A8.5,8.5,0,0,1,196.3,29.3Zm-8.2.2a3.2,3.2,0,0,0-1.3-2.8,4.9,4.9,0,0,0-3.5-1.1,9.8,9.8,0,0,0-6.8,3.1,14.7,14.7,0,0,0-3.9,7.5C182.9,36.2,188.1,34,188.1,29.5Z" style="fill:#fff"/><path d="M339.6,59.2h-8.7a17.3,17.3,0,0,1,.3-3.2,22,22,0,0,1,.4-3.6h-.2a28.9,28.9,0,0,1-3.8,4.7,12.4,12.4,0,0,1-3.4,2.2,12.6,12.6,0,0,1-4.3.8,9.1,9.1,0,0,1-7.9-3.7c-1.9-2.4-2.9-5.7-2.9-10A25.6,25.6,0,0,1,312.2,34a19.9,19.9,0,0,1,8.2-8.8,23.9,23.9,0,0,1,12-2.9A68.3,68.3,0,0,1,345.9,24l-5,23.5c-.3,1.6-.6,3.7-.9,6.1A52.7,52.7,0,0,0,339.6,59.2Zm-3.3-30a15.7,15.7,0,0,0-4.8-.5,12.8,12.8,0,0,0-7.1,2.1,14.4,14.4,0,0,0-4.9,6.3,22.5,22.5,0,0,0-1.8,8.9,9.2,9.2,0,0,0,1.3,5.4,4.5,4.5,0,0,0,4,1.9c2.5,0,4.8-1.3,6.8-3.9a26.4,26.4,0,0,0,4.4-10.5Z" style="fill:#fff"/><path d="M358.6,59.8a8.3,8.3,0,0,1-5.9-2,7.1,7.1,0,0,1-2-5.5,14.7,14.7,0,0,1,.4-3.6l5.2-25.5h8.5l-4.7,22.7a35.4,35.4,0,0,0-.8,4.5c0,1.8,1,2.7,3.1,2.7a8.7,8.7,0,0,0,3.2-.6L364.2,59A21,21,0,0,1,358.6,59.8ZM368.1,11a4.7,4.7,0,0,1-1.5,3.5,5.5,5.5,0,0,1-3.7,1.4,4.5,4.5,0,0,1-3.5-1.3,3.9,3.9,0,0,1-1.5-3.3,3.9,3.9,0,0,1,1.6-3.5,5,5,0,0,1,3.7-1.3,5.5,5.5,0,0,1,3.5,1.2A4.7,4.7,0,0,1,368.1,11Z" style="fill:#fff"/><path d="M379.3,59.8a8.3,8.3,0,0,1-5.9-2,6.9,6.9,0,0,1-2.1-5.4,48.6,48.6,0,0,1,1.4-8.5c.9-4.1,3.6-16.8,8.1-38h8.5l-8.5,40a23.4,23.4,0,0,0-.7,4.5q0,2.7,3,2.7a8.7,8.7,0,0,0,3.2-.6L385,59A22.4,22.4,0,0,1,379.3,59.8Z" style="fill:#fff"/><path d="M307.4.1,310,3.3c-.1.4-.1.7-.2,1.1l-.2.6L297.9,59.1H284.5l10.4-44L266.1,44.8l-4.2-.6L246.7,16.9c-3.6,14-7.1,28-10.7,42.1l-11.6.2,14-54.8c.3-1.5.7-2.9,1.5-3.4h10.2c-.3-.8-.2-.6-.1-.4s1.3,2.5,1.9,3.8l.4.6c4.5,8.9,9.1,17.7,13.7,26.5L291.7,5l.6-.6L296.5.1Z" style="fill:#fff"/><path d="M310,3.5a2.9,2.9,0,0,0-.2.9H238.4l.4-1.8A3.4,3.4,0,0,1,242.1,0h65.1a2.9,2.9,0,0,1,2.9,2.9C310.1,3.1,310,3.3,310,3.5Z" style="fill:#fff"/><path d="M228.9,14.7H203.3a2.5,2.5,0,0,1,0-5h25.6a2.5,2.5,0,0,1,0,5Z" style="fill:#fff"/><path d="M225.3,28.7H213.5a2.5,2.5,0,0,1,0-5h11.8a2.5,2.5,0,0,1,0,5Z" style="fill:#fff"/><path d="M221.9,42.7h-3.1a2.5,2.5,0,0,1,0-5h3.1a2.5,2.5,0,0,1,0,5Z" style="fill:#fff"/></g></g></g></g></svg>
                </span>
            @endif
        </a>
        <button class="navbar-toggler" role="button" data-bs-toggle="collapse" data-bs-target="#navbarsExample04" aria-controls="navbarsExample04" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <span class="leftbar-hide-menu middle-bar-element">
            <svg class="SideBurgerIcon-image" viewBox="0 0 50 32"><path d="M49,4H19c-0.6,0-1-0.4-1-1s0.4-1,1-1h30c0.6,0,1,0.4,1,1S49.6,4,49,4z"></path><path d="M49,16H19c-0.6,0-1-0.4-1-1s0.4-1,1-1h30c0.6,0,1,0.4,1,1S49.6,16,49,16z"></path><path d="M49,28H19c-0.6,0-1-0.4-1-1s0.4-1,1-1h30c0.6,0,1,0.4,1,1S49.6,28,49,28z"></path><path d="M8.1,22.8c-0.3,0-0.5-0.1-0.7-0.3L0.7,15l6.7-7.8c0.4-0.4,1-0.5,1.4-0.1c0.4,0.4,0.5,1,0.1,1.4L3.3,15l5.5,6.2   c0.4,0.4,0.3,1-0.1,1.4C8.6,22.7,8.4,22.8,8.1,22.8z"></path></svg>
        </span>

        <div class="collapse navbar-collapse" id="navbarsExample04">
            <ul class="navbar-nav me-auto mb-md-0 main-menu">
                <li class="nav-item" rel0="HomeController">
                    <a href="{{ action('HomeController@index') }}" title="{{ trans('messages.dashboard') }}" class="leftbar-tooltip nav-link d-flex align-items-center py-3 lvl-1">
                        <i class="navbar-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 92.1 86.1"><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Layer_2-2" data-name="Layer 2"><g id="Layer_1-2-2" data-name="Layer 1-2"><path d="M51.8,86.1H41.9a8.5,8.5,0,0,1-8.5-8.5V60.2a8.5,8.5,0,0,1,8.5-8.5h9.9a8.5,8.5,0,0,1,8.5,8.5V77.6A8.5,8.5,0,0,1,51.8,86.1ZM41.9,58.7a1.5,1.5,0,0,0-1.5,1.5V77.6a1.5,1.5,0,0,0,1.5,1.5h9.9a1.5,1.5,0,0,0,1.5-1.5V60.2a1.5,1.5,0,0,0-1.5-1.5Z" style="fill:aqua"/><path d="M60.4,86.1H31.7A20.6,20.6,0,0,1,11.2,65.7V24.6h7V65.7A13.5,13.5,0,0,0,31.7,79.1H60.4A13.5,13.5,0,0,0,73.9,65.7V25.3h7V65.7A20.6,20.6,0,0,1,60.4,86.1Z" style="fill:#f2f2f2"/><path d="M88.6,36.5a3.6,3.6,0,0,1-2-.6L45.7,7.7,5.5,35.1a3.5,3.5,0,1,1-4-5.8L43.7.6a3.6,3.6,0,0,1,4,0L90.6,30.1a3.5,3.5,0,0,1-2,6.4Z" style="fill:#f2f2f2"/></g></g></g></g></svg>
                        </i>
                        <span>{{ trans('messages.dashboard') }}</span>
                    </a>
                </li>
                <li class="nav-item" rel0="CampaignController">
                    <a title="{{ trans('messages.campaigns') }}" href="{{ action('CampaignController@index') }}" class="leftbar-tooltip nav-link d-flex align-items-center py-3 lvl-1">
                        <i class="navbar-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 106.1 92.1"><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Layer_2-2" data-name="Layer 2"><g id="Layer_1-2-2" data-name="Layer 1-2"><path d="M40.8,92.1h-.1a5.2,5.2,0,0,1-5.1-4.8c-1.4-4.5-2.7-9-4-13.4S29,65.3,27.8,61L3.2,50.4a.1.1,0,0,0-.1-.1A5.7,5.7,0,0,1,.5,47.8a5.6,5.6,0,0,1,2.6-7.4.1.1,0,0,0,.1-.1c16-6.8,31.7-13.2,46.9-19.3S82.2,8,98.9.8a4.5,4.5,0,0,1,5.7.4,4.6,4.6,0,0,1,1.5,4.1l-5.4,38.1C99,56.1,97.2,68.8,95.4,81.6a5.5,5.5,0,0,1-2,3.7,5.6,5.6,0,0,1-4.1,1.4l-1.4-.3h-.2L52.1,71.2c-2.2,6-4.2,11.3-6,16.4A5.4,5.4,0,0,1,40.8,92.1ZM9.3,45.4,31.6,55a4.8,4.8,0,0,1,2.6,3c1.3,4.6,2.7,9.2,4.1,13.9L41,81q2.7-7.2,5.7-15.6l.2-.3.2-.4c.1-.2.2-.5.4-.6L89.2,12.6C76.8,17.8,64.6,22.7,52.7,27.5,38.6,33.2,24.1,39.1,9.3,45.4ZM55.6,65.2,88.7,79.1l5.1-36.6L98,12.8ZM27.5,59.9h0Z" style="fill:#f2f2f2"/><path d="M40.1,54.6a3.6,3.6,0,0,1-2.2-6.3l2-1.6a3.6,3.6,0,0,1,5,.6,3.5,3.5,0,0,1-.6,4.9l-2,1.6A3.5,3.5,0,0,1,40.1,54.6Z" style="fill:#ff0"/><path d="M52.4,45.2a3.5,3.5,0,0,1-2.7-1.4,3.4,3.4,0,0,1,.6-4.9L63.4,28.6a3.5,3.5,0,0,1,4.3,5.5L54.6,44.4A3.7,3.7,0,0,1,52.4,45.2Z" style="fill:aqua"/></g></g></g></g></svg>
                        </i>
                        <span>{{ trans('messages.campaigns') }}</span>
                    </a>
                </li>
                <li class="nav-item" rel0="Automation2Controller">
                    <a href="{{ action('Automation2Controller@index') }}" title="{{ trans('messages.automations') }}" class="leftbar-tooltip nav-link d-flex align-items-center py-3 lvl-1">
                        <i class="navbar-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86.4 86.6"><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Layer_2-2" data-name="Layer 2"><g id="Layer_1-2-2" data-name="Layer 1-2"><path d="M38.4,57.1a3.2,3.2,0,0,1-2.3-.8L21.7,43.8a3.5,3.5,0,1,1,4.6-5.3L38.4,49,60.1,30.5a3.4,3.4,0,0,1,4.9.4,3.5,3.5,0,0,1-.3,4.9l-24,20.5A3.4,3.4,0,0,1,38.4,57.1Z" style="fill:aqua"/><path d="M43.2,86.6H42.1A42.6,42.6,0,0,1,11.9,73.1a43,43,0,0,1,1.6-61,43,43,0,0,1,61,1.6,43,43,0,0,1-1.6,61A42.8,42.8,0,0,1,43.2,86.6Zm0-79.4A36.2,36.2,0,0,0,7,42.4H7A36.2,36.2,0,0,0,42.3,79.6,36.2,36.2,0,0,0,69.5,18.5,36.5,36.5,0,0,0,44.1,7.2ZM3.5,42.3Z" style="fill:#f2f2f2"/><path d="M8.7,27.2a3.2,3.2,0,0,1-1.9-.5A14.5,14.5,0,0,1,11.6.3,14.4,14.4,0,0,1,26.3,5.9a3.6,3.6,0,0,1-.7,4.9,3.5,3.5,0,0,1-4.9-.8,8.6,8.6,0,0,0-2-1.8A7.5,7.5,0,0,0,8.4,10.4a7.5,7.5,0,0,0,2.2,10.4,3.4,3.4,0,0,1,1,4.8A3.3,3.3,0,0,1,8.7,27.2Z" style="fill:#f2f2f2"/><path d="M77.7,27.2a3.3,3.3,0,0,1-2.9-1.5,3.5,3.5,0,0,1,1-4.9,7.4,7.4,0,0,0,3.3-6.3,7.8,7.8,0,0,0-2.3-5.2,7.4,7.4,0,0,0-5.3-2.1,8.2,8.2,0,0,0-6,2.9,3.5,3.5,0,1,1-5.4-4.4A15.1,15.1,0,0,1,71.5.2,14.5,14.5,0,0,1,86.1,14.4a14.4,14.4,0,0,1-6.5,12.3A3.4,3.4,0,0,1,77.7,27.2Z" style="fill:#f2f2f2"/></g></g></g></g></svg>
                        </i>
                        <span>{{ trans('messages.automations') }}</span>
                    </a>
                </li>
                <li class="nav-item" rel0="MailListController">
                    <a href="{{ action('MailListController@index') }}" title="{{ trans('messages.lists') }}" class="leftbar-tooltip nav-link d-flex align-items-center py-3 lvl-1">
                        <i class="navbar-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 86.3 87.8"><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Layer_2-2" data-name="Layer 2"><g id="Layer_1-2-2" data-name="Layer 1-2"><g id="Layer_2-2-2" data-name="Layer 2-2"><g id="Layer_1-2-2-2" data-name="Layer 1-2-2"><g id="Layer_2-2-2-2" data-name="Layer 2-2-2"><g id="Layer_1-2-2-2-2" data-name="Layer 1-2-2-2"><path d="M62.5,49.5A13.1,13.1,0,1,1,75.6,36.4,13.1,13.1,0,0,1,62.5,49.5Zm0-18.8a5.8,5.8,0,1,0,5.8,5.7A5.8,5.8,0,0,0,62.5,30.7Z" style="fill:#f2f2f2"/><path d="M42.6,87.5h-.1a3.5,3.5,0,0,1-3.4-3.6c.4-10.4,4.5-20,10.8-25.6a18.4,18.4,0,0,1,14.2-4.9C76.6,54.5,85.5,66.8,86,83.9a3.3,3.3,0,0,1-3.3,3.6A3.5,3.5,0,0,1,79,84.2c-.4-13.3-6.8-23.1-15.6-23.9a12.1,12.1,0,0,0-8.9,3.3c-4.9,4.3-8,12-8.4,20.6A3.4,3.4,0,0,1,42.6,87.5Z" style="fill:#f2f2f2"/><path d="M82.5,87.5H42.6A3.5,3.5,0,0,1,39.1,84a3.5,3.5,0,0,1,3.5-3.5H82.5A3.5,3.5,0,0,1,86,84,3.4,3.4,0,0,1,82.5,87.5Z" style="fill:#f2f2f2"/><path d="M28.9,87.8H15.6C7,87.8,0,81.9,0,74.6V13.1C0,5.9,7,0,15.6,0h55c8.7,0,15.7,5.9,15.7,13.1V24.6a3.8,3.8,0,1,1-7.5,0V13.1c0-3-3.7-5.6-8.2-5.6h-55c-4.3,0-8.1,2.6-8.1,5.6V74.6c0,3.1,3.8,5.7,8.1,5.7H28.9a3.8,3.8,0,1,1,0,7.5Z" style="fill:#f2f2f2"/><path d="M44.2,30.5H23.4A3.5,3.5,0,0,1,19.9,27a3.5,3.5,0,0,1,3.5-3.5H44.2A3.5,3.5,0,0,1,47.7,27,3.4,3.4,0,0,1,44.2,30.5Z" style="fill:#f2f2f2"/><path d="M28.9,47.8H23.4a3.5,3.5,0,0,1-3.5-3.5,3.5,3.5,0,0,1,3.5-3.5h5.5a3.5,3.5,0,0,1,3.5,3.5A3.4,3.4,0,0,1,28.9,47.8Z" style="fill:#ff0"/><path d="M27.7,65.1H23.4a3.5,3.5,0,0,1-3.5-3.5,3.5,3.5,0,0,1,3.5-3.5h4.3a3.5,3.5,0,0,1,3.5,3.5A3.4,3.4,0,0,1,27.7,65.1Z" style="fill:#f2f2f2"/><polygon points="43.7 55.8 40.3 54.5 37.2 56.6 37.4 52.9 34.4 50.7 38 49.7 39.2 46.2 41.2 49.3 44.9 49.3 42.6 52.3 43.7 55.8" style="fill:lime"/><path d="M37.2,57.1H37a.5.5,0,0,1-.3-.5l.2-3.4-2.8-2.1c-.1-.1-.2-.3-.1-.4s.1-.4.3-.4l3.4-1,1.1-3.2c0-.2.2-.3.4-.4a.5.5,0,0,1,.5.3l1.8,2.8h3.4a.9.9,0,0,1,.5.3c.1.2.1.4-.1.5l-2.1,2.8,1,3.3a.4.4,0,0,1-.1.5c-.2.1-.4.2-.5.1l-3.2-1.2-2.9,2Zm-1.6-6.2,2.1,1.6a.4.4,0,0,1,.2.5v2.7l2.3-1.6a.3.3,0,0,1,.4,0L43,55l-.8-2.5a.5.5,0,0,1,0-.5l1.7-2.2H41.2a.4.4,0,0,1-.4-.2l-1.4-2.2-.9,2.5a.3.3,0,0,1-.3.3Z" style="fill:lime"/></g></g></g></g></g></g></g></g></svg>
                        </i>
                        <span>{{ trans('messages.lists') }}</span>
                    </a>
                </li>
                <li class="nav-item" rel0="TemplateController">
                    <a href="{{ action('TemplateController@index') }}" title="{{ trans('messages.templates') }}" class="leftbar-tooltip nav-link d-flex align-items-center py-3 lvl-1">
                        <i class="navbar-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 91.8 86.2"><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Layer_2-2" data-name="Layer 2"><g id="Layer_1-2-2" data-name="Layer 1-2"><path d="M72.7,86.2h-61A11.7,11.7,0,0,1,0,74.5v-61A11.7,11.7,0,0,1,11.7,1.8H52.3a3.5,3.5,0,0,1,3.5,3.5,3.5,3.5,0,0,1-3.5,3.5H11.7A4.7,4.7,0,0,0,7,13.5v61a4.7,4.7,0,0,0,4.7,4.7h61a4.7,4.7,0,0,0,4.7-4.7V35.2a3.5,3.5,0,0,1,7,0V74.5A11.7,11.7,0,0,1,72.7,86.2Z" style="fill:#f2f2f2"/><path d="M17.2,23.4a4.9,4.9,0,1,1,4.9-4.9A4.9,4.9,0,0,1,17.2,23.4Zm0-7a2.1,2.1,0,1,0,2.1,2.1A2.1,2.1,0,0,0,17.2,16.4Z" style="fill:#f2f2f2"/><path d="M32,23.4a4.9,4.9,0,1,1,4.9-4.9A4.9,4.9,0,0,1,32,23.4Zm0-7a2.1,2.1,0,1,0,2.1,2.1A2.1,2.1,0,0,0,32,16.4Z" style="fill:aqua"/><path d="M44,50.5h-.1A5.3,5.3,0,0,1,40,48.9h0a5.6,5.6,0,0,1-1.5-4.1c.2-6.7,9.9-20.2,18.9-28.5S79.8-.3,86.5,0a5.4,5.4,0,0,1,4,1.8c3.2,3.5-.3,9.6-3.6,14.5a104,104,0,0,1-12.8,15C66.3,39.1,51.3,50.5,44,50.5ZM84.1,7.4C79.6,8.7,70.3,14,62.2,21.5A78.4,78.4,0,0,0,50.1,35.7,34.5,34.5,0,0,0,46,43c4.6-1.8,14.5-8.1,23.2-16.7S82.2,11.3,84.1,7.4Z" style="fill:#f2f2f2"/><path d="M31.4,69.1c-7,0-13.4-3.7-15.3-6.3a3.7,3.7,0,0,1-.7-3.7c1-2.9,4.1-2.7,5.7-2.6a13.1,13.1,0,0,0,2.8.1V56c.1-4.3,2.1-11.6,7.2-14.1s13.1,0,16.5,6,.8,11.2-.4,13.3v.3C43.1,68.3,34.8,69.1,31.4,69.1Zm-2.6-7.2,2.6.2c2.2,0,7.4-.4,9.6-4.1.6-1.2,1.9-4.1.4-6.7s-5.4-4.1-7.1-3.2h0c-1.6.8-3.2,4.6-3.4,7.8a7.9,7.9,0,0,1-.7,4.3l-.3.5Z" style="fill:#ff0"/><rect x="53.5" y="28.5" width="7" height="7.8" transform="translate(-4.8 54.4) rotate(-49.2)" style="fill:#f2f2f2"/></g></g></g></g></svg>
                        </i>
                        <span>{{ trans('messages.templates') }}</span>
                    </a>
                </li>                
                @if (
                    Auth::user()->customer->can("read", new Acelle\Model\SendingServer()) ||					
                    Auth::user()->customer->can("read", new Acelle\Model\EmailVerificationServer()) ||
                    Auth::user()->customer->can("read", new Acelle\Model\Blacklist()) ||
                    true
                )
                    <li class="nav-item dropdown">
                        <a title="{{ trans('messages.sending') }}" href="{{ action('TemplateController@index') }}" class="leftbar-tooltip nav-link d-flex align-items-center py-3 lvl-1 dropdown-toggle" id="sending-menu" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="navbar-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 92 94.2"><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Layer_2-2" data-name="Layer 2"><g id="Layer_1-2-2" data-name="Layer 1-2"><path d="M46.1,94.2A46.9,46.9,0,0,1,12.3,79.9a3.5,3.5,0,1,1,5-4.8,40.2,40.2,0,0,0,56.6.9A39.5,39.5,0,0,0,85.1,56a3.5,3.5,0,1,1,6.8,1.6A47.1,47.1,0,0,1,46.1,94.2Z" style="fill:#f2f2f2"/><polygon points="4.1 89.6 3.5 56.8 32.2 72.6 4.1 89.6" style="fill:#f2f2f2"/><path d="M3.5,40.9H2.7A3.5,3.5,0,0,1,.1,36.6,46.9,46.9,0,0,1,46,0h.2A46.5,46.5,0,0,1,79.7,14.3a3.5,3.5,0,1,1-5,4.8A39.7,39.7,0,0,0,46.2,7H46A39.9,39.9,0,0,0,6.9,38.2,3.5,3.5,0,0,1,3.5,40.9Z" style="fill:#f2f2f2"/><polygon points="59.8 21.6 88.5 37.4 87.9 4.6 59.8 21.6" style="fill:#f2f2f2"/><path d="M64,43.3H60.9a3.3,3.3,0,0,1-1.6-.7,2.8,2.8,0,0,1-.7-1.7,2.1,2.1,0,0,1,.7-1.5h0l.4-.4c0-.1,0-.1.1-.1h0l1.6-1.7c.5-.4.4-1.2-.2-1.8L57.8,32c-.6-.6-1.4-.7-1.8-.2l-1.7,1.6h0c-.1.1-.2.2-.2.3l-.3.2h0a2.5,2.5,0,0,1-1.6.6,2.3,2.3,0,0,1-2.3-2.3h0v-.7h0V29.3c0-.6-.6-1.1-1.5-1.1H43.6a1.2,1.2,0,0,0-1.4,1.1v2.3h-.1a.4.4,0,0,0,.1.3v.4h0a2.9,2.9,0,0,1-.7,1.6,2.6,2.6,0,0,1-3.3.1h0l-.4-.3v-.2h-.1l-1.6-1.7-.4-.3h-.4a2.2,2.2,0,0,0-1.1.5l-3.4,3.4c-.6.6-.7,1.4-.2,1.8l1.7,1.7h0c0,.1.1.1.2.2l.3.3h0a2,2,0,0,1,.6,1.5,2.4,2.4,0,0,1-2.3,2.4h-3c-.7,0-1.1.6-1.1,1.4v4.8c0,.8.4,1.4,1.1,1.4h3a2.9,2.9,0,0,1,1.6.7,2.3,2.3,0,0,1,.1,3.2h0l-.4.4h-.1L30.6,57l-.3.3v.4a2.2,2.2,0,0,0,.5,1.1l3.4,3.4a1.8,1.8,0,0,0,1.2.5.9.9,0,0,0,.7-.3l1.6-1.6h.1l.2-.3.2-.2h0a2.5,2.5,0,0,1,1.6-.6A2.4,2.4,0,0,1,42.2,62h-.1v.7h0V65c0,.6.7,1.1,1.5,1.1h4.8c.9,0,1.5-.5,1.5-1.1V62.6h0v-.7h0a2,2,0,0,1,.7-1.6,2.4,2.4,0,0,1,3.2-.1h0l.4.4c0,.1.1.1.1.2h0L56,62.4a.9.9,0,0,0,.7.3,2.2,2.2,0,0,0,1.1-.5l3.4-3.4a2.2,2.2,0,0,0,.5-1.1v-.5l-1.9-1.9h0c-.1-.1-.2-.1-.2-.2l-.3-.3h0a2,2,0,0,1-.6-1.5,2.3,2.3,0,0,1,2.2-2.4H64a1.2,1.2,0,0,0,1.1-1.4V44.7A1.2,1.2,0,0,0,64,43.3Zm-.6,6H61a4.1,4.1,0,0,0-4,4.2,4,4,0,0,0,1.8,3.3h0l1.1,1.1-3.1,3-1-1h-.1l-.5-.6a4,4,0,0,0-5.8-.2A4.1,4.1,0,0,0,48.2,63h0v1.5H43.8V62.9h.1V62a4.1,4.1,0,0,0-4.1-4.1,4.2,4.2,0,0,0-3.4,1.8h-.1l-1,1-3.1-3,1-1.1h.1l.6-.5a4.1,4.1,0,0,0,0-5.8h0a4,4,0,0,0-3.7-1.1H28.6V44.9H31a4.1,4.1,0,0,0,4.1-4.1,4.2,4.2,0,0,0-1.8-3.4h-.1l-1-1.1,3.1-3,1,1h0l.6.6a3.8,3.8,0,0,0,2.9,1.2A4.1,4.1,0,0,0,43.9,32a2.2,2.2,0,0,0-.1-.8h0V29.9h4.4v1.4h0a2.2,2.2,0,0,0-.1.8,4.1,4.1,0,0,0,4.1,4.1,4.4,4.4,0,0,0,3.5-1.8h0l1.1-1,3.1,3.1-1,.9h-.1l-.7.5a4.1,4.1,0,0,0,0,5.8h0A3.9,3.9,0,0,0,61,45h2.4Z"/><path d="M48.4,68.1H43.6A3.3,3.3,0,0,1,40.1,65V61.8h-.6l-.6,1h-.4l-1,1a2.8,2.8,0,0,1-2,.9h-.3a4.3,4.3,0,0,1-2.3-1h-.1l-3.5-3.5a4.1,4.1,0,0,1-1-2.1V56.5l.9-.9,2.2-2.4a.1.1,0,0,0-.1-.1l-.3-.2H28.1A3.1,3.1,0,0,1,25,49.5V44.7a3.1,3.1,0,0,1,3.1-3.4h3a.4.4,0,0,0,.3-.4l-.3-.3-.4-.5-1.5-1.4a2.9,2.9,0,0,1-.9-2A3.2,3.2,0,0,1,29.4,34l3.5-3.5a4.1,4.1,0,0,1,2.1-1h1.4l1.2.9,1,1.1h1.1v1h.3c0-.1.1-.2.1-.3a1.9,1.9,0,0,1-.1-.8V29a3.4,3.4,0,0,1,3.5-2.8h4.7a3.3,3.3,0,0,1,3.5,3.1v2.9a.3.3,0,0,0,.3.3l.4-.2h0l.3-.3,1.7-1.6a2.8,2.8,0,0,1,1.9-.9,3.2,3.2,0,0,1,2.7,1.1L62.6,34a3.2,3.2,0,0,1,1.1,2.7,2.8,2.8,0,0,1-.9,1.9l-2.2,2.3c0,.1,0,.2.1.2a.5.5,0,0,0,.4.2h3.2a3.4,3.4,0,0,1,2.8,3.5v4.6a3.4,3.4,0,0,1-2.8,3.5H60.9c-.1,0-.2.1-.2.3h0l.5.5h0l2.5,2.5V58a4.1,4.1,0,0,1-1,2.1h-.1l-3.5,3.5a4.1,4.1,0,0,1-2.1,1h-.2a3.1,3.1,0,0,1-2.2-.9l-2.3-2.2h-.4V65A3.3,3.3,0,0,1,48.4,68.1Zm-2.5-5.6h.2A6.5,6.5,0,0,1,48,57.6a6.3,6.3,0,0,1,8.7.3v.2l.2-.2a6.1,6.1,0,0,1-2-4.4,6.1,6.1,0,0,1,6-6.2h.4V47H61a6,6,0,0,1-4.4-1.9,6.1,6.1,0,0,1,.1-8.6l.2-.2h-.1a6.2,6.2,0,0,1-10.7-4v-.3h-.2a6,6,0,0,1-1.8,4.3,6.2,6.2,0,0,1-4.3,1.8,5.8,5.8,0,0,1-4.4-1.8v-.2l-.2.2a6.3,6.3,0,0,1,2,4.5A6.1,6.1,0,0,1,31,46.9h-.4v.2a5.8,5.8,0,0,1,4.7,1.8,6,6,0,0,1,0,8.6l-.2.2.2.2h0a6.1,6.1,0,0,1,4.5-2h0A6.1,6.1,0,0,1,45.9,62Z" style="fill:aqua"/></g></g></g></g></svg>
                            </i>
                            <span>{{ trans('messages.sending') }}</span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-bottom" aria-labelledby="sending-menu">
                            @if (Auth::user()->admin->can("read", new Acelle\Model\SendingServer()))
                                <li class="nav-item" rel0="SendingServerController">
                                    <a href="{{ action('Admin\SendingServerController@index') }}"
                                        class="dropdown-item d-flex align-items-center">
                                        <i class="navbar-icon" style="width:19px">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 91.6 90.9" style="enable-background:new 0 0 91.6 90.9;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M83.9,90.9H7.7c-4.2,0-7.7-3.1-7.7-6.8V6.8C0,3.1,3.5,0,7.7,0h76.2c4.2,0,7.7,3.1,7.7,6.8v77.3 C91.6,87.8,88.1,90.9,83.9,90.9z M7,83.7c0.1,0.1,0.4,0.2,0.7,0.2h76.2c0.3,0,0.6-0.1,0.7-0.2V7.2C84.5,7.1,84.2,7,83.9,7H7.7 C7.4,7,7.1,7.1,7,7.2V83.7z"/><path class="st0" d="M85.6,61.6H3.5C1.6,61.6,0,60,0,58.1s1.6-3.5,3.5-3.5h82.1c1.9,0,3.5,1.6,3.5,3.5S87.5,61.6,85.6,61.6z"/><path class="st0" d="M88.1,33.6H3.5C1.6,33.6,0,32,0,30.1s1.6-3.5,3.5-3.5h84.6c1.9,0,3.5,1.6,3.5,3.5S90,33.6,88.1,33.6z"/><path class="st0" d="M72,22.2c-3.6,0-6.5-2.8-6.5-6.3c0-3.5,2.9-6.3,6.5-6.3s6.5,2.8,6.5,6.3C78.5,19.4,75.6,22.2,72,22.2z M72,15.2c-0.2,0-0.5,0.3-0.5,0.7c0,0.4,0.3,0.7,0.5,0.7s0.5-0.3,0.5-0.7C72.5,15.5,72.2,15.2,72,15.2z"/><path class="st0" d="M72,49.9c-3.6,0-6.5-2.8-6.5-6.3s2.9-6.3,6.5-6.3s6.5,2.8,6.5,6.3S75.6,49.9,72,49.9z M72,42.9 c-0.2,0-0.5,0.3-0.5,0.7s0.3,0.7,0.5,0.7s0.5-0.3,0.5-0.7S72.2,42.9,72,42.9z"/><path class="st0" d="M72,80.5c-3.6,0-6.5-2.8-6.5-6.3s2.9-6.3,6.5-6.3s6.5,2.8,6.5,6.3S75.6,80.5,72,80.5z M72,73.5 c-0.2,0-0.5,0.3-0.5,0.7s0.3,0.7,0.5,0.7s0.5-0.3,0.5-0.7S72.2,73.5,72,73.5z"/><path class="st0" d="M57,19.4H18.9c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5H57c1.9,0,3.5,1.6,3.5,3.5S58.9,19.4,57,19.4z"/><path class="st0" d="M57,47.9H18.9c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5H57c1.9,0,3.5,1.6,3.5,3.5S58.9,47.9,57,47.9z"/><path class="st0" d="M57,77.7H18.9c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5H57c1.9,0,3.5,1.6,3.5,3.5S58.9,77.7,57,77.7z"/></g></g></svg>
                                    </i> {{ trans('messages.sending_servers') }}
                                    </a>
                                </li>
                            @endif
                            <li rel1="SendingDomainController">
                                <a href="{{ action('SendingDomainController@index') }}" class="dropdown-item d-flex align-items-center">
                                <i class="navbar-icon" style="width:20	px">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 77.4 77.5" style="enable-background:new 0 0 77.4 77.5;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M38.7,77.4c-10.2,0-20.3-4-27.9-11.9C-4.1,50.1-3.5,25.6,11.9,10.8l0.4-0.4h0.1C27.3-3.3,50.1-3.3,65,10.4 h0.1l0.5,0.5l1,1.1c14.7,15.4,14.2,39.9-1.2,54.7C58,73.9,48.3,77.4,38.7,77.4z M5.8,41.5c1.5,17,15.6,30.2,32.9,30.3 c17.3,0,31.5-13.2,32.9-30.3H5.8z M61.4,35.9h10.3C71,28.8,68.1,22,63.4,16.7c-1.7,1.4-3.5,2.7-5.4,3.8 C60,25.4,61.1,30.6,61.4,35.9z M41.5,35.9h14.2c-0.3-4.5-1.3-8.8-2.9-13c-3.6,1.4-7.5,2.3-11.4,2.6V35.9z M21.7,35.9h14.2V25.5 c-3.9-0.3-7.7-1.2-11.4-2.6C22.9,27.1,22,31.4,21.7,35.9z M5.8,35.9h10.3c0.3-5.3,1.4-10.5,3.4-15.4c-1.9-1.1-3.7-2.3-5.4-3.8 C9.3,22,6.4,28.8,5.8,35.9z M41.5,7.2v12.6c3.1-0.3,6.1-0.9,9-2.1C48.2,13.7,45.1,10.1,41.5,7.2z M27,17.8 c2.9,1.1,5.8,1.8,8.9,2.1V7.2C32.3,10.1,29.3,13.7,27,17.8z M18.2,12.8c1.2,0.9,2.4,1.8,3.7,2.5c1.5-2.7,3.2-5.3,5.3-7.6 C23.9,8.9,20.9,10.6,18.2,12.8z M50.2,7.7c2,2.3,3.8,4.9,5.3,7.6c1.3-0.8,2.5-1.6,3.7-2.5C56.5,10.6,53.5,8.9,50.2,7.7z"/><rect x="22.5" y="51" class="st0" width="6.3" height="7"/><rect x="34.8" y="51" class="st0" width="7.2" height="7"/><rect x="47.5" y="51" class="st0" width="7.4" height="7"/></g></g></svg>
                                    </i> {{ trans('messages.sending_domains') }}
                                </a>
                            </li>
                            <li class="nav-item" rel0="SenderController" {!! Auth::user()->customer->allowSenderVerification() ? '' : 'style="display:none"' !!}>
                                <a href="{{ action('SenderController@index') }}" class="dropdown-item d-flex align-items-center">
                                <i class="navbar-icon" style="width:20	px">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 114.7 98.6" style="enable-background:new 0 0 114.7 98.6;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M59.9,96.5H12.3C5.4,96.5,0,90,0,81.8V14.7C0,6.5,5.4,0,12.3,0h71.2c6.7,0,12.2,6.6,12.2,14.7v22.2 c0,1.9-1.6,3.5-3.5,3.5s-3.5-1.6-3.5-3.5V14.7c0-4.2-2.4-7.7-5.2-7.7H12.3C9.4,7,7,10.5,7,14.7v67.1c0,4.2,2.4,7.7,5.3,7.7h47.6 c1.9,0,3.5,1.6,3.5,3.5S61.8,96.5,59.9,96.5z"/><path class="st0" d="M30.8,43.7c-7.3,0-13.2-5.9-13.2-13.2s5.9-13.2,13.2-13.2c7.3,0,13.2,5.9,13.2,13.2S38.1,43.7,30.8,43.7z M30.8,24.3c-3.4,0-6.2,2.8-6.2,6.2s2.8,6.2,6.2,6.2c3.4,0,6.2-2.8,6.2-6.2S34.2,24.3,30.8,24.3z"/><path class="st0" d="M74.8,32.3H53.7c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5h21.1c1.9,0,3.5,1.6,3.5,3.5S76.7,32.3,74.8,32.3z"/><path class="st0" d="M66.2,43.6H53.7c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5h12.5c1.9,0,3.5,1.6,3.5,3.5S68.1,43.6,66.2,43.6z"/><path class="st0" d="M86.4,98.6c-7.6,0-14.7-2.9-20-8.3c-11-11-11-29,0-40l0,0c5.3-5.3,12.5-8.3,20-8.3c7.6,0,14.7,2.9,20,8.3 c5.3,5.3,8.3,12.5,8.3,20s-2.9,14.7-8.3,20C101.1,95.7,94,98.6,86.4,98.6z M71.3,55.3c-8.3,8.3-8.3,21.8,0,30.1 c4,4,9.4,6.2,15.1,6.2c5.7,0,11-2.2,15.1-6.2s6.2-9.4,6.2-15.1s-2.2-11-6.2-15.1c-4-4-9.4-6.2-15.1-6.2S75.4,51.2,71.3,55.3 L71.3,55.3z"/><path class="st0" d="M82.1,80c-1,0-2-0.4-2.7-1.3l-8.8-10.5c-1.2-1.5-1-3.7,0.4-4.9c1.5-1.2,3.7-1,4.9,0.4l6.7,8l14.8-10.6 c1.6-1.1,3.8-0.8,4.9,0.8s0.8,3.8-0.8,4.9L84.1,79.3C83.5,79.8,82.8,80,82.1,80z"/><path class="st0" d="M12,77.5c-1.9,0-3.5-1.6-3.5-3.5c0-11.6,9.6-29.5,22.4-29.5c13,0,22.4,16.6,22.4,27.8c0,1.9-1.6,3.5-3.5,3.5 s-3.5-1.6-3.5-3.5c0-10.5-8.8-20.8-15.4-20.8c-7.9,0-15.4,14-15.4,22.5C15.5,75.9,13.9,77.5,12,77.5z"/><path class="st0" d="M30.9,77.5c-1.9,0-3.5-1.6-3.5-3.5V56.6c0-1.9,1.6-3.5,3.5-3.5s3.5,1.6,3.5,3.5V74 C34.4,75.9,32.8,77.5,30.9,77.5z"/><polygon class="st0" points="25,58.3 30.9,48 36.9,58.3 "/></g></g></svg>
                                    </i> {{ trans('messages.verified_senders') }}
                                </a>
                            </li>
                            <li class="nav-item" rel0="TrackingDomainController">
                                <a href="{{ action('TrackingDomainController@index') }}" class="dropdown-item d-flex align-items-center">
                                <i class="navbar-icon" style="width:20px">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 77.4 77.5" style="enable-background:new 0 0 77.4 77.5;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M38.7,77.4c-10.2,0-20.3-4-27.9-11.9C-4.1,50.1-3.5,25.6,11.9,10.8l0.4-0.4h0.1C27.3-3.3,50.1-3.3,65,10.4 h0.1l0.5,0.5l1,1.1c14.7,15.4,14.2,39.9-1.2,54.7C58,73.9,48.3,77.4,38.7,77.4z M5.8,41.5c1.5,17,15.6,30.2,32.9,30.3 c17.3,0,31.5-13.2,32.9-30.3H5.8z M61.4,35.9h10.3C71,28.8,68.1,22,63.4,16.7c-1.7,1.4-3.5,2.7-5.4,3.8 C60,25.4,61.1,30.6,61.4,35.9z M41.5,35.9h14.2c-0.3-4.5-1.3-8.8-2.9-13c-3.6,1.4-7.5,2.3-11.4,2.6V35.9z M21.7,35.9h14.2V25.5 c-3.9-0.3-7.7-1.2-11.4-2.6C22.9,27.1,22,31.4,21.7,35.9z M5.8,35.9h10.3c0.3-5.3,1.4-10.5,3.4-15.4c-1.9-1.1-3.7-2.3-5.4-3.8 C9.3,22,6.4,28.8,5.8,35.9z M41.5,7.2v12.6c3.1-0.3,6.1-0.9,9-2.1C48.2,13.7,45.1,10.1,41.5,7.2z M27,17.8 c2.9,1.1,5.8,1.8,8.9,2.1V7.2C32.3,10.1,29.3,13.7,27,17.8z M18.2,12.8c1.2,0.9,2.4,1.8,3.7,2.5c1.5-2.7,3.2-5.3,5.3-7.6 C23.9,8.9,20.9,10.6,18.2,12.8z M50.2,7.7c2,2.3,3.8,4.9,5.3,7.6c1.3-0.8,2.5-1.6,3.7-2.5C56.5,10.6,53.5,8.9,50.2,7.7z"/><rect x="22.5" y="51" class="st0" width="6.3" height="7"/><rect x="34.8" y="51" class="st0" width="7.2" height="7"/><rect x="47.5" y="51" class="st0" width="7.4" height="7"/></g></g></svg>
                                    </i> {{ trans('messages.tracking_domains') }}
                                </a>
                            </li>
                            @if (Auth::user()->customer->can("read", new Acelle\Model\EmailVerificationServer()))
                                <li class="nav-item" rel0="EmailVerificationServerController">
                                    <a href="{{ action('EmailVerificationServerController@index') }}" class="dropdown-item d-flex align-items-center">
                                    <i class="navbar-icon" style="width:20px">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 91.6 90.9" style="enable-background:new 0 0 91.6 90.9;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M83.9,90.9H7.7c-4.2,0-7.7-3.1-7.7-6.8V6.8C0,3.1,3.5,0,7.7,0h76.2c4.2,0,7.7,3.1,7.7,6.8v77.3 C91.6,87.8,88.1,90.9,83.9,90.9z M7,83.7c0.1,0.1,0.4,0.2,0.7,0.2h76.2c0.3,0,0.6-0.1,0.7-0.2V7.2C84.5,7.1,84.2,7,83.9,7H7.7 C7.4,7,7.1,7.1,7,7.2V83.7z"/><path class="st0" d="M85.6,61.6H3.5C1.6,61.6,0,60,0,58.1s1.6-3.5,3.5-3.5h82.1c1.9,0,3.5,1.6,3.5,3.5S87.5,61.6,85.6,61.6z"/><path class="st0" d="M88.1,33.6H3.5C1.6,33.6,0,32,0,30.1s1.6-3.5,3.5-3.5h84.6c1.9,0,3.5,1.6,3.5,3.5S90,33.6,88.1,33.6z"/><path class="st0" d="M72,22.2c-3.6,0-6.5-2.8-6.5-6.3c0-3.5,2.9-6.3,6.5-6.3s6.5,2.8,6.5,6.3C78.5,19.4,75.6,22.2,72,22.2z M72,15.2c-0.2,0-0.5,0.3-0.5,0.7c0,0.4,0.3,0.7,0.5,0.7s0.5-0.3,0.5-0.7C72.5,15.5,72.2,15.2,72,15.2z"/><path class="st0" d="M72,49.9c-3.6,0-6.5-2.8-6.5-6.3s2.9-6.3,6.5-6.3s6.5,2.8,6.5,6.3S75.6,49.9,72,49.9z M72,42.9 c-0.2,0-0.5,0.3-0.5,0.7s0.3,0.7,0.5,0.7s0.5-0.3,0.5-0.7S72.2,42.9,72,42.9z"/><path class="st0" d="M72,80.5c-3.6,0-6.5-2.8-6.5-6.3s2.9-6.3,6.5-6.3s6.5,2.8,6.5,6.3S75.6,80.5,72,80.5z M72,73.5 c-0.2,0-0.5,0.3-0.5,0.7s0.3,0.7,0.5,0.7s0.5-0.3,0.5-0.7S72.2,73.5,72,73.5z"/><path class="st0" d="M57,19.4H18.9c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5H57c1.9,0,3.5,1.6,3.5,3.5S58.9,19.4,57,19.4z"/><path class="st0" d="M57,47.9H18.9c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5H57c1.9,0,3.5,1.6,3.5,3.5S58.9,47.9,57,47.9z"/><path class="st0" d="M57,77.7H18.9c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5H57c1.9,0,3.5,1.6,3.5,3.5S58.9,77.7,57,77.7z"/></g></g></svg>
                                    </i> {{ trans('messages.email_verification_servers') }}
                                    </a>
                                </li>
                            @endif
                            @if (
                                Auth::user()->admin->getPermission("sending_domain_read") != 'no'
                                || Auth::user()->admin->getPermission("sending_server_read") != 'no'
                                || Auth::user()->admin->getPermission("bounce_handler_read") != 'no'
                                || Auth::user()->admin->getPermission("fbl_handler_read") != 'no'
                                || Auth::user()->admin->getPermission("email_verification_server_read") != 'no'
                                || Auth::user()->admin->can('read', new \Acelle\Model\SubAccount())
                            )
                                @if (Auth::user()->admin->can('read', new \Acelle\Model\SubAccount()))
                                    <li class="nav-item" rel0="SubAccountController">
                                        <a href="{{ action('Admin\SubAccountController@index') }}" class="dropdown-item d-flex align-items-center">
                                        <i class="navbar-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 88.3 88.3" style="enable-background:new 0 0 88.3 88.3;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><g><path id="Layer_1-3_1_" class="st0" d="M44.2,1C20.4,0.9,1,20.1,0.9,43.9c0,12.4,5.2,24.1,14.5,32.4l0,0l0.6,0.6l0.4,0.3 c1.8,1.5,3.7,2.8,5.7,4.1l0.5,0.2l3,1.7h0.1c2.3,1,4.6,1.9,7,2.6h0.1l3.6,0.8h0.3l3.5,0.5h8l3.5-0.5H52l3.5-0.8h0.1 c2.4-0.7,4.8-1.6,7.1-2.6l0,0c1.1-0.5,2.1-1.1,3.1-1.7l0.5-0.2l2.6-1.8l0.7-0.5l2.4-1.8l0.3-0.3l0.7-0.6l0,0 c17.7-16,19.2-43.3,3.2-61C68,6.2,56.4,1,44.2,1z M44.2,44.2c-8,0-14.4-6.4-14.4-14.4c0-8,6.4-14.4,14.4-14.4s14.4,6.4,14.4,14.4 S52.2,44.2,44.2,44.2L44.2,44.2z M49.6,47.8c10.9,0,19.8,8.9,19.8,19.8v7.1l-0.3,0.2l-2.2,1.6l-0.4,0.4L64,78.4l-0.5,0.3 c-3.8,2.1-8,3.6-12.3,4.4h-0.3l-3.1,0.4h-7.2L37.2,83c-3.2-0.6-6.4-1.5-9.4-2.9h-0.3c-1.1-0.5-2.1-1.1-3.1-1.7l-2.5-1.5l-0.5-0.4 l-2.2-1.6c-0.1-0.1-0.1-0.2-0.2-0.2v-7.1c0-10.9,8.9-19.8,19.8-19.8h0H49.6z M73,71.3v-3.7c0-11.1-7.8-20.7-18.7-22.9 c4.9-3.4,7.8-8.9,7.9-14.9c0-9.9-8.1-18-18-18s-18,8.1-18,18c0,6,3,11.5,7.9,14.9c-10.9,2.2-18.7,11.8-18.7,22.9v3.7 C0.5,55.4,1.3,30.4,17.2,15.5S58.1,1.3,73,17.2C87.3,32.4,87.3,56.1,73,71.3z"/><path class="st0" d="M48.3,88.1l-8.2,0l-3.9-0.5l-3.8-0.8c-2.4-0.7-4.7-1.6-6.9-2.6h-0.1l-3.2-1.8l-0.6-0.3c-2-1.3-4-2.7-5.8-4.2 l-0.5-0.4L14.7,77C5.3,68.6-0.1,56.6-0.1,43.9C0,19.7,19.8,0,44,0c0.1,0,0.1,0,0.2,0c12.5,0,24.4,5.4,32.7,14.6 C93.2,32.7,91.8,60.7,73.7,77l-1.1,1l-3.1,2.3l-2.8,1.9l-0.4,0.2c-1,0.6-2.1,1.2-3.1,1.7c-2.4,1.1-4.8,1.9-7.3,2.7l-0.3,0 L52,87.6h-0.2L48.3,88.1z M40.3,86.1h7.9l3.8-0.5l3.6-0.8c2.3-0.7,4.6-1.5,6.8-2.5c1-0.5,2-1,3-1.6l0.2-0.1l0.4-0.2l3.2-2.2 l2.6-2l0.8-0.7C89.6,60,91,33.2,75.4,16C67.5,7.1,56.1,2,44.2,2h0c0,0-0.1,0-0.2,0C20.9,2,2,20.8,1.9,44 c0,12.1,5.1,23.6,14.1,31.6l0.6,0.6l0.3,0.3c1.8,1.5,3.6,2.8,5.6,4l0.5,0.2l3,1.7c2.2,1,4.4,1.8,6.8,2.5l0.2,0l3.8,0.8L40.3,86.1 z M47.9,84.5l-7.4,0L37.1,84c-3.3-0.6-6.5-1.5-9.5-2.9h-0.3L27.1,81c-1.1-0.5-2.2-1.1-3.2-1.8l-2.6-1.6l-0.5-0.4l-2.2-1.6H18 v-8.1c0-11.5,9.3-20.8,20.8-20.8h10.8c11.5,0,20.8,9.3,20.8,20.8v7.6l-0.7,0.5l-2.1,1.5L67,77.8l-3,1.8c-4,2.2-8.2,3.7-12.6,4.5 l-0.4,0L47.9,84.5z M40.7,82.5h7.1l3.4-0.4c4.2-0.8,8.2-2.2,11.9-4.3l2.9-1.7l0.4-0.4l2.1-1.5v-6.6c0-10.4-8.4-18.8-18.8-18.8 H38.8C28.4,48.8,20,57.2,20,67.6v6.6l2.5,1.8l2.4,1.5c0.9,0.6,1.9,1.1,2.8,1.6H28l0.2,0.1c2.9,1.3,6,2.3,9.2,2.8L40.7,82.5z M16.4,73.8L14.7,72c-7.4-7.9-11.3-18.2-11-29c0.3-10.8,4.9-20.8,12.8-28.2c16.3-15.3,42-14.5,57.2,1.8 c14.6,15.5,14.6,39.9,0,55.4L72,73.8v-6.2c0-10.6-7.5-19.8-17.9-21.9l-2.3-0.5l1.9-1.3c4.6-3.2,7.4-8.5,7.5-14.1 c0-9.4-7.6-17-17-17c-9.4,0-17,7.6-17,17c0,5.6,2.8,10.9,7.5,14.1l2,1.3l-2.3,0.5C23.9,47.8,16.4,57,16.4,67.6V73.8z M44.2,5.8 c-9.5,0-18.9,3.4-26.3,10.4C10.4,23.2,6,32.8,5.7,43c-0.3,9.4,2.8,18.4,8.7,25.6v-1c0-10.8,7.2-20.4,17.4-23.4 c-4.2-3.6-6.6-8.8-6.6-14.4c0-5.1,2-9.8,5.6-13.4s8.4-5.6,13.4-5.6c10.5,0,19,8.5,19,19c0,5.6-2.5,10.8-6.7,14.4 C66.8,47.3,74,56.8,74,67.6v1c12.1-14.8,11.5-36.6-1.7-50.7C64.7,9.9,54.5,5.8,44.2,5.8z M44.2,45.2c-8.5,0-15.4-6.9-15.4-15.4 s6.9-15.4,15.4-15.4c8.5,0,15.4,6.9,15.4,15.4S52.7,45.2,44.2,45.2z M44.2,16.4c-7.4,0-13.4,6-13.4,13.4c0,7.4,6,13.4,13.4,13.4 c7.4,0,13.4-6,13.4-13.4C57.6,22.4,51.6,16.4,44.2,16.4z"/></g></g></g></svg>
                                </i>{{ trans('messages.sub_accounts') }}
                                        </a>
                                    </li>
                                @endif
                                @if (Auth::user()->admin->getPermission("bounce_handler_read") != 'no')
                                    <li class="nav-item" rel0="BounceHandlerController">
                                        <a href="{{ action('Admin\BounceHandlerController@index') }}" class="dropdown-item d-flex align-items-center">
                                        <i class="navbar-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 104.9 94.5" style="enable-background:new 0 0 104.9 94.5;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M70.9,94.5H14c-7.7,0-14-6.3-14-14c0,0,0-0.1,0-0.2l0-56.8c0-7.7,6.3-14,14-14h28.5c1.9,0,3.5,1.6,3.5,3.5 s-1.6,3.5-3.5,3.5H14c-3.9,0-7,3.1-7,7v56.9c0,4,3.1,7.1,7,7.1h56.9c3.9,0,7-3.2,7-7.1V52.1c0-1.9,1.6-3.5,3.5-3.5 s3.5,1.6,3.5,3.5v28.3c0.1,7.7-6.1,14-13.9,14.1C71,94.5,70.9,94.5,70.9,94.5z"/><path class="st0" d="M43.1,55.6c-0.4,0-0.8-0.1-1.2-0.2c-1.8-0.7-2.8-2.7-2.1-4.5c3.1-8.5,10.8-24,28.1-33 c1.7-0.9,3.8-0.2,4.7,1.5c0.9,1.7,0.2,3.8-1.5,4.7c-15.7,8.2-22.5,23.1-24.7,29.2C45.9,54.7,44.5,55.6,43.1,55.6z"/><polygon class="st0" points="67.5,48.6 104.9,16.1 58,0 "/></g></g></svg>
                                </i>{{ trans('messages.bounce_handlers') }}
                                        </a>
                                    </li>
                                @endif
                                @if (Auth::user()->admin->getPermission("fbl_handler_read") != 'no')
                                    <li class="nav-item" rel0="FeedbackLoopHandlerController">
                                        <a href="{{ action('Admin\FeedbackLoopHandlerController@index') }}" class="dropdown-item d-flex align-items-center">
                                        <i class="navbar-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 111.9 86.9" style="enable-background:new 0 0 111.9 86.9;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M93.4,46.2c-2.8,0-5-2.2-5-5V17.5c0-4.1-3.3-7.5-7.4-7.5H18.4c-2.8,0-5-2.2-5-5s2.2-5,5-5H81 c9.6,0.1,17.4,7.9,17.4,17.5v23.7C98.4,44,96.2,46.2,93.4,46.2z"/><polygon class="st0" points="75,35.8 93.4,67.8 111.9,35.8 "/><path class="st0" d="M93.4,86.9H30.9c-9.6,0-17.5-7.9-17.5-17.5v-24c0-2.8,2.2-5,5-5s5,2.2,5,5v24c0,4.1,3.4,7.5,7.5,7.5h62.5 c2.8,0,5,2.2,5,5S96.2,86.9,93.4,86.9z"/><polygon class="st0" points="36.9,50.8 18.4,18.9 0,50.8 "/></g></g></svg>
                                </i>{{ trans('messages.feedback_loop_handlers') }}
                                        </a>
                                    </li>
                                @endif
                                @if (Auth::user()->admin->getPermission("email_verification_server_read") != 'no')
                                    <li class="nav-item" rel0="EmailVerificationServerController">
                                        <a href="{{ action('Admin\EmailVerificationServerController@index') }}" class="dropdown-item d-flex align-items-center">
                                        <i class="navbar-icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 107.6 90.9" style="enable-background:new 0 0 107.6 90.9;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M32.7,90.9h-25c-4.2,0-7.7-3.1-7.7-6.8V6.8C0,3.1,3.5,0,7.7,0h76.2c4.2,0,7.7,3.1,7.7,6.8v23.3 c0,1.9-1.6,3.5-3.5,3.5s-3.5-1.6-3.5-3.5V7.2C84.5,7.1,84.2,7,83.9,7H7.7C7.4,7,7.1,7.1,7,7.2v76.6c0.1,0.1,0.4,0.2,0.7,0.2h21.5 v-9.7c0-1.9,1.6-3.5,3.5-3.5s3.5,1.6,3.5,3.5v13.2C36.2,89.3,34.6,90.9,32.7,90.9z"/><path class="st0" d="M32.7,61.6H3.5C1.6,61.6,0,60,0,58.1s1.6-3.5,3.5-3.5h29.2c1.9,0,3.5,1.6,3.5,3.5S34.6,61.6,32.7,61.6z"/><path class="st0" d="M88.1,33.6H3.5C1.6,33.6,0,32,0,30.1s1.6-3.5,3.5-3.5h84.6c1.9,0,3.5,1.6,3.5,3.5S90,33.6,88.1,33.6z"/><path class="st0" d="M72,22.2c-3.6,0-6.5-2.8-6.5-6.3c0-3.5,2.9-6.3,6.5-6.3s6.5,2.8,6.5,6.3C78.5,19.4,75.6,22.2,72,22.2z M72,15.2c-0.2,0-0.5,0.3-0.5,0.7c0,0.4,0.3,0.7,0.5,0.7s0.5-0.3,0.5-0.7C72.5,15.5,72.2,15.2,72,15.2z"/><path class="st0" d="M57,19.4H18.9c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5H57c1.9,0,3.5,1.6,3.5,3.5S58.9,19.4,57,19.4z"/><path class="st0" d="M55.5,47.9H18.9c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5h36.6c1.9,0,3.5,1.6,3.5,3.5S57.4,47.9,55.5,47.9z"/><path class="st0" d="M32.7,77.7H18.9c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5h13.8c1.9,0,3.5,1.6,3.5,3.5S34.6,77.7,32.7,77.7z"/><path class="st0" d="M63,84.7c-1,0-1.9-0.4-2.6-1.2l-19-21.8c-1.3-1.5-1.1-3.7,0.3-4.9c1.5-1.3,3.7-1.1,4.9,0.3l16.7,19.2 l38.5-32.2c1.5-1.2,3.7-1,4.9,0.4c1.2,1.5,1,3.7-0.4,4.9L65.2,83.9C64.6,84.4,63.8,84.7,63,84.7z"/></g></g></svg>
                                </i>{{ trans('messages.email_verification_servers') }}
                                        </a>
                                    </li>
                                @endif	
                            @endif
                        </ul>
                    </li>
                @endif
                <li class="nav-item dropdown language-switch"
					rel0="TemplateController"
					rel1="LayoutController"
					rel2="LanguageController"
					rel3="SettingController"
					rel4="PaymentController"
					rel5="PluginController"
				>
					<a role="button" class="nav-link lvl-1 dropdown-toggle d-flex align-items-center" data-bs-toggle="dropdown">
					<i class="navbar-icon">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 92.2 91.4"><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Layer_2-2" data-name="Layer 2"><g id="Layer_1-2-2" data-name="Layer 1-2"><path d="M88,36.7H80.9a5.5,5.5,0,0,1-5.3-5.5A5.4,5.4,0,0,1,77,27.6h.1l.9-.9.3-.2h-.1l3.9-3.9c1.1-1,.9-2.8-.5-4.2l-8-7.9c-1.4-1.4-3.2-1.6-4.3-.6l-3.9,3.9h0l-.5.5-.6.7h0a5.5,5.5,0,0,1-3.7,1.4,5.4,5.4,0,0,1-5.5-5.2h0V9.6h0V4.1c0-1.5-1.4-2.6-3.4-2.6H40.4C38.5,1.5,37,2.6,37,4.1V9.6h0v1.6h.1a6,6,0,0,1-1.6,3.6,5.8,5.8,0,0,1-7.7.2h.1l-1-.9-.2-.3h0L22.8,10,22,9.3h-.9a3.3,3.3,0,0,0-2.5,1.2l-8,7.9C9.2,19.8,9,21.6,10,22.6l3.9,3.9h0l.6.4.6.7h0a5.6,5.6,0,0,1,1.5,3.7,5.4,5.4,0,0,1-5.3,5.5H4.1c-1.5,0-2.6,1.4-2.6,3.3V51.3c0,2,1.1,3.4,2.6,3.4h7.2a6.2,6.2,0,0,1,3.6,1.6,5.7,5.7,0,0,1,.2,7.6h0l-.9.9-.3.2h0L10,68.8l-.7.8v.9A3.4,3.4,0,0,0,10.6,73l7.9,8a4.2,4.2,0,0,0,2.6,1.2,2.8,2.8,0,0,0,1.7-.7l3.9-3.9h.1c.1-.3.3-.4.4-.6l.7-.6h-.1A5.5,5.5,0,0,1,31.5,75a5.7,5.7,0,0,1,5.6,5.2H37v1.7h0v5.4c0,1.5,1.5,2.6,3.4,2.6H51.7c2,0,3.4-1.1,3.4-2.6V81.9h.1a1.7,1.7,0,0,1-.1-.7v-.9h0a4.8,4.8,0,0,1,1.6-3.6,5.9,5.9,0,0,1,7.6-.2h0l.9.8.2.3h.1l3.9,3.9a2.3,2.3,0,0,0,1.6.6,3.7,3.7,0,0,0,2.6-1.2l8-7.9a3.7,3.7,0,0,0,1.2-2.6v-1l-4.5-4.5h.1l-.6-.5-.6-.6H77a5.5,5.5,0,0,1,.4-7.8,5,5,0,0,1,3.5-1.4H88c1.6,0,2.7-1.4,2.7-3.4V40.1C90.6,38.2,89.5,36.7,88,36.7ZM86.7,50.8H83.1a6.2,6.2,0,0,0-1.9-.2,9.6,9.6,0,0,0-9.7,9.3,9.7,9.7,0,0,0,4.4,8.2h0l2.5,2.4-7.2,7.2-2.4-2.3v-.3l-1.2-1.4a9.8,9.8,0,0,0-13.7,0,9.2,9.2,0,0,0-2.6,8.6h0V86H41V82.5a12.3,12.3,0,0,0,.2-1.9,9.6,9.6,0,0,0-9.9-9.5,9.5,9.5,0,0,0-7.8,4.2h0L21,77.8l-7.3-7.2,2.4-2.3.2-.2a5.7,5.7,0,0,0,1.5-1.2A9.4,9.4,0,0,0,18,53.6l-.2-.2A9.5,9.5,0,0,0,9,50.8H5.4V40.6H9l1.9.2a9.6,9.6,0,0,0,5.4-17.6h-.1l-2.5-2.5L21,13.6,23.3,16l.2.2a5.7,5.7,0,0,0,1.2,1.5A9.7,9.7,0,0,0,41,9h0V5.4H51.2V9a6.2,6.2,0,0,0-.2,1.9,9.6,9.6,0,0,0,9.9,9.5,9.5,9.5,0,0,0,7.8-4.2h0l2.5-2.5,7.2,7.2-2.3,2.3-.2.2a4.4,4.4,0,0,0-1.5,1.2A9.6,9.6,0,0,0,81.2,41l1.9-.2h3.6Z" style="fill:#f2f2f2"/><path d="M51.7,91.4H40.4c-2.8,0-4.9-1.8-4.9-4.1V79.6a4.1,4.1,0,0,0-4-3.1,4.6,4.6,0,0,0-2,.5l-1.2,1c0,.1-.1.1-.1.2l-.3.9h-.6l-3.4,3.5a4.3,4.3,0,0,1-2.8,1.1h-.2a5.4,5.4,0,0,1-3.4-1.6l-7.9-8a5.2,5.2,0,0,1-1.8-3.5h0V69L9,67.7l5-4.9a4,4,0,0,0-.2-5.5,4.4,4.4,0,0,0-2.6-1.1H4.1C1.7,56.2,0,54.1,0,51.3V40.1c0-2.7,1.8-4.8,4.1-4.8h7.2a4,4,0,0,0,3.8-4A4,4,0,0,0,14,28.6l-.5-.6-.7-.4L8.9,23.7c-1.6-1.7-1.3-4.4.6-6.4l8-7.8A5.3,5.3,0,0,1,21,7.8h1.6l1.2,1.1,5.5,5.3a4.4,4.4,0,0,0,5.2-.5,4.4,4.4,0,0,0,1-1.9V4.1c0-2.3,2.1-4.1,4.9-4.1H51.7c2.8,0,4.9,1.7,4.9,4.1v7.1a4,4,0,0,0,4,3.7,3.5,3.5,0,0,0,2.6-1l.6-.7,4.4-4.4c1.8-1.6,4.5-1.3,6.5.6l8,7.9a5.9,5.9,0,0,1,1.6,3.8,3.4,3.4,0,0,1-1.2,2.6L81.8,25h1.3L79,27.9l-1.2,1.2a3.1,3.1,0,0,0-.7,2.1,3.9,3.9,0,0,0,3.9,4h7c2.3,0,4,2,4.2,4.8V51.2c0,2.8-1.8,4.9-4.2,4.9H80.9a3.9,3.9,0,0,0-2.5,1,4.1,4.1,0,0,0-.7,5.2h.1l1,1,3.7,3.1h-.6l2.4,2.4v1.6a5.2,5.2,0,0,1-1.7,3.7L74.7,82a5.4,5.4,0,0,1-3.6,1.6,3.6,3.6,0,0,1-2.7-1l-3.5-3.5h-.2l-.6-.8-.8-.7a4.4,4.4,0,0,0-5.6.2,3.6,3.6,0,0,0-1.1,2.5v1h0l.8,2.1h-.8v3.9C56.6,89.7,54.5,91.4,51.7,91.4ZM38.5,81.7v5.6c0,.6.9,1.1,1.9,1.1H51.7c.9,0,1.9-.4,1.9-1.1v-7a6.8,6.8,0,0,1,2.1-4.7,7.4,7.4,0,0,1,9.6-.3l1.3,1.2,3.9,3.9.5.2a2.3,2.3,0,0,0,1.5-.7l8-8a2.1,2.1,0,0,0,.8-1.6V70l-4.7-4.7h-.3l-.4-.5-.7-.9-.5-.5h.2a6.9,6.9,0,0,1,1.5-8.5,7.2,7.2,0,0,1,4.5-1.8H88c.9,0,1.2-1,1.2-1.9V40.1c-.1-1-.6-1.9-1.2-1.9H80.9a7.2,7.2,0,0,1-4.7-2,7.3,7.3,0,0,1-2.1-5,7.2,7.2,0,0,1,.8-3.2h-.2l.6-.6.6-.8.4-.5h.2L81,21.5a.5.5,0,0,0,.3-.5,2.2,2.2,0,0,0-.8-1.5l-8-7.9c-.7-.8-1.7-1.1-2.2-.6L66,15.3l-.7.8a6.7,6.7,0,0,1-4.7,1.8h-.1a6.9,6.9,0,0,1-6.9-6.6V4.1c0-.7-1-1.1-1.9-1.1H40.4c-1,0-1.9.5-1.9,1.1V9.7h.2v1.6a6.9,6.9,0,0,1-2,4.5,7.3,7.3,0,0,1-9.8.3l-3.1-2.6h.5l-2.8-2.7h-.3a2.1,2.1,0,0,0-1.4.7h0l-8,7.9a1.9,1.9,0,0,0-.8,1.3.8.8,0,0,0,.2.7l3.8,3.8.6.5.7.8a6.8,6.8,0,0,1,1.9,4.7,7,7,0,0,1-6.7,7H4.1c-.6,0-1.1.8-1.1,1.8V51.3c0,.9.4,1.9,1.1,1.9h7.3a8.1,8.1,0,0,1,4.5,2,7.1,7.1,0,0,1,.3,9.7l-1.4,1.3-4,4v.2a1.8,1.8,0,0,0,.8,1.4h.1l7.9,8a2.8,2.8,0,0,0,1.5.8.9.9,0,0,0,.7-.3l2.5-2.5h-.4l2.9-2.6a6.9,6.9,0,0,1,4.7-1.8h0a7.2,7.2,0,0,1,7.1,6.6v1.6Zm14.3,5.8H39.5V82.2a8.8,8.8,0,0,0,.2-1.7,7.7,7.7,0,0,0-2.5-5.6,8.6,8.6,0,0,0-5.9-2.3,8.3,8.3,0,0,0-6.6,3.5v.3L21,79.9l-9.5-9.3,4-3.8a3.8,3.8,0,0,0,1.2-.9,8.1,8.1,0,0,0,2.5-5.6,7.9,7.9,0,0,0-2.3-5.6v-.2a8.1,8.1,0,0,0-7.5-2.2H3.9V39.1H9.2l1.8.2h0a8,8,0,0,0,8.1-8,8.1,8.1,0,0,0-3.3-6.6h-.1l-.6-.4-3.5-3.6L21,11.5l3.8,3.9a3.8,3.8,0,0,0,.9,1.2,8.3,8.3,0,0,0,11.5,0,7.9,7.9,0,0,0,2.3-7.3V3.9H52.7V9.4a6.6,6.6,0,0,0-.1,1.4A7.8,7.8,0,0,0,55,16.6a8.1,8.1,0,0,0,5.7,2.3h.2a8.3,8.3,0,0,0,6.6-3.5v-.3l3.6-3.5,9.3,9.3-3.7,3.7h-.2a2.7,2.7,0,0,0-1,.8v.2a7.6,7.6,0,0,0-2.4,5.7,8.1,8.1,0,0,0,2.3,5.7,8.2,8.2,0,0,0,5.7,2.4l2-.2h5.1v13h-7A8,8,0,0,0,73,59.9a8.2,8.2,0,0,0,3.7,6.9l.2.2,3.6,3.5-9.3,9.3L67.3,76v-.3l-.8-1a8.4,8.4,0,0,0-11.6.1A7.6,7.6,0,0,0,52.8,82v5.5Zm-10.3-3h7.3v-2a10.7,10.7,0,0,1,3.1-9.9,11.4,11.4,0,0,1,15.7,0h.1l1.6,1.8v.3l.9.8,5.1-5.1L75,69.3a11.2,11.2,0,0,1-5-9.4A11,11,0,0,1,81,49.1h.2a7.5,7.5,0,0,1,2.1.2h1.9v-7h-2l-2,.2h0a11.1,11.1,0,0,1-7.9-3.3,11,11,0,0,1-3.2-7.8,10.8,10.8,0,0,1,3.2-7.8A4.6,4.6,0,0,1,75,22.2l1.3-1.3-5.1-5.1-1.3,1.4a11.4,11.4,0,0,1-9,4.7,10.9,10.9,0,0,1-8-3.1,11.7,11.7,0,0,1-3.4-7.9,7.5,7.5,0,0,1,.2-2.1V6.9H42.5v2a11.3,11.3,0,0,1-3.1,9.9,11.5,11.5,0,0,1-15.8,0,10.9,10.9,0,0,1-1.3-1.7L21,15.7l-5.2,5L17.1,22a10.8,10.8,0,0,1,5,9.3,11.1,11.1,0,0,1-11.2,11h-.2l-1.8-.2h-2v7.2H8.8a11.4,11.4,0,0,1,10.1,3c0,.1.1.2.2.3a11.1,11.1,0,0,1,3.1,7.7A11.2,11.2,0,0,1,18.8,68a7,7,0,0,1-1.6,1.3l-1.3,1.3L21,75.7l1.3-1.4a11.4,11.4,0,0,1,9-4.7,11.1,11.1,0,0,1,8,3.1,11.7,11.7,0,0,1,3.4,7.9,12.3,12.3,0,0,1-.2,2Z" style="fill:#f2f2f2"/><path d="M46.1,59.8A14.1,14.1,0,1,1,60.2,45.7,14.1,14.1,0,0,1,46.1,59.8Zm0-21.2a7.1,7.1,0,1,0,7.1,7.1A7.1,7.1,0,0,0,46.1,38.6Z" style="fill:lime"/></g></g></g></g></svg>
							</i>
							<span>{{ trans('messages.setting') }}</span>
                        <span class="caret"></span>
					</a>
                    <ul class="dropdown-menu dropdown-menu-bottom">
						@if (
							Auth::user()->admin->getPermission("setting_general") != 'no' ||
							Auth::user()->admin->getPermission("setting_sending") != 'no' ||
							Auth::user()->admin->getPermission("setting_system_urls") != 'no' ||
							Auth::user()->admin->getPermission("setting_background_job") != 'no'
						)
							<li class="nav-item" rel0="SettingController">
								<a href="{{ action('Admin\SettingController@index') }}" class="dropdown-item d-flex align-items-center">
								<i class="navbar-icon">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 108.7 117.5" style="enable-background:new 0 0 108.7 117.5;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><g><path class="st0" d="M63,42.3C71.4,47,74.3,57.6,69.6,66s-15.3,11.3-23.7,6.6c-8-4.5-11.1-14.5-7.1-22.8 c2.6-5.3,7.7-8.9,13.5-9.6c1.2,0.1,2.1,1.1,2.1,2.3c-0.1,0.9-0.7,1.7-1.6,2c-4.3,0.6-8.1,3.3-10.1,7.2 c-3.2,6.4-0.5,14.2,5.9,17.4c6.4,3.2,14.2,0.5,17.4-5.9c3.2-6.4,0.5-14.2-5.9-17.4c0,0,0,0,0,0c-0.9-0.4-1.4-1.5-1.2-2.5 c-0.2-0.3-0.3-0.7-0.3-1.1V5.9h-8.5v14.9l-1.8,0.3c-9.2,1.5-17.4,6.5-23,13.9l-1.2,1.5l-13.5-7.8L6.3,36l13.9,8l-0.5,1.7 c-1.2,3.6-1.8,7.4-1.8,11.2c0,4.8,1,9.6,2.8,14.1l0.8,1.8L6.3,81.5l4.3,7.4l15.5-9l1.2,1.4c5.5,6.1,12.9,10.1,21,11.5l1.8,0.3 v18.5h8.5V93.1l1.8-0.3c8.1-1.4,15.5-5.4,21.1-11.5l1.2-1.4l15.5,9l4.2-7.4l-15.2-8.7L88,71c1.8-4.5,2.8-9.3,2.8-14.1 c0-3.8-0.6-7.6-1.8-11.2L88.5,44l13.9-8l-4.2-7.3l-13.6,7.8L83.4,35c-3.6-4.8-8.3-8.6-13.7-11.1c-1.1-0.6-1.5-1.9-0.9-3 c0.5-0.9,1.7-1.4,2.7-1c5.5,2.6,10.3,6.3,14.2,10.9l11.2-6.5c1.6-0.9,3.6-0.4,4.5,1.2l5.4,9.2c0.9,1.6,0.4,3.6-1.2,4.6l-11.8,6.8 c0.9,3.5,1.4,7.2,1.4,10.8c0,4.8-0.8,9.5-2.4,14l12.8,7.4c1.6,0.9,2.1,2.9,1.2,4.5l-5.4,9.2c-0.9,1.6-2.9,2.1-4.5,1.2l-13.4-7.7 c-5.6,5.7-12.7,9.6-20.5,11.3v15.9c0,1.8-1.5,3.3-3.3,3.3c0,0,0,0,0,0H49c-1.8,0-3.3-1.5-3.3-3.3l0,0V96.8 c-7.8-1.7-14.9-5.6-20.5-11.3l-13.4,7.7c-1.6,0.9-3.6,0.4-4.5-1.2l-5.4-9.2c-0.9-1.6-0.3-3.6,1.3-4.5c0,0,0,0,0,0L16,70.9 c-1.7-4.5-2.5-9.2-2.5-14c0-3.7,0.5-7.3,1.5-10.8L3.2,39.3c-1.6-0.9-2.2-3-1.3-4.6l5.4-9.2c0.9-1.6,2.9-2.1,4.5-1.2L23,30.8 c5.8-7,13.8-11.8,22.7-13.7V4.8c0-1.8,1.5-3.3,3.3-3.3h10.7C61.5,1.5,63,3,63,4.8V42.3L63,42.3z"/><path class="st0" d="M59.7,117.5H49c-2.6,0-4.8-2.2-4.8-4.8V98c-7.3-1.8-13.9-5.4-19.2-10.6l-12.4,7.1C10.3,95.8,7.3,95,6,92.8 l-5.4-9.2c-1.3-2.3-0.5-5.3,1.8-6.6l11.7-6.8c-1.5-4.3-2.2-8.8-2.2-13.3c0-3.4,0.4-6.8,1.3-10.1L2.5,40.6 c-2.3-1.3-3.2-4.3-1.9-6.6L6,24.7c1.3-2.3,4.3-3.1,6.5-1.7l10.1,5.9c5.7-6.4,13.2-10.9,21.5-13V4.8C44.2,2.2,46.4,0,49,0h10.7 c2.6,0,4.8,2.2,4.8,4.8v36.6c8.5,5.3,11.4,16.5,6.4,25.3c-5.1,9.1-16.7,12.3-25.8,7.1c-8.7-4.9-12.1-15.8-7.7-24.8 c2.8-5.8,8.3-9.7,14.7-10.4l0.1,0l0.1,0c1,0.1,1.9,0.5,2.5,1.2c0.7,0.7,1,1.7,0.9,2.7c-0.1,1.5-1.1,2.9-2.6,3.3L53,46 c-3.9,0.5-7.2,2.9-9,6.4C41.2,58,43.6,65,49.3,67.8c5.7,2.8,12.6,0.5,15.4-5.2c2.8-5.7,0.5-12.6-5.2-15.4 c-1.4-0.7-2.2-2.1-2.1-3.6c-0.2-0.4-0.3-0.9-0.2-1.4V7.4h-5.5v14.7l-3.1,0.5c-8.8,1.4-16.7,6.2-22,13.3l-2,2.5l-13.3-7.7 l-2.8,4.7L22,43.3l-0.8,2.8c-1.2,3.5-1.7,7.1-1.7,10.8c0,4.7,0.9,9.2,2.7,13.5l1.3,3L8.4,82.1l2.8,4.8L26.4,78l2,2.3 c5.2,5.8,12.4,9.7,20.1,11l3,0.5v18.3h5.5V91.8l3.1-0.5c7.7-1.3,14.9-5.2,20.2-11l2-2.3l15.3,8.9l2.7-4.8l-15.1-8.6l1.3-3 c1.8-4.3,2.7-8.8,2.7-13.5c0-3.6-0.6-7.3-1.7-10.7l-0.8-2.9l13.6-7.8l-2.7-4.7l-13.4,7.7l-2-2.5c-3.4-4.6-8-8.3-13.2-10.7l-0.1,0 c-0.9-0.5-1.5-1.3-1.8-2.2c-0.3-0.9-0.2-1.9,0.3-2.8c0.9-1.6,2.8-2.3,4.5-1.7l0.1,0.1c5.3,2.5,10,6,13.9,10.3L96.1,23 c2.3-1.3,5.2-0.5,6.5,1.7l5.4,9.2c1.3,2.3,0.5,5.3-1.7,6.6l-10.8,6.3c0.8,3.3,1.2,6.7,1.2,10.1c0,4.5-0.7,9-2.1,13.3l11.7,6.8 c2.3,1.3,3.1,4.3,1.7,6.5l-5.4,9.2c-1.3,2.3-4.3,3.1-6.5,1.7l-12.4-7.1c-5.4,5.2-12,8.8-19.2,10.6v14.7 C64.5,115.3,62.3,117.5,59.7,117.5z M25.5,83.6l0.8,0.8c5.4,5.5,12.2,9.3,19.7,10.9l1.2,0.3v17.1c0,1,0.8,1.8,1.8,1.8h10.7 c1,0,1.8-0.8,1.8-1.8V95.6l1.2-0.3c7.5-1.6,14.4-5.4,19.7-10.9l0.8-0.8l14.4,8.3c0.9,0.5,2,0.2,2.5-0.7l5.4-9.2 c0.5-0.8,0.2-1.9-0.7-2.4l-13.9-8l0.4-1.2c1.6-4.3,2.3-8.9,2.3-13.5c0-3.5-0.5-7-1.4-10.4l-0.3-1.1l12.8-7.4 c0.9-0.5,1.2-1.7,0.6-2.6l-5.4-9.2c-0.5-0.9-1.6-1.2-2.5-0.7l-12.3,7.1l-0.8-1c-3.8-4.5-8.3-8-13.6-10.5 c-0.3-0.1-0.6,0.1-0.8,0.3c-0.2,0.3-0.1,0.7,0.2,0.9c5.6,2.6,10.5,6.6,14.2,11.5l0.4,0.5l13.8-7.9l5.7,9.9l-14.2,8.2l0.2,0.6 c1.2,3.7,1.9,7.7,1.9,11.6c0,5.1-1,10-2.9,14.7l-0.3,0.6l15.3,8.8l-5.7,10L83,81.8l-0.4,0.5c-5.8,6.3-13.6,10.6-22,12l-0.6,0.1 v18.7H48.6V94.4l-0.5-0.1c-8.4-1.4-16.1-5.7-21.9-12l-0.4-0.5L10.1,91l-5.8-10l15.3-8.8l-0.2-0.6c-1.9-4.7-2.9-9.7-2.9-14.7 c0-4,0.6-7.9,1.9-11.7l0.2-0.5L4.2,36.5l5.8-9.9l13.7,7.9l0.4-0.5c5.8-7.7,14.3-12.9,23.9-14.4l0.5-0.1V4.4h11.5v37.8 c0,0.1,0,0.2,0.1,0.3l0.3,0.5l-0.1,0.6c-0.1,0.3,0.1,0.7,0.4,0.8c7.2,3.6,10.2,12.3,6.6,19.4c-1.7,3.5-4.7,6.1-8.4,7.3 c-3.7,1.2-7.6,1-11.1-0.7c-7.2-3.5-10.1-12.3-6.6-19.4c2.2-4.3,6.3-7.3,11.1-8c0.2-0.1,0.4-0.3,0.4-0.6c0-0.3-0.1-0.4-0.2-0.5 c-0.1-0.1-0.2-0.2-0.4-0.2c-5.3,0.7-9.8,3.9-12.2,8.7c-3.7,7.5-0.9,16.7,6.5,20.8c7.6,4.3,17.4,1.6,21.7-6 c4.3-7.6,1.6-17.4-6-21.7l-0.8-0.4V4.8c0-1-0.8-1.8-1.8-1.8H49c-1,0-1.8,0.8-1.8,1.8v13.5L46,18.6c-8.5,1.8-16.3,6.5-21.9,13.2 l-0.8,1L11,25.6c-0.9-0.5-2-0.2-2.5,0.7l-5.4,9.2c-0.5,0.9-0.2,2,0.7,2.5l12.8,7.4l-0.3,1.1c-1,3.4-1.4,6.9-1.4,10.4 c0,4.6,0.8,9.2,2.4,13.5l0.5,1.2L4,79.6c-0.9,0.5-1.2,1.6-0.7,2.5l5.4,9.2c0.5,0.9,1.6,1.2,2.5,0.7L25.5,83.6z"/></g></g></g></svg>
							</i>{{ trans('messages.all_settings') }}
								</a>
							</li>
						@endif
                        @if (
                            Auth::user()->admin->getPermission("admin_read") != 'no'
                            || Auth::user()->admin->getPermission("admin_group_read") != 'no'
                        )
                            @if (Auth::user()->admin->getPermission("admin_read") != 'no')
                                <li class="nav-item" rel0="Admin2Controller">
                                    <a href="{{ action('Admin\Admin2Controller@index') }}" class="dropdown-item d-flex align-items-center">
                                    <i class="navbar-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 108.3 94.5" style="enable-background:new 0 0 108.3 94.5;" xml:space="preserve"><style type="text/css">.st0{opacity:0.66;}.st1{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><g class="st0"><g><path class="st1" d="M107.7,75.8c-0.6-4.1-3.5-10.9-6.7-15.5C96,52.9,89,47,80.8,43.4l-1.9-0.9l1.2-1.2 c3.5-3.4,5.9-7.7,7.1-12.4c0.8-3.3,0.9-6.8,0.2-10.1c-1.8-8-7.2-14.8-14.7-18.2v6.3c3.1,1.8,5.6,4.4,7.1,7.6 c2.3,4.6,2.8,9.9,1.3,14.9c-1.3,4.5-4.3,8.3-8.4,10.7v6.7l2.3,0.7c11.7,3.7,21,12.6,25.3,24.1c1.8,4.8,2,7.1,0.9,9.5 c-0.9,1.7-2.3,3.1-4,4.1v6.1c0.9-0.2,1.8-0.5,2.6-1c1.5-0.7,2.8-1.6,3.9-2.8C106.8,84.4,108.3,80.1,107.7,75.8z"/><path class="st1" d="M97.2,91.8c-0.1,0-0.2,0-0.3-0.1c-0.1-0.1-0.2-0.2-0.2-0.4v-6.1c0-0.2,0.1-0.3,0.3-0.4 c1.6-0.9,2.9-2.3,3.8-3.9c1-2.2,0.8-4.5-0.9-9.1c-4.3-11.4-13.4-20.1-25-23.8l-2.3-0.7c-0.2-0.1-0.4-0.3-0.4-0.5v-6.7 c0-0.2,0.1-0.3,0.2-0.4c4-2.3,6.9-6,8.2-10.4c1.5-4.9,1-10-1.3-14.5c-1.5-3.1-3.9-5.7-6.9-7.4c-0.2-0.1-0.3-0.3-0.3-0.4V0.6 c0-0.2,0.1-0.3,0.2-0.4c0.1-0.1,0.3-0.1,0.5,0c7.6,3.5,13.2,10.4,15,18.5c0.7,3.4,0.6,7-0.2,10.3c-1.2,4.8-3.7,9.2-7.2,12.6 l-0.7,0.7l1.3,0.6c8.3,3.6,15.3,9.6,20.4,17.1c3.2,4.6,6.2,11.5,6.8,15.7c0,0,0,0,0,0c0.6,4.4-1,9-4.1,12.1 c-1.1,1.2-2.5,2.2-4,2.9C99.2,91.3,98.3,91.6,97.2,91.8C97.3,91.8,97.2,91.8,97.2,91.8z M97.7,85.5v5.2c0.6-0.2,1.3-0.4,1.8-0.8 c1.5-0.7,2.7-1.6,3.8-2.7c3-2.9,4.4-7.2,3.9-11.3c-0.6-4.1-3.5-10.8-6.6-15.3c-5-7.4-11.9-13.1-20-16.7L78.7,43 c-0.1-0.1-0.3-0.2-0.3-0.4c0-0.2,0-0.3,0.1-0.4l1.2-1.2c3.4-3.3,5.8-7.5,7-12.2c0.8-3.2,0.9-6.6,0.2-9.9 c-1.7-7.6-6.8-14.1-13.7-17.5v5.2c3.1,1.8,5.5,4.5,7.1,7.7c2.4,4.7,2.9,10.2,1.3,15.3c-1.3,4.6-4.3,8.4-8.4,10.8v6l1.9,0.6 c11.9,3.8,21.3,12.7,25.6,24.4c1.8,4.9,2.1,7.3,0.9,9.9C100.7,83,99.4,84.5,97.7,85.5z"/></g></g><g><path class="st1" d="M43.2,0.6C33.1,1.9,24.7,8.9,21.5,18.5c-2.3,7.1-1.1,14.9,3.2,21.1c0.9,1.2,1.9,2.3,2.9,3.4 c0.6,0.6,1.2,1.3,1.6,2c-0.6,0-6.3,2.9-8.5,4.3c-4.2,2.8-8,6.3-11.2,10.2C5.7,64.4,2.8,69.9,1,75.8c-0.6,2.5-0.7,5.2-0.1,7.7 c1.3,5,5.3,8.9,10.3,10.2C12.5,94,14.3,94,46,94c37.3,0,34.3,0.1,37.5-1.4c5.5-2.6,8.6-8.5,7.8-14.5c-0.6-4.1-3.5-10.9-6.6-15.5 c-5-7.4-12-13.3-20.2-16.9l-2-0.9l1.3-1.2c3.5-3.4,5.9-7.7,7.1-12.4c0.7-3.3,0.8-6.8,0.2-10.1c-2.3-10.2-10.3-18-20.5-20.2 C48.2,0.5,45.7,0.4,43.2,0.6z M51.7,7.2c5.1,1.3,9.4,4.8,11.7,9.6c2.4,4.6,2.8,10,1.3,14.9c-1.5,5.2-5.2,9.4-10.1,11.6 c-6.1,2.8-13.2,2.4-19.1-0.9c-2.1-1.4-4-3.2-5.6-5.2c-3.8-5.4-4.6-12.4-2.3-18.6c2-5.3,6.2-9.4,11.6-11.1c2.3-0.9,3.8-1,7.3-1 C48.3,6.4,50,6.7,51.7,7.2z M37.2,49.4c0.5,0.2,0.9,0.4,1.2,0.8c0,0.4-5.4,23.5-5.5,23.7s10.9,8,12.5,9s13-8.6,12.9-8.9 s-1.2-5.4-2.7-11.8S53,50.5,53,50.4s0.7-0.6,1.5-0.9l1.6-0.6l2.6,0.9c11.6,3.7,21,12.6,25.3,24c1.8,4.8,2,7.2,0.8,9.6 c-1,1.9-2.5,3.4-4.4,4.3l-1.3,0.5H46.9c-22,0.1-32.7,0-33.7-0.1c-0.9-0.2-1.7-0.5-2.5-0.8c-1.5-1-2.8-2.4-3.7-4 c-0.5-1-0.7-2.1-0.5-3.2c0-1.6,0.3-3.2,0.9-4.6c3.9-12.2,13.5-21.8,25.7-25.7l2.7-0.9L37.2,49.4z M49.2,61l2.4,10.3 c0.1,0.2-0.9,1-2.8,2.4l-3.2,2l-3.1-2c-2-1.4-2.9-2.1-2.8-2.4s1.1-4.8,2.4-10.3l2.3-10h2.5L49.2,61z"/><path class="st1" d="M57.5,94.5c-1.5,0-3.2,0-4.9,0l-6.5,0c-32.3,0-33.6,0-34.9-0.3c-5.2-1.3-9.3-5.4-10.7-10.6 c-0.6-2.6-0.6-5.4,0.1-8c1.8-6,4.7-11.6,8.6-16.5c3.3-4,7.1-7.4,11.3-10.3c1.6-1,6.1-3.4,8-4.2c-0.3-0.5-0.7-1-1.2-1.4 c-1.1-1.1-2-2.3-3-3.5C20,33.6,18.7,25.6,21,18.3C24.3,8.6,33,1.5,43.1,0.1l0,0c2.5-0.2,5-0.1,7.5,0.3C61,2.6,69.2,10.7,71.6,21 c0.6,3.5,0.5,6.9-0.2,10.3c-1.2,4.8-3.7,9.2-7.2,12.7l-0.8,0.7l1.3,0.6c8.3,3.7,15.3,9.6,20.4,17.1c3.1,4.7,6.1,11.6,6.7,15.7 c0.8,6.3-2.4,12.3-8.1,15c-0.2,0.1-0.4,0.2-0.6,0.3C80.9,94.4,80.8,94.5,57.5,94.5z M29.2,45.5c-0.6,0.1-6,2.8-8.2,4.2 c-4.2,2.8-7.9,6.2-11.1,10.1c-3.8,4.8-6.6,10.2-8.4,16.1c-0.6,2.4-0.6,5-0.1,7.4c1.3,4.8,5.1,8.6,9.9,9.8 c1.2,0.3,3.1,0.3,34.7,0.3l6.5,0c28,0,28,0,30.1-1.1c0.2-0.1,0.4-0.2,0.6-0.3c5.3-2.5,8.3-8.2,7.5-14c-0.6-4-3.5-10.7-6.5-15.3 c-5-7.4-11.9-13.1-20-16.7l-2.7-1.2l1.9-1.7c3.4-3.3,5.8-7.5,7-12.2c0.7-3.3,0.8-6.6,0.2-9.9C68.4,11.3,60.5,3.5,50.5,1.4 c-2.4-0.4-4.8-0.5-7.2-0.3C33.5,2.4,25.1,9.3,22,18.7c-2.2,6.9-1,14.7,3.1,20.7c0.9,1.2,1.8,2.3,2.8,3.3c0.6,0.6,1.2,1.3,1.7,2.1 l0.5,0.8H29.2z M30.5,88.7c-11.4,0-16.7-0.1-17.3-0.1c-0.9-0.2-1.8-0.5-2.6-0.8c-1.7-1.1-3-2.5-3.9-4.2C6,82.5,5.8,81.2,6,80 c0-1.5,0.3-3.2,0.9-4.7c3.9-12.3,13.7-22,26-26l2.9-1l1.6,0.6c0.5,0.2,1,0.5,1.4,0.9l0.1,0.1v0.2c0,0.3-4.7,20.5-5.4,23.5 c1.4,1.2,10.6,7.7,12.2,8.7c1.3,0.4,10.8-7.1,12.1-8.6c-0.1-0.4-0.2-1.1-0.6-2.4c-0.5-2.2-1.2-5.4-2.1-9.2 c-1.4-5.9-2.6-11.7-2.6-11.9c0-0.7,1.8-1.4,1.8-1.4l1.8-0.7l2.8,1C70.7,53.1,80,62,84.5,73.6c1.9,4.9,2,7.5,0.8,10 c-1,2-2.6,3.5-4.6,4.5l-1.5,0.6H46.9C40.4,88.7,35,88.7,30.5,88.7z M35.8,49.4l-2.5,0.8c-12,3.9-21.5,13.3-25.4,25.4 C7.3,77.1,7,78.6,7,80.1c-0.2,1.1,0,2.1,0.4,3c0.8,1.5,2.1,2.9,3.5,3.8c0.7,0.3,1.5,0.5,2.3,0.7c0.9,0.1,12,0.2,33.6,0.1H79 l1.2-0.5c1.8-0.9,3.2-2.3,4.1-4.1c1.1-2.2,0.9-4.6-0.8-9.2c-4.3-11.4-13.4-20-25-23.7l-2.4-0.8L54.7,50c-0.5,0.2-0.9,0.4-1.1,0.6 c0.2,1,1.2,5.7,2.6,11.5c0.9,3.7,1.6,7,2.1,9.2c0.3,1.4,0.6,2.5,0.6,2.6c0.1,0.3,0.2,0.6-4.7,4.5c-7.4,5.9-8.5,5.2-8.9,5 c-0.9-0.5-4.2-2.9-6.9-4.8c-6-4.3-6-4.3-5.8-4.8c0.2-0.8,4.9-21,5.4-23.3c-0.2-0.2-0.5-0.4-0.8-0.5l0,0L35.8,49.4z M45.6,76.3 l-3.4-2.2c-2.6-1.8-3.2-2.3-3-3c0-0.1,0.3-1.4,0.7-2.9c0.4-1.9,1-4.5,1.7-7.4L44,50.5h3.3l4.8,20.6c0.2,0.5-0.3,1-3,3L45.6,76.3z M40.2,71.3c0.3,0.4,1.9,1.5,2.6,2l2.8,1.8l2.9-1.8c0.5-0.4,2.2-1.6,2.5-2l-4.6-19.8h-1.7l-2.2,9.6c-0.7,2.9-1.3,5.5-1.7,7.3 C40.5,70.1,40.3,71,40.2,71.3z M40.2,71.5C40.2,71.5,40.2,71.5,40.2,71.5C40.2,71.5,40.2,71.5,40.2,71.5z M45.9,45.7 c-3.7,0-7.4-0.9-10.7-2.8c-2.2-1.5-4.1-3.2-5.7-5.3c-3.9-5.6-4.8-12.7-2.4-19.1C29.2,13,33.5,8.8,39,7c2.4-0.9,4-1,7.5-1 c1.8-0.1,3.6,0.2,5.3,0.7c5.3,1.4,9.6,5,12,9.9c2.4,4.7,2.9,10.2,1.3,15.3c-1.5,5.3-5.3,9.7-10.4,11.9C52,45,49,45.7,45.9,45.7z M47,7c-0.2,0-0.3,0-0.5,0c-3.4,0-4.9,0.1-7.1,1c-5.3,1.7-9.4,5.7-11.3,10.8c-2.3,6-1.4,12.8,2.2,18.1c1.5,2,3.4,3.7,5.5,5.1 c5.7,3.2,12.6,3.6,18.6,0.9c4.8-2.1,8.4-6.2,9.8-11.3c1.5-4.9,1.1-10-1.3-14.5c-2.2-4.7-6.4-8.1-11.4-9.3l0,0 C50.1,7.2,48.6,7,47,7z"/></g></g></g></svg>
                            </i>
                            <span>{{ trans('messages.users') }}			</span>							
                                    </a>
                                </li>
                            @endif
                            @if (Auth::user()->admin->getPermission("admin_group_read") != 'no')
                                <li class="nav-item" rel0="AdminGroup2Controller">
                                    <a href="{{ action('Admin\AdminGroup2Controller@index') }}" class="dropdown-item d-flex align-items-center">
                                    <i class="navbar-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 118.9 118.9" style="enable-background:new 0 0 118.9 118.9;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><g><path class="st0" d="M78.5,66.1l-2.1-1l1.3-1.3c3.8-3.7,6.4-8.3,7.7-13.4c0.8-3.6,0.9-7.3,0.2-10.9c-2.4-11-11.1-19.5-22.1-21.8 c-2.6-0.4-5.3-0.5-8-0.3c-10.9,1.4-20,8.9-23.5,19.3c-2.5,7.7-1.2,16.2,3.5,22.8c1,1.3,2,2.5,3.1,3.7c1.1,1.2,1.9,2.1,1.7,2.1 s-6.8,3.2-9.1,4.7l-1.8,1.2c-0.8,0.6-0.9,1.8-0.3,2.5c0.3,0.4,0.8,0.6,1.3,0.7h5.1l0.9-0.2c2.6-1.5,5.3-2.8,8.2-3.7l2.4-0.7h1.1 l0.9,0.3c0.8,0.4,1.3,0.7,1.3,0.9s-0.3,1.4-0.8,3.4c-1.3,5.9-4,17.6-4.9,21.2c-0.1,0.7,0.2,1.4,0.7,1.8c2.7,2.1,11.1,8,12.6,8.9 s14-9.3,13.9-9.6s-1.3-5.9-2.9-12.8c-0.9-3.7-1.6-7.1-2.2-9.5S66,71.2,66,71.1l1.7-0.9l1.2-0.4H70l2.2,0.7 c2.9,0.9,5.7,2.2,8.3,3.7l0.9,0.2h5.1c1-0.1,1.7-0.9,1.7-1.9c0-0.5-0.3-1-0.7-1.3C84.7,69.2,81.6,67.5,78.5,66.1z M62,82.7 c1.4,5.9,2.5,10.9,2.6,11.1s-1,1.1-3.1,2.5l-3.4,2.3l-3.3-2.2l-2.3-1.7c-0.5-0.4-0.8-1.1-0.6-1.8c0.4-1.7,1.3-5.7,2.4-10.2 l1.9-8.3l0.2-1.2c0.2-0.8,0.9-1.3,1.7-1.3l0,0c0.8,0,1.5,0.5,1.7,1.3l0.3,1.2L62,82.7z M67.8,63.5c-6.6,3-14.3,2.6-20.6-0.9 c-2.4-1.5-4.4-3.5-6.1-5.7c-4.1-5.9-5-13.4-2.5-20.1c2.1-5.7,6.7-10.1,12.5-12c2.6-0.9,4.1-1.1,7.9-1s4,0.1,5.7,0.7 c5.5,1.5,10.1,5.2,12.7,10.3c2.5,5,3,10.8,1.3,16.1C77.1,56.5,73.1,61.1,67.8,63.5z"/><path class="st0" d="M58.1,106.8c-0.2,0-0.3,0-0.4-0.1c-1.5-0.9-10-6.8-12.6-8.9c-0.7-0.5-1-1.4-0.9-2.3C45,92,47.7,80.3,49,74.3 c0.4-1.5,0.7-2.7,0.8-3.2c-0.1-0.1-0.4-0.3-1-0.6L48,70.3h-0.9L44.7,71c-2.8,0.9-5.5,2.2-8.1,3.7l-0.1,0.1l-1,0.2h-5.1 c-0.7,0-1.3-0.4-1.7-0.9c-0.4-0.5-0.6-1.1-0.5-1.7c0.1-0.6,0.4-1.2,0.8-1.5l1.8-1.2c1.6-1,6.7-3.7,8.7-4.5 c-0.4-0.5-1-1.2-1.4-1.5c-1.1-1.2-2.2-2.4-3.1-3.7c-4.7-6.7-6.1-15.4-3.6-23.2c3.6-10.6,12.8-18.2,23.9-19.6 c2.7-0.3,5.5-0.1,8.1,0.3c11.2,2.3,20,11,22.5,22.2c0.7,3.7,0.6,7.4-0.2,11.1c-1.3,5.2-4,9.9-7.8,13.6L77.3,65l1.5,0.7 c3.2,1.4,6.2,3.2,9.1,5.1c0.5,0.4,0.8,1,0.9,1.7c0.1,1.3-0.9,2.4-2.1,2.5l-5.2,0l-1.1-0.3c-2.6-1.5-5.4-2.7-8.2-3.7l-2.1-0.7H69 l-1.1,0.4l-1.3,0.7c0.1,0.4,0.2,1.2,0.6,2.9c0.3,1.2,0.6,2.6,1,4.1c0.4,1.7,0.8,3.5,1.2,5.4c0.9,4,1.7,7.6,2.3,10 c0.3,1.5,0.6,2.7,0.6,2.8c0.1,0.4,0.2,0.5-3.4,3.4C64.8,103.2,59.9,106.8,58.1,106.8z M46.9,69.3l1.3,0l0.9,0.3 c1.2,0.6,1.6,0.9,1.6,1.4c0,0.2-0.2,0.9-0.8,3.5c-1.3,6-4,17.7-4.9,21.2c-0.1,0.5,0.1,1,0.5,1.3c2.7,2.1,11,8,12.5,8.9 c1.4,0.3,11.7-7.8,13.1-9.3c-0.1-0.4-0.3-1.2-0.6-2.6c-0.5-2.3-1.3-5.9-2.3-9.9c-0.5-1.9-0.9-3.7-1.2-5.4 c-0.3-1.5-0.7-2.9-0.9-4.1c-0.6-2.3-0.7-3.2-0.7-3.4v-0.3l2-1l1.4-0.5l1.3,0l2.2,0.7c2.9,1,5.7,2.2,8.3,3.7l0.8,0.2h5 c0.7,0,1.2-0.7,1.2-1.4c0-0.4-0.2-0.7-0.5-0.9c-2.8-1.9-5.8-3.6-8.9-5l0,0l-2.7-1.3l1.8-1.8c3.7-3.6,6.3-8.1,7.6-13.2 c0.8-3.5,0.9-7.1,0.2-10.7c-2.4-10.8-10.9-19.2-21.7-21.4c-2.6-0.4-5.2-0.5-7.9-0.3c-10.7,1.4-19.6,8.7-23.1,19 c-2.4,7.5-1.1,15.9,3.4,22.4c0.9,1.3,2,2.5,3.1,3.6c1.9,2.1,2,2.2,1.8,2.6l-0.1,0.3l-0.3,0c-0.7,0.3-6.7,3.2-8.9,4.6l-1.8,1.2 c-0.2,0.2-0.4,0.5-0.4,0.8c0,0.3,0.1,0.7,0.3,1c0.2,0.3,0.6,0.5,0.9,0.5l5,0l0.8-0.2c2.6-1.5,5.4-2.8,8.2-3.7L46.9,69.3z M58.1,99.2l-3.6-2.4l-2.3-1.7c-0.7-0.6-1-1.5-0.8-2.3l0.4-1.8c0.5-2.1,1.2-5.1,2-8.4l1.9-8.3l0.2-1.2c0.2-1,1.2-1.7,2.2-1.7 c1,0,1.9,0.7,2.2,1.7l0.3,1.2l1.9,8.3c0.7,2.8,1.3,5.4,1.7,7.4c0.4,1.8,0.8,3.4,0.8,3.6c0.2,0.4,0.3,0.7-3.3,3.1L58.1,99.2z M58.1,72.4c-0.6,0-1.1,0.4-1.2,0.9l-0.2,1.2l-1.9,8.3c-0.8,3.3-1.5,6.4-2,8.4L52.4,93c-0.1,0.5,0,1,0.4,1.3l2.3,1.7l3,2l3.1-2.1 c2-1.3,2.7-1.9,2.8-2.1c-0.1-0.4-0.3-1.3-0.8-3.5c-0.5-2-1.1-4.6-1.7-7.4l0,0l-2.2-9.5C59.2,72.8,58.7,72.4,58.1,72.4 C58.1,72.4,58.1,72.4,58.1,72.4z M64.1,94C64.1,94,64.1,94,64.1,94C64.1,94,64.1,94,64.1,94z M58.4,66c-4,0-7.9-1-11.5-3 c-2.4-1.6-4.5-3.5-6.3-5.8c-4.2-6-5.1-13.7-2.6-20.6c2.2-5.9,6.9-10.3,12.8-12.3c2.7-0.9,4.3-1.1,8.1-1l0.1,0 c3.7,0.1,4,0.1,5.7,0.7c5.6,1.5,10.3,5.3,13,10.5c2.6,5.1,3.1,11,1.3,16.5C77.5,56.8,73.5,61.5,68,64h0C65,65.3,61.7,66,58.4,66z M57.4,24.3c-2.6,0-4,0.2-6.1,1c-5.7,1.9-10.1,6.1-12.2,11.7c-2.5,6.5-1.5,13.9,2.4,19.6c1.6,2.2,3.7,4.1,6,5.6 c6.1,3.4,13.7,3.8,20.1,0.9l0,0c5.2-2.3,9.1-6.8,10.6-12.3c1.7-5.2,1.2-10.8-1.3-15.7c-2.5-5-7-8.6-12.4-10 c-1.6-0.6-1.8-0.6-5.5-0.7l-0.1,0C58.4,24.3,57.9,24.3,57.4,24.3z"/></g><rect x="49.5" y="73.9" class="st0" width="6.7" height="1"/><rect x="60.1" y="73.9" class="st0" width="6.6" height="1"/><path class="st0" d="M59.5,119C26.7,119,0,92.3,0,59.5S26.7,0,59.5,0S119,26.7,119,59.5S92.3,119,59.5,119z M59.5,7 C30.6,7,7,30.6,7,59.5C7,88.4,30.6,112,59.5,112c28.9,0,52.5-23.6,52.5-52.5C112,30.6,88.4,7,59.5,7z"/></g></g></svg>
                            </i>
                            <span>{{ trans('messages.user_groups') }}</span>
                                    </a>
                                </li>
                            @endif
                        @endif
						@if (Auth::user()->admin->getPermission("layout_read") != 'no')
							<li class="nav-item" rel0="LayoutController">
								<a href="{{ action('Admin\LayoutController@index') }}" class="dropdown-item d-flex align-items-center">
								<i class="navbar-icon">
									<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 85.4 84.4" style="enable-background:new 0 0 85.4 84.4;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M51,84.4H11.7C5.2,84.4,0,79.2,0,72.7v-61C0,5.2,5.2,0,11.7,0h61c6.5,0,11.7,5.2,11.7,11.7v40.6 c0,1.9-1.6,3.5-3.5,3.5s-3.5-1.6-3.5-3.5V11.7c0-2.6-2.1-4.7-4.7-4.7h-61C9.1,7,7,9.1,7,11.7v61c0,2.6,2.1,4.7,4.7,4.7H51 c1.9,0,3.5,1.6,3.5,3.5S52.9,84.4,51,84.4z"/><path class="st0" d="M71.5,72.6c-0.7,0-1.5-0.2-2.1-0.7L43.1,51.6c-1.5-1.2-1.8-3.4-0.6-4.9c1.2-1.5,3.4-1.8,4.9-0.6l26.3,20.3 c1.5,1.2,1.8,3.4,0.6,4.9C73.6,72.1,72.5,72.6,71.5,72.6z"/><polygon class="st0" points="40.6,60.7 31.3,38.1 55.5,41.4 "/><polygon class="st0" points="61.2,76.6 85.4,79.9 76.1,57.3 "/><path class="st0" d="M57.6,38.8c-0.7,0-1.4-0.2-1.9-0.6l-9.2-6.1c-1-0.7-1.6-1.9-1.6-3.1l0.7-11c0.1-1.3,0.8-2.4,2-2.9l10-4.9 c1.1-0.5,2.5-0.5,3.5,0.2l9.1,6.1c1,0.7,1.6,1.9,1.5,3.1l-0.7,11c-0.1,1.2-0.8,2.4-1.9,2.9l-9.9,4.9 C58.7,38.7,58.1,38.8,57.6,38.8z M52,27.4l5.8,3.9l6.3-3.1l0.4-7l-5.8-3.9l-6.4,3.1L52,27.4z M67.5,30.4L67.5,30.4L67.5,30.4z"/><path class="st0" d="M25.3,30.8c-4.7,0-8.6-3.9-8.6-8.6c0-4.7,3.9-8.6,8.6-8.6c4.7,0,8.6,3.9,8.6,8.6C33.9,26.9,30,30.8,25.3,30.8 z M25.3,20.6c-0.9,0-1.6,0.7-1.6,1.6c0,0.9,0.7,1.6,1.6,1.6c0.9,0,1.6-0.7,1.6-1.6C26.9,21.3,26.2,20.6,25.3,20.6z"/></g></g></svg>
							</i>{{ trans('messages.default_page_form_layout') }}
								</a>
							</li>
						@endif
						@if (Auth::user()->admin->getPermission("language_read") != 'no')
							<li class="nav-item" rel0="LanguageController">
								<a href="{{ action('Admin\LanguageController@index') }}" class="dropdown-item d-flex align-items-center">
								<i class="navbar-icon">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 88.9 88.9" style="enable-background:new 0 0 88.9 88.9;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><g><path class="st0" d="M62.6,73.4H10.1c-5,0.1-9-3.9-9.1-8.9c0,0,0-0.1,0-0.1V10.1C1,5.1,5.1,1,10.1,1c0,0,0,0,0,0H39 c0.8,0,1.5,0.5,1.7,1.2L64.3,71c0.2,0.6,0.1,1.2-0.2,1.7C63.7,73.2,63.2,73.4,62.6,73.4z M10.1,4.6c-3,0-5.5,2.5-5.5,5.5l0,0 v54.3c0.1,3,2.5,5.4,5.5,5.4H60L37.7,4.6H10.1z"/><path class="st0" d="M62.7,74.4C62.6,74.4,62.6,74.4,62.7,74.4l-52.6,0c0,0-0.1,0-0.1,0c-5.5,0-9.9-4.4-10-9.9l0-0.1V10.1 C0,4.5,4.5,0,10.1,0H39c1.2-0.1,2.3,0.7,2.7,1.9l23.6,68.8c0.3,0.9,0.2,1.8-0.3,2.6C64.4,74,63.5,74.4,62.7,74.4z M62.6,72.4 L62.6,72.4c0.3,0,0.5-0.1,0.7-0.3c0.1-0.2,0.1-0.5,0-0.8L39.8,2.5C39.7,2.2,39.4,2,39,2L10.1,2C5.6,2,2,5.6,2,10.1v54.3 c0,4.5,3.7,8,8.1,8H62.6z M10.1,70.8c-3.5,0-6.4-2.9-6.5-6.4V10.1c0-3.6,2.9-6.5,6.5-6.5h28.3l23,67.2H10.1 C10.1,70.8,10.1,70.8,10.1,70.8z M10.1,5.6c-2.5,0-4.5,2-4.5,4.5v54.3c0,2.4,2.1,4.4,4.5,4.4c0,0,0,0,0,0h48.5L37,5.6H10.1z"/></g><g><path class="st0" d="M78.9,87.9h-29c-0.7,0-1.4-0.4-1.7-1.1l-5.4-14.5c-0.4-0.9,0-2,0.9-2.4c0,0,0,0,0.1,0c1-0.3,2,0.2,2.4,1.1 l5,13.3h27.7c3,0,5.4-2.4,5.4-5.4l0,0V24.5c0-3-2.4-5.4-5.4-5.4l0,0H44.5c-1,0-1.8-0.8-1.8-1.8c0-1,0.8-1.8,1.8-1.8h34.4 c5,0,9,4,9,9v54.4C87.9,83.9,83.9,87.9,78.9,87.9z"/><path class="st0" d="M49.8,88.9c-1.1,0-2.1-0.7-2.6-1.7l-5.4-14.5c-0.6-1.4,0.1-3,1.5-3.6l0.1-0.1c1.5-0.5,3,0.3,3.7,1.6 l4.8,12.7h27c2.4,0,4.4-2,4.4-4.4V24.5c0-2.4-2-4.4-4.4-4.4H44.5c-1.5,0-2.8-1.3-2.8-2.8s1.3-2.8,2.8-2.8h34.4 c5.5,0,10,4.5,10,10v54.4c0,5.5-4.5,10-10,10L49.8,88.9C49.9,88.9,49.9,88.9,49.8,88.9z M44.4,70.8c-0.1,0-0.2,0-0.3,0 c-0.4,0.2-0.5,0.6-0.4,1l5.4,14.6c0.1,0.3,0.4,0.5,0.7,0.4h29c4.4,0,8-3.6,8-8V24.5c0-4.4-3.6-8-8-8H44.5c-0.4,0-0.8,0.4-0.8,0.8 c0,0.4,0.4,0.8,0.8,0.8h34.4c3.5,0,6.4,2.9,6.4,6.4v54.4c0,3.5-2.9,6.4-6.4,6.4H50.5l-5.2-13.9C45.1,71,44.8,70.8,44.4,70.8z"/></g><g><path class="st0" d="M49.9,87.9c-0.4,0-0.9-0.1-1.2-0.4c-0.7-0.7-0.8-1.8-0.2-2.6l12.7-14.5c0.7-0.7,1.8-0.8,2.6-0.1 c0.7,0.7,0.7,1.8,0.1,2.5L51.3,87.3C50.9,87.7,50.4,87.9,49.9,87.9z"/><path class="st0" d="M49.9,88.9c-0.6,0-1.3-0.2-1.8-0.6L48,88.2c-1.1-1.1-1.2-2.7-0.3-3.9l12.8-14.6c1.1-1.1,2.9-1.2,4-0.2 c1.1,1.1,1.2,2.8,0.2,3.9L52.1,88C51.5,88.6,50.7,88.9,49.9,88.9C49.9,88.9,49.9,88.9,49.9,88.9z M49.4,86.7 c0.2,0.1,0.3,0.2,0.5,0.2h0c0.3,0,0.5-0.1,0.7-0.3l12.6-14.5c0.3-0.3,0.3-0.8,0-1.1c-0.3-0.3-0.9-0.3-1.2,0.1L49.3,85.6 C49,85.9,49.1,86.4,49.4,86.7z"/></g><g><path class="st0" d="M35.4,51.7c-0.8,0-1.4-0.5-1.7-1.2l-7.3-20.6L19,50.5c-0.3,0.9-1.4,1.4-2.3,1.1c0,0,0,0,0,0 c-0.9-0.4-1.4-1.4-1.1-2.3l9.1-25.4c0.5-0.9,1.6-1.3,2.5-0.9c0.4,0.2,0.7,0.5,0.9,0.9l9,25.4c0.4,0.9,0,1.9-0.9,2.2 c-0.1,0-0.1,0.1-0.2,0.1L35.4,51.7z"/><path class="st0" d="M17.3,52.7c-0.3,0-0.5,0-0.8-0.1h-0.2l-0.2-0.1c-1.3-0.6-2-2.1-1.6-3.5l9.2-25.6c0.7-1.4,2.5-2,3.9-1.3 c0.6,0.3,1,0.7,1.3,1.3l0,0.1L38,49c0.3,0.6,0.3,1.3,0,2c-0.3,0.7-0.8,1.2-1.4,1.5c-0.1,0-0.2,0.1-0.3,0.1l-0.1,0l-0.8,0.1 c0,0,0,0,0,0c-1.2,0-2.2-0.8-2.6-1.9l-6.4-18l-6.5,18c-0.2,0.7-0.8,1.3-1.4,1.6C18.1,52.6,17.7,52.7,17.3,52.7z M17.1,50.7 c0.2,0.1,0.4,0,0.6,0c0.2-0.1,0.3-0.3,0.4-0.5l8.3-23.2l8.2,23.2c0.1,0.3,0.4,0.5,0.7,0.5l0.4-0.1c0.2-0.1,0.4-0.2,0.4-0.4 c0.1-0.2,0.1-0.4,0-0.5l-9-25.4c-0.1-0.2-0.2-0.3-0.4-0.4c-0.2-0.1-0.5-0.1-0.7,0c-0.2,0.1-0.4,0.2-0.5,0.4l-9.1,25.3 C16.4,50,16.6,50.5,17.1,50.7z"/></g><g><path class="st0" d="M30,40.8h-7.3c-1,0-1.8-0.8-1.8-1.8c0-1,0.8-1.8,1.8-1.8H30c1,0,1.8,0.8,1.8,1.8C31.8,40,31,40.8,30,40.8 C30,40.8,30,40.8,30,40.8z"/><path class="st0" d="M30,41.8h-7.3c-1.5,0-2.8-1.3-2.8-2.8c0-1.5,1.3-2.8,2.8-2.8H30c0,0,0,0,0,0c0.7,0,1.4,0.3,2,0.8 c0.5,0.5,0.8,1.2,0.8,2C32.8,40.5,31.5,41.8,30,41.8z M22.7,38.2c-0.4,0-0.8,0.4-0.8,0.8c0,0.2,0.1,0.4,0.2,0.6 c0.2,0.2,0.4,0.2,0.6,0.2H30c0.2,0,0.4-0.1,0.6-0.2c0.2-0.2,0.2-0.4,0.2-0.6c0-0.4-0.4-0.8-0.8-0.8c0,0,0,0,0,0H22.7z"/></g><g><path class="st0" d="M78.9,40.8H53.5c-1,0-1.8-0.8-1.8-1.8c0-1,0.8-1.8,1.8-1.8h25.4c1,0,1.8,0.8,1.8,1.8 C80.7,40,79.9,40.8,78.9,40.8z"/><path class="st0" d="M78.9,41.8H53.5c-1.5,0-2.8-1.3-2.8-2.8c0-1.5,1.3-2.8,2.8-2.8h25.4c0.7,0,1.5,0.3,2,0.8 c0.5,0.5,0.8,1.2,0.8,2C81.7,40.5,80.4,41.8,78.9,41.8z M53.5,38.2c-0.4,0-0.8,0.4-0.8,0.8s0.4,0.8,0.8,0.8h25.4h0 c0.4,0,0.8-0.4,0.8-0.8c0-0.2-0.1-0.4-0.2-0.6c-0.2-0.2-0.4-0.2-0.6-0.2H53.5z"/></g><g><path class="st0" d="M64.4,40.8c-1,0-1.8-0.8-1.8-1.8c0,0,0,0,0,0v-3.6c0-1,0.8-1.8,1.8-1.8c1,0,1.8,0.8,1.8,1.8c0,0,0,0,0,0V39 C66.2,40,65.4,40.8,64.4,40.8z"/><path class="st0" d="M64.4,41.8c-1.5,0-2.8-1.3-2.8-2.8v-3.6c0-1.5,1.3-2.8,2.8-2.8c0,0,0,0,0,0c1.5,0,2.8,1.3,2.8,2.8V39 C67.2,40.5,65.9,41.8,64.4,41.8z M64.4,34.6L64.4,34.6c-0.4,0-0.8,0.4-0.8,0.8V39c0,0.4,0.4,0.8,0.8,0.8s0.8-0.4,0.8-0.8v-3.6 c0-0.2-0.1-0.4-0.2-0.6C64.8,34.7,64.6,34.6,64.4,34.6z"/></g><g><path class="st0" d="M59,62.6c-1,0.1-1.8-0.7-1.9-1.7c0-0.6,0.3-1.3,0.8-1.6c7.9-5.6,13.7-17.1,13.7-20.3c0-1,0.8-1.8,1.8-1.8 l0,0c1,0,1.8,0.8,1.9,1.8c0,4.8-7,17.4-15.3,23.2C59.7,62.5,59.4,62.6,59,62.6z"/><path class="st0" d="M58.9,63.6c-0.7,0-1.3-0.2-1.8-0.7c-0.6-0.5-0.9-1.2-0.9-1.9c-0.1-1,0.4-2,1.3-2.5 c7.5-5.3,13.2-16.5,13.2-19.5c0-1.5,1.3-2.8,2.8-2.8c0,0,0,0,0,0c1.5,0,2.8,1.2,2.9,2.7c0,5.2-7,17.9-15.7,24 c-0.4,0.4-1,0.6-1.6,0.6C59,63.6,58.9,63.6,58.9,63.6z M73.4,38.2C73.4,38.2,73.4,38.2,73.4,38.2c-0.4,0-0.8,0.4-0.8,0.8 c0,3.7-6.1,15.4-14.1,21.1c-0.3,0.2-0.4,0.5-0.4,0.7c0,0.2,0.1,0.4,0.3,0.6s0.4,0.2,0.6,0.2l0.1,0c0.1,0,0.2,0,0.3-0.1l0.1-0.1 c7.9-5.5,14.9-17.9,14.9-22.4C74.3,38.6,73.9,38.2,73.4,38.2z"/></g><g><path class="st0" d="M73.4,66.2c-0.4,0-0.9-0.2-1.2-0.5c-1.3-1.2-12.9-11.9-14.9-16.9c-0.4-0.9,0-2,0.9-2.4c0,0,0,0,0.1,0 c0.9-0.4,1.9,0,2.2,0.9c0,0,0,0.1,0.1,0.1c1.5,3.7,10.7,12.5,14.1,15.7c0.7,0.7,0.7,1.8,0.1,2.5C74.4,66,73.9,66.2,73.4,66.2z"/><path class="st0" d="M73.4,67.2L73.4,67.2c-0.7-0.1-1.3-0.3-1.8-0.7c-4-3.7-13.3-12.6-15.2-17.3c-0.6-1.4,0-3,1.5-3.7l0.1-0.1 c0.6-0.3,1.3-0.3,2,0c0.7,0.3,1.2,0.8,1.5,1.4c0,0.1,0.1,0.2,0.1,0.2c0.9,2.3,6,7.9,13.8,15.3c1.1,1.1,1.2,2.8,0.2,3.9 C75,66.9,74.2,67.2,73.4,67.2L73.4,67.2z M59,47.3c-0.1,0-0.2,0-0.3,0.1c-0.5,0.2-0.7,0.7-0.5,1.1c1.4,3.5,8.5,10.9,14.6,16.6 c0.2,0.1,0.4,0.2,0.6,0.2c0.2,0,0.5-0.1,0.7-0.3c0.3-0.3,0.2-0.8-0.1-1.1c-5.8-5.4-12.9-12.6-14.3-16l0.9-0.5l-0.9,0.4 c-0.1-0.2-0.2-0.3-0.4-0.4C59.2,47.3,59.1,47.3,59,47.3z"/></g></g></g></svg>
							</i>{{ trans('messages.language') }}
								</a>
							</li>
						@endif
						<li class="nav-item" rel0="PluginController">
							<a href="{{ action('Admin\PluginController@index') }}" class="dropdown-item d-flex align-items-center">
							<i class="navbar-icon">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 67.8 81" style="enable-background:new 0 0 67.8 81;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><g><path class="st0" d="M38.6,6.3l-4.2,4.3l-1.7-1.8c-2.2-2.1-3.1-2.6-4.7-2.6c-0.6,0-1.1,0.1-1.6,0.3c-0.2,0.1-4,3.8-8.3,8.1 c-8.5,8.5-9.4,9.6-11,12.7c-1.8,3.3-2.7,7.1-2.7,10.9c-0.1,2.5,0.3,5,1.1,7.3c1.1,3.4,2.9,6.5,5.3,9.2l0.7,0.7l-1.3,1.2 c-1.7,1.5-2.6,3.6-2.7,5.8c0,2.2,0.9,4.2,3,6.5s2.5,3.4,2.5,4.8c0,1.1-0.4,2.1-1.3,2.7c-1.7,1.5-4.2,1.1-6.8-1.1l-1.1-0.9L3,75.3 l-0.8,0.8l0.7,0.7c2.6,2.3,6.1,3.3,8.8,2.4c0.7-0.3,1.4-0.7,1.9-1.2c1.1-1.1,1.7-2.7,1.6-4.3c0-2.5-0.7-4-3.1-6.7 c-0.7-0.6-1.2-1.4-1.7-2.2c-0.4-0.7-0.6-1.4-0.5-2.2c-0.1-0.8,0.1-1.6,0.5-2.3c0.7-1.2,1.6-2.2,2.7-3l1.4,0.9 c3.1,2.4,6.7,4.1,10.5,4.9c3,0.4,6,0.4,9,0c3.7-0.8,7.1-2.3,10.1-4.6c1.6-1.2,16.4-15.9,17-16.9c0.4-0.6,0.5-1.2,0.4-1.9 c0-1.6-0.4-2.4-2.6-4.6l-1.7-1.7l4.2-4.3l4.2-4.2l-3-3l-3-3.1L55.4,23c-2.3,2.3-4.2,4.1-4.3,4.1S40.6,16.9,40.6,16.6l4.2-4.3 l4.1-4.1l-3-3l-3-3.1L38.6,6.3z M41.7,12l-3.8,3.8l-1.3-1.3l-1.3-1.3l3.8-3.9l3.8-3.8l1.3,1.4l1.3,1.3L41.7,12z M28.9,8.8 C29.7,9.2,58.7,38.2,59,38.9s0.6,1-7.7,9.3c-4.4,4.4-8.2,8-8.9,8.5c-4.2,3.3-9.4,4.9-14.7,4.5c-5.5-0.6-10-2.9-14.4-7.4 S6.6,44,6.6,38.3c0-4.7,1.6-9.3,4.5-13c1-1.3,16-16.4,16.5-16.7S28.3,8.5,28.9,8.8z M60.9,23.6l1.3,1.3l-3.8,3.8l-3.8,3.8 l-1.3-1.3L52,29.9l3.7-3.8l3.9-3.8L60.9,23.6z"/><path class="st0" d="M9.6,81c-2.6,0-5.4-1.1-7.7-3.1l-1.8-1.8l1.9-1.9l1.7-1.9l2.2,1.8c1,0.8,3.3,2.5,4.9,1.1l0.1-0.1 c0.5-0.3,0.7-0.9,0.7-1.4c0-1-0.1-1.7-2.1-3.8C7,67.3,6,65,6,62.4c0.1-2.7,1.2-5.2,3.2-6.9l0.2-0.2C7,52.5,5.2,49.4,4.1,46 c-0.9-2.5-1.3-5.2-1.2-7.8c0-4,0.9-8,2.9-11.6c1.7-3.3,2.8-4.6,11.3-13c8.1-8.1,8.5-8.3,8.7-8.4c0.7-0.4,1.5-0.5,2.3-0.5 c2.2,0,3.5,0.9,5.7,3l0.7,0.7l3.1-3.2L42.9,0l4,4.2l4,4l-5.2,5.2l-3.2,3.3c1.9,2,6.5,6.5,8.5,8.4c0.7-0.7,1.8-1.8,3.2-3.1 l5.3-5.3l4.1,4.2l4,4l-5.3,5.3l-3.2,3.2L60,34c2.2,2.2,3,3.4,3,5.5c0.1,1-0.1,2-0.6,2.8C61.5,43.8,46.5,58.6,45,59.7 c-3.1,2.4-6.8,4-10.7,4.9l-0.1,0c-3.1,0.4-6.3,0.4-9.4,0l-0.1,0c-4-0.9-7.8-2.6-11.1-5.1l-0.4-0.3c-0.6,0.6-1.1,1.2-1.5,1.9 c-0.2,0.4-0.3,0.9-0.3,1.4l0,0.1l0,0.1c0,0.5,0.1,0.9,0.3,1.3c0.4,0.7,0.9,1.3,1.4,1.9l0.1,0.1c2.6,3,3.5,4.8,3.5,7.6 c0.1,2-0.6,4-2,5.4c-0.7,0.7-1.5,1.2-2.4,1.5C11.4,80.9,10.5,81,9.6,81z M28.1,10.1C25.6,12.5,13,25.3,12.3,26.2 c-2.7,3.4-4.2,7.7-4.2,12.1c0,5.3,2.1,10.2,6.3,14.5c4.2,4.2,8.3,6.4,13.5,7c4.9,0.4,9.7-1.1,13.6-4.2c0.6-0.4,4.2-3.8,8.8-8.4 c1.6-1.6,6.2-6.2,7.2-7.7C54.3,36,30.4,12.1,28.1,10.1z M54.1,29.9l0.5,0.5l5.5-5.5l-0.5-0.5l-2.8,2.8L54.1,29.9z M51.1,28.6 C51.1,28.6,51.1,28.6,51.1,28.6L51.1,28.6C51.1,28.6,51.1,28.6,51.1,28.6z M37.4,13.2l0.5,0.5l5.5-5.5l-0.5-0.5l-2.7,2.7 L37.4,13.2z"/></g><g><path class="st0" d="M28.5,18.2l-0.4,0.4l10.1,10.1l10.1,10.1l0.4-0.4c0.2-0.1,0.3-0.3,0.3-0.5c0-0.1-19.9-20.1-20-20.1 L28.5,18.2z"/><path class="st0" d="M48.3,40.9L26,18.6l1.6-1.6l0.9-0.7H29c0.7,0,0.7,0,11.1,10.5c10.4,10.5,10.4,10.5,10.4,11.1l0,0.2 c-0.1,0.6-0.4,1.1-0.8,1.5L48.3,40.9z"/></g><g><path class="st0" d="M24.2,22.6L23.8,23l10.1,10l10,10.1l0.5-0.4l0.4-0.4l-10-10.1l-10.2-10C24.4,22.3,24.3,22.4,24.2,22.6z"/><path class="st0" d="M43.8,45.1L32.8,34.1L21.7,23l1.4-1.4c0.2-0.3,0.5-0.5,0.8-0.7l1-0.6l11,10.8l11.1,11.2l-1.6,1.6L43.8,45.1z "/></g></g></g></svg>
							</i>{{ trans('messages.plugins') }}
							</a>
						</li>
                        @if (config('custom.woo'))
                            <li class="nav-item" rel0="ProductController">
                                <a class="dropdown-item d-flex align-items-center" href="{{ action('ProductController@index') }}">
                                    <i class="navbar-icon" style="">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 88.3 71.5" style="enable-background:new 0 0 88.3 71.5;" xml:space="preserve"> <style type="text/css"> .st0{fill:#93A8C1;}.st1{fill:#414042;}</style> <g id="Layer_2_1_"> <g id="Layer_1-2"> <rect x="18.4" y="48" class="st0" width="52.5" height="10.1"/> <rect x="18.4" y="30.8" class="st0" width="52.5" height="10.1"/> <path class="st1" d="M71.3,71.5C71.3,71.5,71.3,71.5,71.3,71.5L17.7,71c-0.6,0-1.2-0.3-1.7-0.7s-0.7-1.1-0.7-1.7l0.9-38l-4.4,2.7 c-0.6,0.4-1.3,0.5-1.9,0.3c-0.6-0.2-1.2-0.6-1.5-1.2c-2.7-5.5-5.4-11-8.2-16.5c-0.4-0.9-0.3-1.9,0.3-2.6c4.4-5.1,10-9.1,16.3-11.4 c4.7-1.6,7.7-1.5,13.6-1.3c3,0.1,6.8,0.2,12.2,0.2c6.2-0.1,10.4-0.3,13.5-0.5c5.3-0.3,8-0.5,12.5,0.8c7.3,2.2,13.8,6.3,19,11.9 c0.6,0.7,0.8,1.7,0.4,2.6L80.6,32c-0.3,0.6-0.8,1.1-1.4,1.3c-0.6,0.2-1.3,0.1-1.9-0.2l-4.7-2.7l1.1,38.7c0,0.6-0.2,1.3-0.7,1.7 C72.6,71.2,72,71.5,71.3,71.5z M20.1,66.2l48.7,0.5l-1.2-40.5c0-0.9,0.4-1.7,1.2-2.1c0.7-0.4,1.7-0.5,2.4,0l6.1,3.5L83,15 c-4.4-4.4-9.8-7.6-15.7-9.4C63.6,4.6,61.5,4.7,56.4,5C53.3,5.2,49,5.4,42.7,5.5c-5.5,0-9.3-0.1-12.4-0.2c-5.8-0.2-8-0.3-11.8,1.1 c-5,1.8-9.6,4.9-13.3,8.8c2.1,4.2,4.2,8.5,6.3,12.7l5.9-3.7c0.7-0.5,1.7-0.5,2.4,0c0.8,0.4,1.2,1.3,1.2,2.1L20.1,66.2z"/> <path class="st1" d="M44.4,18c-3.5,0-6.9-1.6-10-4.8c-2.6-2.8-4.2-6.3-4.5-10c-0.1-1.3,0.8-2.5,2.1-2.6c1.3-0.1,2.5,0.8,2.6,2.1 c0.3,2.6,1.4,5.2,3.2,7.1c0.9,0.9,3.5,3.6,7,3.3c3.9-0.3,6.4-3.9,7.5-6.1c0.8-1.5,1.3-3.2,1.6-4.9c0.2-1.3,1.4-2.2,2.7-2 c1.3,0.2,2.2,1.4,2,2.7c-0.3,2.2-1,4.3-2.1,6.3c-2.7,5.3-6.8,8.4-11.4,8.7C44.9,18,44.7,18,44.4,18z"/> </g> </g> </svg>
                                    </i>
                                    <span>{{ trans('messages.products') }}</span>
                                </a>
                            </li>
                            <li class="nav-item" rel0="SourceController">
                                <a class="dropdown-item d-flex align-items-center" href="{{ action('SourceController@index') }}">
                                    <i class="navbar-icon" style="">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 94.4 85.6" style="enable-background:new 0 0 94.4 85.6;" xml:space="preserve"><style type="text/css">.st0{fill:#93C2A0;}.st1{fill:#414042;}.st2{fill:#877083;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M37,58.5h18.1c2.3,0,4.2,1.9,4.2,4.2V78c0,2.3-1.9,4.2-4.2,4.2H37c-2.3,0-4.2-1.9-4.2-4.2V62.7 C32.8,60.4,34.7,58.5,37,58.5z"/><path class="st1" d="M94.4,32.8c0-1.9-0.3-3.8-0.9-5.6l0,0c0-0.3,0-0.3-0.3-0.6l-8-19.8c-1.5-4.2-5.6-6.9-10-6.8H19.2 c-4.7,0-8.3,2.4-9.7,6.5L0.9,26.8v0.6C0.3,29.3,0,31.3,0,33.3c-0.1,5.2,2.1,10.1,5.9,13.6v29.8c0,4.9,4,8.8,8.9,8.9h64 c4.9,0,8.8-4,8.9-8.9V48.1C91.7,43.7,94.4,38.4,94.4,32.8L94.4,32.8z M78.8,77.9h-64c-0.9,0-1.7-0.7-1.8-1.6c0-0.1,0-0.1,0-0.2 V50.5c2,0.6,4.1,0.9,6.2,0.9c5.5,0.1,10.8-2.4,14.2-6.8c3.5,4.2,8.7,6.5,14.2,6.5c5.5,0.1,10.8-2.4,14.2-6.8 c3.6,4.2,8.9,6.7,14.5,6.8c1.6,0,3.2-0.2,4.7-0.6v25.4C80.7,76.9,79.9,77.7,78.8,77.9L78.8,77.9z M81.4,43.1 c-1.7,0.9-3.7,1.3-5.6,1.2c-4.1,0-7.9-2.1-10-5.6c-0.3-0.3-0.3-0.9-0.9-1.5c-0.8-0.9-2-1.5-3.2-1.5c-1.3-0.1-2.5,0.5-3.2,1.5 c-0.4,0.4-0.7,0.9-0.9,1.5c-3.4,5.5-10.7,7.3-16.2,3.9c-1.6-1-2.9-2.3-3.9-3.9c-0.3-0.3-0.3-0.9-0.9-1.2c-1.5-1.8-5.3-1.8-6.5,0 c-0.4,0.4-0.8,0.9-0.9,1.5c-2.1,3.5-5.9,5.7-10,5.6c-1.9,0.1-3.9-0.3-5.6-1.2l0,0c-3.9-2.1-6.2-6.2-6.2-10.6 c0-1.3,0.2-2.6,0.6-3.8v-0.3l8.5-20.1c0.3-0.6,0.6-2.1,3.2-2.1h56.1c1.5-0.2,3,0.7,3.5,2.1l8,19.8v0.3c0.3,1.3,0.5,2.5,0.6,3.8 C87.8,36.9,85.3,40.9,81.4,43.1L81.4,43.1z"/><path class="st2" d="M67.1,27.3H26.7c-2.2,0-4-1.8-4-4s1.8-4,4-4h40.4c2.2,0,4,1.8,4,4S69.3,27.3,67.1,27.3z"/></g></g></svg>
                                    </i>
                                    <span>{{ trans('messages.stores_connections') }}</span>
                                </a>
                            </li>
                        @endif
                    </ul>
				</li>
                @if (
                    Auth::user()->customer->can("read", new Acelle\Model\Blacklist())
					|| Auth::user()->admin->getPermission("report_blacklist") != 'no'
					|| Auth::user()->admin->getPermission("report_tracking_log") != 'no'
					|| Auth::user()->admin->getPermission("report_bounce_log") != 'no'
					|| Auth::user()->admin->getPermission("report_feedback_log") != 'no'
					|| Auth::user()->admin->getPermission("report_open_log") != 'no'
					|| Auth::user()->admin->getPermission("report_click_log") != 'no'
					|| Auth::user()->admin->getPermission("report_unsubscribe_log") != 'no'
				)
					<li class="nav-item dropdown language-switch"
						rel0="TrackingLogController"
						rel1="OpenLogController"
						rel2="ClickLogController"
						rel3="FeedbackLogController"
						rel4="BlacklistController"
						rel5="UnsubscribeLogController"
						rel6="BounceLogController"
					>
						<a role="button" class="nav-link lvl-1 dropdown-toggle d-flex align-items-center" data-bs-toggle="dropdown">
							<i class="navbar-icon">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 102.5 100.8"><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><g id="Layer_2-2" data-name="Layer 2"><g id="Layer_1-2-2" data-name="Layer 1-2"><path d="M18.3,92.5H15.8A15.8,15.8,0,0,1,0,76.7V15.8A15.8,15.8,0,0,1,15.8,0H76.7A15.8,15.8,0,0,1,92.5,15.8v5.5a3.5,3.5,0,0,1-7,0V15.8A8.7,8.7,0,0,0,76.7,7H15.8A8.7,8.7,0,0,0,7,15.8V76.7a8.7,8.7,0,0,0,8.8,8.8h2.5a3.5,3.5,0,0,1,0,7Z" style="fill:#f2f2f2"/><path d="M65.3,100.8a37.2,37.2,0,1,1,37.2-37.2A37.3,37.3,0,0,1,65.3,100.8Zm0-67.4A30.2,30.2,0,1,0,95.5,63.6,30.2,30.2,0,0,0,65.3,33.4Z" style="fill:#f2f2f2"/><path d="M83,81.8a3.1,3.1,0,0,1-2-.7L63.4,68.4a3.3,3.3,0,0,1-1.5-2.7l-.6-16.4a3.5,3.5,0,1,1,7-.2l.5,14.7L85,75.5a3.3,3.3,0,0,1,.8,4.8A3.2,3.2,0,0,1,83,81.8Z" style="fill:aqua"/><path d="M40,23.6H19.5a3.5,3.5,0,0,1,0-7H40a3.5,3.5,0,0,1,0,7Z" style="fill:#ff0"/><path d="M25.8,36.7H19.5a3.5,3.5,0,0,1,0-7h6.3a3.5,3.5,0,0,1,0,7Z" style="fill:#f2f2f2"/></g></g></g></g></svg>
							</i>
							<span>{{ trans('messages.report') }}</span>
							<span class="caret"></span>
						</a>
						<ul class="dropdown-menu dropdown-menu-bottom">
							<li class="nav-item" rel0="BlacklistController">
                                <a href="{{ action('BlacklistController@index') }}" class="dropdown-item d-flex align-items-center">
                                <i class="navbar-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 65.6 65.6" style="enable-background:new 0 0 65.6 65.6;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><g><path class="st0" d="M42.7,56.8c-1.1,0-2,0.9-2,2v1.8H5v-10c-0.1-9.7,7.7-17.7,17.4-17.9h0.9c3.7,0.1,7.2,1.3,10.2,3.5 c0.9,0.7,2.1,0.5,2.8-0.4c0.6-0.9,0.4-2.1-0.5-2.8c-1.6-1.2-3.3-2.2-5.2-2.9c7.5-4.3,10.2-13.9,5.9-21.4S22.6-1.5,15.1,2.8 S4.9,16.7,9.2,24.2c1.4,2.5,3.4,4.5,5.9,5.9C6.6,33.3,1,41.5,1,50.6v10.5c0,1.9,1.6,3.5,3.5,3.5h36.7c1.9,0,3.5-1.6,3.5-3.5v-2.3 C44.7,57.7,43.8,56.8,42.7,56.8z M11.2,16.6C11.3,10.1,16.6,5,23,5c3,0,5.9,1.2,8.1,3.4c4.5,4.5,4.5,11.9,0,16.4 c-2.2,2.2-5.2,3.4-8.3,3.4C16.4,28.2,11.2,23,11.2,16.6z"/><path class="st0" d="M41.2,65.6H4.5c-2.5,0-4.5-2-4.5-4.5V50.6c0-8.8,5.1-16.9,13-20.7c-1.9-1.4-3.5-3.2-4.7-5.2 C6.1,20.8,5.6,16.3,6.8,12c1.2-4.3,4-7.9,7.9-10.1c3.9-2.2,8.4-2.8,12.7-1.6c4.3,1.2,7.9,4,10.1,7.9c4.2,7.4,2.1,16.8-4.7,21.7 c1.3,0.6,2.5,1.4,3.7,2.3c1.3,1,1.6,2.8,0.7,4.1c-0.5,0.7-1.2,1.1-2,1.2c-0.8,0.1-1.6-0.1-2.2-0.6c-2.8-2.1-6.1-3.2-9.6-3.3 l-0.9,0C13.3,33.9,5.9,41.4,6,50.6v9h33.7v-0.8c0-1.7,1.3-3,3-3s3,1.3,3,3v2.3C45.7,63.6,43.7,65.6,41.2,65.6z M22.8,1.7 c-2.5,0-5,0.6-7.2,1.9c-7,4-9.5,13-5.5,20c1.3,2.3,3.2,4.2,5.5,5.5l1.8,1l-2,0.8C7.4,34.1,2,42,2,50.6v10.5 c0,1.4,1.1,2.5,2.5,2.5h36.7c1.4,0,2.5-1.1,2.5-2.5v-2.3c0-0.6-0.4-1-1-1s-1,0.4-1,1v2.8H4v-11c-0.1-10.2,8.1-18.7,18.4-18.9h0.9 c3.9,0.1,7.7,1.4,10.8,3.7c0.2,0.2,0.5,0.2,0.7,0.2c0.3,0,0.5-0.2,0.7-0.4c0.3-0.4,0.1-1.1-0.3-1.4c-1.5-1.2-3.2-2.1-4.9-2.8 l-2-0.8l1.9-1.1c7-4,9.5-13,5.5-20c-1.9-3.4-5.1-5.9-8.9-6.9C25.5,1.9,24.1,1.7,22.8,1.7z M22.9,29.2c0,0-0.1,0-0.1,0 c-6.9,0-12.6-5.7-12.6-12.6v0c0-3.4,1.4-6.6,3.8-8.9s5.7-3.6,9-3.6c3.3,0,6.4,1.3,8.7,3.6c2.4,2.4,3.7,5.6,3.7,8.9 s-1.3,6.5-3.7,8.9C29.5,27.9,26.2,29.2,22.9,29.2z M12.2,16.6c0,5.8,4.8,10.6,10.6,10.6c2.8,0,5.6-1.1,7.6-3.1 c2-2,3.1-4.7,3.1-7.5c0-2.8-1.1-5.5-3.1-7.5c-2-1.9-4.6-3-7.4-3.1c-2.9,0-5.6,1-7.6,3C13.4,11.1,12.2,13.8,12.2,16.6z"/></g><g><path class="st0" d="M55.5,40.7l8.5-8.5c0.7-0.9,0.5-2.1-0.4-2.8c-0.7-0.5-1.7-0.5-2.4,0l-8.6,8.5l-8.5-8.5 c-0.9-0.7-2.1-0.5-2.8,0.4c-0.5,0.7-0.5,1.7,0,2.4l8.5,8.5l-8.5,8.6c-0.8,0.7-0.8,1.9-0.1,2.7c0,0,0.1,0.1,0.1,0.1 c0.7,0.8,1.9,0.8,2.7,0.1c0,0,0.1-0.1,0.1-0.1l8.5-8.6l8.6,8.6c0.7,0.8,1.9,0.8,2.7,0.1c0,0,0.1-0.1,0.1-0.1 c0.8-0.7,0.8-1.9,0.1-2.7c0,0-0.1-0.1-0.1-0.1L55.5,40.7z"/><path class="st0" d="M62.6,53.7c-0.8,0-1.6-0.3-2.1-0.9l-7.9-7.9l-7.8,7.9c0,0-0.1,0.1-0.1,0.1c-1.2,1.1-3,1-4.1-0.2c0,0,0,0,0,0 c0,0-0.1-0.1-0.1-0.1c-1.1-1.2-1-3,0.2-4.1l7.8-7.9l-7.9-7.9c-0.8-1.1-0.8-2.5,0-3.6c1-1.3,2.9-1.6,4.2-0.6l0.1,0.1l7.8,7.8 l8-7.9c1.1-0.8,2.5-0.8,3.6,0c0.6,0.5,1.1,1.2,1.2,2c0.1,0.8-0.1,1.6-0.6,2.2l-0.1,0.1l-7.8,7.8l7.8,7.9c0,0,0.1,0.1,0.1,0.1 c0.5,0.6,0.8,1.3,0.8,2.1c0,0.8-0.4,1.5-0.9,2c0,0-0.1,0.1-0.1,0.1C64,53.5,63.3,53.7,62.6,53.7z M42.1,31.6l9.1,9.1L42,50 c-0.4,0.4-0.4,0.9-0.1,1.3l0.1,0.1c0.3,0.4,0.9,0.4,1.3,0.1l0.1-0.1l9.2-9.3l9.3,9.3c0.4,0.4,0.9,0.4,1.3,0.1l0.1-0.1 c0.2-0.2,0.3-0.4,0.3-0.6c0-0.2-0.1-0.5-0.2-0.6L63.3,50l-9.2-9.3l9.1-9.1c0.1-0.2,0.2-0.4,0.2-0.7c0-0.3-0.2-0.5-0.4-0.7 c-0.3-0.3-0.8-0.3-1.2,0l-9.3,9.1l-9.1-9.1c-0.4-0.3-1-0.2-1.4,0.2C41.8,30.7,41.8,31.2,42.1,31.6z"/></g></g></g></svg>
                        </i>{{ trans('messages.blacklist') }}
                                </a>
                            </li>
							@if (Auth::user()->admin->getPermission("report_tracking_log") != 'no')
								<li class="nav-item" rel0="TrackingLogController">
									<a href="{{ action('Admin\TrackingLogController@index') }}" class="dropdown-item d-flex align-items-center">
									<i class="navbar-icon">
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 102.5 100.8" style="enable-background:new 0 0 102.5 100.8;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M18.3,92.5h-2.5C7.1,92.5,0,85.4,0,76.7V15.8C0,7.1,7.1,0,15.8,0h60.9c8.7,0,15.8,7.1,15.8,15.8v5.5 c0,1.9-1.6,3.5-3.5,3.5s-3.5-1.6-3.5-3.5v-5.5c0-4.9-3.9-8.8-8.8-8.8H15.8C10.9,7,7,10.9,7,15.8v60.9c0,4.9,3.9,8.8,8.8,8.8h2.5 c1.9,0,3.5,1.6,3.5,3.5S20.2,92.5,18.3,92.5z"/><path class="st0" d="M65.3,100.8c-20.5,0-37.2-16.7-37.2-37.2c0-20.5,16.7-37.2,37.2-37.2c20.5,0,37.2,16.7,37.2,37.2 C102.5,84.1,85.8,100.8,65.3,100.8z M65.3,33.4c-16.7,0-30.2,13.5-30.2,30.2s13.5,30.2,30.2,30.2s30.2-13.5,30.2-30.2 S82,33.4,65.3,33.4z"/><path class="st0" d="M83,81.8c-0.7,0-1.4-0.2-2-0.7L63.4,68.4c-0.9-0.6-1.4-1.6-1.5-2.7l-0.6-16.4c-0.1-1.9,1.4-3.6,3.4-3.6 c1.9-0.1,3.6,1.4,3.6,3.4l0.5,14.7L85,75.5c1.6,1.1,1.9,3.3,0.8,4.9C85.2,81.3,84.1,81.8,83,81.8z"/><path class="st0" d="M40,23.6H19.5c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5H40c1.9,0,3.5,1.6,3.5,3.5S41.9,23.6,40,23.6z"/><path class="st0" d="M25.8,36.7h-6.3c-1.9,0-3.5-1.6-3.5-3.5s1.6-3.5,3.5-3.5h6.3c1.9,0,3.5,1.6,3.5,3.5S27.7,36.7,25.8,36.7z"/></g></g></svg>
							</i>{{ trans('messages.tracking_log') }}
									</a>
								</li>
							@endif
							@if (Auth::user()->admin->getPermission("report_bounce_log") != 'no')
								<li class="nav-item" rel0="BounceLogController">
									<a href="{{ action('Admin\BounceLogController@index') }}" class="dropdown-item d-flex align-items-center">
									<i class="navbar-icon">
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 104.9 94.5" style="enable-background:new 0 0 104.9 94.5;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M70.9,94.5H14c-7.7,0-14-6.3-14-14c0,0,0-0.1,0-0.2l0-56.8c0-7.7,6.3-14,14-14h28.5c1.9,0,3.5,1.6,3.5,3.5 s-1.6,3.5-3.5,3.5H14c-3.9,0-7,3.1-7,7v56.9c0,4,3.1,7.1,7,7.1h56.9c3.9,0,7-3.2,7-7.1V52.1c0-1.9,1.6-3.5,3.5-3.5 s3.5,1.6,3.5,3.5v28.3c0.1,7.7-6.1,14-13.9,14.1C71,94.5,70.9,94.5,70.9,94.5z"/><path class="st0" d="M43.1,55.6c-0.4,0-0.8-0.1-1.2-0.2c-1.8-0.7-2.8-2.7-2.1-4.5c3.1-8.5,10.8-24,28.1-33 c1.7-0.9,3.8-0.2,4.7,1.5c0.9,1.7,0.2,3.8-1.5,4.7c-15.7,8.2-22.5,23.1-24.7,29.2C45.9,54.7,44.5,55.6,43.1,55.6z"/><polygon class="st0" points="67.5,48.6 104.9,16.1 58,0 "/></g></g></svg>
							</i>{{ trans('messages.bounce_log') }}
									</a>
								</li>
							@endif
							@if (Auth::user()->admin->getPermission("report_feedback_log") != 'no')
								<li class="nav-item" rel0="FeedbackLogController">
									<a href="{{ action('Admin\FeedbackLogController@index') }}" class="dropdown-item d-flex align-items-center">
									<i class="navbar-icon">
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 111.9 86.9" style="enable-background:new 0 0 111.9 86.9;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><path class="st0" d="M93.4,46.2c-2.8,0-5-2.2-5-5V17.5c0-4.1-3.3-7.5-7.4-7.5H18.4c-2.8,0-5-2.2-5-5s2.2-5,5-5H81 c9.6,0.1,17.4,7.9,17.4,17.5v23.7C98.4,44,96.2,46.2,93.4,46.2z"/><polygon class="st0" points="75,35.8 93.4,67.8 111.9,35.8 "/><path class="st0" d="M93.4,86.9H30.9c-9.6,0-17.5-7.9-17.5-17.5v-24c0-2.8,2.2-5,5-5s5,2.2,5,5v24c0,4.1,3.4,7.5,7.5,7.5h62.5 c2.8,0,5,2.2,5,5S96.2,86.9,93.4,86.9z"/><polygon class="st0" points="36.9,50.8 18.4,18.9 0,50.8 "/></g></g></svg>
							</i>{{ trans('messages.feedback_log') }}
									</a>
								</li>
							@endif
							@if (Auth::user()->admin->getPermission("report_open_log") != 'no')
								<li class="nav-item" rel0="OpenLogController">
									<a href="{{ action('Admin\OpenLogController@index') }}" class="dropdown-item d-flex align-items-center">
									<i class="navbar-icon">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 105 105" style="enable-background:new 0 0 105 105;" xml:space="preserve"><style type="text/css">.st0{fill-rule:evenodd;clip-rule:evenodd;fill:#333333;}.st1{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><g id="Page-1"><g id="icon-5-mail-envelope-open"><g><path id="mail-envelope-open_1_" class="st0" d="M53.8,73.4h6.6l26.8-22.2V20.8c-0.1-2.2-1.8-3.9-4-3.8c0,0-0.1,0-0.1,0H21.9 c-2.2-0.1-4,1.5-4.1,3.7c0,0,0,0,0,0v30.9l26.8,21.7L53.8,73.4z M38.6,13.2L52.5,1.9l13.9,11.3h16.7c4.6,0,8.2,3.4,8.2,7.5 v12.7l12.2,9.9V96c0,4.1-3.6,7.5-8.1,7.5H9.7c-4.6,0-8.2-3.4-8.2-7.5V43.3l12.2-9.9V20.7c0-4.1,3.7-7.5,8.2-7.5L38.6,13.2z M60.4,13.2l-7.9-6.4l-7.8,6.4L60.4,13.2z M91.3,38.3l6.1,5l-6.1,5V38.3z M13.7,48.3l-6.1-5l6.1-5V48.3z M40.3,77.2L11.7,99.7 h81.6L64.8,77.2H40.3z M98.2,98.7L66.8,73.5l32.7-26.4V96C99.5,97,99,98,98.2,98.7z M6.9,98.7l31.3-25.2L5.6,47.1V96 C5.6,97,6.1,98,6.9,98.7z"/><path class="st1" d="M95.4,105H9.7c-5.3,0-9.7-4-9.7-9V42.6l12.2-9.9v-12c0-5,4.4-9,9.7-9h16.2L52.5,0l14.4,11.7h16.2 c5.3,0,9.7,4,9.7,9v12l12.2,9.9V96C105,101,100.7,105,95.4,105z M3,44v52c0,3.3,3,6,6.7,6h85.7c3.6,0,6.6-2.7,6.6-6V44 l-12.2-9.9V20.7c0-3.3-3-6-6.7-6H65.9L52.5,3.8L39.1,14.7H21.9c-3.6,0-6.7,2.7-6.7,6v13.4L3,44z M97.6,101.2H7.4l32.4-25.5 h25.5L97.6,101.2z M16,98.2H89L64.3,78.7H40.8L16,98.2z M6.9,100.6l-0.9-0.8c-1.1-0.9-1.8-2.3-1.8-3.8l0-52.1l36.5,29.5 L6.9,100.6z M7.1,50.2V96c0,0.2,0,0.4,0.1,0.5l28.6-23L7.1,50.2z M98.2,100.6L64.4,73.5L101,44v52c0,1.5-0.7,2.9-1.8,3.8 L98.2,100.6z M69.2,73.5l28.7,23C98,96.3,98,96.2,98,96l0-45.7L69.2,73.5z M60.9,74.9h-7.2l-9.7-0.1L16.3,52.3l0-31.8 c0.3-3,2.8-5.2,5.7-5l61.2,0c2.9-0.1,5.4,2.3,5.5,5.3v31.1L60.9,74.9z M53.8,71.9h6.1l25.8-21.4V20.8c0-1.3-1.1-2.3-2.4-2.3 c0,0,0,0-0.1,0l-0.1,0H21.9c-0.7,0-1.3,0.2-1.8,0.6c-0.5,0.4-0.7,1-0.8,1.6v30.1l25.8,20.9L53.8,71.9z M15.2,51.5l-10-8.2 l10-8.2V51.5z M10,43.3l2.2,1.8v-3.7L10,43.3z M89.8,51.5V35.1l10,8.2L89.8,51.5z M92.8,41.5v3.7l2.2-1.8L92.8,41.5z M64.6,14.7H40.5l12-9.8L64.6,14.7z M48.9,11.7h7.3l-3.7-3L48.9,11.7z"/></g></g></g></g></g></svg>
							</i>{{ trans('messages.open_log') }}
									</a>
								</li>
							@endif
							@if (Auth::user()->admin->getPermission("report_click_log") != 'no')
								<li class="nav-item" rel0="ClickLogController">
									<a href="{{ action('Admin\ClickLogController@index') }}" class="dropdown-item d-flex align-items-center">
									<i class="navbar-icon">
										<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 106.7 117.1"><defs><style>.cls-1{fill:#333;}</style></defs><g id="Layer_2" data-name="Layer 2"><g id="Layer_1-2" data-name="Layer 1"><path class="cls-1" d="M77,117.1c-5.8,0-11.5-2.9-14.2-7.8L55,96.4l-4.4,7.5-.4.5c-2.9,3.6-7.7,4.9-11.2,4.9h-.1A17.9,17.9,0,0,1,28,105.2a13.6,13.6,0,0,1-4.7-10.1V35.9c0-5.4,3.5-10.2,9-12.5a17.3,17.3,0,0,1,16.5,1.9L83,47.7a4.2,4.2,0,0,1,1,6.4,5.5,5.5,0,0,1-7.2,1L42.5,32.6l-.3-.2a5.8,5.8,0,0,0-5.5-.7,4.7,4.7,0,0,0-3,4.2V95.1a5.3,5.3,0,0,0,5.2,5H39a4,4,0,0,0,2.6-.8l8.8-14.8A5.2,5.2,0,0,1,55,82.1h0a5.3,5.3,0,0,1,4.6,2.4L72,105.1v.2a5.6,5.6,0,0,0,7,2.2,5,5,0,0,0,2.8-2.7,3.9,3.9,0,0,0-.2-3.5L69.1,81.6a4.1,4.1,0,0,1,.1-4.6,5.3,5.3,0,0,1,4.5-2.3H91.4a5,5,0,0,0,4.5-2.8,4.1,4.1,0,0,0-1-5,4.3,4.3,0,0,1,.2-6.5,5.9,5.9,0,0,1,7.4.2,12.5,12.5,0,0,1,3,14.7c-2.3,5.1-7.6,8.4-13.8,8.6H82.5L90.9,97v.2a12.2,12.2,0,0,1,.7,10.7,15.1,15.1,0,0,1-8.2,7.9A16.4,16.4,0,0,1,77,117.1ZM29.2,18a4.5,4.5,0,0,0,2.1-6.3l-4.4-7a5.5,5.5,0,0,0-7.1-1.8,4.3,4.3,0,0,0-2,6.2l4.4,7a5.1,5.1,0,0,0,4.5,2.4A7,7,0,0,0,29.2,18Zm-11,10.4a4.4,4.4,0,0,0-2.6-6.1L7.3,19.1A5.6,5.6,0,0,0,.4,21.5a4.4,4.4,0,0,0,2.7,6l8.3,3.2a5.2,5.2,0,0,0,2.1.4A5.1,5.1,0,0,0,18.2,28.4ZM50.6,13.6,53.4,6c.9-2.4-.5-5-3.3-5.8a5.3,5.3,0,0,0-6.5,2.9l-2.9,7.6c-.9,2.4.6,5,3.3,5.8l1.6.2A5.3,5.3,0,0,0,50.6,13.6ZM64.3,25.2l7-4.6a4.2,4.2,0,0,0,1.1-6.4,5.8,5.8,0,0,0-7.3-1l-7,4.6A4.2,4.2,0,0,0,57,24.2a5.7,5.7,0,0,0,4.2,1.9A5.6,5.6,0,0,0,64.3,25.2ZM7.6,50.9l7.8-2.8c2.7-.9,4-3.6,2.9-5.9a5.4,5.4,0,0,0-6.7-2.5L3.8,42.4c-2.7.9-4,3.6-2.9,5.9a5.1,5.1,0,0,0,4.8,2.9A6.3,6.3,0,0,0,7.6,50.9Z"/></g></g></svg>
							</i>{{ trans('messages.click_log') }}
									</a>
								</li>
							@endif
							@if (Auth::user()->admin->getPermission("report_unsubscribe_log") != 'no')
								<li class="nav-item" rel0="UnsubscribeLogController">
									<a href="{{ action('Admin\UnsubscribeLogController@index') }}" class="dropdown-item d-flex align-items-center">
									<i class="navbar-icon">
								<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 106.8 99.7" style="enable-background:new 0 0 106.8 99.7;" xml:space="preserve"><style type="text/css">.st0{fill:#333333;}</style><g id="Layer_2_1_"><g id="Layer_1-2"><g><path class="st0" d="M11.2,0.5C5.3,0.5,0.5,5.3,0.5,11.2v57c0.1,5.9,4.8,10.6,10.7,10.7h46.3v-7.1H11.2c-2,0-3.6-1.6-3.6-3.6 V14.4L50.4,44l42.7-29.6v28.8h7.1v-32c0-5.9-4.7-10.6-10.6-10.7H11.2z M11.2,7.6h78.4l0.6,0.2L50.4,35.4L10.5,7.8L11.2,7.6z M63.6,51.4l-5.1,5.1l18.9,18.8L58.5,94.2l5.1,5l18.8-18.8l18.9,18.8l5-5L87.5,75.3l18.8-18.8l-5-5.1L82.4,70.3L63.6,51.4z"/><path class="st0" d="M63.6,99.7c-0.1,0-0.3,0-0.3-0.1l-5.1-5c-0.1-0.1-0.1-0.2-0.2-0.4c0-0.1,0.1-0.3,0.1-0.4l18.5-18.5 L58.1,56.9c-0.1-0.1-0.1-0.2-0.1-0.4s0.1-0.3,0.1-0.4l5.1-5.1c0.1-0.1,0.2-0.1,0.4-0.1c0,0,0,0,0,0c0.1,0,0.3,0.1,0.4,0.1 l18.4,18.5L100.9,51c0.1-0.1,0.2-0.1,0.4-0.1c0.1,0,0.3,0.1,0.4,0.2l5,5.1c0.2,0.2,0.2,0.5,0,0.7L88.2,75.3l18.4,18.5 c0.2,0.2,0.2,0.5,0,0.7l-5,5c-0.2,0.2-0.5,0.2-0.7,0L82.4,81.1L64,99.6C63.9,99.7,63.7,99.7,63.6,99.7z M59.2,94.2l4.4,4.3L82,80 c0.2-0.2,0.5-0.2,0.7,0l18.5,18.4l4.3-4.3L87.1,75.7c-0.2-0.2-0.2-0.5,0-0.7l18.4-18.5l-4.3-4.4L82.8,70.7 c-0.1,0.1-0.2,0.1-0.4,0.1c0,0,0,0,0,0c-0.1,0-0.3-0.1-0.4-0.1L63.6,52.1l-4.4,4.4l18.5,18.4c0.1,0.1,0.1,0.2,0.1,0.4 s-0.1,0.3-0.1,0.4L59.2,94.2z M57.5,79.4H11.2C5.1,79.3,0.1,74.3,0,68.2v-57C0,5,5,0,11.2,0h78.4c6.1,0.1,11.1,5.1,11.1,11.2v32 c0,0.3-0.2,0.5-0.5,0.5h-7.1c-0.3,0-0.5-0.2-0.5-0.5V15.4L50.7,44.4c-0.2,0.1-0.4,0.1-0.6,0l-42-29.1v52.8c0,1.7,1.4,3.1,3.1,3.1 h46.3c0.3,0,0.5,0.2,0.5,0.5v7.1C58,79.2,57.8,79.4,57.5,79.4z M89.6,1H11.2C5.6,1,1,5.6,1,11.2v57c0.1,5.6,4.6,10.1,10.2,10.2 H57v-6.1H11.2c-2.3,0-4.1-1.8-4.1-4.1V14.4c0-0.2,0.1-0.4,0.3-0.4c0.2-0.1,0.4-0.1,0.5,0l42.5,29.4L92.8,14 c0.2-0.1,0.4-0.1,0.5,0c0.2,0.1,0.3,0.3,0.3,0.4v28.3h6.1V11.2C99.7,5.6,95.2,1.1,89.6,1z M50.4,35.9c-0.1,0-0.2,0-0.3-0.1 L10.2,8.2C10.1,8.1,10,7.9,10,7.7c0-0.2,0.2-0.3,0.4-0.4l0.7-0.2c0,0,0.1,0,0.1,0h78.4c0.1,0,0.1,0,0.2,0l0.6,0.2 c0.2,0.1,0.3,0.2,0.3,0.4c0,0.2-0.1,0.4-0.2,0.5L50.7,35.8C50.6,35.9,50.5,35.9,50.4,35.9z M11.8,8.1l38.6,26.7L88.9,8.1H11.8z"/></g></g></g></svg>
							</i>{{ trans('messages.unsubscribe_log') }}
									</a>
								</li>
							@endif
						</ul>
					</li>
				@endif
            </ul>
            <div class="navbar-right">
                <ul class="navbar-nav me-auto mb-md-0">
                    @include('layouts.core._top_notifications')
                    
                    @include('layouts.core._menu_frontend_user')
                </ul>
            </div>
        </div>
    </div>
</nav>

<script>
    var MenuFrontend = {
        saveLeftbarState: function(state) {
            var url = '{{ action('AccountController@leftbarState') }}';

            $.ajax({
                method: "GET",
                url: url,
                data: {
                    _token: CSRF_TOKEN,
                    state: state,
                }
            });
        }
    };

    $(function() {
        //
        $('.leftbar .leftbar-hide-menu').on('click', function(e) {
            if (!$('.leftbar').hasClass('leftbar-closed')) {
                $('.leftbar').addClass('leftbar-closed');

                MenuFrontend.saveLeftbarState('closed');
            } else {
                $('.leftbar').removeClass('leftbar-closed');

                MenuFrontend.saveLeftbarState('open');
            }
        });
    });        
</script>
