var Builder =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 28);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return createElementFromHTML; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return makeid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Editor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return simulateClick; });
/* harmony import */ var _elements__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _elements__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_elements__WEBPACK_IMPORTED_MODULE_0__);
/* Editor
* + init()
* + elementFactory(htmlObj)
* + select(Element)
* + unselect()
* + duplicate()
*
* Sidebar
* + load
* + renderAttribute
*
*/



function createElementFromHTML(htmlString) {
  var div = document.createElement('div');
  div.innerHTML = htmlString.trim();

  // Change this to div.childNodes to support multiple top-level nodes
  return div.childNodes;
}

function simulateClick(x,y){
    var ev = document.createEvent("MouseEvent");
    var el = document.elementFromPoint(x,y);
    ev.initMouseEvent(
        "click",
        true /* bubble */, true /* cancelable */,
        window, null,
        x, y, 0, 0, /* coordinates */
        false, false, false, false, /* modifier keys */
        0 /*left*/, null
    );
    el.dispatchEvent(ev);
}

function makeid() {
    var text = "";
    var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    for (var i = 0; i < 5; i++)
        text += possible.charAt(Math.floor(Math.random() * possible.length));

    return text;
}

var Editor = function(options) {
    var thisEditor = this;
    window.currentEditor = thisEditor;

    // ifram contents
    thisEditor.getIframeContent = function() {
        return $("#builder_iframe").contents();
    };

    // default strict
    thisEditor.strict = true;

    // default help button
    thisEditor.showHelp = true;

    // before save events
    thisEditor.beforeSaveEvents = [];

    // Set params cho object tu options
    // Vi du: editor.saveAssetUrl
    var keys =  Object.keys(options);
    for (var i = 0; i < keys.length; i += 1) {
        var key = keys[i];
        var value = options[key];
        this[key] = value;
    }

    // fix root path
    thisEditor.root = thisEditor.root.trim();
    if (thisEditor.root.slice(-1) !== '/') {
        thisEditor.root = thisEditor.root + '/';
    }

    if (typeof(window.CSRF_TOKEN) == 'undefined') {
        window.CSRF_TOKEN = '';
    }

    // check language
    if(typeof(this.language) == 'undefined') {
        this.language = 'en';
    }

    // save check anchor
    this.saveAchor = 0;
};

Editor.prototype = {

    addBeforeSaveEvent: function(event) {
        this.beforeSaveEvents.push(event);
    },

    runBeforeSaveEvents: function(event) {
        this.beforeSaveEvents.forEach(function(event) {
            event();
        });
    },

    // change loading message
    loadingSetMessage: function (data) {
        $('.loading-page-overlay label').html(data);
    },

    // hide loading effect when done
    done: function () {
        var thisEditor = this;

        $('.loading-page-overlay').remove();

        // loaded callback
        if (thisEditor.loaded) {
            thisEditor.loaded();
        }
    },

    historyGoto: function(achor) {
        var thisEditor = this;

        // move record postion -1
        thisEditor.currentRecordAchor = achor;

        // get old content
        var content = thisEditor.history()[thisEditor.currentRecordAchor].contents;
        //var content = thisEditor.history()[thisEditor.currentRecordAchor];

        // change content
        $("#builder_iframe").contents().find("body").html(content);

        //check undo hide
        thisEditor.historyToggleButton();

        // update history list
        thisEditor.listHistory();

        // check empty
        thisEditor.checkEmpty();
    },

    undo: function() {
        var thisEditor = this;

        // check if has no old record
        if (thisEditor.currentRecordAchor <= 0) {
            return;
        }

        // got to history node
        thisEditor.historyGoto(thisEditor.currentRecordAchor - 1);
    },

    redo: function() {
        var thisEditor = this;

        // check if has no new record
        if (thisEditor.currentRecordAchor >= thisEditor.history().length - 1) {
            return;
        }

        // got to history node
        thisEditor.historyGoto(thisEditor.currentRecordAchor + 1);
    },

    history: function() {
        var thisEditor = this;

        // init history records
        if (typeof(thisEditor.historyRecords) == 'undefined') {
            thisEditor.historyRecords = [];

            // toggle button
            thisEditor.historyToggleButton();

            // HISTORY LIST BUTTON EVENT
            // got to history event
            $(document).on('click', 'li.history_add, .history-item', function() {
                var id = $(this).attr('data-achor');
                thisEditor.historyGoto(id);
            });
        }

        return thisEditor.historyRecords;
    },

    historyToggleButton: function() {
        var thisEditor = this;
        var canUndo = thisEditor.currentRecordAchor > 0;
        var canRedo = thisEditor.currentRecordAchor < thisEditor.history().length - 1;

        // can redo
        if (canRedo == true) {
            $('.undo-redo-action-redo').removeClass('disable-redo');
            $('.action.redo').removeClass('disabled');
        } else {
            $('.undo-redo-action-redo').addClass('disable-redo');
            $('.action.redo').addClass('disabled');
        }

        // can undo
        if (canUndo == true) {
            $('.undo-redo-action-undo').removeClass('disable-undo');
            $('.action.undo').removeClass('disabled');
        } else {
            $('.undo-redo-action-undo').addClass('disable-undo');
            $('.action.undo').addClass('disabled');
        }

        //can not undo-redo
        if (canRedo == false && canUndo == false) {
            $('.undo-redo').hide();
        } else {
            $('.undo-redo').show();
        }
    },

    formatDate: function(date) {
        var hours = date.getHours();
        var minutes = date.getMinutes();
        var seconds = date.getSeconds();
        var ampm = hours >= 12 ? 'PM' : 'AM';
        hours = hours % 12;
        hours = hours ? hours : 12; // the hour '0' should be '12'
        minutes = minutes < 10 ? '0'+minutes : minutes;
        seconds = seconds < 10 ? '0'+seconds : seconds;
        var strTime = hours + ':' + minutes + ':' + seconds + ' ' + ampm;
        return date.getMonth()+1 + "/" + date.getDate() + "/" + date.getFullYear() + " - " + strTime;
    },

    recordState: function(title = getI18n('mess_open'), icon = 'fa fa-list-alt') {
        var thisEditor = this;
        var content = $("#builder_iframe").contents().find("html").html();

        // // remove inline edit
        // if (thisEditor.selected != null) {
        //     // editor
        //     thisEditor.removeInlineEdit(thisEditor.selected.obj);
        // }

        //get datatime now
        var dt = new Date();
        var time = thisEditor.formatDate(dt);

        // gioi han mang records
        if (thisEditor.history().length == 10) {
            thisEditor.history().shift();
        }

        // check if history is not empty and content has no change
        if (typeof(thisEditor.currentRecordAchor) != 'undefined' && content == thisEditor.history()[thisEditor.currentRecordAchor]) {
            return;
        }

        // remove after state
        thisEditor.historyRecords = thisEditor.historyRecords.slice(0, thisEditor.currentRecordAchor+1);

        thisEditor.history().push({contents: content, title: title, icon: icon, time: time});

        // set history current position to the last record
        thisEditor.currentRecordAchor = thisEditor.history().length - 1;

        // toggle button
        thisEditor.historyToggleButton();

        // update history list
        thisEditor.listHistory();
    },

    mask: function() {
        $('div.loadding-indicator').show();
    },

    unmask: function() {
        $('div.loadding-indicator').hide();
    },

    closePreview: function () {
        $('div.showPreview').hide();
        $('#modal-preview-desktop').show();
        $('.click-active-preview').removeClass('active-preview');
    },

    cleanUpContent: function() {
        // unselect
        this.unselect();

        // remove additional classes
        $("#builder_iframe").contents().find("*").removeClass (function (index, className) {
            return (className.match (/builder-class[a-zA-Z0-9\_\-]+/g) || []).join(' ');
        });

        // remove builder-tool
        $("#builder_iframe").contents().find('.builder-tool').remove();

        // remove notebook editor
        $("#builder_iframe").contents().find("[id^=jquery-notebook-content-]").remove();

        // remove inline edit
        this.removeInlineEdit();
    },

    cleanupHtml: function(html) {
        html = html.replace(/element-selected/g, '').replace(/builder-outline-move-hook/g, '').replace(/builder-outline-selected-controls/g, '');
        html = html.replace(/(<link([^>]+)builder\-helper([^>]+)>)/ig,"").replace(/(<script([^>]+)builder\-helper([^>]+)>\<\/script>)/ig,"");

        return html;
    },

    getContent: function() {
        var thisEditor = this;

        // cleanup content
        var content = $("#builder_iframe").contents().find("html")[0].outerHTML;
        content = this.cleanupHtml(content);

        // standard mode fix
        if (!content.toLowerCase().includes('DOCTYPE html'.toLowerCase())) {
            content = '<!DOCTYPE html>' + content;
        }

        return content;
    },

    save: function(callback) {
        var thisEditor = this;
        var url = thisEditor.saveUrl;

        // before save events
        thisEditor.runBeforeSaveEvents();

        // cleanup content before save
        thisEditor.cleanUpContent();

        // save saveAchor
        thisEditor.saveAchor = thisEditor.currentRecordAchor;

        // get save content
        var content = thisEditor.getContent();

        var requestMethod = thisEditor.uploadAssetMethod;
        var notSupportedMethods = [ 'PUT', 'PATCH', 'TRACE', 'OPTIONS', 'DELETE', 'HEAD', 'CONNECT' ];
        if (typeof(requestMethod) == 'undefined' || notSupportedMethods.includes( requestMethod.toUpperCase())) {
            requestMethod = 'POST';
        } 

        $('button.btn-save').attr("disabled", 'disabled');
        $('button.btn-save').html('<div class="loader-save"></div>');
        thisEditor.mask();
        setTimeout(function() {
            thisEditor.unmask();
            $('button.btn-save').removeAttr("disabled", 'disabled');
            $('button.btn-save').html(getI18n('save'));

            var data = {
                _token: CSRF_TOKEN,
                content: content,
                _method: requestMethod
            }

            if (thisEditor.data !== null) {
                data = $.extend({}, data, thisEditor.data);
            }

            $.ajax({
                url: url,
                type: requestMethod,
                dataType: 'json',
                data: data,
            }).done(function(data, textStatus, jqXHR) { // jqXHR.status == 200
                if (jqXHR.status == 200) {
                    // Okie, done, redirect to index
                    //var time = 'Last saved at '+ data['last_updated'];
                    //var html = '<span style="font-size: 13px;height: 100%;display: flex;align-items: center;justify-content: flex-end;">'+time+'</span>';
                    var content = getI18n('update_content');
                    editor.notificationArea(content);
                    //$('.footer .footer-right').html(html);
                    //$('.footer .footer-right span').show();
                    $('button.btn-save').removeAttr("disabled", 'disabled');
                    $('button.btn-save').html('Save');
                    
                    // callback
                    if (typeof(callback) !== 'undefined') {
                        callback();
                    }

                    // after save callback
                    if (typeof(thisEditor.callbacks) !== 'undefined') {
                        if (typeof(thisEditor.callbacks.afterSave) !== 'undefined') {
                            thisEditor.callbacks.afterSave();
                        }
                    }
                } else {
                    alert('Failed to save');
                    $('button.btn-save').removeAttr("disabled", 'disabled');
                    $('button.btn-save').html('Save');
                    // Tr ve form voi error messaqge ==> thanh cong 200!
                }

                // save current content
                thisEditor.initContent = thisEditor.getContent();
            }).fail(function(jqXHR, textStatus, errorThrown) { // jqXHR.status = 5xx hoac 4xx
                try {
                    $.parseJSON(jqXHR.responseText);
                }
                catch(err) {
                    Swal.fire({
                        title: getI18n('error_job'),
                        text: jqXHR.responseText,
                        type: "error",
                    });
                    return;
                }
                Swal.fire({
                    title: getI18n('error_job'),
                    text: ($.parseJSON(jqXHR.responseText).message),
                    type: "error",
                });
            });
        }, 500);
    },

    uploadTemplate: function(url) {
        var thisEditor = this;
        var callback = thisEditor.url;
        var requestMethod = thisEditor.uploadAssetMethod;

        var notSupportedMethods = [ 'PUT', 'PATCH', 'TRACE', 'OPTIONS', 'DELETE', 'HEAD', 'CONNECT' ];
        if (notSupportedMethods.includes( requestMethod.toUpperCase())) {
            requestMethod = 'POST';
        }

        //var file = $('.file-upload-template')[0].files[0];
        var file = $('.file-upload-template').prop('files')[0];
        var formData = new FormData();
        formData.append('file', file);
        formData.append('action', 'upload');

        if (thisEditor.data !== null) {
            for ( var key in thisEditor.data ) {
               formData.append(key, thisEditor.data[key]);
           }
        }

        $.ajax({
            url: url,
            type: requestMethod,
            dataType: 'json',
            contentType: false,
            processData: false,
            data : formData,
        }).done(function(data, textStatus, jqXHR) { // jqXHR.status == 200
            if (jqXHR.status == 200) {
                // Okie, done, redirect to index
                var popup = new PopUp();
                popup.hide();
                //alert('Upload template success!');
                Swal.fire({
                      title: getI18n('good_job'),
                      text: getI18n('upload_success'),
                      type: "success",
                }).then((result) => {
                    // window.location = window.location.origin + '/design.php?id=' + data.url + '&type=other';
                    if (thisEditor.uploadTemplateCallback) {
                        thisEditor.uploadTemplateCallback(data);
                    }
                });
            } else {
                alert(jqXHR.responseText);
            }
        }).fail(function(jqXHR, textStatus, errorThrown) { // jqXHR.status = 5xx hoac 4xx
            //var json = $.parseJSON(jqXHR.responseText);
            alert('Error while upload file:' + jqXHR.responseText.error);
        });
    },

    changeTemplate: function(url) {
        var thisEditor = this;

        // checl if has callback for changing template
        if (typeof(thisEditor.changeTemplateCallback) != 'undefined') {
          Swal.fire({
              title: getI18n('are_you_sure'),
              text: getI18n('text_are_you'),
              type: 'warning',
              showCancelButton: true,
              confirmButtonColor: '#3085d6',
              cancelButtonColor: '#d33',
              confirmButtonText: getI18n('confirm_apply')
          }).then((result) => {
              if (result.value) {
                  Swal.fire({
                      title: getI18n('good_job'),
                      text: getI18n('success_aplly'),
                      type: "success",
                  }).then((result) => {
                      thisEditor.changeTemplateCallback(url);
                  });
              }
          });
          return;
        }

        var data = {
            _token: CSRF_TOKEN
        }

        if (thisEditor.data !== null) {
            data = $.extend({}, data, thisEditor.data);
        }

        $.ajax({
            url: url,
            type: 'GET',
            data: {
                _token: CSRF_TOKEN
            },
        }).done(function(data, textStatus, jqXHR) { // jqXHR.status == 200
            if (jqXHR.status == 200) {
                // Okie, done, redirect to index
                Swal.fire({
                    title: getI18n('good_job'),
                    text: getI18n('success_aplly'),
                    type: "success",
                }).then((result) => {
                    location.reload();
                });
            } else {
                alert('Failed choose');
                // Tr ve form voi error messaqge ==> thanh cong 200!
            }
        }).fail(function(jqXHR, textStatus, errorThrown) { // jqXHR.status = 5xx hoac 4xx
            alert(getI18n('error_save') + errorThrown);
        });
    },

    back: function() {
        var thisEditor = this;
        
        var changed = (thisEditor.saveAchor != thisEditor.currentRecordAchor);

        if (changed) {
            Swal.fire({
                title: getI18n('are_you_sure'),
                text: getI18n('text_back'),
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: getI18n('ok')
            }).then((result) => {
                if (result.value) {
                    // check if builder has backCallback
                    if (typeof(thisEditor.backCallback) !== 'undefined') {
                        thisEditor.backCallback();
                    } else {
                        window.location.href = this.urlBack;
                    }
                }
            });
        } else {
            // check if builder has backCallback
            if (typeof(thisEditor.backCallback) !== 'undefined') {
                thisEditor.backCallback();
            } else {
                window.location.href = this.urlBack;
            }
        }
    },

    synchronization: function(data) {
        var sync = $(data).attr('data-sync');
        $('button.btn-sync').find('i').removeClass('fab fa-google');
        $('button.btn-sync').find('i').removeClass('fab fa-dropbox');
        $('button.btn-sync').find('i').removeClass('fab fa-google-drive');

        if ( sync == 'google-driver' ) {
            $('button.btn-sync').find('i').addClass('fab fa-google');
        } else if ( sync == 'dropbox' ) {
            $('button.btn-sync').find('i').addClass('fab fa-dropbox');
        } else if ( sync == 'one-driver' ) {
            $('button.btn-sync').find('i').addClass('fab fa-google-drive');
        }
        $('ul.action-sync').removeClass('show-action');
    },

    settingSync: function() {
        $('ul.action-sync').removeClass('show-action');
        Swal.fire({
            title: getI18n('setting_title'),
            text: getI18n('setting_text'),
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: getI18n('ok')
          }).then((result) => {
            if (result.value) {

            }
        });
    },

    addDragShadow(shadow_html) {
        var thisEditor = this;

        // init shadow box
        thisEditor.dragShadow = $('.drag-shadow');
        if (!thisEditor.dragShadow.length) {
            var html = '<div class="drag-shadow"></div>';
            $('body').append(html);

            thisEditor.dragShadow = $('.drag-shadow');
        }

        // css drag shadow
        thisEditor.dragShadow.css('position', 'fixed');
        thisEditor.dragShadow.css('z-index', '10000');
        thisEditor.dragShadow.css('top', '0');
        thisEditor.dragShadow.css('left', '0');
        thisEditor.dragShadow.css('pointer-events', 'none');
        thisEditor.dragShadow.hide();

        // insert html shadow
        thisEditor.dragShadow.html(shadow_html);

        // move outside content
        $(document).on('mousemove', '*', function(e) {
            if (thisEditor.isDragging) {
                thisEditor.dragShadow.show();

                // posistion
                thisEditor.dragShadow.css('left', e.pageX + 5);
                thisEditor.dragShadow.css('top', e.pageY + 5);
            }
        });

        // mouse move in content, trigger drag shadow
        $("#builder_iframe").contents().on('mousemove', '*', function(e) {
            if (thisEditor.isDragging) {
                thisEditor.dragShadow.show();

                // find mouse posistion in iframe
                thisEditor.dragShadow.css('left', e.pageX + $("#builder_iframe").offset().left + 5);
                thisEditor.dragShadow.css('top', e.pageY + $("#builder_iframe").offset().top + 5);
            }
        });
    },

    drag: function(draggableItem, options) {
        var thisEditor = this;
        thisEditor.draggableItem = draggableItem;

        // unselect
        thisEditor.unselect();

        // set as dragging
        thisEditor.isDragging = true;

        // drag options
        if (typeof(options) !== 'undefined') {
            thisEditor.dragOptions = options;
        } else {
            thisEditor.dragOptions = {};
        }

        // set dropHtml
        thisEditor.dropHtml = thisEditor.transformHtml(draggableItem.dropHtml());

        // add drag shadow and mouse events
        thisEditor.addDragShadow(thisEditor.transformHtml(draggableItem.dragHtml()));
    },

    canDropInside: function(element) {
        var hasCell = this.dropHtml.includes('CellElement');
        var containerIsCell = element.obj.attr('builder-element') == 'CellElement';
        
        return element.isContainer() && !(hasCell && containerIsCell);
    },

    canDropBeside: function(element) {
        var hasCell = this.dropHtml.includes('CellElement');
        var insideCell = element.obj.closest('[builder-element="CellElement"]').length > 0;
        
        return !this.strict || (element.isDraggable() && !(hasCell && insideCell));
    },

    findClosestDraggableOrDroppableElement: function(target) {
        // check not strict
        if (!this.strict) {
            return this.elementFactory(target);
        }

        target = target.closest('[builder-element]');
        var element = this.elementFactory(target);

        // not inside any builder element
        if (element == null) {
            return element;
        }

        // look through parents element until found or null
        while(
            element.obj.parents('[builder-element]').length &&
            !this.canDropBeside(element) &&
            !this.canDropInside(element)
        ) {
            element = this.elementFactory(element.obj.parents('[builder-element]').first());
        }

        return element;
    },

    dragging: function (e) {
        var thisEditor = this;

        // remove all selection
        $("#builder_iframe")[0].contentWindow.getSelection().removeAllRanges();

        // find closest droppable|draggable element
        var element = thisEditor.findClosestDraggableOrDroppableElement($(e.target));

        // return if not found draggable | droppable element
        if (element == null) {
            return;
        }

        // CASE 1: element is container | droppable
        if (thisEditor.canDropInside(element)) {
            if (!element.obj.children().length) {
                element.dropInsideHighlight();
            }
        }

        // CASE 2: element is not container | draggable
        else if (thisEditor.canDropBeside(element)) {
            var pos = element.checkTargetPosition(e);

            if (pos == 'before') {
                element.beforeHighlight();
            } else if (pos == 'after')  {
                element.afterHighlight();
            }
        } else {
            return false;
        }
    },

    checkEmpty() {
        var thisEditor = this;

        $("#builder_iframe").contents().find("[builder-element='PageElement']").each(function() {
            if ($(this).html().trim() == '') {
                $(this).addClass('container-_blank');
                $(this).html('');
            } else {
                $(this).removeClass('container-_blank');
            }
        });

        // remove all space inside cells to make sure :empty css works
        $("#builder_iframe").contents().find("[builder-element='CellElement']").each(function() {
            if ($(this).html().trim() == '') {
                $(this).html('');
            }
        });

        // js auto height iframe
        thisEditor.adjustIframeSize();
    },

    drop: function(e) {
        var thisEditor = this;

        // check is dragging
        if (!thisEditor.isDragging) {
            return;
        }

        // remove effect
        thisEditor.dragShadow.remove();
        thisEditor.isDragging = false;

        // check if e present?
        if (typeof(e) == 'undefined') {
            return;
        }

        // init
        var element = thisEditor.findClosestDraggableOrDroppableElement($(e.target));

        if (element == null) {
            return;
        }

        // items before drop
        var items = $('<div>').html(thisEditor.dropHtml).children();

        // add block container
        if (!thisEditor.draggableItem.hasBlockContainer()) {
            var pItem = $(`
                <div builder-element="BlockElement" style="padding-top:15px;padding-bottom:15px">
                    <div class="container">
                    </div>
                </div>
            `);
            pItem.find('.container').eq(0).append(items);
            items = pItem;
        }

        // hide effects
        items.css('opacity', 0);        

        // CASE 1: element is container
        if (thisEditor.canDropInside(element)) {            
            // find postion vs element
            var pos = element.checkTargetPosition(e);

            if (pos == 'before') {
                // insert element
                element.obj.prepend(items);
            } else if (pos == 'after')  {
                // insert element
                element.obj.append(items);
            }
        }

        // CASE 2: element is not container
        else if (thisEditor.canDropBeside(element)) {
            // find postion vs element
            var pos = element.checkTargetPosition(e);

            if (pos == 'before') {
                // insert element
                element.obj.before(items);
            } else if (pos == 'after')  {
                // insert element
                element.obj.after(items);
            }
        } else {
            return false;
        }

        // items fater drop
        items.fadeTo(500, 1, function() {
            // unselect current
            thisEditor.unselect();
            thisEditor.hideControls();

            // save history
            thisEditor.recordState(getI18n('dropped'));

            // check empty
            thisEditor.checkEmpty();

            // after action
            if (typeof(thisEditor.dragOptions.drop) !== 'undefined') {
                thisEditor.dragOptions.drop();
            }
        });
    },

    // find mouse over element
    findMouseOverElement: function(e) {
        var elem = $($("#builder_iframe")[0].contentWindow.document.elementFromPoint(
            e.pageX + $("#builder_iframe").offset().left - $("#builder_iframe").contents().find("body").scrollLeft(),
            e.pageY + $("#builder_iframe").offset().top - $("#builder_iframe").contents().find("html").scrollTop()
        ));
        return elem.closest('[class*="col-"]');
    },

    initDrag: function() {
        var thisEditor = this;
        thisEditor.isDragging = false;

        // Click on widget
        $(document).on('mousedown', '.widget-item', function(e) {
            // click on remove widget
            if ($(e.target).closest('.remove-widget-button').length) {
                return;
            }

            var widget_id = $(this).attr('id');
            var widget_class = $(this).attr('class-name');
            var widget;
            
            // try to create new widget with new id
            if(widget_class == 'CustomWidget' || widget_class.endsWith("FieldWidget")) {
                widget = thisEditor.widgets[widget_id];
            } else {
                widget = eval(`new ${widget_class}()`);
            }

            thisEditor.drag(widget, {
                drop: function() {
                    if (typeof(widget.drop) !== 'undefined') {
                        widget.drop();
                    }
                }
            });
        });

        // drag over elements in content
        $("#builder_iframe").contents().find("body").on('mousemove', '*', function(e) {
            if(!thisEditor.isDragging) {
                return;
            }

            thisEditor.dragging(e);
        });

        // drop widget in content
        $("#builder_iframe").contents().find("html").on('mouseup', '*', function(e) {
            if(!thisEditor.isDragging) {
                return;
            }

            thisEditor.drop(e);

            // select again
            if (thisEditor.selected != null) {
                thisEditor.selected.select();
            }
        });

        // mouse up outside content
        $(document).on('mouseup', '*', function() {
            //// drop id has anything dragging
            thisEditor.drop();

            // select again
            if (thisEditor.selected != null) {
                thisEditor.selected.select();
            }
        });

        // mouse up outside content
        $("#builder_iframe").contents().find("body").on('mouseout', '*', function() {
            // remove all drop after effect
            $("#builder_iframe").contents().find('.drop-element-after-highlight').removeClass('drop-element-after-highlight');
            $("#builder_iframe").contents().find('.drop-element-after-hover').remove();
            $("#builder_iframe").contents().find('.builder-drop-after-element').removeClass('builder-drop-after-element');
            $("#builder_iframe").contents().find('.drop-element-before-hover').remove();
            $("#builder_iframe").contents().find('.builder-drop-before-element').removeClass('builder-drop-before-element');
            $("#builder_iframe").contents().find('.builder-class-drop-element-highlight').removeClass('builder-class-drop-element-highlight');
            $("#builder_iframe").contents().find('.builder-drop-outline').remove();
            $("#builder_iframe").contents().find('.drop-inside-label-hover').remove();
            $("#builder_iframe").contents().find('.builder-drop-inside-outline').remove();

            // other
            $("#builder_iframe").contents().find('.drop-row-after-highlight').removeClass('drop-row-after-highlight');
            $("#builder_iframe").contents().find('.col-hightlight').removeClass('col-hightlight');
        });

        // mouse up in content
        $("#builder_iframe").contents().find("body").on('mouseup', '*', function() {
            // remove all drop after effect
            $("#builder_iframe").contents().find('.drop-element-after-highlight').removeClass('drop-element-after-highlight');
            $("#builder_iframe").contents().find('.drop-element-after-hover').remove();
            $("#builder_iframe").contents().find('.builder-drop-after-element').removeClass('builder-drop-after-element');
            $("#builder_iframe").contents().find('.drop-element-before-hover').remove();
            $("#builder_iframe").contents().find('.builder-drop-before-element').removeClass('builder-drop-before-element');
            $("#builder_iframe").contents().find('.builder-class-drop-element-highlight').removeClass('builder-class-drop-element-highlight');
            $("#builder_iframe").contents().find('.builder-drop-outline').remove();
            $("#builder_iframe").contents().find('.drop-inside-label-hover').remove();
            $("#builder_iframe").contents().find('.builder-drop-inside-outline').remove();

            // other
            $("#builder_iframe").contents().find('.drop-row-after-highlight').removeClass('drop-row-after-highlight');
            $("#builder_iframe").contents().find('.col-hightlight').removeClass('col-hightlight');
        });

        // init moving element inside content
        $("#builder_iframe").contents().find("body").on('mousedown', '.builder-outline-move-hook', function(e) {
            var old = thisEditor.selected;

            // remove inline edit
            thisEditor.removeInlineEdit(thisEditor.selected.obj);

            // unselect effects
            thisEditor.selected.unselect();

            thisEditor.drag(
                thisEditor.selected,
                {
                    drop: function() {
                        old.obj.remove();
                    }
                }
            );
        });
    },

    inlineEdit: function(container) {
        var thisEditor = this; 

        // custom inline edit
        if (thisEditor.customInlineEdit) {
            thisEditor.customInlineEdit(container);
            return;
        }

        var types = 'li, p, h1, h2, h3, h4, h5, h6, a, span';

        // set true always check editor type
        if (thisEditor.inlineEditor == 'default') {
            // if (true || container.is(types)) {
            if (!container[0].hasAttribute('builder-no-inline-edit')) {
                container.notebook({
                    modifiers: ['bold', 'italic', 'underline', 'anchor']
                });
            }

            //if (container.is('div')) {
            //    if (container.children().length == 0) {
            //        container.notebook({
            //            modifiers: ['bold', 'italic', 'underline', 'anchor']
            //        });
            //    }
            //}
        } else if (thisEditor.inlineEditor == 'tinymce') {
            var toolbar = [
                'undo redo | bold italic underline fontsizeselect | link | menuDateButton',
                // 'forecolor backcolor | alignleft aligncenter alignright alignfull | numlist bullist outdent indent'
            ];
            if (typeof(thisEditor.showInlineToolbar) !== 'undefined' && thisEditor.showInlineToolbar == false) {
                toolbar = [];
            }
            var tinyconfig = {
                skin: 'oxide-dark',
                valid_elements: '*[*]',
                valid_children: '+h1[div],+h2[div],+h3[div],+h4[div],+h5[div],+h6[div],+a[div],*[*]',
                allow_html_in_named_anchor: true,
                inline: true,
                menubar: false,
                force_br_newlines : false,
                force_p_newlines : false,
                forced_root_block : '',
                relative_urls: false,
                convert_urls: false,
                remove_script_host : false,
                inline_boundaries: false,
                plugins: 'link lists autolink',
                //toolbar: 'undo redo | bold italic underline | fontselect fontsizeselect | forecolor backcolor | alignleft aligncenter alignright alignfull | numlist bullist outdent indent',
                toolbar: toolbar,
                setup: function (editor) {
                
                    /* Menu button that has a simple "insert date" menu item, and a submenu containing other formats. */
                    /* Clicking the first menu item or one of the submenu items inserts the date in the selected format. */
                    editor.ui.registry.addMenuButton('menuDateButton', {
                      text: getI18n('editor.insert_tag'),
                      fetch: function (callback) {
                        var items = [];

                        thisEditor.tags.forEach(function(tag) {
                            if ( tag.type == 'label') {
                                items.push({
                                    type: 'menuitem',
                                    text: tag.tag.replace("{", "").replace("}", ""),
                                    onAction: function (_) {
                                        if (tag.text) {
                                            editor.insertContent(tag.text);
                                        } else {
                                            editor.insertContent(tag.tag);
                                        }                                            
                                    }
                                });
                            }
                        });
                        
                        callback(items);
                      }
                    });

                    editor.on("change keyup", function(e){
                        if (typeof(thisEditor.inlineEditCallback) != 'undefined') {
                            thisEditor.inlineEditCallback(editor.getContent());
                        }
                    });
                }
            };

            var unsupported_types = 'td, table, img, body';
            if (!container.is(unsupported_types) && (container.is('[builder-inline-edit]') || !thisEditor.strict)) {
                container.addClass('builder-class-tinymce');
                tinyconfig.selector = '.builder-class-tinymce';
                thisEditor.tinymce = $("#builder_iframe")[0].contentWindow.tinymce.init(tinyconfig);

                container.removeClass('builder-class-tinymce');
            }

            // fixing td tinymce
            if (container.is('td')) {
                if (!container.find('.tinymce-td-fix').length) {
                    var span = $('<div class="tinymce-td-fix builder-class-tinymce">');
                    span.html(container.html());

                    container.html('');
                    container.append(span);

                    span.click();
                }
            }
        }
    },

    removeInlineEdit: function(container) {
        // remove tinymce instant
        $("#builder_iframe")[0].contentWindow.tinymce.remove();
    },

    loadIframeJs: function(jss, callback) {
        var thisEditor = this;

        if (jss.length > 0) {
            var s = document.createElement("script");
            var url = jss.shift();

            console.log("loading: " + url);

            s.type = "text/javascript";
            s.src = url;
            s.setAttribute('builder-helper', 'true')
            s.onload = function () {
                //
                thisEditor.loadIframeJs(jss, callback);
            };
            $("#builder_iframe")[0].contentWindow.document.head.appendChild(s);
        } else {
            if (typeof(callback) !== 'undefined') {
                callback();
            }
        }
    },

    includeIframeJs: function(jss, callback) {
        var thisEditor = this;

        if (jss.length > 0) {
            var s = document.createElement("script");
            var url = jss.shift();
            console.log("loading: " + url);
            s.type = "text/javascript";
            s.src = url;
            s.onload = function () {
                if (typeof(callback) !== 'undefined') {
                    callback();
                }

                //
                thisEditor.loadIframeJs(jss, callback);
            };
            $("#builder_iframe")[0].contentWindow.document.head.appendChild(s);
        }
    },

    loadPageJs: function(jss, callback) {
        var thisEditor = this;

        if (jss.length > 0) {
            var s = document.createElement("script");
            var url = jss.shift();

            console.log("loading: " + url);

            s.type = "text/javascript";
            s.src = url;
            s.setAttribute('builder-helper', 'true');
            s.onload = function () {
                //
                thisEditor.loadIframeJs(jss, callback);
            };
            window.document.head.appendChild(s);
        } else {
            if (typeof(callback) !== 'undefined') {
                callback();
            }
        }
    },

    setupIframe: function(callback) {
        var thisEditor = this;

        // code will run after iframe has finished loading        
        $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+thisEditor.root+'iframe/builder-frame.css">');
        $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">');
        $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons+Outlined">');
        if (thisEditor.iconStyle == 'default') {
            $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+thisEditor.root+'iframe/fontawesome-free/css/fontawesome.min.css">');
            $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+thisEditor.root+'iframe/fontawesome-free/css/brands.min.css">');
            $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+thisEditor.root+'iframe/fontawesome-free/css/solid.min.css">');
        } else if (thisEditor.iconStyle == 'fontawesome') {
            $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+thisEditor.root+'iframe/fontawesome/css/fontawesome.min.css">');
            $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+thisEditor.root+'iframe/fontawesome/css/light.min.css">');
            $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+thisEditor.root+'iframe/fontawesome/css/brands.min.css">');
        }
        $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+thisEditor.root+'iframe/autocomplete.css">');

        // Default js
        var jss = [thisEditor.root+'iframe/events.js', thisEditor.root+'iframe/jquery.min.js'];

        // Editor
        if (thisEditor.inlineEditor == 'default') {
            $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+thisEditor.root+'iframe/editor-notebook/src/js/jquery.notebook.css">');
            jss.push(thisEditor.root+'iframe/editor-notebook/src/js/jquery.notebook.js');
        } else if (thisEditor.inlineEditor == 'tinymce') {
            jss.push(thisEditor.root+'iframe/tinymce/tinymce.min.js');
        }

        // load js
        thisEditor.loadIframeJs(jss, function () {
            thisEditor.loadingSetMessage('Scripts were loaded...');

            if (typeof(callback) !== 'undefined') {
                callback();
            }
        });
    },

    initIframe: function() {
        var thisEditor = this;
        
        // content iframe after loaded listening
        thisEditor.iframe.on('load', function() {
            thisEditor.setupIframe(function() {
                thisEditor.loadingSetMessage('Finalizing...');

                // after iframe header loaded (all loaded)
                thisEditor.afterIframeLoaded();

                // callback
                if (typeof(thisEditor.iframeLoadedCallback) !== 'undefined') {
                    thisEditor.iframeLoadedCallback();
                }

                // 
                thisEditor.adjustIframeSize();

                // all done
                thisEditor.done();
            });
        });

        if (!thisEditor.url) {            
            var html = '<!DOCTYPE html><html lang="en"><head>' +
                '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">' +
                    '<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">' +
                    '<meta name="description" content="">' +
                    '<meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors">' +
                    '<meta name="generator" content="AcelleSystemLayouts">' +
                    '<title>Blank</title>' +
                '</head>' +
                '<body class="" style="width:auto">' +
                    '<div builder-element="PageElement">' +
                    '</div>' +
                '</body>' +
                '</html>';
            thisEditor.iframe.attr('srcdoc', html);
        } else {
            thisEditor.loadingSetMessage('Loading template...');
            thisEditor.loadUrl(thisEditor.url);
        }
    },

    loadHtml: function(html) {
        var thisEditor = this;

        // unselect
        thisEditor.unselect();
        thisEditor.hideControls();

        thisEditor.iframe.contents().find("body").html(html);

        // js auto height iframe
        thisEditor.adjustIframeSize();
    },

    loadUrl: function(url, callback) {
        var thisEditor = this;

        thisEditor.url = url;
        
        thisEditor.iframe.attr('src', thisEditor.url);

        if (typeof(callback) !== 'undefined') {
            thisEditor.iframeLoadedCallback = function() {
                callback();
            }
        };
    },

    load: function(html) {
        var thisEditor = this;

        thisEditor.iframeLoadedCallback = function() {
            thisEditor.loadHtml(html);
        };
    },

    handleAutocomplete: function() {
        var thisEditor = this;
        var tags = [];

        if (!thisEditor.tags) {
            return false;
        }

        thisEditor.tags.forEach(function(tag) {
            if ( tag.type == 'label') {
                tags.push(tag.tag);
            }
        });

        // init autocomplete input
        acpAutocomplete (thisEditor, tags);
    },
    
    isNotElement: function (obj) {
        if (obj[0].hasAttribute('builder-no-select')) {
            return true;
        } else {
            return false;
        }
    },

    isHelperTarget: function (obj) {
        if (// obj.closest('.mce-content-body').length > 0 ||
            obj.closest('.tox').length > 0 ||
            obj.closest('.tox-tinymce').length > 0 ||
            obj.closest('.builder-outline-move-hook').length > 0 ||
            obj.closest('.builder-outline-selected-controls').length > 0 ||
            obj.closest('[f-role=placeholder]').length > 0 ||
            obj.closest('.tox-editor-container').length > 0 ||
            obj.closest('.bubble').length > 0
        ) {
            return true;
        } else {
            return false;
        }
    },
    
    showEditCode: function () {
        var thisEditor = this;
        
        thisEditor.editHtmlPopup = new PopUp(getI18n('edit_html_code'), 'auto');
        var content = $('#EditHtmlModal').html();
        
        content = window.beautify.html(content, {
            indent_size: '2',
            indent_char: ' ',
            max_preserve_newlines: '5',
            preserve_newlines: true,
            keep_array_indentation: false,
            break_chained_methods: false,
            indent_scripts: 'normal',
            brace_style: 'expand',
            space_before_conditional: true,
            unescape_strings: false,
            jslint_happy: false,
            end_with_newline: false,
            wrap_line_length: '80',
            indent_inner_html: true,
            comma_first: false,
            e4x: false
        });
        
        thisEditor.editHtmlPopup.loadHtml(content);
        
        //set editor with ace js
        thisEditor.edit_html = ace.edit("EditHtml");
        thisEditor.edit_html.setTheme("ace/theme/monokai");
        thisEditor.edit_html.session.setMode("ace/mode/html");
        thisEditor.edit_html.session.setTabSize(4);
        thisEditor.edit_html.setValue(thisEditor.selected.obj[0].outerHTML);
        thisEditor.edit_html.session.setUseWrapMode(true);
        
        thisEditor.edit_html.setOptions({
            maxLines: (window.innerHeight - 260)/15,
            minLines: (window.innerHeight - 260)/15
        });
    },

    // after iframe and all new js css files embeded loaded
    afterIframeLoaded: function() {
        var thisEditor = this;

        thisEditor.initDrag();

        // include js
        if (typeof($("#builder_iframe")[0].contentWindow.beeFormLoaded) == 'undefined') {
            $("#builder_iframe").contents().find('head').append('<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">');
            $("#builder_iframe").contents().find('head').append('<link href="https://fonts.googleapis.com/icon?family=Material+Icons+Outlined" rel="stylesheet">');
            $("#builder_iframe").contents().find('head').append(thisEditor.transformHtml(`
                <style builder-helper="true" class="builder-tool">
                    [builder-element=CellElement]:empty::after {
                        content: "{language.drag_items_here}";
                    }
                </style>
            `));
            thisEditor.loading += 1;
        }

        // click on content (content)
        $("#builder_iframe").contents().click(function(e) {
            if ($(e.target).hasClass('builder-outline-move-hook') || $(e.target).parents('.builder-outline-move-hook').length) {
                return;
            }

            // save current click pos
            thisEditor.clickX = e.offsetX;
            thisEditor.clickY = e.offsetY;

            var obj = $(e.target);
            var element = thisEditor.elementFactory(obj);

            while (element != null && !element.canSelect() && obj.parents('[builder-element]').length) {
                obj = obj.parents('[builder-element]').first();
                element = thisEditor.elementFactory(obj);
            }

            if (!element.canSelect()) {
                return this.elementFactory(element.obj.parents('[builder-element]').first());
            }

            if (element != null) {
                e.preventDefault();

                $('a.nav-item').removeClass('active show');
                $('.tab-pane').removeClass('active show');
                $('#nav-home-tab').addClass('active show');
                $('#nav-home').addClass('active show');

                // select elment
                var old = thisEditor.selected;
                thisEditor.select(element);
                if(old == null || !old.equals(thisEditor.selected)) {
                    thisEditor.handleSelect();
                }
            } else if (!thisEditor.isHelperTarget($(e.target))) {

                thisEditor.unselect();
                thisEditor.hideControls();
            }

            // trigger iframe content click
            clickIframe();
        });

        // Click on duplicate action on left content (khi nhan chuot phai no duplicate)
        $("#builder_iframe").contents().find("body").on('mouseup', '.builder-duplicate-selected-button', function() {
            thisEditor.duplicate();
        });
        
        // Click on code action on left content (khi nhan chuot phai no duplicate)
        $("#builder_iframe").contents().find("body").on('mouseup', '.builder-code-selected-button', function() {
            thisEditor.showEditCode();
        });

        // Click on remove action on left content (khi nhan chuot phai no delete)
        $("#builder_iframe").contents().find("body").on('mouseup', '.builder-remove-selected-button', function() {
            thisEditor.remove();
        });

        // Add content element to custom widgets
        $("#builder_iframe").contents().find("body").on('mouseup', '.builder-add-widget-button', function() {
            thisEditor.addCustomWidget(thisEditor.selected, thisEditor.selected.obj);
        });

        // select parent element
        $("#builder_iframe").contents().find("body").on('mouseup', '.builder-select-parent-button', function() {
            thisEditor.selectParent(thisEditor.selected);
        });

        $("#builder_iframe").contents().find("body").keydown(function(e){
            if( e.which === 90 && e.ctrlKey ){
                thisEditor.undo();

                return;
            }

            if( e.which === 89 && e.ctrlKey ){
                thisEditor.redo();

                return;
            }

            if( !e.ctrlKey ){
                // save history
                thisEditor.recordState();
            }
        });

        // hover on elements of content
        $("#builder_iframe").contents().find("body").on('mouseover', '*', function(e) {
            if(thisEditor.isDragging) {
                return;
            }

            // find hover element
            var obj = $(e.target);
            var element = thisEditor.elementFactory(obj);

            while (element != null && !element.canSelect() && obj.parents('[builder-element]').length) {
                obj = obj.parents('[builder-element]').first();
                element = thisEditor.elementFactory(obj);
            }

            if (element != null) {
               if (element.equals(thisEditor.selected)) {
                    // do not highlight selected element
                    return true;
               }
               element.highlight();
            }
        });

        // this.content.find('*').mouseout(function(e) {
        $("#builder_iframe").contents().find("body").on('mouseout', '*', function(e) {
            var element = thisEditor.elementFactory($(e.target));

            if (element != null) {
                if (element.equals(thisEditor.selected)) {
                    return true;
                }
                element.unhighlight();
            }
        });

        // this.content.find('*').mouseout(function(e) {
        $("#builder_iframe").contents().find("body").on('keyup', '*', function() {
            if (thisEditor.selected != null) {
                thisEditor.selected.adjustSelectOutlinePosition();
                thisEditor.selected.adjustSelectControlsPosition();
                thisEditor.selected.adjustSelectMoveButtonPosition();
            }
        });

        $("#builder_iframe").contents().find("body").on('click', '*', function() {
            $('.template-thumbnail').hide();
            $('ul.action-sync').removeClass('show-action');
            $('ul.action-lang').removeClass('show-action');
            //remove preview
            $('.action-preview').removeClass('add-background-color');
            $('ul.display').removeClass('hienlen');
            //remove view source
            $('.view-mode').removeClass('add-background-color');
            $('ul.display-view-mode').removeClass('hienlen');
            //remove design
            $('.design-menu').removeClass('add-background-design');
            $('ul.design').removeClass('display-menu');
            //remove choose
            $('.action-choose-template').removeClass('add-background-choose');
            $('ul.display-template').removeClass('display-choose-template');
        });

        // js auto height iframe
        thisEditor.adjustIframeSize();

        // handle autocomplete
        thisEditor.handleAutocomplete();

        // save first history state
        thisEditor.recordState();

        // load widgets
        thisEditor.loadWidgets();

        // init content
        thisEditor.initContent = thisEditor.getContent();

        // check empty
        thisEditor.checkEmpty();

        // prevent form element clickable
        thisEditor.preventFormElementEvents();

        // iframe resize event
        var iframeWin = document.getElementById('builder_iframe').contentWindow;
        iframeWin.addEventListener('resize', function(){ 
            if (thisEditor.selected != null) {
                thisEditor.selected.select();
            }
        });

        // disable link
        // hover on elements of content
        $("#builder_iframe").contents().find("body").on('click', 'a', function(e) {
            e.preventDefault();
        });

        // go to home tab
        thisEditor.goToHomeTab();

        $(document.getElementById('builder_iframe').contentWindow.document).ready(function() {
            thisEditor.adjustIframeSize();

            // make sure it works
            setTimeout(function() {
                thisEditor.adjustIframeSize();
            }, 500);
        })
    },

    goToHomeTab: function() {
        var thisEditor = this;

        // beepro default tab
        // default page after load
        if (thisEditor.defaultTab && thisEditor.defaultTab == 'FieldsList') {
            goToListFieldsPage();
        } else {
            goToHtmlWidgetsPage();
        }
    },

    preventFormElementEvents: function() {
        $("#builder_iframe").contents().find('select,input,textarea').on('mousedown', function(e) {
            e.preventDefault();
            this.blur();
            window.focus();
        });
    },

    adjustIframeSize: function() {
        var my_frame = document.getElementById('builder_iframe');
        var content_height = my_frame.contentWindow.document.body.scrollHeight;
        var padding = parseInt($(document.getElementById('builder_iframe').contentWindow.document.documentElement).css('padding-top')) +
            parseInt($(document.getElementById('builder_iframe').contentWindow.document.documentElement).css('padding-bottom'));

        if (content_height < 200) {
            content_height = 200;
        }

        my_frame.style.height = (content_height + padding) + 'px';

        // adjust selected hover
        if (this.selected != null) {
            this.selected.select();
        }
    },

    loadWidgets: function() {
        var thisEditor = this;
        thisEditor.widgets = {};

        // content position
        thisEditor.content_widgets_bar = $('#builder_sidebar').find('.content_widget_container');
        thisEditor.content_widgets_bar.html('');

        // row position
        thisEditor.row_widgets_bar = $('#builder_sidebar').find('.row_widget_container');
        thisEditor.row_widgets_bar.html('');

        // row position
        thisEditor.form_widgets_bar = $('.fields-container');
        thisEditor.form_widgets_bar.html('');

        // Form elements
        if (thisEditor.formFields && thisEditor.formFields.length) {
            // Form field widgets
            thisEditor.formFields.forEach(function(field) {
                var className = field.type.charAt(0).toUpperCase() + field.type.slice(1) + 'FieldWidget';
                var widget = eval('new ' + className + '(field)');
                thisEditor.addWidget(widget, 'form');
            });              
            
            // Add submit button
            thisEditor.addWidget(new SubmitButtonWidget(), 'form');
            // add form class
            $('.content-left').addClass('content-form-mode');
        } else {
            // hide forms section
            $('.widgets-section.widgets-form').hide();
        }

        // check strict
        if (this.strict) {
            // thisEditor.addWidget(new OneRowWidget(), 'row');
            // thisEditor.addWidget(new TwoRow48Widget(), 'row');
            // thisEditor.addWidget(new TwoRow66Widget(), 'row');
            // thisEditor.addWidget(new TwoRow84Widget(), 'row');
            // thisEditor.addWidget(new ThreeRow444Widget(), 'row');
            // thisEditor.addWidget(new FourRow3333Widget(), 'row');
            
            thisEditor.addWidget(new TwoColumnsWidget(), 'content');
            thisEditor.addWidget(new ThreeColumnsWidget(), 'content');

            thisEditor.addWidget(new CenterLogoWidget(), 'content');
            thisEditor.addWidget(new TextWidget(), 'content');
            thisEditor.addWidget(new ImageWidget(), 'content');
            thisEditor.addWidget(new IntroBlockWidget(), 'content');
            
            
            thisEditor.addWidget(new OneColumnBlockWidget(), 'content');
            thisEditor.addWidget(new TwoColumnsBlockWidget(), 'content');
            thisEditor.addWidget(new ThreeColumnsBlockWidget(), 'content');

            thisEditor.addWidget(new YoutubeWidget(), 'content');

            thisEditor.addWidget(new SocialLinksBlockWidget(), 'content');
            thisEditor.addWidget(new PricingTableWidget(), 'content');
            thisEditor.addWidget(new DividerWidget(), 'content');

            thisEditor.addWidget(new BoxedTextWidget(), 'content');
            thisEditor.addWidget(new HeaderBlockWidget(), 'content');
            thisEditor.addWidget(new HeroImageWidget(), 'content');

            
            thisEditor.addWidget(new TwoArticlesBlockWidget(), 'content');
            thisEditor.addWidget(new TwoArticlesRTLBlockWidget(), 'content');
            thisEditor.addWidget(new FooterBlockWidget(), 'content');
            
            
            
            thisEditor.addWidget(new ButtonWidget(), 'content');
            thisEditor.addWidget(new Button2Widget(), 'content');
            thisEditor.addWidget(new VideoWidget(), 'content');
            thisEditor.addWidget(new TableWidget(), 'content');
            thisEditor.addWidget(new Table4Widget(), 'content');
            thisEditor.addWidget(new Table5Widget(), 'content');            
            // thisEditor.addWidget(new ButtonWidget(), 'content');
            // thisEditor.addWidget(new SocialWidget(), 'content');
            // thisEditor.addWidget(new HtmlWidget(), 'content');
            // thisEditor.addWidget(new ImageCaptionWidget(), 'content');
            // thisEditor.addWidget(new FooterWidget(), 'content');
            // thisEditor.addWidget(new HeaderWidget(), 'content');            
            // thisEditor.addWidget(new ListImageWidget(), 'content');
            // thisEditor.addWidget(new ProgressBarWidget(), 'content');
            // thisEditor.addWidget(new ListGroupWidget(), 'content');
            // thisEditor.addWidget(new PanelWidget(), 'content');
            // thisEditor.addWidget(new ImageHeaderWidget(), 'content');
            // thisEditor.addWidget(new JumbotronWidget(), 'content');
            // thisEditor.addWidget(new MeterialWidget(), 'content');
            // thisEditor.addWidget(new NavbarWidget(), 'content');
            // thisEditor.addWidget(new PricingTableWidget(), 'content');
            // thisEditor.addWidget(new ServicesListWidget(), 'content');
            // thisEditor.addWidget(new ImageGridWidget(), 'content');
            // thisEditor.addWidget(new UserProfileWidget(), 'content');
            // thisEditor.addWidget(new DivContainerWidget(), 'content');
            // thisEditor.addWidget(new ContainerWidget(), 'content');
            // thisEditor.addWidget(new WellWidget(), 'content');
            // thisEditor.addWidget(new MediaObjectWidget(), 'content');
            // thisEditor.addWidget(new ParagraphWidget(), 'content');
            // thisEditor.addWidget(new MarkedTextWidget(), 'content');
            // thisEditor.addWidget(new DefinitionListWidget(), 'content');
            // thisEditor.addWidget(new BlockqouteWidget(), 'content');
            // thisEditor.addWidget(new UnorderedListWidget(), 'content');
            // thisEditor.addWidget(new HeadingWidget(), 'content');
            // thisEditor.addWidget(new LinkWidget(), 'content');
            // thisEditor.addWidget(new ButtonGroupWidget(), 'content');
            // thisEditor.addWidget(new ButtonToolbarWidget(), 'content');
            // thisEditor.addWidget(new InputFieldWidget(), 'content');
            // thisEditor.addWidget(new TextAreaWidget(), 'content');
            // thisEditor.addWidget(new CheckboxWidget(), 'content');
            // thisEditor.addWidget(new InputGroupWidget(), 'content');
            // thisEditor.addWidget(new FormGroupWidget(), 'content');
            // thisEditor.addWidget(new SelectWidget(), 'content');
            // thisEditor.addWidget(new FormWidget(), 'content');
        }

        if (!this.strict) {
            thisEditor.addWidget(new OneRowWidget(), 'row');
            thisEditor.addWidget(new TwoRow48Widget(), 'row');
            thisEditor.addWidget(new TwoRow66Widget(), 'row');
            thisEditor.addWidget(new TwoRow84Widget(), 'row');
            thisEditor.addWidget(new ThreeRow444Widget(), 'row');
            thisEditor.addWidget(new FourRow3333Widget(), 'row');
            
            // thisEditor.addWidget(new HeaderBlockWidget(), 'content');
            // thisEditor.addWidget(new HeroImageWidget(), 'content');
            // thisEditor.addWidget(new IntroBlockWidget(), 'content');
            // thisEditor.addWidget(new OneColumnBlockWidget(), 'content');
            // thisEditor.addWidget(new TwoColumnsBlockWidget(), 'content');
            // thisEditor.addWidget(new ThreeColumnsBlockWidget(), 'content');
            // thisEditor.addWidget(new TwoArticlesBlockWidget(), 'content');
            // thisEditor.addWidget(new TwoArticlesRTLBlockWidget(), 'content');
            // thisEditor.addWidget(new FooterBlockWidget(), 'content');
            // thisEditor.addWidget(new SocialLinksBlockWidget(), 'content');
            // thisEditor.addWidget(new PricingTableWidget(), 'content');
            
            // thisEditor.addWidget(new ImageWidget(), 'content');
            thisEditor.addWidget(new TextWidget(), 'content');
            thisEditor.addWidget(new DividerWidget(), 'content');
            thisEditor.addWidget(new ButtonWidget(), 'content');
            thisEditor.addWidget(new ImageWidget(), 'content');
            // thisEditor.addWidget(new TableWidget(), 'content');
            // thisEditor.addWidget(new Table4Widget(), 'content');
            // thisEditor.addWidget(new Table5Widget(), 'content');
            thisEditor.addWidget(new VideoWidget(), 'content');
            // thisEditor.addWidget(new ButtonWidget(), 'content');
            // thisEditor.addWidget(new SocialWidget(), 'content');
            thisEditor.addWidget(new HtmlWidget(), 'content');
            thisEditor.addWidget(new ImageCaptionWidget(), 'content');
            thisEditor.addWidget(new FooterWidget(), 'content');
            thisEditor.addWidget(new HeaderWidget(), 'content');            
            thisEditor.addWidget(new ListImageWidget(), 'content');
            thisEditor.addWidget(new ProgressBarWidget(), 'content');
            thisEditor.addWidget(new ListGroupWidget(), 'content');
            thisEditor.addWidget(new PanelWidget(), 'content');
            // thisEditor.addWidget(new ImageHeaderWidget(), 'content');
            thisEditor.addWidget(new JumbotronWidget(), 'content');
            thisEditor.addWidget(new MeterialWidget(), 'content');
            thisEditor.addWidget(new NavbarWidget(), 'content');
            thisEditor.addWidget(new PricingTableWidget(), 'content');
            thisEditor.addWidget(new ServicesListWidget(), 'content');
            thisEditor.addWidget(new ImageGridWidget(), 'content');
            // thisEditor.addWidget(new UserProfileWidget(), 'content');
            // thisEditor.addWidget(new DivContainerWidget(), 'content');
            // thisEditor.addWidget(new ContainerWidget(), 'content');
            // thisEditor.addWidget(new WellWidget(), 'content');
            // thisEditor.addWidget(new MediaObjectWidget(), 'content');
            thisEditor.addWidget(new ParagraphWidget(), 'content');
            thisEditor.addWidget(new MarkedTextWidget(), 'content');
            thisEditor.addWidget(new DefinitionListWidget(), 'content');
            thisEditor.addWidget(new BlockqouteWidget(), 'content');
            thisEditor.addWidget(new UnorderedListWidget(), 'content');
            // thisEditor.addWidget(new HeadingWidget(), 'content');
            thisEditor.addWidget(new LinkWidget(), 'content');
            thisEditor.addWidget(new ButtonGroupWidget(), 'content');
            thisEditor.addWidget(new ButtonToolbarWidget(), 'content');
            thisEditor.addWidget(new InputFieldWidget(), 'content');
            thisEditor.addWidget(new TextAreaWidget(), 'content');
            thisEditor.addWidget(new CheckboxWidget(), 'content');
            thisEditor.addWidget(new InputGroupWidget(), 'content');
            thisEditor.addWidget(new FormGroupWidget(), 'content');
            thisEditor.addWidget(new SelectWidget(), 'content');
            thisEditor.addWidget(new FormWidget(), 'content');
        }

        var widgets = $('#builder_sidebar').find('.content_widget_container .widget-item');
        var slideing = 18;
        // hide > 9th widget
        //dem widget > 10 thi addClass hide
        widgets.slice(slideing).addClass('hide');

        $('#builder_sidebar').find('a.link-show_more').click(function() {
            var widgets = $('#builder_sidebar').find('.content_widget_container .widget-item');
            widgets.slice(slideing).removeClass('hide');
            $(this).hide();
            $('a.link-hide_less').show();
        });

        $('#builder_sidebar').find('a.link-hide_less').click(function() {
            var widgets = $('#builder_sidebar').find('.content_widget_container .widget-item');
            widgets.slice(slideing).addClass('hide');
            $(this).hide();
            $('a.link-show_more').show();
        });
    },

    selectParent: function(element) {
        var thisEditor = this;

        var obj = element.obj.parent();
        var element = thisEditor.elementFactory(obj);

        while (element != null && !element.canSelect() && obj.parents('[builder-element]').length) {
            obj = obj.parents('[builder-element]').first();
            element = thisEditor.elementFactory(obj);
        }

        if (element != null) {
            thisEditor.select(element);
            thisEditor.handleSelect();
        } else {
            thisEditor.unselect();
            thisEditor.hideControls();
        }
    },

    transformHtml: function(html) {
        return this.setIcons(this.updateLanguage(this.prepairUrls(html)));
    },

    addWidget: function(widget, position, index) {
        var thisEditor = this;
        thisEditor.widgets[widget.id] = widget;

        // disabled widget
        if (thisEditor.disableWidgets != null && thisEditor.disableWidgets.includes(widget.getHtmlId())) {
            return;
        }

        var html = '<div class="widget-item" id="' + widget.id + '" class-name="'+widget.getHtmlId()+'" f-library="true">' +
            thisEditor.transformHtml(widget.getButtonHtml()) +
       '</div>';

        var new_w = $(html);

        if (position == 'content') {
            if (index !== null && thisEditor.content_widgets_bar.children().eq(index).length) {
                var posItem = thisEditor.content_widgets_bar.children().eq(index);                 
                posItem.before(new_w);
            } else {
                thisEditor.content_widgets_bar.append(new_w);
            }
            
            // bee pro
            $('.widgets-container').append(new_w);
        }

        if (position == 'row') {
            thisEditor.row_widgets_bar.append(new_w);
        }

        if (position == 'form') {
            thisEditor.form_widgets_bar.append(new_w);
        }

        return new_w;
    },

    addContentWidget: function(widget, index, group) {
        var thisEditor = this;
        thisEditor.widgets[widget.id] = widget;

        var html = '<div class="widget-item content-widget" id="' + widget.id + '" class-name="'+widget.getHtmlId()+'" f-library="true">' +
            widget.getButtonHtml() +
        '</div>';

        var container = thisEditor.content_widgets_bar;

        // group
        if (group !== null) {
            if (!$('[widgets-group="'+group+'"]').length) {
                // add new group
                $('.widgets-sections').prepend(`
                    <div class="widgets-section widgets-other mb-4" widgets-group="`+group+`">
                        <label class="block-title">`+group+`</label>
                        <div class="widget-list">                  
                        </div>
                    </div>
                `);
            }

            container = $('[widgets-group="'+group+'"] .widget-list');
        }

        var new_w = $(html);
        var posItem;
        if (index !== null && container.children().eq(index).length) {
            posItem = container.children().eq(index); 
            
            posItem.before(new_w);
        } else {
            posItem = container.append(new_w);
        }

        
        
        return new_w;
    },

    addCustomCss: function(url) {
        // add custom css
        $("#builder_iframe").contents().find('head').append('<link builder-helper="true" rel="stylesheet" href="'+url+'">');
    },

    addCustomWidget: function(element, item) {
        var thisEditor = this;

        var w = new CustomWidget();
        w.contentHtml = element.obj[0].outerHTML;

        // thisEditor.addWidget(w, 'content');
        thisEditor.addingWidget = w;

        // show name popup
        var p = new PopUp(getI18n('add_widget'), 'auto');
        p.loadHtml($('#WidgetNameToolbox').html().replace('[ID]', w.id));

        $(document).on('click', '.btn-add-custom-widget-'+w.id, function() {
            var name = '';
            if ($('#CustomWidgetName').val().trim() != '') {
                name = $('#CustomWidgetName').val().trim();
            } else {
                name = getI18n('my_widget');
            }

            thisEditor.addingWidget.buttonHtml = thisEditor.addingWidget.buttonHtml.replace(/\[NAME\]/g, name);
            thisEditor.addingWidget.draggingHtml = thisEditor.addingWidget.buttonHtml.replace(/\[NAME\]/g, name);

            var new_w = thisEditor.addWidget(thisEditor.addingWidget, 'content');

            p.hide();

            //
            // We mainly want to work with the <li> here so lets store it in a variable
            //var parent = item.clone();
            var parent = $('<div class="widget-moving-box">' + $('#CustomWidget').html().replace(/\[NAME\]/g, name) + '</div>');

            $('.detail-content').removeClass('dilen');
            $('.tab-content').removeClass('hide-scroll-bar');
            // Effect show/hide
            new_w.css({opacity: 0});
            $("#nav-tabContent").animate({scrollTop: $("#nav-tabContent")[0].scrollHeight}, 300, function() {
                // let's assume we have our cart with id #cart and let's get it's offset too
                var d_top = new_w.offset().top;
                var d_left = new_w.offset().left;

                parent
                // apend it to the body so that the `<body>` is our relative element
                .appendTo("body")

                // Set the product to absolute, and (hopefully) clone its' position
                .css({
                    'position': 'fixed',
                    'top': item.offset().top + $("#builder_iframe").offset().top - $("#builder_iframe").contents().find("body").scrollTop() + thisEditor.selected.obj.outerHeight()/2 - parent.outerHeight()/2,
                    'left': item.offset().left + thisEditor.selected.obj.outerWidth()/2 - parent.outerWidth()/2,
                })

                // we're now ready to animate it, supplying the coordinates from the #cart
                .animate({
                    'top': d_top,
                    'left': d_left,
                    //'height': new_w.height(),
                    'opacity': 0.2
                }, 1000, function() {
                    // Animation complete.
                    new_w.animate({
                        'opacity': 1
                    }, 300);
                })

                // Then fade it out perhaps?
                .fadeOut(300);

                thisEditor.notificationArea(getI18n('widget_success'));
            });
        });
    },

    doExport: function() {
        var thisEditor = this;

        // cleanup content before save
        thisEditor.cleanUpContent();

        // get save content
        var content = thisEditor.getContent();

        // add ddata
        var data = '';
        if(thisEditor.data != null) {
            for(var key in thisEditor.data){
                // Check if the property really exists
                if(thisEditor.data.hasOwnProperty(key)){
                    var value = thisEditor.data[key];
                    // Do something with the item :
                    data = data + '<input type="hiden" name="'+key+'" value="'+value+'" />';
                }
            }
        }

        var form = $(`
            <form style="display:none" action="`+thisEditor.export.url+`" method="POST" target="_blank">
                `+data+`
                <textarea name="content"></textarea>
            </form>`
        ).appendTo('body');
        form.find('textarea[name=content]').val(content);

        setTimeout(function() {
            form.submit();
        }, 100);
    },

    loadEvents: function() {
        var thisEditor = this;

        $(document).on('click', '.pr-desktop', function() {
            thisEditor.showPreview('desktop');
        });

        $(document).on('click', '.pr-mobile', function() {
            thisEditor.showPreview('mobile');
        });

        //js modal preview design builder desktop
        $(document).on('click', '.close-preview', function() {
            thisEditor.closePreview();
        });

        $(document).on('click', '.click-active-preview', function() {
            $('.click-active-preview').removeClass('active-preview');
            $(this).addClass('active-preview');
        });

        $('#btnClone').click(function() {
            thisEditor.duplicate();	// selected.clone()
        });

        $(document).on('click', 'a.save-design, .bp-save', function(e) {
            e.preventDefault();
            thisEditor.save();
        });
        
        $(document).on('click', '.menu-bar-action.btn-save-and-close', function(e) {
            e.preventDefault();
            
            thisEditor.save(function() {
              // check if builder has backCallback
              if (typeof(thisEditor.backCallback) !== 'undefined') {
                thisEditor.backCallback();
              } else {
                window.location.href = thisEditor.urlBack;
              }                
            });
        });
        
        $(document).on('click', '.menu-bar-action.btn-export', function(e) {
            e.preventDefault();

            Swal.fire({
                title: getI18n('are_you_sure'),
                text: getI18n('export_template_confirm'),
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: getI18n('ok')
            }).then((result) => {
                if (result.value) {
                    if (thisEditor.export != null) {
                        thisEditor.doExport();
                    }
                }
            });
        });

        //js click button preview design desktop
        $(document).on('click', '.preview-design-desktop', function() {
            thisEditor.showPreview('desktop');
        });

        //js click button preview design mobile
        $(document).on('click', '.preview-design-mobile', function() {
            thisEditor.showPreview('mobile');
        });

        //click button show on design
        $(document).on('click', '.view-mode-design', function() {
            thisEditor.viewDesign();
            return false;
        });

        //click button show on source
        $(document).on('click', '.view-mode-source, .bp-view-source', function() {
            thisEditor.viewSource();
            return false;
        });

        //js click change template
        $(document).on('click', '.hover-name-template', function(e) {
            e.preventDefault();

            var template_url = $(this).attr('template-url');
            thisEditor.changeTemplate(template_url);
        });
        
        //js click change template
        $(document).on('click', '.new-from-template-select', function(e) {
            e.preventDefault();

            var template_url = $(this).attr('href');
            thisEditor.changeTemplate(template_url);
        });

        $(document).on('click', 'img.img-template', function(e) {
            e.preventDefault();

            var template_url = $(this).attr('template-url');
            thisEditor.changeTemplate(template_url);
        });

        //js nut back in builder
        $(document).on('click', 'a.back', function(e){
            e.preventDefault();

            thisEditor.back();
        });
        
        // click on close button in top menu bar
        $(document).on('click', '.menu-bar-action.btn-close, .bp-exit', function(e){
            e.preventDefault();

            thisEditor.back();
        });

        //
        $(document).on('click', '.builder-duplicate-selected-button, .bp-duplicate', function() {
            thisEditor.duplicate();
        });

        //
        $(document).on('click', '.builder-remove-selected-button, .bp-delete', function() {
            thisEditor.remove();
        });

        //click button hide on desktop
        $('#builder_sidebar').on('click', '.desktop', function() {
           thisEditor.hideOnDesktop();
        });

        //click button hide on mobile
        $('#builder_sidebar').on('click', '.mobile', function() {
            thisEditor.hideOnMobile();
        });

        //click button hide on desktop and mobile
        $('#builder_sidebar').on('click', '.icon-remove-two-screen', function() {
           thisEditor.removeHideOnTowScreen();
        });

        $('.chonfont').click(function() {
            $('div.language').toggleClass('bangchon');
            //$('.thongso').toggleClass('doimau');
            $('.arrows-button').toggleClass('doimau');
        });
        //hieu ung sidebar content di len
        $('.click-chon').click(function() {
            thisEditor.showControls();
        });

        $('a.move').click(function() {
            thisEditor.unselect();
            thisEditor.hideControls();

            return false;
        });

        //js click not button choose-sync
        $('*:not(.choose-sync)').click(function() {
            $('ul.action-sync').removeClass('show-action');
            return;
        });
        
        //js click not button choose-lang
        $('*:not(.choose-lang)').click(function() {
            $('ul.action-lang').removeClass('show-action');
            return;
        });

        //js choose template builder
        $('*:not(.menu-bar)').click(function(e) {
            if ($(e.target).closest('.action-preview, ul.display, .view-mode, ul.display-view-mode, .design-menu, ul.design, .action-choose-template, ul.display-template').length) {
                $('div.template-thumbnail').hide();
                return;
            }

            $('div.template-thumbnail').hide();

            $('.action-choose-template').removeClass('add-background-choose');
            $('ul.display-template').removeClass('display-choose-template');
            //remove view source
            $('.view-mode').removeClass('add-background-color');
            $('ul.display-view-mode').removeClass('hienlen');
            //remove design
            $('.design-menu').removeClass('add-background-design');
            $('ul.design').removeClass('display-menu');

            $('.preview-page').removeClass('add-background-color');
            $('.preview-page').find('ul.display').removeClass('hienlen');
        });

        //js nut chon design menu
        $('.design-menu').click(function() {
            $(this).toggleClass('add-background-design');
            $(this).find('ul.design').toggleClass('display-menu');

            //remove choose
            $('.action-choose-template').removeClass('add-background-choose');
            $('ul.display-template').removeClass('display-choose-template');

            //remove view source
            $('.view-mode').removeClass('add-background-color');
            $('ul.display-view-mode').removeClass('hienlen');

            //remove preview
            $('.action-preview').removeClass('add-background-color');
            $('ul.display').removeClass('hienlen');
        });

        //js nut chon action hien preview design
        $('.preview-page').click(function() {
            $(this).toggleClass('add-background-color');
            $(this).find('ul.display').toggleClass('hienlen');

            //remove choose
            $('.action-choose-template').removeClass('add-background-choose');
            $('ul.display-template').removeClass('display-choose-template');
            //remove view source
            $('.view-mode').removeClass('add-background-color');
            $('ul.display-view-mode').removeClass('hienlen');
            //remove design
            $('.design-menu').removeClass('add-background-design');
            $('ul.design').removeClass('display-menu');
        });

        //js nut chon action view mode design, source
        $('.view-mode').click(function() {
            $(this).toggleClass('add-background-color');
            $(this).find('ul.display-view-mode').toggleClass('hienlen');

            //remove choose
            $('.action-choose-template').removeClass('add-background-choose');
            $('ul.display-template').removeClass('display-choose-template');
            //remove preview
            $('.action-preview').removeClass('add-background-color');
            $('ul.display').removeClass('hienlen');
            //remove design
            $('.design-menu').removeClass('add-background-design');
            $('ul.design').removeClass('display-menu');
        });

        //js choose template builder
        $('.action-choose-template').click(function() {
            $(this).toggleClass('add-background-choose');
            $(this).find('ul.display-template').toggleClass('display-choose-template');
            //remove preview
            $('.action-preview').removeClass('add-background-color');
            $('ul.display').removeClass('hienlen');
            //remove view source
            $('.view-mode').removeClass('add-background-color');
            $('ul.display-view-mode').removeClass('hienlen');
            //remove design
            $('.design-menu').removeClass('add-background-design');
            $('ul.design').removeClass('display-menu');

            $('div.template-thumbnail').hide();
        });

        //hover li template show image thumbnail
        $(document).on('mouseover', 'li.hover-name-template', function() {
            var thumbnail = $(this).attr('data-thumbnail');
            var url = $(this).attr('template-url');
            $('.template-thumbnail img.img-template').attr('template-url', url);
            $('.template-thumbnail img.img-template').attr('src', thumbnail);
            $('.template-thumbnail').show();
        });

        //js click action mode preview design
        $(document).on('click', 'li.device', function() {
            $('.icon-mode').css('color', 'rgb(150, 150, 150)');
            $(this).find('.icon-mode').css('color', 'white');
            $('.content-background').removeClass('mode-mobile');
            $('.content-background').removeClass('mode-tablet');
            $('.content-background').removeClass('mode-desktop');
            
            var mode = $(this).attr('data-mode');
            $('img.bg-image').attr('data-mode', mode);
            $('li.change-background').attr('data-mode', mode);
        });

        $(document).on('click', 'li.mode-mobile', function() {
            thisEditor.backgroundModeMobile();
        });
        
        $(document).on('click', 'li.box-mode-mobile', function() {
            thisEditor.backgroundModeMobile();
        });

        $(document).on('click', 'li.mode-tablet', function() {
            thisEditor.backgroundModeTablet();
        });
        
        $(document).on('click', 'li.box-mode-tablet', function() {
            thisEditor.backgroundModeTablet();
        });

        $(document).on('click', 'li.mode-desktop', function() {
            thisEditor.backgroundModeDesktop();
        });
        
        $(document).on('click', 'li.box-mode-desktop', function() {
            thisEditor.backgroundModeDesktop();
        });
        
        $(document).on('click', '.group-device li.device-screen', function() {
            $('.content-background').removeClass('mode-mobile-320 mode-mobile-360 mode-mobile-375 mode-mobile-414 mode-tablet-768 mode-tablet-1024 mode-desktop-1280 mode-desktop-1360 mode-desktop-1920 mode-mobile mode-tablet mode-desktop');

            if ($(this).hasClass('_320')) {
                $('.content-background').addClass('mode-mobile-320');
            } else if ($(this).hasClass('_360')) {
                $('.content-background').addClass('mode-mobile-360');
            } else if ($(this).hasClass('_375')) {
                $('.content-background').addClass('mode-mobile-375');
            } else if ($(this).hasClass('_414')) {
                $('.content-background').addClass('mode-mobile-414');
            } else if ($(this).hasClass('_768')) {
                $('.content-background').addClass('mode-tablet-768');
            } else if ($(this).hasClass('_1024')) {
                $('.content-background').addClass('mode-tablet-1024');
            } else if ($(this).hasClass('_1280')) {
                $('.content-background').addClass('mode-desktop-1280');
            } else if ($(this).hasClass('_1360')) {
                $('.content-background').addClass('mode-desktop-1360');
            } else if ($(this).hasClass('_1920')) {
                $('.content-background').addClass('mode-desktop-1920');
            }
        });

        $('span.padding-img').click(function() {
            $('.padding-img').toggleClass('hienlen');
            $('._1_minus-plus.img').toggleClass('andi');
        });
        
        //js click hien slide range detail img
        $(document).on('click', 'span.slider.disable', function() {
            $('input.myRanges').prop("disabled", true);
            $('label.check-disable').addClass('andi');
            $('label.check-enable').addClass('hienthi');
            $('input.color-default').addClass('color-blue');
        });

        $(document).on('click', 'span.slider.enable', function() {
            $('input.myRanges').prop("disabled", false);
            $('label.check-disable').removeClass('andi');
            $('label.check-enable').removeClass('hienthi');
            $('input.color-default').removeClass('color-blue');
        });

        //js click hien slide padding all
        $(document).on('click', 'span.slider.all-padding', function() {
            $('label.check-all-padding').addClass('andi');
            $('label.check-4-padding').addClass('hienthi');
            $('.all-padding-section').addClass('andi');
            $('.four-padding-section').addClass('hienlen');
        });

        $(document).on('click', 'span.slider._4-padding', function() {
            $('label.check-all-padding').removeClass('andi');
            $('label.check-4-padding').removeClass('hienthi');
            $('.all-padding-section').removeClass('andi');
            $('.four-padding-section').removeClass('hienlen');
        });

        //hieu ung dropdown-menu hien
        $('button.owp').click(function() {
            $('ul.down-menu').toggleClass('hienlen');
            $('.owp').toggleClass('change-background');
        });

        $('.spacing').click(function() {
            $('ul.select-down').toggleClass('hienlen');
            $('input.spacing').toggleClass('change-background');
        });

        $('._4icon').click(function() {
            $('.display-icon').toggleClass('box-icon-display');
        });

        //xu ly click thay doi trang thai active
        $(".thongso ul li span.icon-align").click(function() {
            $('span.icon-align').removeClass('active');
            $(this).addClass("active");
        });

        $("li img.icon-line-height").click(function() {
            $('.icon-line-height').removeClass('active');
            $(this).addClass("active");
        });

        $(document).on('click', 'span.dijitDialogCloseIcon', function() {
            $('.dijitDialogShow.dijitDialog').remove();
            $('.dijitDialogUnderlayWrapper').remove();
        });

        //js click nav-bar
        $(document).on('click', '#nav-home-tab', function() {
            $('.detail-content').removeClass('dilen');
            $('.tab-content').removeClass('hide-scroll-bar');

            thisEditor.unselect();
            thisEditor.hideControls();
        });

        $(document).on('click', '#nav-profile-tab, .bp-setting', function() {
            $("#builder_iframe").contents().find("[builder-element='PageElement']").click();
        });

        $(document).on('click', '#nav-contact-tab', function() {
            $('.tab-content').addClass('hide-scroll-bar');
        });

        //js action setting builder
        $(document).on('change', '#myRange', function() {
            var width = $(this).val();
            var content_builder = $('#builder_iframe').contents().find('body');
            content_builder.css('width', width);
            content_builder.css('margin', 'auto');
        });

        $(document).on('change', '#background-color', function(){
            var color = $(this).val();
            $('#text-bg-color').val(color);
            var content_body = $('#builder_iframe').contents().find('body');
            content_body.css('background-color', color);
        });

        $(document).on('change', '#content-background-color', function(){
            var color = $(this).val();
            $('#text-content-bg-color').val(color);
            var content_body = $('#builder_iframe').contents().find('body');
            var element = content_body.find('*');
            element.css('background-color', color);
        });

        $(document).on('click', 'a.font-family', function(){
            var font = $(this).attr('data-font');
            $('button.chonfont').html(font);
            var content_body = $('#builder_iframe').contents().find('body');
            content_body.css('font-family', font);
            $('.language').removeClass('bangchon');
        });

        $(document).on('change', '#link-color', function(){
            var color = $(this).val();
            $('#text-link-color').val(color);
            var content_body = $('#builder_iframe').contents().find('a');
            content_body.css('color', color);
        });

        //js action by modal change video builder
        $(document).on('click', '.action-tab', function() {
            $('.action-tab').removeClass('tab-active');
            $(this).addClass('tab-active');
            $('.tab-bg-active').removeClass('tab-bg-active');
        });

        $(document).on('click', '.video-container-modal li.tab-url', function() {
            $('.content-tab-url').show();
            $('.content-tab-upload').hide();
        });

        $(document).on('click', '.video-container-modal li.tab-upload', function() {
            $('.content-tab-url').hide();
            $('.content-tab-upload').show();
        });

        $(document).on('change', 'input.file-upload-url', function(e) {
            var fileName = e.target.files[0].name;
            $('span.des-upload-video').text(fileName);
        });

        // copy clipboard
        $(document).on('click', '.btn-tag-copy', function() {
            $(this).closest('li.tags').find('input')[0].select();
            document.execCommand('copy');

            var content = getI18n('copy_tag');
            thisEditor.notificationArea(content);
        });

        // copy tag clipboard
        $(document).on('click', '.tag-item', function() {
            $(this).find('input')[0].select();
            document.execCommand('copy');

            var content = getI18n('copy_tag');
            thisEditor.notificationArea(content);
        });

        // click new design
        $(document).on('click', '.design-new', function() {
            thisEditor.newDesign();
        });

        // click clear design
        $(document).on('click', '.design-clear', function() {
            thisEditor.clearDesign();
        });

        // click new from template
        $(document).on('click', '.design-from-template', function() {
            thisEditor.showTemplatePopup();
        });

        //copy url link image
        $(document).on('click', 'a.copy-url', function(e) {
            e.preventDefault();

            $(this).closest('.link-image').find('input.url-image')[0].select();
            document.execCommand('copy');

            var content = getI18n('copy_url_success'); //'Copy url successfully!';

            thisEditor.notificationArea(content);
        });

        // click history
        $(document).on('click', '.undo-redo-action-history', function() {
            $('.undo-redo__history--wrapper').toggleClass('show-history');
        });

        // click undo
        $(document).on('click', '.undo-redo-action-undo, .action.undo', function() {
            thisEditor.undo();
        });

        // click redo
        $(document).on('click', '.undo-redo-action-redo, .action.redo', function() {
            thisEditor.redo();
        });

        // remove widget event
        $(document).on('click', '.remove-widget-button', function() {
            $(this).closest('.widget-item').fadeOut(300, function() {
                $(this).remove();
            });
        });

        //click help modal
        $(document).on('click', '.ask-help', function(e) {
            e.preventDefault();

            var Popup = new helpPopUp();
            var url = thisEditor.root + '../manual?v=4';
            Popup.load(url);
        });

        //click button change language
        $(document).on('click', '.choose-lang', function(e) {
            e.preventDefault();
            $('ul.action-lang').toggleClass('show-action');
        });
        
        //click button sync
        $(document).on('click', '.choose-sync', function(e) {
            e.preventDefault();
            $('ul.action-sync').toggleClass('show-action');
        });

        //click span action sync
        $(document).on('click', '.btn-sync', function(e) {
            e.preventDefault();
            thisEditor.save();
        });

        //click action sync
        $(document).on('click', 'li.synchronization', function(e) {
            e.preventDefault();
            var sync = $(this).attr('data-title');
            thisEditor.synchronization($(this));
            var content = getI18n('syn_with') +sync;
            thisEditor.notificationArea(content);
        });

        $(document).on('click', 'li.setting', function(e) {
            e.preventDefault();
            thisEditor.settingSync();
        });

        //load js action box right
        $(document).on('mouseover', '.box-popup-right', function() {
            $(this).addClass('box-over');
            $(this).removeClass('box-out');
        });

        $(document).on('mouseout', '.box-popup-right', function() {
            $(this).addClass('box-out');
            $(this).removeClass('box-over');
        });

        $(document).on('click', '.box-popup-right', function() {
            $('.right-box').toggleClass('show');
            $('i.icon-box').toggleClass('change-icon');
            $(this).toggleClass('distance-right');
            $('#builderModal').toggleClass('show-popup-right');

            if ($(this).hasClass('distance-right')) {
                $('.box-popup-right.distance-right').attr('title', 'Hide apps');
                $('.box-popup-right .icon').html('chevron_right');
            } else {
                $('.box-popup-right').attr('title', 'Show apps');
                $('.box-popup-right .icon').html('chevron_left');
            }

            var popup = new PopUp('', 'xright', 'right');
            popup.loadHtmlXright();
        });

        $("li#box-mode-mobile").hover(
            function () {
                $('ul.group-mobile').addClass('show');
            },
            function () {
                $('ul.group-mobile').removeClass('show');
            }
        );

        $("li#box-mode-tablet").hover(
            function () {
                $('ul.group-tablet').addClass('show');
            },
            function () {
                $('ul.group-tablet').removeClass('show');
            }
        );

        $("li#box-mode-desktop").hover(
            function () {
                $('ul.group-desktop').addClass('show');
            },
            function () {
                $('ul.group-desktop').removeClass('show');
            }
        );

        $("li#background-option").hover(
            function () {
                $('ul.group-background').addClass('show');
            },
            function () {
                $('ul.group-background').removeClass('show');
            }
        );

        $('li.box-device').hover(function() {
            $('li.box-device').removeClass('background-active');
            $(this).addClass('background-active');
        });

        $(document).on('click', 'li.box-device', function() {
            $('.box-device.active').removeClass('active');
            $(this).addClass('active');
        });

        //js change background
        $(document).on('click', 'li.device-bg img.bg-image', function(e) {
            e.preventDefault();

            var mode = $(this).attr('data-mode');
            var bg = $(this).attr('src');
            $('#editable').css('background-image','url('+ bg + ')');
            $('#editable').css('background-size','contain');
            $('#editable').css('background-position','inherit');
            $('.content-background').attr('class').addClass(mode);
        });

        $(document).on('click', 'li.change-background', function() {
            var mode = $(this).attr('data-mode');
            $('.content-background').attr('class').addClass(mode);
        });

        //js upload template for builder
        $(document).on('click', 'a.design-upload-template', function(e) {
            e.preventDefault();

            var html = $('#uploadTemplate').html();
            var popup = new PopUp('Upload Template', 'auto');
            popup.loadHtml(html);
        });

        $(document).on('change', 'input.file-upload-template', function() {
            var fileName = this.files[0].name;
            $('span.des-upload').text(fileName);
        });

        $(document).on('click', '#buttonUploadTemplate', function(e){
            e.preventDefault();

            var url = thisEditor.uploadTemplateUrl;
            thisEditor.uploadTemplate(url);
        });
        
        // click save edit html
        $(document).on('click', '.edit-html-save-button', function(e){
            e.preventDefault();
            
            var cur = thisEditor.selected;
            
            var html = thisEditor.edit_html.getValue();
            
            var newObj = $(html);

            thisEditor.selected.obj.replaceWith(newObj);
            
            var element = thisEditor.elementFactory(newObj);
            if (element !== null) {
                thisEditor.select(element);
                thisEditor.handleSelect();
            }
            
            thisEditor.editHtmlPopup.hide();
        });

        // click outside grey background content
        $(".content-left, .beepro-content, .content-background").click(function(){
            thisEditor.unselect();
            thisEditor.hideControls();
        }).children().click(function(e) {
            return false;
        });
    },
    
    changeActiveDevice: function() {
        $('.box-mode-mobile').removeClass('active');
        $('.box-mode-tablet').removeClass('active');
        $('.box-mode-desktop').removeClass('active');
        $('.box-mode-mobile').removeClass('background-active');
        $('.box-mode-tablet').removeClass('background-active');
        $('.box-mode-desktop').removeClass('background-active');
    },
    
    backgroundModeMobile: function() {
        var thisEditor = this;
        $('.content-background').addClass('mode-mobile');
        $('.content-background').removeClass('mode-tablet mode-tablet-768 mode-tablet-1024');
        $('.content-background').removeClass('mode-desktop mode-desktop-1280 mode-desktop-1360 mode-desktop-1920');
        $('li.mode-mobile').find('i.icon-mode').css('color', 'white');
        $('li.mode-tablet').find('i.icon-mode').css('color', 'rgb(150, 150, 150)');
        $('li.mode-desktop').find('i.icon-mode').css('color', 'rgb(150, 150, 150)');
        
        thisEditor.changeActiveDevice();
        $('ul.box-mode li#box-mode-mobile').addClass('active');
        $('ul.box-mode li#box-mode-mobile').addClass('background-active');
        
        var my_frame = document.getElementById('builder_iframe');
        var width = $('.content-background.mode-mobile').width();
        my_frame.style.width = width + 'px';

        // body css
        $("#builder_iframe").contents().find("body").removeClass (function (index, className) {
            return (className.match (/(^|\s)builder-class-mode-\S+/g) || []).join(' ');
        });
        $("#builder_iframe").contents().find("body").addClass('builder-class-mode-mobile');

        thisEditor.adjustIframeSize();
    },
    
    backgroundModeTablet: function() {
        var thisEditor = this;
        $('.content-background').addClass('mode-tablet');
        $('.content-background').removeClass('mode-mobile');
        $('.content-background').removeClass('mode-desktop mode-desktop-1280 mode-desktop-1360 mode-desktop-1920');
        $('li.mode-tablet').find('i.icon-mode').css('color', 'white');
        $('li.mode-mobile').find('i.icon-mode').css('color', 'rgb(150, 150, 150)');
        $('li.mode-desktop').find('i.icon-mode').css('color', 'rgb(150, 150, 150)');
        
        thisEditor.changeActiveDevice();
        $('ul.box-mode li#box-mode-tablet').addClass('active');
        $('ul.box-mode li#box-mode-tablet').addClass('background-active');
        
        var my_frame = document.getElementById('builder_iframe');
        var width = $('.content-background.mode-tablet').width();
        my_frame.style.width = width + 'px';

        // body css
        $("#builder_iframe").contents().find("body").removeClass (function (index, className) {
            return (className.match (/(^|\s)builder-class-mode-\S+/g) || []).join(' ');
        });
        $("#builder_iframe").contents().find("body").addClass('builder-class-mode-tablet');

        thisEditor.adjustIframeSize();
    },
    
    backgroundModeDesktop: function() {
        var thisEditor = this;
        $('.content-background').addClass('mode-desktop');
        $('.content-background').removeClass('mode-mobile');
        $('.content-background').removeClass('mode-tablet');
        $('li.mode-desktop').find('i.icon-mode').css('color', 'white');
        $('li.mode-mobile').find('i.icon-mode').css('color', 'rgb(150, 150, 150)');
        $('li.mode-tablet').find('i.icon-mode').css('color', 'rgb(150, 150, 150)');
        
        thisEditor.changeActiveDevice();
        $('ul.box-mode li#box-mode-desktop').addClass('active');
        $('ul.box-mode li#box-mode-desktop').addClass('background-active');
        
        var my_frame = document.getElementById('builder_iframe');
        var width = $('.content-background.mode-desktop').width();
        my_frame.style.width = width + 'px';

        // body css
        $("#builder_iframe").contents().find("body").removeClass (function (index, className) {
            return (className.match (/(^|\s)builder-class-mode-\S+/g) || []).join(' ');
        });
        $("#builder_iframe").contents().find("body").addClass('builder-class-mode-desktop');

        thisEditor.adjustIframeSize();
    },

    notificationArea: function(content) {
        bootstrapGrowl(content ,{
            type: 'success',
            delay: 3000,
        });
    },

    newDesign: function() {
        var thisEditor = this;

        if (thisEditor.strict) {
            $("#builder_iframe").contents().find("[builder-element='PageElement']").html('');
            thisEditor.checkEmpty();
        }
    },

    clearDesign: function() {
        var thisEditor = this;

        Swal.fire({
            title: getI18n('are_you_sure'),
            text: getI18n('clear_while'),
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: getI18n('ok')
        }).then((result) => {
            if (result.value) {
                thisEditor.unselect();
                thisEditor.hideControls();

                Swal.fire({
                    title: getI18n('good_job'),
                    text: getI18n('clear_success'),
                    type: "success",
                }).then((result) => {
                    // clear callback
                    if (thisEditor.clear) {
                        thisEditor.clear();
                        return;
                    }

                    if (thisEditor.strict) {
                        $("#builder_iframe").contents().find("[builder-element='PageElement']").html('');
                        thisEditor.checkEmpty();
                    }                    
                });
            }
        });
    },

    showTemplatePopup: function() {
        var templatePopup = new PopUp(getI18n('choose_template'));
        var contentPopup = '<div>' + $('#templateToolbox').html() + '</div>';

        templatePopup.loadHtml(contentPopup);
        $('.nav-content').removeClass('active');
        $('.nav-tab').removeClass('active');
        $('#home').addClass('active show');
    },

    viewSource: function() {
        var thisEditor = this;
        thisEditor.editing = false;

        // bee pro
        $('body').addClass('bp-source-mode');
        hideMainMenuDropdown();

        $('.content-left').removeClass('col-md-8');
        $('.content-left').addClass('col-md-6');
        $('#show-mode').html(getI18n('mode_source'));
        $('.content-right').hide();
        $('.view-source').show();

        var content = $("#builder_iframe").contents().find("body").html();

        //set editor with ace js
        var source_code = ace.edit("editor");
        source_code.setTheme("ace/theme/monokai");
        source_code.session.setMode("ace/mode/html");
        source_code.session.setTabSize(4);
        source_code.setValue(content);

        if (thisEditor.editing == false) {
            thisEditor.editing = true;

            source_code.session.on('change', function() {
                thisEditor.editing = false;
                setTimeout(function() {thisEditor.updateFromSource('source');}, 5000);
            });
        }

        thisEditor.cleanUpContent();
        thisEditor.adjustIframeSize();
    },

    updateFromSource: function(mode = 'design') {
        if (mode == 'source') {
            var source_code = ace.edit("editor");
            var content = source_code.getValue();
            $('iframe#builder_iframe').contents().find('body').html(content);
        } else {
            //return;
            $('.tab-content').removeClass('hide-scroll-bar');
            $('.content-left').addClass('animation');
            setTimeout(function (){
                $('.content-left').removeClass('animation');
            },100);
        }
    },

    viewDesign: function() {
        var thisEditor = this;

        $('body').removeClass('bp-source-mode');

        thisEditor.updateFromSource('design');

        $('.detail-content.dilen').removeClass('dilen');
        $('.content-left').removeClass('col-md-6');
        $('.content-left').addClass('col-md-8');
        $('#show-mode').html(getI18n('mode_design'));
        $('.content-right').show();
        $('.view-source').hide();

        thisEditor.adjustIframeSize();
    },

    showControls: function() {
        $('.detail-content').addClass('dilen');
        $('#nav-home-tab').removeClass('active');
    },

    toogleChooseTemplateMenu: function() {
        var thisEditor = this;

        if(typeof(thisEditor.templates) == 'undefined' || thisEditor.templates == '' || thisEditor.templates.length == 0) {
          $('.choose-template-menu').remove();
        }
    },

    showPreview: function(device = 'desktop') {
        // show popup
        var thisBuilder = this;
        //clean element hieu ung
        thisBuilder.cleanUpContent();
        var latestContent = $('#builder_iframe').contents().find('html').html();

        $('div.showPreview').show("fast", function() {
            $('#modal-preview-desktop .modal-body-preview').hide();
            $('#modal-preview-desktop .modal-body-preview-mobile').hide();
            
            thisBuilder.hideControls();


            $('#previewIframeMobile').attr('src', thisBuilder.url);
            $('#previewIframeDesktop').attr('src', thisBuilder.url);
            // load iframe
            if (device == 'mobile') {
                //$('#previewIframeMobile').attr("srcdoc", content);

                $('#modal-preview-desktop .modal-body-preview-mobile').show("fast", function() {
                    $('.pr-mobile').addClass('active-preview');
                    $('#previewIframeMobile').contents().find('body').html(latestContent);
                    $('#previewIframeMobile').contents().find('body').find('.Hide-on-mobile').css('display', 'none');
                });
                thisBuilder.setAdjustFrame('mobile');

            } else { // desktop
                //$('#previewIframeDesktop').attr("srcdoc", content);

                $('#modal-preview-desktop .modal-body-preview').show("fast", function() {
                    $('.pr-desktop').addClass('active-preview');
                    $('#previewIframeDesktop').contents().find('body').html(latestContent);
                    $('#previewIframeDesktop').contents().find('body').find('.Hide-on-desktop').css('display', 'none');
                });
                thisBuilder.setAdjustFrame('desktop');
            }
        });
    },

    setAdjustFrame: function(mode = 'desktop') {
        if (mode == 'mobile') {
            var my_frameM = document.getElementById('previewIframeMobile');
            var content_heightM = my_frameM.contentWindow.document.body.scrollHeight;
            my_frameM.style.height = content_heightM + 'px';
        } else {
            var my_frameD = document.getElementById('previewIframeDesktop');
            var content_heightD = my_frameD.contentWindow.document.body.scrollHeight;
            my_frameD.style.height = content_heightD + 'px';
        }
    },

    loadTags: function() {
        var thisEditor = this;

        if (typeof(thisEditor.tags) != 'undefined') {
            thisEditor.tags.forEach(function(tag) {
                if ( tag.type == 'label') {
                    $('ul.tags-value').append('<li class="tags" title="'+tag.tag+'">'+
                                                '<div class="float-left">'+
                                                   '<div class="tag">'+
                                                      '<input class="copy-tags builder-tag-text" value="'+ tag.tag +'" data-value="" style="outline: none;border: none;background-color: #f5f5f5;"/>'+
                                                   '</div>'+
                                                '</div>'+
                                                '<div class="float-right insert">'+
                                                   '<button class="btn btn-tag-copy" data-clipboard-target=".copy-tags" style="cursor: pointer;padding: 5px 20px;color: #241c15;background-color: #fff;">Copy</button>'+
                                                '</div>'+
                                            '</li>');

                    // bee pro tags                    
                    $('.tags-container').append(`
                        <div class="tag-item ml-2 mb-2" title="`+tag.tag+`">
                            <span class="tag-icon">
                                <i style="height: 23px;">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 16 16"><g fill="#626262"><path fill-rule="evenodd" d="M5 2a.5.5 0 0 1 .5-.5c.862 0 1.573.287 2.06.566c.174.099.321.198.44.286c.119-.088.266-.187.44-.286A4.165 4.165 0 0 1 10.5 1.5a.5.5 0 0 1 0 1c-.638 0-1.177.213-1.564.434a3.49 3.49 0 0 0-.436.294V7.5H9a.5.5 0 0 1 0 1h-.5v4.272c.1.08.248.187.436.294c.387.221.926.434 1.564.434a.5.5 0 0 1 0 1a4.165 4.165 0 0 1-2.06-.566A4.561 4.561 0 0 1 8 13.65a4.561 4.561 0 0 1-.44.285a4.165 4.165 0 0 1-2.06.566a.5.5 0 0 1 0-1c.638 0 1.177-.213 1.564-.434c.188-.107.335-.214.436-.294V8.5H7a.5.5 0 0 1 0-1h.5V3.228a3.49 3.49 0 0 0-.436-.294A3.166 3.166 0 0 0 5.5 2.5A.5.5 0 0 1 5 2zm3.352 1.355zm-.704 9.29z"/><path d="M10 5h4a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1h-4v1h4a2 2 0 0 0 2-2V6a2 2 0 0 0-2-2h-4v1zM6 5V4H2a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h4v-1H2a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h4z"/></g></svg>
                                </i>
                            </span>
                            <span class="tag-title">
                                <input value="`+ tag.tag +`" type="text" style=""/>
                            </span>
                        </div>
                    `);
                }
            });
        }
    },

    listTemplate: function() {
        var thisEditor = this;

        if (typeof(thisEditor.templates) !== 'undefined') {
            thisEditor.templates.forEach(function(template) {
                $('.show-list-template ul.display-template').append('<li class="hover-name-template" data-thumbnail="'+ template.thumbnail +'" template-url="' + template.url +'">'+
                                                                '<a class="template-change" href="#"> '+ template.name +' </a>'+
                                                            '</li>');

                $('ul.list-new-template').append('<li class="c-templateSelection_item c-choiceCard c-choiceCard--thick pb-4">'+
                                                    '<div class="c-choiceCard_innerContainer">'+
                                                        '<a aria-label="button" title="'+ getI18n('selected_template') +'" style="background-position: center;background-size: 151px;background-repeat: no-repeat;background-image: url('+ template.thumbnail +');" href="'+ template.url +'" class="newTemplate new-from-template-select c-choiceCard_label overflow--visible background-size--cover background-position--center-top border-gray border-radius--lv1 v-aspectRatio--square margin-bottom--lv1"></a>'+
                                                        '<p title="'+ template.name +'" class="text-align--center margin-bottom--lv0 font-weight--bold ">'+ template.name +'</p>'+
                                                        
                                                    '</div>'+
                                                '</li>');

                // bee pro
                $('.templates-container').append('<li class="c-templateSelection_item c-choiceCard c-choiceCard--thick pb-4">'+
                    '<div class="c-choiceCard_innerContainer">'+
                        '<a aria-label="button" title="'+ getI18n('selected_template') +'" style="background-position: center;background-size: 151px;background-repeat: no-repeat;background-image: url('+ template.thumbnail +');" href="'+ template.url +'" class="newTemplate new-from-template-select c-choiceCard_label overflow--visible background-size--cover background-position--center-top border-gray border-radius--lv1 v-aspectRatio--square margin-bottom--lv1"></a>'+
                        '<p title="'+ template.name +'" class="text-align--center margin-bottom--lv0 font-weight--bold ">'+ template.name +'</p>'+
                          
                    '</div>'+
                '</li>');
            });
        }
    },

    listHistory: function() {
        var thisEditor = this;
        $('ul#undo-redo__history').html('');
        if (typeof(thisEditor.historyRecords) !== 'undefined') {
            for (var i = 0; i < thisEditor.historyRecords.length; i++) {
                var list = thisEditor.historyRecords[i];
                var current_class = 'history_item_current';

                if (i != thisEditor.currentRecordAchor) {
                    current_class = '';
                }

                $('ul#undo-redo__history').prepend('<li data-achor="'+i+'" class="history_add '+current_class+' history__step ng-scope history__step--active">'+
                    '<div class="step__icon ng-binding" ng-bind-html="::icon(event.icon)">'+
                        '<i id="text" class="'+ list.icon +'" style="font-size:28px;display:inline-block"></i>'+
                    '</div>'+
                    '<div class="step__body">'+
                        '<div class="step__title ng-binding">'+ list.title +'</div>'+
                        '<div class="step__time ng-binding">'+ list.time +'</div>'+
                    '</div>'+
                '</li>');


                // new hidtory bee pro
                $('.history-container').html('');
                $('.history-container').prepend('<div data-achor="'+i+'" class="history_add history-item '+current_class+' history__step ng-scope history__step--active">'+
                    '<div class="history-icon ng-binding" ng-bind-html="::icon(event.icon)">'+
                        '<i id="text" class="'+ list.icon +'" style="font-size:28px;display:inline-block"></i>'+
                    '</div>'+
                    '<div class="history-body">'+
                        '<div class="step__title ng-binding">'+ list.title +'</div>'+
                        '<div class="step__time time ng-binding">'+ list.time +'</div>'+
                    '</div>'+
                '</div>');
            }
        }
    },

    setLogo: function() {
        // logo
        if (typeof(this.logo) !== 'undefined') {
            $('.logo .logo-img').attr('src', this.logo);
        }        
    },

    init: function() {
        var thisEditor = this;

        // load required js
        thisEditor.loadPageJs([thisEditor.root+'language/all.js'], function() {
            // set language
            thisEditor.setLanguage();

            // load editor
            thisEditor.run();
        });
    },

    setLanguage: function() {
        var thisEditor = this;

        thisEditor.I18n = LANGUAGE[this.language];

        // merge custom language
        if (thisEditor.lang) {
            thisEditor.I18n = $.extend(thisEditor.I18n, thisEditor.lang);
        }

        window.getI18n = function (phrase) {
            if (typeof(thisEditor.I18n[phrase]) !== 'undefined') {
                return thisEditor.I18n[phrase];
            } else {
                return phrase;
            }
        };
    },

    run: function () {
        var thisEditor = this;

        // prepair HTML
        thisEditor.prepairHtml(thisEditor.theme);

        // prepair body html
        thisEditor.build();

        // init vars
        thisEditor.iframe = $('#builder_iframe');
        thisEditor.content = this.iframe.contents().find('body');
        thisEditor.window = this.iframe.contents().find("html");
        thisEditor.selected = null;
        
        // 
        thisEditor.initIframe();

        // load tags buttons
        thisEditor.loadTags();

        // load event listensers
        thisEditor.loadEvents();

        // check if change template enu available
        thisEditor.toogleChooseTemplateMenu();

        // list template
        thisEditor.listTemplate();

        // set logo
        thisEditor.setLogo();
        
        // set backgrounds
        thisEditor.setBackgrounds();

        // load tinymce
        thisEditor.loadPageJs([thisEditor.root+'iframe/tinymce/tinymce.min.js']);

        // strict layout fix
        thisEditor.checkStrict();        

        // check export button
        if (thisEditor.export == null) {
            $('.export-button').remove();
        }

        // iframe no makeup
        if(thisEditor.frameBoxStyle && thisEditor.frameBoxStyle == 'none') {
            thisEditor.iframe.addClass('no_style');
        }

        // hide help button
        if (!thisEditor.showHelp) {
            $('li.ask-help').remove();
        }

        // disable features
        thisEditor.checkDisableFeatures();

        // file manager
        if (!thisEditor.filemanager) {
            $('.filemanager-item').remove();
        }
    },

    checkDisableFeatures: function() {
        var thisEditor = this;
        
        if (thisEditor.disableFeatures == null) {
            return;
        }
        // disable change template
        if (thisEditor.disableFeatures.includes('change_template')) {
            $('.choose-template-menu').hide();
        }

        // disable export
        if (thisEditor.disableFeatures.includes('export')) {
            $('.export-button').hide();
        }

        // disable save & close
        if (thisEditor.disableFeatures.includes('save_close')) {
            $('.btn-save-and-close').remove();
        }

        // disable footer exit
        if (thisEditor.disableFeatures.includes('footer_exit')) {
            $('.footer-exit-without-save').remove();
        }

        // disable help
        if (thisEditor.disableFeatures.includes('help')) {
            $('.ask-help').remove();
        }
    },

    checkStrict: function() {
        var thisEditor = this;

        if(!thisEditor.strict) {
            $('#nav-profile-tab').remove();            
            $('.design .design-new').parent().hide();
            $('.design .design-clear').parent().hide();
            if (!thisEditor.strict) {
                $('#nav-layouts-tab').show();
            } else {
                $('.content-right nav #nav-tab a').css('width', '50%');
            }
        }

        // close
        $('.build-mode-warning-close').on('click', function() {
            $('body').removeClass('build-mode-disabled');
            $('.build-mode-warning').remove();
        });
    },

    setBackgrounds: function() {
        if(typeof(this.backgrounds) != 'undefined') {
            this.backgrounds.forEach(function(url) {
                $('.builder-backgrounds').append(`
                    <li class="device-bg bg-default">
                        <img alt="image" class="bg-image" src="`+url+`" />
                    </li>
                `);
            });
        }
    },

    //fix loi
    select: function(element) {
        if (!element.equals(this.selected)) {
            this.unselect();

            this.selected = element;
            this.selected.select();

            // editor
            this.inlineEdit($("#builder_iframe")[0].contentWindow.$(element.obj[0]));
        }

        // js auto height iframe
        this.adjustIframeSize();

        // is warpper
        if (element.isWrapper()) {
            $('#nav-profile-tab').addClass('active');
        }
    },

    unselect: function() {
        if (this.selected != null) {
            this.selected.unhighlight();
            this.selected.unselect();

            // editor
            this.removeInlineEdit(this.selected.obj);
        }
        this.selected = null;

        // js auto height iframe
        this.adjustIframeSize();

        // is warpper
        $('#nav-profile-tab').removeClass('active');
    },

    duplicate: function() {
        var thisEditor = this;

        // bee pro
        if (!thisEditor.selected) {
            beeAlert('Duplicate', 'Please choose a field from your form design first!');
            return;
        }

        var obj = this.selected.obj;
        this.unselect();
        var html = obj.clone();

        var new_item = $(html);

        obj.after(new_item);
        new_item.css('display', 'none');
        new_item.fadeIn(200, function() {
            // select new element
            var element = thisEditor.elementFactory(new_item);
            if (element !== null) {
                thisEditor.select(element);
                thisEditor.handleSelect();
            }

            // save history
            thisEditor.recordState(element.name() + getI18n('duplicated_element'), element.icon());

            // js auto height iframe
            thisEditor.adjustIframeSize();

            // notify
            thisEditor.notificationArea(getI18n('duplicate'));
        });
    },

    remove: function() {
        var thisEditor = this;
        // bee pro
        if (!thisEditor.selected) {
            beeAlert('Remove', 'Please choose a field from your form design first!');
            return;
        }
        var obj = this.selected.obj;
        var removed = this.selected;
        this.unselect();

        obj.fadeOut(200,function(){
            // find empty parent element
            var parents = obj.parents('[builder-element]');

            obj.remove();

            // check parent if empty then remove
            if (parents.length &&
                !parents.first().find('[builder-element]').length &&
                !parents.first().is("[builder-element='PageElement']") &&
                !parents.first().is("[builder-element='CellElement']")
            ) {
                    parents.first().remove();
            }

            // save history
            thisEditor.recordState(removed.name() + getI18n('deleted_element'), removed.icon());

            // js auto height iframe
            thisEditor.adjustIframeSize();

            // check empty
            thisEditor.checkEmpty();

            // notify
            thisEditor.notificationArea(getI18n('remove'));
        });

        // hide controls
        this.hideControls();
    },

    hideOnDesktop: function() {
        var obj = this.selected.obj;
        obj.addClass('Hide-on-desktop');
        obj.removeClass('Hide-on-mobile');
        $('.icon-remove-two-screen').removeClass('hide');
    },

    hideOnMobile: function() {
        var obj = this.selected.obj;
        obj.addClass('Hide-on-mobile');
        obj.removeClass('Hide-on-desktop');
        $('.icon-remove-two-screen').removeClass('hide');
    },

    removeHideOnTowScreen: function() {
        var obj = this.selected.obj;
        obj.removeClass('Hide-on-mobile');
        obj.removeClass('Hide-on-desktop');
        $('.icon-remove-two-screen').addClass('hide');
        $('.hide-all.desktop').removeClass('change-bgcolor');
        $('.hide-all.mobile').removeClass('change-bgcolor');
    },

    getElementByTagName: function(obj) {
        var tagName = obj.prop('tagName').toLowerCase();
        var element = null;

        // get element by class name (bootstrap)
        if (obj.hasClass('btn')) {
            element = new ButtonElement(obj);
        }
       
        switch(tagName) {
            case 'p':
                element = new PElement(obj);
                break;
            case 'a':
                element = new AElement(obj);
                break;
            case 'img':
                element = new ImgElement(obj);
                break;
            case 'video':
                element = new VideoElement(obj);
                break;
            case 'h1':
            case 'h2':
            case 'h3':
            case 'h4':
            case 'h5':
            case 'h6':
                element = new HeadingElement(obj);
                break;
            case 'span':
                element = new SpanElement(obj);
                break;
            case 'button':
                element = new ButtonElement(obj);
                break;
            case 'select':
                element = new DropdownElement(obj);
                break;
            case 'td':
            case 'label':
                element = new TextElement(obj);
                break;
            case 'input':
                if (obj.attr('type') == 'checkbox') {
                    element = new CheckboxElement(obj);
                } else if (obj.attr('type') == 'text') {
                    element = new TextFieldElement(obj);
                } else if (obj.attr('type') == 'email') {
                    element = new EmailFieldElement(obj);
                } else {
                    element = new TextElement(obj);
                }
                break;
            default:
                element = new OtherElement(obj);
        }

        return element;
    },

    elementFactory: function(obj) {
        var element = null;

        // check if obj is null
        if (typeof(obj) == 'undefined') {
            return null;
        }

        // STRICT MODE
        if (this.strict) {
            // if obj is OR is inside element
            if (obj.closest('[builder-element]').length) {
                obj = obj.closest('[builder-element]');
            } else {
                return null;
            }

            // Get element by builder-element value
            if (typeof(obj.attr('builder-element')) != 'undefined' && obj.attr('builder-element') != '') {
                element = eval('new ' + obj.attr('builder-element') + '(obj)');
            }

            // OR get element by tag name
            else {
                element = this.getElementByTagName(obj);
            }

            return element;

        // NOT STRICT MODE
        } else {
            // check if inside helper
            if (this.isHelperTarget(obj)) {
                return null;
            }
            
            // check if is not element
            if (this.isNotElement(obj)) {
                return null;
            }

            return this.getElementByTagName(obj);
        }

        
    },

    handleSelect: function() {
        var thisEditor = this;
        
        setTimeout(function() {
            thisEditor.loadControls();
        }, 100);
    },

    loadControls: function() {
        var thisEditor = this;
        var element_bar = $('#builder_sidebar').find('.detail-content');

        // if no selected
        if (this.selected == null) {
            return;
        }

        // top delete button toggle
        if (!this.selected.canDelete()) {
            $('.builder-remove-selected-button').hide();
        } else {
            $('.builder-remove-selected-button').show();
        }

        // top duplicate button toggle
        if (!this.selected.canDuplicate()) {
            $('.builder-duplicate-selected-button').hide();
        } else {
            $('.builder-duplicate-selected-button').show();
        }

        // Get controls from selected
        var controls = this.selected.getControls();

        // Get controls from container
        var containerControls = [];
        if (this.selected.getContainer() != null) {
            containerControls = this.selected.getContainer().getControls();
        }

        // Get controls from cell container
        var cellControls = [];
        if (this.selected.getCellContainer() != null) {
            cellControls = this.selected.getCellContainer().getControls();
        }

        // return if has no controls
        if (controls.length == 0) {
            return;
        }

        // Load element controls bar
        $('#builder_sidebar').find('.tab-content').addClass('hide-scroll-bar');
        thisEditor.showControls();

        // insert controls to sidebar
        $('.attributes-container').html('');

        // Selected controls
        controls.forEach(function(control) {
            var group = $('.attributes[group-id="'+control.groupId()+'"]');

            // create group controls html container if not exists
            if (!group.length) {
                $('.attributes-container').append(thisEditor.transformHtml(`<div class="attributes-group mb-1">
                    <div class="attribute-header">
                        <label>{language.`+control.groupId()+`}</label>
                        <span class="toggle-caret-icon ag-toogle-button open">
                            <i>
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="0.3em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 210 700"><path d="M23 44q10 0 16 6l163 162q7 8 7 17t-7 16L39 407q-7 7-16 7t-16-7t-7-16t7-16l146-146L7 83q-7-7-7-17t6.5-16T23 44z" fill="#626262"/></svg>
                            </i>
                        </span>
                    </div>
                    <div class="attributes" group-id="`+control.groupId()+`">
                    </div>
                </div>`));

                group = $('.attributes[group-id="'+control.groupId()+'"]');
            }

            group.append('<div>' + thisEditor.transformHtml(control.renderHtml()) + '</div>');
            
            // after render control
            if (typeof(control.afterRender) != 'undefined') {
                control.afterRender();
            }
        });

        // Cell container controls
        if (cellControls.length) {
            $('.attributes-container').append(thisEditor.transformHtml(`<div class="cell-container-controls"><h3 class="title-bar">{language.cell_options}</h3></div>`));
            cellControls.forEach(function(control) {
                var group = $('.attributes[group-id="cell-container-'+control.groupId()+'"]');

                // create group controls html container if not exists
                if (!group.length) {
                    $('.attributes-container .cell-container-controls').append(thisEditor.transformHtml(`<div class="attributes-group mb-1">
                        <div class="attribute-header">
                            <label>{language.`+control.groupId()+`}</label>
                            <span class="toggle-caret-icon ag-toogle-button open">
                                <i>
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="0.3em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 210 700"><path d="M23 44q10 0 16 6l163 162q7 8 7 17t-7 16L39 407q-7 7-16 7t-16-7t-7-16t7-16l146-146L7 83q-7-7-7-17t6.5-16T23 44z" fill="#626262"/></svg>
                                </i>
                            </span>
                        </div>
                        <div class="attributes" group-id="cell-container-`+control.groupId()+`">
                        </div>
                    </div>`));
                    
                    group = $('.attributes[group-id="cell-container-'+control.groupId()+'"]');
                }

                group.append('<div>' + thisEditor.transformHtml(control.renderHtml()) + '</div>');
                
                // after render control
                if (typeof(control.afterRender) != 'undefined') {
                    control.afterRender();
                }
            });
        }

        // Container controls
        if (containerControls.length) {
            $('.attributes-container').append(thisEditor.transformHtml(`<div class="container-controls"><h3 class="title-bar">{language.container_options}</h3></div>`));
            containerControls.forEach(function(control) {
                var group = $('.attributes[group-id="container-'+control.groupId()+'"]');

                // create group controls html container if not exists
                if (!group.length) {
                    $('.attributes-container .container-controls').append(thisEditor.transformHtml(`<div class="attributes-group mb-1">
                        <div class="attribute-header">
                            <label>{language.`+control.groupId()+`}</label>
                            <span class="toggle-caret-icon ag-toogle-button open">
                                <i>
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="0.3em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 210 700"><path d="M23 44q10 0 16 6l163 162q7 8 7 17t-7 16L39 407q-7 7-16 7t-16-7t-7-16t7-16l146-146L7 83q-7-7-7-17t6.5-16T23 44z" fill="#626262"/></svg>
                                </i>
                            </span>
                        </div>
                        <div class="attributes" group-id="container-`+control.groupId()+`">
                        </div>
                    </div>`));
                    
                    group = $('.attributes[group-id="container-'+control.groupId()+'"]');
                }

                group.append('<div>' + thisEditor.transformHtml(control.renderHtml()) + '</div>');
                
                // after render control
                if (typeof(control.afterRender) != 'undefined') {
                    control.afterRender();
                }
            });
        }

        // hide empty group
        $('.attributes[group-id]').each(function() {
            if ($(this).children().length) {
                $(this).closest('.attributes-group').show();
            } else {
                $(this).closest('.attributes-group').hide();
            }
        });

        // show element name in header
        $('.element-attributes .element-name').html(thisEditor.selected.name());

        // go to third page
        goToThirdPage();
    },

    hideControls: function() {
        var thisEditor = this;

        // Load element controls bar
        var element_bar = $('#builder_sidebar').find('.detail-content');
        element_bar.removeClass('dilen');
        // element_bar.find('.properties-pannel-content').html('');
        $('#builder_sidebar').find('.tab-content').removeClass('hide-scroll-bar');

        $('#nav-home-tab').addClass('active');

        // beepro go back
        goToMainPage();
    }
};




/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),
/* 2 */
/***/ (function(module, exports) {

module.exports = "data:image/jpeg;base64,/9j/4RI7RXhpZgAATU0AKgAAAAgABwESAAMAAAABAAEAAAEaAAUAAAABAAAAYgEbAAUAAAABAAAAagEoAAMAAAABAAIAAAExAAIAAAAeAAAAcgEyAAIAAAAUAAAAkIdpAAQAAAABAAAApAAAANAACvyAAAAnEAAK/IAAACcQQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2gAMjAxMzoxMToyNSAyMTo0NjozMAAAA6ABAAMAAAAB//8AAKACAAQAAAABAAABLKADAAQAAAABAAABLAAAAAAAAAAGAQMAAwAAAAEABgAAARoABQAAAAEAAAEeARsABQAAAAEAAAEmASgAAwAAAAEAAgAAAgEABAAAAAEAAAEuAgIABAAAAAEAABEFAAAAAAAAAEgAAAABAAAASAAAAAH/2P/tAAxBZG9iZV9DTQAB/+4ADkFkb2JlAGSAAAAAAf/bAIQADAgICAkIDAkJDBELCgsRFQ8MDA8VGBMTFRMTGBEMDAwMDAwRDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAENCwsNDg0QDg4QFA4ODhQUDg4ODhQRDAwMDAwREQwMDAwMDBEMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwM/8AAEQgAoACgAwEiAAIRAQMRAf/dAAQACv/EAT8AAAEFAQEBAQEBAAAAAAAAAAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUDDDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1RkRcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MVY3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpamtsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A86CkEwThSLlwnCQUgklcBS0Ak6BR3N+PwUXbna9uwThElBkAs+zx0HYJqmW2mQSxniP++/vKVWOXe+3Xwb/5L/yKtAJGXQKjEnUsGVEf4R7vif8AYjtChua3nnwCcWnsI8zqm8JPRfxRj1TNbKfcwODNw3OMBvJQNznfSJI8Oyi9h/N0PI+KPt9yj3ewbzQiNCVJF1bbI+kPuP5w/wA5F9JwE8jxUJPRsjwU0I9VgDSD2BLUAHsp41NuZYa6dK2n9LdyB/IZ+/YmkLrA3dDCfT6NtmQ5zoAZS2OXuH0t7f8ARM96vV47vQrvd7W2ya2u0cWD/DbfzanO+gqLaLKCWZTXPqknEa1n882w6zs97/Tc303fzdf761cdz33Gyz9P1L6ThY4GvHYPay63b7XP/wBGzbsr/wAF69n6RQz60gSWrr8lYrpPggPtl22knYNN8QT/AOQUqmHT+9R8EiLJpRm//9DztSCZSCkXrgIZO0lrpJ/NPkihRtGjXRIEgyJRB1RIaMBaOCNUVrmng/ekw1ubER8dY/ztyc4zOd+35BO4u63h00K4kcGPgiteQNRPh/5khsYGiAZE8xCmAnEA7qEiNivE6nUnkqYCYBTARWrgKRZISARWNQJSk6a73PpP9dv5HhaVbVnUs2XMtby06jsQdHhatFlL4h20+DtFVzAg2BoW1hmOGidQqnpbuoZVGM1/otsfF1gEkVhr3GB++5zWLfxMPDwcsYV1TjVVW2xt8BuM3eXbGWOe7fbe/wBN3/qT/Bh6RXtzqfGST8muWx1+5tHTaGvl260bWDguDHu/ioDIkVv2CpG51emyDPyOl5NTqH5TW2t1rezcXMdH/Bt+i5vteseloZWaa2hlROrWjn+U9x/SWbv5aFUwzLtXEy4+JOqtVtRIA8VDwSVsVqmtRqr4V2inhRyKX//R86aY+HgiNIKEH+KmCCp6BUCQlAUwhNJHmEVjgfI+BTSCF4kCwdQZ3VaH93/yKZtg4cII5VprVI41dur2yf3hofvSE63Ucd7IGwRpqpgKZ6XbzS+fJwg/57f/ACKg+vMxxN1Ttv70S3/txntThkidiFphIbgpAFMBM0aA+OqI0JyxdoRWt1UWiUVrU0lLNjVd6dj1ZGXVj2v2iySBEl20b3Vt/d9qrMGqu49boD2Hba2xhqd4Oad6iyHQ60vju9Dg0+n1VjBxDi34FroVn61kbcKr+Va6PgK2fxUOmWfaOr1viG7XQ3wAbr/0lL6ygvzMZg/Mqcf89/8A6jVWK/qHIrYNFcpqlLHxiSBHyW1gdLNjg2Q0xPuPYIE60uumrj45MaLTxsRx4Eq/T0+ioa+8/cFYgAQBA8AiMZ6rTPs//9LzgROug+9JJPH+5WELhxCNWWO0Ltp8Dx96CApAJKbwwcxuVTjWbKzextrbHvLWNY8Ocx1zo/R/Q+h/YTWMsousx75qvpca7a3HVr26PYf6qXTKw62APpWVj73K99cG1f8AOjqL6TuqvsZkVuiJbdXXc12v9ZCzxcPhaejTbuPDyfg4/wB6K31hw5/+c7+9UAFNu4cOPyKJCG+2sqba3eCpMfaNN7vvKI193+kdpr9I6/BA2mm+2lx4CNXj2HsVnNst72P8fpFHi1j3V2SHNMOaTMEcjlNNpEPF02YxA90D4kD8qu4dY3EgyKhAI1l7/c7/ADK//Piz+k04F2bVTnvtqotIabKWtcQSQG794d+jd++xlmxbn2VuI84jXiz0yd1gBaCXfpJh/u9texV8hOy+gGx0/OxsDMrvydwrIcyWDcQSPp7f3G/yFc6nl0X5gsocy6v0mBtjTIP0neX735y5yyz7Rd7fofRZ5NGpf/39aFRAEN0AGnwUMxQA67skYjcunTa7xgDsNPyK/jZDmOa5hhzTIKyK3K1VZCgOhteQ9Xj5DMive3Qj6TfA/wDkVNc/j5L2ODq3EP7EfkWrR1Kp4AtGx37w1b930mqeGYHSWhYZYyNtn//T85CkAmCkArKFQpR2PISAUgElN3pfttrd/wAMz8HMV/621gdRxrP9Lh1yfOmzIwj/AO26oYMASTGx7SBBM6hzl03XOnU5/Qv2pXJtxW2W0cicazIuy7PVYf8AC1MyN3/WlHMiM4k9fT/jJGoeQgkyf7vyKQHddl0D/F79rxasvrF12O673MwqQ1tgYf5s33Wiz07Lfpegyr9Gz6f6RH6h0H6vvZf07o+KPWqaIydzrb327tlfp2Wu/o/q/ordnp1We/8A4NCWeETWp16bJES8WGwYkGO41CkB5KdlNtF1lF7DXdU4strdy17fpMKcSYHhoPyqRS7GorBHA0Cg0I1QEwdByT5DVNK4Or0SlpzqXuHtr3Wu+FbXWf8AVBa2T6mZ0fH6hRUPtWU8YuTXS0y6yXMa5jJf77WV1VvWV0Rzj07NzHf6BzGT29Z+xjf+22Ld+q17nYubiMJDmkWsgxo8enZ/56Vae5P7tJtbHxmdFx3ZL3CzPeDWC0yysv5pq/0r9v8AScj9z9Dj/wClsp1OgAeCHn5oysj9GZoqllXgf37P7f8A57UWPURBOp3LLEUHQrejseqDLNEdlngo5RXugy1HZfHdZrbUVtqjMVP/1POwFIcR+KYKYCtLVxxwpAJhASnwSU6HT+mZeYw31vbRjVWBl11j9rZcJFbKmn1cmzTd6dbP+M9NdTi9fo6R0Tp+TZi2ZjXs9Nga5rGh4Lyz1t4s+m1rtm1n5i47AuFGSLDw4bXHvH/nS6HpmZiX/Vl+Ln1OfTS0U5Ir+m2qwufjdQoYf5x1Fvu9Hcz+ZUOUXVixY0XBs5P+MXLyZoNFODRd7bLhY+y4NP0nNdFbf67vS3/uJsDLdjZuJfZNbch/2VrZjYywF9O4f6R+RVV/xf8ANrjG1j031SHWUkuDmzD2D+djcG/+GGf9dW30+92dg0Y2r8mjIoYGt1e5jnba7G/ymM3f9toSxxrQVehTbv8A1q6WLaR1Whv6SloZltH51Y9td/8AWx/5uz/gP+IXMxHy5XV2dddRZhXvNdnT8iuxuQ5g3Bzw70r7N359LI9jPz6H2rZ6X9U/q7iVMybcY5Nj5fW3Jd6jGtn9H6OP7avT2/QfkNteo8czjjwz1r5f+9/wUnXV4jp3S+pdTO3p2K/JAMOtaIrH/GZNm2j/AKal17peZ0WhjMl1TrMnc1opcXgBgY5+5xaz86zb7F6bZe57Qwe2tujaxoAPgPauH+vf6bI6bp7fXtaT5NbUT/1CMcplMCqCWNNYxvq4G8G+9jP7NTf/ACdb1Poua/Cyrr2AECh4fu4iWua7+V7mrSo6Xi9Q6dRhnK9LIxhudWwBxDnje/1anbXO/nP8G5XukfV0dK9bJzjXlbgGUV7TtMg7vWrs3N36/Q/SfvqMkVLxKnk6nBrB4gcIzLBPwUeptpp6llU0bRU207Ws0a3u6po/dqfurQm2finEWL7soLdbYjMt81QFkd1NtsJhguBdEWqYuWcLlMXJhgm3/9XzyVKSoiRqFIK0tXCkEwUpnUmSklfU6zB8tFoY3Ua6b6rC1tfqMOPlV1tDazXP6KyP9Ix7WWu/8zVCI0UbYAk8d0CAQllkX1YmXZX6A31XOHql7yWtB2sFdbSyv2s/0vq+oo235WG99ePYaqbmR+jhu+smfSssb77Wbhs9zv0ir3P9S9z3a7oJnnQAfwV7pWF+0L2Y973NprG5sRMEta5uvu+imHranqfqkMXqdVePlVl9VN32mn9w2Bv6bHd+8z1Nlr6v+EXcF7nEucZcTJJXK9Nbj4T6GY7BVTU9sNb4E7XOd+8535z3Lp5gx4aKrkNm1wZOsDGOedAwFx+QXGm3H6vkOv8AVF1dfsZjtJDmgH3eux221r7H+9/sW71vO9OsYlZ99om0+DPzW/8AXf8AqFx3W2MvtZsAbkVNn1R7Xknit1jYf9FLHGz28UvY9Jwt7m5twlrTuoae5H+GP8n/AEf+eodSyrumfbMu2x9z3BrcN1ji6XvLoZr/AKDbvs/4NiqfVT6zDqVbenZpjqNTYrcdPXYwfu/9yqW/z1f+Fr/Tf6VP9dLGjAxGQC517i09wG1u37f629iAgeMRPdTzIf4mT3ceSfFSD1X3pbzB10Ks8K4FtCzwPx+al6qqeoYidB/FL1AgYrrbnqHkceKXrkAgEweR4wqfqpjaUOBPE//W88CcKIUgrSGbQTMAmBJgTAH5x/kqTQCCSYgaCCZMgbdPo/v+5QB+XipApKZiE8Agg6g8hRCeeySUBqDHwfcBqCfBavQD+vT/ACf+/NWbcYcDz2VnpWXXj5JfYHRt0AEnRzXJkhoQp69rjtMcxoujtzq6cE5rxuArDwwEAucR7aml3t3WP9i4X9usGlePY7+s5rfyb1es6pkZWHjU2M9JtIJcyd0kud6fu0+hUq0sZ0sLghyOtfpHX51F9RsdLn7WuZJ/Ma+t7m/yGKg+31HusPLzuPhrwp9SsFgbQToQXO+J+h/mqhjWE17HfSrO0/DspoxAF1SlZXsvrupc5l4Ie1zJDmuafZcxzfov3LW6p1y7q2Nhfaa/TycdtgyCIDXuca9l1bW/Q3sZ+kr/ADLPofo1mF8mRoFHen8AsE7hKUu7ymL/ADQ9yYv0jXXsjSku/wA0xfKEXKO/w0SpVpt6YvQd6iXoUq3/1/OwpAqAKkCrKmQTgqIKdFSSU8qAI7fJOCklbIAGgIdBjc2YMfnNna7aliAG4Txqmt1YfiFLCI9ceQKad1OrQ0N1I17D+9WW2SqjXJXW7aXQdT7R8+f+imkWpHZb6ljn/vHT4DRqERFpsB+k2CFEOTF2pTgEhnuSLvPnsh7k25OSz3JtyhuTFySGZcmLlAuTFyCmZco7lHco7kkW/wD/0POZUiC1xB5BgwQRp/Kb7XKAKeVYUyBTyoynBRSzlKVCU8oqZO+ifgljWMZbucYEFRcfafghM5TZbqLpjLpH5xPwBULcllrmtaT7dYOkkqmCmcdUENvdATbkFljnNg9u6eU4JCV0tcWmJaSDBBEj+U2WuTFwIAAgge4zMmT7v5P7qHKRcilkXJiVHcmlJDLcmJUSUxKCmW5MSmL3ENaSSGyGjwk7jt/tKMoKf//Z/+0ZalBob3Rvc2hvcCAzLjAAOEJJTQQlAAAAAAAQAAAAAAAAAAAAAAAAAAAAADhCSU0EOgAAAAAAkwAAABAAAAABAAAAAAALcHJpbnRPdXRwdXQAAAAFAAAAAENsclNlbnVtAAAAAENsclMAAAAAUkdCQwAAAABJbnRlZW51bQAAAABJbnRlAAAAAEltZyAAAAAATXBCbGJvb2wBAAAAD3ByaW50U2l4dGVlbkJpdGJvb2wAAAAAC3ByaW50ZXJOYW1lVEVYVAAAAAEAAAA4QklNBDsAAAAAAbIAAAAQAAAAAQAAAAAAEnByaW50T3V0cHV0T3B0aW9ucwAAABIAAAAAQ3B0bmJvb2wAAAAAAENsYnJib29sAAAAAABSZ3NNYm9vbAAAAAAAQ3JuQ2Jvb2wAAAAAAENudENib29sAAAAAABMYmxzYm9vbAAAAAAATmd0dmJvb2wAAAAAAEVtbERib29sAAAAAABJbnRyYm9vbAAAAAAAQmNrZ09iamMAAAABAAAAAAAAUkdCQwAAAAMAAAAAUmQgIGRvdWJAb+AAAAAAAAAAAABHcm4gZG91YkBv4AAAAAAAAAAAAEJsICBkb3ViQG/gAAAAAAAAAAAAQnJkVFVudEYjUmx0AAAAAAAAAAAAAAAAQmxkIFVudEYjUmx0AAAAAAAAAAAAAAAAUnNsdFVudEYjUHhsQFIAAAAAAAAAAAAKdmVjdG9yRGF0YWJvb2wBAAAAAFBnUHNlbnVtAAAAAFBnUHMAAAAAUGdQQwAAAABMZWZ0VW50RiNSbHQAAAAAAAAAAAAAAABUb3AgVW50RiNSbHQAAAAAAAAAAAAAAABTY2wgVW50RiNQcmNAWQAAAAAAADhCSU0D7QAAAAAAEABIAAAAAQACAEgAAAABAAI4QklNBCYAAAAAAA4AAAAAAAAAAAAAP4AAADhCSU0EDQAAAAAABAAAAHg4QklNBBkAAAAAAAQAAAAeOEJJTQPzAAAAAAAJAAAAAAAAAAABADhCSU0nEAAAAAAACgABAAAAAAAAAAI4QklNA/UAAAAAAEgAL2ZmAAEAbGZmAAYAAAAAAAEAL2ZmAAEAoZmaAAYAAAAAAAEAMgAAAAEAWgAAAAYAAAAAAAEANQAAAAEALQAAAAYAAAAAAAE4QklNA/gAAAAAAHAAAP////////////////////////////8D6AAAAAD/////////////////////////////A+gAAAAA/////////////////////////////wPoAAAAAP////////////////////////////8D6AAAOEJJTQQAAAAAAAACAAA4QklNBAIAAAAAAAIAADhCSU0EMAAAAAAAAQEAOEJJTQQtAAAAAAAGAAEAAAACOEJJTQQIAAAAAAAQAAAAAQAAAkAAAAJAAAAAADhCSU0EHgAAAAAABAAAAAA4QklNBBoAAAAAA00AAAAGAAAAAAAAAAAAAAEsAAABLAAAAAwAUwBpAG4AIAB0AO0AdAB1AGwAbwAtADEAAAABAAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAASwAAAEsAAAAAAAAAAAAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAEAAAAAEAAAAAAABudWxsAAAAAgAAAAZib3VuZHNPYmpjAAAAAQAAAAAAAFJjdDEAAAAEAAAAAFRvcCBsb25nAAAAAAAAAABMZWZ0bG9uZwAAAAAAAAAAQnRvbWxvbmcAAAEsAAAAAFJnaHRsb25nAAABLAAAAAZzbGljZXNWbExzAAAAAU9iamMAAAABAAAAAAAFc2xpY2UAAAASAAAAB3NsaWNlSURsb25nAAAAAAAAAAdncm91cElEbG9uZwAAAAAAAAAGb3JpZ2luZW51bQAAAAxFU2xpY2VPcmlnaW4AAAANYXV0b0dlbmVyYXRlZAAAAABUeXBlZW51bQAAAApFU2xpY2VUeXBlAAAAAEltZyAAAAAGYm91bmRzT2JqYwAAAAEAAAAAAABSY3QxAAAABAAAAABUb3AgbG9uZwAAAAAAAAAATGVmdGxvbmcAAAAAAAAAAEJ0b21sb25nAAABLAAAAABSZ2h0bG9uZwAAASwAAAADdXJsVEVYVAAAAAEAAAAAAABudWxsVEVYVAAAAAEAAAAAAABNc2dlVEVYVAAAAAEAAAAAAAZhbHRUYWdURVhUAAAAAQAAAAAADmNlbGxUZXh0SXNIVE1MYm9vbAEAAAAIY2VsbFRleHRURVhUAAAAAQAAAAAACWhvcnpBbGlnbmVudW0AAAAPRVNsaWNlSG9yekFsaWduAAAAB2RlZmF1bHQAAAAJdmVydEFsaWduZW51bQAAAA9FU2xpY2VWZXJ0QWxpZ24AAAAHZGVmYXVsdAAAAAtiZ0NvbG9yVHlwZWVudW0AAAARRVNsaWNlQkdDb2xvclR5cGUAAAAATm9uZQAAAAl0b3BPdXRzZXRsb25nAAAAAAAAAApsZWZ0T3V0c2V0bG9uZwAAAAAAAAAMYm90dG9tT3V0c2V0bG9uZwAAAAAAAAALcmlnaHRPdXRzZXRsb25nAAAAAAA4QklNBCgAAAAAAAwAAAACP/AAAAAAAAA4QklNBBQAAAAAAAQAAAADOEJJTQQMAAAAABEhAAAAAQAAAKAAAACgAAAB4AABLAAAABEFABgAAf/Y/+0ADEFkb2JlX0NNAAH/7gAOQWRvYmUAZIAAAAAB/9sAhAAMCAgICQgMCQkMEQsKCxEVDwwMDxUYExMVExMYEQwMDAwMDBEMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMAQ0LCw0ODRAODhAUDg4OFBQODg4OFBEMDAwMDBERDAwMDAwMEQwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAz/wAARCACgAKADASIAAhEBAxEB/90ABAAK/8QBPwAAAQUBAQEBAQEAAAAAAAAAAwABAgQFBgcICQoLAQABBQEBAQEBAQAAAAAAAAABAAIDBAUGBwgJCgsQAAEEAQMCBAIFBwYIBQMMMwEAAhEDBCESMQVBUWETInGBMgYUkaGxQiMkFVLBYjM0coLRQwclklPw4fFjczUWorKDJkSTVGRFwqN0NhfSVeJl8rOEw9N14/NGJ5SkhbSVxNTk9KW1xdXl9VZmdoaWprbG1ub2N0dXZ3eHl6e3x9fn9xEAAgIBAgQEAwQFBgcHBgU1AQACEQMhMRIEQVFhcSITBTKBkRShsUIjwVLR8DMkYuFygpJDUxVjczTxJQYWorKDByY1wtJEk1SjF2RFVTZ0ZeLys4TD03Xj80aUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9ic3R1dnd4eXp7fH/9oADAMBAAIRAxEAPwDzoKQTBOFIuXCcJBSCSVwFLQCToFHc34/BRdudr27BOESUGQCz7PHQdgmqZbaZBLGeI/77+8pVY5d77dfBv/kv/Iq0AkZdAqMSdSwZUR/hHu+J/wBiO0KG5reefAJxaewjzOqbwk9F/FGPVM1sp9zA4M3Dc4wG8lA3Od9Ikjw7KL2H83Q8j4o+33KPd7BvNCI0JUkXVtsj6Q+4/nD/ADkX0nATyPFQk9GyPBTQj1WANIPYEtQAeynjU25lhrp0raf0t3IH8hn79iaQusDd0MJ9Po22ZDnOgBlLY5e4fS3t/wBEz3q9Xju9Cu93tbbJra7RxYP8Nt/Nqc76CotosoJZlNc+qScRrWfzzbDrOz3v9NzfTd/N1/vrVx3PfcbLP0/UvpOFjga8dg9rLrdvtc//AEbNuyv/AAXr2fpFDPrSBJauvyViuk+CA+2XbaSdg03xBP8A5BSqYdP71HwSIsmlGb//0PO1IJlIKReuAhk7SWukn80+SKFG0aNdEgSDIlEHVEhowFo4I1RWuaeD96TDW5sRHx1j/O3JzjM537fkE7i7reHTQriRwY+CK15A1E+H/mSGxgaIBkTzEKYCcQDuoSI2K8TqdSeSpgJgFMBFauApFkhIBFY1AlKTprvc+k/12/keFpVtWdSzZcy1vLTqOxB0eFq0WUviHbT4O0VXMCDYGhbWGY4aJ1Cqelu6hlUYzX+i2x8XWASRWGvcYH77nNYt/Ew8PByxhXVONVVbbG3wG4zd5dsZY57t9t7/AE3f+pP8GHpFe3Op8ZJPya5bHX7m0dNoa+XbrRtYOC4Me7+KgMiRW/YKkbnV6bIM/I6Xk1OoflNba3Wt7Nxcx0f8G36Lm+16x6WhlZpraGVE6taOf5T3H9JZu/loVTDMu1cTLj4k6q1W1EgDxUPBJWxWqa1GqvhXaKeFHIpf/9Hzppj4eCI0goQf4qYIKnoFQJCUBTCE0keYRWOB8j4FNIIXiQLB1BndVof3f/Ipm2DhwgjlWmtUjjV26vbJ/eGh+9ITrdRx3sgbBGmqmApnpdvNL58nCD/nt/8AIqD68zHE3VO2/vRLf+3Ge1OGSJ2IWmEhuCkAUwEzRoD46ojQnLF2hFa3VRaJRWtTSUs2NV3p2PVkZdWPa/aLJIESXbRvdW3932qswaq7j1ugPYdtrbGGp3g5p3qLIdDrS+O70ODT6fVWMHEOLfgWuhWfrWRtwqv5Vro+ArZ/FQ6ZZ9o6vW+IbtdDfABuv/SUvrKC/MxmD8ypx/z3/wDqNVYr+ocitg0VymqUsfGJIEfJbWB0s2ODZDTE+49ggTrS66auPjkxotPGxHHgSr9PT6Khr7z9wViABAEDwCIxnqtM+z//0vOBE66D70kk8f7lYQuHEI1ZY7Qu2nwPH3oICkAkpvDBzG5VONZsrN7G2tse8tY1jw5zHXOj9H9D6H9hNYyyi6zHvmq+lxrtrcdWvbo9h/qpdMrDrYA+lZWPvcr31wbV/wA6OovpO6q+xmRW6Ilt1ddzXa/1kLPFw+Fp6NNu48PJ+Dj/AHorfWHDn/5zv71QAU27hw4/IokIb7ayptrd4Kkx9o03u+8ojX3f6R2mv0jr8EDaab7aXHgI1ePYexWc2y3vY/x+kUeLWPdXZIc0w5pMwRyOU02kQ8XTZjED3QPiQPyq7h1jcSDIqEAjWXv9zv8AMr/8+LP6TTgXZtVOe+2qi0hpspa1xBJAbv3h36N377GWbFufZW4jziNeLPTJ3WAFoJd+kmH+7217FXyE7L6AbHT87GwMyu/J3CshzJYNxBI+nt/cb/IVzqeXRfmCyhzLq/SYG2NMg/Sd5fvfnLnLLPtF3t+h9Fnk0al//f1oVEAQ3QAafBQzFADruyRiNy6dNrvGAOw0/Ir+NkOY5rmGHNMgrIrcrVVkKA6G15D1ePkMyK97dCPpN8D/AORU1z+PkvY4OrcQ/sR+RatHUqngC0bHfvDVv3fSap4ZgdJaFhljI22f/9PzkKQCYKQCsoVClHY8hIBSASU3el+22t3/AAzPwcxX/rbWB1HGs/0uHXJ86bMjCP8A7bqhgwBJMbHtIEEzqHOXTdc6dTn9C/alcm3FbZbRyJxrMi7Ls9Vh/wALUzI3f9aUcyIziT19P+Mkah5CCTJ/u/IpAd12XQP8Xv2vFqy+sXXY7rvczCpDW2Bh/mzfdaLPTst+l6DKv0bPp/pEfqHQfq+9l/Tuj4o9apojJ3Otvfbu2V+nZa7+j+r+it2enVZ7/wDg0JZ4RNanXpskRLxYbBiQY7jUKQHkp2U20XWUXsNd1Tiy2t3LXt+kwpxJgeGg/KpFLsaisEcDQKDQjVATB0HJPkNU0rg6vRKWnOpe4e2vda74VtdZ/wBUFrZPqZnR8fqFFQ+1ZTxi5NdLTLrJcxrmMl/vtZXVW9ZXRHOPTs3Md/oHMZPb1n7GN/7bYt36rXudi5uIwkOaRayDGjx6dn/npVp7k/u0m1sfGZ0XHdkvcLM94NYLTLKy/mmr/Sv2/wBJyP3P0OP/AKWynU6AB4IefmjKyP0ZmiqWVeB/fs/t/wDntRY9REE6ncssRQdCt6Ox6oMs0R2WeCjlFe6DLUdl8d1mttRW2qMxU//U87AUhxH4pgpgK0tXHHCkAmEBKfBJTodP6Zl5jDfW9tGNVYGXXWP2tlwkVsqafVybNN3p1s/4z011OL1+jpHROn5NmLZmNez02BrmsaHgvLPW3iz6bWu2bWfmLjsC4UZIsPDhtce8f+dLoemZmJf9WX4ufU59NLRTkiv6barC5+N1Chh/nHUW+70dzP5lQ5RdWLFjRcGzk/4xcvJmg0U4NF3tsuFj7Lg0/Sc10Vt/ru9Lf+4mwMt2Nm4l9k1tyH/ZWtmNjLAX07h/pH5FVX/F/wA2uMbWPTfVIdZSS4ObMPYP52Nwb/4YZ/11bfT73Z2DRjavyaMihga3V7mOdtrsb/KYzd/22hLHGtBV6FNu/wDWrpYtpHVaG/pKWhmW0fnVj213/wBbH/m7P+A/4hczEfLldXZ111FmFe812dPyK7G5DmDcHPDvSvs3fn0sj2M/Pofatnpf1T+ruJUzJtxjk2Pl9bcl3qMa2f0fo4/tq9Pb9B+Q216jxzOOPDPWvl/73/BSddXiOndL6l1M7enYr8kAw61oisf8Zk2baP8ApqXXul5nRaGMyXVOsydzWilxeAGBjn7nFrPzrNvsXptl7ntDB7a26NrGgA+A9q4f69/psjpunt9e1pPk1tRP/UIxymUwKoJY01jG+rgbwb72M/s1N/8AJ1vU+i5r8LKuvYAQKHh+7iJa5rv5XuatKjpeL1Dp1GGcr0sjGG51bAHEOeN7/Vqdtc7+c/wble6R9XR0r1snONeVuAZRXtO0yDu9auzc3fr9D9J++oyRUvEqeTqcGsHiBwjMsE/BR6m2mnqWVTRtFTbTtazRre7qmj92p+6tCbZ+KcRYvuygt1tiMy3zVAWR3U22wmGC4F0Rapi5ZwuUxcmGCbf/1fPJUpKiJGoUgrS1cKQTBSmdSZKSV9TrMHy0WhjdRrpvqsLW1+ow4+VXW0NrNc/orI/0jHtZa7/zNUIjRRtgCTx3QIBCWWRfViZdlfoDfVc4eqXvJa0HawV1tLK/az/S+r6ijbflYb3149hqpuZH6OG76yZ9KyxvvtZuGz3O/SKvc/1L3PdrugmedAB/BXulYX7QvZj3vc2msbmxEwS1rm6+76KYetqep+qQxep1V4+VWX1U3faaf3DYG/psd37zPU2Wvq/4RdwXucS5xlxMklcr01uPhPoZjsFVNT2w1vgTtc537znfnPcunmDHhoquQ2bXBk6wMY550DAXH5Bcabcfq+Q6/wBUXV1+xmO0kOaAfd67HbbWvsf73+xbvW8706xiVn32ibT4M/Nb/wBd/wCoXHdbYy+1mwBuRU2fVHteSeK3WNh/0UscbPbxS9j0nC3ubm3CWtO6hp7kf4Y/yf8AR/56h1LKu6Z9sy7bH3PcGtw3WOLpe8uhmv8AoNu+z/g2Kp9VPrMOpVt6dmmOo1Nitx09djB+7/3Kpb/PV/4Wv9N/pU/10saMDEZALnXuLT3AbW7ft/rb2ICB4xE91PMh/iZPdx5J8VIPVfelvMHXQqzwrgW0LPA/H5qXqqp6hiJ0H8UvUCBiutueoeRx4peuQCATB5HjCp+qmNpQ4E8T/9bzwJwohSCtIZtBMwCYEmBMAfnH+SpNAIJJiBoIJkyBt0+j+/7lAH5eKkCkpmITwCCDqDyFEJ57JJQGoMfB9wGoJ8Fq9AP69P8AJ/781ZtxhwPPZWelZdePkl9gdG3QASdHNcmSGhCnr2uO0xzGi6O3OrpwTmvG4CsPDAQC5xHtqaXe3dY/2Lhf26waV49jv6zmt/JvV6zqmRlYeNTYz0m0glzJ3SS53p+7T6FSrSxnSwuCHI61+kdfnUX1Gx0ufta5kn8xr63ub/IYqD7fUe6w8vO4+GvCn1KwWBtBOhBc74n6H+aqGNYTXsd9Ks7T8OymjEAXVKVley+u6lzmXgh7XMkOa5p9lzHN+i/ctbqnXLurY2F9pr9PJx22DIIgNe5xr2XVtb9Dexn6Sv8AMs+h+jWYXyZGgUd6fwCwTuEpS7vKYv8AND3Ji/SNdeyNKS7/ADTF8oRco7/DRKlWm3pi9B3qJehSrf/X87CkCoAqQKsqZBOCogp0VJJTyoAjt8k4KSVsgAaAh0GNzZgx+c2drtqWIAbhPGqa3Vh+IUsIj1x5App3U6tDQ3UjXsP71ZbZKqNcldbtpdB1PtHz5/6KaRakdlvqWOf+8dPgNGoREWmwH6TYIUQ5MXalOASGe5Iu8+eyHuTbk5LPcm3KG5MXJIZlyYuUC5MXIKZlyjuUdyjuSRb/AP/Q85lSILXEHkGDBBGn8pvtcoAp5VhTIFPKjKcFFLOUpUJTyipk76J+CWNYxlu5xgQVFx9p+CEzlNluoumMukfnE/AFQtyWWua1pPt1g6SSqYKZx1QQ290BNuQWWOc2D27p5TgkJXS1xaYlpIMEESP5TZa5MXAgACCB7jMyZPu/k/uocpFyKWRcmJUdyaUkMtyYlRJTEoKZbkxKYvcQ1pJIbIaPCTuO3+0oygp//9kAOEJJTQQhAAAAAABVAAAAAQEAAAAPAEEAZABvAGIAZQAgAFAAaABvAHQAbwBzAGgAbwBwAAAAEwBBAGQAbwBiAGUAIABQAGgAbwB0AG8AcwBoAG8AcAAgAEMAUwA1AAAAAQA4QklNBAYAAAAAAAcACAABAAEBAP/hDmFodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMC1jMDYwIDYxLjEzNDc3NywgMjAxMC8wMi8xMi0xNzozMjowMCAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RFdnQ9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZUV2ZW50IyIgeG1sbnM6cGhvdG9zaG9wPSJodHRwOi8vbnMuYWRvYmUuY29tL3Bob3Rvc2hvcC8xLjAvIiB4bWxuczpkYz0iaHR0cDovL3B1cmwub3JnL2RjL2VsZW1lbnRzLzEuMS8iIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giIHhtcDpDcmVhdGVEYXRlPSIyMDEzLTExLTI1VDIxOjQ2OjMwKzAxOjAwIiB4bXA6TWV0YWRhdGFEYXRlPSIyMDEzLTExLTI1VDIxOjQ2OjMwKzAxOjAwIiB4bXA6TW9kaWZ5RGF0ZT0iMjAxMy0xMS0yNVQyMTo0NjozMCswMTowMCIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpCRTRFRDREMkREMjU2ODExOTk0Q0QyOEFDREYwRUJEQyIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDpCRDRFRDREMkREMjU2ODExOTk0Q0QyOEFDREYwRUJEQyIgeG1wTU06T3JpZ2luYWxEb2N1bWVudElEPSJ4bXAuZGlkOkJENEVENEQyREQyNTY4MTE5OTRDRDI4QUNERjBFQkRDIiBwaG90b3Nob3A6Q29sb3JNb2RlPSIzIiBwaG90b3Nob3A6SUNDUHJvZmlsZT0iQWRvYmUgUkdCICgxOTk4KSIgZGM6Zm9ybWF0PSJpbWFnZS9qcGVnIj4gPHhtcE1NOkhpc3Rvcnk+IDxyZGY6U2VxPiA8cmRmOmxpIHN0RXZ0OmFjdGlvbj0iY3JlYXRlZCIgc3RFdnQ6aW5zdGFuY2VJRD0ieG1wLmlpZDpCRDRFRDREMkREMjU2ODExOTk0Q0QyOEFDREYwRUJEQyIgc3RFdnQ6d2hlbj0iMjAxMy0xMS0yNVQyMTo0NjozMCswMTowMCIgc3RFdnQ6c29mdHdhcmVBZ2VudD0iQWRvYmUgUGhvdG9zaG9wIENTNSBNYWNpbnRvc2giLz4gPHJkZjpsaSBzdEV2dDphY3Rpb249InNhdmVkIiBzdEV2dDppbnN0YW5jZUlEPSJ4bXAuaWlkOkJFNEVENEQyREQyNTY4MTE5OTRDRDI4QUNERjBFQkRDIiBzdEV2dDp3aGVuPSIyMDEzLTExLTI1VDIxOjQ2OjMwKzAxOjAwIiBzdEV2dDpzb2Z0d2FyZUFnZW50PSJBZG9iZSBQaG90b3Nob3AgQ1M1IE1hY2ludG9zaCIgc3RFdnQ6Y2hhbmdlZD0iLyIvPiA8L3JkZjpTZXE+IDwveG1wTU06SGlzdG9yeT4gPHBob3Rvc2hvcDpEb2N1bWVudEFuY2VzdG9ycz4gPHJkZjpCYWc+IDxyZGY6bGk+eG1wLmRpZDpBQ0Q0NjE4RkNDMjA2ODExODhDNkYzMzA3NEY1OUZBMzwvcmRmOmxpPiA8L3JkZjpCYWc+IDwvcGhvdG9zaG9wOkRvY3VtZW50QW5jZXN0b3JzPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8P3hwYWNrZXQgZW5kPSJ3Ij8+/+ICQElDQ19QUk9GSUxFAAEBAAACMEFEQkUCEAAAbW50clJHQiBYWVogB88ABgADAAAAAAAAYWNzcEFQUEwAAAAAbm9uZQAAAAAAAAAAAAAAAAAAAAAAAPbWAAEAAAAA0y1BREJFAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAKY3BydAAAAPwAAAAyZGVzYwAAATAAAABrd3RwdAAAAZwAAAAUYmtwdAAAAbAAAAAUclRSQwAAAcQAAAAOZ1RSQwAAAdQAAAAOYlRSQwAAAeQAAAAOclhZWgAAAfQAAAAUZ1hZWgAAAggAAAAUYlhZWgAAAhwAAAAUdGV4dAAAAABDb3B5cmlnaHQgMTk5OSBBZG9iZSBTeXN0ZW1zIEluY29ycG9yYXRlZAAAAGRlc2MAAAAAAAAAEUFkb2JlIFJHQiAoMTk5OCkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAFhZWiAAAAAAAADzUQABAAAAARbMWFlaIAAAAAAAAAAAAAAAAAAAAABjdXJ2AAAAAAAAAAECMwAAY3VydgAAAAAAAAABAjMAAGN1cnYAAAAAAAAAAQIzAABYWVogAAAAAAAAnBgAAE+lAAAE/FhZWiAAAAAAAAA0jQAAoCwAAA+VWFlaIAAAAAAAACYxAAAQLwAAvpz/7gAOQWRvYmUAZEAAAAAB/9sAhAABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAgICAgICAgICAgIDAwMDAwMDAwMDAQEBAQEBAQEBAQECAgECAgMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwMDAwP/wAARCAEsASwDAREAAhEBAxEB/90ABAAm/8QAxAAAAQQDAQEBAAAAAAAAAAAABAMFBgcICQoCAQABAAEFAQEBAAAAAAAAAAAAAAIAAQMEBQYHCBAAAgIBAwMDAgQEBAMFBQcFAQIRAwQhEgUAMQZBIhNRB2EyFAhxgSMVkaFCCbFSM/DB0WIW4fGCJDRykqJDU2MlF7LCJxgRAAEDAgQDBQUFBQYEBgMBAAEAEQIhAzFBEgRRYQXwcYGRIqGxMhMGwdHhQhRSYoIjB/FyktIzFaLCUySyQ7PTNBajRCUX/9oADAMBAAIRAxEAPwDjqWQPWNQDP4mNB37fxHbrryyvkHIOiFAjWCQe8d/pJkxO7/t36RBxyTEMcUQIERp6jTuQNAdD2J17f4dLJFGrBLqIUH/ELoTEzIEzB016epo1E70S6KRJ09JA0MgmCDGuo16WKeqKUaDtrA0AkAjQ/wDlmOn5I28kui9iQCAB3JA/N3JkaAn+XT5o8wiq1BIJgHUCBofQbQO8fWY6WacCjkIpE9zfhtIAAAj0j/lBMdv/AA6RDogOTo6usCOygQFDSd47QGBIkEz9I/zYh07OjUUd9pMdwPaYgkElR/zD6gfz6FmopIhgUrY9WJULL9FY/wBOvdDXMYMUtqsqogsdF9fSZ7Nm7uLgs2YvNqk4RHE/YMTkhvXrW2t/Mu4ZDMnl9+AUXys6zJdnsMKP+lUG9tYYdpgglxBLHU/gIA6nabO1tLemFZmspHEn7AMhgPMrmt1urm6ua7lIjADAfjxKaMrlf0Q0tsFukU12umkgKTB2qqn1Pf06bcDbRpctwlPgQCooXbsPguyA5Ej3JtxfIPJ8vLTHwMzkLsixpqxaSbtF9AlgcBFHcmBHc9Yl21ti85WYRHKg9iu2d31Ccows37kpHJ397qdcev3LsZd39vrUEe7kFwZ0EgxiIbvUf8Ne3VScdoHYzHcT9q1rQ60SH0fxCP2VU646nyoMv9wyOAJk71xcTkPkIEiFL5mPVGnfbA/y6qT+TlKenm33LXsw39DenZccBJ/eB7FNsKpjO5VWVBkCRAUk/maAWIJAO49uq0mydaVaAsnSmsApuXQEttAZoP5QAwkEqG01IA179RSzZSCuSdaKiRHb2CSdxA1EPACiUX11/l1FImimjHwRa4xf3UhigIAkBVJ9pBn1IQ99IB10iYzJqEqX5b4I6qtgnvC75BWR7gzDUhwVMsAO3f8A4ASHd1LGNGo6cqadyLuHuAI1Mdt35gCADIk6D/M9RTIBLYKzGJMIuKpzooB71RuI9xfcArlZdZ07nUa7tI/CJ5Fg7n7lbhBhWPYp3rp2gbWbaGAnV29hG8soA/Mze70judOotWLqyBUcE/4lTMwZkmBuDE7dQJX3ALL+kmPw+nUE6ChUwBJwcqQUoGBkH8QVjUkNqNoO0f8AtnqAkhTxgGrinumlYGhCqikyzFdFLDbJJLBzqAQe/wDHqCRc41KsxjmQph49lV8fko1jTh3BUytyGaNxYfNtXVhugED/AEE/SOqG7ib0SIj1jDny7Zq/beIGk0zVq/8A0GFyOdUyrcKTYGdq7EB2MtXxnaFRVa6drAgkx36xq3Z2rZDxfu7YY8Fdi5NUpwHlfMWis28T/cU+ZMQXYdbLZbezIK8YKwsrutuYgFQASSNJM9BudjZqI3tMmdjw48gpNFsRJJ0hq8FmTy32g5Dxn7aeN+ectmJx+R5HzL8dx/BZihs7MxKMGzJy+VwjWzG3D46ylMa5zKNdaCug65GW8md/PbCANoQJ1DIuzEcC5Me4hZWx6rDe7vcbezbJt2x8WRrTxOIzZMHHYQeFCrtUKwLJAkOGhQpmvQkbdYn2gkdQ3b2kB8e3mteor2/FTDBwmYAAKAv1AllDPBWCfaOwB1E/jrn3b2koxJg5wUy4/il3IAo2q6mPaGZg6yrQCXAKhtY+p79Z17caomte39iEzoWUvw+LR43BQSdZDwSwYBhtgAmIH+ZjXrNu7gjBC7Dmyl2FxLQG1BLD+m3ewLDbdoChnJEKF1U9+su9uhUHBBKTKS/21tkbdInZru/JMTsnvpHf8J6o/PrigfNf/9DjsA9sa6an/CZPpHXXM7cFpAtgiUBMSfzgALBEgekHvBA7jTp0wFdSIVRIM94E/WJPp2I+nft0/cmGTogLpAX/AO7oyzB9xiJ0/DpAIm5IhNBI/MCpA0BAn1kk6+nb+PST5ImD7I1IkkqI1/gNO479EjGCJAKxOoKz3IgElinq34/TpIs3RdYiNCO3qfp2J1kyf+3bp2RMjkGsiZIk6R3/ABBnaBJ/HpiiFC6LrWIA0BECJAYRopk6x3EadM7NSqIZJTIyacFA9o+R2LmugSGcCPexmVpDaFvXsJ9Jtttru7um3apEfFLKP3ngPE0UW43FvaQM7heZwjmfuHPwCiuTl25FjW2MC/aJhESZ+NFLeyoGTp3Op66rb7a1tbQhaDRz4k8SezZMFzd+/cv3DcuyeR8gOA4BRvN5YKSmOZb/AFXeiGIisa7o117DqK/uhF426nio2epwSXC8DyHkFzWUzVhq+3J5C4M1QbT+nXpuvujQBYA9SOsi9uACSayV7Z7G9uyNFLYxkcPxPJXjwPj/AB/C1GnCr9zoRkZVvvyMkjUC6wLIAMwghB6Cesu7dlcxNF1m12Vnawa1HHEnE9/3YKS1ViSdSN3unUAhi0LJI3CP5QDPUcizPiytgRqWqnSpBuRrB7XOogkwfzFgdxYa9+89QGXpkysRajp3rpIQEbqy6EELtZirAe2CJH00gkEDqEyq2TomJyTrj0NqxDEoyAN7QWJXRnnUiNJ7toeozLEOp4QJ70804oI2QG3SpRN02MLPdtUEFy35pImDp1XnNqv55KzGLlmr70pdl8fx6EZubjYhWN6WWmzJAVogY2Ot13pp7PxjQwdnbbvdyP6Ta3Lo4gen/GWj7VHf32x2cQNzuoQlwJeX+EOfYo5yX3B4zFV043jMnkrOyW5ZXAxtxBghUN+Y6lhMf0jr362dv9K9RuMd1ft2hwHrl9kAcvzBYu5+rNnDVHabWdw8ZeiPkHkR5KceM5D85wWDy1Jrm6splY9YO+nLrZ6r6dpUhqxYCV0mGB6wepbc7LeX9tIE6TQngag+X2rqOlbmPUNhtt3FgZBpDhIOCPtHJSCtGLKrIpLSSrfmDhhEho1G73AHuZ1iOqBkKsVqCpZvtT9j1bRWSBoY19qj0glggKsewMgH6x1HIvgTgpos2CdqFJX3LG2fb7gNm5WDABirbt/aB+B7DqIkvTBSRAxdlIcKsOyqwJYlWAJVtu73LqCpgt+BH4z1BcJaRU8AXLVTvWJldpBIO7uCkn2nbJizt+aSYgdtYTkdVPerUA1M0VTCtJLDYm3SdQpG7aonYS7xGgUA9zp0Em0sBn293erduhaRopZb5DWvANhXu6tTZXWbYPxnEWbQCwG5jWUVSsSQwMenVIbWR3AuDAh/HtXwV2DM5kwrVT/7N4PO855l4zVg5NuDZVnPyFpami1ON4yuBl2W15FdtNVl1Z2uxUNVvCjs0D1eO12HTN7utzbEvQwxDk4YMeYFXryWD1TqHz4Ss2h6MDzOQ7fYsjPuJ99PMfuz5ZkcpRj4tvFcNjYvjfjiY2EauPw+HwbBi4gwMDGsrw8SzlbR8pRAWsexVUE7V647adHtbazajuZk7y56pAFi7PpwJIgKeciQ5Wx03YWOm7KMZU/NM8Sca8sAs5/t79ssH7LfbjI86+9ODh879wvN+LyuO8W+3HJ1qnH+P4GQtZu5HmaaosTla1NbWuGD4QK46N87WMvOdavbaco7TZRqC+sE6nGYL/DiAG9ZcmgYYh3256z1EW+nzla2NqQMpjEtkO/8cFVPF42PmJcmFbVknE+Jsr9O9eQcZbCwpfJNfyHHGRZ7ELn3HRZaR1hbi5ctsZxIEnZwQ/FnxbP2rpNQ1iMpDVkOzYKb8fxcBWRFhn3FihVEJKhSw9NRMDQ6SNesi9ua1NR5pGVcVNsHiwy6kDaFLMwRKVRTAZpIValUFWMhRH8usi9u61PdxJ4DnwzQy54VUwwePxLAs5WLqysW/UUuCsge3+rO1vSIEnTXvn3r9yLj5Uwe4/co9YykG71Lv7VX+l/6tETv3/LVsme+75d/5dY7R69Zn6iXzcC/cVHri/xe1f/R471EgFogCf5jQCSI9R37Drr81oEAZIhR2/0/wiAO+gJAX8dR/PpjgnBJBoikEKJ7nt6qBp7vza6nokmqEuIj8o1kQ0/l/jEt3Hp6npZp+SXUGYA101mOxJ1JP1HSwTj2IxVIUQNInvrt1IMCQJMn0gDToijGHNFKpIEkj3SAJMTukQPUdp6SMVRlfZdqjSFIJETPaCPdp/L/AB6SNuARlabnOkkgHQgfTQLA2yfTT/wRLVwCcByvV+UuIhNdfyZBA21DX4wfyveFllrJ9O7fgJPVrabK5vZHQdNkGsvsjxPPAczRVt1u7e0i2N44Dhzl9gxPIKK5GRZc7WXMbHcEs7bQQwHZQsKAF0A7D066i1Yt7eEbdqIEBl9vM8Sarnrlyd2crlyTzPbsMlF+WzbflOOGK1AJCqCGsLAMA2skltABp/Hqju70hMwf0oQHwUp8f8Hty/jzubWyjGIDVccDGReIUqcphrjVPI9o95HeOse9fekMeK29n0oza5ug0Mo5nv4D2q4MXGqoqrxcequqmtfjrqRAlaDQFFA9qqwPqNeqMiSXJcrpbUBGIhCAEQnOmqI0P/mGg1AIg7dSA0evpHc9BI4jip4g5o6tZUkruWV3H1J7KZ7E6x9I/HoC2D5J2wqnWqreJRCwUSxWVA9u0l2IhVUAdyD+PVeUtPxSAfD8OKnESRQURQ5DAxjL5lL2wAacdTmMDO6G+E/ApDT+d10/zs2OndQ3bfI2k9H7UvQPOVfIFUr/AFXp21Mjd3MTMZR9Z9lB4kLw3kJrLfocEAEhRbn2h2OoJC42O6bS3b3WH00JPWvZ+l7k67zeCP7tsf8ANL7ILIvfVYAMdntK/tTP/LH7ZFCWcpymZ/Tuy7lp1/pYhGPURr7WWhFZxAH5ixP8+trbdD6VtTGdvaCU/wBqfrPf6nA8AFh7rrfVN0DG5u5C2fyx9Ef+Fn8SV4XFBUAIoLAgwqkloAjsfzHQgatOmunWlqbu+xZYxJKYMzEKlifaNza7dwbUdpCkmTGv+PTyNArETRlZX2g5Q0ZvKePWt7cqv+5YAYyPmpKVZtSgEzvpKPAE+09cJ9YbN47fexHwnRLuPwnzceIXe/Rm9a5uenzPxDXHvFJDyY+DrIWvjse9iWRVMKVuTd8gBhTtbb8bRqYiCJAJ64SUzgDRehxALHNfW4nIxlL7GvoRpLKu0qWKNusBLlDBmR6EH0PQ/OD0NVJpkxo4R1dQ/wBJXdDGTO1kBAYQNoYsB2kadJwRyRxhnPinPHVQd+0FRp7faZlpk+0sa3GnaR6adRzJwdWbebI9bgxVZ2JoQGneCFnaxAliNxnaDrr6jqMghyant2qpw3kvS3MrbjtUbQX3SqoVLSu8nRREt21An69LSGbEupYt+akUzcZb5B5p5LxnjPhXHvy2fdmoaYQNiMtN/wAlt+SbD8VGBSBNlj7VUdjugDUjtttsNpd33U7ny4COBx/GRyGfmsre9UeJsWJfyhiePcsivG/KfMPtr575d9tszxPCzvJPJuNxPGPGrl5OrAxjbyuQCeRHN5aVLZxPJYGTdXCoLBaFB9yleud6rstp13pmw6ja30obK1cNy76TItAfDoD+oSANSzPkXVXaztCdrcTDwh6gOYwfuPesq/EvCE8Ffi+e8szR5N5zhvTyHjfB8EhweC8Ty8Y76Mrh8M7UoswrVB/u+bNoZZqCwQeD3/VbdwXbGwt/K2kqTnMvcuP+3Ln/ANKFOKvRO+63OQJ0bMGpyblxPLzV9eHeK/cj93XmXKeT53lmHmcRw71cb5X5qrhvEfC8fjqA/wDZeJRbasblecbGBtsqpIx1sZrsi4AkGl8iHTrQnu7EoahqEZUncB/NLOEOD+oikYjFWb+/2PQtvDZ7GGq6cBiZE5nj2AV/0+Q/bjg6MP7CfYniruUp8jyqV8h8jbDXO57znOwHN+TyebyVtVX6fg8B6vkfM2042OixWa65L8z1e71Hq1u9uRZH6Tbh3wEeAiMBT8oJkcSodvtLtqY6r1m/pvt6YufQDyGMi+FSeZwhvkXNY3jC146VVZvMXhjRxxtBpxK9f/m+QakOxps1FaJDXakHbBOB0To2669cnPWbXT4FpXGcyI/JbehkPzEuIUcEllf3nULe1iABquHLDxPDkoBkchzPPENyOVZkUOzOMHGAxcCpRqsYtRi9gG0+b5HB9R269F2PR+ldJAO02w+ezG5L13Dx9R+HuiIjkufvb7cbk/zLjR4CgUk47j8ddi/Cg2yqttVYWAJ3AqWKhtCBpH4x0r12Rk+uihq2Cmn6BP00e3bsiPjERt//AFP/ANTb7oj8Os75n83NNXiv/9Lj1gbQYIYTOqiRP+E+h67DgtBEKApiSNIP/lJXUKPQwYj8Y/DpZckQ9qJr1Gmh1ie+h01gboA0k+nSOKQRCqSJJmRoYj6A9vUQe2nT0pVO2HFL1qRO31Mgaj+XqZPc+n+XSDeKdF1gkhvcSDuG3WAVBB0/KCSOnJAZ0YBPel/loqHvsAeV/JNlmhkrsSdsR2Mdvr1Nb2+4vN8uzIjjgPMt7FHc3O3tfHdHcKn2Lx+uG2KaAZJG60gCPpsUnQDsd3Yfj1oWukXJSHzrwiOEanzNPYVSudUiAflWSeZ+4fevf6nJtI/qlZMslKitJI3AHaQ7AzBBJjrStdN2dpj8rVLjL1e+nkFRu77dXXe60TkKe6qUSqTu3A92LCCSYkQTDEnsfxPr1foAAAwVR6l8UpZjVWzuAMhvdEFTrG1vUqP59O3FIFKcRxnFYGa2blVXXZRYfFfYq2V46qAP6VSe5LPUv7j6CNesXf7LdXJSnZYw4Ox9tPatXp242Vgg7iJF16HEDw+1irAx2ryQTS6WCNzNXYCVEAQ+pIJnuY/j1h3IztERuwMZPgQy6q1ct34iVq4JR5H3pzqQTuIBWCWJ9oEMAV/KILnWPUfhqIZGhDq3B2JTjWoG3cPqPaO0+4g1kkKIPae8fXqPMspTEk4USebnpxgWipEuzHRbFVp+LHV5CvkoTuLOmor7xDMQCAb3T+mXepSNwyMNoCxlnI5iGVMDLjQAkUyOp9Vt7BrNuOrdEO1Wi+cueYjmKktiwNfk5JH6nIuyRJlHY/DJbUJjjZUi6fTWfp11u22Gy2n/AMfbQjLizy/xGvtXH397u9z/AK+5nIcHp5Bh7E4U1jVViIlVAO0N7gR6CdjfSY/n1dzDqq7YpyqraCAN0+5ZIMGFgbfRQG7Ezr6HpjTHFIMyNx65IYQSAYHfuxM/l1DBZ7T/AC6EkJzgnFBtUSoJWAQm6SNBt2hQ3uLRI/y6GpfvRDJfM3CLLuCqwWIn0BO6VHZwGk6jWZ1M9MJckccQyYsPKfgOX4zmccEtxuXVdYqe1rKd2zIoJmP6mOzr/PXqn1HbR32z3G2kB64EDkcj4FitTp+6lst5tt3DG3ME8xmPEOFnBxi05lePlYtitXdRRlVOhPwvTftag711IsDqIAInQHt14jf1WjOFyNRIgjNxivcbU4XI2rkKwkAR3GoUrox1VPlcmFX+tuCyUUoXcKiLWzAEECPasz1QlcJ9IOJorUIhiajt27k4P4zhZgRqgce8tXvsSpvicwXC31sJRl2ncwUHsD9TEN7ctkg1t99e3LvU8bTxidVXUazuJzuOAbJqCqS0X1qpxyQTEMi7aDIJgnQRA7kXbO4tXvglXgcfxRG2QwIqU0W2JjrflZD1V0V1u1tr2FVCLE2TAJ3T+b6ntPe3CErkoW7cSbhLAAZ/gnMrdkGc5gQAqcO3vTT45w3lX3e8jo8Q8Mw7Gxt4vzuRtLV4uHh1tXTZyXKZMMcXBp3nYgJe0wqgmANe7HZfT+1PUOozHzWpEVL46YjOXE4DHCq5ze9UluXt2wY7b2y7/u81tM+z32a8e+1/FU8LweM3Ic3yhpTlucsxjZy3NZ24rTTRjJXZbRhV2CKMSsyO7brDPXk/W+ubvrF43r0tNmL6YA+mI5nORzl5MFn6zImWXesqfMP2Cc39z/F8PzfmKquN8/8AFweU8M8YbXM52ul68w8L5FlE1Jgm/wCMWYtW5mryQA7Kljr1S6X9QX+nG/t4SP6K8GlxjiDKPAgOOYycAp9v1K1ZuxgQ9o4nhzHHmsL/AP0V5B9xvK/ILvP/ACuvxHwHgtmV5B49j5TcLymflY7PRn4PkHIZbmzGw8bIr+OwFySGFSorDd1ZN3YfT+z2x2W0luOrXCRC5Ia2eo+XACsiK0GWolqLqJbzcTtWdvtrY0kMAA0e8nurwVl8H92cjlqm+137f+CzOQ8UuOHxXkGZx65HAeA4uJj2A1/qbTULebegk2imsKbzqxuBjrJ3HR9wRPqf1Tvf04LyFsyEr9zP1VaAyq+nhE1Uti1tdkRudxIT3mRxb+4Mzzw7llvyD+H/AGO4HI8Q8HzKfJ/OPIcWgeX+bX1Cu/myYevBwqApbifCsC4H4cRdtnINXusmtYPLvuPq6/8AptsDY+mbEmlKNNZFTCBOMj+eZ+HHEgKtc3FyBjvN9/8AKNbds1Fsftz4y4cMAqSrqyMq27Lyrb78rJua3IyLCDdfc6rrbKsASPaqfkVQAIgDrtrduxtbFra7W1GG3txAjEYRA4eNScSaknFZMrk7twznJ5GpPbt4KW8bgE/Gdqn3ghXkpAIaCo1CwoAntH0jqpeutQGicY1wVhcdhh2GxNJkkE9gYB2lQAPdHaY+vbrKuTodXBEakKY/25f0X/TtiNm3aNm3t22zun8Z9O2nWfr9WNU79zL/0+PjbG3QNoDqZAImA3fU7pj0668v4LRqM6oisEN6A6RtAPeGIG7T+Z00+nTp8Ci0EgETuH1ViDH0PtPSOFE+aIQSNYMKF09NQTMAQJ11+v8AgjXLJPkia1gRqARBIBJKyAV0Ezr/ANj06JkPyuHZl4Ni1O3y0qtldaOwFu389LqpAsDA6TMMPoeprMhC7GRjTzUO5tSu2ZCJOoV7+SaOMzaGoRbbUVqzHvbaXSDtM/8AP6EfTrpLN6M4DVIahzWAQQaBF2clTj3fF8Ztr2ht1bq8yBGm4arPaT1KbwjLSQ4xcJmojqeWwHj+qaWaAfkUqBEAe4Ssx6/+HUkb0CMWQmJTtQ9Nv/TsqsLMCfjtVj27yhBBE+vY9SggihCbhxTiEKnUgE+h9unafd3Cj6adOyYpZJ79tSZ7Gex7GYJMdOCUmoiVrht6mLAwCujlGVhBJDIynvE6/wCPQ3IQuR03ICUeBDo4TnblqtzMZ8RRPmHyefiqdxrzK17q6ivIA03FLUUo5+m4GT3MdZV/o23uCRsyMJcMY+2vtZbW167u7JjG81y3nkfAj7QpWnJY1eGM5Pexf4qMZwAzZEGyLhJKV0q25+8wACAQesCHTd1e3g2MomOc5ZCPEHBzhHm5yK6G/wBY2tnZS3lqQnI0hH97mHoI4njQA1Uf2vbfbba5tttZntsje1llis5busAH07DruLVq3YtQtWoCNqIAA4N28SuCuXJ3bkrtyWq5IkknMopKYKyD9Qfyz2MHttn6STqI106PmgTmiE6wPdtI7NKtELoSQzaj1A/n05qzlLk6dqagSAQS0oSRtDPJ1LboB09JA+sdDXHNOMDgnOmuCQokHYCkBgCwBDEgzsYN3mf8QOoziDmnyCcK6oZQT3hTqdxMHQmY2g66n8O40Z3c5ImpFH24psrcBH1LQCI29/d8hAHrqImJjTtEZDijGKi2dgvDVlVJ2nSABJKnSA5G4iAZM6dFGTsVYisk/sjzDcp43bxFm2zL8evrwQSxVnwbDZdh2EuAvxhS9Pu7/GO3Xk31lsv0fUvngNavDV/FhL7D4r1z6Q3h3nTYbeUnu2Jaf4TWJ948FkFiU2K43sZaFgtDK35XG0gBSCSBA09R1w85RIoF2kBJqqUYOKXdFYqqCUDOVB3Kd6075chE2jcAyk7Y/N1TuTAfMqaOAYJ4tx0etFFftscA1Wj5KyfaiK/yyrM7LATsYkLB6rwmQSXr7fZ7/apoD8r5Kpsb7Eec/fD79fbX7L/b+jHxz5pwvkvK5uVm5T18Rw6+JI2fyfJ5TlX/AKQwbUpoR2h8m2pdy7mYdj0jru36Z0nqXUt2Ndy1OMYiglLWKRfmQSeQJqy5L6nlO3uNoCT8gxJIH7QIr7fBbbvDP2ic/wDYnxq7jM7guM8M8P46lOQ8s+4/lPP+P8f4/RVXbj02855d5NZmnGxMf5b1SpHCoC61VJuIB866l1jede3ovT13NwTpjbiJHSDhGER76knFc7G/CWBrw+5bEf22+IfZfI8bp81+23mPj33UvN1/H3+dcRfTyPHYedQvx5eFwKDcMPFZCCt4LNkVEOrlGjrC3lnd7e8bO7sSt3aHSQxAOZHZuChvzvPGM4mMCHA4jjzWVXxPDAiCoAG9iygrMqza92Gh1ntodTVIoTk6iAyGC12fvM/a5xnlyXfcrgOEx+QqsyMK77j+PVLaK+Rx8e+gVeWV14bVXfrMVKwM34wrPVFwYEWk6vT+rXNhC41wiUISMJUeND6Q70l5PkzLo+j74xI2lybA/Cfs+7y4LDbh/IuS4a5eP8Yx8PxfheLd8LE4ji+O484aJXbtD5Qyca8PbetUltAdRqw3G1uuh9P6ltYy6nrv37sRMylOcTUOw0yFA9AX48lZhvdzauyuQl/Mchyx9/2J8qFmdmX52XfdfmZVnz5OVa023WvIUsCtSbKyQAFBCogAiB1Las2dntbW021qNvbW4tGIwA97nMmpJJLkqKdy5cmblyWqRqSe3lgpfhYBZFSz2F4QkklQBtJkywVQDBaCIA+utS7dANMQnFMFM+OwAXAVQw2rBYAlSFV9YJQEkAGIB7a9UbkvSTIqWuasfh+Ma47gwXWXJEBmYmK4AIrMtAPdR6ehy790RBDJyWyVg/2tv0uzaNkzHr/05nfP1/1fX0nrL+aNbuh1Vdf/1OPwat7u6iJBOp7wTOhG30/w67BuC0ji7JdANzmZE7izTI3ExqZ9xI7H1H06ejDimqKvRFVmIkCIEqIAjuCNdNSP+09NXwRB9XJFIHIb1IMDUntqQwjsGHc9OKo2oikjsNpaRHaIEwTB7yf5aQfo6flmjEXdERMCCuuvfSSPQ+noelxRR4qF8/w9+NmLZi02W15wstWuoS6W1uq3Ktanc6kuGECVmD1ds3gYGMpMRnyWTu9tKF0StxeMq0yOaZaKUZhVkZP9uv3Qn66i+rHY6gKbwpNXp+Zdv49TG/KJcB48lVjaBLSnol+8CB55eKfT49zlSh1xEzUYKUswsqq9LE/MGQBkYggegMevRw3tr4ZYqWWw3IGoQ1R4ggoOyrIxW25GLk47CZF1FtZiTEswAAJ0kanq5C7bmzFVZ27lstcgR3hSLB5l6K1U1fMAzQxtYt2AABhzpIEdur8LrRAZ1EY0xTvVz6FkV8JwzMoAV1YGSBqSB7RP4n+HUnzP3ULYqVIk7SQDP4akanuYMSNDOkdSnDmlxR1KAMAdqwQZJ1EDssygAB7evRM2BTtR0dXWsAyohtWiF2zLCANNP4du3foo4u1EOGSORIGqgdyBIJ2xMD8pJ3GNNQB+E9EwAFc0ONGThXSAVIgM0CJ9xBDe0iIHt119O3Q0rVNx4J1qpBUALuAiSJJUkKEIAYwN50mdR316YkUqlw4I+mkExrqXUkekr7jpqxLnXX8Ne3QkpVZk649KyNvaAgLCAwBUwfaNqzrEL3P8SBPwoxUJyqSSN42NrtjbusGgho9wUyQY0JH4nqIyoQpKcE+0IsgFQyal9wEncrHadJYEiR9SDOpPUJkNJISAJlRNPJ8c6e5lKq5hYGh2JoNzKJBk7hAA+p6eNwEOFYgwyT99reTbx7zjjUd0/R89HD5SkmtBkXWB+NtsY9zXnAJr6WEevXM/V2yG+6NeuxH86x6x3D4h/hr4LrfpHfDZ9WswnJrN4aD34xPnTxKznxsJmtrFoVH2soJLK4eEAkbWbtEQQSoknvPiE7rROkuHXs8BKgIUzwsNRaUYBq7fkBQIwWd43m5SAlYcSsaSSCNQJzbt9hE/mDdualiGYZqQ43DiEtJGxEed1ZKqgUj2gyQy1HQayGM6RNK5ujWOb9vapxF6HwWff7HvDcHjPu945yz4df8AdcvhvIn/AFD0k5FGDZxjlMFrrE3U4t1tdV7IYV22ae3qhu79ydkQMj8vWCz0cAgGmJqQ/wB64H6j3g3O5NmJ9FkN3yJ9XkwHgtqv3u/brifuk+x33O+yfI80nj+J5hieL1Pyb4T8hifJwXlnC+V04GXipfj3Wcbyt3AV05ARxatNrFQSBM3Qt5d6fv47+zAG5AEB/wB4GNDxGI55Lmo3Y2blmc46oOXDtRlhHyvi9n7Gufwftp9tK+I8g53n/CuB53zjyzmuPzhXk8p+q5fHxeJ8e4LF5PE47hvH+KwqlNK2V2ZT/ITbZG1Vw/qTr1+e7nGcx6MHr8VXfEk0d+FAu06T0+x1zand7yU4243DGMYkCjCpLEkk+FFSnnX7zfv2PILeB8f8k4XiaeMqpx+TfA8Z4Qu3LWqLraqLuSxs5kXBqsWpiJHyl5kKAN76V6XDf9KHVOqQJ+dIm1EPEfLjQSLVJmQSK/DpbFUep7PYbXdfp9rCXpHqJJPq4eHvdR0fuB+/POkrm/dPyjZZV7sfDyMLjarEtHxMrpg4mIkMTAEgsB6TrsXendMhCUf0cDE8XPvPnkqVuEAdWgOPYongYe5fdv33OWsd9CN5ZbGUmCtg7/X3GdeorkxGgHpAYAez7lfgA7up3x2KqMTG35FIT2f9Rd6oHMj42cPJgyY10IEZ165QaT296kHqop9g4SFa0JZvcGfcuwhSQpli/uIM7gZLDt69Zspu5JUtBgrE43jfbW5ht+hZd4BUqjJXWxO2tSZkgiOx+hpXrlCO3BJwDgrU4XjJ2e0tucEEoo3fT5I0aFnUx37enWLenq1AISe5WJ/Zv/4/dCT22Qd0R8m6Y3T8f49v8eqP5nZA9Wqv/9XkA2iNCIG0/WSoaAPSNsdp1J67AOtIBEVqIACsSdC0zoO4AJ/0mY9CZ16c4VSoKozQLowJJE6zLHQidAuo/wCw6bmiGKKRD7ZU94/KRMRpuO3sfx0nokaIUECCQNvuIgsYJ2hj/wCUAxpMSNOl4UToysRtj/k/lrO4aTC7hPb8PTpZIhRky+TKVw8HIU7TVlsgYaAF6W0Qgn1r/A9W9kQL8olmMT7CqHUQRatTGIn7x+C+8VzljKuPlLXlKIX4bgCXAEH4r7A6Mfolk+sN9L9zYW73qsy0XOH5T9yq2eo3LbRvR12/b+PipnhV8dfWacRGob8z49Juwrk3yWb4qHr3enuUlSesu/t7tmX8+3XIkO/iVs7e7tr8T8iTcQCYkeAK92cD+oBVeY57EVtwK18jZcg0iSuSLA0kxEiP5dRg24sfkwPgpTtjOg3N0U/aJ9hTY/gL3tv/AL3l2Wn2A3YlLP7gWECu2ssP8O3Vu31A24sIARHAqpLowuF/1MjI8QCfYQkLvCXwCjWc7jNYGDfAcSw5Bga70qut+OSP9ZA/49X9rvb+6lE2trOUHrJwI+Zx/hdZ+86dZ2gIub6Gv9liZeQdvFlJ60M1nuYEhyCJk99dYBn8OugwHNY9Ko+mtoncFEAGYMQdwJ3A7R9RGn8elWqXLNGqswBuYqAdDHqR7BKrG5tO+k/TohxxSwTnXUQJChjosn1UEFdezklDG7v/ACHRUZyoxzwdOaVRtMIi6hYAYKSiliTsQs5bU7e309DGTkURwYYJxQKjWHUaAkQBJBEsxDNLkLqJ7R0PBMMYuaI7HXZAYkEN7Z2gbgsiTJcxMagiOmkaI2HgnapG13EyV2wVkE7gzEbRDVwZ09T2GsxHKiRHApwopgdxDFSpknbG0jc30MdtI/4RSclkRJLOpDj0jfuZTALAgKJKmdW3qCW7naYOmmmvUMidJCONACVIqsTfpbVKQyOHQMr+0iCGX0IBI0+sEdVTPgfwUz0oUByHh1GfUL8C5sHKrZLKyh9gasq9V1dT73rK2kMP4dML7ardyOq2QxfgaEFWLc5QIIxGBzpgs0PC/IsHnMDjas3OwaubsxMT+54Nrrj3LnVJ8V6YSMFGTXZYhcNUGYKxnUdeA9e6Nvul7ncmO1ufoRM6JgExMCXBkQ7EChEm8l7p0fr3TupbfbtvIDfGA1QJ0yEs2BZ3OGnkrl43h1Vd1atVvsSwuULMVCQrneF2l1hY00gRAAXjb+61O8gQzdmxXRxAiHOKsTx/x9cjIx6raylQt+bI7BkrpPvqNJ3Dbkbgv4zM95zxdleuxtxOPu4uqnUN6Njs724EvUzR5yOHlieQWf37SMf/AP2/xojalfj3kTFRo9ezGStEBO5QgSwbvqQOrO5AMQBkfBeYXJGUZEl5k58cyt0/2/xHHG5uRH/1GYqKy+0bKKFXQkEg77vbIMGR6z1Js4+icq1PuWfelUA5Bajv31eYcNwf3v8AKcjLz8PJ5njPF/F+P4bhRYt2blZtXB15WN+ox6QxxsNcvODva4SsoGgyQOuLv9G6n9RfUV/abbb3BsBdjG7eZoQgwM2kWBmzgRi5chwwdehdF3236d0G1OVyP6iRnKMcySWFMhxJ8FrO4jEZm+bLayzKvvsz8vLtUsr5WSbb77XB37zkWszEkmAY69sufLswhZ28RGxCIhGIyjEARA7gAAucNyU5SuSLzJLnni6szicEKFJQBApDLPtr3JtUTZLvsrADL2Prrqci/dDmp7fjgp4mqnuFULGAVgprU/nUswRmM+0K0NCRJgFgOsqZPqcOFYhKgoprxeCbLanG5peH3BtzV+4llbdtJjUECD9Zjqncm0THNWI0B7laPG8cC29QTCqWlQBt0ckMyuweQO4AO3XXTrMncaJBNU2ommSsrh+Me741dw4LCCE7yAdrqukzAJkSYGk9Zd24XNU5kAKBXHwHDE7CUMsxVDJMgtposy066epjrPm/FRmZGatP+xn+379on8n/AO5t+PbHeZjXtG7SZ6j+WXdqKLUXZf/W498bKW4Cth8V4UqUsMq8QFNcabdf5d+u3vWJ2j6h6eKtWb8brDCfD7k6KCPzEToYKkzp6RMgjUnQ9QMrAxRiSomNpU7e417EnaBPpqR059qKIqjkWRqW90FZBKkSw1G4OY1H8unqyJLIIgFhDhYPcndrpMgCddCDPp0kSOqUaCB+budewI3fUxPfpKTSCyNbCoy6XxsmoXVWCGR5YAj3FlBIYOin0IIPY9+iEpQkJRLFPK3C5ExnF4qCcr45k8bORjCzLwQ25oG+7HWJ9wUk2VKG/OP/AIgOtTb7uM9MJ0msPdbGdl52/Va9o/DmvXGcsE+OvLmyvtXfWx+esx7RvEMyoCJI1HWvGYlHRdiJW/NZwJiRKBIl5Kx8HlbBWpsZcylwSlqOqWaj2lnhldSTPbcOqW46RbuerbXBA8DUeFQfB2Wttus3bY07iHzA1C7Hx/sdF28jl3KVVhj1sf8Ap40glZMzeQb2mPqF17dTWOkbSyRK7E3bozlgO6OHm55qHcdW3m4GiMvl2+EaecsT7BySdSDWPrqfpGoPfTt/n1qtgsuuSPUAT7IHcerxGkFgfdJOvefp0TcEOfNHVVwxJViQIkgONxGurbp7+hE/x16dn70SNrBWOwK7mA2turAJUExJMg9x/Hv3QAcMhxoU61oVA0Q7iphmOgCgAspBrUa6evfuTAYsUPcnCtDtCHUbrSsjt+RVG3Rfd7oOv4R0L1wSxTpWkhXCnU6ABZKkwYWPctg00Ijv6wIycE4b01R1FJ0LaKpiWA2wYZVWdCVInQz+PQyJ8UdE749PvRyinUwg1VkE7yQrPu1PcT/j7uoi7GqehTzjUndtKtLFnGxa1IGmjFiFJIGneO+h06glNkYjQp/xEVWWQk7bNrKCwDArZ7lKamFHafd6fWCZJBYo2OkOFIceoBEQbQqiNhhmJnRY2t72Ej26naPr1WkXlIvVSRarhSPEww5rZa0AVllVBmLKxBWZCM1kwdYInSJ6qTuM+Kl8clJ8XEqaysAKpextwKqyMd20GxWmtnDxEFtDrqY6qzmwL4MpYVZWj47y/knBov8AauRydqhicPPIz+OYuJ+KrDzBOOpVgC1Lr7RoQR1yfVOgdC6k53WyjG4fz2/5c+8mNJfxA4rpendf6t09oWN7I2gPhl64+Alh4Ms5/ttdyef4xg8ly+DhY2XyDOZxEuFduDSGFDNVl2WWUvewZ2AazdXtJM9vH9/0rZ9J6jurG03M7kA1Zs4OcXiwLcWFcqLotx1nc9Ws7c37cYCLloksSc2LtTAOs7/2g4qP91bRAV8fxPmrQFHfddxtc3ewFkEwGjVpGusZe4JOhi9W9hVOdIeK3VeH4r1cBx0qR8/z5CEEICtt1nxHTUk1ID/D6Dtd2wIswcYufasy5WZZc337u7bed/dV97s2sWWVVed5HHLYg1tHCYHH8SHZlYFmrGGFIJH5dpGh66jps4W+l7b1VIka/vSJ97rVstG3CvqZVlxONW212qCufkb4mNjd3liNupsTeSREtB0ET1DuLhdoypTt3YKcNQKb8XSxgNU6AhTsBDDaU3Iuz/SgRSVA3AEfwnNvEYkuVbApFlOuLwyCwKjawSXEPuZWD6qAJACHXTQ9xE9ULk/JTguIsVZPFYUPWWDI50VQGsdWOu5mmCCsCA0+2B2nrOuz+JTudPJW/wALx5sSmwAElULlEPtgz7ewWvaY7MQJB0gjGvTIlKKbVkMFbfB8LYGrJRQrOx7BGQbQCNh1+PT+Q7DuOqhkGY4oZSAV5eP+POGVAjkaFSvuO0HtuMgBiD9ZnoNBNSoTOjlWv/YB+gj4x22bZP5Pjj8kfTX80zr+PQfKlp+Gii11xX//1+O1QpIBQsQDtaO/qCpXUd+8/wCHr6rpBDSAkGVIEguCj6b7qm2ytyhQD6OACxUfIE1Mdpk/Q9U73T4SeVqTHhkrdrezjS4NQ9v4p5xr6LyiL7XYR8bDa4WRKhS0Nt76TqD1m3bF2yTriw45ea0rV+1dHpkNXDNOSL2MxCkaswggfiTBJaDHpPUQaisDmEWqTBVT7Rug7tE+u7U6AfQf4dIYom4pxrVdDO0sSACp92h2kQSQdCQTMes+rngyk4I2pZEaQACoJ3AkDTuROkD/AN3S70QAZOKIxKkH00jSRAB0japKiAOmKlALh1GuV8OGQGy+ICUZLAvZivCY+Rrq1ZJH6a1tT/8Apkj0Pe7tt8bZELzmHtH3rN3fSRdBubalzMZHu4H2dyiOHm5fG5L47I1TByL8K9WrZGESpViHRypkESCPqOugs3RIAwk8CucuQnCRjOJEhkVN8XlsDICgWGlgD/TvOwAwD+bWtzJ09x0nTSDcjOOVCo2UgqT8rLB3A+5YKn+Zbszf8dejGRZN3o9BG0rtEidxIMD6SCRGh0MT6enRiooyXiU4VoBtG1Y2hRqNpOphyVCrtIH4d/w6ZqomwRlSD8zAiG3sNwImWAhSdoLA7jJIPeOk/Apj7E7VgEALuDhd6MoncZUGCNW7j8IPeOhfNRhOdNZ2/F+R03DduUat+bUe06AmYGn+YPUURgAB061Vhdhjez/mO1jEtEtGgJGkGfX+AikakZJdwR9FJBiFCnaVCkMQdVYMWkERMR9egMm70QDkcU/Y1IJq02sq+5nYLE6e54BVAFIAM+p794pS+NEAMk9YtRB2jdKmdxQliHca6+2I+gP4mAOq0yWco4h8DVPmJQTYu8e1iS0N8hZFgsDs9FgkgR/GOoLkgAVKH041UioqRlUQpKo7qAssxDekwQWkCBO7Seqs5l6Jxg5CkeLusgDbZWG3KqljuWNjVhgzzXXA0EkEnbPVWdMaFFEYKVYeMjGuxFCsayRuRYW1AxgIUG73jQn1BIiR1SuTNQTn7FbjlRZLft8+3Xj/ANzfO08Z5vmG474OLt51uJxh8fJc3x1GVh42UuFfYERFxrc2sXWMGtVbAVWdzLxX1b1vc9E2ENxttvrlOekSNYwLEhxm7FhhSuQOvsdoNxKRnNoRxGa2sfcPwLjeK8L4rI4Dj8XjcXxqyvGGJiqKR/bc5K8dntaSbjjZNNZLvrBJI68N2m9u391eO4uGU7jkk1qHPg63wAIxEaAKd/s7x9n3H5hl3V/D4RyRKggMAeW4ZAGLWONRBInUD10i9dOpi9BVNd+GvFbteCw/hxeKx1AZfgw02sgX3lKt7MFYAzukqRETAJ7akWt2hyj7g6y5VmTzXLl9z84c192PufzLkWvy33I8z5Gtj/8AmnK8l5F69xIUhX3BRo07h+B629uSNptYk4Wog+Qfv4rWtj0tky/cdj7hW7bgSskPWS5qUqNirUTLbxPfWfSCDTuyAcCqntkYHipvxWItjlEUAjcLCBvmAWBcg+9wGB2DQesyIoXp6Y6jmrceZqrN4jinaAla67XcMACKz8YPeApLTHZtPX1zLlzAnBTCWZVtcDwhAqUwWJKksSV2SP6iqyqSZbsQRoe4IHWZfuu4GCfU5pgro8f8daz4lRCDuRpADaiFBAA7NtjU/wAfp1nyJBqaptbd6vjxnxSxmqOwAGPkUBZhJEsGU+5e0yRPeeoxF6jFBK47rIfxvxBiK5paCe5Q75IgnaSrAz/KD3g9W7VsyxFSqk7pxCs//wBJW/ovk+J/j3RPwP8AHu77d8940/7T1N+mlp1aDp4tR+9V/nV0v6l//9DjzWQBOq7dSdNQdZBOv+Y0/Hr1mNMCqCWr0MiVJ13EEtOsgH8uoI1In6dFHuqki1SSFIBj3D2H88+pkQV3GD3npFjECTGJyI+9JyC4NUfTk5NJifmrAH9OxiLApEQtoEmB/wA0xHVO9021cBlZ9Mmwy/BXbO/uW2jcGqPt8/vT7RlU5BVAwS4Mn9K4hWhBWBtWNlgk+hJ/w6ybu2v2P9W36eOXn961rO5s320TrwOP4+1PNM/h7pZoI7kyAuhIDHt37R/GGjPkrgFQnCsbm1CifTQA6sT66Lu+kafh0LsiiapyqpEEMQO47mWIGpXUga+sgHpnYAZqWI806U0qVAAmVhgSW3Iwkyok7okR39eojI+KtQiDQcEhyvjGHz9Oy9Xoz61AxstUUXVLIAR2BAto3z7TJInUGT0djeXdsdVsvDMds1Du+n2N7BphrowkMR38Ry8lWmX4h5Pxqu78bZn4q7j+p40jMPx6xY+Mn/zNckagqe3eOugsdX2twgTnplzp7cFy246PvrDn5RnDjGvsx9iasHkb8d4x8q2lxu+WoypUsx3B6bBMQIIInrWt3YzGqExpWYYEOCGIUvwfJb0CLl0Lcohd1JC2x2LFCXQtt+kA9uphMjEUTENV6qZ8fy/G5OyurJCOQpNOQDj+8MV9ruwRyAQSZ7/w6MTBzQ1fBSimqYK+/wDK0qDsAl9UadmsdhGmhIkgonBJnTpVVoQNqkA2Bmkk/mJE7YWdYJ0kx36Fz9iH0hOtNJgMTO1mLe1QWEy5ZoAZp/CACPXvETikCCDwdOdNUh9wiAgZjuO8oSzbpgMVggCN0jX0PUZDSfMoiWGFU710I7BTKyRubQtCgSw0KjXuJC/Xt1EZFnzRAsyfMXGI2MNzNCAAQCtjA7mkAksAAPWN0doiGc/iJ7BI1dPWPjkkOBKlJO5oB1RSpT8u2Y/Ej+ECvKYFFKAGwqn/ABagu2wgs8hhG1RqDW+i1LBMmGHYDXQa1pyJJGSQd8VIsXHqYsxADRLJLEbz6HYsSUMflKgET26qyJYNkpQWLFSLEx7LA9Uq4CNNpSLlL27VGo3tIEHQrrqAT1VuSiNJwUkdJpzU0wcQNYntsJR2JZLFQ7yu7awshFBYDQElhII6zrtz0moKsgsCpzwY5v7feUeGffHhDkZXLeCeQUpkcTj3bMXn/FuUbLxPJ+FsUCBl8rx1TV48wK70rYQTpzHVJ7bqdvddAvsLN61SRxjcDGEhyiWJ4gldB04aLZuEeklb9v7n47z/ANvr+bXIOV4xznjg5PFyhWH+fjeS4+vLxAanDfHkFLkgH3raNpiIHz1K3uLG+/Tyjp3Nu5pI4EFj4c+C1STqCG/ZPiPkfcLnqY/q/wDpjFxwVC7rTk83gFtxOqBDu29wR27z1vn1XIRfEn7ENwtDUVulycmvAw+QzmC7ON47MzbJBEpx+PblNNukBRSSRP10BM9au4YWrtPylZcayi+LrlDw1bPzeQ5KwM12blZGVZWxaxrbs297XKKQxNrG31C+0KT9eti5IQhC2DQD2Dj24rXdtNVYXEYIvas7YbZCbCAiorA7lUKfmMH3FgG/kQesq/d0uAe32Ke2NLFWpwPBtcrFK94BWlpmVj3GoBexO4QNSp17STlX71a0CsAgZl1d/jnjFl52ioqdwJP9RSwZVB2OZjQ6KTpPpp1lXr3OiMywqsgPFfBbrdk02BZE7l1cAL2bQFWZokmR/COqEpklI3OCyZ8V+3NjfETQw3KBoPdO4DaFbU7jo3bX06EDUSBioJXQH4rKfw77McxelNr4hwcVtpORnqaFVCUkJQT+ptUj/wAmyPXt1u7Lom+3LSNrRaOcqeQxPks6/wBQtQJBk8uAqsh+F+33B8MlfzKeQyRtLPaoSisEmGWlJaxTs/1nUjtE9dTtOg7TbgSu/wAyY40iPDPxWVd3t66+k6R7fP7lMfiq2/D8NH6fb8fx/HX8Px7O22Pj+P07dutfRb06NEflYM1PLBVXL6tR1O+buv/R416cu+nRTICiQx3f5zuX8Pr16VGc4YSVN+KdKM+sx8oIMkM2jKfdIAJhgerELxA9UfFMwOCd6b6XACOCSFmGg/QiIO3/AA16sxu25UB80JEhlROSBYWGILEga6zOpJkLPYSDr/HqwMjxCZE/CrBQVG2REDdu1Gu6D7jPtJAE9OSC8WockgTQ5pzxsnIxyPjY31Btvx3SWIOo23ausR67gPSOs6/021drZOifmPEZeCv2Oo3rTCZ1w54+f3qRYmdj5BVSwpt7fFcdrHQj+m8RZDCNDOuo9esXcbTcbb/VtnTxFR55eK29vvLG4bRcafA4/j4KSUIwdT2kGQBDBZABgiPUx6dUpF2WlEVqnymk/GdsLuCtujtAJBBJLHbGpImdB1XMwC2aswBqQnnDqGhIIC7YLkTYoIYDd7/am1hA7T1XuTyViEHAopRhYpALfHvB/qbmYhZdTOvsUxu/jB9QOqF29j6mViEHIOmnFOGV4RwXkVQTleGxMpiRX+qasplICsxRl1rVkKd7+rwW07CRUj1bc7OT2NxKLZPTxBopZ9L2u8i2528Zc2r4Gh9qh3Jft8ruBfxrmcvEtZQRx3MVpmYsh1Gz9dSaMmn88e5LIJH8tbbfXV2z6N9YE4D80KHyLg+YWPu/ou1PVLZbown+zOo/xCo8iq25n7X+f+Oo1/JeN5WXiLJbP4YHlMYKzDa1tWMDl0KwAE2VLqNSeut6f9W9C37QhvoQvH8szoPg9D4FcxvfpzrGxEp3NnKVofmh6h7KjxAUewOWy8SUxMu2oVmGpZmZC4kEWUPPxsBpqARJ7ddGDq0mJoe3isIhiRmr640tdgYWRayNbdTW7AD2ElZlFVtpVWnse0fTQSWJDqGQ9RT0iAsHktYQzhQsmvbW8WJLbDKe099sjv2IuNJHBPEck749LDaQiqAdpG3b8c1kMQbG/LOg0AJ16ilieKdx4Jzooggk7oG4gOAJqR10LiX1iO407ajqN/JIDAp8xay1SA7RW7RMtO4kCRu9pRQd0GBp2BE9Vrki5bFSBs8U/wCJQRtddykKjh92wCDXFiFlLHU6CFkiZkQaszyqUTswT3VQ2yta/wA4UuTqVgkA/Ht26uzQexbqCUw/q4qQGrlSjBqHtYe0bSH+RV2FRJKtBOzbpBMie5gdUrkqs6MVxUk43FLOFbeAzE7bACp3hWmCrlwUBmCdwH8+qd64wBHsU0WDtipvhUv8QJ3WarX7KiENl067qw257Laz7IYwIA79Z05VOX4KzAARLmqv3I4mnF+3wxsnGtD57cVhYIQDdbf81VrIjqzs81VMCQN21we564L58r/Wrl2FwaYmRPdhh5eS6faR02rUJYsCVmp4XznK+PfajC+1+TknIrxsujKxclvy4uGd2byHBVfIBa2LXzjNZSQGlXKj2gDrgupRtbrqlzqUbbEuG45CXeYsCrZILcVnT+wjGXK+5Pkqq27Z49xdoJBiE5hrgrkRqDSDEgHt3g9R2I6r9s8/x+xR7iX8pbQPu7yH9l+1X3Q5RSKX4/7eea5VRIX3WVePcjVSF0hT8z7YkGTGhPWjuP8ASIdiTEZZyAVC18ceDrmv8f8AHXDY6rTZuVFQutcrIpIcGA4DwxcakgmDqBEm43DhgQ3t+xaccOSunx7xks2PNR3hJ2lCpVGG0FiSdrtvg+o2+sHrHv3vjqpoOcFkB4t4W1vxq1ft3e0lSpDFiSLW1khoBBgFewHbrIv3zJxFSiYAosuPBftXbkV03/phVSdp+bKX4KioIAixiFs3EzC7jpoesm7u7NstO8NXB/uwTgTl6mJWxLwX9seDg4mLm87yePYl1aZAx+HX9QLKLotrsGfkItIFgIYBayGnvAkdnsvpSd2Nq/u92PlyAIFurghx6jTDgCsa/wBWYmFm36gW9XLksi+G8M8Z8crROM4nGSxYnLtBycyxYiRkXsSA49FXsdB11O16XsdkwsbeIkPzH1S8z9jLNu7q/erO4W4YBP1gcztIB0MurEK1Y2n/AJtJJOgj/wCLq4XZ1CEOygsxJ2qoME+190BSI2gKpPf8QBoOmSFBzXja0R/p3bN2153bvyTO7v6/XTp6Y5Jcl//S41F7jTQAd4/iQNR3069MA8FSqvapJmCfymO+o17n6gz6R6dOIuU3vXpQVIK6H8NCIk9/Tp9JcDNOCnOjOyKhG/eI13k/waNpDqDH16mgZxwkQEn4h064/LAkfIrJqATG5I7EtHYLpr36mF6WcQQ2OCTAqQU5geCgDK2s1y3t+q7tO0SPw6nFwCpDJG2cRVHJk0sQHmCI2sD39J9dCe/YHqX5kZAsaIDGQOFQn3D5azH2oLFuQAAV3/I22IgqwdLQqj0mB1m7jpmz3BeL25fusx8CCPILR2/VN5t46aTjkJOW8QQU/VeRZBXauPhMCx1ZcqdyydQMgLMn0B7dVT9PbWQH/dXW/g/yq2PqDdDDb2v+L/Mn3H8l5A7SMTAIBME15bMPcGGn6uSBJMT+J6jP0vtZO+7v/wDB/kRf/Zd4P/17PlL/ADJ+x/NeToDIvH8WqkmW+LkdzMqFTqc0FWAJgx9Tpr1Xn9GbG4XO+3P/AOP/ACKWP1Xvou21seU/86f8T7i83ROzjuFLdtz4vIblIWQ6gcipLKshW/MA0aela59A9MuH1dQ3Td9v/wBtTD616lFm2u38p/51Iqfurz1YqT+1+PtWrKwVsfk/eyuCQWXk59y9479yJ6qz/pv0gmR/3HePyNr/ANtTQ+uepjDabdhyn/nUl477y+UUKCvC+NsRIZjh8urLG1VCkctSQCYBGh/GZmhf/pb0S6a9U3rd9rv/AOkVPH6/6vA+nabYHun/AJ01c95PieZqR5H9vfAc7LdXP9xxMHmOP5NoDAunI4XOVZAKgyF3OogaEadaPTfokdFI/wBv+qOqQt/sGVmcP8ErJj7jjVZm++p59SjL9Z0fZSn+0IzjL/FGYPm6juHjV011Y+PUaqkqArrNljqqFj8dKva5NnadzMxO0nWAeu1jIiIFyeqQzoCebBgPAMOAXMSGokxDRfDh51T5TR7f+oBE72P9II4jaGVGRVDfIQde3ZYM9BKYwaqEDJ0fRj9grfUrtcbZl9oIBXeyqIECPTqGU2NU4i1ck704pcRKsdSWBKyoUkM2gmGr2+2B6fj1DO5WgRaRg9FIMTHZSwVhMFT7FWAGDBxtEOrMR9dRqNda85uEYiKcE+UV2BNo1VQAdsgOSCCTEADduMjUj17dV5SDp2AOl1IcGtoAhiVMbdntt9oVjuAVdNJmdYPr1UukkOnGIUnxsY2SS7FlRiU+IbmWF2ptLSVEkEnaBA/AdU5zIIYU71LAsRR1LMHjAgI/TkiPzLIHsCqWkDSC59xAJkAfTqhcvEt669uzKyIxcaTgp3wmDdk2YWN8bBrciqk6Bf6JZU7ht0FJO5jqSToOsnd3owjdua/SIkqa3EynGIzICyU8cw257zzjuOmxuK8HwP7xlqK0+N+ZybFGBiXDcUNhssrMgH21NtgByeAvyG16XfvFvn7mWkf3fzEcsfPuXVx9IBHcFkfjEsC1ffeSiKGNgsUhWSJn5C6g7tWPpA78nco2odu2SliTpDrZB/t34xu8t+4uWxrdMbgOGkEK1itkZuYpLgzB2ykrvkCRB0L7SL7nAuIH3hQbuluNcSs8f3Hs6fYX7pVVJYbuS8as4ytED2O1nL8nx/HsBtUO4dMlh9NsegJ6n6jet2NuLt2cYQEw5JYCvEqDbxlO7GMIky4D7lpy4nwqnDar9ddx/HBYA/V5dTPBVdyfpqXvvd5IJMCZ7aT1ye5+o+nwf5VyV2X7kSf+ItH2resdM3lyptGI/ep7MVbPCUeK4cb8nK5KytwyJRVXiY+/3IXW29ci1ym7uEj6T1zm7+o95cH/AG+0jAcZHUfIMPatO30VmN674Rp7T9yu/wAa57DwwpwMLFw40W7Z+pyEKqNjG2/5GDOP+WADB9J65/cbzf7it7dyI4D0juYN7SVbhsdvabTarzqr08f8lvdlORlWWuG37mckKo0YyGJiJH8j/HqOxPTQCiVyyGLCjLYD9g/uTRzHHV+H8lkbuQw6jdwtx1ORhH3XYCro5txDJqXuaiQJ2a+x/RPXo7izHpG5n/NgCbZOcc498cRxHcuK63082p/q4R9B+LkePjnz71kc1YLKfaAoCFIBIYyCT2UAkR37DvPXoDLAdCsjTJE9hYBBZuxG7RRG2e49ewnpsyEQKSNY17kISRIaGbWG2qTLf+U7jH116HwTheI98bl/Js27ln67duye3unt/LXpZ4UScthVf//T41gJ10gHvP1nsToCevTdJxdUUdjtQtOWtuIci26itMW39Q9C4V36ih2yjWiFcoNjo9QrYhR8m/ug6kYnSxYZ88acqsUvBIBYmDOsADU/hp2Ov/s6IR5FJLhTEdtNNfSToNDPaR0bFJKAGYky0j/ERtOk6R3B6IAkN29iSLx7LKGBQlS35l9GUnsyiVgx2/79eiqM04kRgrB4LyLjFqrwuSw0rULu/VKhtrckklr1IaxXH4SogaDqaBiR6ooxcyKyE+1n2Vq++vnvh/284XPt4o+Vcj8F/PcYz5FfF8fRS+XyXJW0K4qy1xOPrd/iOzc+1JUt1n9Y3lrpvTN3vrgcW4uACznCI8Sw81LajK5OMI5ql/JftX534Z9yvIPttx2PyHLcpw/m2T4XR+qxhxluTnjmG4jjruTxcnKvq4avkW2WF7LnoqR9zWlRu6q2NwRs7G/heazO0JvE6gxDnKrYYV70coAyMJCrtX71mh9+v2q2fZXxGn7peL+fcR90/s2nK+M+BX/cXgWVcXJ+6t/jVuZ5dweBxV64ufd4rx/kvFclj8fyyCyjOxaarQd1gBz+jfVst/1A9I3OzNrqghK6YEEEWdQEZE+oayJRJg4IJPCj3tjbha+bG4dLtxr7KU5rFrA5TicjaP12OheCVtZq9QuhG5VAidIHY/wPXZ/PgcXB7lnm1PKvipRjVY1oHw5FFi/nVq7lMljtUQGLAF4JBnt03z7f/UD9/wB6H5c3cwPbuTlTx8qbSjBSyFdoBhS0K5UGAhkD1n8REtrBZiEjGQyZO9GD8bb33VsSpBO+drNuFi/GSSQNT6+muvQSk9BghFWKdsbj2ZlChmJHtYKQpFgIAJB0V1aJOhM6jqGU6FSMnujjRsax/Y27duVQXMAKZJZWYsrs0wPcNBIPQGeQw7dvFAeSesfiGOkFGgbyQPzneG2ofj2+4ACSCSsekdQzugM+CCpTjVwzyohg+35CHDKxsFhVidNVcgxtgmddR1DK+Kuyk086qQYvEMTW1ZLsVAa0VhiyDQL6No1kxI/HqtK8Ku2KTHipDRwhtdJqUEuzyikJAVQ27ZKlGVo+g1nvHVWV/SCRKvbt/YjYmOKkmNwFrGoohG5J3AKygbFILEqSHhvcD6/Tsas9zEO+CeMSSpTxXjVrhAdrsHO/YfepaAzooCuCzjUGIHdgJPVC/uxEkgMO3b7FKIEGuKnvGeJ23Ef0WA0WMdHL2gInx31vUHsZZBDAkE9u56ytxv4QxmB/eIpjSqnt2iaRiT4P7lZOB4blVgDIxhSpZWT9Q9GMq2KpMlLitLawTAC+pEd8G/1nZh/+7gTyLn2OVftbHe3CNG0uE/3T7ypfgcbxHDU5PIX8nxm7jMJs/wDS4vKYmTmOKNyqipi/JDLoSGgAMB3iMfcdTG8ba7eNyRuS0uYSEa4l5ALQsdL3lqUL1+zotg5kO+VHJVxfZ/gnwfDU57kUazmPOORfyTJZ962HjxZk4vC1QAEQ3H9Rcg/Ka3QwIBGB1/cCW9jtLX+ht4CA/vUMv+Ud7rTlL1Ri2AVt11moAhwVCgnWLQxRT6ttg2BZMwB6/l6wZESBYfcpI4Yqzvs/+8p/2uee8hiL4fheY8Fz+DxlXmlCZz8dz3H/AKa27IwE4LMYW4LZdWPlsbaMmora1iKr1FWPWx0vp1y5YnudTGRaIOBAx8zQHkpztP1Nqs9MhhmOFVsM+8n7rftB97f21+QZ/wBsfMRdzOZzfh2HzHh/JIOL8y4Su/lP1tyclw1zubsWs4WmVjNkYzECH12jC+qLUo7S3YvRYym4zB0hy3ECncrHRNpetdSiZw9AjKowwbHsVr64rJ3Oim1iHZNrM52wSQqswT2M8kET7j6g6jz27bABaPbt2ZdqGFVZnEZPxMoH9PYw/MgDNLf0RWYMLJ/mRMzPWbdhXiCn71afB8iEtUB127VgDYy6GYZYaTvIM/8AN6n0oyiWLiqCUaK4+D5pFYAFnKhZYgwUAIFZUb2cz/kAJnvWIIwNFAQxbJXp4n5Vkcdk4uXjZN2Jk4t1d+LdTYRbRk0sGDVtp71Yesj0IK6dXdru52Llq7amY3YEEEYgjAhVL9iNyBjKLwOLrZZ9rvufgfcHj0x8lqsXybFonPw12V/rq6lAfksAbtvxH/8AMRQxqc/8sHr3X6c+pLXXLAt3TGPUYR9Uf2hnOPLiMYnkxXn/AFLptzYTMognbk0OLcj9hzCs+5QwCrYqltoOjQpCgt8eoj2t6SZY9uunNVnDiUg6lQFmF1Xv7tys0ruBZoUTqe/8e49yQOC8fH7tk+349+6fw2bZ2zt9N0/hM6dM4d07581//9TjaAk9517me4A0I/n16kAKuKKilI7ToRBI9NO/YiIiNO56PSTRqpJdQFgwfpoB2Xswb2gyfp0QFaM6SXCsfSdR3MzrMgyJMH/DogGNMEktXUpZAzbQXAcoAxAJ2s22VDGNR7huiJ9enALnimSyV7W7gg7tp7zpoRBYrqZ17dGxwaqSMRTtAaJAkSe0k+6Rt1ke7U/4dNEEukpJ455P5N4nkZGZ4r5DzXjWXl4eRx+Tl8FymbxOXfg5Y25WJZk4VtFv6fKrAFi7gGAgyOnuWbV6IhdsxnAEFpAEOMCxzGSKM5RrGRBVvfbK/O5NObzuQycnkMmzLo+bLzr78vJyXNb2u+VmZL2XWtLQSzE7T39OoNyBCEIRAEQKAUHcys2vUanBbyPMPtqef/2LPuF5T8S/P4999fGPJ6DbXuur47h/PsXxi80NP9NLrvLrd5IJ2of9IJHk+yvC1/VSzJnN2xK33PaM/wDlWjeH/wDPLZMfa32rnYSrVfQ6aerQCGIB1lYj/tI9nESzssUE4I+tyGEMwHofVVkSo7EEfwOnQmJrqiE2ohk60Z/IU6052TWYAArssSNogEDQAD8Z19Y6jNu2aGA8kYuTLhynmjybyCuFHKZ23auhs+RWWsMApNoO5TprA0JA06E2LZrpauRIRCRwPuUkxfO/JqSEPIFylYQfJiY1hYKB+cmsbhu9TLN/DTqGe1i8mnL/ABFSiUWINuJ8An3F+5PlNJIL4dqB1Db8DHUsq1lQPkREPtZjpIkaagA9ANrEkk3ZuOadrZobMfd9qki/dHyAVJb8XEPuUh0HH2VqPeamrsUsFt+WpVYne7e4eo9sZ2NSP1Fxnxcd/DLtRFos/wDQj7fvR/8A/VfyViAcfifcTYf/AJLQk1jcT/V7vpLRPbUzPUB6eB/+xcw4j7kemzU/JD98vvT1g/d7ymvWvG4p2Zh7WwNw9NmxWudUG14jtEdo6r3OnRPpO5ugciH9gRxt7fE7eJ8ZfepFi/d7zBm2onELNTr7OJq3lXY6lbt8v6EkEkHXQa15dJskerc3sX+L8OxVi3Db0/7WHt+9PVP3W83t0fMwkD7NxXi+PMfGPbtmkH2kNoYndrpr1Vl0jaZyukj9+Qx7ir0IWAARtbb9wPvT/g/c/wA2vO5vIbaDVU59ipRuJsTclJxsZFD2CzWdu4E6gx1n3ujdPDarBk5zlI+byVq3KILxtwB/uj7k9Y/mvlub7sjyPmryzRYByGWNjJo5Va22sXU7YBie+gI6pz6T022abK0C2cQfeFp271xg0qclM/H15/nMqvFxMfmuczbxV8GHg1Z3KZl1h3IK6sXGrvvstmSNqSzN27dUtza21iJkBbhHjQDt4q7G4Zn1HzWTHF/ZD7rcDy/h/i/mnhPk/gWV90sjGx/HqvKuOy+Izs7gas6l+W5enjM9a83+3YliITZbXSGNDFCwV+sG9vtpG3ud7C7G5a28DIkVDs0Q/E4UfFVt3etyhGMJgkSq1Vnm64fztTxyvj8dhV43GcVVUApp4rjaUweMWLNlZC4lFZI0BeZgT15tOU5PO8QbkiZF85SqfaT9iy4yebtiguc5qjxjheR8gyaga+PQCjFc7Bn8rk/LVgYQA/qOl1oayzuRRS5B01fa7aW83FrbRkfVieERifsHMhW7QcsSsMsjNu5PLyuQyr3yc7Nvuys20gG23LyG+Rya5VVLEkmV0Err267+FsWbcLUIAW4gAcgFp2ZMWWT/ANt+I/tfB4+RkIBm8t8Gfe5VfkrxWUHBqNoYH24zbypICl4kR15d9Qbr9b1C6LZexaeEeDj4z4yDPwiF0Wxt/LtGZ+KXuV48dmQoIPyF2VSGJ1qOhXcjFARuAAn6aydOTu2qktRX8K5Kw+Oyj/Tas61hgpLDawJClUJCja9f5tQJjUAdZt238QOacYsrNwOTyHWqq+w2rjKaqFNhC00OzWkVrKqEd7izCAslp+vWZODJADI4qx+E5JaXRmaTt07l9kHeoMwO+kmD9B26qTjjwUUovkrY4jmYCA2lVYEvIUn3Ad9p1OhMf6gNYgjquQYuQA6iMS5cBXL4v5bm8fk4/I4WTkYedRct9VuNZVVYt9RSHUoVVC6ASCNpUwRrBu7bd3ttet3rV0xuwIIIox5dqqre28LkZW5wEoEMQa0WfX24+/3E+R1Y3F+WvRxPNECuvk1+OvjM9vyq140Xjchnj6VWEmNkwfX/AKf+uNvvY29r1WUbW7wE8IS7/wBk/wDCeIXF9Q6Hd25lc2gM7OY/MPvHtHNZCNYHWuytg1NqqyWVqrh0ADKanTSxX3AiCQy+pHXd4kSBccRwWAzOCKjJCbTu+X4hv/5txnb+eO3/AFJ1/j6xr0q8MkXJyv/V43Qqgaf/AIpiB+P1k6jsOvVWZ1RRC+gEHtMaBhBEaGfX+H/eYfwTJww2x6czGuzMb9diV3VWZOF+osxf1tKODbi/qaQ9uML0Gz5ElkmR26eUZSjICTSObOx7sEwPJeQoY6QFljG4wNZA9f8A3dOxFCUsKpdQR3K66PGhAOuvthe/8upYh0sKogJrIGm3v6nUx27fj26IgsQyYItEE6SPr9B3k95/DXpCLGqLkllWfQjT0gRI0gwCO3UmLd6cVyWQv2jp28Zk2uDtfkH3MIWa6qKZWRqQDOv06zuoEgMGdlasMXC6MPtX5NieX/7Tn3u/beeCufmOU/bn+4f748fzpvqGAMb7e/c/hN3EU4gra9+Qpbj/ANS1m5VUbFhjJ68T3RnY+vel78H+XHfWLZGb3IMD3VqtXTr2d+P7p9lVy1qgIMEbCu5hBGpiCdGKkyPrP16+ggMQWXP8ESEiV90gAa6MYAkmB7VIOs6z07UwTkNmi1qMAqdoEszDZH5p2oqyrHsO5jv+PUco1JTxGOCda6MOzDsL33jPS7FGNjLh1nDuw3TKOZffnPkLdi341tdK1Vim1bRa7F0+MB4yLmuNB8ti5eoNGADMxq5cEMKF6GAD3pWjSDBLCBtAVSQJMiG/0sR66CBB6UovV1LEZI+qkgwGIIUroFJYtBK79Sdu0ye86Adh0ABBzRgcU84+OQnu+NtxPtFYLdmXVdAJZT6mR27z05HejYUYp1FMTDjaxDAQpYBSEDl4JNvfWTA7d+opRGNUZbEKSX1ca19L8R+r/Srh4Ndv9zGI2T/cFxMf+6NScSKVwW5H5f0wJFv6fZv9+7qtEXNJ+dp16j8Ltpc6Xer6W1ZanajI4MzAFG44+NwQPZAWNWNZO4KSUMDcVgsREfWOo5AYZqxBnyZWP4h4vk+VZPKYmFy3jfE/2nxnnvKr7fJuf4/x3Fy8Xx7j7OQyuK4jI5CxE5HyXk6k+LjuPrnIz8kiusF56zd7fjto25ytzlquRgNMTIgyLAlsIjGUjSIqVctAEaV4wa95G2wgELCGhlUkupYONCNw1MztE/U9RXW0u1Qp4CrYqW8cwhQIgwyKQQNkSNQWCrL6Abu30AAzr0SXr/ar9g6XaiyW+w33w+6H2F+5nj33A+0/NtwnkvE/082nIVMzh+e4rKeo5fj3kPGsyDkOGzVxw1q+22tttlTJYqsuJvunbLfba7b3tsSg/pOBiR+aJyNW4GoTbmWuUbRwAr24rpF+4H348D++v2F8f++fNfZPhuP854n7XeV8rx/N87mZGdn+M2cpxHJ4XMYvAZnHvx1mbw/IWK12KuYbCm5XNfyyx8a324nZ6pPoNg6oG/CEpPQsQRQZh83AL5KpGBtxmddGwWvrBV8lcS3HSy18kV01V1EvZZ8ipsSuBta1g3tAUEEwOopkR1RkQG4oYVMeLrHz7yeV/wB08hHjGBk1XcP4xZdjZNlbQvIeSMEq5bPqdGQW1cb8S4mOezCl3Glpjqeh7Ibfa/qbkSL92o5Q/LE9/wAR7wMlpWqCmKiXhfj2d5JzS4tGDmcjicdi3c3zS4WHkZT43E8a9TZmVkJQlj04hvtqqewtsTcST6GTrO7/AEexuTtlr8/RD+9IY/wjVLwAWjtYid2MCWjz7eCyc47LNgncu1dwld52oStkbR/TVdsxBJ2qB2HXmt2yIsIju7Z8/NdTFshRlYmFbUK8Zlya7bnsse6s1sn6fZYFqJvd/ivFisLAVACHSAesm7AvKhZlICeFGU84zMACiCQ6ORtWVUiYDlpITaQJnQHWNOsu7aLniEWbqc8flswhgVJeQbF1SCS+1dSWJA7wQBOgmM+5CIcsCjfCtFN+J5AAp7wBCsCNwcstigEooJXeCCOxI7dUr1qjgMU5VkcbyZWNrALGrmZJCrDIykDcCQDHqCfr1UkOKikB4qxuJ5ph3sEkKZUKwIUKYI9oMKfT0+vVcxZRyGCtHiOUv/SNnfCxxFyacOzJ2KtQyLUa6mhmBLbmpRmAPcKepImYiZgegSZ+fDyUExEyEX/mEO3Lir58H+9Pk3ii1Y2Dn/quMUop4vP+TMw1liW+KX+XCnd/+W6/wOvXTdI+qeqdKaFi/qsD8kqx8A4Mf4SFk73pG23byuQa7+0KH8fFZC//APR+B/a93/ph/wC5bp+H9ZV/a42/9f5Pi/V7d/8Ap2bp/wBcddp//oln9O/+2n9Vw1jR3u2rw9qwv/rsvm//ACR8vix1eTt2wX//1uOVPdH1MxPrIiCRpqT/AB69ZHILPPFKqAPcB9O8EAlSQCNSD/PogGqyWNCiEX0IH5iB6kNIEHQEAwB+P49GzPwSywRIrOkwp0U6GdBELPrqNe/b8OiEUz5BEIgMT/qERG4kATPb+J6lEeKZLIgDLpIjRlH5oH1Gqzpr36fSCiARoSRJ0mNRBGigmYaQPXt0WkU4J0VWntJ9SFPoTqAIBg6gfzJ6JgE44rIz7X0fFwGJZt3NbmZWQ3qpUWNUA2mwEbDp6gd+snqBJkQ+StWasCKrot/YNxreWeNfa7wW+mq3H+5X7bv33fbKql3srbKsy8vjeYx03yvyVtmZgJliAO4OpPg31VIbfqu53OovY3O0u04tMe6K27A1WtPEELlloxrMdKsdtbqU/T2yXEPTNTQB7hDr/wCA6+kSQfUMCHXMnFk602Y9fHX4bcbhPk35mFlJytrZpy8KjEpy67sHGrry1wTjchblI9vy0vcr46Ct6x8i2DokbkJ/MIiIkaaMSWYks7hmDECpcGjE9CF9WqSqh1O7X/UGEkwT6bvpoQD9OnZxUUT0RiV7hZvDbgiimLdtSt8qmxrVIYupqkASCCBJ0I6Agiow7faiFU44tIkd0LBWIDhT8gBAtgsSikCY0Ovrp01TiFMAnquk1j3I1akEsGhmBRpdSTvtrkhgNBB6jOPFGO9H01wpBAVi07jShAUV7pVYZSZmIH+nsZnoS7kspAzAJ6SirZTtDK4FyWNLEXWF2dXFTVKoKVELtLEkqTI7AKlz296Q96MpCIvtHtCkkEEQ7IRvJHu9rzp6R1DKNaqSNGCd8asCC6PtJBggbQwUhiTKsdZ/GO3YdQzdmBqrEaYqTY1YVawCrOhgLGwewe2CRoyagwNfr36pyBqDgrMSGpin/CpCKFEuZK7gWRifbuY6s/uUa6+6e8AE07gcngFcga0U3wcf9RtStlR3jvSGUAhFD+2ss0SBsAmAO4PWbcGh5F27+3mrcCQCVcXi3AubK2xUsuysyyqjFqWZm50THq9xZX3FlESZMwZjrH3F4RB+YQLcQXPm6qmRMpknFdFvhub9kczmfHP2e/cNvOePzfLvtZgcFw3IeHNweNx5tbgM+q/By87kDkZfHclkLxNllB/S5FNljKj+5tfENjs7m5O6+pZyeMNyZNz1AgniAZAFmPglMltEcCM1iP8AfLh8j9uS+VcJVkZmTyeNyNviHgWZllaszNqs46m1/KnSsrig8RwWZSwZFFa8hfWAAFbrQ2G2/wB134jcA+RE67nBnLR/iOP7oKK1GtclgXwHE8n5HynGcBwWDyHL85zeZi8VxXFcTjZGZyXK8hlslePh4WLSjZWRk3WWe0bdx1J7adzckIRlOZAgK1yCtRLOXw4rev8Atq+1FX7L/EfMPI/KeT4y77z+VeN10eYPjGjN4f7Q+IYqvyWZ48MpRdj815VnlUfPFYOPSaq6UNmu/wA1+pfqATfZ7O3qvH0jMgyo3944D9nE1wURLdTtwiDoenM/ctePK87hc55HzvOYHHjiOP5bmeQ5HC4ysGMJM7KsuqoSH+Ouxa7NxQSFP5faNMy3tbu32tixdua7kIASkcyBU869nXcWiYwhEl5RFfvT3gZALLuO5XJNigLtUwZcOG3BTrJB10IjQdUrsPiFaKfVzVgcXnFTVDgd9oBTbahY9yVO8bhJ17T/AA6yr1oeqlUWI5qe4WXtqrcksqoVG1gu1Qv5vduLNr9O4EfXrNuW6yGaOMge9S/CzCD83undALmVJBUAaiFMEaAxHrqJoztkUCLGjqXYXIuuxtzKNsgAxEMAGAUfl9/qp2t1TnbFWFU1MGU+47lVUFjYVHYjcGJEe522CYMR6roJH0oyiQWIp7kxDiim2FzBQAoSBqrS66kabC27aq1Ke5gevrAiMHc5oNLqaYHkHwsF3AnaF2vYAGn6bZEFh6z3H49R6pRyxTaaUUl/9Vmf0vyDft+X5d39HZsjfO7bHptmfXt0/wAybO1HQfJDvkv/1+OrZOupHcRpEekAGP8Au69c0k1Wcl1RAu75G3BwAu32sCGlgxaQVIACwZnvprIAx5JZ4IuvcpJUsg2lH926QVKFdIjep1+vUgjUUS4YIitAZBkfhMKBp+Gk6699OnETmmxzRSqGaZ1DfmPruEax27xHUjA5pkdjJiH5jk2ZNQXHufFFGNXd82YFUUY92/Ix/gxrdd9q/IyRohnpjqpoiDWtWYZnAueXtRRzStJKkkop/OikiYDA+5YIK2KTInQH6jomcVCLmiVBgQpUEgAA7mBgDUH0+sfzHSA51SCyR8Cr+DguKQkg/Fc5n27msyLLFVZAbcQT/qGsR9eszdjVKY7YKzbIGkroe/24+TqwPIP9vrPybKhRyn3b/cr4VkSU3EeR+O5ViYbL2Kvbjo2mpKj66+E/WNict79SQhHDbbaQ5NOQMvAE+a2NtNowPMrnG++Ph7+CffL70eE2V/E3iP3a+5HjgqAMUpw/mXNYdVIMkApVjqJI9J6996Rf/WdJ6Vug/wDM21uVcawiSVh3Y6bt2PCRHtVdriqy7t6qysIRy+5/kXZvrr2FNqOokkqwDaA6xfJqBpKCIqikoSB+RoLswCkFSVYLKy0iCIOkAfwPSwBKXFGUY6sQNrJJLKIIEiPdvPopP0BPeOglyRx5p2pWt/i21IFCVo6DfYhZVCvYdzsV+cSxAIUQQBrAAPV5PXsFKeQUiyLcC/IF2BiZWNS2LgpkLyOanIZd+aMOleRzDlph4S/p87LSx6KirNRS6o9lrKbGgjC5GGm5KJOotpjpGlzpDOagMCcy5AiCyOj/AIpatSU2kBdyghrBvZghP9OYsIZh2BiJ7gDoSpYVBTqMSRWttiV2guzpvVvjCEMWfaS4SwkbG2hW1gkqSBEsQ1O2H2otIcI6miosrOthC793xuqtuUlUUP8AG35HKloElQYPqIpux0t2xUkRESwxT1hL7PcGrlChG2wFj9VDMVJHYkD2zMdV5u7O/krEfapDTVUFJLVhg1ftdXiwtW6tqFKqKdgncRMgCdYgmCTgfMdqqWJyqn7Ep3hyrRKK6jcs2KTop2LvJ0J1B1kz1UuUNY/2qzA8lNuBosvyhU4Ib5a9tUaKLPVlDS+yoMNB+YgnsAcvdtGDjzVic2gG+I+5Zy/t48TTyr7r/bbgXAuou8o4zMyU+Oa2xuFnmeRL+4b6zTiMhJJMsQe0jhPqLdna9K6jef1i0QO+XpHtPsUQLkV9SyD+7v3OyPFf3k4/n9GQSPt75t4SjAH2jF8ep4scvWw91vx3Jbk1kKANpjuZOF0DZCf0rb22mt23OXjIkx4DIH8EpF5Ngtov+4P9jvKvvZ4X9q7/ALa8BneWeWYnn9Xj/Hcfx1avlZ3B+ccd7bb7QGqxeOxc7i8W26+166aELWOwVRON9P7uG23N4XS0ZW341izMOJcjPwqpYSESdRRv2I+wfh37SOKsowMzjvMv3A8lx/6Ty77gYtfy8N9vcTKT4szxL7cfOgKZ5Q/Hn8ntW92G2vZX7esn6i+pJXZy2+0k3Eiun75c8I5VqjANxjKlvhx71ix+637qrRZi/bLict3uyfg5zzS/5f6gDstvE8RkMxk3WsVzcgFi7gVKwncpx+gdOO4nc6ldg9uBMbb5ywnPwrAHjqL4Loel7cAG/MVNB9/2LE7DyDXYgUlamQVoFdYIVNjjezw0FwxDGSBJHqdy7acE4ydbUSHwU043KCBVJJeVLWBitfxw5cbNh1dnkkN+QRr6ZN207lvv7BWIsatQKa8dlsmzeGYE6NKWMp7OsrFe1jEwY1EaxGbetYszjvCkBdmIU84/PAXaVVSGrIO8Oiq24kdwd4A7ztGo1J0zLtp/aniXOaleNnkBQSwsUgbV7bSTIcKZCMDGpMkEEjt1nzsiuDIoliS9FKsPOIVAzKWrJk0k2JYCeyneQxIB1gwe8RuNK7a1Sw7du5S0Zwpdick1QeLGCiS6ggbWXYSCVLDsASWJDASOqk7b5VZCzsWqpNhcy3+pjNhBrKsQpQ6l9W7EEHsDHVadpmZO3KgUqw+bIjUhNgX8xJ3Kf9O0oyptSI7qDrE9V5QZ02kZmrp5/v8A/wDLbN52zt37DE7Nn/R3f9P5PbHfb/j1H8ovyS0h3zX/0OPBULKI17RB/mJPcbiOvYQCccFm04ohFJnaANCO42699sCfXTqQDMCiXAIitCIESBqYPtG0d9fWf4T0QAol41RlaflIUTpp9dd0HX69E1GATIpFiZjSTBMgwFncZ0APbTp0qPiia61nREIgSTLanQ9wR7R/A9FjgnBrijUrHbZub29gp0nudZUCfrEdMnCNStiBAOhOo7NKkAg6ED3SdO3+bpOFkP4S6ZXCY9mEmVZVxVePichkV42R8WJkshsRMi1B+nVnYFk90sF0mT1nbgetiQ5ydWIF40FAt3v7RubTxn7cfsi8yeu8YXh37xuVu5jJx67bKuO4jl7szB5HlMz40savGxaHJseGCJ3EsvXkX1JaE+s/UdkzEdXTYEPRzEgt3tlmtKxImFlg/qdUB/uX/snzPHcr7w/vN4Hn8/O4L7h/fnkOX5HwnL8dq4jL8Y8f8+5HkruM5vIuTkcyyv5ebSmmyq2tbFOYljCsk1i//T76+tb/AH+x+jb20EZW9ofl3tZPzJWmeDaQB6CZAgn4SK4pb/YfLhLdxm5MqhsHzfv5ZrTxxHFctz3J8ZwfB8dn8xzHNcjh8Tw/Fcbi35/JcnyvJZCYfHcfx+DjpbkZmXl5Vy11V1qzO7wAT39fuzhahO9dnGNqIJJJYACpJJwAGPBZeiRIjEOSt0v2V/2Fv3x/chsTN+4mL9vv2/8ACZJR738+8lTyPypce2S6p4j4QnMOmSgM/Fl5eG+47WhhHXnPUv6pfTmzEo7OF7dXMtEdEP8AFNi3dE+0K7Dp24m2siMeePsW1z7ef7CP7Ovsv43nec/uT+7X3I+7GPwGK3Ic3i8ddh/a/wALKJCpi14HDvy/lvIPl3MqVVLytNtz2ABQSCPPurf1X69dhM7LbWNpZGbG7OuFZNF8PyZcCQr9np1rVGJJlLyH3+1ayf36/tZ+1ef4Zf8AdL9uf2r4T7WcR9uVtp5Lwbxhs/L/ALr9vS7OnkXJZ3JZPI5nNeWcBlP+o5DLe6xmxL3OqY6jqj/Tj+o3Vrv1Nd6T9TdQnd23UJD5Ept/JvRDC1QBoXoho0/1YgD41d6h021Haxu7aDTt/FzHH+H3LTUtR+NHK2ILFS6svWUFtb2Md9ZIVTSGRgSI1Hfr6PfUWofv+9c+A+dE849KqtT7SRthYLakhpZS43TWoDep1UEa9QSqSFJAMU//AK/NbjsPinvd+PwcvP5DDxmqoCU5XI1YFObelwpGU75FfG0gozHbs9oBLRW+XbFy5fEf5sgIk5kByA2FDI5Z9ynIpyyX4VAMVUKASJdFLKfjr9y1mwjcQymSdBGneATuBRIZVTrjJPvfckoQhG1rCNs7FPsZW2wBofUx1WmGLN38FOACzEupDVUpr2wI3Gx53Kw/5q90Mu0NE6SNRA1HVaVEbnF0/wDHKdNte4BwoDoQzS6mZOwrWXC+7TbIGg717oHHLj28lNbL0IoU4eTcvb4l4u/KYd4xuayrqMLit9SezKyFS7JyPiYFXSrFrghoUkqNRp1nW7Y3W6NucXsxFccnYeakuTIYk4Bh3rb1+wPxqzk/unbzeaAbfEvBrnyLqkU1/wBx5yzF403Jt2pVY1b5TAAAAL2iI8j+v9yLfS42Yf8Am3/ZBz9ykh8UicVjh9yeTHlXnHn3POrf/wAz5V5HlV2hqy2RRZyeUlIrOkr8SiT2CqIMGTv9NtfpdjsLA/JagG56R270JPqJfNdLP7c/PeR88/bD9vPLeP5G/H5y77b1cLnZeLYUyRy3jlF3jnKBba9rV2ZdvFupII/OCpB168x6xYnt9z1CFqRjISk3FjUd1CykDahqDhY7/cjz/jftf4RznmvJhMhsGkUcVgWOzWctzeUXr43iy/8A1CLLVNl7alaUdyRBjkdnsr3Ud3t9jYJErmMv2Yj4peAw4yIGa07No3rkIDDPuWmzL8k5LyHleT8g5fJfK5bmczI5Lk8l0ctkZl9tmRkvZuG6uskBUVCFVFAgCAfVhs7W1s2ttZgBZhERiOADAd/E86ro7JYxAYAUUkwOR3tQlntexT8ajbBne5CIGYiVr3Bm0QmZA7592xSRi9O3birGpi/FTLj89UZA7mxRYdWDBibdzE7iLIALyYaR3E6A5N6yS/pqytRk4YAqc8bmlSbCgL1pvL72A+KdiusCVdXaUULLEa9z1l3rWAcsfejchmdlM8TkmsqTEenG2ra1ll7ALcyZNdLGrIyUsIepFpmtdpKO7SSG0oXLGMnPLw7e5KJAINVLcTOKorVspaQtZRxM/nVY3AMNok9xtPqTBzp2XNRRSABwQzJ7w+UX3LvAKyk7WG1rfypvj/QT6fw6qXNvhJlK6lFHJl4EkhhXq1m5oViDunUltpDAamf49UZ2dJ5pwWUiwuVUpHyFhoVBCxILq3ru3bgBH+A7zVuWCC4iiIFE/UcsJUB7CkBmUE6mshSRBIYuWnWZ9ZPVadp8scO3bwTVFaJ1/vOmz5DtmIkdojdPeNvpH4ROnUPyasxSriv/0ePILr/pGp9wJ07TETqP+/r2QCj5rNRaAgmREELAP0AkasJA6MAYBMi61kQIAAnafdJ19fUA/wCPRAcClTAlGVqSdp2gjQye0GfWACdx6JsEnRddWgAhl3AyTugEgAsZECfUnXpEBLHBG/EFcqdm5SwLKQ6tEg+4HYymNCJB0PrPRAg9yQcIpBJMyR+UdgQNANBIkST69/59I4IuSNrrML6CNp93YmSPr7vTv26Q70sVkh9tfJeewPHcfh+O8gt4vGyXzbLePXmMbisbIb5wttliZOTj0WWMgUsT7tqKJ7dZ27s2J3fmXbUTMMxIc+FH/tVm0bmnTAls+C2Uf7dvmnO5v318H8Ou52/I8QxOD8+5DiuBttS7hhzV/GNm3cnTiov6azOFqBkuguqrCwvXnv8AUDYWP9j3e7FkfqjctAy/NpdmfFuWHFXNlOQvCBNKre190ft5xX3o+0f3G+0XN2pXgee+F8z42uXkMCMHk76vn4DlCbWat14jyKjHyAI3DYJJ7deE7K7e6P1XpvWtvB7u1vwuMM4ik4/xQMo+K2yRdtXLM8JBvu9rLH//AGd/9sHL+xwwv3Q/uN8eqo+8uWmVV9rvBuVQWj7ZcXY1+Hf5ny+MGPx+ceS1Fxx6mf7Zxzh4GRefh9a+vfq2PV//AOR0m6JdMDGcx/5hxER+5Gj/ALUuQrlbSx8v+bMevLkuhtcpaq2sy7Mda6abrrsh76qKK6qa99ttlrla66qkVmdyQqrJMRI8w+QBQjBX9dea0T/vE/d5k/efns3w/wC2uatv2/8AEDnLxT3tbVgeb+W4uPcuNzue9Zqv/saZKfDgqDKVbr43uu2WXSjM2zuomNtxQYiJLEtg7YA93FT27gg5HxlR37PeE+A/uz+z/wBrMTmcgePeGeZ8RmZH3Fw/1tiWU49/Ecpx/nvDX5ZrpszeV4PlsC5MNNEsysancu1Qh5jd2N19OfUt8QvCG4294St3WHpFuQuQnGOHrhRsxIgVLqxC982E4kOJAgji9Foy/fj+0Gn9rn3Owf8A0XZ5ByH2T85quy/tzy/kFtOdy/G3calNfM+J+Tcjj4uHi5nNcfuTJS1aakyMbJQqv9Nwv0f/AE1+vofW/Td5HeW4Wuu7WbXYRoJQkSbV2AqwkPRIV0ziRmFi7/YnaTgQXtSFDzGIP2clhLRWQiruLrS5sRWLBBZYFc7BuCL8qgTAaY9Non0aTeotU8FTicEelAHoHUg1hiCQkNIauSDtdi0wNxiBrr1CTnmpw5eieaqmPtARGIRpAYEBAXbeQxCqrMpMDXtAOgilkUVcE41VAiJcgFRsCwsGCbFVoNhZzI01I1MgDqKbHBHGXe6dcVUUKHDfn3liwUPIYTt2qUgzoQe4HpBgmOClBGBxUm4/Ha3KqCisWm2So1AogvaCpf8Ap7KztBI7+k9Ur84whORNAPbl7VJAMaKLeV5X/qT7o+DeHUWfNicfzGCmVU1jhGyKmr5vm2IQuVSvHxkpDD8oB/E9VrA+R0/d7mQacony+GPvdKZMrkAF0Bfsvx08X+zH3k+5dlKV2luRqxskIa2arxXx3K5Fvh3FS5/W8kRoW9wIOp08F+tSdz1rpPThKnpcP/1Jgf8AhCswLCTrW3TkW2Ktjz8sfMZUvIsl2I3s07nmJ3HTQMOvRZxAlIflwQGhIai3u/7WfnDc59l/MfB8u7fd4N52+bj0Myu/9n8w48ZlaCGlK15LjsvuF1aBqNfP/qrbi3v7V0D03LY840PsZTU0ghYNfvf+4HI8j95+V+2gXIwuA+2GfkcYMe/2pyPM8hjUZWRzr1u23IoPHWVUYp7/ABhiNLYAfSfSbe12N3fyIlfvksRXTCMiIx5En1S5sPyroNm0IRqNRDrFbHtrs9yMw/1hXdCNysyuGrYv/WDsVUBdB/DToZ2yKHt48FfhNiCpNx+VuQl2NZJsV6TAZWiDYXAJrcAkAgAtqD30zb1qo014H8O3sVrVQEFS3jMsn4yVLkFlrmsMEVEIVZld21lJUxErM6g9Zl60PVl48+wKswl6WAUt4/kFVWFg21ll3SNordndjZIAAsYQCQCx/GJ6zb1iuCliXq9VLcfkQNmvyWhgSyhZZCVliGZVesBQCR6fhp1QnYqcoqSJckUUrwuWWYs3HaZCuwAaxp9fc0aakaQCe0Hqjc25/KMQjiTTSyk1PKqpUGyWVtA+tZA3NIcKGDINxUwPQESNpoT27uG7du2afU7cU+UciFeo79T+Qah95LyVYsy7QoOpnURPVS5ZxcUUj4uE918iAiFnIbf8in2li0gaGZTYDrGhbWDGtSVgiRID0SBOTp5xeYmYsUkwFMgAKQyhkLdu2hAj+XVWe3GcewR1oWRv92Ef9T13Tvr+X5YnfHfd6zOyf/Nr1D+nql4fcv/S4/FSTI9QuoEE6fxAJBOv8evaAK1wWW+QRSJ3mB9NInbtgTP+oa/+/ogCknTBsTFta23Cxc8GjMoFGWcpaktvxbcerMVsTIxrDkYNtgurBYobUXerpuQqUTIMJmNQXDPQuRUGhwObGlapxRelSNuu46NO3WYjvoTp/AadH4JYFO3H2YtGXhX5mH/cMKjIqty8D9VdhDOortQ3Yn6zHRsjE/ULK/KoLJOnboZicoSEJ6ZkFizsWoWNC3ApZhflrUEEaakrtJ0EyQTHuiQJ9f49FwTOjUSO3btBgDuFO3sQdP8AjHRhiHTo6usQJILQAdNpn0JJj0GumhGv06YFkTL55LXTXxXi+W5rAxvJ8jEUsBq2ZVj5CbST7nZqTCgfh6dU9wCL1o5uFPbNCtwX+3/4N5v9v/3D/ZhPOfGOV8Vv8m8a815PhcHm6Bx/LZHAXeNcq+Dyr8Nkv/cOOwc5Y/T/AKiqhsiv+rWDXDNwv1tuNru/p7qo2t6MxbuWxIxqAdYpqFCRmxLYGqt2IkX7eoM7+5b+1/dR+z37Hc/a/wB/vvn4X4py/FVY3IYngllXNeQeS5yX1JZicnkcH4zxHL5i8dAmoWLNrrIGwe7yXpv011jqkY7jZ9OncsEkagwiSMayIFM1pXL8I01MWUO83/38P2VeMi6rw3gfvV91Mxfnh+K8R4zxLjcl02jYvI+V83g8hXVkknay4b+0AEAmOus2/wDTzrtxvnSsWo0d5uWzpEHDg4fIqD9TAVDusOPuD/vU8h+6bDy/sr4V9sM37NcN5QpXO5/kvMavI/IfJeKxSLLPF2r47h+HweAq5GlHa803ZFmTWppUqrtN699BT6ZZ/W3t3G/pxiIsBkJOSSWLUYBy5wQjc6zpAYLD3yPzDO5fmk+2njWS+Ly2djLf5VzOOdz+I+NKQcj4rqwtY5vlKz8GKCSagwMy27pWem2rVn/c9xB7YP8ALif/ADJ5U/ZGJ4sj+YHAByWaP7HfPvH+G8q+9X2B4SzOx6PAeY4Hzzx7jcxUX9NxfnnGY1nkGDx1n6jLObxmF5NT+rWxxW5s5FpQAe7zf696Tf3G26T1y+Im5ftytzIzNuR0k0DSMPSf7gqre3uiMiBkx81nj98fsj4x+5P7PeT/AGs8pNWJdy1Scj4tzlla23+K+Z8fVeeB5+hwrMKDaf0+ciqWvwr7azqQevKOidf3/wBGfUOz+oNgDL5RMbkBQXbMm+ZbPNvVA5TjE8VtXrUN5t5W5YEODwOR+w8nXJr5b4V5H9vvLvJPBfNONv4TyrxTl8zhec4y1N36fkcK413NS2xUv469VFtN4O26mxbFLKwHX3T03qOy6x0/ZdV6beFzYbi2JwkM4yGfCQqJA1BBBAIXIztztXJW7gacT7U1mpjjmpa2OYjWbXssepFT27KrECsKHBDMXJaJC7FI3GxINIGmhu3b2o7dWCKqpLlaiHWAT+Z2Kl1gr2cGtlTQbp0PcmOgYAEhSsFIqslTgU4K4nGoMW/MzXzsbG28neclMKlMXMydzfNhYhww9FQQFHssaTv0qyttclc+ZP1ADST6QzlwMiXYl6gAZJsMBRHYNF+ZdTx+Ji5GTmZrpXjYmFj25GTlXbXrXHxcepWuvssckbK0LExoZA6imY2wbk5gQGJJDDmTk3MqWNWYKe53Fc54h43k+Yc/wnKcRx1Wdy3E47clgZHGW5XOcHicZyGZxy4uXXVkG1qubwtwZNhFwHcGMi/dt7idrb2LonqYuCJBi+YpRjzopvhDvVUZ9jPm537tZvOXsbH4Xg+Vz3utjYOS5bJXD37/AJFSoWDLtIJ09pAg6ibqzW+nxtRFJSiPAV+wIbZ1XXOQ9q6QacY/bn9gce+jkPJPFRkWbNg3ZHnfPVus7AIB4fIQBhoU/hA+fJkdR+vIlwbdu83haj/mCuOwNFq1rtC1q2yza7N8pV0RrgEBNrEA7KnCqBPvJGnvg9enSDkgmvd27Y0UZIOaz8/2/wD70r9ovuJ9wP1WDmctxvk/gLAYWE6/E/P8Dy2Jfwn6qxitOLh3jPyK2tUWWqrBVEadcf8AVtsDZWLxIFyNxg/7wJPOjAnDzU0Bq9OaoL9xn3HzvuR9+fuJ5byjYjZOTyuLxbJgY4oxlPj+Fh8LsrqWTd8S4QAssZmAAdmMMerv05tJW/p/p2v/AFbkTc7hckZgcgAcM+9dBZa2Bb4e9QXBa+jCHK2U2jiXyhhNnBS+G2e9JyRjLddvxxeMU7wslgAWAGp6s3bYlM2Q3zmdnq2DsKs9PKqs2yJENQhOeNmAGoq6ulqFSR7HuQQpZlfUo9Q3Sx269yY6qXLNJBmPsCtOSGoyk3G8hUCoVl/qzKgggAaQrh1+MuRIERoPqIoXrBrqFRn+Hb2KxGRAIdSrH5GFUS6hoRAzKoDBlRmLMD+RZBBnWCAO5zp2S5BU0ZPU4p/xeRNQMAJCoKB8igXBXNZC1yQdwA1IUe7QxHVK7Y1SJLnw+1Si5WIerp/xOUurNerbHYAGxwDFZXe25gSgVg2g1gfiW6o3dvH1FvUOw+xSiQqc1KMfltgVrLdkKyKxKVoTtIrjeVsrLOQQPy7oI7gmhKxqemfbtikCap+xuWQimqx9XVWashvy+1mD99wJcLtmTqNYMVLm3PqIGePbsEhIvqCeauXVVDOx3yAh+RQq2FtyglgdqEgg+snUk6GnLb1IAyUsZviK/YnCrnKwGRWbQglWGgQgklmgiskAmF7dj6dRnbl9RHb7VLEg1aiP/vixG9Zifz/1P/sRG/4/WJnb/h1X/S56aP2qjaLO6//T5AUAkNoViCIH4kDQ9x17UBJZWaLrAWdYI7AR3IIMfXUfx6IDMpEopEnQfX/VPYETpP0YE95HTsnRtdZhdQAdZiSQARI0iQBp+Pr057kkbSBO0+4a9+wgiTB7jXtr0q45J8uaORFXbETDNoAR3IExHduw6WkpvejEErMBTqx0OgGn1Og7gRrHr0YiSDVODVFAop3MwGhkttC71AI0hezn+Z/DopBi6ICi2o/s0/cT9k/td9sud8R8X+xHDc59/wDyIvkZf3m+5Wbw/mvE8HicdkWW01fbfwvP8dTG8T5jApam6nJL5mQ99XytZ7K604b6j6T1DqG8tXr/AFIjpcDS1AGMiSGechL1A14AAsBiVobLQSYafX5qf/bLzXnvK/3u/aTO57l8nlOQyuE8oyOR5DKysvJyeTzuZ4zzJnu5HLta2/Kybr8YFmdn966mNRkda2lnbfSXVoWremIlCjYAShgOFTgrMj/3dkPl96t7/cv/AG75/nXgvHffPxLi/wC4c39reF5Qec0Y4Ccny329x0s5QZ+NRM52T4xm/Pb8YIsOLk2uJ+MKcD6D6/a6dfvdL3kyNvekDbzAuYN/GGD4OAM0W4s64C5H4g/l+C5+eJ8zweSz8bApqupbJ3142TkvWtFl7Vsceq3abHVMm6EDyQCRIM6etQ3tu5cEIwLnB28FR1Lxhef+T4HIY+Zx608Jn8Xm15GPaputzcTOwMksroXsRBZRfXEley/xmKd+d2Erdy1ERIIINeRB9yQ4hbjf2pc/xPkv27r8rxcls3yTm+Ry382z8pgc0+QUuFbEdiEB484t1dtQEoRbJjULwv1HGfz4WjFtvGIFsDARzPe9D3U52IEkAtVPXiPn+R9pv3+eI+UC9aOA8k8c4fxry4NYGos8c8gXF8ffPa2K0b+08zXgZbwDtSh2OgJWh1HpkeqfRG425i9+3OU4UrqgTJv4o6o+KsQm1wHJl0T8ByF7W04laWvf8oqGOil3a0llVKUVJZxWpAQBmYwYEAH5n6j08T1SEXft5krd2t9os61nf7nf7ZU828ZT9yXhfGq/lXh3G4vFfcrBxaCbub8Lx2ZOJ8rrSprGs5DxJrhVlvBY8ayGYxj16T/Rn6sl0fqEvo/qV1unbqZltpHC3fPx2uUbzaoZC6CMZqDqe3+ZH9VD44j1cxx8Pd3LRSBqrggrHvKAL+VFlxr+cK3ucMyldNdevp0hwaVWHE1CyU+wX7Qv3J/uUzaqfsh9ofL/ADLCmuvK8pTD/svhHH7xtVuT815qzE8fpCFpKLkWWT+VGiOsPqfXuj9JBG/3sIzH5B6p+EIua8271ahEyA9NFvP/AG9/7AzIuJzn7o/vGldSCq637ffaBA9laVKrWY3KfcXncVcemoCzaxweOYTJS4TuPnnUf6i3LmqHSNiIRf47tfHQCw8ZHmFJ8mJA1Yjgts/24/bl+2H9tmB/aPsJ9pPEeA5mus0XeZZWN/6h8rydqEtdf5bzd+fz+ZdYskrTdRjSdEC9ebdX631Lqpl+q3c7xORPoHdANE+Xmp7dsRDswWhf/fW5nLyPtd9tznZdmbdife/mMO/Ktv8A6j0D7b05uTiVIrqlFJ5LikYKEGiLEag9Z/Si2Y77rUTUxtw85SINOTU70O5kGi1AtIn7TuAv5P8Av2bRWbMzyDnuH8X48pCs1trE2qjEPB+fka2OhgLMEA9enfUN6NuEBItG3CUz3AfgVDtx8R4ldDX74L6PE/sR4Z4RiPXjJf5H4/w1KouxTg+JcLk/IFJErFldRJA9w17GevAvokS3fXd5vZAki1OR75yH4q6SAwGa1LDIVyybRYtKhN49jmkwUaK/l3AHQKewDdtV69WMGIILE+9RGhWbX7QPDfIPIuS5P+w8TfznPc1yWPwfBcVgGpcvkcrBx7+Wuorttauquv5TUHsdlSsKSWAEjz763uG8drsbQJkYkmjtqIiCwqWGoq3Y0gxkSAAfcscfuL9u/uj9svKcziPuv4J5Z4H5Jm5XJciMDyvisjif7ib7w2fdxF+QWw+XxFvtj5cay2pQ89567jay2d7bwjsr8J2IRjH01MdIaLjEGmYWnC4JORIEHxUe/V204sGwWJYZaos9P9WQotRHKKT8Yhp01OusAJWxKZeLHjjRWoTDj9rJOKZWRKjcCH+BVTaZUbA6fIA3xkh12iTIiDoIFWVu3WmD9uKtRmpLRmnR1YI/s2oyhRtRWZIIbe+1iPzaSZ1HejO0CCCKKxG5QUePbtVSLE5FCgNxFbMSssoC16WWTIBZ1J90tLL3EASKE7BBYBx28u7BS62AbBP2Pyj1VqSR7QNxKmK9XYWMp2qyuzbpH8dZnqjPbgktn2bt+CkjceTjAp3xuTbaGDidrbJLOm8hRWLQGkguYCwdDAkkxVnt3cd3b7VajMgUw4J/p5VCWL7SCjaqrFA4B2nbDLuUf5ErHeaM9sWIYt7UYOoFqHvUjbyCzKyzblZd2XkMpNj5Nge1nQV0g32WsxsmpIBBWACpj29UjtdEPTARjy86dvNMPTGgZFVcnIj5HVX3xJIBXcoLkN7ayoUEGJM6jQdQy25zipBKjUdHVc0tQO2zci71Klh/q2FlA3Ft1SsDJIWAZPqYJ7cmrVKLU1GxRH98G3bvrmPknePi+Wd8T2mNZ+v49R/pTjp7YdsvBHqlx9y//9TkFrBJH4Cew7d/WNNPX8OvbGyIWQeCMrXUSI+srP0gabvygx27dOxzRYI2pIgwqyO35ZPYR2Mz+OnTpxgCjlXcZcAH2gAKtajYpQQi6QQvuJHuP8dVkWd0s0augGomIYkTBI0UanaOiApmnBbJEblRQzMBrqSPduEzECSf4dJgKkpBfDlwrCsAe0Es3u2lidQqmDp9dJ6cGrB0kmGLt/VcsJIk6CWYEABYhTEiAde8z0pEnNGpt4NzuV49z3HZ2KR81N9N1akgK1tbf9JjukLk1M9Rj0aZkdQXrcbtsxlgQjtyMJiUTgspqvvmv2r/AHJfbv7pcdjVcjwvB4vi2ZyGJrfdbwPJ0cjRzFODYGRaM2vj+WuNXfbeqA6SOud3XTD1Lo2+6bOem5ccA5agQYk8nAfkr9y5H51u5iGHtXRRzf7i/tL9nOH8M+6X3O8UzvuN9ifK8vj+P8i5LgWfNs4fgPLOLsu4jy3M8cWpT5d4occmrkcRLEuWq0OiXFDS/inS+ibrqO83GxtXBa6laBMYyoDKBYx1fllnE4EirYq9K4IQEsYk1XKv+8P7GeLfYH9wHlHDfbHybjPNvs35Q1H3H+xPnPj2cnIcXzX208pyL87gKKc1Cr18z4jmLdxGfj2pXk4+ZgOttdbHb17F0jcXNztbdzc2pWt9A6bkSKxnHHwlSUSHBBDLMnERLj4Th3KvvOa6vIuK4H7lYFVFbc0RwPmONQAi4PmPG46s+ca09lVXknGqt6ns1yWabj1pgtKUCcajxTkFhJXp+zj7snwD7kV+McnkrT419wLMbicpr2ijA5sWfHw+cWYkVfqbLGxLDBVktBYELpldc2f6raSlCJ+dbGocxmPtHMc08SXbJZ4fcnisC/8AdF9l+N57+hxHnONZ9t+Zv9qtTiedY3N+HnNreX2X4V3IU2B5G22oMIgdYeznP/611W7ZL3bMvmxHO3puN3HSQ3Aq1D44A5081tV5D7zfdziv2j+VeSePn+w/dzgvGc77d/cfNfFyq/IPGuS8b5geH/dLK8flqbuM5zLxsC62rLjfTx+Y1tOywpYPNdr0vp9v6qs2LkRLY3J67WDNcjrtP56SOIbB1YjckIyGrkUD+xD9xVXnnjF32a82yMXkud4Ti8pOBXmD+pr8p8MOM1Gdwmat7MM23h68h62QhjdgWCZFZnI+vvpIbPc/7ts4ShYuSGoxobdwF4zi2DkAgvSY5q/t9y40TrL3hbKv2ff7aH7GeBwMv7g2fa277h+Y4/kHI/JR90s9/J/GPGLjk25eDheO+KJjcb47l8Zh4ltYqfNx828Ko3PuknSP1t9S9X2Vq1e3xtkREZfLGgzIDGRk5k8sSAQASzMq87Nu1M6fhK2x5fM8B4jxmNx9VWLxeDhUCniuB4nExsHHxqqa0rqpwePwq8LEwcSsKB7ErVQAPbEdc/cMLZlO4XmT3knic/akHlkqf5vzDkOdsZCzYuEvsGHWzD9Q4AcWZNy2ILyWOv8AoBB9onWjcuzvUNI8PvUwAi2Kh2Rm1Y1GTm3AirEpsuvfQr+nxw15b+rCAqoYa6wdQInqJmBJwCJ6Yrmp/wB6TmLeR/bv4ZlNjmw8j99cLLuyt6t8FuR4n5pYVkv8jHKBIE7gAhHtkg95/SsyPX9+DMsdrItxOuFfB/aqm7pbHesK/wDbf8LflvLPs3gvSLMe/wAh5DzfOURubB4o5XJ0veuqoLP7ZQgnbIZR2663+oG8FjpvVZv6vli2O+TAt5n2p9sGjHzXRf8AdX9n3j37jfFOB/8AWHlfk3iXJ8Lfn5/BvwdXHZWGtHJV0VWnk+P5TH+TK+RcRXT476GqT1YnryP6a3t/osb24t2oyN4CknoA7MRgS/OinkQSzYLX353/ALWn314a23I+3XlPhf3PpLH4MGy7N8M8kyK1XYqJjckvIcNlZDbJA/uFIIOkSAvd7f6o2F3THcWbls8Q0x7GI/wn7UDutwX+35+1O39tf2nxvJ/ubxqcX90OVweQyuYw8i7EyP8A0PxGTkWZWRxYyeNys3Bs5bORK3ynottQIK6ksneTzPU79vc9R3W91fyxSJ4RiGeoBrU1AxRa3EYDAe1YZf7sG7z/AO3PiP3Af2UeEef2cTg03K//AMpwvlPFZGKVKAnY2RyfEY1lgG2bG+qCF9H7+dz6g3Fmui9tyw525CQ8dMpf2K9sz8cc8Vohu5L5npZGdSqBZiohEbRy7ByHNunuJAG2Z169QFgASotGJI596dqM1mFopACyKgg97U7gQA6ll9phe7iDI26607lkekzOT9v7OFVYjNmOalGNzOQOPXjvmZcFspcz43rrCHLsxmxhf8prbIew49ewoX2CT7SYJoXNvH5huAHWA3g7twx5OpITlqrKqdKcy0oALDTdt+NGWxttoYq4gPLM4BidCBr7T2qytAE0ePu7cFOL0tTB24IyvkrK1DW6NubdXWDvbcxVoadgdmrB/wBRO4AdoNeViJ+EefZ8/YrEbkZDMck8UcjsglgGUSy/IXBU2IxIVjt0LRqNw9e2lSVh8QVNGVQ+KesfmVs2hbGZgAWYVlFJ1aw/G5KfIQ0kgk6RJM9Vbm2YGlO3sUsbgIYsnZOZ3MqhiRC7fatde0MytMunfbMSVEwPcYNWW10guPvRasfUiU5tqxDqQqq+1SEEklXJaytWALiDEgExI06gltNXw9vBSAuwonKjmQyr8bI6oRAfYCw+VmW3VdVRiCRodPpoa89qQS4r+Ccmpf2Lx/e/d/1D/wBPfPtj4/z7vj/6e/8ACPze6eg/S0du2HbLJHrDYZ8F/9XkKrU7WcbSFKA+5QZadvsncwEGYBj17jr20FiBmsihyRFcyOwM+0r3A2kEH07/AOPT1Ll6IvBONcLCyvq30hTJIOnpE/UdIs4BGScUeiJ+ZK+zncABtADxoAIHuG3Qd/UenRCQFDFJn7l7GSfZJ2V7gHNcWWBJVHKliq/JtMgGBIgmOmLl8HTgZLyjERJYa6Fm3E/QnuPcV7dhHTEImPBGL9d07gRH1XT/ACUsSB9P83wZNnzTnhYFudcaqbMdWXGzMonLy8fCqKYeNflXql2bbTU+S9NJFdSsbLrNtdas7KpK5IRiJl2cCgJxIGVWc1OAFTQIhmAF9rBXa6uwIcMmsRboVbVdwOgjsT0zOU+DLI37S/a7zT7nc3k8/wCNeF8T5hwfi3i/OZ/l58tObR4jxVFHC51FH6vOxszjZ5pr7ls4nGS7+pnV1SrVhwcPqu+2mw+Va3G5lbuXbkYwEWM5ORgGPpA+MtQPgWVq1GUxLSAQFnr+0z7n0/cb9t33O/bd5o45DnvtpxY8k8Roz23PzH2/TO3crxUsSCfGmz7TEDZi5SAQKgBxn1F089O+oOn9b2w02b89EyMrjek/xsPEc1bszE7MrZy934LVP96vB8jwvl8/g8m2443D5bZXBWZHybMzhuVetqbq6mdq0yLFQfOV720tJOh67mF23vNpa3QYTwLcRiPtCrEaTpKh3215Xj78/k/B+Zy1r4PzvFr4vJtdgf7PzdFu/wAe5+BrWMHk9tbtA/pWMC0T1DMONWYPYDvTwZ9JwPYITjvCvLMnP5fAq45sbM8azb8TmMvKz8LieP4jOxLNhORyvKZmBhUklA9c2B2SGWQeo5XoQEJk4+Ne4VTsQSGqFtc8S+/X2J4rC+zf3S+63n3hf3T+9/g/EOvjn2Y8Xv5vyPin+5nGcm6eE+efd3y5OPxvDafDuCux15TL4bC5DNzuSzPhxrEpxrL7hzVrbbic+pdN2Vs29jdmNVwsCLZHrhbi+rUfhEiAAHIcgBTRnGhkfV9vNZh/sc+7XKfcryL7+fbz7p8/neUcr90jyf3SzeV5y5r+Q5rP8nVfGvuU972b1vybWy8DK+NAdvzOdqqIHMfXHTo7IdH6nsbQgLBFr04DT67XukHPmjiWMnNTVVr+1v7EfdTy792HDfafxDLyeA5/wPzXKyvI/Lj/AEKfGfHvHc8Lby+S18Y7Y/I8dWFVbZW5b9plS06nXt/0+f09Ld34xnb3VoCEDhKUg5c/uFySMNNKspbOr5g5Z9uK7EuL5/hvDfHeP8R8IRjj8cHxrOWvxwluZnGwrmchRRYifLfl3KWV2UAKQFkAdeL6o2YRs2cBm2eZ7eSumJJ1Sw4KLX5duQ9l991ttt7brjZZue9pGosUtusULE6gRA9pjqtIOauSjHBeN20BWK/GAqghz7PaX2llcVBQCD6fTtPTMKc0+ThQH7l8yOK8K5Uq4D8l8fFUqrpvH6p6zkncqgg/p1sgj07qdR1WvSa1LiaJgeK55v8Ac+z/AB37k+H+N/YvGz2xuaw+XwfuFyfJY615FfDZNHG8txnA8fmYqGbDydPK3W2ruraqoVnXeOvQP6c7e/stxuOsyh/IlA2gD+b1AykDyYDCteCivwF2Oh2CqH9mnFZXh2P5Dm4hyuIz+O+3dPg3i/M0Yq7KuS5cY9PKcvhZF1Rx2zMPj8CwoDuZLb13LoZ0PrjcWr0dra9M4HcfMnAn8sfhjICrEkd4BYorYERp4BbLvtB+4L7zeDV4HE8t5hy33Zwb/wBNhcdxfmGLhZHNC8uaqKMbyLh8ZeYvyGsKpWMk5UlgBroOF3l+3dmTZ2kLLY6dTEd0i3k3kiEQXZbicb72faT7ReH8Hz33Gzh4f5ZzfGDMyPGrKsjyLyNbkrT9bhcf/bcH4HxMe24KbF+KssxDsSC3UNm7a0k4Xc+3BCbcy7YKth+5jiPvdxPM4/h/Ec1w3jnFcliYeXn85+iryucY0HKrFWLg35K8fh0QrMLLSzvtJVNeqPUNzKQjaiGiQ55oxDTU4rRj/uS/fY8/5nw/2W4PNeziPAQnNeXCpg9eR5lyeKGwMC0bTvPj/CZYO0zF+W8+6oA+g/QHRgNvf61fj67rwt/3In1S/jkG5iPAq7YGkOcStZFGdYkl5JFjFy0EkkvsMkoSSR2J3NunXQH0Kdp8BkrkZFmlgnOjPClt1mqL3+SG97b1c7Pc+h+gZuw7Ga87X7vsUooBwTrTyNdZS0EqVZSFst2oxeobA5sYIWr07DeAABJ0FWdnVQD71NCR704jlmDuRYy9q2r37Et95k2EBVEu0gsVAI9D1WO3BABjzfh25KQSkCTknfH5bFFRdct25NMqrGbijU7O+G9HyV575DsKyttyfEtO3eT7jIkdVbm3mZMbf8tidXN/hbuq+GSk1uSUXXybuZr3iuNpFcbv9AO6oFgGldSkCQJGsdQS27BjXv8AFFG6YipRSeQhTYQoSFaXawspat9q2CB7VcCV10Gv0PUM9oWAx8OKsRuhgT2dE1+ROyw/5GdYBdgGRGLke2mxAywDtlpH0G4mCezGqgqB27fgpo3GwNUavOLVvd0s3NtO1CklAhk/mZ2KMdw3AETAJOhry2pOGT9u3ipheq5CfOA5vgbORqp8iv5rF4amjkamt8fo4/P5H9ZXg5N3GVU0cjlYOM2I/KJTXeWdbK6PlZVsYKrVr22uiBNkRNwt8TgM4d2cuztxLJG4WJg2p88MfuTV/wCoDs2TXu+P8u9tnzz8m78s/D83t+kfh7ei/S5tn+Hbn5qT5lNOktxX/9bkJrAH0mPSR/wgdv5de3CmSyeSXFqL2IJ0IOu0aydxHpA+nScZhOBVkr8lhBAO0aEqCCDEtt7+4kd56Z806VrkkxEDWdSF1gsdSdunY9GC6INxRqqCoME6DUdlE9iDHYev/v6YhJGIOxja2wAGN0+okAmAfXUE/h0QZmOKduKMq7MNdQddAANDoD3Bn+f49CzVOCYiuKKCsxUAhZaAZEggaNuMjRoMj0P8OpY4tpqnCKWuRX20/KdwAC7iQBG2F9xMaad46RGJAojYPjRWN4H575H4XzXF2cfynMjgDy+LbzHjmNyGZXxnJ1ZDpiPdfxiWjEy8yhWBpsetrFZF2sI6pb7aWtxDXO1H5oiQJMHD8DiA+KmgSAYv6Vbj/dPxn7affrgfP/A8nOzKcPMzcXyvHrWuvi+S4rmcezjfJ+B4342S3Nxcnisu+S4VFuKhQQgbrHubK71Hpd3ZbqIBIGg5iUawkeBEgPDvU0ZaJRkDXNG/u78nfiOd+yPmfHcV4p5FxeNRyvN8bT5LxA5ng+dtwcnjMzjcHyPjXyaq+X4NMTIrsOGztTYbHDkqzIMnp9si1v8AbyuThLUxYsxYhwci71bId6IljEsFihmfuy+8nL2jg+d5vh8L7fZj/pvIPtx4D4R4N9tfEeZ4jIrqx8/Fy+J8D8c4GvkWbHprsqfJN5XJprun5QWMFm3bsXxclDVcifilKU5DGoMzIhqs2RbCibWfDyRX3r4BOe8f4XzzEv8A1+ViLx3j3k2QorFfIVnBqv8ABvNfirLLWnk3BRj3uRpm4xrncD1pbm2ZahH4TUfd5+8J5CmsHv8AvWN3H5b4WTTk196mG4bv9E+5IGoDjt+OvVS1clZuwuAYH2HJAtsH7TvvVT4h5j9rfuddlFG8S8mw+H8zIcE2eG+RonA+QZN1bIGOMvGciM1n3ey7CAgRILrvT/8Adelb7aAOblvVD+/H1R8XDc9SlBLCi7A/2zeNeAY3F+V+fePeO4GH5Z5fztuN5jzyq9+fzH9hxsTB4MW22wtGGnFCtjj1/HW1rl23O28fPe83G5n+n2t68ZWLMToGUdReTeL1PBadiIFsS/Mfasq63NZQfJvgsuyWXcFeGUIjCSi6Ayg/09pIpHEcVOEQcplW161U2KzHZvSuqxn+P+mzWlVQIW3CdGUH1M9BM4tilHGqVF6kCdm8LWXVSwVXgGatGuFAO6D2CkzBGrOWAZFiCsR/3c/dPB+33jXG5WbdgvdWbbOO4zP5DC47+9+Q5xbA4Hgq8jMyqAMjMuquZgWLJUr2BfZ0W32c+obq3t4iWgAmUgCdMR8UiACaD2kBw6AlmWknj/tRfzfkfMeZ/dPPr8n8j5vkTy+bx+Mt9XCV5ORYLlxjY5TKzcbHp2BEArxxSiyH7ddnuevfK29rY9IgbW2hHSJFtbCj8ASc6lycE1VflS42Dh42LjVJj4dFZpx8eha8bHpAB3UVU0v8dQSCIABABEEGeuWmZXJznMvMlyTUnmSaphSRYLYh+1n7FniqcP7n+Y4hr5HIqtu8Q4bIV/k4/CvWz5Ofy6rN9iZeath/Tow/pVN8ntZ120L1wSOmNY8ef3KaIzV8/fr7ZL92PA8zj8KpT5LwgflPFcrcis2ZVWa7+KckFTRzFFfxme1qVuB7SeoozMZCRwzRZrCHwz7l8Z9iP2zeffc/msetG4fl+bPHcVkb68jkvKK68LgeD8f2v/VsN3NJtsESlS2MR7TFix0291jrOy6ZYPrukAy/ZhWU5/wxcjJ2GaTOQBwXPnzPkvK+S8/zPlHO5dmfzHP8pncxyuZYxdr87PyrMrMyVfcW/qZFx2hhovtkR19D2dpa2u3s7TbxEbNuAjEcAAwHkK+auAiQw8kLVki0JXbYk7oFwQBdIVWVHeyF3fmAYlokQdA5izkDwRD0mrosZliLuQHYCzRGikyWYF2Rim7sREjufXqI24GlFNG4GDpdOUs0V9qoxYgCRDFNpY6rG+yZmRIIO7sIZWI4g1UwIIcIteRIQMSpBO75UAYBTEMoJTdCyZ07CO2sRtVYYohOrJwq5K1Azs0hdYWyNAWLBEDCuWEGSAwgD0EVp2Yk4V7eKkMotgyJPJkbmrKDftRVIIlU2vA2uNjsVKwCTpB+pi+Q5rkjEiGEgvlPLSpFrja+3QKrHaACJAcqx9q6AkD0MqJCVgOGFe349ipNXA1RFnJWF2FViwyCLC1Y0UIqxWFiS7ETu2gAR3PUP6eJHqB7k4lV3IX0cgKt6sykAKSApDAJvbRd0hRvk6nU6kwSYztyWojFxyTkvv8AekZ3cWCXKhYgH2Q6ldoj2s3cqCIOggMAO0cANh27d6k1s/qSf9593xR7p/PsTd8fxz8G6d++fTb36X6QY5d/PHu8Uvmc/av/1+QIMzfgpMEen/HtA69rqSVlo2oYjY9rvdcuYt9CY+OtKnGtx3S85V1uV+oV6babVrCViplsV2JZdgDMdeoekaWOdXo1PNy48XomXtNANqypOup+gEwD6N6/+zo2bJIolCNZ7GNCe2oG6d0kDQnooliiHMJwClCVbeGgMQ4hgrQwIBIPuDAz9Pp04bIJ2ZO3HfoUyqn5KjJy8ENYb8fDykwcqwFHWk05NuNmV1Mt5UkNU4ZFI0JBAkXJQkLUgLmRIcCvAEP5pweIXysHaC7kkwNFhd5H/KSYRhoO5/nr0ZD5JZ1CLQQR67dSYJfRZMdyRrH4D/DpxQgAVTgckeg1VvwHYgFl7EALJKidR2+nr1IBmFI37tEQ6utTfC7VWBH/ACnXaUlgC3uBassCViCYA6a5EmMo5+9PGqjeU5QVWVsv9OxirDsJTtABBAYRrp1Qk7gqQZqa/dLy0+R/Y7w7ir3T+4eDeYX4WNZa8ZF/jHknE5OThYyKS26vjeQ4mytoPtretfTrE3tj5F+5egWt3gHH70cT4gjxBRu8QHWJtim4KVQl64UqBqwJ9pVYDEqBGvWbOJlUBzTyySyWSf2k8r4y3gsjw7zO1sbiculvGrLslHIv8Z57LFgas7gEzfDfIWTkcQuVVarcgE6AG7ajclZ+XcgRIYP28EcSKxeio1OAuz+ZzuI4m5eYfDzM7GFvHLNWTXh5D47chV8rVBcTJ2ixWYAbXH4dVrdr9RcItFzmMxWvcED8Fug/Yd+0Hy7xe637g/d7hOOXg+e8Y5rhON+3fPVPk8lm4XOY+IMfnr1xc0YuHj3YOVk464+SiZCfMXG3QryX1H9Qwt2D03p25l8+NwGVyJpExJOgFi9QC4cUZzgrFqEoCUzmOxXTd+zXmcSrj/MPDqiEw+MHB5+BhgXMmPh1YtnEFFcs8pTXh0VrDktIj8o68l3glK8Lsy8pOSeJd38SeC0LBeAHALOGqxHHyVkO7kwFDbFAVBBdgylnIExICzI0HVMmtDVTjAogqAA5fTcAJM2CEIdm+Vgr9jqx9uoPr0EkhlwXxh2TfuFh1UECwqixsDsCwRVXcOzSe+hlsgiei0efvzo+3/7jfLOS8T8jxjz3iviuW+Jwl+BnZmC+JzuDi/oc3m+IzMOyz34+Q9lQNldiMob+mQQT0309u970e5Ld7O5pvXAHcAiUcREg5HGhGVVGYiYaQp7lqN87w/v5+0XCw+a8O+6L+efbTIzFw6vG/MKbOQy+MXYmQyPi3WGxMOhbADkYGTTtZlmpQeu92J6D9XTu2t30v5PUoxcztlgas7jPlMHvUP8AMtgHU8Vnh/t8/un+0X7hvvN499vfuzg4vgfkt1FuT4pw2XyCZfh/3G8oqahqfHKM7LpxbuPzGpRrqcPIDHkGT4EtZyK35f6m+j970fbXN5s7xv7MH1FmnCPEgEgxyJGGLAVB2rkZTAOPvXSI7sAyFINaoigIA1YEjYgcqiLqVE6qDrMdecOyujBffnL7dzIJKspAgGd4qAVLACpaChHcgGRIkXcYshWjv/d4wOZ4Dhfs/icLdx2B9vvIPJ/MuX5jhqDZRlZXny42JkpymVRWfiyeOPFZt2wqPZk5FjMo3A9elf0yhtTvesXJwJ3otQETkLZJ1AcCZCL8QEJ7lpGGVXIVEZWCP8hZ1lD2BR0A77RBOk6zOnXsBtliTIEIoyrwKUJINfyVuq2Uq6q25a2bftDgjUw6sCV3dtp90xBpZ2NQe3bxwVoXQwEo9yXGYSQrzsK6FrTtkQBYNoAKkQAIAgCfoAMGwZ+5OxNeKNuyErxMHLXNxL78l8oXYtQylyOMFLhKBlM+PXjFc0e+s0WXEIv9QqxhoRHVO5E2yIhmJZpPi1XpgXArg6ljOUSCMEvg5mE+Qy52Tl4tS15JrsxMWjLdstMV3xKDVbl4Vfw5eVWldtu+aamawJYwCMF6FwRBtxiS4xJFHDl2JcByA1TRxiJY3InHFfhyQA36BiJ21Ts0ENDhV27ZhydIP/NPUfygc6duw+5SCZqQQQv39zDMy7gwO53cMdwdv9AIBCuCDAn3md3p0BsZg0TwmP2h3L2vJWyPcjLB2xWd3xj3BbAVkNJgHtOo7dRSsCgqpRIFzKhRScxQmLk436XEvucYluPmWtkfqON+C57HXEFeSuLvzAwRxalu1QCpViWEctsTOM/mSADuKNJ6Vo9MQxHN0/zCzg0SLcoGkixaZamzeWggh4UsW3gJCiAJMfjr03yBmMAU5ugsAzJF+VQ1yhJG4/ms2WErLB2JlGk+moUa95PTfpy5cpa6Bkj/AHS3ZPt/N+T5mmNkfJtie/run079N8kPjlw7duSP5lH0dvuX/9DkBSNIG4HUwNdNSGHoQdOvamWXgiUHZoIOnfWSNSNCZJPb6fXohVwME/gi07a9tZn2xETO0iNPToiMkmo6MqAMNEgqJmBHugjX6nQ9j08XGAThOD/ESnw/KoFVK2C6xHb9RsVcg1Oi07cdrgdimWCQCSQT0vU5cZ5dseKLuRCAkH29yvZgfc0bjpExuECI9eiAZN3oys6n3a7fbr+YMSR+WCZ1J/z+nRMXRMMwnDEw8rNbKOJi35P6LEvzstceqy9sXBxyn6jMv2I4rx8feN9jQqlhJ6UpQgY65iLlg5xJwA5nIck4DjN0qm7cZJPcMxEbRLCFOujgfx/z6kAL0BUoqOaNrZoO0jSSdqHYVJlN2sQd0RqdT6QOiBPgnEQ6i/MV/A9YgJU7XX7yRATbLB/9IFepjSAfoZ6z9zH5c+ETVFWqhPkHMY+bwmRxwrZ7Kbqb8bKUgVsPmG5GrHu2qtjMGk94AiD1l7u9GdicAMCCCiZQPFJFqkHVQT2CmAoBggQRLf59ZUPjBzCSfaK8jJtFdQtvsfaoVfcxkRIYg7FCyNx0HVgapECLlIhbi/2O/aHwfkeF8H8o8n4XisrneJ47yvNxLPiQ/r8xfNRhcXlc0DQh5AeP1NZ+lDOyUm0mPascp9T73e7Kzu9tt7hj8yUBIjERFskgHLVn5ZlWLUQQCea23plIGq1qiiwgoJmu0U2DdCauRZYKyutjFmMkT15hGBqwLkex+x8lZDkHgsq/2rc8nH/c+rjncMnkPA8nghVZbUbIxa15ipkO0iwBMRkBEiGkw2nWbvIegS4FS2Ctl5dVUEgkg7jsJNtj1Lv2FVl94QdtZJ06y5cVb49yIrtVx795q0HyBipZPdO9iV0VgQZgmI7ggjLgmGSxo/dH94z9svA7eL4fJVfMPKRlcdxOy+xm4vCs3VcjzTqjK1C4tVnx1H2k3WrtEgzZ2W3G4uxjIfyo1P3B8z7nSmchiVp0bLbSxneLPdWNtNrOVG57Nye512judyAvP1U9MIZNUeHbt3oRyWF37iPKf/UXlI4RWNnFePYY43JqdVNF3I5tdl3Km1CSLEFRSll3O3sZQwkDrufpfYDbbM3zH+deOr+EUj9p8eVIzJ34LW55j45l+E89jZfF2ZeJiWXLyfj3IY2Q9eVx+RjXC5Eqy8axbMbkeMya1aq1CraKyndIXubVyO4tyEgDRpA4F+RyIxUEhpLjBdTf+2N/uO1/uY8fxvst94+Wx8f9wHi3FfLxnMWWVYlf3h8b42vY3MY6qqV/+ueGx0DclSuuWg/V1L/1Ur8O+s/pM9Fu/wC4bGJPSrkmIztSOESf2DhEnD4ScCbu3vaxoJ9fvW3T5meHM+/YFJUruKghktks3pDD0Mkx264AlWCtEP8AvKeUsfLfsP4fRayf27xnzPyi6uux/bZy/K8XxFDMFRfd8fAWEH13Np6deu/0t24Nrre5kAxnbh5CUj/4h5KKRAAGZWltbywE2AICGlmVdwXZUsOikyCCWHcNIBAPXqpgxomDjNeWyGeF2ynu2y8qqAu6mGK/6WkjcoMnpCES7mqOMh+bDJfPmLmE/KrMX+SwbiWKjcm0BC3tB10+mp6Ewap9yljc505r0LggUx8TAGLGKj4wFfcQOwDH3QNzE+vcdRmJqMRwR6olmoUQ2dIABezf74RgNoUQNoAUEqtg1iNf5dAIBixD8+3JOZEfEKrz+tI13soUEvqVgupcNBqkB6gAIkxI0nVvliWA7efFSi4wFV6GfWoOoUsw3bIVQCiSNqy8EsJj3T9THUUrZdH8zB+2C9DkCzaurEq272BhWrMd6/mV1ZRAHqAdJO49AbTMDgijKQDCThCPycOnuXYaw7NtZnVt6yD3VkDLPq2v106IWaEpfN5YLz/cG9LQSdxge51Ta0/GdsBydARIABE/SM2gcQn+c9MuSSs5DYoAtWLAbN49wCttIK7VDqocaE6kD6CA3ynyRC5m+KT/AFbfN8O+ndv+CN6/Hv3bf+vPxfl9d23drMadDpi2urY4Vbu/B8kvnB8a9vsqv//R5AE3AgCAY0JG6TEyCJmSOva8VmlkUgJB7y0bmnUf/h1lj69OEzZoqsz/AMpggemuug7n6ev8eiCJGV+7Ukad/UT6yCSToPqQOnT4IpGkiAurAbTpB7BTI0IkfXvPT4txTsjkiVBI9BqSSJHuBEjuewmD69E7Gj0TIhJ1M6HsTEToI0HukdjHRRAJcuyLxRlYbcCre5lgOGCqw/1rpoAfp66dEQxJTgDAGiORWYGz5EVQyCNwDlGJACoCC/5P4Ke8T0QLkVNe2KlHeiytlLlGADKY/MsKddd6OywIB0JBPY9LJ3oe2aINxQufxuJy2NZiZgBF9bIlqt76dxBW2kTCjcqnXQgEAQY6iv2be4gbdwGo8QixVI5/HZPG5N/DZwmATTYkhcqljK2VFgTDBdBrDSD265y5ZlZuS217w5jj27kgvHGcG92Q224LjqqlnZZt22N+UKTtL+366amI6ihtiZn1en2pEqx+Pw8bCRq8epUG0B2Zptuf3Ab3EtA0MRt9Bp1ejCEA0Q3bimxW4L9k2ZWnhXjqb9to4HyyCrVya084rZ9w2/IbEDoBtYT+J168++rokymWp8yH/pnw4qzawB5FZ+42WSNd3yWDWgWKu41/1FQsVKOilNs+4gQonUrweiv7oz7eftU8TxxV0/a/yL/05574Py1ligYXk3EfKa7EqqNN99eFkvWiuLCt+Nc/tIKamSACBlbq29u6QPyk/a3h4Ka2W0vQrcattnatmUEuDaogKA4BesHfG5O0DUERIPXPnlwVvvQnM85g+PcTyHN8tkphYHE4l+Zk5dw9ldNFb2WMLbU2AIFLaAkxpAU9NplIiMA8iaJjLSCStF33d+6/I/dfzrk/MMsXLh3EY3BYT3f0sHhMSzIGFjlbCK8bJyqv6tyqWYszDdt2x2G02I2tkWifW9TxJbzAwHhzUMZmR1Mqe5ryFOD4jk+ZzchUp4nEvzcgAOwsyKq4oprsDh1e+xlUJu2sXIYhtOtHb7Y7i/ZsW41mQB3HHy48uCcnSHBWuTMzsjkOQy+RzbTZlZ2bfl33M0i3IttOQ8kwWRGsJClRM/8Awj1CNuNq3Czbi0YxAA5YKEEkAnB0w+Q8Ri+ScRlcVm2GLK0sx71rXdg5dKBKcpCG+RWqtJDhfc6EgxO0PCUrUxMDPzCM+oM6xWw+T8r+3fl/G8zwfK8j4z5j4fzOJyvC85xORdx/I8Ty/G3Lk4PKcdlJtsrYModGiGRoYEFh1oXbdndWLlq7bjOxciRKJqCDiCFXOqMgQfUCuwH/AG8f3/8AB/vA8GPAeWWcfwX7gPCuNxz5t49TsxsXy3jaWox//wCoPimCoWMLMtZP7jiVBm47Kft8NtR6+fPq36Xv9A3Zu2QZdKuS9EsTE4/LlzH5T+YcwQtOzeFwVpMYhauv917y+zlf3YWcPVa99Phn208H4VTurPx35tfKeTZKuE+NVb/+aXcQigj6BRHqH9MtoLf01K+T6ru5uHwjpgP/AAobtZU4LWsMgtO4t8h2N7SFKL7m2lRAhxBH09Qe49BNsCoZkMZGIqUkMqbBuJiSUkRL7nICMu0ALoSO+hnQQBMCiPqqAvqZIVhuZo3Su7e2+CqEh23e/afcdY+s9MQcOITgkMEPdnD27gT67CW3EupUiPjc6swJ+p/zHQU+srw2aytobIOhdGgbVIlTtJ1LzHdjr2BI6D5bh3ClFzDXivX9wJmWeLH3BgQG9jBV/pyoVARJBP8Aj0Py27fanDfECyUbKKKq1srmK29hdioZAwrUmtB8gQ+7uJ7SOhbVU0PclqbEYIJ82yZL6Kq7fjIAEKANoABd2BJA+o+p6LRkyWs1Lry+cWKxZ9IYuQ0HsSPUEED0JIgdAYAOGxRCdRySD51h3MtsbSWc/wDlncr7gDEMY09WEeg6b5eIZPq4Lyc+1TK+9iZeYmTsEMxYkBTqDGh6E2wzZpxcLFD/ANw93dJjbsgztiY27p3RrP007adLQOBQ/NPHPgv/0uP1WjtuBH5tDrBiRAJER+Pfr2qNVnY5URlZUKI3bi075kEe6YQBmJmDM6R0fuSbkiUMmd3bU+380SPUiQe/8T0QRBuCLWBMiSdfxAg7hqJ1/hGuvROO5JqsyMrKgAlhqQ23QrOp3H2ncZP8PXpChRVJwRwaCW1QsS0Mq6aNqNBB1BB/8QeiPHJPpbEKT+KWeLVeQcRZ5th+QZ3h6ZtbeQ4fiebx3GeS5PG7GWyvhOR5bA5PjsTONhRla/HtrgEFZIIhv/qjYvx2dy3HdGPoMwZQEv3hExkR3EHBHFnAkDpz4psQ6NAIg7V9qTI1Icn2PqIPpp+PVp2YJMckcjArYCihm27bpZWUJKlBDfGVJYEkqSAojuZd3ONGRJZGDehBldGAG3apO4eiuzTr+ae+vUgIID4ohjhVFVFY3BYnTWdioQrANA9Y3enbt9GGVUeSbOc4jE5aiprxtycOwZGPaqy6BWHy0nQf08kjUDuxDD6GtvbFu9ATl8cS44jl48PFMR6S6rjilKpaZAPzfHIMe2tZP0CqC0ntr1iWnDk8UOakKWa/lAmAGWSNNZUbYYkHt9TP4iXjwSW2v9m9lNHiXiRN4XJv8c83ZamCt8qf+usF2X42Ac7WklpkgkSsA9cD9URlOV8t6Rch/wCme32FWLbMH4FZ74d5K49TWV1rUVZw9QC2hx867xLrWxueV2rukFpG3cvDyiHmQHPYe77s6zjAsVLKci5UxxWjfOiLar/KxY21M1ygqj17XWzcQC6zqQZKzQnEEkvR+32ZfapBRuK3ZeJeRVc/4t45z62BhzHB8ZyLfHZLF8zCx7bGSGJK13u0yVHqdYjjrsflzlGT+kkc6K8KgFasv9yL73/dBcDgftX9jeV8NXPuyX5j7i4/ki5rLl8Unx/2fhcVsXdj4y5eYj3XtYRvprSDFpB7H6R2HTbt2/verQumyPTbMf2vzSOZYMBzJ4KrfnJwIkMFpfzvvb+5jxIWt5D9leK5zFQOrcl43byWZjJX8gSUHF5fLwkptDPWGhtZBg+hR6P9PbmURY6rKE+EmBNP3gD4DwUInciQflv3KEcj+63/APqlhr4g3i9njWRkX05WTltzj8nXljAU2thVUtxmJbjzePliYPx7TJJPWlsvpyHTtwd1+o+Y0SANLM+buXYU9qXzhP0syZjmNtWutiEBco5lSUdNhgiwlRbJY7Z7D6k9aZiHdnRA0xQ6Zqy1QO8HdWApkKsBa1Ujs6ViTtmZ9TA6UoOASidUT92c3jr+R43HprU8nVj2vlX7vccS4ziY1ylVJvU72A/0oRA16msRLS/ZdBdkCwzSX2l8j+6P2y878X+5f2y5HN8T8v8AFOSo5TgudciutLkIW7GysK0N/c+K5ChmoycZ0erIpcowjUPu+mWeqbW9st3t9e2nFpA08QcQRiCKghFCNxxKAYrKr77fevl/v192fLPu75Fx+FxHLeX/ANivzuK467Iu4zDu4zgOL4W6rj78kDJXAezjvkpWyXRWCsWYFjL0PpEOhdJ2vSbdwzja1+oip1TlKvmyuk6iDmqnXKR7VrtvWiGtZWcWWBFWpzWoFCu4/UFdmikDdJAUE9aZjRwH7vx4Y/eUBrQlCW5Ke0V70AkTuVhCyYg7SNQQfQj6zIfTIjDBDqLuMEmMtTu3FzoGkANqIV2XQsEIPf1Ed/QTAsjjPUHOKRbKRvjIY7QWUl93tZlaQNVIKzEz6/TqPTIO2KXNeDkoBEjQmYUncCIBDAjsV01AJ7ep6XeEgWpmklzq0mVQkSv+nZqSNSRuPuEEnTYNZ06RtyIcItYOFCkmzlIgO3fTaGLNLaqpASddAO+np0GgjJP8xkLZmowjcC4USP8AVWrIVDf6YC7dCYBP+a0EVaiIyBC+HMRQyuzIYAYhY26CGYs6BgCPr3/DXptD1bBDqEaLz+thEVLGja1kKrbRDEKIJ9rGNIIM+vS0ckJnwKFfPM7ixBUKRtj5JaR+QyFBUesd9SRr03yhhpSN0lq4Ib+4p+X5DMRtgd47fT8usd4/8vT/AC6YZpay+S//0+PxJiD9dY0IiNT66k/zHXtEaOqCJQ6f4n8upHYMQ0RpP1/7ujGfFJFKSRE/gDrECDoSOwJPR80QLVdE1Fu0yO0QDH+oAyCJ/wC3bp0RzRS+5GrchwykFddpBgEA942aSIn6x0YoaYp1KvJPK/JPMeWs8g8t5rO57m7sLiONt5PkmS3KbA4DicLgOGxndK61arjeG43HxqdJFVSgz36r7babbZ2Rt9rYjbs6pERGDykZSPeZEk8yik8i5LlNlTNuA3DbBmRJ1MEgqBGnaNOrNcEyLDMRCgdogkTDCNpPtACjufX16J40DJ6eKLSx1WDu0I9QBuLRKKIAcx9Ppoe3ThuCICiIUboJBGgUzqN0x3BiA2o/9/Ru/uTtQVRwvZlqQ1VItFdkWVJXVdZvsd91tg917qW2qzTtQBB7QB0ogDUTH1H2UyyH3owksgsuNZtYn2qC20jcQwYRoWIMTpB3DQR1Hf8A9KY00/FKXwniq2rT4XyK2IIOVkNITsDadu4REkDsOsJjElxmfegRi2FWP5W2ltBppMQATr+Mad/SOpCaMktrH7TMitfEvCGe22tW8X+4CyrlVcjznjHsBZTKoUsG5iNvt/E9cT9QvL9Swf8Am2//AE5dgp7eEK8VnPx2bYpK0uy/G6BaA6lwy17rGLsxWyvYW1JYCZBAMLxkoAkmUXcY9vDIKYOHopZjZl8ilai4PwqKit7lQ43kOQpdWCO5klgqCJAIPVG7biXk7Y8O33nJSRllkthfhf364rwT9r2L5Jyd1Qz/AB1OW4GnARlF2Tl1ck/9rw6JcGts+nLqWshdFDuBCADmL3Tru56x+jsgvMgucgQ5J7q+5WRca2OK1Icv5byHlnO8p5Pzd9mXyXMZl+flwfb8rgMlNW8sK6MOsIlMONlSqAD367+G0htrFvb2QBbgGHbiavzdVzx5qB+feVN494Xy2Zjf/LX2Yp43AapSHGdmh8ZLKGDFgacax3DCTAkncZNzp2z/AFPULEJ1i+o9wqx7y1PsRE6YEjFam/MqMjxfy2nlsPbWmVdXzGKalKpXkq6frMdgY7uJKiNLOwPXpMWlAhqKnL0zdqK+8LkKOQxcTkcdi2Pl0pdWy2/1RUyAuloEkDe5Ux+Vl01B6pTizxzVqJxL0RYZC+/5E2IpRnYIhrVIdxtUykVH0O46ydTDCJkRGI9RI9qdiSGUMtowXzsnPrw8cZOXa9l171C3J1X46qi1ru9aJUqhVVgBED066KztrVmAAi8gMeeZHipxGMS4AdLnKYINxWANY3anVSQRtkqDprqDH06OUAcSpHeoKTbICk9kAmd5DyZM7gdBB/L3PcA+vUZgCKY96bXxKHXJEhQqqSQZ/wBRrBGwgjWBPcCZ6f5bVL6U9JcivP6jQhkDabZ9zHTX49svMkz3hh+HdEPgmYjFfEyNs7e+8Ea2IHJUbU2+4lhOn1E6mR0JiCfBCQDVfc3krss4ptrxq/0eLThVfDRRjmzHoFrK2QKKqhlZdgd991u65xG5zA6ijZjDVpkXlImpJx4OaDhEMBkEOqTtiE3te0HY4LERtLNKqSVU+0GVbbMgwdNAenMQccEQkDRI/rFULJ9xlfygTP5pIGyAZgHQg+nSNs4Bkxo7CqRsyHMKz2voK0QEnYK7CSN4PsSCfaJEk/TRBqu3ehch3C+X8zlviU8cbyMTGyMvMppVFFdeTl149OS/yqq3P8lOFTKlmVdgICkmRG3tC5K6I+uQAeuAcjliTk9avRP8wjNBPmgNqS6g7vcCRNZMCANe0j6n+MdObYLszpC4cHqh2y9wPuJX2ixiGZKt0AliCSAWIEmDOnbQxGJiQxS1A4iqFOW53Mzn3aEzKpuMkRO2AFOhkHp3w4pUySX6uvdu3mZ/Lt0jfu/+7+Haf8Oh1HDxTV8F/9Tj7SNdRMDdHbWCR/KO3aT17RVUBxRFf4mZjQ6wfrPtMA+v16MSNHCeiKTaIgnsZ0PoRER2IA6c96IAeKJUCImQTrJK6fQwQYBjow6MZIpCV3e4QxJBgnaNAQSFmNf4adOTgM07DxRQYkAD2kTthpde8g6zE/gfX006MOzukiEJAeN35jEgEhjr6HXQ6Tp0mNHxSAFKopTJ3biSDC7j7ViS4YxDACBr69ECSiYU4IusiWJ3AmY0JJV9qhYYa+0Qe41jp6jAsiHejUaVUg6LG1W1Bb3BjOpIKmBEafjJ6cEsAE4xXoWFiJIUkf6dDKgDax295GsmZ16OowLJwzJZxvqurEruRphTDHaSICkyAVH1179BISMJB8kUmIIVW80GTNNldltQtrR7ApIXcrFGI/KQSFE/j1z19xcoSAQog7c0CuVyCyPlW1RMq0E+2YaSIAH8de/UOq6KCThOwWV/2k+9vmniXjPG4fjtOGvJ8Iea4yi3NxGzcQ8XzWZh8vkfFjNfVUcm3NpVbGYwK61j6iG50/a7+MxuYmsgSxYuAQK8gTRHGRYAYqx8z78ffnlgz3eY3cdU9i2KOMxOKw1r2qyoo+LEfIUVqdAzTC9yV6G30Po1l22YJ5kn7c0bz7gmUch91/K7a6c/zbyrkf1Fir7+b5ezGaxmZ4VFyaRvbfJCKdCerQs9N2wJhs7UW/dj9yUROWazE+2v/qPxX7bYf2/yeUfOwD5Zyvm+TSzWt+p5blON4fiD8+97LcoYWBw5WtiWVPmsMag9cn1Ibbc9RnvhbafyhbBpSIMpU4OZd9ArUImLh6qeVZTtc6JtIsYVuCqn3srbhbXvlgiNK+1lDEggGG6zJwAgHele3Z/cnNGdUX97vIy1/CeP0XFacOs8rlBnDN8+WDTgC/cGYMlCMwX0FoYTu63OhbbTHcbqQ9UjpHcPibx9zILhoAAsWfOsBuV4O91WtsnCJzqWSSXRQDkoZVR/VSSAANUEDroogPRRyqGTH9t+bFuBk8PdcQ+DcuRiKpDO2NczC1EKq+5EyZYr/wDuT9R0NwOQQEVqRYh1P+S5ArQlNTEWXrvYdoRd2kQ0qzECZjQjvHVvp231XJ3pikaDv/sVmFa5JmF7yvaNokCQATtEqXIOonSQR27d9jTgipRIPlksBW4LsexVjpuCwQ0aKGJBmATOno2gBwRRIcikWtMn3IWIkja21SWke6SxOumgMajpjENgiYcapMXS0B131sZBA2ksZ79ioM/4AdAQ2IdJudUq9wDIUsN0Vp8hKbClhXayJWpAYq8+6dYnTt1HpBBcMO2aRIwKQbKKnVwdpFZABC+4bm02jSRB9exjpxE/s0KExfFCPlXGytUNZG+SGLKdmw/UwQxEdtY7gjpxGPDt27MmMWwXlsltdrLCsDJk6KVktH1BEfQfw6bTxBqmJCDsyGZW32IGBCoYhTMsgZtd0xEEaj/DpiAC4CFzHNCPktqA+30J94LhxEyACJMj+H8Om0u9EWrMpJ8u0j0LAaOB3gnaNo9p9wj1PQENJgEzglkK+RMFis9/oASZ3knUQAT/AA+vQ51imLHvSLWsTKuYJSW7gsJae4bbr/DtMgjpjpOITOcikWy2E+6FaCT3K7dWCiWAgkenboTEYMmcvikvlE7N4iN22NP+aI/PM+kz/wAOm0D9kJtRbFf/1ePivSFIjSQBHftCkALH4ev/AB9nBccyqLE5JeQRBMGApmAREKBHckR2H0/wIFqEo4gNgjVA01hTA3DWTpoYiQZ9OjeidGXpTXk31UXnJx67LEoylpsxxk1K8Jd8Fs3UixRO1vcswdekJSIDxY8MUXcvSt3BgQQ3pEdoYkGRBgfQ9SADFqp2wRCHSCfQKYgEfXuQBr3J7THTgkNwT+9HUWip2JSl5qesC3eBUbEKC6tUao/LSx3oSSu4AsGGnRtqGYr24+OfBP4VS6OIaWnYsjafpAhh+UKIMfSekQc8EgnFXw/0mv6n9ecoRDUjBGCKQfaZ/Ufrf1PYf9PYT/qHSe4JMw0aebu/kzeLoqNhVekuAEHsW9fRu0xBka6xJ79z0UccKOn8UsGHpOpAgEAKNon6LMn+HRuS4zThEVuCSrEMIAEHQDtEfxHpE9/4g5iSCFIGIYqtvIUFeRVoIVblA7kgWysn/V7WHaAe/WDvBplHx96gAYkZplR9qzPoCYDEkAnWQYkH694nqs/FPRXZ9sMHIy0sFLqGfIynKOSiiumjDhmbZ7kb5NQPcZiNep7Z0w1SwdPAclfHHcTjLZUlldmbexYrj7Ts3bQK2FQgOQE1n6d9COmuTJ1MWU0WGSv3xrjKsBa78hhZkkEQgJrwgERhTjvU9SlmkhtoVZgajUYm5umYIj8Pv71OBUHJT6jPZ1tZsgspYBVtIriu9nCWN8cFQIEIs6EzoJ6zpWxQCH9o7YlE7unJcx2UuLti1NXLGJ2rXZY0QFDABDB9FA7jQVzEUGnFIkMQByWIHkPP/wB/8g5Xly5NeVmWfpplmWiplro3bi8oMdVIgkAiCIA662xY+Rt7VlmMYh+/P2qvIuZFNVeSm4sCdYC79ZYHUlD7ds6ERBj6aCYxcJA0VL0U5Pjnm614dL21fqHeuuBFnGZkCwN70Brx0adxIG5APUdDonMiEQTLJKAPzPSrKys35rnt3aHRV36rXJVVrGjkwoYxP8fXrfsWvlWoWwMvbn7VeFABmkf1tQViQ+4GsVlWrFa7TYHNlZXuwPt1AmZnSJNMqcKpkn+oG0iSRrOiAElgIMoYOmo7H/ijE+KauCS/VBNwKb5X87M25XIU/KIZFZlr0gmDrpPTGBIoWLonPBCHJn6EmYMCZgklZJlgR+Ggn16cwFEn4lfFyyqHaB8ntKOWPsChg6gSa3ayRMgxt0ABJIG3mMEwPKqRbLLE7nLa7QdSR+UAAj+OmmgnpjFiGCTpI5Alf6g0I1n6AmNIkT+P8umoaJaqJM5QmJgGQfyzMHcQYjsP8pJ9ehNMkxrR0g2QrglwCoA9hUakEbIj2+2B6fTpnGCA0ovl2ZQ9OLTTifDk1HJOVl/PbY2cLbEbEDYtpNWKcWpWT262BpaI6iEZSnOUpPE4BsONcS+NcMkL0ZNtl/0/M0hnYECCBEqfbGh/gO3SIZ0OojBIWXMf9QIJO0MT29YmSOw76af4Capzc4oWzIH5pJJ+k+0Lu1Gv5TGsmO/QEJGYfmkmypAO4zIBH0J0JIaAdANZOgGvQkZhMSvnzGfWfy7dv4/l7x26B8s0z55r/9bj1QwAQCe0FW9fygQw7Egfh17GDgyqtUPVEo3/AJvcQPUjTsfcupiew/8AHqQMapNXFLrMkwSuh/L27aFTGqkdGCMsE6IRjpE6gwTH5gY7ax+H49FTxTgeaOxrkpsNlmPXlK1V9fxZD3LWGuosqTIUUXY7/Ji2OLUBbaXQb1ZZBepDRmY/24Z9sDmiHcvysdIkTBGnpEw0jWdOpE4S9bRECJ0KLHukg9zppP8APvp04PknRtbEgkNG4EHSAVj6TtYLr3Pft0TipSRAYQSNJI9u4TuB2jQsBugf4j6dJyaDFOz1S6PES0bfTuJInUyATr+P8+iJYFj7fNEOKKrcASZnTQaAgTAAGggen+XSEmbgnbgpFyfLcVm8P4zx+H41g8PyPD4nJY/N85jcjy+bleYZedy2Rn4fJchg5+Vdx3D28Vx1leBXXgJTVbVQLLFNrM3UFu3djc3N25upThMxMYaYgWwIgEAgPLUXkTIkglh6WUmqkfSxCqbyoEXVuJKl3bVQCd6Vn012SPx6zOoj1xJ4n2qCVJEFR7GTdZBkIBuf8ApAESQZP/f1nxqQmWQ32sawrYK61g25iiBLOxr4pQoJE7dkx9CPx1sgvCXDijisnOHxUw4stH/zryxZX3bB7SUQgIAQ4O5o/DTqtclrLD4FOKB1NMLJsrgmxqnlgQbGJggKVDAr/UIeBIEqDI0g0rsQaM6MliyesbMZaqymliFykGU3Kykl2AJVzP5fzEGFHVeUKycU7dvenJxTP5x5B/a/F+QfeEuz6lwMQ1lVsQ5Ve290G5TUy4+4iJ7SDoQC2W3+Zubb/DEufDD29uKlL04usZf1AbT+mv8AqIaNF3ESGYgLp3iYB9R10MqUVc4omu87twglRtkGA27doRJG5E7SNQfWB0xFCnBFE18ldW16PtT5EqSkuoUPtZ94UWDaxQAzBMbjOkdafT7ei0bmlzI+ztkrdoel8ygGtVDqw3EvuIQEye6rGjFfqI10/E364qUhJ/KJWWYLp3AG2NymQzCNU07zpHTZUxTVDVK8/PKxWdpOquy7iCK9okEkblUesfhPTMUgXRHIZ9GZl3XU4GLx1FprIwsNsr9LjtXUlbLS+Zk5eSwsasuQ9jwzmCFgCK3CcIxjK5KZGZZy/FgByoPamd8Am82BSNrHSJXaG/MDv9pBiSPy6ggdx0bFmIQ14USFlhr2MQ2503iVK7lDOC9RYr7AykCIGkE6aCXLs3bJLUkXuEGCpMiFIncNQR3Yge70HTEYuKJaqOkHuXUaiHEKyptDQwhQ0Rr2mD/PoZRzyTUqDgvJsZpQBnJUttAhtqIWMDSQiLMwO306ikdIqQyTkYIY3bYUCARLT3P4zJ7gfy6AydsEOrmhjYGY6nuRJOn5t2h+knWfX8ehdCZcSkTadNRBOoI0EaDTVRoCNPr02ojmEL5pJ72sIO78gCgiFXYo2+2IEwvczPcmT0yGhCQewGW3QCDIkACCJ3Tpt/hHTIS2KQ+VQAdxX2kQDt+sRrvED/DTXpi7FsUJ4g0Sfyjvp3idwmNveI7btJ+vr0GkcQ6Tn2L/1+PBSDoJBGhJJ1WSSJ3aiDHpI169iiXVYotbWFa1b1CK7WhSimwMwStjvVRayRWIUnaO4EknoqOO7t/anqaJZHMHvDaRqDtYiQ0EiCR2/Dt26kjQhin8Usrxu7kAEbjuiQY0B9I/xnqUEFk44FLB5Bj6d2M/znWIJ79PQIkurHaDOhEwG9IHoBI09I9Y6MZElJLhx6HsInXcARMaATPb6T09EsUdTTkXU5GQlbNRh/AMi0bR8L5DvVRuXfvY2OCBsBgjWOm1gShHVU4eH3Ig7FLVhwiWuj/FYXRHKsK7GrCfIqPG12qWxdwXUblmJHRCQJIevtHDsU/F0qHKHu4lYU66mNIBE6tr6AE9SasUg2SJFgUx8hEkaFSJQFu5EDfu0iB/3dR58EYFKpT5AdoXagJUEEAA6Q+v17CSdfXqSJeiegNCon5UGavHs9BZtn1n3g7joSSD1k9TFIFqFR3AAQyj+MBWrTAP5hpBg9h9ZHbt1mRiwFUKyR+zSgYt94lbmuz0WwfmFavw+4CdE19QVn6wOjqYsjiVf+PksdoG4pGjwAWdlVwGIP8A0xtMHvE/XoDHzUwwwT/jZT1qzMWrXaN42mytlFaMGQ/lMMgMatJgaCOoJQfTRHTwTrj5ZNYAgtZskSdkmwsd6siDehnaxMx/COoZQqeCRzVR/c7njfnYPDpbYa+ORs26syB+qzKxWhaSdKselRAkDeTpJ6v9PsiMLl1qyp4D8Sopn8rqtFyVaWFgU/6o1YkKNsbTu/if+/q5LEIQBVGVZGpIs2SSde8kkM0mQGgnv6fXt0DEkAZ4JCpACbP11yZJvx7DRbtuRHp3BtllT0WISY9r0WFW+oYz69bwtiNsWmeIAx5fjVaDsABghFtCwN0ADUmBIH5TptOk/Uz+PRFyXSdehZuS5ltqQVKpdXuRLLTZYtQ/TVud9zq1m5go9qyxgKSEZNpi1TyPDPh24pnyQvywhMmfaF9xB0kGfzBpUjWJ0Pr3cEh3TE0Zki2QxEAmTAmQVPtMboBkAk6ayf4dCSUJPKq8NkMNGcf6oO70j26kk/x179M7VKT80k2QTt1/KoKmZIE7lDDttBn00J6bUDQBAWQ5tJP5u7D8wHtJ9xgn6R9RI6EkVdJ+OCQsyRuEkEElgZgnRgZJYguR/kegMj4pnok2un27oIJLSNe0+hGgH+fQGpNUxKQ/Uabdw26gKSADEgSfQqx06Eg14JnqzLw166+8ahdfrGv5e5J0I/EdRkNQ4JnQpyBGkGCQIPoZMkgQCdP4/wDADUBC44pB7xopfsRBEMSIJg6lpDt69+llilRINe2jBhqAQRP8dupAOpB9CemdqIfchmyCWb3CToZMluxbWPTU/TptTYoTivHz+6IHb66RHftMxr/zdPqGDpUfBf/Q46wwB11kEg99CIn6HX/Lr11iyr0aqVVySZ1JgjXaNI/yIHUkTk1UTUS4sAIgkERpqFmTIOpnU/4dSP7E4wS6vpJgSYI1EDUSADGo9fXogWzT8EQjgL3juD/q0B3An2+h/wCx6lHqASqiQwExPYxqIg/jIEwCfrp0VRjinIOKWV9upb+A/D6xEz6/ge3RYp8uSXDdiPce8AgdxqBJ0IH+PSFDUJZpdLDABbTduC7m2pIWQolgCwAJjWf4dHqd6J82zS4f/m1ERMgjSDtIGkHcdR+GnTOwonZqjBKi3QmdDO0EFdDIiVMdjMfTogRWiIEvpXz5IGrFZIlhtkARoIMw695006ThsERCaOeX5cFGOvx3IVA7qCGAUaaRp1R6iAbMJDESUc3AiowtkAEnUnURqIAMegEdoiSO/WM9OajWQn2ls24V0A6tmNOpU/1sMEAFlHtFOpgntrp1Yg3yx3lFH2q9astxobfb8c7ZG5iyg2QrAgMYA3AQO35QehMWlhVTghmTvXkuJUGfbDMNxrZWXcWkwzgxpoJ10JPuhMQjBw8E5JmGlC139NKazbZY7gxUqyzGyDCipZgyTrHqREYglhmnLF6LHLleVfleRz+RsZmsysl7SdwkVgGuhVABVUWhVQCDA61IR0QjAZBVn1ElIjIBgnaADr7QNpIBYrIjRoidT6nv00siUl9uzCtLSw3spRCTLgWe0gDX8tbNOsTp6x1Y2tvXuIyOAr9ymsgagTkms5AKx/TBcAazuESYcGA35f59bGoEsVa1AheTcoA0B9w09CJ3aDusEev8Y16YyDUNUzijBItdPckDXSBuOuhjtqxPqI6HWExY5r4bxprA0j01AIE/8pJOkaevfXpApE5jBIvaFEkmJmO4ETAjWVJ+g7dC/OqGnBIfKxMpuYIu4hST7VBJYwCYVR3PYDoTIHEsm80m90T3gkges6SROknUT3nToaJE8qJBryQASARu1/MSAPazzCgkj016EkOSgd8Eg18AAkRub8gmDtII10UwfT/2dJ0ySa4f6dQpjbuVT+UR7va0fjr26aiXBINbpKjUNGsxu13aiZk6fxHp02KHAckO15LGe23a2okER6ganT6n+PTPXkkXLcEg14PcgiNPdH5mnUQWDR2Gv16ClQhNeDJH5p0loBkDXQiZBBjWe56D00d3TY50SLXgsYgiZO7QQJ7mSZ/znqMnFM/JItbBAUiSdR3IBEAeuoJ7/T6dAS5ZJs15+YfTWYiDtn/mjtMfy6bVV8ux7FJl/9HjkR/r30mO0ken1PXrUZcTVQMDR0sHkDaI1jQ6+sle8f8AbTqQHF0Tc0sjCROkFSRAgahvwIkj69SCRo6SWVvoSZBghddWgEmRMyPTosDTMJ0urs0xtgyd0EdjIJEQdR3nt1ICCHCdkurTqpn09o9YEie4M/z9Oj41KIJbcVX6mdv4xoRLQRAA+o/h0USfNLxSq2amNAT3PtjssT3MA/8Av6InLNPkiAw0E9wYhSTAGggayPrpJPTukK44JUW9ohew1gGYgCJnQa9p6fyT0qve9iJkxpru1+p9wgAa/Ud+k4YcE8aVXqY9T309dxCxunRiBP8AAdOWLNREC4wSGepswcitNWCBtABHxsGZR+Prr1W3cDPb3AA5x9tU0w8TSqiCuGhg24EQxU6HXQmJ0GvWECPiDMoBUVV9/a2yyvBYkFq2XI9sOw/+rO0hNpEzWdSZBHVq3/p0T4B3Vv1ZLbSAu1FPyAuC0wokkSWZ5BPoAJifU2DqUGgT3TcQCGLKBJDjcy+9gpJKLIGkySe0COoSHKIYCqaPLeXbD8ftRLP62e/6FYMkhmd8tisltpo0P4kQe8tbj/NcjCv3J5yYEKlkcroZkkzpEAiYZRI7nT+HVujO1VAMEulpC6CTuClp0gj3AknaxJ0mOlXgiSOZkAMlYJAhnZV/5iWhoUT+USNOx9B1obSIjCUyC5PuU9qNH4odMy1EvoSxkTIRUvrDMEvSu1LqxYANfjtqVonuJ6skAmMmBI7U8FLi6Ta0KVlpJOgH5VYQOxmSO/8Aw7aoyFaJdyRa46Fmj2xA92ssDPcA6dDq9yXMI/hcrhU5viLPJcflsvxtOVwLOdxeCysXA5vL4VMipuTx+Gzc7Ez8HD5W/DDrj220W012kM6Msgw3/nmxe/SygNzoOgyBMRNqGQBBMXZwCCRQEJNUan05oLNycJ8vJ/Q15FeC+VknBrzrK7cyvBa9/wBImZZj01025SYzILWVVrawEqADHRR16LfzG+YwdsHarPVnwD4Ypiz0QQybamJpd6y1T0u9djJupuU121PsYM1dlR2sv5WUwenIBHqD19uRCFih7L50J/5oOqkCY2gGRBn6+vS8UxPND2X+u5Dpt2sGg/6Qd0ET9df59+mJrzTE8MUM14kEmYJBEk7TH5YGi7ZMaf5dMSBU4pvJeTeTuRWCB4GqiSJDgAtuKgETII79CWTUqTgk2uiFESNPcCBMbYEk6SPQajpO6Zw4qh/lE6g9oknQe0a7o0BMGP8Aj0NEFMCh3tHtk+sKBBH11lZlYPYj/wAYyzmgTYJM2kiJE6nd/FtdAoGv49CTTFO6Qa0H6R+U7hJmJ1Mwv8eoyeBS7gkXtIAiTM+oknuB66gR9OozXOqVXXj9RrGv07abpj6/lj1/7tOgcYUSqv/S43lJGg7xoe3aO8yRHXqw5qLmnjhM5eO5fiuSfieP56rjM/D5K/g+Wx8zI4nmMfjrkzMjjuXpwcnCzbOKzaqTXkCq6mz4WbbYh9wa7E3LV22LsoSkCBKJGqLhtQcEOMQ4NRhknjlR0PkXrkZORkJRRiJkZF+QuLiK64uIt9j2jExltsutXGx1f46w7uwrUAsTJM8PTGEXdgKk1PM4CueSbPBeQQF17TAkGJOmoH/jOnUoJA5onRKWGU2iHkEMCZUiPcNPaJGnRRc4Yp2zSy2AGJjUkggCdRPb3A6f5/h1OC2KdKKQZkwWJIGmu3Qtr/pJMCfp/gndk9Kpbf2k9u8kz/EkaTqf4n/DotQyTjHklEcDSTroRHcgj/VIAA/7uiT6XCVDgwCdGA10YDt2n/u/j0TpwPJKfKxWtZJAJ2p6QxG4+nuaNSImP8FxTuTlRLK4H1/HvqPQA6EbRGvT+9IFeMu3bjZRJiMW6ToBARpgjQROn16ivyazdL4RPuTyNDXJVpW7pEM4mAGUxBGhPtGkfj/PrkASKvVVuYUu4PyLncGl6MDksnHr3bdlfxxtL/IRvKFlG9yx19erdm5c0kas0vFSceT8+ygWc3yTQYYjLuQT/qg1sg0+g9NOrWqTAmScE8UieW5C7W3kc19f9WZky0yNYt7bf+30aMiTUpOmzNz8zHyMa6rJuWytrH3Gxm9xFf5lsJWwEaGZnoJ3DGUSCkclLeH8kpzdtVzLRmEKoBJFVp13/Gx1Vj32mZOgn0sW70Z0lSXvTKUJZoTIAgggiNO/4EaaGY7dTFyWGaIEuGKYnyt9trsASzaSx/IGAEhAZOz0E6da8YaYxiMAFeDACIFF4TJ7sGCkjaZ2khSGVo3T3JiQAQOx6RHJMWyxT5h8/j4fj/OcG/AcHmZPM5nC5eP5Fm051vkPAJxB5Bsjj+Aur5GnAowufOeozVvxr3sGNUKnqh98E7Mp7jb3xuLkYwjIGAbRPUzGYIJeLHS0gA5cGjO4qGxzTA1oIOhB+sgxJn2wSO0/wE9TuXZN3L4bGKtYp9hZVJgwHKk6MQAVbaxH4fy6ajpq4JA3HQEnaCR6bQNVAGgB0HTceKXvSZtnuTIBn2947sRJLExp+HbpOzIavQpNrtIGpAMQQCJ1HaSZH/t6YmtUzlINcBMNqDJkiO/0PY+nTE5pF2debsqyz4hbY1i0J8FQJk10q9lgrU/6UFtjNHpuP1PQMHJAqS/jxQFImw+k6jSDAkA9vSSQCfQxPSfgU1XfAJFnZRLRqqsJJEDtpr3MHX1/DodQOCWKQa0knuDEjQ9/poNCCNP8+hMgCzpssEk134g+h9JJ7nuOzf4gdRmXApmonTL4bIxOD4XyBuR4S6jnMvmcLH43F5fEy+f49+DbArvu5zhKmObw+Fn/ANwT9DdaAuYK7DXPxN1WjuNV+/Z0TEoRiXMSIkSekZYSIb1AfC4fEIiPSJUr2wTAXgM0ADUQpnfJJmO7a+unRanzohOHNImwqPSGJk6ntBgwZkzP1n/DoCSKpsV43L9dYj8uu3bP1mI/l0Lh8fSm8Kr/0+NcEamZ7HSWEagdp069SBIYuomRVdjozNW7VsVZN1bFGK2Ia7FJUj2WVkqwJ1UwdOjEhmnX1W9PT0j6FfSO3+fRPV0kqrA/hGsawSPp9B/H/HqaMuOHvSHNKA7TqwYwDIbsD2XQ6Edo7z1I4xBDowHXsP6kyf4wNe8dpg9v49OLhHekyVR9Z0OoBg9x+EaHX6DqQSZjROA+CKF/9IVbUOxzZu2j5CWREZTaoLNUorkKTAYk9yekPio6diMMV9Fn1iNRIj6mCBr/AD0nqUEEMMUYDMyUVie0k/y7zG4n3GTPfXpwWelE5RKuQoHcFt2ok7m0ImCzAbdPT16JyK5pMXdkp8v+kj3Sxnc09tFgGIBnX1npxXNO1UJyFpGFlt7f/p7NGJiXVgO/qZ9eoN0RHa7g/uFDL4Sq+VhqZEnQDWZ7wRMTOuo65NQclIOLla7DPuLRPoPaDAI7Eg6yOrVnAnN0hUunVLJiNY1mToZIkTqZmfUz1YPwpIhLCNdPX6lpgH10JHY9NEsUkFyNhYUaRrZI+mq/WdGn/u6C5+VJim8NGsafj/wn/vEdRZJlMuF5rLtquxLnFypWBXa5ItXeSigt/wDmADtJkfiO2p08yuzaRDRqpLUXk/BH/KAT2A2/UyNNIAEFj2/Hrad65q0OKUqNl1q01VNbdY61111yzWWFvYirHcz+HQykIAyJYDNKq8C9SZkEFYA1ifrHeIMz/h0/BMTgvhuA9ZEGSRr3gkHSBJjpsEuC+fLpJI+g0MQSDEg7u/b+PTnvTEu/BJGwaxrBnST6H6aTH09OhoMqpnySTXKDG7UnRtNAe+gE9vp/4dCT5JnPmlLM26ymjFscNRifMMVQqL8f6mwXWqrhUdw9iggOzROkDodIcyzP2JO7VQrXCYntO7+Mjv2AMd/X/j06TBkg12ogz/zEk6nUj6emnQk8kq4Mvys9zhK9rMVsIDPWg21o1rnfa6VhvjrJAkbjoATAMc5iJrh25JsyhmtG0bSsGT/9kk7YMwZA1n+H8gMsQME2ZSbWyAI1BJZw0fmjao7bQPUx69C+CZ2q6Ha0SYE6gjU9zoSZA9O0n/LqIyxTE1DSovDPIYDQnuu0zBIAb+X4/U9IkNghJwSJsMNqfw9C38iR3H/b06iJxKR9iTa0n2yYAOsnse8qZgx6dBIhC/mk943bvbHaNY7/APh/OeheqTr/1ONL1HbdBie3p/y6R/2Pr16cNXpdBxZKjufpp27esfhP8NJnoxnq7BMlhu926YkfXvpt76xH16lOB1YJkoJ/4/8Af3j1/j04d6YJzglhOvbu/eJmTMfjHU8ddUQenBfl7fhtPb6QY7ev/f0g70Zk9KPilk3Qf8+8dj9Pw+nr+HRxd/Sn4JQbp9fWYjdED/Lb/OOpQ+WPtT5cl7Xd/LcJ77u3p6bvrOn+fRB6viiypgiqp/GfWO3b8Pwn/tHRBmP7SkGFUsJ9sTH4bo9NkTrumfw6MYpqL0vySO8R7YmO3tifb+bvPSOenFNJ8m5oHkv/AKHLjdHwnfEdtyxH+X4f59Vt6/6S/wANKafwnioWIkz29u2e0/j6xu+nXLhQVqnvAn4Xjdu+QTsnd6fTT809v9XVm0+muCYJy986d4WPzT3Pbb+H8upzlgnS679wjdu1jt3j3d/T+Gs9MGqkhOR3fHTM/ms3Ttn0+v4dRXHoySBHbX8fr2j/APuj/tHQ18UyeOH3/q3jbs+A7oj/AJq42f6Z39vw/n1odN1fqC2Gkv7FNZ+LwUjE7fdvmPWYjX806xPeNfr1u1ywU55LxrHujbp+b6QPzenfvPrPTVyxTF8sV5G6R+b/AOKd0z6zpPSrR0u/Fe/f/kO8xH4x+Mfh0qtRNlySZ3wJ2xDdtsbo0jd67u0f8elV+SWaT9+v1/1fm29m27p1n+P/AA6YvkkUk0xpumNJ7Tv9v4d57/8ACOhq3NKvgvjb5H5pjTv29Nv+qZ7dIZpDBJNPtie3t2z+EfjMz+PQ1euKZIPugdu/p/3R67o7dAXc8O3Ypd6Tado3bdstu2zMbfSdN09/TqM5cO3bzQ1cpMboPeJ13do9ZnSNvQnWxQnL9pJmdZ+p7bfp7ds+v/8Aj1HVz39uaVauvJ3bdf8AmMxPfWe3t3REx0JfNDwZIHuds7f5btsadtZ2/wAp6A4lvhTZ8mSRmP8AzzpE941/n1HJNmV4siTHbSI3fmj1nXt3/wDf0EsSyYskPX0nd/8Aj/8ACP5fz6Cvil7l/9k="

/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = "<div class=showPreview>\r\n    <div id=modal-preview-desktop class=\"modal preview-modal ng-scope ng-isolate-scope in\" style=\"\">\r\n        <div class=modal-dialog style=width:100%;max-width:100%;margin:0;height:100%;position:fixed>\r\n            <div class=modal-content uib-modal-transclude=\"\" style=width:100%;border-radius:0;height:100%>\r\n                <div class=\"modal-header row ng-scope\" style=\"border-bottom:1px solid #e5e5e5;background:#fff;padding:10px 24px!important\">\r\n                    <div class=\"col-lg-6 col-md-6\">\r\n                        <h3 class=ng-binding style=font-size:16px;margin:0;padding:0;line-height:38px;color:#505659;font-weight:700;float:left;font-style:normal>{language.wpanel.others.preview_mode.title}</h3>\r\n                        <div ng-model=conditions class=\"ng-pristine ng-untouched ng-valid ng-isolate-scope ng-not-empty\">\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-lg-6 col-md-6 text-right\">\r\n                        <div class=\"btn-group switch-preview ng-pristine ng-untouched ng-valid ng-not-empty active-desktop\" data-toggle=buttons ng-model=previewStyle ng-class=\"{'active-desktop': previewStyle==='desktop', 'active-mobile': previewStyle==='mobile'}\">\r\n                            <div class=\"pr-desktop click-active-preview\">\r\n                                <label class=\"preview-desktop ng-pristine ng-untouched ng-valid ng-binding ng-not-empty active\" ng-model=previewStyle uib-btn-radio=\"'desktop'\">\r\n                                    <i class={builder-icon-laptop}></i>\r\n                                    {language.wpanel.others.desktop.title}\r\n                                </label>\r\n                            </div>\r\n                            <div class=\"pr-mobile click-active-preview\">\r\n                                <label class=\"preview-mobile ng-pristine ng-untouched ng-valid ng-binding ng-not-empty\" ng-model=previewStyle uib-btn-radio=\"'mobile'\">\r\n                                    <i class={builder-icon-mobile}></i>\r\n                                    {language.wpanel.others.mobile.title}\r\n                                </label>\r\n                            </div>\r\n                            <div class=switch-preview__active></div>\r\n                        </div>\r\n                        <button type=button class=\"btn btn-primary close-preview\" ng-click=cancel()><i class={builder-icon-times-circle}></i></button>\r\n                    </div>\r\n                </div>\r\n                <!--modal load content desktop-->\r\n                <div class=\"modal-body-preview ng-scope\" style=\"\">\r\n                    <div class=\"desktop ng-not-empty\" style=\"\">\r\n                        <div ng-transclude=\"\" mailup-common-scrollbar=\"\" class=ng-isolate-scope style=height:100%;width:100%;position:relative>\r\n                            <div class=\"containter-preview ng-scope mailup-common-scrollable-container ps-container ps-theme-default ps-active-y\" style=width:100%;overflow-y:auto>\r\n                                <iframe id=previewIframeDesktop src=\"\" scrolling=no onload='this.style.height=this.contentDocument.body.scrollHeight+\"px\"' style=\"width:100%;margin:0 auto;border:none\">\r\n\r\n                                </iframe>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <!--modal load content mobile-->\r\n                <div class=\"modal-body-preview-mobile ng-scope bananaphone\" style=\"\">\r\n                    <div class=\"mobile ng-not-empty-mobile\" style=\"\">\r\n                        <div ng-transclude=\"\" mailup-common-scrollbar=\"\" class=ng-isolate-scope style=height:100%;width:100%;position:relative>\r\n                            <div class=\"containter-preview ng-scope mailup-common-scrollable-container ps-container ps-theme-default ps-active-y\" style=width:100%;overflow-y:auto>\r\n                                <iframe id=previewIframeMobile src=\"\" scrolling=no onload='this.style.height=this.contentDocument.body.scrollHeight+\"px\"' style=\"width:100%;margin:0 auto;border:none;height:2000px\">\r\n\r\n                                </iframe>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=modal-bg-preview-desktop class=\"modal-backdrop ng-scope in\" style=z-index:1040;background-color:#000085></div>\r\n</div>\r\n\r\n<div class=modal id=builderModal>\r\n    <div class=default-popup>\r\n        <div class=\"modal-dialog modal-lg\">\r\n            <div class=modal-content>\r\n                <!-- Modal Header -->\r\n                <div class=\"modal-header text-center\">\r\n                    <h4 class=\"modal-title w-100\" id=popupTitle>{language.wpanel.others.change_image.title}</h4>\r\n                    <button type=button class=\"close PopUpCloseButton\" data-dismiss=modal>&times;</button>\r\n                </div>\r\n    \r\n                <!-- Modal body -->\r\n                <div class=\"modal-body PopUpContent\">\r\n                    {language.wpanel.others.loading.title}\r\n                </div>\r\n            </div>\r\n        </div>    \r\n    </div>\r\n    <div class=right-popup>\r\n        <div class=right-box>\r\n            <div class=show-box-popup>\r\n                <ul class=box-mode>\r\n                    <li id=box-mode-mobile class=\"box-mode-mobile box-device\" title=Mobile data-mode=mode-mobile>\r\n                        <div class=group>\r\n                            <span class=\"material-icons-outlined icon\">smartphone</span>\r\n                            <span>{language.wpanel.others.mobile.title}</span>\r\n                        </div>\r\n                        <ul class=\"group-device group-mobile\">\r\n                            <li class=\"device-screen _320\">{language.wpanel.others.mobile.320.title}</li>\r\n                            <li class=\"device-screen _360\">{language.wpanel.others.mobile.360.title}</li>\r\n                            <li class=\"device-screen _375\">{language.wpanel.others.mobile.375.title}</li>\r\n                            <li class=\"device-screen _414\">{language.wpanel.others.mobile.414.title}</li>\r\n                        </ul>\r\n                    </li>\r\n                    <li id=box-mode-tablet class=\"box-mode-tablet box-device\" title=Tablet data-mode=mode-tablet>\r\n                        <div class=group>\r\n                            <span class=\"material-icons-outlined icon\">tablet_android</span>\r\n                            <span>{language.wpanel.others.tablet.title}</span>\r\n                        </div>\r\n                        <ul class=\"group-device group-tablet\">\r\n                            <li class=\"device-screen _768\">{language.wpanel.others.tablet.768.title}</li>\r\n                            <li class=\"device-screen _1024\">{language.wpanel.others.tablet.1024.title}</li>\r\n                        </ul>\r\n                    </li>\r\n                    <li id=box-mode-desktop class=\"box-mode-desktop box-device background-active active\" title=Desktop data-mode=mode-desktop> \r\n                        <div class=group>\r\n                            <span class=\"material-icons-outlined icon\">computer</span>\r\n                            <span>{language.wpanel.others.desktop.title}</span>\r\n                        </div>\r\n                        <ul class=\"group-device group-desktop\">\r\n                            <li class=\"device-screen _1280\">{language.wpanel.others.desktop.1280.title}</li>\r\n                            <li class=\"device-screen _1360\">{language.wpanel.others.desktop.1360.title}</li>\r\n                            <li class=\"device-screen _1920\">{language.wpanel.others.desktop.1920.title}</li>\r\n                        </ul>\r\n                    </li>\r\n                    <li id=background-option class=\"change-background device\" title=\"Change background\">\r\n                        <div class=group>\r\n                            <span class=\"material-icons-outlined icon\">wallpaper</span>\r\n                            <span>{language.wpanel.others.background.title}</span>\r\n                        </div>\r\n                        <ul class=\"group-background builder-backgrounds\">\r\n                            \r\n                        </ul>\r\n                    </li>\r\n                </ul>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<!-- The Image Toolbox -->\r\n<div class=modal id=ImageToolbox>\r\n    <div class=container>\r\n        <!-- Nav tabs -->\r\n        <ul class=\"nav nav-tabs\">\r\n            <li class=nav-item>\r\n                <a class=\"home nav-link active nav-tab\" data-toggle=tab href=#home>{language.wpanel.others.upload.title}</a>\r\n            </li>\r\n            <li class=nav-item>\r\n                <a class=\"menu1 nav-link nav-tab\" data-toggle=tab href=#menu1>{language.wpanel.others.url.title}</a>\r\n            </li>\r\n            <li class=nav-item>\r\n                <a class=\"menu2 nav-link nav-tab\" data-toggle=tab href=#menu2>{language.wpanel.others.base64.title}</a>\r\n            </li>\r\n            <li class=\"nav-item filemanager-item\">\r\n                <a class=\"menu3 nav-link nav-tab\" data-toggle=tab href=#menu3>{language.wpanel.others.filemanager.title}</a>\r\n            </li>\r\n        </ul>\r\n\r\n        <!-- Tab panes -->\r\n        <div class=tab-content>\r\n            <div id=home class=\"container tab-pane active nav-content active\">\r\n                <p class=\"margin-bottom--lv4 py-2\">{language.wpanel.others.des_upload_image.title}</p>\r\n                <label class=mb-2>{language.wpanel.others.file.title}</label>\r\n                <input type=file name=file_upload_image class=file-upload-image multiple=\"\" accept=image/*>\r\n                <p class=file-upload-input-title><i class={builder-icon-arrow-to-bottom} style=display:block;position:absolute;top:33px;left:50%;z-index:2;font-size:30px;color:#267e88;transform:translateX(-50%)></i><span class=des-upload>{language.wpanel.others.des_drag_image.title}</span></p>\r\n                <div class=\"text-center mt-3\"><button tabindex=0 type=\"\" class=\"buttonSaveUpload btn btn-default\">{language.wpanel.others.upload.title}</button></div>\r\n            </div>\r\n            <div id=menu1 class=\"container tab-pane fade nav-content\">\r\n                <p class=\"margin-bottom--lv4 py-2\">{language.wpanel.others.des_url_image.title}</p>\r\n                <label class=mb-2>{language.wpanel.others.url.title}</label>\r\n                <input placeholder=https://sample.com/images/example.png type=text name=url_image class=url-image>\r\n                <div class=text-center>\r\n                    <button tabindex=0 type=\"\" class=\"buttonSaveUrl btn btn-default\">{language.wpanel.others.save.title}</button>\r\n                </div>\r\n            </div>\r\n            <div id=menu2 class=\"container tab-pane fade nav-content\">\r\n                <p class=\"margin-bottom--lv4 py-2\">{language.wpanel.others.des_base64_image.title}</p>\r\n                <label class=mb-2>{language.wpanel.others.base64.title}</label>\r\n                <textarea rows=5 placeholder=data:image/png;base64,iVBORw0KGgoAAAANSUh.... name=base64_image class=base64-image></textarea>\r\n                <div class=\"text-center mt-3\">\r\n                    <button tabindex=0 type=\"\" class=\"buttonSaveBase64 btn btn-default\">{language.wpanel.others.save.title}</button>\r\n                </div>\r\n            </div>\r\n            <div id=menu3 class=\"container tab-pane fade nav-content filemanager-item\" style=margin-bottom:-42px>\r\n                <iframe style=\"height:calc(100vh - 255px);width:100%;border:solid 1px #ddd\" class=filemanager-iframe></iframe>\r\n                <div class=\"mt-3 text-center\">\r\n                    <a href=javascript:; class=\"btn btn-primary mr-1 filemanager-ok\">{language.wpanel.others.filemanager.ok}</a>\r\n                    <a href=javascript:; class=\"btn btn-secondary filemanager-cancel\">{language.wpanel.others.filemanager.cancel}</a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=modal id=VideoToolbox>\r\n    <div class=container>\r\n        <!-- Nav tabs -->\r\n        <ul class=\"nav nav-tabs\">\r\n            <li class=nav-item>\r\n                <a class=\"home nav-link active nav-tab\" data-toggle=tab href=#home>{language.wpanel.others.upload.title}</a>\r\n            </li>\r\n            <li class=nav-item>\r\n                <a class=\"menu1 nav-link nav-tab\" data-toggle=tab href=#menu1>{language.wpanel.others.url.title}</a>\r\n            </li>\r\n        </ul>\r\n\r\n        <!-- Tab panes -->\r\n        <div class=tab-content>\r\n            <div id=home class=\"container tab-pane active nav-content\">\r\n                <p class=\"margin-bottom--lv4 py-2\">{language.wpanel.others.des_upload_video.title}</p>\r\n                <label>{language.wpanel.others.file.title}</label>\r\n                <input type=file name=file_upload_video class=file-upload-video multiple=\"\" accept=video/*>\r\n                <p class=file-upload-input-title><i class={builder-icon-arrow-to-bottom} style=display:block;position:absolute;top:25px;left:50%;z-index:2;font-size:30px;color:#267e88;transform:translateX(-50%)></i><span class=des-upload>Drag your files here or click in this area.</span></p>\r\n                <button tabindex=0 type=\"\" class=\"buttonSaveUpload btn btn-default\">{language.wpanel.others.upload.title}</button>\r\n            </div>\r\n            <div id=menu1 class=\"container tab-pane fade nav-content\">\r\n                <p class=\"margin-bottom--lv4 py-2\">{language.wpanel.others.des_url_video.title}</p>\r\n                <label>{language.wpanel.others.url.title}</label>\r\n                <input type=text name=url_video class=url-video>\r\n                <button tabindex=0 type=\"\" class=\"buttonSaveUrl btn btn-default\">{language.wpanel.others.save.title}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<!-- The Image Toolbox -->\r\n<div class=modal id=WidgetNameToolbox>\r\n    <div class=container style=\"padding:0 60px 30px\">\r\n        <div class=form-group>\r\n            <!--<p class=\"title-widget\">Name your custom widget</p>-->\r\n            <p class=margin-bottom--lv4>{language.wpanel.others.des_widget_name.title}</p>\r\n            <input type=text class=form-control value=\"My Custom Widget\" id=CustomWidgetName aria-describedby=\"\" placeholder=\"Enter widget name\">\r\n        </div>\r\n        <button type=submit id=buttonCustomWidget class=\"btn btn-primary btn-add-custom-widget-[ID]\">{language.wpanel.others.add.title}</button>\r\n    </div>\r\n</div>\r\n\r\n<!-- The Template Toolbox -->\r\n<div class=modal id=templateToolbox>\r\n    <div class=container style=margin-top:-8px>\r\n        <!-- Tab panes -->\r\n        <div class=tab-content>\r\n            <div id=home class=\"container tab-pane active nav-content\">\r\n                <p class=\"margin-bottom--lv4 py-2\">{language.wpanel.others.des_template_toolbox.title}</p>\r\n            </div>\r\n        </div>\r\n        <div class=\"new-templates unit size1of1 tab-container\" style=margin-top:30px>\r\n            <!--noi hien thi danh sach template-->\r\n            <ul class=\"c-templateSelection list-new-template\" style=justify-content:left;padding-left:0>\r\n\r\n            </ul>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<!--The modal help builder-->\r\n<div class=\"helpPopUp front-door c-interstitial position--relative topsliderpane-base\" style=display:none;z-index:999>\r\n    <div class=\"flex justify-content--center position--fixed top-bottom--0 left-right--0 align-items--flex-start\">\r\n        <div class=\"bg-white border-radius--lv1 bg-popup\" style=\"\">\r\n            <div id=header-modal class=\"full-width textcolor zin-lv2 position--static selfclear\" data-dojo-attach-point=topBarActions>\r\n                <div class=\"flex flex-between\">\r\n                    <ul class=\"close-overlay close-right absolute cursor-pointer\">\r\n                        <li class=noborder>\r\n                            <a href=javascript: data-dojo-attach-point=closeLink class=\"helpPopUpCloseButton closeLink c-interstitial_button nolink\" tabindex=0>\r\n                                <i class={builder-icon-times}></i>\r\n                            </a>\r\n                        </li>\r\n                    </ul>\r\n                </div>\r\n            </div>\r\n            <div data-dojo-attach-point=content class=\"helpPopUpContent position--static flex justify-content--center overflow--auto margin--lv0\" style=\"\">\r\n                <!--load content list acticle-->\r\n                <iframe id=iframeLoad class=\"\" src=\"\"></iframe>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<!--The modal upload template by builder-->\r\n<div class=modal id=uploadTemplate>\r\n    <div class=container style=\"padding:0 60px 30px\">\r\n        <form class=form-upload action=upload.php enctype=multipart/form-data>\r\n            <div class=form-group>\r\n                <p class=margin-bottom--lv4>{language.wpanel.others.des_upload_template.title}</p>\r\n                <div data-dojo-attach-point=formInputs>\r\n                    <fieldset class=field-wrapper id=dijit__TemplatedMixin_43 widgetid=dijit__TemplatedMixin_43>\r\n                        <label>File</label>\r\n                        <div class=\"input-group file-upload\" id=drag-file-upload style=width:100%;height:auto>\r\n                            <input type=file name=file class=file-upload-template multiple=\"\" style=width:100%;height:150px;position:relative;opacity:0;z-index:4>\r\n                            <p class=file-upload-input-title style=\"position:absolute;top:0;left:50%;z-index:3;transform:translateX(-50%);width:100%;height:100%;border:1px dashed #007c89;background:#e5f7ff;display:flex;justify-content:center;align-items:center\">\r\n                                <span class=\"material-icons-outlined icon\" style=font-size:40px;margin-top:-30px;color:rgba(0,0,0,.4)>upload</span>\r\n                                <span class=des-upload style=position:absolute;top:80px;left:50%;transform:translateX(-50%);white-space:nowrap>Drag your files here or click in this area.</span>\r\n                            </p>\r\n                        </div>              \r\n                    </fieldset>\r\n                </div>\r\n            </div>\r\n            <button type=submit id=buttonUploadTemplate class=\"btn btn-primary btn-upload-template-[ID]\" style=position:relative;top:0;left:50%;z-index:2;transform:translateX(-50%);background:gray;outline:0;border:none>Upload</button>\r\n        </form>\r\n    </div>\r\n</div>\r\n\r\n<div style=display:none>\r\n    <div class=\"builder-tool builder-outline-selected-controls\">\r\n        <ul>\r\n            <li class=\"builder-action-selected-button builder-select-parent-button\" data-toggle=tooltip title={language.wpanel.others.select_parent.title}>\r\n                <span class=material-icons-outlined style=font-size:22px>arrow_upward</span>\r\n            </li>\r\n            <!-- <li class=\"builder-action-selected-button builder-add-widget-button\" data-toggle=\"tooltip\" title=\"{language.wpanel.others.add_widget.title}\"><i class=\"{builder-icon-layer-plus}\"></i></li> -->\r\n            <li class=\"builder-action-selected-button builder-remove-selected-button\" data-toggle=tooltip title={language.wpanel.others.delete.title}>\r\n                <span class=material-icons-outlined style=font-size:22px>delete</span>\r\n            </li>\r\n            <li class=\"builder-action-selected-button builder-duplicate-selected-button\" data-toggle=tooltip title={language.wpanel.others.duplicate.title}>\r\n                <span class=material-icons-outlined style=font-size:17px>filter_none</span>\r\n            </li>\r\n            <li class=\"builder-action-selected-button builder-code-selected-button\" data-toggle=tooltip title={language.wpanel.others.code.title}>\r\n                <span class=material-icons-outlined style=font-size:22px>code</span>\r\n            </li>\r\n        </ul>\r\n    </div>\r\n\r\n    <div class=\"builder-tool builder-outline-move-hook\" title={language.wpanel.others.move.title}>\r\n        <span class=material-icons-outlined style=\"font-size:18px;margin:7px 6px;transform:rotate(45deg)\">zoom_out_map</span>\r\n    </div>\r\n</div>\r\n\r\n<!--loading-->\r\n<div class=loadding-indicator style=display:none;z-index:999>\r\n    <div id=spinningSquaresG>\r\n        <div id=spinningSquaresG_1 class=spinningSquaresG></div>\r\n        <div id=spinningSquaresG_2 class=spinningSquaresG></div>\r\n        <div id=spinningSquaresG_3 class=spinningSquaresG></div>\r\n        <div id=spinningSquaresG_4 class=spinningSquaresG></div>\r\n        <div id=spinningSquaresG_5 class=spinningSquaresG></div>\r\n        <div id=spinningSquaresG_6 class=spinningSquaresG></div>\r\n        <div id=spinningSquaresG_7 class=spinningSquaresG></div>\r\n        <div id=spinningSquaresG_8 class=spinningSquaresG></div>\r\n    </div>\r\n</div>\r\n\r\n<!-- The Image Toolbox -->\r\n<div class=modal id=EditHtmlModal>\r\n    <div class=mb-4>\r\n        <h2 class=mb-2>{language.edit_html_code}</h2>\r\n        \r\n        <textarea id=EditHtml></textarea>\r\n        \r\n        <button tabindex=0 type=\"\" class=\"btn btn-secondary edit-html-save-button\">Save</button>\r\n    </div>\r\n</div>";

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = "<div style=display:none>\r\n     <!--ButtonControl-->\r\n     <div id=ButtonControl>\r\n        <div class=\"widget-section font-family pr-3 control-[ID]\" style=position:relative>\r\n            <div class=label>[TITLE]</div>\r\n            <div class=button-styles-select>\r\n                <button class=button-preview>Abc</button>\r\n                <div class=button_styles style=display:none>\r\n                    <div style=display:flex;justify-content:space-between>\r\n                        <button class=\"\" data-style=style_1>Abc</button>\r\n                        <button class=\"\" data-style=style_2>Abc</button>\r\n                        <button class=\"\" data-style=style_3>Abc</button>\r\n                        <button class=\"\" data-style=style_4>Abc</button>\r\n                        <button class=\"\" data-style=style_5>Abc</button>\r\n                        <button class=\"\" data-style=style_6>Abc</button>\r\n                        <button class=\"\" data-style=style_7>Abc</button>\r\n                    </div>\r\n                    <div style=display:flex;justify-content:space-between>\r\n                        <button class=\"\" data-style=style_8>Abc</button>\r\n                        <button class=\"\" data-style=style_9>Abc</button>\r\n                        <button class=\"\" data-style=style_10>Abc</button>\r\n                        <button class=\"\" data-style=style_11>Abc</button>\r\n                        <button class=\"\" data-style=style_12>Abc</button>\r\n                        <button class=\"\" data-style=style_13>Abc</button>\r\n                        <button class=\"\" data-style=style_14>Abc</button>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--YoutubeControl-->\r\n    <div id=YoutubeControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget-row px-3 py-2\">\r\n                <h4>{language.youtube}</h4>\r\n                <p class=mb-2>{language.youtube.enter_youtube_url}</p>\r\n                <div class=place-value>\r\n                    <span class=\"\">\r\n                        <input type=text class=youtube_url value=[CODE] style=width:100% />\r\n                    </span>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-row px-3 py-2 d-flex align-items-center\">\r\n                <div class=\"label mr-auto\">{language.youtube.width}</div>\r\n                <div class=place-value>\r\n                    <span class=\"\">\r\n                        <input type=text class=youtube_width value=[WIDTH] />\r\n                    </span>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-row px-3 py-2 d-flex align-items-center\">\r\n                <div class=\"label mr-auto\">{language.youtube.height}</div>\r\n                <div class=place-value>\r\n                    <span class=\"\">\r\n                        <input type=text class=youtube_height value=[HEIGHT] />\r\n                    </span>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-row px-3 py-2 d-flex align-items-center\">\r\n                <div class=\"label mr-auto\">{language.youtube.alignment}</div>\r\n                <div class=place-value>\r\n                    <span class=\"\">\r\n                        <select class=\"form-control alignment\">\r\n                            <option value=\"\">{language.youtube.default}</option>\r\n                            <option value=left>{language.youtube.left}</option>\r\n                            <option value=right>{language.youtube.right}</option>\r\n                            <option value=center>{language.youtube.center}</option>\r\n                        </select>\r\n                    </span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--TableBlockControl-->\r\n    <div id=TableBlockControl>\r\n        <div class=\"widget-section font-family pr-3 control-[ID]\">\r\n            <div class=label>[TITLE]</div>\r\n            <select class=\"form-control theme\">\r\n                <option value=\"\">Default</option>\r\n                <option value=table-striped>Striped</option>\r\n                <option value=table-dark>Dark</option>\r\n                <option value=\"table-dark table-striped\">Dark - Striped</option>\r\n                <option value=table-bordered>Bordered</option>\r\n                <option value=\"table-dark table-bordered\">Dark - Bordered</option>\r\n            </select>\r\n        </div>\r\n    </div>\r\n\r\n    <!--PricingTableControl-->\r\n    <div id=PricingTableControl>\r\n        <div class=\"widget-section font-family pr-3 control-[ID]\" style=position:relative>\r\n            <div class=label>[TITLE]</div>\r\n            <div class=pricing-styles-select>\r\n                <button class=pricing-preview>Abc</button>\r\n                <div class=pricing_styles style=display:none>\r\n                    <div style=display:flex;justify-content:space-between>\r\n                        <button class=\"\" data-style=\"\">Abc</button>\r\n                        <button class=\"\" data-style=dark>Abc</button>\r\n                        <button class=\"\" data-style=light>Abc</button>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    \r\n    <!--Background Image Control-->\r\n    <div id=BackgroundImageControl>\r\n        <div class=control-[ID]>\r\n            <div class=atts-groupx>\r\n                <div class=atts-group-containerx>\r\n                    <div class=\"widget-row px-3 py-2\">\r\n                        <div class=\"d-flex align-items-center\">\r\n                            <div class=\"label mr-auto\">\r\n                                {language.background_image.image}\r\n                            </div>\r\n                            <div class=\"btn-group mr-2\" role=group aria-label=\"Basic example\">\r\n                                <button class=\"btn btn-default btn-icon change-image\"><span class=material-icons-outlined>create</span></button>\r\n                                <button class=\"btn btn-danger btn-icon clear-image\"><span class=material-icons-outlined>clear</span></button>\r\n                            </div>\r\n                            <div class=\"\">\r\n                                <div class=background-image-preview>\r\n                                    <img class=background-image src=" + __webpack_require__(210) + " />\r\n                                </div>\r\n                            </div>                    \r\n                        </div>\r\n                    </div>\r\n                    <div class=\"widget-row px-3 py-2 d-flex align-items-center\">\r\n                        <div class=\"label mr-auto\">{language.background_image.color}</div>\r\n                        <div class=place-value>\r\n                            <span class=color-picker>\r\n                                <input type=color class=background-color value=#ffffff />\r\n                                <input class=background-color type=text value=\"\"/>\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"widget-row px-3 py-2 d-flex align-items-center\">\r\n                        <div class=\"label mr-auto\">{language.background_image.repeat}</div>\r\n                        <div class=place-value>\r\n                            <select class=\"background-repeat form-control enctype\">\r\n                                <option value=inherit>inherit</option>\r\n                                <option value=initial>initial</option>\r\n                                <option value=no-repeat>no-repeat</option>\r\n                                <option value=repeat>repeat</option>\r\n                                <option value=repeat-x>repeat-x</option>\r\n                                <option value=repeat-y>repeat-y</option>\r\n                                <option value=revert>revert</option>\r\n                                <option value=round>round</option>\r\n                                <option value=space>space</option>\r\n                            </select>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"widget-row px-3 py-2 d-flex align-items-center\">\r\n                        <div class=\"label mr-auto\">{language.background_image.size}</div>\r\n                        <div class=place-value>\r\n                            <input type=text value=100 class=\"form-control background-size\"/>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"widget-row px-3 py-2 d-flex align-items-center\">\r\n                        <div class=\"label mr-auto\">{language.background_image.position}</div>\r\n                        <div class=place-value>\r\n                            <input type=text value=100 class=\"form-control background-position\"/>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Image link Control-->\r\n    <div id=FieldListHeaderControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget-section link-image\">\r\n                <div class=p-3>\r\n                    <p class=\"d-block mb-2\">\r\n                        This is an <strong>[TITLE]</strong> field is associated with the following mail list\r\n                    </p>\r\n                    <div class=form-disabled>\r\n                        <select class=\"form-control disabled\" disabled=disabled>\r\n                            <option>[LIST_NAME]</option>\r\n                        </select>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Image link Control-->\r\n    <div id=ImageLinkControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget-section link-image\">\r\n                <div class=\"wg-info w-url-container d-flex align-items-center\">\r\n                    <div class=tren>\r\n                         <div class=trai>\r\n                            <span>{language.image_link}</span>\r\n                         </div>\r\n                    </div>\r\n                    <div class=pr-3>\r\n                        <input type=text class=\"image-link link\" value=\"\">\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Image size Control-->\r\n    <div id=ImageSizeControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget-section d-flex align-items-center pr-3\">\r\n                <div class=\"label mr-auto\">[TITLE]</div>\r\n                <select class=\"image-sizes form-control\">\r\n                    <option value=100%xauto>Default - 100% width</option>\r\n                    <option value=150x150>Thumbnail - 150 x 150</option>\r\n                    <option value=300x300>Medium - 300 x 300</option>\r\n                    <option value=768xauto>Medium Large - 768 x 0</option>\r\n                    <option value=300x300>Woocommerce Thumbnail - 300 x 300</option>\r\n                    <option value=600xauto>Woocommerce Single - 600 x 0</option>\r\n                    <option value=100x100>Woocommerce Gallery Thumbnail - 100 x 100</option>\r\n                    <option value=300x300>Shop Catalog - 300 x 300</option>\r\n                    <option value=600xauto>Shop Single - 600 x 0</option>\r\n                    <option value=100x100>Shop Thumbnail - 100 x 100</option>                    \r\n                    <option value=custom>Custom</option>\r\n                </select>\r\n            </div>\r\n            <div class=\"image-size custom-size\" style=display:none>\r\n                <div class=\"widget-section d-flex align-items-center px-3\">\r\n                    <div class=\"mr-auto control-label\">{language.image_size.width}</div>\r\n                    <div>\r\n                        <input type=text value=100 class=\"custom-width form-control\"/>\r\n                    </div>\r\n                </div>\r\n                <div class=\"widget-section d-flex align-items-center px-3\">\r\n                    <span class=\"mr-auto control-label\">{language.image_size.height}</span>\r\n                    <div>\r\n                        <input type=text value=100 class=\"custom-height form-control\"/>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Field Options Control-->\r\n    <div id=FieldOptionsControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"field-options-container px-3\">\r\n                [OPTIONS]\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Form Control-->\r\n    <div id=FormControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget-section d-flex align-items-center\">\r\n                <div class=\"label mr-auto\">{language.field.control.form.method}</div>\r\n                <div class=pr-3>\r\n                    <!-- <input class=\"method\" type=\"text\" value=\"[METHOD]\"/> -->\r\n                    <select name=method class=\"form-control method\">\r\n                        <option value=GET>GET</option>\r\n                        <option value=POST>POST</option>\r\n                    </select>\r\n                </div>\r\n            </div>    \r\n            <div class=\"widget-section d-flex align-items-center pr-3\">\r\n                <div class=\"label mr-auto\">{language.field.control.autocomplete}</div>\r\n                <div class=\"\">\r\n                    <span class=\"mswitch autocomplete-switch\" data-checked=true>\r\n                        <span class=\"material-icons text-primary\">toggle_on</span>\r\n                    </span>\r\n                </div>\r\n            </div>     \r\n            <div class=\"widget-section d-flex align-items-center\">\r\n                <div class=\"label mr-auto\">{language.field.control.form.enctype}</div>\r\n                <div class=place-value>\r\n                    <select name=enctype class=\"form-control enctype\">\r\n                        <option value=application/x-www-form-urlencoded>application/x-www-form-urlencoded</option>\r\n                        <option value=multipart/form-data>multipart/form-data</option>\r\n                        <option value=text/plain>text/plain</option>\r\n                    </select>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section d-flex align-items-center\">\r\n                <div class=\"label mr-auto\">{language.field.control.form.accept_charset}</div>\r\n                <div class=place-value>\r\n                    <select name=accept_charset class=\"form-control accept_charset\">\r\n                        <option value=UTF-8>UTF-8</option>\r\n                        <option value=ISO-8859-1>ISO-8859-1</option>\r\n                    </select>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Captcha toggle Control-->\r\n    <div id=CaptchaToggleControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget-section d-flex align-items-center pr-3\">\r\n                <div class=\"label mr-auto\">{language.field.control.captcha}</div>\r\n                <div class=\"\">\r\n                    <span class=\"mswitch captcha-switch\" data-checked=true>\r\n                        <span class=\"material-icons text-primary\">toggle_on</span>\r\n                    </span>\r\n                </div>\r\n            </div>      \r\n        </div>\r\n    </div>\r\n\r\n    <!--Common Field Control-->\r\n    <div id=SectionTitleControl>\r\n        <div class=\"jumbotron jumbotron-fluid jumb-title\">\r\n            <h3 class=title>[TITLE]</h3>\r\n        </div>\r\n    </div>\r\n    \r\n    <!--Common Field Control-->\r\n    <div id=CommonFieldControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget-section d-flex align-items-center\">\r\n                <div class=\"label mr-auto\">{language.field.control.field_name}</div>\r\n                <div class=\"place-value pr-3\">\r\n                    <input class=\"field-name disabled\" type=text value=[FIELD_NAME] disabled=disabled />\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section d-flex align-items-center\">\r\n                <div class=\"label mr-auto\">{language.field.control.field_id}</div>\r\n                <div class=\"place-value pr-3\">\r\n                    <div class=\"form-element-widget m-0\">\r\n                        <input type=hidden class=field-id name=[FIELD_ID] />\r\n                        <span class=icon>\r\n                            <i class=material-icons-outlined style=font-size:25px;display:inline-block>[ICON]</i>\r\n                        </span>\r\n                        <span class=\"field-label-box mb-0\"><span class=label>[FIELD_NAME]</span><span class=\"small text-muted hide\">[FIELD_NAME]</span></span>\r\n                    </div>\r\n                    <!-- <input class=\"field-id\" type=\"text\" value=\"[FIELD_NAME]\"/> -->\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section d-flex align-items-center pr-3\">\r\n                <div class=\"label mr-auto\">{language.field.control.show_label}</div>\r\n                <div class=\"\">\r\n                    <span class=\"mswitch label-switch\" data-checked=true>\r\n                        <span class=\"material-icons text-primary\">toggle_on</span>\r\n                    </span>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section d-flex align-items-center field-label-line\">\r\n                <div class=\"label mr-auto\">{language.field.control.label}</div>\r\n                <div class=\"place-value pr-3\">\r\n                    <input class=field-label type=text value=[LABEL] />\r\n                </div>\r\n            </div>            \r\n        </div>\r\n    </div>\r\n\r\n    <!--Validation on/off Control-->\r\n    <div id=ValidationControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget-section d-flex align-items-center pr-3\">\r\n                <div class=\"label mr-auto font-weight-normal\">{language.field.control.validation.required}</div>\r\n                <div class=\"\">\r\n                    <span class=\"mswitch required-switch\" data-checked=true>\r\n                        <span class=\"material-icons text-primary\">toggle_on</span>\r\n                    </span>\r\n                </div>\r\n            </div>\r\n            <div class=validation-rules>\r\n                <div class=\"widget-section d-flex align-items-center\">\r\n                    <div class=\"label mr-auto\">{language.field.control.validation.min_length}</div>\r\n                    <div class=\"place-value pr-3\">\r\n                        <input class=min-length type=text value=[MIN_LENGTH] />\r\n                    </div>\r\n                </div>\r\n                <div class=\"widget-section d-flex align-items-center\">\r\n                    <div class=\"label mr-auto\">{language.field.control.validation.max_length}</div>\r\n                    <div class=\"place-value pr-3\">\r\n                        <input class=max-length type=text value=[MAX_LENGTH] />\r\n                    </div>\r\n                </div>\r\n                <div class=\"widget-section d-flex align-items-center\">\r\n                    <div class=\"label mr-auto\">{language.field.control.validation.regexp}</div>\r\n                    <div class=\"place-value pr-3\">\r\n                        <input class=regexp type=text value=[REGEXP] />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Icon Select Control-->\r\n    <div id=HeadingControl>\r\n        <div class=\"widget-section control-[ID] d-flex align-items-center pr-3\">\r\n            <div class=\"label mr-auto\">[TITLE]</div>\r\n            <select class=form-control style=width:180px>\r\n                <option value=h1>H1</option>     \r\n                <option value=h2>H2</option>     \r\n                <option value=h3>H3</option>     \r\n                <option value=h4>H4</option>     \r\n                <option value=h5>H5</option>     \r\n                <option value=h6>H6</option>     \r\n            </select>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Text style-->\r\n    <div id=TextControl>\r\n        <div class=\"control-[ID] px-3 py-2\">\r\n            <textarea class=\"text-content text-editor-[ID]\">[TEXT]</textarea>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Background color-->\r\n    <div id=BackgroundControl>\r\n        <div class=\"widget-section link-color-element\">\r\n            <div class=label>[TITLE]</div>\r\n            <div class=thongso>\r\n                <span class=click-color>\r\n                    <input type=color class=link-color value=#0056b3 id=[AINPUT_ID] />\r\n                </span>\r\n                <span class=value>\r\n                    <input class=link-color-input type=text value=\"\" id=A-bg-color-[AINPUT_ID] />\r\n                </span>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Icon Select Control-->\r\n    <div id=IconSelectControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget-section d-flex align-items-center pr-3\">\r\n                <div class=\"label mr-auto\">[TITLE]</div>\r\n                <div class=\"icon mr-2\" style=height:32px;text-align:right;width:100px></div>\r\n                <select class=form-control style=width:180px>\r\n                    <option value={{root}}image/icon-none.png>\r\n                        --</option>\r\n                    <option value={{root}}image/facebook.png>\r\n                        Facebook</option>\r\n                    <option value={{root}}image/twitter.png>\r\n                        Twitter</option>\r\n                    <option value={{root}}image/instagram.png>\r\n                        Instagram</option>\r\n                    <option value={{root}}image/linkedin.png>\r\n                        Linkedin</option>\r\n                    <option value={{root}}image/tumblr.png>\r\n                        Tumblr</option>\r\n                    <option value={{root}}image/google-plus.png>\r\n                        Google Plus</option> \r\n                    <option value={{root}}image/youtube.png>\r\n                        YouTube\r\n                    </option>       \r\n                    <option value={{root}}image/line.png>\r\n                        LINE\r\n                    </option> \r\n                    <option value={{root}}image/wechat.png>\r\n                        WeChat\r\n                    </option>  \r\n                    <option value={{root}}image/weibo.png>\r\n                        Weibo\r\n                    </option>\r\n                    <option value={{root}}image/tiktok.png>\r\n                        TikTok\r\n                    </option>\r\n                </select>\r\n            </div>\r\n            <div class=\"widget-section d-flex align-items-center pr-3\">\r\n                <div class=\"label mr-auto\">{language.link}</div>\r\n                <div class=\"\">\r\n                    <input style=width:220px type=text name=url class=\"form-control url\"/>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section d-flex align-items-center px-2\">\r\n                <button class=\"btn btn-secondary mr-2 but-dup\">{language.widget.duplicate}</button>\r\n                <button class=\"btn btn-warning but-remove\">{language.widget.remove}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Font family-->\r\n    <div id=FontFamilyControl>\r\n        <div class=\"widget-section font-family pr-3 control-[ID]\">\r\n            <div class=label>[TITLE]</div>\r\n            <select class=form-control>\r\n                <option value=times>Times</option>\r\n                <option value=serif>Serif</option>\r\n                <option value=arial>Arial</option>\r\n                <option value=tahoma>Tahoma</option>\r\n                <option value=roboto>Roboto</option>\r\n                <option value=\"segoe ui\">Segoe UI</option>                \r\n            </select>\r\n        </div>\r\n    </div>\r\n    \r\n    <!--Text size-->\r\n    <div id=TextSizeControl>\r\n        <div class=\"widget-section text-size control-[ID]\">\r\n            <div class=label>[TITLE]</div>\r\n            <select class=form-control>\r\n                <option value=8px>8px</option>\r\n                <option value=9px>9px</option>\r\n                <option value=10px>10px</option>\r\n                <option value=11px selected=selected>11px</option>\r\n                <option value=12px>12px</option>\r\n                <option value=14px>14px</option>\r\n                <option value=16px>16px</option>\r\n                <option value=18px>18px</option>\r\n                <option value=20px>20px</option>\r\n                <option value=22px>22px</option>\r\n                <option value=24px>24px</option>\r\n                <option value=30px>30px</option>\r\n                <option value=38px>38px</option>\r\n                <option value=46px>46px</option>\r\n                <option value=60px>60px</option>\r\n                <option value=72px>72px</option>\r\n            </select>\r\n        </div>\r\n    </div>\r\n    \r\n    <!--Text style-->\r\n    <div id=TextStyleControl>\r\n        <div class=\"widget-section text-style control-[ID]\">\r\n            <div class=label>[TITLE]</div>\r\n            <div class=icons-group>\r\n                <ul>\r\n                    <li>\r\n                        <button class=text-style-bold>\r\n                            <i class={builder-icon-bold}></i>\r\n                        </button>\r\n                    </li>\r\n                    <li>\r\n                        <button class=text-style-italic>\r\n                            <i class={builder-icon-italic}></i>\r\n                        </button>\r\n                    </li>\r\n                    <li>\r\n                        <button class=text-style-underline>\r\n                            <i class={builder-icon-underline}></i>\r\n                        </button>\r\n                    </li>\r\n                    <li>\r\n                        <button class=text-style-strikethrough>\r\n                            <i class={builder-icon-strikethrough}></i>\r\n                        </button>\r\n                    </li>\r\n                </ul>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    \r\n    <!--Text color-->\r\n    <div id=ColorPickerControl>\r\n        <div class=\"widget-section text-color-element\">\r\n            <div class=label>[TITLE]</div>\r\n            <div class=thongso>\r\n                <span class=click-color>\r\n                    <input type=color id=[PINPUT_ID] class=color value=#555555 />\r\n                </span>\r\n                <span class=value>\r\n                    <input class=text-color-input type=text value=\"\" id=P-text-color />\r\n                </span>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n\r\n    <!--link color-->\r\n    <div id=LinkColorControl>\r\n        <div class=\"widget-section link-color-element\">\r\n            <div class=label>[TITLE]</div>\r\n            <div class=thongso>\r\n                <span class=click-color>\r\n                    <input type=color class=link-color value=#0056b3 id=[AINPUT_ID] />\r\n                </span>\r\n                <span class=value>\r\n                    <input class=link-color-input type=text value=\"\" id=A-link-color-[AINPUT_ID] />\r\n                </span>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Associate with tag-->\r\n    <div id=DropdownAssociateControl>\r\n        <div class=\"widget-section widget-associate\">\r\n            <div class=label>[TITLE]</div>\r\n            <div class=right-value>\r\n                <select class=associate-dropdown id=[dropdown_ID] name={GENDER}>\r\n                    <option class=placeholder-option style=display:none>-- Select option --</option>\r\n                </select>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Associate with text-->\r\n    <div id=TextAssociateControl>\r\n        <div class=\"widget-section widget-associate\">\r\n            <div class=label>[TITLE]</div>\r\n            <div class=\"right-value right-value-text\">\r\n                <select class=associate-text name=\"\" id=\"\">\r\n                <!--tag-->\r\n                </select>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Associate with checkbox-->\r\n    <div id=CheckboxAssociateControl>\r\n        <div class=\"widget-section widget-associate\">\r\n            <div class=label>[TITLE]</div>\r\n            <div class=\"right-value right-value-checbox\">\r\n                <select class=associate-checkbox name=\"\" id=\"\">\r\n                    <!--option-->\r\n                </select>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Placeholder-->\r\n    <div id=PlaceholderControl>\r\n        <div class=\"widget-section placeholder placeholder-input-control\">\r\n            <div class=label>[TITLE]</div>\r\n            <div class=place-value>\r\n                <input class=\"placeholder placeholder-input\" type=text value=\"\" name=\"\"/>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--line height-->\r\n    <div id=LineHeightControl>\r\n        <div class=widget-section>\r\n            <div class=label>[TITLE]</div>\r\n            <div class=thongso>\r\n                <ul>\r\n                    <li><img class=\"icon-left icon-line-height active\" src=" + __webpack_require__(17) + " line-height=1 /></li>\r\n                    <li><img class=\"icon-center icon-line-height\" src=" + __webpack_require__(18) + " line-height=1.5 /></li>\r\n                    <li><img class=\"icon-justify icon-line-height\" src=" + __webpack_require__(19) + " line-height=2 /></li>\r\n                    <li><img class=\"icon-right icon-line-height\" src=" + __webpack_require__(20) + " line-height=2.5 /></li>\r\n                </ul>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Action-->\r\n    <div id=ActionControl>\r\n        <div class=widget-action>\r\n            <div class=wg-info>\r\n                <div class=tren>\r\n                    <div class=trai>\r\n                       <span>{language.wpanel.controls.image_link.title}</span>\r\n                    </div>\r\n                </div>\r\n                <div class=giua>\r\n                    <div class=url-link>\r\n                        <div class=thongso>\r\n                            <span class=url>{language.wpanel.controls.url.title}</span>\r\n                            <span class=value>\r\n                                <input type=text value=[HREF]>\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <div class=duoi>\r\n                    <a class=\"\" href=\"\">{language.wpanel.controls.special_link.title}</a>\r\n                    <a class=\"\" href=\"\">{language.wpanel.controls.link_file.title}</a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Block option-->\r\n    <div id=BlockOptionControl>\r\n        <div class=\"widget-section2 block-option-control control-[ID]\">\r\n            <div class=section-option>\r\n                <div class=widget>\r\n                    <div class=row>\r\n                        <div class=\"col-md-7 left\">\r\n                            <div class=widget-label>[TITLE]</div>\r\n                        </div>\r\n                        <div class=\"col-md-5 right\">\r\n                            <div class=\"widget-value right\">\r\n                                <div class=toggle>\r\n                                    <div class=\"toggle__status toggle__status--off\">{language.wpanel.controls.more_option.title}</div>\r\n                                    <label class=\"switch check-all-padding\">\r\n                                        <input type=checkbox>\r\n                                        <span class=\"slider all-padding\" id=\"\"></span>\r\n                                    </label>\r\n                                    <label class=\"switch check-4-padding\" style=display:none>\r\n                                        <input type=checkbox>\r\n                                        <span class=\"slider _4-padding\" id=\"\"></span>\r\n                                    </label>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <hr class=hr--cs />\r\n                <div class=\"widget detail-padding\">\r\n                    <div class=container>\r\n                        <div class=\"\">\r\n                            <div class=\"d-flex align-items-center\" style=width:100%>\r\n                                <div class=all-padding-section>\r\n                                    <div class=\"_1_minus-plus _1_minus-plus-block\">\r\n                                        <span class=label>{language.wpanel.controls.all_side.title}</span>\r\n                                        <div class=minus-plus>\r\n                                            <span class=minus>\r\n                                                <button class=minus-all id=\"\">-</button>\r\n                                            </span>\r\n                                            <input type=text value=[PADDING] id=giatri class=value-padding />\r\n                                            <span class=plus>\r\n                                                <button class=plus-all id=\"\">+</button>\r\n                                            </span>\r\n                                        </div>\r\n                                    </div>\r\n                                </div>\r\n                                <div class=four-padding-section>\r\n                                    <div class=\"left padding\" id=padding>\r\n                                        <div class=\"tren mr-3\">\r\n                                            <span class=label>{language.wpanel.controls.top.title}</span>\r\n                                            <div class=minus-plus>\r\n                                                <span class=minus>\r\n                                                    <button class=minus-top id=\"\">-</button>\r\n                                                </span>\r\n                                                <input type=text value=[TOP] id=value-top class=value-top />\r\n                                                <span class=plus>\r\n                                                    <button class=plus-top id=\"\">+</button>\r\n                                                </span>\r\n                                            </div>\r\n                                        </div>\r\n                                        <div class=tren>\r\n                                            <span class=label>{language.wpanel.controls.bottom.title}</span>\r\n                                            <div class=\"minus-plus minus-bottom-right\">\r\n                                                <span class=minus style=\"\">\r\n                                                    <button class=minus-bottom id=\"\">-</button>\r\n                                                </span>\r\n                                                <input type=text value=[BOTTOM] id=value-bottom class=value-bottom />\r\n                                                <span class=plus style=\"\">\r\n                                                    <button class=plus-bottom id=\"\">+</button>\r\n                                                </span>\r\n                                            </div>\r\n                                        </div>\r\n                                    </div>\r\n                                    <div class=\"left padding\" style=\"\" id=padding>\r\n                                        <div class=\"tren mr-3\">\r\n                                            <span class=label>{language.wpanel.controls.left.title}</span>\r\n                                            <div class=minus-plus>\r\n                                                <span class=minus>\r\n                                                    <button class=minus-left id=\"\">-</button>\r\n                                                </span>\r\n                                                <input type=text value=[LEFT] id=value-left class=value-left />\r\n                                                <span class=plus>\r\n                                                    <button class=plus-left id=\"\">+</button>\r\n                                                </span>\r\n                                            </div>\r\n                                        </div>\r\n                                        <div class=tren>\r\n                                            <span class=label>{language.wpanel.controls.right.title}</span>\r\n                                            <div class=\"minus-plus minus-bottom-right\" style=\"\">\r\n                                                <span class=minus style=\"\">\r\n                                                    <button class=minus-right id=\"\">-</button>\r\n                                                </span>\r\n                                                <input type=text value=[RIGHT] id=value-right class=value-right />\r\n                                                <span class=plus style=\"\">\r\n                                                    <button class=plus-right id=\"\">+</button>\r\n                                                </span>\r\n                                            </div>\r\n                                        </div>                                        \r\n                                    </div>                                \r\n                                </div>\r\n                                <div class=\"right ml-auto\">\r\n                                    <div class=square id=square-block>\r\n                                        <img title=\"Padding preview\" src=" + __webpack_require__(21) + ">\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=imageControl>\r\n        <div class=control-[ID]>\r\n            <div class=\"widget image-name\">\r\n                <div class=image-selected>\r\n                    <img id=[image_selected_ID] class=image-select src=https://tinyjpg.com/images/social/website.jpg />\r\n                </div>\r\n                <div class=tren>\r\n                    <div class=\"d-flex align-items-canter justify-content-center\">\r\n                        <!-- <div class=\"label\">{language.wpanel.controls.image_name.title}</div> -->\r\n                        <span id=name-image>{language.wpanel.controls.logo_name.title}</span>\r\n                    </div>\r\n                    <div class=button>\r\n                        <button class=\"btn btn-info change\" id=[uploadImage-ID] type=submit>{language.wpanel.controls.change_image.title}</button>\r\n                        <!-- <button class=\"btn btn-secondary\" style=\"pointer-events: none;\">{language.wpanel.controls.effect.title}</button> -->\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            \r\n            <div class=\"widget alternate-text\">\r\n                <div class=row>\r\n                    <div class=\"col-md-3 left\">\r\n                        <div class=widget-label>{language.wpanel.controls.alternate.title}</div>\r\n                    </div>\r\n                    <div class=\"col-md-9 right\">\r\n                        <input type=text value=\"\" id=[img_alt_ID] class=name-img />\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            \r\n            <div class=\"widget range\" id=image-control-ID>\r\n                <div class=row>\r\n                    <div class=\"col-md-8 left\">\r\n                        <div class=widget-label>{language.image.width}</div>\r\n                    </div>\r\n                </div>\r\n                <div class=tren>\r\n                    <input type=range min=0 max=100 step=1 value=0 class=image-width>\r\n                    <div class=\"thongso image-width-text\">{language.wpanel.controls.value.title}</div>\r\n                </div>\r\n            </div>\r\n            <hr class=hr--cs />\r\n            <div class=\"widget range\" id=image-control-ID>\r\n                <div class=row>\r\n                    <div class=\"col-md-8 left\">\r\n                        <div class=widget-label>\r\n                            <div class=\"d-flex align-items-center\">\r\n                                <div>{language.image.height}</div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-md-4 right\">\r\n                        <div class=\"d-flex align-items-center\">\r\n                            <div class=\"mr-2 small\">{language.image.auto_height}</div>\r\n                            <div class=\"d-flex align-items-center\">\r\n                                <label style=position:relative>\r\n                                    <input type=checkbox class=\"styled3 image-height-auto\"/>\r\n                                    <span class=check-symbol></span>\r\n                                </label>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <div class=tren>\r\n                    <input type=range min=0 max=2000 step=1 value=0 class=image-height>\r\n                    <div class=\"thongso image-height-text\">{language.wpanel.controls.value.title}</div>\r\n                </div>\r\n            </div>\r\n            <hr class=hr--cs />\r\n            <div class=\"widget align\">\r\n                <div class=label>[TITLE]</div>\r\n                <div class=thongso>\r\n                    <ul>\r\n                        <li><i class=\"{builder-icon-align-left} icon-left-img icon-align\" align=left id=[icon-left-ID]></i></li>\r\n                        <li><i class=\"{builder-icon-align-justify} icon-center-img icon-align\" align=center id=[icon-center-ID]></i></li>\r\n                        <li><i class=\"{builder-icon-align-right} icon-right-img icon-align\" align=right id=[icon-right-ID]></i></li>\r\n                    </ul>\r\n                </div>\r\n            </div>\r\n            \r\n            <div class=\"widget-section link-image\">\r\n                <div class=wg-info>\r\n                    <div class=tren>\r\n                        <div class=trai>\r\n                            <span>{language.image_url}</span>\r\n                        </div>\r\n                    </div>\r\n                    <div class=giua>\r\n                        <div class=url-link>\r\n                            <div class=thongso>\r\n                                <span class=url>{language.wpanel.controls.url.title}</span>\r\n                                <span class=value>\r\n                                    <input type=text class=url-image id=[img_url_ID] value=\"\">\r\n                                </span>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=duoi>\r\n                        <a class=copy-url href=\"\">{language.wpanel.controls.copy_url.title}</a>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Button option-->\r\n    <div id=ButtonOptionControl>\r\n        <div class=\"widget-section2 button-option-control\">\r\n            <div class=\"widget range\" style=\"border-bottom:1px solid #e1e4e7;height:auto!important;padding-bottom:15px!important\">\r\n                <div class=row>\r\n                    <div class=\"col-md-8 left\">\r\n                        <div class=widget-label>{language.wpanel.controls.auto_width.title}</div>\r\n                    </div>\r\n                    <div class=\"col-md-4 right\" style=padding-right:6px!important>\r\n                        <div class=\"widget-value right\">\r\n                            <div class=toggle>\r\n                                <label class=switch>\r\n                                    <input type=checkbox checked=checked>\r\n                                    <span class=\"slider auto-width-plus\"></span>\r\n                                </label>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <hr class=\"hr--cs hr--cs-button hide\" style=\"border-top:1px solid rgba(0,0,0,.04)!important\">\r\n                <div class=\"tren auto-width-button hide\">\r\n                    <input type=range min=50 max=500 step=5 value=\"\" style=\"\" id=\"\" class=\"color-default color-default-button\">\r\n                    <div class=\"thongso width-button\" id=thongsos>[WIDTH_BUTTON]</div>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section bg-color\" style=height:60px!important>\r\n                <div class=label>{language.wpanel.controls.background_color.title}</div>\r\n                <div class=\"thongso background\">\r\n                    <span class=click-color>\r\n                        <input type=color class=\"color background-color\" value=#cccccc id=[BACKINPUT_ID] />\r\n                    </span>\r\n                    <span class=value>\r\n                        <input class=background-color-input type=text value=[BACKGROUNDVALUE] id=background-color />\r\n                    </span>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section text-color\" style=height:60px!important>\r\n                <div class=label>{language.wpanel.controls.text_color.title}</div>\r\n                <div class=\"thongso background\">\r\n                    <span class=click-color>\r\n                        <input type=color class=text-color value=#555555 id=\"\"/>\r\n                    </span>\r\n                    <span class=value>\r\n                        <input class=input-text-color type=text value=\"\" id=text_color_input />\r\n                    </span>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section align\" style=height:60px!important>\r\n                <div class=label>{language.wpanel.controls.align.title}</div>\r\n                <div class=\"thongso background\">\r\n                    <div class=\"item_1-2 right\">\r\n                        <div mailup-common-alignment-selector=\"\" ng-model=\"style['text-align']\" class=\"ng-pristine ng-untouched ng-valid ng-isolate-scope ng-not-empty\">\r\n                            <div class=alignment-container>\r\n                                <button type=button class=\"align btn btn-default align-left ng-pristine ng-valid ng-not-empty ng-touched\" float=left ng-model=value uib-btn-radio=\"'left'\" style=\"\">\r\n                                </button>\r\n                                <button type=button class=\"align btn btn-default align-center ng-pristine ng-untouched ng-valid ng-not-empty active\" float=center ng-model=value uib-btn-radio=\"'center'\">\r\n                                </button>\r\n                                <button type=button class=\"align btn btn-default align-right ng-pristine ng-untouched ng-valid ng-not-empty\" float=right ng-model=value uib-btn-radio=\"'right'\">\r\n                                </button>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section line-height\" style=height:60px!important>\r\n                <div class=label>{language.wpanel.controls.line_height.title}</div>\r\n                <div class=thongso>\r\n                    <ul>\r\n                        <li><img class=\"icon-left icon-line-height active\" src=" + __webpack_require__(17) + " line-height=1 style=width:70%;height:100%;cursor:pointer /></li>\r\n                        <li><img class=\"icon-center icon-line-height\" src=" + __webpack_require__(18) + " line-height=1.5 style=width:70%;height:100%;cursor:pointer /></li>\r\n                        <li><img class=\"icon-justify icon-line-height\" src=" + __webpack_require__(19) + " line-height=2 style=width:68%;height:100%;cursor:pointer /></li>\r\n                        <li><img class=\"icon-right icon-line-height\" src=" + __webpack_require__(20) + " line-height=2.5 style=width:68%;height:100%;cursor:pointer /></li>\r\n                    </ul>\r\n                </div>\r\n            </div>\r\n            <div class=\"widget-section border-radius\" style=height:60px!important>\r\n                <div class=label>{language.wpanel.controls.border_radius.title}</div>\r\n                <div class=thongso>\r\n                    <div class=\"minus-plus border-radius\">\r\n                        <span class=minus>\r\n                            <button class=minus id=minus-border>-</button>\r\n                        </span>\r\n                        <input class=border-button type=text value=\"\" id=border-radius />\r\n                        <span class=plus>\r\n                            <button class=plus id=plus-border>+</button>\r\n                        </span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class=\"section-option borders\" style=margin-bottom:40px>\r\n                <div class=\"widget more-options\">\r\n                    <div class=row>\r\n                        <div class=\"col-md-7 left\">\r\n                            <div class=widget-label>{language.wpanel.controls.border.title}</div>\r\n                        </div>\r\n                        <div class=\"col-md-5 right\">\r\n                            <div class=\"widget-value right\">\r\n                                <div class=toggle>\r\n                                    <div class=\"toggle__status toggle__status--off\">{language.wpanel.controls.more_option.title}</div>\r\n                                    <label class=\"switch check-all-border\">\r\n                                        <input type=checkbox>\r\n                                        <span class=\"slider padding_border all-border\" id=\"\"></span>\r\n                                    </label>\r\n                                    <label class=\"switch check-four-border\" style=display:none>\r\n                                        <input type=checkbox>\r\n                                        <span class=\"slider padding_border four-border\" id=\"\"></span>\r\n                                    </label>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <div class=\"widget all-sides\">\r\n                    <div class=container>\r\n                        <div class=row>\r\n                            <div class=\"_1_minus-plus _1_minus-plus-border\" style=\"\">\r\n                                <span class=label style=\"\">{language.wpanel.controls.all_side.title}</span>\r\n                                <div class=\"btn-group dropdown-custom dropdown-custom--cs dropdown\" uib-dropdown=\"\" ng-click=toggleDropdown($event) ng-show=styleEnabled style=\"\">\r\n                                    <button uib-dropdown-toggle=\"\" is-open=isOpen type=button class=\"btn btn-default dropdown-toggle dropdown-toggle-style\" aria-haspopup=true aria-expanded=false>\r\n                                        <span class=\"ng-binding border-style\"></span>\r\n                                        <div class=arrows>\r\n                                            <span class=\"caret up\"></span>\r\n                                            <span class=\"caret down\"></span>\r\n                                            <div class=clear-fix></div>\r\n                                        </div>\r\n                                    </button>\r\n                                    <ul class=\"dropdown-menu dropdown-menu-style\" role=menu>\r\n                                        <!-- ngRepeat: style in styles -->\r\n                                        <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                            <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=solid class=\"ng-binding ng-binding-solid\">{language.wpanel.controls.solid.title}</a>\r\n                                        </li>\r\n                                        <!-- end ngRepeat: style in styles -->\r\n                                        <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                            <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=dotted class=\"ng-binding ng-binding-dotted\">{language.wpanel.controls.dotted.title}</a>\r\n                                        </li>\r\n                                        <!-- end ngRepeat: style in styles -->\r\n                                        <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                            <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=dashed class=\"ng-binding ng-binding-dashed\">{language.wpanel.controls.dashed.title}</a>\r\n                                        </li>\r\n                                        <!-- end ngRepeat: style in styles -->\r\n                                    </ul>\r\n                                </div>\r\n                                <div class=\"minus-plus minus-plus-border\">\r\n                                    <span class=\"minus minus-border\">\r\n                                        <button class=minus id=minus-border-width>-</button>\r\n                                    </span>\r\n                                    <input class=border-width-input type=text value=\"\" id=giatriborder />\r\n                                    <span class=\"plus plus-border\">\r\n                                        <button class=plus id=plus-border-width>+</button>\r\n                                    </span>\r\n                                </div>\r\n\r\n                                <div class=widget-section-border>\r\n                                    <div class=thongso>\r\n                                        <span class=click-color>\r\n                                            <input type=color id=\"\" class=border-color value=#000000 style=padding:3px;border:none;width:28px;position:absolute;cursor:pointer />\r\n                                        </span>\r\n                                        <span class=value>\r\n                                            <input class=border_color_input type=text value=\"\" id=border-color />\r\n                                        </span>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n\r\n                            <div class=\"left padding-border\" id=padding-border>\r\n                                <div class=\"_1_minus-plus-top _1_minus-plus-border-top\" style=\"\">\r\n                                    <span class=label style=width:100%!important>{language.wpanel.controls.top.title}</span>\r\n                                    <div class=\"btn-group dropdown-custom dropdown-custom--cs dropdown\" uib-dropdown=\"\" ng-click=toggleDropdown($event) ng-show=styleEnabled style=\"\">\r\n                                        <button uib-dropdown-toggle=\"\" is-open=isOpen type=button class=\"btn btn-default dropdown-toggle dropdown-toggle-style-top\" aria-haspopup=true aria-expanded=false>\r\n                                            <span class=\"ng-binding border-style-top\">{language.wpanel.controls.solid.title}</span>\r\n                                            <div class=arrows>\r\n                                                <span class=\"caret up\"></span>\r\n                                                <span class=\"caret down\"></span>\r\n                                                <div class=clear-fix></div>\r\n                                            </div>\r\n                                        </button>\r\n                                        <ul class=\"dropdown-menu dropdown-menu-style-top\" role=menu>\r\n                                            <!-- ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=solid class=\"ng-binding ng-binding-solid-top\">{language.wpanel.controls.solid.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=dotted class=\"ng-binding ng-binding-dotted-top\">{language.wpanel.controls.dotted.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-cborder-colorlick=changeStyle(style) id=\"\" data-value=dashed class=\"ng-binding ng-binding-dashed-top\">{language.wpanel.controls.dashed.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                        </ul>\r\n                                    </div>\r\n                                    <div class=\"minus-plus minus-plus-border\">\r\n                                        <span class=\"minus minus-border\">\r\n                                            <button class=minus id=minus-border-top>-</button>\r\n                                        </span>\r\n                                        <input class=\"border-input border-top-width-input\" type=text value=0 id=giatribordertop />\r\n                                        <span class=\"plus plus-border\">\r\n                                            <button class=plus id=plus-border-top>+</button>\r\n                                        </span>\r\n                                    </div>\r\n\r\n                                    <div class=widget-section-border>\r\n                                        <div class=thongso>\r\n                                            <span class=click-color>\r\n                                                <input type=color id=\"\" class=border-color-top value=#000000 style=padding:3px;border:none;width:28px;position:absolute;top:2px;cursor:pointer;left:-57px />\r\n                                            </span>\r\n                                            <span class=value>\r\n                                                <input class=border_top_color_input type=text value=\"\" id=border-top-color />\r\n                                            </span>\r\n                                        </div>\r\n                                    </div>\r\n                                </div>\r\n                                <div class=\"_1_minus-plus-right _1_minus-plus-border-right\" style=\"\">\r\n                                    <span class=label style=width:100%!important>{language.wpanel.controls.right.title}</span>\r\n                                    <div class=\"btn-group dropdown-custom dropdown-custom--cs dropdown\" uib-dropdown=\"\" ng-click=toggleDropdown($event) ng-show=styleEnabled style=\"\">\r\n                                        <button uib-dropdown-toggle=\"\" is-open=isOpen type=button class=\"btn btn-default dropdown-toggle dropdown-toggle-style-right\" aria-haspopup=true aria-expanded=false>\r\n                                            <span class=\"ng-binding border-style-right\">{language.wpanel.controls.solid.title}</span>\r\n                                            <div class=arrows>\r\n                                                <span class=\"caret up\"></span>\r\n                                                <span class=\"caret down\"></span>\r\n                                                <div class=clear-fix></div>\r\n                                            </div>\r\n                                        </button>\r\n                                        <ul class=\"dropdown-menu dropdown-menu-style-right\" role=menu>\r\n                                            <!-- ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=solid class=\"ng-binding ng-binding-solid-right\">{language.wpanel.controls.solid.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=dotted class=\"ng-binding ng-binding-dotted-right\">{language.wpanel.controls.dotted.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=dashed class=\"ng-binding ng-binding-dashed-right\">{language.wpanel.controls.dashed.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                        </ul>\r\n                                    </div>\r\n                                    <div class=\"minus-plus minus-plus-border\">\r\n                                        <span class=\"minus minus-border\">\r\n                                            <button class=minus id=minus-border-right>-</button>\r\n                                        </span>\r\n                                        <input class=\"border-input border-right-width-input\" type=text value=0 id=giatriborderright />\r\n                                        <span class=\"plus plus-border\">\r\n                                            <button class=plus id=plus-border-right>+</button>\r\n                                        </span>\r\n                                    </div>\r\n\r\n                                    <div class=widget-section-border>\r\n                                        <div class=thongso>\r\n                                            <span class=click-color>\r\n                                                <input type=color id=\"\" class=border-color-right value=#000000 style=padding:3px;border:none;width:28px;position:absolute;top:2px;cursor:pointer;left:-57px />\r\n                                            </span>\r\n                                            <span class=value>\r\n                                                <input class=border_right_color_input type=text value=\"\" id=border-right-color />\r\n                                            </span>\r\n                                        </div>\r\n                                    </div>\r\n                                </div>\r\n                                <div class=\"_1_minus-plus-bottom _1_minus-plus-border-bottom\" style=\"\">\r\n                                    <span class=label style=width:100%!important>{language.wpanel.controls.bottom.title}</span>\r\n                                    <div class=\"btn-group dropdown-custom dropdown-custom--cs dropdown\" uib-dropdown=\"\" ng-click=toggleDropdown($event) ng-show=styleEnabled style=\"\">\r\n                                        <button uib-dropdown-toggle=\"\" is-open=isOpen type=button class=\"btn btn-default dropdown-toggle dropdown-toggle-style-bottom\" aria-haspopup=true aria-expanded=false>\r\n                                            <span class=\"ng-binding border-style-bottom\">{language.wpanel.controls.solid.title}</span>\r\n                                            <div class=arrows>\r\n                                                <span class=\"caret up\"></span>\r\n                                                <span class=\"caret down\"></span>\r\n                                                <div class=clear-fix></div>\r\n                                            </div>\r\n                                        </button>\r\n                                        <ul class=\"dropdown-menu dropdown-menu-style-bottom\" role=menu>\r\n                                            <!-- ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=solid class=\"ng-binding ng-binding-solid-bottom\">{language.wpanel.controls.solid.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=dotted class=\"ng-binding ng-binding-dotted-bottom\">{language.wpanel.controls.dotted.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=dashed class=\"ng-binding ng-binding-dashed-bottom\">{language.wpanel.controls.dashed.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                        </ul>\r\n                                    </div>\r\n                                    <div class=\"minus-plus minus-plus-border\">\r\n                                        <span class=\"minus minus-border\">\r\n                                            <button class=minus id=minus-border-bottom>-</button>\r\n                                        </span>\r\n                                        <input class=\"border-input border-bottom-width-input\" type=text value=0 id=giatriborderbottom />\r\n                                        <span class=\"plus plus-border\">\r\n                                            <button class=plus id=plus-border-bottom>+</button>\r\n                                        </span>\r\n                                    </div>\r\n\r\n                                    <div class=widget-section-border>\r\n                                        <div class=thongso>\r\n                                            <span class=click-color>\r\n                                                <input type=color id=\"\" class=border-color-bottom value=#000000 style=padding:3px;border:none;width:28px;position:absolute;top:2px;cursor:pointer;left:-62px />\r\n                                            </span>\r\n                                            <span class=value>\r\n                                                <input class=border_bottom_color_input type=text value=\"\" id=border-bottom-color />\r\n                                            </span>\r\n                                        </div>\r\n                                    </div>\r\n                                </div>\r\n                                <div class=\"_1_minus-plus-left _1_minus-plus-border-left\" style=\"\">\r\n                                    <span class=label style=width:100%!important>{language.wpanel.controls.left.title}</span>\r\n                                    <div class=\"btn-group dropdown-custom dropdown-custom--cs dropdown\" uib-dropdown=\"\" ng-click=toggleDropdown($event) ng-show=styleEnabled style=\"\">\r\n                                        <button uib-dropdown-toggle=\"\" is-open=isOpen type=button class=\"btn btn-default dropdown-toggle dropdown-toggle-style-left\" aria-haspopup=true aria-expanded=false>\r\n                                            <span class=\"ng-binding border-style-left\">{language.wpanel.controls.solid.title}</span>\r\n                                            <div class=arrows>\r\n                                                <span class=\"caret up\"></span>\r\n                                                <span class=\"caret down\"></span>\r\n                                                <div class=clear-fix></div>\r\n                                            </div>\r\n                                        </button>\r\n                                        <ul class=\"dropdown-menu dropdown-menu-style-left\" role=menu>\r\n                                            <!-- ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=solid class=\"ng-binding ng-binding-solid-left\">{language.wpanel.controls.solid.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=dotted class=\"ng-binding ng-binding-dotted-left\">{language.wpanel.controls.dotted.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                            <li ng-repeat=\"style in styles\" class=ng-scope>\r\n                                                <a href=javascript:; ng-click=changeStyle(style) id=\"\" data-value=dashed class=\"ng-binding ng-binding-dashed-left\">{language.wpanel.controls.dashed.title}</a>\r\n                                            </li>\r\n                                            <!-- end ngRepeat: style in styles -->\r\n                                        </ul>\r\n                                    </div>\r\n                                    <div class=\"minus-plus minus-plus-border\">\r\n                                        <span class=\"minus minus-border\">\r\n                                            <button class=minus id=minus-border-left>-</button>\r\n                                        </span>\r\n                                        <input class=\"border-input border-left-width-input\" type=text value=0 id=giatriborderleft />\r\n                                        <span class=\"plus plus-border\">\r\n                                            <button class=plus id=plus-border-left>+</button>\r\n                                        </span>\r\n                                    </div>\r\n\r\n                                    <div class=widget-section-border>\r\n                                        <div class=thongso>\r\n                                            <span class=click-color>\r\n                                                <input type=color id=\"\" class=border-color-left value=#000000 style=padding:3px;border:none;width:28px;position:absolute;top:2px;cursor:pointer;left:-57px />\r\n                                            </span>\r\n                                            <span class=value>\r\n                                                <input class=border_left_color_input type=text value=\"\" id=border-left-color />\r\n                                            </span>\r\n                                        </div>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                            \r\n                            <div class=\"col-md-4 right\" style=top:12px!important>\r\n                                <div class=square-border id=square-border>\r\n                                    <img title=\"Padding preview\" src=" + __webpack_require__(21) + ">\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <script>$(document).on(\"click\",\"span.slider.content_padding\",function(){$(\".content-padding\").toggleClass(\"hienlen\"),$(\"._1_minus-plus-content\").toggleClass(\"andi\")}),$(document).on(\"click\",\"span.all-border\",function(){$(\"label.check-all-border\").addClass(\"andi\"),$(\"label.check-four-border\").addClass(\"hienthi\"),$(\"._1_minus-plus-border\").addClass(\"andi\"),$(\".left.padding-border\").addClass(\"hienlen\")}),$(document).on(\"click\",\"span.four-border\",function(){$(\"label.check-all-border\").removeClass(\"andi\"),$(\"label.check-four-border\").removeClass(\"hienthi\"),$(\"._1_minus-plus-border\").removeClass(\"andi\"),$(\".left.padding-border\").removeClass(\"hienlen\")}),$(document).on(\"click\",\"span.auto-width-plus\",function(){$(\".auto-width-button\").toggleClass(\"hide\"),$(\".hr--cs-button\").toggleClass(\"hide\")}),$(document).on(\"click\",\".dropdown-toggle\",function(){var e=$(this).closest(\".dropdown-custom\").find(\".dropdown-menu\");e.is(\":visible\")?e.hide():($(\".dropdown-menu:visible\").hide(),e.show()),$(this).closest(\".dropdown-custom\").addClass(\"visible\"),$(\".dropdown-toggle\").removeClass(\"change-bg\"),$(this).addClass(\"change-bg\")}),$(document).click(function(e){0==$(e.target).closest(\".dropdown-menu\").length&&0==$(e.target).closest(\".dropdown-toggle\").length&&($(\".dropdown-menu:visible\").hide(),$(\".dropdown-custom\").removeClass(\"visible\"),$(\".dropdown-toggle\").removeClass(\"change-bg\"))})</script>\r\n\r\n    <!--Action button-->\r\n    <div id=ActionButtonControl>\r\n        <div class=\"widget-action action-button\">\r\n            <div class=wg-info>\r\n                <div class=tren id=link-redirect-page style=\"\">\r\n                    <div class=trai>\r\n                        <input type=radio class=check-link-page name=redirect-page style=margin-right:5px />\r\n                        <span>{language.wpanel.controls.link_to.title}</span>\r\n                    </div>\r\n                    <div class=phai>\r\n                        <button type=\"\" value=\"\" class=owp-button id=\"\"></button>\r\n                        <div class=\"arrows arrows-button\">\r\n                            <span class=\"caret up\"></span>\r\n                            <span class=\"caret down\"></span>\r\n                            <div class=clear-fix></div>\r\n                        </div>\r\n                        <ul class=\"down-menu down-menu-button\" id=\"\">\r\n                            <!--li-->\r\n                        </ul>\r\n                    </div>\r\n                </div>\r\n                <div class=\"input-url input-url-hide\">\r\n                    <div class=giua>\r\n                        <div class=url-link>\r\n                            <div class=thongso>\r\n                                <span class=url>{language.wpanel.controls.url.title}</span>\r\n                                <span class=value>\r\n                                    <input type=text value=\"\" class=input-external>\r\n                                </span>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <!-- <div class=\"tren\" id=\"action-redirect-page\" style=\"border-top: 1px solid #eee;\">\r\n                    <div class=\"trai\">\r\n                        <input type=\"radio\" class=\"check-action-page\" name=\"redirect-page\" style=\"margin-right: 5px;\"/>\r\n                        <span>{language.wpanel.controls.actions.title}</span>\r\n                    </div>\r\n                    <div class=\"phai\">\r\n                        <button type=\"\" value=\"\" class=\"action-button-link\" id=\"\"></button>\r\n                        <div class=\"arrows arrows-button\">\r\n                            <span class=\"caret up\"></span>\r\n                            <span class=\"caret down\"></span>\r\n                            <div class=\"clear-fix\"></div>\r\n                        </div>\r\n                        <ul class=\"down-menu-action-button\" id=\"\">\r\n                        </ul>\r\n                    </div>\r\n                </div> -->\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <script>$(document).on(\"click\",\".owp-button\",function(){$(\"ul.down-menu-button\").toggleClass(\"hienlen\")}),$(document).on(\"click\",\".arrows-button\",function(){$(\"ul.down-menu-button\").toggleClass(\"hienlen\")}),$(document).on(\"click\",\".external-url\",function(){$(\".input-url\").removeClass(\"input-url-hide\")}),$(document).on(\"click\",\".link-page\",function(){$(\".input-url\").addClass(\"input-url-hide\")}),$(document).on(\"click\",\".action-button-link\",function(){$(\"ul.down-menu-action-button\").toggleClass(\"hienlen\")})</script>\r\n\r\n    <!--Video action-->\r\n    <div id=VideoOptionControl>\r\n        <div class=\"widget-action action-video\">\r\n            <div class=video-content-container>\r\n                <div class=wg-info>\r\n                    <div class=widget-label>\r\n                        [TITLE]\r\n                    </div>\r\n                    <div class=\"item_1 basic-spacer\">\r\n                        <input type=text value=\"\" class=input-url-link-video>\r\n                    </div>\r\n                    <div class=item_1>\r\n                        <p class=\"widget__label widget__label--cs\">{language.wpanel.controls.widget_label.title}</p>\r\n                    </div>\r\n                </div>\r\n                <hr class=hr--cs>\r\n                <div class=\"widget-info bottom\">\r\n                    <div class=item_2-4>\r\n                        <div class=widget__box>\r\n                            <span class=box__label>{language.wpanel.controls.play_icon.title}</span>\r\n                            <div class=box__action>\r\n                                <div class=dropdown--custom>\r\n                                    <button class=\"type dropdown--toggle\">\r\n                                        <span>{language.wpanel.controls.round_solid.title}</span>\r\n                                        <div class=arrows>\r\n                                            <span class=\"caret up\"></span>\r\n                                            <span class=\"caret down\"></span>\r\n                                            <div class=clear-fix></div>\r\n                                        </div>\r\n                                    </button>\r\n                                    <ul class=\"dropdown-menu dropdown-menu-type\">\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.round_solid.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.round_outline.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.rectangle_solid.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.rectangle_outline.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.square_solid.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.square_outline.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.arrow_only.title}</a>\r\n                                        </li>\r\n                                    </ul>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class=widget__box>\r\n                            <span class=box__label>{language.wpanel.controls.play_icon_color.title}</span>\r\n                            <div class=box__action>\r\n                                <div class=dropdown--custom>\r\n                                    <button class=\"color dropdown--toggle\">\r\n                                        <span>{language.wpanel.controls.light.title}</span>\r\n                                        <div class=arrows>\r\n                                            <span class=\"caret up\"></span>\r\n                                            <span class=\"caret down\"></span>\r\n                                            <div class=clear-fix></div>\r\n                                        </div>\r\n                                    </button>\r\n                                    <ul class=\"dropdown-menu dropdown-menu-color\">\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.light.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.dark.title}</a>\r\n                                        </li>\r\n                                    </ul>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class=widget__box style=margin-bottom:40px>\r\n                            <span class=box__label>{language.wpanel.controls.play_icon_size.title}</span>\r\n                            <div class=box__action>\r\n                                <div class=dropdown--custom>\r\n                                    <button class=\"size dropdown--toggle\">\r\n                                        <span>{language.wpanel.controls.value.title}</span>\r\n                                        <div class=arrows>\r\n                                            <span class=\"caret up\"></span>\r\n                                            <span class=\"caret down\"></span>\r\n                                            <div class=clear-fix></div>\r\n                                        </div>\r\n                                    </button>\r\n                                    <ul class=\"dropdown-menu dropdown-menu-size\">\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.value.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.value_55.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.value_60.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.value_65.title}</a>\r\n                                        </li>\r\n                                        <li class=item-drop>\r\n                                            <a>{language.wpanel.controls.value_70.title}</a>\r\n                                        </li>\r\n                                    </ul>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=item_2-4>\r\n                        <div class=video-square>\r\n                            <img title=\"Play icon preview\" src=" + __webpack_require__(211) + ">\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <script>$(document).on(\"click\",\".dropdown--toggle\",function(){var o=$(this).closest(\".dropdown--custom\").find(\".dropdown-menu\");o.is(\":visible\")?o.show():($(\".dropdown-menu:visible\").hide(),o.hide()),$(this).closest(\".dropdown--custom\").addClass(\"visible\"),$(\".dropdown--toggle\").removeClass(\"change-bg\"),$(this).addClass(\"change-bg\")}),$(document).click(function(o){0==$(o.target).closest(\".dropdown-menu\").length&&0==$(o.target).closest(\".dropdown--toggle\").length&&($(\".dropdown-menu:visible\").show(),$(\".dropdown--custom\").removeClass(\"visible\"),$(\".dropdown--toggle\").removeClass(\"change-bg\"))})</script>\r\n\r\n    <!--html-->\r\n    <div id=HtmlOptionControl>\r\n        <div class=\"widget-section action-html align-items-top control-[ID]\">\r\n            <div>\r\n                <div class=\"widget-section-1 _1khoi\">\r\n                    <textarea class=\"p-2 html-input\" style=\"margin:12px;width:calc(100% - 24px);height:calc(100% - 24px);height:150px\">[HTML]</textarea>\r\n                </div>\r\n                <!-- end _1khoi-->\r\n                <div class=\"widget-section-2 _1khoi\">\r\n                    <div class=widget-desc>\r\n                        <h3 class=widget-label>{language.wpanel.controls.des_label.title}</h3>\r\n                        <p class=widget-label-des>{language.wpanel.controls.des_widget_label.title}</p>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>";

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = "<div style=display:none>\r\n    <!--Center Logo-->\r\n    <div id=CenterLogoWidget>\r\n        <div class=\"_1content widget-video\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n              <div class=image-drag>\r\n                  <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                    <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 90.2 72\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect x=0.6 y=61.8 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=0.6 y=25 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=0.6 y=32.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=0.6 y=69.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect x=25 width=40.7 height=13.31 rx=5.2 style=fill:#999 /><rect y=41.4 width=40.7 height=13.31 style=fill:#b7b7b7 /><rect x=49.5 y=41.4 width=40.7 height=13.31 style=fill:#b7b7b7 /></g></g></svg>\r\n                  </div>\r\n              </div>\r\n               <div class=\"body__title body__title--cs ng-binding\">{language.center_logo}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=CenterLogoWidgetContent>\r\n        <p builder-element style=text-align:center;margin:0>\r\n            <img builder-element=\"\" src=" + __webpack_require__(212) + " width=200px class=\"\">\r\n        </p>\r\n    </div>\r\n\r\n    <!--Textarea Field-->\r\n    <div id=YoutubeWidget>\r\n        <div class=\"_1content widget-video\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n              <div class=image-drag>\r\n                  <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                      <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 83.5 83.5\"><defs><style>.cls-1{fill:#b7b7b7}</style></defs><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><polygon class=cls-1 points=\"23.93 45.27 26.95 45.27 26.95 60.28 29.87 60.28 29.87 45.27 32.89 45.27 32.89 42.71 23.93 42.71 23.93 45.27\"/><path class=cls-1 d=M41.86,32.79a1.36,1.36,0,0,0,1-.32,1.23,1.23,0,0,0,.35-.91V23.78A.9.9,0,0,0,42.8,23a1.41,1.41,0,0,0-.94-.3A1.23,1.23,0,0,0,41,23a.91.91,0,0,0-.34.75v7.78a1.26,1.26,0,0,0,.32.91A1.17,1.17,0,0,0,41.86,32.79Z /><path class=cls-1 d=M48.3,47.16a2.49,2.49,0,0,0-1.19.31,4,4,0,0,0-1.11.9V42.71H43.38V60.28H46v-1a3.35,3.35,0,0,0,1.11.88,3,3,0,0,0,1.35.28,2.14,2.14,0,0,0,1.76-.73,3.22,3.22,0,0,0,.61-2.11v-7.2A3.81,3.81,0,0,0,50.18,48,2.24,2.24,0,0,0,48.3,47.16Zm-.14,10.09a1.38,1.38,0,0,1-.22.89.83.83,0,0,1-.7.28,1.52,1.52,0,0,1-.63-.14,2.17,2.17,0,0,1-.61-.46V49.74a1.8,1.8,0,0,1,.53-.39,1.23,1.23,0,0,1,.55-.13,1,1,0,0,1,.81.33,1.59,1.59,0,0,1,.27,1Z /><path class=cls-1 d=M38.84,57.17a3.5,3.5,0,0,1-.81.69,1.47,1.47,0,0,1-.72.27.63.63,0,0,1-.53-.2,1.14,1.14,0,0,1-.16-.66v-10H34V58.16a2.83,2.83,0,0,0,.45,1.74,1.65,1.65,0,0,0,1.36.57,3.12,3.12,0,0,0,1.5-.41,5.61,5.61,0,0,0,1.5-1.2v1.42h2.59v-13H38.84v9.85Z /><path class=cls-1 d=M41.75,0A41.75,41.75,0,1,0,83.5,41.75,41.75,41.75,0,0,0,41.75,0ZM48.5,20.62h2.91v11a1.16,1.16,0,0,0,.19.73.69.69,0,0,0,.59.24,1.76,1.76,0,0,0,.82-.31,3.76,3.76,0,0,0,.89-.77V20.62h2.92V34.9H53.9V33.33a6,6,0,0,1-1.68,1.32,3.56,3.56,0,0,1-1.69.46A1.82,1.82,0,0,1,49,34.47a3,3,0,0,1-.51-1.91ZM37.66,23.89a3.27,3.27,0,0,1,1.18-2.65,4.82,4.82,0,0,1,3.17-1,4.32,4.32,0,0,1,3,1A3.44,3.44,0,0,1,46.13,24v7.38A3.71,3.71,0,0,1,45,34.22a4.48,4.48,0,0,1-3.13,1,4.34,4.34,0,0,1-3.06-1.07,3.82,3.82,0,0,1-1.15-2.9v-7.4Zm-7.95-8.35,2.14,7.74h.2l2-7.74h3.34L33.6,26.87v8H30.32V27.23L26.4,15.54ZM67.93,56.29a9.36,9.36,0,0,1-9.36,9.36H26.06a9.36,9.36,0,0,1-9.36-9.36V48.77a9.36,9.36,0,0,1,9.36-9.36H58.57a9.36,9.36,0,0,1,9.36,9.36Z /><path class=cls-1 d=M56.13,47a3.92,3.92,0,0,0-2.84,1.06,3.67,3.67,0,0,0-1.1,2.74v5.83a4.15,4.15,0,0,0,1,2.94,3.58,3.58,0,0,0,2.74,1.07,3.85,3.85,0,0,0,2.91-1,4.15,4.15,0,0,0,1-3V56H57.15v.59A2.86,2.86,0,0,1,56.9,58a1,1,0,0,1-.9.34,1,1,0,0,1-.88-.39,2.86,2.86,0,0,1-.25-1.43V54.11h5V50.8a3.93,3.93,0,0,0-1-2.82A3.65,3.65,0,0,0,56.13,47Zm1,5.1H54.86V50.79a1.94,1.94,0,0,1,.27-1.17,1,1,0,0,1,.89-.35,1,1,0,0,1,.86.35,1.94,1.94,0,0,1,.27,1.17V52.1Z /></g></g></svg>\r\n                  </div>\r\n              </div>\r\n               <div class=\"body__title body__title--cs ng-binding\">{language.youtube}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=YoutubeWidgetContent>\r\n        <div class=video-container f-role=placeholder>\r\n            <div class=\"video-wrap video-placeholder\">\r\n                <a class=\"remove remove-content-widget\"><i class={builder-icon-times-circle}></i></a>\r\n                <img style=width:100px;opacity:.6 src=\"data:image/png;base64,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\"/>\r\n                <div class=description>{language.youtube_video}</div>\r\n                <button class=\"btn btn-dafault button-add-youtube\">{language.youtube_video.add_button}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Textarea Field-->\r\n    <div id=TextareaFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:30px;display:inline-block>article</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.textarea}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=TextareaFieldWidgetContent>\r\n        <div builder-element=TextareaFieldElement class=form-group>\r\n            <label builder-element builder-inline-edit for=\"\" class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <textarea [field_required] name=[FIELD_NAME] class=form-control placeholder=[FIELD_PLACEHOLDER]></textarea>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Checkbox Field-->\r\n    <div id=CheckboxFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:30px;display:inline-block>check_box</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.checkbox}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=CheckboxFieldWidgetContent>\r\n        <div builder-element=CheckboxFieldElement class=form-group>\r\n            <label for=exampleFormControlSelect1 class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <div class=inputs-group>\r\n                [FIELD_OPTIONS]\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Multiselect Field-->\r\n    <div id=MultiselectFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:25px;display:inline-block>done_all</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.multiselect}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=MultiselectFieldWidgetContent>\r\n        <div builder-element=MultiselectFieldElement class=form-group>\r\n            <label builder-element builder-inline-edit for=\"\" class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <select [field_required] name=[FIELD_NAME] class=form-select multiple=multiple>\r\n                [FIELD_OPTIONS]\r\n            </select>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Submit Button-->\r\n    <div id=SubmitButtonWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons style=font-size:30px;display:inline-block>smart_button</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>{language.wpanel.widgets.submit_button}</span><span class=\"small text-muted hide\">{language.wpanel.widgets.button}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=SubmitButtonWidgetContent>\r\n        <div builder-element class=form-group>\r\n            <button builder-element type=submit data-style=style_1 class=\"btn btn-primary mr-2\">{language.wpanel.widgets.button.submit}</button>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Number Field-->\r\n    <div id=NumberFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:30px;display:inline-block>looks_5</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.number}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=NumberFieldWidgetContent>\r\n        <div builder-element=NumberFieldElement class=form-group>\r\n            <label builder-element builder-inline-edit for=\"\" class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <input [field_required] name=[FIELD_NAME] type=number class=form-control placeholder=[FIELD_PLACEHOLDER]>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Ip Field-->\r\n    <div id=IpFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:30px;display:inline-block>router</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.ip_address}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=IpFieldWidgetContent>\r\n        <div builder-element=IpFieldElement class=form-group>\r\n            <label builder-element builder-inline-edit for=\"\" class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <input [field_required] name=[FIELD_NAME] type=text class=form-control placeholder=[FIELD_PLACEHOLDER]>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Rating Field-->\r\n    <div id=RatingFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:30px;display:inline-block>star_half</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.rating}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=RatingFieldWidgetContent>\r\n        <div builder-element=RatingFieldElement class=form-group>\r\n            <label builder-element builder-inline-edit for=\"\" class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <span class=\"small d-block mt-0\">\r\n                <span class=\"rating rating-[FIELD_ID] hoverable\">\r\n                    <input type=hidden value=3 name=[FIELD_NAME] class=rating-input>\r\n                    <span class=\"material-icons pr-1 remove-rate\" data-star=0 style=color:#d84315>\r\n                    remove_circle\r\n                    </span>\r\n\r\n                            <span class=material-icons data-star=1 data-rate=star style=color:#fbbc05>star</span>\r\n\r\n                            <span class=material-icons data-star=2 data-rate=star style=color:#fbbc05>star</span>\r\n\r\n                            <span class=material-icons data-star=3 data-rate=star style=color:#fbbc05>star</span>\r\n\r\n                            <span class=material-icons data-star=4 data-rate=star_outline style=color:#fbbc05>star_outline</span>\r\n\r\n                            <span class=material-icons data-star=5 data-rate=star_outline style=color:#fbbc05>star_outline</span>\r\n                </span>                  \r\n            </span>\r\n            [SCRIPT]\r\n        </div>\r\n    </div>\r\n\r\n    <!--Radio Field-->\r\n    <div id=RadioFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:30px;display:inline-block>radio_button_checked</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.radio}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=RadioFieldWidgetContent>\r\n        <div builder-element=RadioFieldElement class=form-group>\r\n            <label for=exampleFormControlSelect1 class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <div class=inputs-group>\r\n                [FIELD_OPTIONS]\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Date Field-->\r\n    <div id=DateFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:30px;display:inline-block>today</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.date}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=DateFieldWidgetContent>\r\n        <div builder-element=DateFieldElement class=form-group>\r\n            <label for=exampleFormControlInput1 class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <div class=\"input-group date\">\r\n                <input [field_required] type=text class=\"form-control date-control\" name=[FIELD_NAME] placeholder=[FIELD_PLACEHOLDER]>\r\n                <span class=input-group-addon style=position:absolute;right:7px;top:4px;pointer-events:none>\r\n                    <svg xmlns=http://www.w3.org/2000/svg xmlns:xlink=http://www.w3.org/1999/xlink aria-hidden=true focusable=false width=1.26em height=1.26em style=-ms-transform:rotate(360deg);-webkit-transform:rotate(360deg);transform:rotate(360deg) preserveAspectRatio=\"xMidYMid meet\" viewBox=\"0 0 16 16\"><g fill=currentColor><path d=\"M6.445 11.688V6.354h-.633A12.6 12.6 0 0 0 4.5 7.16v.695c.375-.257.969-.62 1.258-.777h.012v4.61h.675zm1.188-1.305c.047.64.594 1.406 1.703 1.406c1.258 0 2-1.066 2-2.871c0-1.934-.781-2.668-1.953-2.668c-.926 0-1.797.672-1.797 1.809c0 1.16.824 1.77 1.676 1.77c.746 0 1.23-.376 1.383-.79h.027c-.004 1.316-.461 2.164-1.305 2.164c-.664 0-1.008-.45-1.05-.82h-.684zm2.953-2.317c0 .696-.559 1.18-1.184 1.18c-.601 0-1.144-.383-1.144-1.2c0-.823.582-1.21 1.168-1.21c.633 0 1.16.398 1.16 1.23z\"/><path fill-rule=evenodd d=\"M1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1zm1-3a2 2 0 0 0-2 2v11a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H2z\"/><path fill-rule=evenodd d=\"M3.5 0a.5.5 0 0 1 .5.5V1a.5.5 0 0 1-1 0V.5a.5.5 0 0 1 .5-.5zm9 0a.5.5 0 0 1 .5.5V1a.5.5 0 0 1-1 0V.5a.5.5 0 0 1 .5-.5z\"/></g></svg>\r\n                </span>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Datetime Field-->\r\n    <div id=DatetimeFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:30px;display:inline-block>today</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.date}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=DatetimeFieldWidgetContent>\r\n        <div builder-element=DateFieldElement class=form-group>\r\n            <label for=exampleFormControlInput1 class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <div class=\"input-group date\">\r\n                <label for=exampleFormControlInput1 class=font-weight-bold>[FIELD_LABEL]</label>\r\n                <div class=\"input-group date\">\r\n                    <input [field_required] type=text class=\"form-control datetime-control\" name=[FIELD_NAME] placeholder=[FIELD_PLACEHOLDER]>\r\n                    <span class=input-group-addon style=position:absolute;right:7px;top:4px;pointer-events:none>\r\n                        <svg xmlns=http://www.w3.org/2000/svg xmlns:xlink=http://www.w3.org/1999/xlink aria-hidden=true focusable=false width=1.26em height=1.26em style=-ms-transform:rotate(360deg);-webkit-transform:rotate(360deg);transform:rotate(360deg) preserveAspectRatio=\"xMidYMid meet\" viewBox=\"0 0 16 16\"><g fill=currentColor><path d=\"M6.445 11.688V6.354h-.633A12.6 12.6 0 0 0 4.5 7.16v.695c.375-.257.969-.62 1.258-.777h.012v4.61h.675zm1.188-1.305c.047.64.594 1.406 1.703 1.406c1.258 0 2-1.066 2-2.871c0-1.934-.781-2.668-1.953-2.668c-.926 0-1.797.672-1.797 1.809c0 1.16.824 1.77 1.676 1.77c.746 0 1.23-.376 1.383-.79h.027c-.004 1.316-.461 2.164-1.305 2.164c-.664 0-1.008-.45-1.05-.82h-.684zm2.953-2.317c0 .696-.559 1.18-1.184 1.18c-.601 0-1.144-.383-1.144-1.2c0-.823.582-1.21 1.168-1.21c.633 0 1.16.398 1.16 1.23z\"/><path fill-rule=evenodd d=\"M1 4v10a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1V4H1zm1-3a2 2 0 0 0-2 2v11a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V3a2 2 0 0 0-2-2H2z\"/><path fill-rule=evenodd d=\"M3.5 0a.5.5 0 0 1 .5.5V1a.5.5 0 0 1-1 0V.5a.5.5 0 0 1 .5-.5zm9 0a.5.5 0 0 1 .5.5V1a.5.5 0 0 1-1 0V.5a.5.5 0 0 1 .5-.5z\"/></g></svg>\r\n                    </span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Text Field-->\r\n    <div id=TextFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:30px;display:inline-block>text_format</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.text}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=TextFieldWidgetContent>\r\n        <div builder-element=TextFieldElement class=form-group>\r\n            <label builder-element builder-inline-edit for=\"\" class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <input [field_required] name=[FIELD_NAME] type=text class=form-control placeholder=[FIELD_PLACEHOLDER]>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Email Field-->\r\n    <div id=EmailFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:25px;display:inline-block>mail</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">Email</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=EmailFieldWidgetContent>\r\n        <div builder-element=EmailFieldElement class=form-group>\r\n            <label builder-element builder-inline-edit for=\"\" class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <input [field_required] name=[FIELD_NAME] type=email class=form-control placeholder=[FIELD_PLACEHOLDER]>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Dropdown Field-->\r\n    <div id=DropdownFieldWidget>\r\n        <div class=form-element-widget>\r\n            <span class=icon>\r\n                <i class=material-icons-outlined style=font-size:25px;display:inline-block>kitchen</i>\r\n            </span>\r\n            <span class=\"field-label mb-0\"><span class=label>[FIELD_LABEL]</span><span class=\"small text-muted hide\">{language.wpanel.widgets.dropdown}</span></span>\r\n        </div>\r\n    </div>\r\n    <div id=DropdownFieldWidgetContent>\r\n        <div builder-element=DropdownFieldElement class=form-group>\r\n            <label builder-element builder-inline-edit for=\"\" class=font-weight-bold>[FIELD_LABEL]</label>\r\n            <select [field_required] name=[FIELD_NAME] class=form-select>\r\n                [FIELD_OPTIONS]\r\n            </select>\r\n        </div>\r\n    </div>\r\n\r\n    <!--table-->\r\n    <div id=Table5Widget>\r\n        <div class=\"_1content widget-table\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.9 81.8\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=14.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect x=0.8 y=26.5 width=88.4 height=54.64 rx=2.4 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=0.8 y1=39.6 x2=89.2 y2=39.6 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=0.8 y1=59.6 x2=89.2 y2=59.6 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><path d=M3.9,26.5H86a3.1,3.1,0,0,1,3.1,3.1v10a0,0,0,0,1,0,0H.8a0,0,0,0,1,0,0v-10A3.1,3.1,0,0,1,3.9,26.5Z style=fill:#e6e6e6;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=14.9 y1=39.7 x2=14.9 y2=81.2 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=75.9 y1=38.9 x2=75.9 y2=80.4 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=55.5 y1=39.6 x2=55.5 y2=81.1 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=35.2 y1=40.5 x2=35.2 y2=80.4 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.table5.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=Table5WidgetContent>\r\n        <div builder-element=TableBlockElement>\r\n            <table class=table style=\"\">\r\n                <thead>\r\n                    <tr builder-element>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.hashtag.title}</span></th>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.first_name.title}</span></th>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.last_name.title}</span></th>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.username.title}</span></th>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.other.title}</span></th>\r\n                    </tr>\r\n                </thead>\r\n                <tbody>\r\n                    <tr builder-element>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.one.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.mark.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.otto.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.modo.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.other.title}</span></td>\r\n                    </tr>\r\n                    <tr builder-element>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.two.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.jacob.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.thornton.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.fat.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.other.title}</span></td>\r\n                    </tr>\r\n                    <tr builder-element>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.three.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.larry.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.bird.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.twitter.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.other.title}</span></td>\r\n                    </tr>\r\n                </tbody>\r\n            </table>\r\n        </div>\r\n    </div>\r\n\r\n    <!--table-->\r\n    <div id=Table4Widget>\r\n        <div class=\"_1content widget-table\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.9 81.8\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=14.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect x=0.8 y=26.5 width=88.4 height=54.64 rx=2.4 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=0.8 y1=39.6 x2=89.2 y2=39.6 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=0.8 y1=59.6 x2=89.2 y2=59.6 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><path d=M3.9,26.5H86a3.1,3.1,0,0,1,3.1,3.1v10a0,0,0,0,1,0,0H.8a0,0,0,0,1,0,0v-10A3.1,3.1,0,0,1,3.9,26.5Z style=fill:#e6e6e6;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=18.1 y1=38.9 x2=18.1 y2=80.4 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=72.9 y1=38.9 x2=72.9 y2=80.4 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=45.5 y1=39.6 x2=45.5 y2=81.1 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.table4.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=Table4WidgetContent>\r\n        <div builder-element=TableBlockElement>\r\n            <table class=table style=\"\">\r\n                <thead>\r\n                    <tr builder-element>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.hashtag.title}</span></th>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.first_name.title}</span></th>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.last_name.title}</span></th>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.username.title}</span></th>\r\n                    </tr>\r\n                </thead>\r\n                <tbody>\r\n                    <tr builder-element>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.one.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.mark.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.otto.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.modo.title}</span></td>\r\n                    </tr>\r\n                    <tr builder-element>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.two.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.jacob.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.thornton.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.fat.title}</span></td>\r\n                    </tr>\r\n                    <tr builder-element>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.three.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.larry.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.bird.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.twitter.title}</span></td>\r\n                    </tr>\r\n                </tbody>\r\n            </table>\r\n        </div>\r\n    </div>\r\n\r\n    <!--table-->\r\n    <div id=TableWidget>\r\n        <div class=\"_1content widget-table\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.9 81.8\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=14.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect x=0.8 y=26.5 width=88.4 height=54.64 rx=2.4 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=0.8 y1=39.6 x2=89.2 y2=39.6 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=0.8 y1=59.6 x2=89.2 y2=59.6 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><path d=M3.9,26.5H86a3.1,3.1,0,0,1,3.1,3.1v10a0,0,0,0,1,0,0H.8a0,0,0,0,1,0,0v-10A3.1,3.1,0,0,1,3.9,26.5Z style=fill:#e6e6e6;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=25 y1=39.6 x2=25 y2=81.1 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /><line x1=64.1 y1=39.6 x2=64.1 y2=81.1 style=fill:none;stroke:#b7b7b7;stroke-miterlimit:10;stroke-width:1.5px /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.table.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=TableWidgetContent>\r\n        <div builder-element=TableBlockElement>\r\n            <table class=table style=\"\">\r\n                <thead>\r\n                    <tr builder-element>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.hashtag.title}</span></th>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.first_name.title}</span></th>\r\n                        <th><span builder-element builder-inline-edit>{language.wpanel.widgets.table.last_name.title}</span></th>\r\n                    </tr>\r\n                </thead>\r\n                <tbody>\r\n                    <tr builder-element>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.one.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.mark.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.otto.title}</span></td>\r\n                    </tr>\r\n                    <tr builder-element>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.two.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.jacob.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.thornton.title}</span></td>\r\n                    </tr>\r\n                    <tr builder-element>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.three.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.larry.title}</span></td>\r\n                        <td><span builder-element builder-inline-edit>{language.wpanel.widgets.table.bird.title}</span></td>\r\n                    </tr>\r\n                </tbody>\r\n            </table>\r\n        </div>\r\n    </div>\r\n\r\n    <!--button-->\r\n    <div id=ButtonWidget>\r\n        <div class=\"_1content widget-button\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg style=width:100% xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 224 180\"><defs><style>.a{fill:#e0e0e0}.b{fill:#939394}</style></defs><title>button</title><path class=a d=M44,66.5H180a8,8,0,0,1,8,8v38a8,8,0,0,1-8,8H44a8,8,0,0,1-8-8v-38A8,8,0,0,1,44,66.5Z /><path class=b d=M123.9,125.7l10.1.8-22-26v34.4l6.7-7.5,5.1,13.4a2.71,2.71,0,0,0,2.6,1.7c.3,0,.6-.1.9-.1a2.46,2.46,0,0,0,1.8-2.4,2.92,2.92,0,0,0-.2-.9Z /></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.button.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ButtonWidgetContent>\r\n        <div class=text-center>\r\n            <a builder-element=ButtonElement data-style=style_1 builder-inline-edit class=\"btn btn-primary btn-lg mr-2\" style=\"display:inline-block;font-weight:400;color:#fff;text-align:center;vertical-align:middle;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;background-color:transparent;border:1px solid transparent;padding:.375rem .75rem;font-size:1rem;line-height:1.5;border-radius:.25rem;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out;background-color:#2196f3;border-color:#2196f3\">{language.wpanel.widgets.button.title}</a>\r\n        </div>\r\n    </div>\r\n\r\n    <!--button-->\r\n    <div id=Button2Widget>\r\n        <div class=\"_1content widget-button\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg xmlns:xlink=http://www.w3.org/1999/xlink version=1.1 id=Layer_1 x=0px y=0px viewBox=\"0 0 87.9 59.5\" style=\"enable-background:new 0 0 87.9 59.5\" xml:space=preserve>\r\n                            <style type=text/css>.st0{fill:#cfcfcf}.st1{fill:#f2f2f2}.st2{fill:#bababa}</style>\r\n                            <g id=Layer_2_1_>\r\n                                <g id=Layer_1-2>\r\n                                    <path class=st0 d=M6.6,0h74.7c3.6,0,6.6,3,6.6,6.6v17.9c0,3.6-3,6.6-6.6,6.6H6.6c-3.6,0-6.6-3-6.6-6.6V6.6C0,3,3,0,6.6,0z />\r\n                                    <rect x=23.5 y=7.8 class=st1 width=44.3 height=7.7 />\r\n                                    <rect x=23.5 y=19.4 class=st1 width=44.3 height=3.2 />\r\n                                    <path class=st2 d=M53.9,19.4l0.9,40.1l10.7-13.2h16.3L53.9,19.4z />\r\n                                </g>\r\n                            </g>\r\n                        </svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.button_2.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=Button2WidgetContent>\r\n        <div class=text-center>\r\n            <a builder-element=ButtonElement data-style=style_1 builder-inline-edit class=\"btn btn-primary btn-lg mr-2\" style=\"display:inline-block;font-weight:400;color:#fff;text-align:center;vertical-align:middle;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;background-color:transparent;border:1px solid transparent;padding:.375rem 1.5rem;font-size:1rem;line-height:1.5;border-radius:.25rem;transition:color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out;background-color:#2196f3;border-color:#2196f3\">\r\n                <div>{language.wpanel.widgets.button.title}</div>\r\n                <div class=small>{language.wpanel.widgets.button.second_line}</div>\r\n            </a>\r\n        </div>\r\n    </div>\r\n\r\n    <!--divider-->\r\n    <div id=DividerWidget>\r\n        <div class=\"_1content widget-divider\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg style=width:100% xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 224 180\"><defs><style>.a{fill:#e0e0e0}.b{fill:#b7b7b7}</style></defs><title>divider</title><rect class=a x=48.2 y=37.5 width=128 height=44 /><rect class=b x=38.2 y=92.5 width=148 height=4 /><rect class=a x=48.2 y=107.5 width=128 height=44 /></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.divider.title}</div>\r\n             </div>\r\n        </div>\r\n    </div>\r\n    <div id=DividerWidgetContent>\r\n        <hr>\r\n    </div>\r\n\r\n    <!--image-->\r\n    <div id=ImageWidget>\r\n        <div class=\"_1content widget-image\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg style=width:100% viewBox=\"0 0 224 180\" xmlns=http://www.w3.org/2000/svg><defs><style>.a{fill:#e0e0e0}.b{fill:#b7b7b7}</style></defs><path class=a d=\"M48 48h128v94H48z\"/><path class=b d=\"M182 42v106H42V42h140m4-4H38v114h148V38z\"/><path class=b d=\"M48 112.1V142h128v-30l-20-20-22 20-44-41-42 41.1\"/><g id=blimpIcon><g id=Layer_1><g id=Group><g id=blimpIcon><g id=Layer_1><g id=Group stroke=#B5B5B5 fill=#B5B5B5><path d=\"M148.93 69.854c.428.71.428 1.628 0 2.338-2.733 4.615-10.053 5.237-15.208 5.118-5.383-.118-10.026-1.36-11.678-1.952-2.42-.888-4.984-2.338-6.864-4.172-.17-.148-.17-.385 0-.533 1.88-1.834 4.415-3.106 6.864-3.964 1.652-.593 6.295-1.836 11.678-1.954 5.155-.118 12.475.503 15.21 5.118z\" id=Shape stroke-width=.86 /><path d=\"M132.09 76.397c-1.014-.04-1.99-.083-2.93-.165v3.6h7.2v-3.518c-1.485.124-2.932.124-4.27.083z\" id=Shape stroke-width=.86 /><path d=\"M118.79 73.8l.32 3.6 2.096-.062c1.282-.042 2.44-.708 2.983-1.686M118.79 68.4l.32-3.6 2.096.062c1.282.042 2.44.708 2.983 1.686\" id=Shape stroke-width=.688 /></g></g></g></g></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.image.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ImageWidgetContent>\r\n        <div class=image-container f-role=placeholder>\r\n            <div class=\"image-wrap image-placeholder\">\r\n                <a class=\"remove remove-content-widget\"><i class={builder-icon-times-circle}></i></a>\r\n                <i class={builder-icon-images} style=font-size:40px></i>\r\n                <div class=description>{language.wpanel.widgets.des_image.title}</div>\r\n                <button class=\"btn btn-dafault browse-btn\">{language.wpanel.widgets.browse.title}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Text-->\r\n    <div id=TextWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 73.4\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=89.6 height=2.55 style=fill:#cacaca /><rect y=8.9 width=89.6 height=2.55 style=fill:#cacaca /><rect y=17.7 width=89.6 height=2.55 style=fill:#cacaca /><rect y=26.6 width=89.6 height=2.55 style=fill:#cacaca /><rect y=70.9 width=72.9 height=2.55 style=fill:#cacaca /><rect y=35.4 width=89.6 height=2.55 style=fill:#cacaca /><rect y=44.3 width=89.6 height=2.55 style=fill:#cacaca /><rect y=53.1 width=89.6 height=2.55 style=fill:#cacaca /><rect y=62 width=89.6 height=2.55 style=fill:#cacaca /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.text.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=TextWidgetContent>\r\n        <p builder-element builder-inline-edit>{language.wpanel.widgets.des_text.title}</p>\r\n    </div>\r\n\r\n    <!--BoxedText-->\r\n    <div id=BoxedTextWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 88.7 79.2\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=88.7 height=79.19 style=fill:#b7b7b7 /><rect x=8.7 y=11.7 width=71.2 height=2.55 style=fill:#fff /><rect x=8.7 y=20.6 width=71.2 height=2.55 style=fill:#fff /><rect x=8.7 y=64.9 width=57.9 height=2.55 style=fill:#fff /><rect x=8.8 y=29.5 width=71.2 height=2.55 style=fill:#fff /><rect x=8.8 y=38.3 width=71.2 height=2.55 style=fill:#fff /><rect x=8.8 y=47.2 width=71.2 height=2.55 style=fill:#fff /><rect x=8.8 y=56 width=71.2 height=2.55 style=fill:#fff /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.boxed_text.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=BoxedTextWidgetContent>\r\n        <p builder-element builder-inline-edit class=p-3 style=background-color:#eee>{language.wpanel.widgets.des_text.title}</p>\r\n    </div>\r\n\r\n    <!--pricing table-->\r\n    <div id=PricingTableWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.header.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 90.6 80.7\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect x=0.5 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=0.5 y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=0.5 y=29.7 width=32.2 height=48.51 rx=2.1 style=fill:#e6e6e6;stroke:#ccc;stroke-miterlimit:10 /><rect x=57.9 y=29.7 width=32.2 height=48.51 rx=2.2 style=fill:#e6e6e6;stroke:#ccc;stroke-miterlimit:10 /><rect x=24.3 y=20.9 width=43.2 height=59.32 rx=1.9 style=fill:#fff;stroke:#ccc;stroke-miterlimit:10 /><path d=M45.1,41.8v-2a7.3,7.3,0,0,1-3.6-.9l.7-2.4a8.1,8.1,0,0,0,3.5.9c1.1,0,2-.5,2-1.3s-.7-1.3-2.3-1.8-3.7-1.8-3.7-3.9a3.8,3.8,0,0,1,3.5-3.7v-2h2.1v1.8a8.8,8.8,0,0,1,3,.7l-.6,2.4a7.2,7.2,0,0,0-3-.7c-1.4,0-1.8.6-1.8,1.2s.7,1.1,2.5,1.8,3.5,2,3.5,3.9-1.3,3.5-3.7,3.9v2.1Z style=fill:#b7b7b7 /><rect x=34.5 y=48 width=22.7 height=2.71 style=fill:#b7b7b7 /><rect x=27.2 y=58 width=37.2 height=2.55 style=fill:#e2e2e2 /><rect x=27.2 y=65.3 width=37.2 height=2.55 style=fill:#e2e2e2 /><rect x=27.2 y=72.7 width=37.2 height=2.55 style=fill:#e2e2e2 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.pricing_table.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=PricingTableWidgetContent>\r\n        <div builder-element=PricingTableElement data-style=default style=margin:-7px;padding:7px>\r\n            <div class=\"row mx-0\" style=\"border-left:solid 1px #ccc\">\r\n                <div builder-element=\"\" class=\"p-3 pb-0 col-12\" style=\"border:solid 1px #ccc;border-left:none\">\r\n                <h3 builder-element=\"\" builder-inline-edit=\"\" class=font-weight-normal>Free</h3>\r\n                <p builder-element=\"\" builder-inline-edit=\"\" class=my-3>All the basics for businesses or individual to get started with email marketing campaign</p>\r\n                <div builder-element=TextElement builder-inline-edit=\"\" class=\"text-center mt-5\">Starting at</div>\r\n                <div builder-element=TextElement builder-inline-edit=\"\" class=\"display-4 text-center my-2\" style=font-size:40px;font-weight:400>$0</div>\r\n                <div builder-element=TextElement builder-inline-edit=\"\" class=text-center>1 month</div>\r\n                <div class=\"text-center my-3 mt-5\">\r\n                    <a builder-element=\"\" builder-inline-edit=\"\" href=\"\" data-style=style_1 class=\"btn btn-primary\" style=width:80%;background-color:#007c89>Select</a>\r\n                </div>\r\n                </div>\r\n                <div builder-element=\"\" class=\"p-3 pb-0 col-12\" style=\"border:solid 1px #ccc;border-left:none\">\r\n                <h3 builder-element=\"\" builder-inline-edit=\"\" class=font-weight-normal>Essentials</h3>\r\n                <p builder-element=\"\" builder-inline-edit=\"\" class=my-3>Must-have features for marketing agency &amp; individual to engage in email marketing</p>\r\n                <div builder-element=TextElement builder-inline-edit=\"\" class=\"text-center mt-5\">Starting at</div>\r\n                <div builder-element=TextElement builder-inline-edit=\"\" class=\"display-4 text-center my-2\" style=font-size:40px;font-weight:400>$28</div>\r\n                <div builder-element=TextElement builder-inline-edit=\"\" class=text-center>1 month</div>\r\n                <div class=\"text-center my-3 mt-5\">\r\n                    <a builder-element=\"\" builder-inline-edit=\"\" href=\"\" data-style=style_1 class=\"btn btn-primary\" style=width:80%;background-color:#007c89>Select</a>\r\n                </div>\r\n                </div>\r\n                <div builder-element=\"\" class=\"p-3 pb-0 col-12\" style=\"border:solid 1px #ccc;border-left:none\">\r\n                <h3 builder-element=\"\" builder-inline-edit=\"\" class=font-weight-normal>Premium</h3>\r\n                <p builder-element=\"\" builder-inline-edit=\"\" class=my-3>Advanced features for professionals who need unlimited marketing capability</p>\r\n                <div builder-element=TextElement builder-inline-edit=\"\" class=\"text-center mt-5\">Starting at</div>\r\n                <div builder-element=TextElement builder-inline-edit=\"\" class=\"display-4 text-center my-2\" style=font-size:40px;font-weight:400>$50</div>\r\n                <div builder-element=TextElement builder-inline-edit=\"\" class=text-center>1 month</div>\r\n                <div class=\"text-center my-3 mt-5\">\r\n                    <a builder-element=\"\" builder-inline-edit=\"\" href=\"\" data-style=style_1 class=\"btn btn-primary\" style=width:80%;background-color:#007c89>Select</a>\r\n                </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=SocialLinksBlockWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.header.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                    <svg style=width:100% width=224 height=180 viewBox=\"0 0 224 180\" fill=none xmlns=http://www.w3.org/2000/svg>\r\n                        <rect width=224 height=180 fill=white />\r\n                        <circle cx=165.756 cy=78.9806 r=24.2443 fill=#EBEBEB />\r\n                        <path fill-rule=evenodd clip-rule=evenodd d=\"M180.304 70.2949C179.436 70.683 178.488 70.8607 177.537 70.8138C178.13 70.4733 178.634 69.9987 179.009 69.428C179.385 68.8573 179.621 68.2065 179.699 67.5278C178.501 68.2863 177.187 68.8414 175.808 69.1708C175.289 68.0467 174.165 66.5767 170.793 66.9226C165.172 67.4414 165.172 72.9755 165.777 74.6185C163.295 74.4586 160.872 73.7932 158.656 72.6631C156.441 71.533 154.48 69.9621 152.893 68.0467C151.164 71.8514 152.893 75.2238 154.536 76.2615C153.749 76.3509 152.956 76.1678 152.288 75.7426C152.288 75.7426 151.682 80.6715 157.303 81.1903C156.778 81.4464 156.201 81.5794 155.617 81.5794C155.033 81.5794 154.456 81.4464 153.931 81.1903C154.449 83.4386 156.698 86.1192 160.07 85.6004C157.303 87.8486 154.536 88.3674 151.164 88.3674C154.006 90.1776 157.306 91.1377 160.675 91.1345C171.917 91.1345 177.451 82.055 177.451 74.0997C177.451 73.97 177.472 73.7754 177.494 73.5808C177.516 73.3863 177.537 73.1917 177.537 73.062C178.756 72.4927 179.735 71.5133 180.304 70.2949Z\" fill=#ADADAD />\r\n                        <circle cx=111.448 cy=44.069 r=24.2443 fill=#EBEBEB />\r\n                        <path fill-rule=evenodd clip-rule=evenodd d=\"M115.739 34.372H118.648V29.7174C117.291 29.6204 115.836 29.5234 114.478 29.5234C110.503 29.5234 107.981 31.8508 107.981 36.3114V40.1903H103.133V45.0389H107.981V58.6149H112.83V45.0389H117.679L118.648 40.1903H112.83V36.8933C112.83 35.4387 113.606 34.372 115.739 34.372Z\" fill=#ADADAD />\r\n                        <circle cx=57.6696 cy=78.9806 r=24.2443 fill=#EBEBEB />\r\n                        <g clip-path=url(#clip0)>\r\n                        <mask id=mask0 mask-type=alpha maskUnits=userSpaceOnUse x=43 y=64 width=30 height=30>\r\n                        <path d=\"M43.1211 64.4424H72.2051V93.5229H43.1211V64.4424Z\" fill=#ADADAD />\r\n                        </mask>\r\n                        <g mask=url(#mask0)>\r\n                        <path fill-rule=evenodd clip-rule=evenodd d=\"M57.6631 64.4424C53.7137 64.4424 53.2185 64.4591 51.6674 64.5299C50.1196 64.6005 49.0625 64.8463 48.1375 65.2058C47.1813 65.5774 46.3703 66.0747 45.5618 66.8831C44.7534 67.6916 44.2561 68.5026 43.8846 69.4588C43.525 70.3838 43.2792 71.4409 43.2086 72.9887C43.1378 74.5398 43.1211 75.035 43.1211 78.9844C43.1211 82.9337 43.1378 83.429 43.2086 84.98C43.2792 86.5278 43.525 87.585 43.8846 88.5099C44.2561 89.4662 44.7534 90.2772 45.5618 91.0857C46.3703 91.8941 47.1813 92.3913 48.1375 92.763C49.0625 93.1224 50.1196 93.3683 51.6674 93.4389C53.2185 93.5096 53.7137 93.5264 57.6631 93.5264C61.6125 93.5264 62.1077 93.5096 63.6587 93.4389C65.2066 93.3683 66.2637 93.1224 67.1886 92.763C68.1449 92.3913 68.9559 91.8941 69.7644 91.0857C70.5728 90.2772 71.07 89.4662 71.4417 88.5099C71.8011 87.585 72.047 86.5278 72.1176 84.98C72.1883 83.429 72.2051 82.9337 72.2051 78.9844C72.2051 75.035 72.1883 74.5398 72.1176 72.9887C72.047 71.4409 71.8011 70.3838 71.4417 69.4588C71.07 68.5026 70.5728 67.6916 69.7644 66.8831C68.9559 66.0747 68.1449 65.5774 67.1886 65.2058C66.2637 64.8463 65.2066 64.6005 63.6587 64.5299C62.1077 64.4591 61.6125 64.4424 57.6631 64.4424ZM57.6631 67.0626C61.546 67.0626 62.0059 67.0774 63.5393 67.1474C64.9571 67.212 65.7271 67.4489 66.2395 67.6481C66.9183 67.9119 67.4027 68.227 67.9116 68.7359C68.4205 69.2447 68.7356 69.7291 68.9994 70.4079C69.1986 70.9203 69.4355 71.6903 69.5001 73.1082C69.5701 74.6416 69.5849 75.1015 69.5849 78.9844C69.5849 82.8672 69.5701 83.3272 69.5001 84.8606C69.4355 86.2784 69.1986 87.0484 68.9994 87.5608C68.7356 88.2396 68.4205 88.724 67.9116 89.2329C67.4027 89.7418 66.9183 90.0569 66.2395 90.3207C65.7271 90.5198 64.9571 90.7567 63.5393 90.8214C62.0061 90.8914 61.5462 90.9062 57.6631 90.9062C53.7799 90.9062 53.3201 90.8914 51.7869 90.8214C50.369 90.7567 49.5991 90.5198 49.0866 90.3207C48.4079 90.0569 47.9234 89.7418 47.4146 89.2329C46.9057 88.724 46.5906 88.2396 46.3268 87.5608C46.1276 87.0484 45.8907 86.2784 45.8261 84.8606C45.7561 83.3272 45.7413 82.8672 45.7413 78.9844C45.7413 75.1015 45.7561 74.6416 45.8261 73.1082C45.8907 71.6903 46.1276 70.9203 46.3268 70.4079C46.5906 69.7291 46.9057 69.2447 47.4146 68.7359C47.9234 68.227 48.4079 67.9119 49.0866 67.6481C49.5991 67.4489 50.369 67.212 51.7869 67.1474C53.3203 67.0774 53.7802 67.0626 57.6631 67.0626Z\" fill=#ADADAD />\r\n                        </g>\r\n                        <path fill-rule=evenodd clip-rule=evenodd d=\"M57.6633 83.8329C54.9862 83.8329 52.816 81.6627 52.816 78.9856C52.816 76.3085 54.9862 74.1382 57.6633 74.1382C60.3404 74.1382 62.5106 76.3085 62.5106 78.9856C62.5106 81.6627 60.3404 83.8329 57.6633 83.8329ZM57.6633 71.5181C53.5391 71.5181 50.1958 74.8614 50.1958 78.9856C50.1958 83.1098 53.5391 86.4531 57.6633 86.4531C61.7875 86.4531 65.1308 83.1098 65.1308 78.9856C65.1308 74.8614 61.7875 71.5181 57.6633 71.5181Z\" fill=#ADADAD />\r\n                        <path fill-rule=evenodd clip-rule=evenodd d=\"M67.1707 71.2231C67.1707 72.1869 66.3894 72.9681 65.4257 72.9681C64.462 72.9681 63.6807 72.1869 63.6807 71.2231C63.6807 70.2593 64.462 69.478 65.4257 69.478C66.3894 69.478 67.1707 70.2593 67.1707 71.2231Z\" fill=#ADADAD />\r\n                        </g>\r\n                        <path d=\"M110.479 89.4727C100.705 89.4727 91.3319 93.3554 84.4209 100.266C77.51 107.177 73.6274 116.55 73.6274 126.324C73.6274 136.098 77.51 145.471 84.4209 152.382C91.3319 159.293 100.705 163.175 110.479 163.175C120.252 163.175 129.626 159.293 136.537 152.382C143.448 145.471 147.33 136.098 147.33 126.324C147.33 116.55 143.448 107.177 136.537 100.266C129.626 93.3554 120.252 89.4727 110.479 89.4727V89.4727ZM105.214 105.266H115.743V121.06H131.537V131.588H115.743V147.382H105.214V131.588H89.4209V121.06H105.214V105.266Z\" fill=#B9B9B9 />\r\n                        <defs>\r\n                        <clipPath id=clip0>\r\n                        <rect width=29.0932 height=29.0932 fill=white transform=\"translate(43.1211 64.4341)\"/>\r\n                        </clipPath>\r\n                        </defs>\r\n                        </svg>\r\n    \r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.social_block.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=SocialLinksBlockWidgetContent>\r\n        <div builder-element=IconsContainerElement class=\"d-flex justify-content-center\">\r\n            <a builder-element=IconLinkElement href=\"\" class=\"mr-3 me-3\">\r\n            <img src={{root}}image/facebook.png style=width:40px;height:40px;display:block;border-radius:100%;background-color:#fff />\r\n            </a>\r\n            <a builder-element=IconLinkElement builder-element href=\"\" class=\"mr-3 me-3\">\r\n            <img src={{root}}image/twitter.png style=width:40px;height:40px;display:block;border-radius:100%;background-color:#fff />\r\n            </a>\r\n            <a builder-element=IconLinkElement builder-element href=\"\" class=\"mr-3 me-3\">\r\n            <img src={{root}}image/instagram.png style=width:40px;height:40px;display:block;border-radius:100%;background-color:#fff />\r\n            </a>\r\n            <a builder-element=IconLinkElement builder-element href=\"\" class=\"mr-3 me-3\">\r\n                <img src={{root}}image/google-plus.png style=width:40px;height:40px;display:block;border-radius:100%;background-color:#fff />\r\n            </a>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=HeaderBlockWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.header.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 71\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=38 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=45.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=53.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=60.8 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=68.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect width=89.6 height=28.43 rx=0.3 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.header.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=HeaderBlockWidgetContent>\r\n        <table width=100%>\r\n            <tr>\r\n                <td class=text-left>\r\n                <img builder-element src=" + __webpack_require__(213) + " width=200px />\r\n                </td>\r\n                <td class=\"text-right pr-2\">\r\n                <a builder-element builder-inline-edit href=\"\" style=color:#333>Open in your browser</a>\r\n                </td>\r\n            </tr>\r\n        </table>\r\n    </div>\r\n    <div id=HeroImageWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.hero_image.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 79\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=46 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=40.2 y=2 width=48.5 height=2.55 style=fill:#e2e2e2 /><rect x=62.9 y=6.9 width=25.9 height=2.55 style=fill:#e2e2e2 /><rect y=53.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=61.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=68.8 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=76.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect width=29 height=10.43 rx=0.3 style=fill:#e2e2e2 /><rect y=15.4 width=89.6 height=24.81 style=fill:#dedede /><path d=M89.6,40.2H0V35.4l10.8-12L24.7,36.1l10.9-7.5,10.6,8.7,30.5.2Z style=fill:#b7b7b7 /><path d=M49.7,30.4c-.7.8-1.6.6-1.8,1.2a1.2,1.2,0,0,0,.7,1.3c.7.3,1.4-.7,2-.4s.3.7.6.9,1.6-.6,2.9-.7,2,1.5,3.7,1.5A3.4,3.4,0,0,0,61,31.5a3.7,3.7,0,0,0-2.6-3.6c-2-.5-3.2,1.5-5.4.9s-2-1.4-2.6-1.1S50.5,29.4,49.7,30.4Z style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.hero_image.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=HeroImageWidgetContent>\r\n        <img builder-element src={{root}}image/hero_banner.png width=100% />\r\n    </div>\r\n    <div id=IntroBlockWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.intro_block.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 81\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=55 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=29.9 width=89.6 height=3.38 style=fill:#b7b7b7 /><rect y=37.3 width=89.6 height=3.38 style=fill:#b7b7b7 /><rect y=62.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=70.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=78.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect width=89.6 height=10.43 rx=0.3 style=fill:#e2e2e2 /><rect x=23.7 y=18.5 width=45.4 height=7.06 style=fill:#b7b7b7 /><path d=M21.6,50.1c1.2-.6,10.6-5.5,13.7-3.2a2.4,2.4,0,0,1,.7,3.3c-1.1,1.3-4.3,1.4-5,.4s1.1-4.5,4.2-5.6,4.1,0,11.5,2.2c4.9,1.4,10.5,3,16.8,3,2.1,0,4.2-.1,4.9-1.2a2,2,0,0,0-.4-2.5,3.9,3.9,0,0,0-4.5.2 style=fill:none;stroke:#e2e2e2;stroke-miterlimit:10 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.intro_block.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=IntroBlockWidgetContent>\r\n        <div>\r\n            <h1 builder-element builder-inline-edit class=display-4 style=text-align:center>Lorem ipsum dolor</h1>\r\n            <h5 builder-element builder-inline-edit class=\"font-weight-normal mt-1 mb-3 text-muted\" style=text-align:center>Nunc pulvinar turpis sed pellentesque aliquet</h5>\r\n            <p builder-element builder-inline-edit class=\"\">Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque. Nunc pulvinar turpis sed pellentesque aliquet. Sed ullamcorper, tellus eu viverra tincidunt, quam justo pellentesque est, et gravida justo eros vitae turpis. Mauris molestie id nisi in ultrices. Curabitur tellus ex, pretium nec dui ut, feugiat semper ipsum. Donec porttitor congue blandit. Pellentesque in purus nulla. Integer ut turpis purus. Nunc nec efficitur nunc.</p>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=OneColumnBlockWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.intro_block.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.7 79.9\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=54.5 width=89.6 height=2.55 style=fill:#d5d5d5 /><rect y=62.1 width=89.6 height=2.55 style=fill:#d5d5d5 /><rect y=69.7 width=89.6 height=2.55 style=fill:#d5d5d5 /><rect y=77.3 width=72.9 height=2.55 style=fill:#d5d5d5 /><rect width=89.6 height=49.49 style=fill:#dedede /><path d=M89.6,49.5H0V40.3L29.9,12.2,56.3,41.3,75.4,23,89.7,37.7Z style=fill:#b7b7b7 /><path d=M53.2,11.5c-.9,1-2.3.8-2.5,1.7a1.6,1.6,0,0,0,1,1.8c1,.4,2-1,2.8-.5s.4.8.9,1.2,2.2-.9,4-1,2.9,2.1,5.2,2.2A5,5,0,0,0,69.2,13c.3-2.3-1.7-4.5-3.7-5s-4.4,2.1-7.6,1.2-2.8-2-3.6-1.5S54.4,10.1,53.2,11.5Z style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.one_col_block.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=OneColumnBlockWidgetContent>\r\n        <div>\r\n            <div class=text-center>\r\n                <img builder-element class=\"\" src=" + __webpack_require__(22) + " width=100% />\r\n            </div>\r\n            <h2 builder-element builder-inline-edit class=mt-3>Lorem ipsum dolor</h2>\r\n            <p builder-element builder-inline-edit>Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque.\r\n                Nunc pulvinar turpis sed pellentesque aliquet. Sed ullamcorper, tellus eu viverra tincidunt,\r\n                quam justo pellentesque est, et gravida justo eros vitae turpis. Mauris molestie id nisi in ultrices.\r\n                Curabitur tellus ex, pretium nec dui ut, feugiat semper ipsum. Donec porttitor congue blandit.\r\n                Pellentesque in purus nulla. Integer ut turpis purus. Nunc nec efficitur nunc.\r\n            </p>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=TwoColumnsBlockWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.two_col_block.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 78.5\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=64.1 width=41.6 height=2.27 style=fill:#d5d5d5 /><rect y=69.8 width=41.6 height=2.27 style=fill:#d5d5d5 /><rect y=76.3 width=33.8 height=2.27 style=fill:#d5d5d5 /><rect y=26 width=41.6 height=34.51 style=fill:#dedede /><path d=M41.6,60.5H0V54.1L17,34.9,34,54.1c2.5-3,5-6.1,7.6-9.1V60.5Z style=fill:#b7b7b7 /><path d=M29.3,34.4c-.6.8-1.5.6-1.7,1.2a1.2,1.2,0,0,0,.7,1.3c.7.3,1.3-.7,1.9-.4s.2.6.6.9,1.4-.7,2.7-.7,1.9,1.5,3.5,1.5a3.3,3.3,0,0,0,3-2.7A3.5,3.5,0,0,0,37.5,32c-1.8-.6-2.9,1.5-5.1.8s-1.9-1.3-2.4-1S30.1,33.5,29.3,34.4Z style=fill:#b7b7b7 /><rect x=48 y=64.1 width=41.6 height=2.27 style=fill:#d5d5d5 /><rect x=48 y=69.8 width=41.6 height=2.27 style=fill:#d5d5d5 /><rect x=48 y=76.3 width=33.8 height=2.27 style=fill:#d5d5d5 /><rect x=48 y=26 width=41.6 height=34.51 style=fill:#dedede /><path d=M89.6,60.5H48V54.1L65,34.9,82,54.1,89.6,45V60.5Z style=fill:#b7b7b7 /><path d=M77.3,34.4c-.6.8-1.5.6-1.7,1.2a1.2,1.2,0,0,0,.7,1.3c.7.3,1.3-.7,1.9-.4s.2.6.6.9,1.5-.7,2.7-.7,1.9,1.5,3.5,1.5a3.3,3.3,0,0,0,3-2.7A3.5,3.5,0,0,0,85.6,32c-1.9-.6-3,1.5-5.1.8s-1.9-1.3-2.5-1S78.1,33.5,77.3,34.4Z style=fill:#b7b7b7 /><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=14.4 width=72.9 height=2.55 style=fill:#e2e2e2 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.two_col_block.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=TwoColumnsBlockWidgetContent>\r\n        <div>\r\n            <div builder-element=CellContainerElement style=display:flex;flex-wrap:wrap data-layout=5-5>\r\n                <div style=\"flex:0 0 50%;max-width:50%\" builder-element=CellElement>\r\n\r\n                    <div builder-element=BlockElement style=padding-top:15px;padding-bottom:15px;padding-right:15px>\r\n                        <div class=container>\r\n                            <img builder-element builder-inline-edit class=my-2 src=" + __webpack_require__(1) + " width=100% />\r\n                            <h3 builder-element builder-inline-edit class=\"mt-2 mb-2\">Lorem ipsum dolor</h3>\r\n                            <p builder-element builder-inline-edit>Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque.\r\n                            Nunc pulvinar turpis sed pellentesque aliquet. Sed ullamcorper, tellus eu viverra tincidunt,\r\n                            quam justo p\r\n                        </p></div>\r\n                    </div>\r\n\r\n                </div>\r\n                <div style=\"flex:0 0 50%;max-width:50%\" builder-element=CellElement>\r\n                \r\n                    <div builder-element=BlockElement style=padding-top:15px;padding-bottom:15px;padding-left:15px>\r\n                        <div class=container>\r\n                            <img builder-element builder-inline-edit class=my-2 src=" + __webpack_require__(1) + " width=100% />\r\n                            <h3 builder-element builder-inline-edit class=\"mt-2 mb-2\">Lorem ipsum dolor</h3>\r\n                            <p builder-element builder-inline-edit>Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque.\r\n                            Nunc pulvinar turpis sed pellentesque aliquet. Sed ullamcorper, tellus eu viverra tincidunt,\r\n                            quam justo p\r\n                        </p></div>\r\n                    </div>\r\n\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=ThreeColumnsBlockWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.two_col_block.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.8 82\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect x=0.2 y=65 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=0.2 y=72.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=0.2 y=79.5 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect y=15 width=25.9 height=21.53 style=fill:#dedede /><path d=M25.9,36.5H0v-4l10.6-12,10.6,12,4.7-5.7v9.7Z style=fill:#b7b7b7 /><path d=M18.3,20.2c-.4.5-1,.4-1.1.8s.2.7.4.8.9-.5,1.2-.3.2.4.4.6.9-.4,1.7-.5,1.2,1,2.2,1A2.2,2.2,0,0,0,25,20.9a2.2,2.2,0,0,0-1.6-2.2c-1.2-.3-1.8.9-3.2.5s-1.1-.8-1.5-.6S18.8,19.6,18.3,20.2Z style=fill:#b7b7b7 /><rect x=32 y=15 width=25.9 height=21.53 style=fill:#dedede /><path d=M57.9,36.5H32v-4l10.6-12,10.6,12,4.7-5.7v9.7Z style=fill:#b7b7b7 /><path d=M50.3,20.2c-.4.5-1,.4-1.1.8s.2.7.4.8.9-.5,1.2-.3.2.4.4.6.9-.4,1.7-.5,1.2,1,2.2,1A2.2,2.2,0,0,0,57,20.9a2.2,2.2,0,0,0-1.6-2.2c-1.2-.3-1.8.9-3.2.5s-1.1-.8-1.5-.6S50.8,19.6,50.3,20.2Z style=fill:#b7b7b7 /><rect x=63.7 y=15 width=25.9 height=21.53 style=fill:#dedede /><path d=M89.6,36.5H63.7v-4l10.6-12,10.6,12,4.7-5.7v9.7Z style=fill:#b7b7b7 /><path d=M81.4,30.7c-.4.5-.9.3-1,.7a.7.7,0,0,0,.4.8c.4.2.8-.4,1.2-.2s.1.4.3.5,1-.4,1.7-.4,1.2.9,2.2.9a2,2,0,0,0,1.9-1.6,2.2,2.2,0,0,0-1.5-2.2c-1.2-.4-1.9.9-3.2.5s-1.2-.9-1.5-.7S81.9,30.1,81.4,30.7Z style=fill:#b7b7b7 /><rect x=0.3 y=41.3 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=0.3 y=47 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=0.3 y=53.5 width=20.8 height=2.27 style=fill:#d5d5d5 /><rect x=32.2 y=41.3 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=32.2 y=47 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=32.2 y=53.5 width=20.8 height=2.27 style=fill:#d5d5d5 /><rect x=63.8 y=41.3 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=63.8 y=47 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=63.8 y=53.5 width=20.8 height=2.27 style=fill:#d5d5d5 /><rect x=0.2 width=89.3 height=8.68 style=fill:#e8e8e8 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.three_col_block.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ThreeColumnsBlockWidgetContent>\r\n        <div>\r\n            <div builder-element=CellContainerElement style=display:flex;flex-wrap:wrap data-layout=4-4-4>\r\n                <div style=\"flex:0 0 33.333333%;max-width:33.333333%\" builder-element=CellElement>\r\n\r\n                    <div builder-element=BlockElement style=padding-top:15px;padding-bottom:15px;padding-right:10px>\r\n                        <div class=container>\r\n                            <img builder-element builder-inline-edit class=my-2 src=" + __webpack_require__(1) + " width=100% />\r\n                            <h3 builder-element builder-inline-edit class=\"mt-2 mb-2\">Lorem ipsum dolor</h3>\r\n                            <p builder-element builder-inline-edit>Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque.\r\n                            Nunc pulvinar turpis sed pellentesque aliquet. Sed ullamcorper, tellus eu viverra tincidunt,\r\n                            quam justo p\r\n                        </p></div>\r\n                    </div>\r\n\r\n                </div>\r\n                <div style=\"flex:0 0 33.333333%;max-width:33.333333%\" builder-element=CellElement>\r\n                \r\n                    <div builder-element=BlockElement style=padding-top:15px;padding-bottom:15px;padding-left:5px;padding-right:5px>\r\n                        <div class=container>\r\n                            <img builder-element builder-inline-edit class=my-2 src=" + __webpack_require__(1) + " width=100% />\r\n                            <h3 builder-element builder-inline-edit class=\"mt-2 mb-2\">Lorem ipsum dolor</h3>\r\n                            <p builder-element builder-inline-edit>Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque.\r\n                            Nunc pulvinar turpis sed pellentesque aliquet. Sed ullamcorper, tellus eu viverra tincidunt,\r\n                            quam justo p\r\n                        </p></div>\r\n                    </div>\r\n\r\n                </div>\r\n                <div style=\"flex:0 0 33.333333%;max-width:33.333333%\" builder-element=CellElement>\r\n                \r\n                    <div builder-element=BlockElement style=padding-top:15px;padding-bottom:15px;padding-left:10px>\r\n                        <div class=container>\r\n                            <img builder-element builder-inline-edit class=my-2 src=" + __webpack_require__(1) + " width=100% />\r\n                            <h3 builder-element builder-inline-edit class=\"mt-2 mb-2\">Lorem ipsum dolor</h3>\r\n                            <p builder-element builder-inline-edit>Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque.\r\n                            Nunc pulvinar turpis sed pellentesque aliquet. Sed ullamcorper, tellus eu viverra tincidunt,\r\n                            quam justo p\r\n                        </p></div>\r\n                    </div>\r\n\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=TwoArticlesBlockWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.two_article_block.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 90.1 82.4\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect x=46.5 y=25.7 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect x=46.5 y=32.8 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect x=46.5 y=39.9 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect x=46.5 y=46.9 width=35.5 height=2.38 style=fill:#d5d5d5 /><rect y=24.9 width=40.4 height=25.17 style=fill:#dedede /><path d=M40.4,50.1H0V45.4L13.5,31.1c3.9,5,7.9,9.9,11.9,14.8L34,36.6l6.4,7.5Z style=fill:#b7b7b7 /><path d=M24,30.8c-.4.5-1,.4-1.1.8a.8.8,0,0,0,.4.9c.5.2.9-.5,1.3-.2s.1.4.4.6,1-.5,1.8-.5,1.3,1.1,2.3,1.1a2.3,2.3,0,0,0,2.1-2A2.5,2.5,0,0,0,29.5,29c-1.2-.4-2,1-3.4.6s-1.3-1-1.6-.8S24.5,30,24,30.8Z style=fill:#b7b7b7 /><rect x=46.5 y=58 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect x=46.5 y=65.1 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect x=46.5 y=72.2 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect x=46.5 y=79.3 width=35.5 height=2.38 style=fill:#d5d5d5 /><rect y=57.3 width=40.4 height=25.17 style=fill:#dedede /><path d=M40.4,82.4H0V77.8L13.5,63.5,25.4,78.3,34,69l6.5,7.5Z style=fill:#b7b7b7 /><path d=M24,63.1c-.4.5-1,.4-1.1.9a.8.8,0,0,0,.5.9c.4.2.8-.5,1.2-.3s.2.5.4.6,1-.4,1.8-.5,1.3,1.1,2.4,1.1a2.2,2.2,0,0,0,2-1.9,2.5,2.5,0,0,0-1.6-2.6c-1.3-.4-2,1.1-3.5.6s-1.2-1-1.6-.7S24.6,62.4,24,63.1Z style=fill:#b7b7b7 /><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=15.2 width=89.6 height=2.55 style=fill:#e2e2e2 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.two_article_block.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=TwoArticlesBlockWidgetContent>\r\n        <div>\r\n            <div builder-element class=\"d-flex mb-4\">\r\n                <a builder-element href=\"\" class=mr-4><img builder-element src=" + __webpack_require__(1) + " width=300px /></a>\r\n                <div class=\"\">\r\n                    <h3 builder-element builder-inline-edit class=font-weight-normal>Lorem ipsum dolor</h3>\r\n                    <p builder-element builder-inline-edit class=\"\">Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque. Nunc pulvinar turpis sed pellentesque aliquet.</p>\r\n                    <a builder-element builder-inline-edit data-style=style_1 class=\"btn btn-primary text-white\">View more</a>\r\n                </div>\r\n                </div>\r\n                <div builder-element class=\"d-flex mb-4\">\r\n                <a builder-element href=\"\" class=mr-4><img builder-element src=" + __webpack_require__(1) + " width=300px /></a>\r\n                <div class=\"\">\r\n                    <h3 builder-element builder-inline-edit class=font-weight-normal>Lorem ipsum dolor</h3>\r\n                    <p builder-element builder-inline-edit class=\"\">Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque. Nunc pulvinar turpis sed pellentesque aliquet.</p>\r\n                    <a builder-element builder-inline-edit data-style=style_1 class=\"btn btn-primary text-white\">View more</a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=TwoArticlesRTLBlockWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.two_article_block.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 81.9\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=24.9 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect y=32 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect y=39.1 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect y=46.2 width=35.5 height=2.38 style=fill:#d5d5d5 /><rect y=57.3 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect y=64.3 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect y=71.4 width=43.6 height=2.38 style=fill:#d5d5d5 /><rect y=78.5 width=35.5 height=2.38 style=fill:#d5d5d5 /><rect x=49.2 y=24.4 width=40.4 height=25.17 style=fill:#dedede /><path d=M89.6,49.6H49.2V44.9L62.6,30.6l12,14.8,8.5-9.3,6.5,7.5Z style=fill:#b7b7b7 /><path d=M73.2,30.2c-.5.6-1.1.4-1.2.9a.9.9,0,0,0,.5.9c.4.2.9-.5,1.3-.2s.1.4.3.6,1-.5,1.9-.5S77.3,33,78.3,33a2.2,2.2,0,0,0,2-2,2.3,2.3,0,0,0-1.6-2.5c-1.3-.4-2,1-3.4.6s-1.3-1-1.7-.8S73.7,29.5,73.2,30.2Z style=fill:#b7b7b7 /><rect x=49.2 y=56.8 width=40.4 height=25.17 style=fill:#dedede /><path d=M89.6,81.9H49.2V77.3L62.7,63,74.6,77.8l8.6-9.3,6.4,7.4Z style=fill:#b7b7b7 /><path d=M73.2,62.6c-.4.5-1,.4-1.1.8a.9.9,0,0,0,.4,1c.5.2.9-.5,1.3-.3s.2.5.4.6,1-.4,1.8-.5,1.3,1.1,2.3,1.1a2.2,2.2,0,0,0,2.1-1.9,2.7,2.7,0,0,0-1.7-2.6c-1.2-.4-2,1.1-3.4.6s-1.3-1-1.6-.8S73.8,61.9,73.2,62.6Z style=fill:#b7b7b7 /><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=15.2 width=89.6 height=2.55 style=fill:#e2e2e2 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.two_article_rtl_block.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=TwoArticlesRTLBlockWidgetContent>\r\n        <div>\r\n            <div builder-element class=\"d-flex mb-4\">              \r\n                <div class=\"\">\r\n                    <h3 builder-element builder-inline-edit class=font-weight-normal>Lorem ipsum dolor</h3>\r\n                    <p builder-element builder-inline-edit class=\"\">Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque. Nunc pulvinar turpis sed pellentesque aliquet.</p>\r\n                    <a builder-element builder-inline-edit data-style=style_1 class=\"btn btn-primary text-white\">View more</a>\r\n                </div>\r\n                <a builder-element href=\"\" class=ml-4><img builder-element src=" + __webpack_require__(1) + " width=300px /></a>\r\n            </div>\r\n            <div builder-element class=\"d-flex mb-4\">              \r\n                <div class=\"\">\r\n                <h3 builder-element builder-inline-edit class=font-weight-normal>Lorem ipsum dolor</h3>\r\n                <p builder-element builder-inline-edit class=\"\">Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque. Nunc pulvinar turpis sed pellentesque aliquet.</p>\r\n                <a builder-element builder-inline-edit data-style=style_1 class=\"btn btn-primary text-white\">View more</a>\r\n                </div>\r\n                <a builder-element href=\"\" class=ml-4><img builder-element src=" + __webpack_require__(1) + " width=300px /></a>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=FooterBlockWidget>\r\n        <div class=\"_1content widget-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.footer.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 73.2\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=15.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=22.8 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=30.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect y=44.8 width=89.6 height=28.43 rx=0.3 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.footer.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=FooterBlockWidgetContent>\r\n        <div>\r\n            <div style=padding-bottom:16px>\r\n                <div>\r\n                    <div class=d-flex style=justify-content:center;padding-top:40px;padding-bottom:20px>\r\n                        <a builder-element=IconLinkElement href=\"\" class=\"mr-3 me-3\">\r\n                        <img src={{root}}image/facebook.png style=width:40px;height:40px;display:block;border-radius:100%;background-color:#fff />\r\n                        </a>\r\n                        <a builder-element=IconLinkElement builder-element href=\"\" class=\"mr-3 me-3\">\r\n                        <img src={{root}}image/twitter.png style=width:40px;height:40px;display:block;border-radius:100%;background-color:#fff />\r\n                        </a>\r\n                        <a builder-element=IconLinkElement builder-element href=\"\" class=\"mr-3 me-3\">\r\n                        <img src={{root}}image/instagram.png style=width:40px;height:40px;display:block;border-radius:100%;background-color:#fff />\r\n                        </a>\r\n                        <a builder-element=IconLinkElement builder-element href=\"\" class=\"mr-3 me-3\">\r\n                            <img src={{root}}image/google-plus.png style=width:40px;height:40px;display:block;border-radius:100%;background-color:#fff />\r\n                        </a>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <footer style=padding-top:16px>\r\n                <div class=\"\" style=padding-top:10px;padding-bottom:10px>\r\n                    <div class=text-muted>\r\n\r\n                        <div builder-element=TextElement>\r\n                            <p class=m-0 style=text-align:center;padding-bottom:5px>Copyright &copy; 2021. All rights reserved.</p>\r\n                            <p class=m-0 style=text-align:center;padding-bottom:5px>You can <a builder-element href={UPDATE_PROFILE_URL}>update your preferences</a> or <a builder-element href={UNSUBSCRIBE_URL}>unsubscribe from this list</a>.</p>\r\n                        </div>\r\n                        \r\n                        <p builder-element builder-inline-edit style=text-align:center;padding-top:15px;font-size:13px>\r\n                            <a builder-element href=# style=color:#555>Back to top</a>\r\n                        </p>\r\n                    </div>\r\n                </div>\r\n            </footer>\r\n        </div>\r\n    </div>\r\n\r\n    <div id=OneRowWidget>\r\n        <div class=row style=\"\">\r\n            <div class=\"col-md-12 _1row\">\r\n                <div class=\"row list-row\">\r\n                    <div class=\"col-md-12 row-left\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div><!-- end _1row-->\r\n        </div>\r\n    </div>\r\n    <div id=OneRowWidgetContent>\r\n        <div class=\"row builder-class-row-empty\">\r\n            <div class=\"col-md-12 builder-class-col-empty\">\r\n                <span class=pointer-events-none>{language.wpanel.widgets.content_drag.title}</span>\r\n            </div><!-- end _1row-->\r\n        </div>\r\n    </div>\r\n\r\n    <div id=TwoRow48Widget>\r\n        <div class=\"row builder-class-row-empty\" style=\"\">\r\n            <div class=\"col-md-12 _1row\">\r\n                <div class=\"row list-row\">\r\n                    <div class=\"col-md-4 row-left\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-md-8 row-right\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div><!-- end _1row-->\r\n        </div>\r\n    </div>\r\n    <div id=TwoRow48WidgetContent>\r\n        <table builder-element width=100% border=1 cellspacing=10 cellpadding=10>\r\n            <tr>\r\n                <td style=\"width:30%;padding:0 30px 50px 30px;font-size:initial\" class=p0-15-30 bgcolor=#ffffff>\r\n                </td>\r\n                <td style=\"width:70%;padding:0 30px 50px 30px;font-size:initial\" class=p0-15-30 bgcolor=#ffffff>\r\n                </td>\r\n            </tr>\r\n        </table>\r\n    </div>\r\n\r\n    <div id=TwoRow66Widget>\r\n        <div class=\"row builder-class-row-empty\" style=\"\">\r\n            <div class=\"col-md-12 _1row\">\r\n                <div class=\"row list-row\">\r\n                    <div class=\"col-md-6 row-left\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-md-6 row-right\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div><!-- end _1row-->\r\n        </div>\r\n    </div>\r\n    <div id=TwoRow66WidgetContent>\r\n        <table builder-element width=100% border=1 cellspacing=10 cellpadding=10>\r\n            <tr>\r\n                <td style=\"width:50%;padding:0 30px 50px 30px;font-size:initial\" class=p0-15-30 bgcolor=#ffffff>\r\n                </td>\r\n                <td style=\"width:50%;padding:0 30px 50px 30px;font-size:initial\" class=p0-15-30 bgcolor=#ffffff>\r\n                </td>\r\n            </tr>\r\n        </table>\r\n    </div>\r\n\r\n    <div id=TwoRow84Widget>\r\n        <div class=\"row builder-class-row-empty\" style=\"\">\r\n            <div class=\"col-md-12 _1row\">\r\n                <div class=\"row list-row\">\r\n                    <div class=\"col-md-8 row-left\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-md-4 row-right\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div><!-- end _1row-->\r\n        </div>\r\n    </div>\r\n    <div id=TwoRow84WidgetContent>\r\n        <table builder-element width=100% border=1 cellspacing=10 cellpadding=10>\r\n            <tr>\r\n                <td style=\"width:70%;padding:0 30px 50px 30px;font-size:initial\" class=p0-15-30 bgcolor=#ffffff>\r\n                </td>\r\n                <td style=\"width:30%;padding:0 30px 50px 30px;font-size:initial\" class=p0-15-30 bgcolor=#ffffff>\r\n                </td>\r\n            </tr>\r\n        </table>\r\n    </div>\r\n\r\n    <div id=ThreeRow444Widget>\r\n        <div class=\"row builder-class-row-empty\" style=\"\">\r\n            <div class=\"col-md-12 _1row\">\r\n                <div class=\"row list-row\">\r\n                    <div class=\"col-md-4 row-left\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-md-4 row-center\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-md-4 row-right\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div><!-- end _1row-->\r\n        </div>\r\n    </div>\r\n    <div id=ThreeRow444WidgetContent>\r\n        <div class=\"row builder-class-row-empty\">\r\n            <div class=\"col-md-4 builder-class-col-empty\">\r\n                <span class=pointer-events-none>{language.wpanel.widgets.content_drag.title}</span>\r\n            </div><!-- end _1row-->\r\n            <div class=\"col-md-4 builder-class-col-empty\">\r\n                <span class=pointer-events-none>{language.wpanel.widgets.content_drag.title}</span>\r\n            </div><!-- end _1row-->\r\n            <div class=\"col-md-4 builder-class-col-empty\">\r\n                <span class=pointer-events-none>{language.wpanel.widgets.content_drag.title}</span>\r\n            </div><!-- end _1row-->\r\n        </div>\r\n    </div>\r\n\r\n    <div id=FourRow3333Widget>\r\n        <div class=\"row builder-class-row-empty\" style=\"\">\r\n            <div class=\"col-md-12 _1row\">\r\n                <div class=\"row list-row\">\r\n                    <div class=\"col-md-3 row-left\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-md-3 row-center\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-md-3 row-right\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                    <div class=\"col-md-3 row-right\">\r\n                        <div class=panel__body>\r\n                            <div class=image-drag></div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div><!-- end _1row-->\r\n        </div>\r\n    </div>\r\n    <div id=FourRow3333WidgetContent>\r\n        <div class=\"row builder-class-row-empty\">\r\n            <div class=\"col-md-3 builder-class-col-empty\">\r\n                <span class=pointer-events-none>{language.wpanel.widgets.content_drag.title}</span>\r\n            </div><!-- end _1row-->\r\n            <div class=\"col-md-3 builder-class-col-empty\">\r\n                <span class=pointer-events-none>{language.wpanel.widgets.content_drag.title}</span>\r\n            </div><!-- end _1row-->\r\n            <div class=\"col-md-3 builder-class-col-empty\">\r\n                <span class=pointer-events-none>{language.wpanel.widgets.content_drag.title}</span>\r\n            </div><!-- end _1row-->\r\n            <div class=\"col-md-3 builder-class-col-empty\">\r\n                <span class=pointer-events-none>{language.wpanel.widgets.content_drag.title}</span>\r\n            </div><!-- end _1row-->\r\n        </div>\r\n    </div>\r\n\r\n    <!--button-->\r\n    <div id=ButtonWidget>\r\n        <div class=\"_1content widget-button\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg style=width:100% xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 224 180\"><defs><style>.a{fill:#e0e0e0}.b{fill:#939394}</style></defs><title>button</title><path class=a d=M44,66.5H180a8,8,0,0,1,8,8v38a8,8,0,0,1-8,8H44a8,8,0,0,1-8-8v-38A8,8,0,0,1,44,66.5Z /><path class=b d=M123.9,125.7l10.1.8-22-26v34.4l6.7-7.5,5.1,13.4a2.71,2.71,0,0,0,2.6,1.7c.3,0,.6-.1.9-.1a2.46,2.46,0,0,0,1.8-2.4,2.92,2.92,0,0,0-.2-.9Z /></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.button.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ButtonWidgetContent>\r\n       <div class=button-container>\r\n            <div class=\"button-wrap button-placeholder\">\r\n                <button class=button>{language.wpanel.widgets.button.title}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--social-->\r\n    <div id=SocialWidget>\r\n        <div class=\"_1content widget-social\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class={builder-icon-share-alt} style=font-size:36px;display:inline-block></i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.social.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=SocialWidgetContent>\r\n       <div builder-no-inline-edit=true ng-class=\"{'text-container': module.type == 'mailup-bee-newsletter-modules-text', 'button-container': module.type == 'mailup-bee-newsletter-modules-button'}\" mailup-bee-common-builder=\"\" component=module.type ng-model=module.descriptor configuration=\"{'row': rowIndex, 'column': columnIndex, 'module': moduleIndex}\" class=\"ng-pristine ng-untouched ng-valid ng-isolate-scope ng-not-empty\">\r\n          <div mailup-bee-newsletter-modules-social=\"\" ng-model=content configuration=configuration() class=\"ng-pristine ng-untouched ng-valid ng-scope ng-isolate-scope ng-not-empty\">\r\n              <table width=100% border=0 cellspacing=0 cellpadding=0>\r\n                  <tbody>\r\n                      <tr>\r\n                          <td align=center style=max-width:285px>\r\n                              <table class=bee-social align=center border=0 cellspacing=0 cellpadding=0 style=width:auto>\r\n                                  <tbody>\r\n                                      <tr>\r\n                                          <td align=left ng-style=module.style style=text-align:center;padding:10px>\r\n                                              <!-- ngRepeat: icon in module.iconsList.icons -->\r\n                                              <table align=left border=0 cellspacing=0 cellpadding=0 height=32 ng-repeat=\"icon in module.iconsList.icons\" ng-attr-style=\"display: inline-block; margin: {{ module.computedStyle['padding'] }}\" class=ng-scope style=\"display:inline-block;margin:0 5px 5px 0\">\r\n                                                  <tbody>\r\n                                                      <tr>\r\n                                                          <td>\r\n                                                                <a href=javascript:; title={language.wpanel.widgets.facebook.title}>\r\n                                                                    <span class=icon-social><i class=\"fab fa-facebook-f\"></i></span>\r\n                                                              <span class=ng-binding></span>\r\n                                                              </a>\r\n                                                          </td>\r\n                                                      </tr>\r\n                                                  </tbody>\r\n                                              </table>\r\n                                              <!-- end ngRepeat: icon in module.iconsList.icons -->\r\n                                              <table align=left border=0 cellspacing=0 cellpadding=0 height=32 ng-repeat=\"icon in module.iconsList.icons\" ng-attr-style=\"display: inline-block; margin: {{ module.computedStyle['padding'] }}\" class=ng-scope style=\"display:inline-block;margin:0 5px 5px 0\">\r\n                                                  <tbody>\r\n                                                      <tr>\r\n                                                          <td>\r\n                                                              <a href=javascript:; title={language.wpanel.widgets.twitter.title}>\r\n                                                              <span class=icon-social><i class=\"fab fa-twitter\"></i></span>\r\n                                                              <span class=ng-binding></span>\r\n                                                              </a>\r\n                                                          </td>\r\n                                                      </tr>\r\n                                                  </tbody>\r\n                                              </table>\r\n                                              <!-- end ngRepeat: icon in module.iconsList.icons -->\r\n                                              <table align=left border=0 cellspacing=0 cellpadding=0 height=32 ng-repeat=\"icon in module.iconsList.icons\" ng-attr-style=\"display: inline-block; margin: {{ module.computedStyle['padding'] }}\" class=ng-scope style=\"display:inline-block;margin:0 5px 5px 0\">\r\n                                                  <tbody>\r\n                                                      <tr>\r\n                                                          <td>\r\n                                                              <a href=javascript:; title={language.wpanel.widgets.instagram.title}>\r\n                                                                <span class=icon-social><i class=\"fab fa-instagram\"></i></span>\r\n                                                              <span class=ng-binding></span>\r\n                                                              </a>\r\n                                                          </td>\r\n                                                      </tr>\r\n                                                  </tbody>\r\n                                              </table>\r\n                                              <!-- end ngRepeat: icon in module.iconsList.icons -->\r\n                                              <table align=left border=0 cellspacing=0 cellpadding=0 height=32 ng-repeat=\"icon in module.iconsList.icons\" ng-attr-style=\"display: inline-block; margin: {{ module.computedStyle['padding'] }}\" class=ng-scope style=\"display:inline-block;margin:0 5px 5px 0\">\r\n                                                  <tbody>\r\n                                                      <tr>\r\n                                                          <td>\r\n                                                              <a href=javascript:; title={language.wpanel.widgets.linkedIn.title}>\r\n                                                              <span class=icon-social><i class=\"fab fa-linkedin-in\"></i></span>\r\n                                                              <span class=ng-binding></span>\r\n                                                              </a>\r\n                                                          </td>\r\n                                                      </tr>\r\n                                                  </tbody>\r\n                                              </table>\r\n                                              <!-- end ngRepeat: icon in module.iconsList.icons -->\r\n                                          </td>\r\n                                      </tr>\r\n                                  </tbody>\r\n                              </table>\r\n                          </td>\r\n                      </tr>\r\n                  </tbody>\r\n              </table>\r\n          </div>\r\n      </div>\r\n    </div>\r\n\r\n    <!--html-->\r\n    <div id=HtmlWidget>\r\n       <div class=\"_1content widget-html\">\r\n          <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n             <div class=image-drag>\r\n                <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                    <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 73.6\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=7.1 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=14.7 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=21.5 width=72.9 height=2.55 style=fill:#e2e2e2 /><path d=M4.8,53.6,30.2,39.3v3.4L8.2,54.8l22,12.7v3.3L4.8,56.2Z transform=translate(-2.2) style=fill:#b7b7b7 /><path d=M37.9,73.6,54,30.3h2.9L40.8,73.6Z transform=translate(-2.2) style=fill:#b7b7b7 /><path d=M89.9,56.5,64.6,70.8V67.4l22-12.1-22-12.7V39.3L89.9,53.9Z transform=translate(-2.2) style=fill:#b7b7b7 /></g></g></svg>\r\n                </div>\r\n            </div>\r\n            <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.html.title}</div>\r\n         </div>\r\n       </div>\r\n    </div>\r\n    <div id=HtmlWidgetContent>\r\n        <div builder-element=HtmlElement class=description id=clickable-layer data-bind-html=trustedHtml> {language.wpanel.widgets.des_html.title} </div>\r\n    </div>\r\n\r\n    <!--video-->\r\n    <div id=VideoWidget>\r\n        <div class=\"_1content widget-video\">\r\n          <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n            <div class=image-drag>\r\n                <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                    <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 73.8\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><path d=M71.7,73.8h-57a6,6,0,0,1-6-6V25.9a6,6,0,0,1,6-6h57a6,6,0,0,1,6,6V67.8A6,6,0,0,1,71.7,73.8ZM25.2,22.9H14.7a3,3,0,0,0-3,3v3H25.2Zm16.5,0H28.2v6H41.7Zm16.5,0H44.7v6H58.2Zm16.5,3a3,3,0,0,0-3-3H61.2v6H74.7Zm0,6h-63V61.8h63Zm0,32.9H61.2v6h-3v-6H44.7v6h-3v-6H28.2v6h-3v-6H11.7v3a3,3,0,0,0,3,3h57a3,3,0,0,0,3-3Zm-35-9.3a1.7,1.7,0,0,1-1,.3,1.5,1.5,0,0,1-1.5-1.5v-15a1.5,1.5,0,0,1,1.5-1.5,3.2,3.2,0,0,1,.9.3l11.6,7.3a1.5,1.5,0,0,1,1,1.4,1.4,1.4,0,0,1-.6,1.2Z style=fill:#b7b7b7;fill-rule:evenodd /><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /></g></g></svg>\r\n                </div>\r\n            </div>\r\n             <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.video.title}</div>\r\n          </div>\r\n        </div>\r\n    </div>\r\n    <div id=VideoWidgetContent>\r\n        <div class=video-container f-role=placeholder>\r\n            <div class=\"video-wrap video-placeholder\">\r\n                <a class=\"remove remove-content-widget\"><i class={builder-icon-times-circle}></i></a>\r\n                <i class={builder-icon-film} style=font-size:40px></i>\r\n                <div class=description>{language.wpanel.widgets.video.title}</div>\r\n                <button class=\"btn btn-dafault button-add-video\">{language.wpanel.widgets.des_video.title}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--image + caption-->\r\n    <div id=ImageCaptionWidget>\r\n        <div class=\"_1content widget-image-caption\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.7 79.9\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=54.5 width=89.6 height=2.55 style=fill:#d5d5d5 /><rect y=62.1 width=89.6 height=2.55 style=fill:#d5d5d5 /><rect y=69.7 width=89.6 height=2.55 style=fill:#d5d5d5 /><rect y=77.3 width=72.9 height=2.55 style=fill:#d5d5d5 /><rect width=89.6 height=49.49 style=fill:#dedede /><path d=M89.6,49.5H0V40.3L29.9,12.2,56.3,41.3,75.4,23,89.7,37.7Z style=fill:#b7b7b7 /><path d=M53.2,11.5c-.9,1-2.3.8-2.5,1.7a1.6,1.6,0,0,0,1,1.8c1,.4,2-1,2.8-.5s.4.8.9,1.2,2.2-.9,4-1,2.9,2.1,5.2,2.2A5,5,0,0,0,69.2,13c.3-2.3-1.7-4.5-3.7-5s-4.4,2.1-7.6,1.2-2.8-2-3.6-1.5S54.4,10.1,53.2,11.5Z style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.block.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ImageCaptionWidgetContent>\r\n        <div class=row>\r\n            <div class=\"col-12 col-md-12\">\r\n            <img builder-element builder-inline-edit class=my-2 src=" + __webpack_require__(22) + " width=100% />\r\n            <h3 builder-element builder-inline-edit class=\"mt-2 mb-2\">Lorem ipsum dolor</h3>\r\n            <p builder-element builder-inline-edit>Vestibulum id convallis ligula. Maecenas tellus erat, porta in augue eget, pretium aliquet neque.\r\n            Nunc pulvinar turpis sed pellentesque aliquet. Sed ullamcorper, tellus eu viverra tincidunt,\r\n            quam justo pellentesque est, et gravida justo eros vitae turpis.</p>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--footer-->\r\n    <div id=FooterWidget>\r\n        <div class=\"_1content widget-image-caption\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 73.2\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=15.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=22.8 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=30.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect y=44.8 width=89.6 height=28.43 rx=0.3 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.footer.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=FooterWidgetContent>\r\n        <div class=footer-container f-role=placeholder>\r\n            <div class=\"footer-wrap footer-placeholder\">\r\n                <a class=\"remove remove-content-widget\"><i class={builder-icon-times-circle}></i></a>\r\n                <td valign=top class=mcnTextContent style=padding-top:0;padding-right:18px;padding-bottom:9px;padding-left:18px>\r\n                    {language.wpanel.widgets.des_footer.title}\r\n                </td>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--header-->\r\n    <div id=HeaderWidget>\r\n        <div class=\"_1content widget-header\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 71\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=38 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=45.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=53.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=60.8 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=68.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect width=89.6 height=28.43 rx=0.3 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.header.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=HeaderWidgetContent>\r\n        <div class=header-container f-role=\"\">\r\n            <div class=\"footer-wrap header-placeholder\">\r\n                <h1>{language.wpanel.widgets.page_header.title}</h1>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--List image-->\r\n    <div id=ListImageWidget>\r\n        <div class=\"_1content widget-list-image\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.8 82\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect x=0.2 y=65 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=0.2 y=72.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=0.2 y=79.5 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect y=15 width=25.9 height=21.53 style=fill:#dedede /><path d=M25.9,36.5H0v-4l10.6-12,10.6,12,4.7-5.7v9.7Z style=fill:#b7b7b7 /><path d=M18.3,20.2c-.4.5-1,.4-1.1.8s.2.7.4.8.9-.5,1.2-.3.2.4.4.6.9-.4,1.7-.5,1.2,1,2.2,1A2.2,2.2,0,0,0,25,20.9a2.2,2.2,0,0,0-1.6-2.2c-1.2-.3-1.8.9-3.2.5s-1.1-.8-1.5-.6S18.8,19.6,18.3,20.2Z style=fill:#b7b7b7 /><rect x=32 y=15 width=25.9 height=21.53 style=fill:#dedede /><path d=M57.9,36.5H32v-4l10.6-12,10.6,12,4.7-5.7v9.7Z style=fill:#b7b7b7 /><path d=M50.3,20.2c-.4.5-1,.4-1.1.8s.2.7.4.8.9-.5,1.2-.3.2.4.4.6.9-.4,1.7-.5,1.2,1,2.2,1A2.2,2.2,0,0,0,57,20.9a2.2,2.2,0,0,0-1.6-2.2c-1.2-.3-1.8.9-3.2.5s-1.1-.8-1.5-.6S50.8,19.6,50.3,20.2Z style=fill:#b7b7b7 /><rect x=63.7 y=15 width=25.9 height=21.53 style=fill:#dedede /><path d=M89.6,36.5H63.7v-4l10.6-12,10.6,12,4.7-5.7v9.7Z style=fill:#b7b7b7 /><path d=M81.4,30.7c-.4.5-.9.3-1,.7a.7.7,0,0,0,.4.8c.4.2.8-.4,1.2-.2s.1.4.3.5,1-.4,1.7-.4,1.2.9,2.2.9a2,2,0,0,0,1.9-1.6,2.2,2.2,0,0,0-1.5-2.2c-1.2-.4-1.9.9-3.2.5s-1.2-.9-1.5-.7S81.9,30.1,81.4,30.7Z style=fill:#b7b7b7 /><rect x=0.3 y=41.3 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=0.3 y=47 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=0.3 y=53.5 width=20.8 height=2.27 style=fill:#d5d5d5 /><rect x=32.2 y=41.3 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=32.2 y=47 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=32.2 y=53.5 width=20.8 height=2.27 style=fill:#d5d5d5 /><rect x=63.8 y=41.3 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=63.8 y=47 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=63.8 y=53.5 width=20.8 height=2.27 style=fill:#d5d5d5 /><rect x=0.2 width=89.3 height=8.68 style=fill:#e8e8e8 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>{language.wpanel.widgets.list_image.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ListImageWidgetContent>\r\n        <div class=list-images-container f-role=\"\">\r\n            <div class=\"row list-images\" style=\"\">\r\n                <div class=\"col-12 col-md-4 item-col\">\r\n                    <div class=col-content>\r\n                        <img src=" + __webpack_require__(214) + " alt=\"Image Builder\" class=\"img-circle img-thumbnail\">\r\n                        <h2 class=title>{language.wpanel.widgets.list_image.designer.title}</h2>\r\n                        <p>{language.wpanel.widgets.list_image.design.des.title}\r\n                        </p>\r\n                        <a href=# data-style=style_1 class=\"btn btn-primary btn-link\" title=\"See more\">{language.wpanel.widgets.list_image.see.title}</a>\r\n                    </div>\r\n                </div>\r\n                <div class=\"col-12 col-md-4 item-col\">\r\n                    <div class=col-content>\r\n                        <img src=" + __webpack_require__(215) + " alt=\"Image Builder\" class=\"img-circle img-thumbnail\">\r\n                        <h2 class=title>{language.wpanel.widgets.list_image.photo.title}</h2>\r\n                        <p>{language.wpanel.widgets.list_image.photo.des.title}\r\n                        </p>\r\n                        <a href=# data-style=style_1 class=\"btn btn-primary btn-link\" title=\"See more\">{language.wpanel.widgets.list_image.see.title}</a>\r\n                    </div>\r\n                </div>\r\n                <div class=\"col-12 col-md-4 item-col\">\r\n                    <div class=col-content>\r\n                        <img src=" + __webpack_require__(216) + " alt=\"Image Builder\" class=\"img-circle img-thumbnail\">\r\n                        <h2 class=title>{language.wpanel.widgets.list_image.copy.title}</h2>\r\n                        <p>{language.wpanel.widgets.list_image.copy.des.title}\r\n                        </p>\r\n                        <a href=# data-style=style_1 class=\"btn btn-primary btn-link\" title=\"See more\">{language.wpanel.widgets.list_image.see.title}</a>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--progress bar-->\r\n    <div id=ProgressBarWidget>\r\n        <div class=\"_1content widget-progress-bar\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 76\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=37.8 width=89.6 height=38.18 rx=6.6 style=fill:#e2e2e2 /><path d=M6.7,37.8H31.5a0,0,0,0,1,0,0V76a0,0,0,0,1,0,0H6.7A6.6,6.6,0,0,1,0,69.4V44.5a6.6,6.6,0,0,1,6.6-6.6Z style=fill:#b7b7b7 /><rect y=7.1 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=14.7 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=21.5 width=72.9 height=2.55 style=fill:#e2e2e2 /><path d=M17.2,52.7v2.6c0,2-.9,3-2.6,3s-2.5-.8-2.5-2.8V52.7c0-2.1,1.1-2.9,2.6-2.9S17.2,50.8,17.2,52.7ZM13.6,65.6,21,50h1.2L14.8,65.6Zm.2-13v2.9c0,.8.2,1.2.8,1.2s.9-.5.9-1.3V52.5c0-.7-.3-1.1-.8-1.1S13.8,51.8,13.8,52.6Zm10,7.6v2.6c0,2-1,3-2.6,3S18.6,65,18.6,63V60.2c0-2,1.1-2.9,2.6-2.9S23.8,58.3,23.8,60.2Zm-3.5-.1V63q0,1.2.9,1.2c.7,0,.8-.5.8-1.3V60c0-.7-.2-1.1-.8-1.1S20.3,59.3,20.3,60.1Z style=fill:#fff /><path d=M41.5,59.1h0c0,1.5-.4,2.8-2.3,2.8s-2.3-1.3-2.3-3V56.1c0-1.3.5-2.7,2.4-2.7s2.2,1.5,2.2,2.5v.3H39.9v-.3c0-.7-.1-1.1-.7-1.1s-.6.4-.6,1.1v3.6c0,.6.1,1.1.6,1.1s.7-.4.7-1.1v-.4Z style=fill:#b7b7b7 /><path d=M47.2,56.1v3.2q0,2.7-2.4,2.7c-1.6,0-2.4-1-2.4-2.7V56c0-1.8,1-2.6,2.4-2.6S47.2,54.4,47.2,56.1ZM44,56v3.4c0,.6.2,1.1.8,1.1s.8-.4.8-1.2V56c0-.6-.2-1.1-.8-1.1S44,55.3,44,56Z style=fill:#b7b7b7 /><path d=M48.4,56V53.6h1.5a1.5,1.5,0,0,1,.1.7,1.6,1.6,0,0,1,1.5-.9,1.3,1.3,0,0,1,1.3.9,1.8,1.8,0,0,1,1.6-.9c.9,0,1.6.5,1.6,2.1v6.3H54.4v-6c0-.6-.2-.9-.7-.9s-.7.5-.7,1.3v5.6H51.4v-6c0-.7-.3-.9-.7-.9s-.7.5-.7,1.3v5.6H48.4Z style=fill:#b7b7b7 /><path d=M59,61.3v3.3H57.4v-11h1.5a1.7,1.7,0,0,1,.1.8,1.5,1.5,0,0,1,1.5-1c1.2,0,1.7.8,1.7,2.5v3.4c0,1.9-.6,2.7-1.8,2.7A1.7,1.7,0,0,1,59,61.3Zm1.6-2V56c0-.7-.2-1.1-.7-1.1s-.9.3-.9,1.3v2.9c0,.8.2,1.4.8,1.4S60.6,60,60.6,59.3Z style=fill:#b7b7b7 /><path d=M63.4,61.8V50.7h1.7V61.8Z style=fill:#b7b7b7 /><path d=M67.8,58.1v1.3c0,.6.2,1.2.8,1.2s.7-.6.7-1.2h1.6c0,.9-.2,2.6-2.3,2.6s-2.4-1.3-2.4-3V56.3c0-1.2.4-2.9,2.4-2.9S71,54.6,71,56.3v1.8Zm1.6-1.3V56c0-.8-.2-1.2-.8-1.2s-.8.4-.8,1.2v.8Z style=fill:#b7b7b7 /><path d=M71.5,53.6h.9v-2H74v2h1.1V55H74v4.9c0,.4.1.7.6.7H75v1.2L74,62c-1,0-1.6-.4-1.6-1.8V55h-.9Z style=fill:#b7b7b7 /><path d=M77.3,58.1v1.3c0,.6.1,1.2.7,1.2s.8-.6.8-1.2h1.6c0,.9-.2,2.6-2.3,2.6s-2.5-1.3-2.5-3V56.3c0-1.2.4-2.9,2.5-2.9s2.3,1.2,2.3,2.9v1.8Zm1.5-1.3V56c0-.8-.2-1.2-.7-1.2s-.8.4-.8,1.2v.8Z style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.progress_bar.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ProgressBarWidgetContent>\r\n        <div class=progress-bar-container f-role=\"\"> <!--placeholder-->\r\n            <div class=progress style=\"\">\r\n                <div class=progress-bar role=progressbar aria-valuenow=60 aria-valuemin=0 aria-valuemax=100 style=width:60%>60%</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--list group-->\r\n    <div id=ListGroupWidget>\r\n        <div class=\"_1content widget-list-group\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 77.4\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=6.8 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect y=15.8 width=89.6 height=14.09 style=fill:#e6e6e6 /><rect y=31.5 width=89.6 height=14.09 style=fill:#e6e6e6 /><rect y=47.3 width=89.6 height=14.09 style=fill:#e6e6e6 /><rect y=63.4 width=89.6 height=14.09 style=fill:#e6e6e6 /><rect x=9.6 y=21.5 width=71.1 height=2.55 style=fill:#b7b7b7 /><rect x=9.6 y=37.3 width=71.1 height=2.55 style=fill:#b7b7b7 /><rect x=9.6 y=53.2 width=71.1 height=2.55 style=fill:#b7b7b7 /><rect x=9.6 y=69.1 width=71.1 height=2.55 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.list_group.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ListGroupWidgetContent>\r\n        <div class=list-group-container f-role=\"\">\r\n            <div class=list-group style=\"\">\r\n                <a href=# class=\"list-group-item disabled\">{language.wpanel.widgets.list_group.cras.title}</a>\r\n                <a href=# class=list-group-item>{language.wpanel.widgets.list_group.dapibus.title}</a>\r\n                <a href=# class=list-group-item>{language.wpanel.widgets.list_group.morbi.title}</a>\r\n                <a href=# class=list-group-item>{language.wpanel.widgets.list_group.porta.title}</a>\r\n                <a href=# class=list-group-item>{language.wpanel.widgets.list_group.vesti.title}</a>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Panel-->\r\n    <div id=PanelWidget>\r\n        <div class=\"_1content widget-panel\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 81\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=89.6 height=18.49 style=fill:#b7b7b7 /><rect y=20.7 width=89.6 height=18.49 style=fill:#e6e6e6 /><rect y=41.4 width=89.6 height=18.49 style=fill:#e6e6e6 /><rect y=62.5 width=89.6 height=18.49 style=fill:#e6e6e6 /><rect x=9.3 y=8.9 width=71.1 height=2.55 style=fill:#dedede /><rect x=9.3 y=28.7 width=71.1 height=2.55 style=fill:#b7b7b7 /><rect x=9.3 y=49.4 width=71.1 height=2.55 style=fill:#b7b7b7 /><rect x=9.3 y=71.4 width=71.1 height=2.55 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.panel.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=PanelWidgetContent>\r\n        <div class=panel-container f-role=\"\">\r\n            <div class=\"panel panel-primary\" style=\"\">\r\n                <div class=panel-heading>{language.wpanel.widgets.panel.heading.title}</div>\r\n                <div class=panel-body>{language.wpanel.widgets.panel.body.title}</div>\r\n                <div class=panel-footer>{language.wpanel.widgets.panel.footer.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Image header-->\r\n    <div id=ImageHeaderWidget>\r\n        <div class=\"_1content widget-image-header\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class={builder-icon-image_header} style=font-size:36px;display:inline-block></i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.image_header.title}</div>\r\n             </div>\r\n        </div>\r\n    </div>\r\n    <div id=ImageHeaderWidgetContent>\r\n        <div class=image-header-container>\r\n            <div class=image-header style=\"\">\r\n                <h3>{language.wpanel.widgets.image_header.h3.title}</h3>\r\n                <h1>{language.wpanel.widgets.image_header.h1.title}</h1>\r\n                <p><a data-style=style_1 class=\"btn btn-primary btn-lg\" role=button>{language.wpanel.widgets.image_header.tell.title}</a></p>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--jumbotron widget-->\r\n    <div id=JumbotronWidget>\r\n        <div class=\"_1content widget-jumbotron\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 81\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=55 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=29.9 width=89.6 height=3.38 style=fill:#b7b7b7 /><rect y=37.3 width=89.6 height=3.38 style=fill:#b7b7b7 /><rect y=62.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=70.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=78.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect width=89.6 height=10.43 rx=0.3 style=fill:#e2e2e2 /><rect x=23.7 y=18.5 width=45.4 height=7.06 style=fill:#b7b7b7 /><path d=M21.6,50.1c1.2-.6,10.6-5.5,13.7-3.2a2.4,2.4,0,0,1,.7,3.3c-1.1,1.3-4.3,1.4-5,.4s1.1-4.5,4.2-5.6,4.1,0,11.5,2.2c4.9,1.4,10.5,3,16.8,3,2.1,0,4.2-.1,4.9-1.2a2,2,0,0,0-.4-2.5,3.9,3.9,0,0,0-4.5.2 style=fill:none;stroke:#e2e2e2;stroke-miterlimit:10 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.jumbotron.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=JumbotronWidgetContent>\r\n        <div class=jumbotron-container f-role=\"\">\r\n            <div class=jumbotron style=\"\">\r\n                <div class=\"\">\r\n                    <h1>{language.wpanel.widgets.jumbotron.welcome.title}</h1>\r\n                    <p class=des-jumbotron>{language.wpanel.widgets.jumbotron.des.title}</p>\r\n                    <p class=btn-jumbotron>\r\n                        <a data-style=style_1 class=\"btn btn-primary btn-lg\" role=button>{language.wpanel.widgets.jumbotron.learn_more.title}</a>\r\n                    </p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Meterial box-->\r\n    <div id=MeterialWidget>\r\n        <div class=\"_1content widget-meterial\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 81\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=55 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=29.9 width=89.6 height=3.38 style=fill:#b7b7b7 /><rect y=37.3 width=89.6 height=3.38 style=fill:#b7b7b7 /><rect y=62.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=70.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=78.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect width=89.6 height=10.43 rx=0.3 style=fill:#e2e2e2 /><rect x=37.8 y=13.4 width=14 height=13.99 rx=7 style=fill:#b7b7b7 /><rect x=30.7 y=44 width=28.3 height=4.43 rx=2.2 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.meterial.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=MeterialWidgetContent>\r\n        <div class=meterial-container f-role=\"\">\r\n            <div class=box>\r\n                <div class=box-icon>\r\n                    <i class=\"fab fa-html5\"></i>\r\n                </div>\r\n                <div class=info>\r\n                    <h4 class=text-center>{language.wpanel.widgets.meterial.title.title}</h4>\r\n                    <p>{language.wpanel.widgets.meterial.des.title}</p>\r\n                    <a href=\"\" class=btn>{language.wpanel.widgets.meterial.link.title}</a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Navbar-->\r\n    <div id=NavbarWidget>\r\n        <div class=\"_1content widget-navbar\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 76.6\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=43.7 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=51.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=58.8 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=66.4 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=22 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=29.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=37.2 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=74 width=72.9 height=2.55 style=fill:#e2e2e2 /><rect width=88.8 height=14.41 style=fill:#e2e2e2 /><rect x=28.7 y=4.8 width=14.8 height=4.84 rx=1.9 style=fill:#b7b7b7 /><rect x=10.3 y=4.8 width=14.8 height=4.84 rx=1.9 style=fill:#b7b7b7 /><rect x=46.6 y=4.8 width=14.8 height=4.84 rx=1.9 style=fill:#b7b7b7 /><rect x=64.4 y=4.8 width=14.8 height=4.84 rx=1.9 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.navbar.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=NavbarWidgetContent>\r\n        <div class=navbar-container f-role=\"\">\r\n            <div class=\"navbar nav-default\">\r\n                <div class=\"\">\r\n                    <div class=\"navbar-header responsive-logo\">\r\n                        <a href=/ class=navbar-brand><i class=\"fab fa-blackberry\"></i> {language.wpanel.widgets.navbar.architect.title}</a>\r\n                    </div>\r\n                    <nav class=\"navbar-collapse bs-navbar-collapse collapse\" role=navigation style=height:1px>\r\n                        <ul class=\"nav navbar-nav navbar-right responsive-nav main-nav-list\">\r\n                            <li class=\"\"><a href=#focus>{language.wpanel.widgets.navbar.portfolio.title}</a></li>\r\n                            <li class=\"\"><a href=#aboutus>{language.wpanel.widgets.navbar.about.title}</a></li>\r\n                            <li class=\"\"><a href=#pricingtable>{language.wpanel.widgets.navbar.pricing.title}</a></li>\r\n                            <li class=\"\"><a href=#features>{language.wpanel.widgets.navbar.team.title}</a></li>\r\n                            <li><a href=#contact>{language.wpanel.widgets.navbar.contact.title}</a></li>\r\n                        </ul>\r\n                    </nav>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--services list widget-->\r\n    <div id=ServicesListWidget>\r\n        <div class=\"_1content widget-services-list\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.9 80\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=25.9 height=21.53 style=fill:#dedede /><path d=M25.9,21.5H0v-4L10.6,5.6,21.2,17.5l4.7-5.7v9.7Z style=fill:#b7b7b7 /><path d=M18.3,5.2c-.4.5-1,.4-1.1.8a.8.8,0,0,0,.4.8c.5.1.9-.4,1.2-.3s.2.4.4.6.9-.4,1.7-.5,1.2,1,2.2,1A2.1,2.1,0,0,0,25,5.9a2.2,2.2,0,0,0-1.6-2.2c-1.2-.3-1.8.9-3.2.6s-1.1-.9-1.5-.7S18.8,4.6,18.3,5.2Z style=fill:#b7b7b7 /><rect x=32 width=25.9 height=21.53 style=fill:#dedede /><path d=M57.9,21.5H32v-4L42.6,5.6,53.2,17.5l4.7-5.7v9.7Z style=fill:#b7b7b7 /><path d=M50.3,5.2c-.4.5-1,.4-1.1.8a.8.8,0,0,0,.4.8c.5.1.9-.4,1.2-.3s.2.4.4.6.9-.4,1.7-.5,1.2,1,2.2,1A2.1,2.1,0,0,0,57,5.9a2.2,2.2,0,0,0-1.6-2.2c-1.2-.3-1.8.9-3.2.6s-1.1-.9-1.5-.7S50.8,4.6,50.3,5.2Z style=fill:#b7b7b7 /><rect x=63.7 width=25.9 height=21.53 style=fill:#dedede /><path d=M89.6,21.5H63.7v-4L74.3,5.6c3.5,4,7,8,10.6,11.9l4.7-5.7v9.7Z style=fill:#b7b7b7 /><path d=M81.4,15.7c-.4.5-.9.4-1,.7a.9.9,0,0,0,.4.9c.4.1.8-.5,1.2-.3s.1.4.3.5,1-.3,1.7-.4,1.2,1,2.2,1a2.1,2.1,0,0,0,1.9-1.7,2.2,2.2,0,0,0-1.5-2.2c-1.2-.4-1.9.9-3.2.5s-1.2-.8-1.5-.6S81.9,15.1,81.4,15.7Z style=fill:#b7b7b7 /><rect x=0.3 y=26.3 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=0.3 y=32.1 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=32.2 y=26.3 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=32.2 y=32.1 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=63.8 y=26.3 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=63.8 y=32.1 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=0.3 y=45.6 width=25.9 height=21.53 style=fill:#dedede /><path d=M26.2,67.2H.3v-4l10.6-12,10.6,12,4.7-5.7v9.7Z style=fill:#b7b7b7 /><rect x=32.3 y=45.6 width=25.9 height=21.53 style=fill:#dedede /><path d=M58.2,67.2H32.3v-4l10.6-12,10.6,12,4.7-5.7v9.7Z style=fill:#b7b7b7 /><rect x=64 y=45.6 width=25.9 height=21.53 style=fill:#dedede /><path d=M89.9,67.2H64v-4l10.6-12,10.6,12,4.7-5.7v9.7Z style=fill:#b7b7b7 /><rect x=0.6 y=71.9 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=0.6 y=77.7 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=32.5 y=71.9 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=32.5 y=77.7 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=64.1 y=71.9 width=25.6 height=2.27 style=fill:#d5d5d5 /><rect x=64.1 y=77.7 width=25.6 height=2.27 style=fill:#d5d5d5 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.services_list.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ServicesListWidgetContent>\r\n        <div class=services-list-container f-role=\"\">\r\n            <div class=services-list style=\"\">\r\n                <div class=row>\r\n                    <div class=\"col-lg-3 col-md-6\">\r\n                        <div class=service-box>\r\n                            <div class=service-icon><i class=\"fal fa-lightbulb\"></i></div>\r\n                            <h4>{language.wpanel.widgets.services_list.generating.title}</h4>\r\n                            <p class=text-center>{language.wpanel.widgets.services_list.des1.title}</p>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div class=\"col-lg-3 col-md-6\">\r\n                       <div class=service-box>\r\n                            <div class=service-icon><i class=\"fal fa-keyboard\"></i></div>\r\n                            <h4>{language.wpanel.widgets.services_list.prototype.title}</h4>\r\n                            <p class=text-center>{language.wpanel.widgets.services_list.des2.title}</p>\r\n                       </div>\r\n                    </div>\r\n\r\n                    <div class=\"col-lg-3 col-md-6\">\r\n                       <div class=service-box>\r\n                            <div class=service-icon><i class=\"fal fa-code\"></i></div>\r\n                            <h4>{language.wpanel.widgets.services_list.design.title}</h4>\r\n                            <p class=text-center>{language.wpanel.widgets.services_list.des3.title}</p>\r\n                       </div>\r\n                    </div>\r\n\r\n                    <div class=\"col-lg-3 col-md-6\">\r\n                        <div class=service-box>\r\n                            <div class=service-icon><i class=\"fal fa-rocket\"></i></div>\r\n                            <h4>{language.wpanel.widgets.services_list.launching.title}</h4>\r\n                            <p class=text-center>{language.wpanel.widgets.services_list.des4.title}</p>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--image grid-->\r\n    <div id=ImageGridWidget>\r\n        <div class=\"_1content widget-image-grid\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg style=width:100% xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 224 180\"><defs><style>.a{fill:#e2e2e2}.b{fill:#b7b7b7}</style></defs><title>imageGroup</title><path class=a d=\"M45 46h56v38H45z\"/><path class=b d=\"M45 73.1V84h56V73l-9-9-9 9-19-18-19 18.1\"/><g id=blimpIcon><g id=Layer_1><g id=Group><g id=blimpIcon><g id=Layer_1><g id=Group stroke=#B5B5B5 fill=#B5B5B5><path d=\"M89.966 52.427c.213.355.213.814 0 1.17-1.368 2.307-5.027 2.617-7.605 2.558-2.69-.06-5.012-.68-5.838-.976-1.21-.445-2.492-1.17-3.432-2.087-.086-.074-.086-.192 0-.266.94-.918 2.207-1.554 3.432-1.983.826-.296 3.147-.917 5.84-.976 2.577-.06 6.236.25 7.604 2.56z\" id=Shape stroke-width=.86 /><path d=\"M81.545 55.7c-.507-.022-.995-.043-1.466-.084v1.8h3.6v-1.76c-.742.063-1.466.063-2.135.043z\" id=Shape stroke-width=.86 /><path d=\"M74.895 54.4l.16 1.8 1.048-.03c.64-.022 1.22-.355 1.492-.844M74.895 51.7l.16-1.8 1.048.03c.64.022 1.22.355 1.492.844\" id=Shape stroke-width=.688 /></g></g></g></g></g></g><path class=b d=\"M105 42v46H41V42h64m4-4H37v54h72V38z\"/><path class=a d=\"M123 46h56v38h-56z\"/><path class=b d=\"M123 73.1V84h56V73l-9-9-9 9-19-18-19 18.1\"/><g id=blimpIcon><g id=Layer_1><g id=Group><g id=blimpIcon><g id=Layer_1><g id=Group stroke=#B5B5B5 fill=#B5B5B5><path d=\"M167.966 52.427c.213.355.213.814 0 1.17-1.368 2.307-5.027 2.617-7.605 2.558-2.69-.06-5.012-.68-5.838-.976-1.21-.445-2.492-1.17-3.432-2.087-.086-.074-.086-.192 0-.266.94-.918 2.207-1.554 3.432-1.983.826-.296 3.147-.917 5.84-.976 2.577-.06 6.236.25 7.604 2.56z\" id=Shape stroke-width=.86 /><path d=\"M159.545 55.7c-.507-.022-.995-.043-1.466-.084v1.8h3.6v-1.76c-.742.063-1.466.063-2.135.043z\" id=Shape stroke-width=.86 /><path d=\"M152.895 54.4l.16 1.8 1.048-.03c.64-.022 1.22-.355 1.492-.844M152.895 51.7l.16-1.8 1.048.03c.64.022 1.22.355 1.492.844\" id=Shape stroke-width=.688 /></g></g></g></g></g></g><path class=b d=\"M183 42v46h-64V42h64m4-4h-72v54h72V38z\"/><path class=a d=\"M45 106h56v38H45z\"/><path class=b d=\"M45 133.1V144h56v-11l-9-9-9 9-19-18-19 18.1\"/><g id=blimpIcon><g id=Layer_1><g id=Group><g id=blimpIcon><g id=Layer_1><g id=Group stroke=#B5B5B5 fill=#B5B5B5><path d=\"M89.966 112.427c.213.355.213.814 0 1.17-1.368 2.307-5.027 2.617-7.605 2.558-2.69-.06-5.012-.68-5.838-.976-1.21-.445-2.492-1.17-3.432-2.087-.086-.074-.086-.192 0-.266.94-.918 2.207-1.554 3.432-1.983.826-.296 3.147-.917 5.84-.976 2.577-.06 6.236.25 7.604 2.56z\" id=Shape stroke-width=.86 /><path d=\"M81.545 115.7c-.507-.022-.995-.043-1.466-.084v1.8h3.6v-1.76c-.742.063-1.466.063-2.135.043z\" id=Shape stroke-width=.86 /><path d=\"M74.895 114.4l.16 1.8 1.048-.03c.64-.022 1.22-.355 1.492-.844M74.895 111.7l.16-1.8 1.048.03c.64.022 1.22.355 1.492.844\" id=Shape stroke-width=.688 /></g></g></g></g></g></g><path class=b d=\"M105 102v46H41v-46h64m4-4H37v54h72V98z\"/><path class=a d=\"M123 106h56v38h-56z\"/><path class=b d=\"M123 133.1V144h56v-11l-9-9-9 9-19-18-19 18.1\"/><g id=blimpIcon><g id=Layer_1><g id=Group><g id=blimpIcon><g id=Layer_1><g id=Group stroke=#B5B5B5 fill=#B5B5B5><path d=\"M167.966 112.427c.213.355.213.814 0 1.17-1.368 2.307-5.027 2.617-7.605 2.558-2.69-.06-5.012-.68-5.838-.976-1.21-.445-2.492-1.17-3.432-2.087-.086-.074-.086-.192 0-.266.94-.918 2.207-1.554 3.432-1.983.826-.296 3.147-.917 5.84-.976 2.577-.06 6.236.25 7.604 2.56z\" id=Shape stroke-width=.86 /><path d=\"M159.545 115.7c-.507-.022-.995-.043-1.466-.084v1.8h3.6v-1.76c-.742.063-1.466.063-2.135.043z\" id=Shape stroke-width=.86 /><path d=\"M152.895 114.4l.16 1.8 1.048-.03c.64-.022 1.22-.355 1.492-.844M152.895 111.7l.16-1.8 1.048.03c.64.022 1.22.355 1.492.844\" id=Shape stroke-width=.688 /></g></g></g></g></g></g><path class=b d=\"M183 102v46h-64v-46h64m4-4h-72v54h72V98z\"/></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.image_grid.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ImageGridWidgetContent>\r\n        <div class=image-grid-container f-role=\"\">\r\n            <div class=\"row image-grid\" style=\"\">\r\n                <div class=col-xs-3>\r\n                    <a href=# class=thumbnail>\r\n                        <img src=" + __webpack_require__(2) + ">\r\n                    </a>\r\n                </div>\r\n                <div class=col-xs-3>\r\n                    <a href=# class=thumbnail>\r\n                        <img src=" + __webpack_require__(2) + ">\r\n                    </a>\r\n                </div>\r\n                <div class=col-xs-3>\r\n                    <a href=# class=thumbnail>\r\n                        <img src=" + __webpack_require__(2) + ">\r\n                    </a>\r\n                </div>\r\n                <div class=col-xs-3>\r\n                    <a href=# class=thumbnail>\r\n                        <img src=" + __webpack_require__(2) + ">\r\n                    </a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--user profile-->\r\n    <div id=UserProfileWidget>\r\n        <div class=\"_1content widget-user-profile\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class={builder-icon-user} style=font-size:36px;display:inline-block></i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.user_profile.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=UserProfileWidgetContent>\r\n        <div class=user-profile-container f-role=\"\">\r\n            <div class=user-profile style=\"\">\r\n                <div class=\"col-md-8 col-lg-6 content\">\r\n                    <div class=\"well profile\">\r\n                        <div class=\"col-sm-12 content-top\">\r\n                            <div class=\"col-xs-12 col-sm-8\">\r\n                                <h2>{language.wpanel.widgets.user_profile.name.title}</h2>\r\n                                <p><strong>{language.wpanel.widgets.user_profile.about.title} </strong> {language.wpanel.widgets.user_profile.webdesign.title} </p>\r\n                                <p><strong>{language.wpanel.widgets.user_profile.hobbies.title} </strong> {language.wpanel.widgets.user_profile.read.title} </p>\r\n                                <p><strong>{language.wpanel.widgets.user_profile.skills.title} </strong>\r\n                                    <span class=\"label label-success\">{language.wpanel.widgets.user_profile.html5.title}</span>\r\n                                    <span class=\"label label-success\">{language.wpanel.widgets.user_profile.css3.title}</span>\r\n                                    <span class=\"label label-success\">{language.wpanel.widgets.user_profile.jquery.title}</span>\r\n                                    <span class=\"label label-success\">{language.wpanel.widgets.user_profile.bootstrap3.title}</span>\r\n                                </p>\r\n                            </div>\r\n                            <div class=\"col-xs-12 col-sm-4 text-center\">\r\n                                <p>{language.wpanel.widgets.user_profile.ratings.title}\r\n                                    <a href=#>\r\n                                        <i class=\"fal fa-star\"></i>\r\n                                    </a>\r\n                                    <a href=#>\r\n                                        <i class=\"fal fa-star\"></i>\r\n                                    </a>\r\n                                    <a href=#>\r\n                                        <i class=\"fal fa-star\"></i>\r\n                                    </a>\r\n                                    <a href=#>\r\n                                        <i class=\"fal fa-star\"></i>\r\n                                    </a>\r\n                                    <a href=#>\r\n                                        <i class=\"fal fa-star\"></i>\r\n                                    </a>\r\n                                </p>\r\n                            </div>\r\n                        </div>\r\n                        <div class=\"col-xs-12 divider text-center\">\r\n                            <div class=\"col-xs-12 col-sm-4 emphasis\">\r\n                                <h2><strong> {language.wpanel.widgets.user_profile.interge1.title} </strong></h2>\r\n                                <p><small>{language.wpanel.widgets.user_profile.followers.title}</small></p>\r\n                                <button class=\"btn btn-success btn-block\"><i class=\"fal fa-plus-circle\"></i> {language.wpanel.widgets.user_profile.follow.title} </button>\r\n                            </div>\r\n                            <div class=\"col-xs-12 col-sm-4 emphasis\">\r\n                                <h2><strong>{language.wpanel.widgets.user_profile.interge2.title}</strong></h2>\r\n                                <p><small>{language.wpanel.widgets.user_profile.following.title}</small></p>\r\n                                <button class=\"btn btn-info btn-block\"><i class=\"fal fa-user\"></i> {language.wpanel.widgets.user_profile.viewprofile.title} </button>\r\n                            </div>\r\n                            <div class=\"col-xs-12 col-sm-4 emphasis\">\r\n                                <h2><strong>{language.wpanel.widgets.user_profile.interge3.title}</strong></h2>\r\n                                <p><small>{language.wpanel.widgets.user_profile.snippets.title}</small></p>\r\n                                <button data-style=style_1 class=\"btn btn-primary btn-block\"><i class=\"fal fa-cogs\"></i> {language.wpanel.widgets.user_profile.options.title} </button>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Div container widget-->\r\n    <div id=DivContainerWidget>\r\n        <div class=\"_1content widget-div-container\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class=material-icons-outlined style=font-size:36px;display:inline-block>move_to_inbox</i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.div_container.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=DivContainerWidgetContent>\r\n        <div class=div_container-container f-role=\"\">\r\n            <div class=div></div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Container widget-->\r\n    <div id=ContainerWidget>\r\n        <div class=\"_1content widget-container\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class=material-icons-outlined style=font-size:36px;display:inline-block>aspect_ratio</i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.container.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ContainerWidgetContent>\r\n        <div class=container-container f-role=\"\">\r\n            <div class=\"\"></div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--well widget-->\r\n    <div id=WellWidget>\r\n        <div class=\"_1content widget-well\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class=material-icons-outlined style=font-size:36px;display:inline-block>check_box_outline_blank</i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.well.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=WellWidgetContent>\r\n        <div class=well-container f-role=\"\">\r\n            <div class=well style=\"\">{language.wpanel.widgets.well.look.title}</div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--media object widget-->\r\n    <div id=MediaObjectWidget>\r\n        <div class=\"_1content widget-media-object\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class={builder-icon-media_object} style=font-size:36px;display:inline-block></i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.media_object.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=MediaObjectWidgetContent>\r\n        <div class=media-object-container f-role=\"\">\r\n            <div class=media style=\"\">\r\n                <a class=media-left href=#>\r\n                    <img src=" + __webpack_require__(217) + ">\r\n                </a>\r\n                <div class=media-body>\r\n                    <h2 class=media-heading>{language.wpanel.widgets.media_object.heading.title}</h2>\r\n                    <p>{language.wpanel.widgets.media_object.des1.title}</p>\r\n                    <p>{language.wpanel.widgets.media_object.des2.title}</p>\r\n                    <p>{language.wpanel.widgets.media_object.des3.title}</p>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Paragraph-->\r\n    <div id=ParagraphWidget>\r\n        <div class=\"_1content widget-paragraph-profile\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 73.4\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=89.6 height=2.55 style=fill:#cacaca /><rect y=8.9 width=89.6 height=2.55 style=fill:#cacaca /><rect y=17.7 width=89.6 height=2.55 style=fill:#cacaca /><rect y=26.6 width=89.6 height=2.55 style=fill:#cacaca /><rect y=70.9 width=72.9 height=2.55 style=fill:#cacaca /><rect y=35.4 width=89.6 height=2.55 style=fill:#cacaca /><rect y=44.3 width=89.6 height=2.55 style=fill:#cacaca /><rect y=53.1 width=89.6 height=2.55 style=fill:#cacaca /><rect y=62 width=89.6 height=2.55 style=fill:#cacaca /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.paragraph.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ParagraphWidgetContent>\r\n        <div class=paragraph-container f-role=\"\">\r\n            <div class=paragraph-profile style=\"\">\r\n                <p class=paragraph style=\"\">{language.wpanel.widgets.paragraph.description}</p>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Marked Text-->\r\n    <div id=MarkedTextWidget>\r\n        <div class=\"_1content widget-marked-text\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 88.7 73.2\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><polygon points=\"88.7 0 88.7 60.5 72.5 60.5 72.5 73.2 0 73.2 0 0 88.7 0\" style=fill:#b7b7b7 /><rect x=7.1 y=6 width=71.2 height=2.55 style=fill:#fff /><rect x=7.1 y=14.9 width=71.2 height=2.55 style=fill:#fff /><rect x=7.1 y=59.2 width=57.9 height=2.55 style=fill:#fff /><rect x=7.1 y=23.7 width=71.2 height=2.55 style=fill:#fff /><rect x=7.1 y=32.6 width=71.2 height=2.55 style=fill:#fff /><rect x=7.1 y=41.5 width=71.2 height=2.55 style=fill:#fff /><rect x=7.1 y=50.3 width=71.2 height=2.55 style=fill:#fff /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.marked_text.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=MarkedTextWidgetContent>\r\n        <div class=marked-text style=\"\">\r\n            <mark style=\"\">{language.wpanel.widgets.marked_text.description}</mark>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Definition List-->\r\n    <div id=DefinitionListWidget>\r\n        <div class=\"_1content widget-definition-list\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 88.7 79.3\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect x=23.6 width=64.6 height=3.89 style=fill:#e2e2e2 /><rect x=23.6 y=10.4 width=52.5 height=3.89 style=fill:#e2e2e2 /><rect x=23.6 y=47.8 width=64.6 height=3.89 style=fill:#e2e2e2 /><rect x=23.6 y=58.2 width=52.5 height=3.89 style=fill:#e2e2e2 /><rect x=23.6 y=28.8 width=64.6 height=3.89 style=fill:#e2e2e2 /><rect width=19.4 height=8.38 style=fill:#b7b7b7 /><rect y=26.5 width=19.4 height=8.38 style=fill:#b7b7b7 /><rect y=47.8 width=19.4 height=8.38 style=fill:#b7b7b7 /><rect x=24.1 y=73.2 width=64.6 height=3.89 style=fill:#e2e2e2 /><rect x=0.7 y=70.9 width=19.4 height=8.38 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.definition_list.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=DefinitionListWidgetContent>\r\n        <div class=definition-list-container f-role=\"\">\r\n            <div class=definition-list style=\"\">\r\n                <dl class=dl-horizontal style=\"\">\r\n                    <dt>{language.wpanel.widgets.definition_list.description1}</dt>\r\n                    <dd>{language.wpanel.widgets.definition_list.description2}</dd>\r\n                    <dt>{language.wpanel.widgets.definition_list.description3}</dt>\r\n                    <dd>{language.wpanel.widgets.definition_list.description4}</dd>\r\n                    <dd>{language.wpanel.widgets.definition_list.description5}</dd>\r\n                    <dt>{language.wpanel.widgets.definition_list.description6}</dt>\r\n                    <dd>{language.wpanel.widgets.definition_list.description7}</dd>\r\n                    <dt>{language.wpanel.widgets.definition_list.description8}</dt>\r\n                    <dd>{language.wpanel.widgets.definition_list.description9}</dd>\r\n                </dl>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Blockqoute-->\r\n    <div id=BlockqouteWidget>\r\n        <div class=\"_1content widget-blockqoute\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 73.8 57.3\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><path d=M10,0V7.4C10,13.1,6.3,17,1,18L0,15.8A6.6,6.6,0,0,0,4,10H0V0ZM24,0V7.4c0,5.7-3.7,9.6-9,10.6l-1-2.2A6.6,6.6,0,0,0,18,10H14V0Z style=fill:#b7b7b7 /><rect x=34.7 y=1.6 width=39.1 height=2.55 style=fill:#e2e2e2 /><rect x=34.7 y=10.5 width=39.1 height=2.55 style=fill:#e2e2e2 /><rect x=2.5 y=54.8 width=57.9 height=2.55 style=fill:#e2e2e2 /><rect x=34.7 y=19.4 width=39.1 height=2.55 style=fill:#e2e2e2 /><rect x=2.6 y=28.2 width=71.2 height=2.55 style=fill:#e2e2e2 /><rect x=2.6 y=37.1 width=71.2 height=2.55 style=fill:#e2e2e2 /><rect x=2.6 y=45.9 width=71.2 height=2.55 style=fill:#e2e2e2 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.blockqoute.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=BlockqouteWidgetContent>\r\n        <div class=blockqoute-container f-role=\"\">\r\n            <div class=blockqoute style=\"\">\r\n                <blockquote style=\"\">\r\n                    <p>{language.wpanel.widgets.blockqoute.description1}</p>\r\n                    <footer>{language.wpanel.widgets.blockqoute.description2} <cite title=\"Source Title\">{language.wpanel.widgets.blockqoute.description3}</cite></footer>\r\n                </blockquote>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Unordered List-->\r\n    <div id=UnorderedListWidget>\r\n        <div class=\"_1content widget-unordered-list\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class={builder-icon-unordered-list} style=font-size:36px;display:inline-block></i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.unordered_list.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=UnorderedListWidgetContent>\r\n        <div class=unordered-list-container f-role=\"\">\r\n            <div class=unordered-list style=\"\">\r\n                <ul style=\"\">\r\n                    <li>{language.wpanel.widgets.unordered_list.description1}</li>\r\n                    <li>{language.wpanel.widgets.unordered_list.description2}</li>\r\n                    <li>{language.wpanel.widgets.unordered_list.description3}</li>\r\n                    <ul></ul>\r\n                </ul>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Heading-->\r\n    <div id=HeadingWidget>\r\n        <div class=\"_1content widget-heading\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class=material-icons-outlined style=transform:rotate(180deg);font-size:36px;display:inline-block>view_carousel</i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.heading.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=HeadingWidgetContent>\r\n        <div class=heading-container f-role=\"\">\r\n            <div class=heading style=\"\">\r\n                <h2 style=\"\">{language.wpanel.widgets.heading.description1}</h2>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Link-->\r\n    <div id=LinkWidget>\r\n        <div class=\"_1content widget-link\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 71.2 57.5\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect x=32.1 y=1.8 width=39.1 height=2.55 style=fill:#e2e2e2 /><rect x=32.1 y=10.7 width=39.1 height=2.55 style=fill:#e2e2e2 /><rect y=55 width=57.9 height=2.55 style=fill:#e2e2e2 /><rect x=32.1 y=19.6 width=39.1 height=2.55 style=fill:#e2e2e2 /><rect y=28.4 width=71.2 height=2.55 style=fill:#e2e2e2 /><rect y=37.3 width=71.2 height=2.55 style=fill:#e2e2e2 /><rect y=46.1 width=71.2 height=2.55 style=fill:#e2e2e2 /><path d=M10.7,18.2,7.8,21.1a3.1,3.1,0,0,1-4.2,0,3,3,0,0,1,0-4.3l5.6-5.6a3,3,0,0,1,4.3,0,1,1,0,0,0,1.4-1.4,5,5,0,0,0-7.1,0L2.2,15.4a5,5,0,0,0,0,7.1,5,5,0,0,0,7,0l2.9-2.8a1.1,1.1,0,0,0,0-1.5A1.2,1.2,0,0,0,10.7,18.2Z style=fill:#b7b7b7 /><path d=M23.2,1.5a4.8,4.8,0,0,0-7,0L12.8,4.8a1.1,1.1,0,0,0,0,1.5,1.2,1.2,0,0,0,1.4,0l3.4-3.4a2.9,2.9,0,0,1,4.2,0,2.9,2.9,0,0,1,0,4.2l-6.2,6.2a2.9,2.9,0,0,1-4.2,0A1,1,0,1,0,10,14.7a4.8,4.8,0,0,0,7,0l6.2-6.2A4.8,4.8,0,0,0,23.2,1.5Z style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.link.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=LinkWidgetContent>\r\n        <div class=link-container f-role=\"\">\r\n            <div class=link style=\"\">\r\n                <a href=# style=\"\">{language.wpanel.widgets.link.description}</a>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Button Group-->\r\n    <div id=ButtonGroupWidget>\r\n        <div class=\"_1content widget-button-group\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>                        \r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 86.7 55.2\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect x=1.3 width=85.3 height=2.55 style=fill:#e2e2e2 /><rect x=1.3 y=7.6 width=85.3 height=2.55 style=fill:#e2e2e2 /><rect x=1.3 y=14.4 width=69.4 height=2.55 style=fill:#e2e2e2 /><path d=M5.5,25.8H27.6a0,0,0,0,1,0,0V55.2a0,0,0,0,1,0,0H5.5A5.5,5.5,0,0,1,0,49.6V31.3A5.5,5.5,0,0,1,5.5,25.8Z style=fill:#b7b7b7 /><rect x=28.9 y=25.8 width=27.6 height=29.38 style=fill:#b7b7b7 /><path d=M57.7,25.8H79.6a5.7,5.7,0,0,1,5.7,5.7V49.4a5.7,5.7,0,0,1-5.7,5.7H57.7a0,0,0,0,1,0,0V25.8A0,0,0,0,1,57.7,25.8Z style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.button_group.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ButtonGroupWidgetContent>\r\n        <div class=\"button-group btn-group\" style=\"\">\r\n            <button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_group.left}</button>\r\n            <button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_group.middle}</button>\r\n            <button type=button class=\"btn btn-default\" style=border-top-left-radius:0;border-bottom-left-radius:0>{language.wpanel.widgets.button_group.right}</button>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Button Toolbar-->\r\n    <div id=ButtonToolbarWidget>\r\n        <div class=\"_1content widget-button-toolbar\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 85.4 54.3\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=37.3 width=85.3 height=2.55 style=fill:#e2e2e2 /><rect y=44.9 width=85.3 height=2.55 style=fill:#e2e2e2 /><rect y=51.7 width=69.4 height=2.55 style=fill:#e2e2e2 /><path d=M5.5,0H27.6a0,0,0,0,1,0,0V29.4a0,0,0,0,1,0,0H5.5A5.5,5.5,0,0,1,0,23.8V5.5A5.5,5.5,0,0,1,5.5,0Z style=fill:#b7b7b7 /><rect x=28.9 width=27.6 height=29.38 style=fill:#b7b7b7 /><path d=M57.7,0H79.6a5.7,5.7,0,0,1,5.7,5.7V23.6a5.7,5.7,0,0,1-5.7,5.7H57.7a0,0,0,0,1,0,0V0A0,0,0,0,1,57.7,0Z style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.button_toolbar.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=ButtonToolbarWidgetContent>\r\n        <div class=button-toolbar style=\"\">\r\n            <div class=btn-toolbar role=toolbar aria-label=\"Toolbar with button groups\" style=\"\">\r\n                <div class=btn-group role=group aria-label=\"First group\"><button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_toolbar.description1}</button><button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_toolbar.description2}</button><button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_toolbar.description3}</button><button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_toolbar.description4}</button></div>\r\n                <div class=btn-group role=group aria-label=\"Second group\"><button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_toolbar.description5}</button><button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_toolbar.description6}</button><button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_toolbar.description7}</button></div>\r\n                <div class=btn-group role=group aria-label=\"Third group\"><button type=button class=\"btn btn-default\">{language.wpanel.widgets.button_toolbar.description8}</button></div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Input Field-->\r\n    <div id=InputFieldWidget>\r\n        <div class=\"_1content widget-input-field\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 72.4\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=41.3 width=87.9 height=31.08 rx=9.1 style=fill:#dedede /><rect x=16.4 y=28.1 width=2.8 height=26.45 style=fill:#b7b7b7 /><rect x=7.9 y=24.5 width=19.8 height=3.61 rx=1.2 style=fill:#b7b7b7 /><rect x=7.9 y=54.6 width=19.8 height=3.61 rx=1.2 style=fill:#b7b7b7 /><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=14.4 width=72.9 height=2.55 style=fill:#e2e2e2 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.input_field.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=InputFieldWidgetContent>\r\n        <div class=input-field-container f-role=\"\">\r\n            <div class=input-field style=\"\">\r\n                <input type=text class=form-control placeholder=\"Text input\" style=\"\">\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Text Area-->\r\n    <div id=TextAreaWidget>\r\n        <div class=\"_1content widget-text-area\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 83 83\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=83 height=83.02 rx=7.3 style=fill:#e2e2e2 /><rect x=21.3 y=17.8 width=2.8 height=26.45 style=fill:#b7b7b7 /><rect x=12.8 y=14.2 width=19.8 height=3.61 rx=1.2 style=fill:#b7b7b7 /><rect x=12.8 y=44.3 width=19.8 height=3.61 rx=1.2 style=fill:#b7b7b7 /><rect x=42.6 y=18.2 width=35.6 height=2.55 style=fill:#fff /><rect x=42.6 y=27.1 width=35.6 height=2.55 style=fill:#fff /><rect x=7 y=71.4 width=57.9 height=2.55 style=fill:#fff /><rect x=42.6 y=36 width=35.6 height=2.55 style=fill:#fff /><rect x=42.6 y=44.8 width=35.6 height=2.55 style=fill:#fff /><rect x=7 y=53.7 width=71.2 height=2.55 style=fill:#fff /><rect x=7 y=62.5 width=71.2 height=2.55 style=fill:#fff /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.text_area.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=TextAreaWidgetContent>\r\n        <div class=text-area-container f-role=\"\">\r\n            <div class=text-area style=\"\">\r\n                <textarea class=form-control rows=3 cols=50></textarea>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Checkbox-->\r\n    <div id=CheckboxWidget>\r\n        <div class=\"_1content widget-checkbox\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class={builder-icon-checkbox} style=font-size:36px;display:inline-block></i>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.checkbox.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=CheckboxWidgetContent>\r\n        <div class=checkbox-container f-role=\"\">\r\n            <div class=checkbox>\r\n                <label><input type=checkbox>{language.wpanel.widgets.checkbox.description}</label>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Input Group-->\r\n    <div id=InputGroupWidget>\r\n        <div class=\"_1content widget-input-group\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 72.4\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=41.3 width=87.9 height=31.08 rx=9.1 style=fill:#f2f2f2 /><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.6 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=14.4 width=72.9 height=2.55 style=fill:#e2e2e2 /><path d=M9.1,41.3H39a0,0,0,0,1,0,0V72.4a0,0,0,0,1,0,0H9.1A9.1,9.1,0,0,1,0,63.3V50.5A9.1,9.1,0,0,1,9.1,41.3Z style=fill:#dedede /><rect x=16.4 y=28.1 width=2.8 height=26.45 style=fill:#b7b7b7 /><rect x=7.9 y=24.5 width=19.8 height=3.61 rx=1.2 style=fill:#b7b7b7 /><rect x=7.9 y=54.6 width=19.8 height=3.61 rx=1.2 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.input_group.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=InputGroupWidgetContent>\r\n        <div class=input-group-container f-role=\"\">\r\n            <div class=form-group style=\"\">\r\n                <div class=input-group>\r\n                    <div class=input-group-addon>{language.wpanel.widgets.input_group.description}</div>\r\n                    <input class=form-control type=email placeholder=\"Enter email\">\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Form Group-->\r\n    <div id=FormGroupWidget>\r\n        <div class=\"_1content widget-form-group\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 92.7 71.4\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect x=1.2 y=5.5 width=48.9 height=7.28 style=fill:#b7b7b7 /><rect y=20.8 width=87.9 height=31.08 rx=9.1 style=fill:#f2f2f2 /><path d=M58,20.8H87.9a0,0,0,0,1,0,0V51.9a0,0,0,0,1,0,0H58a9.1,9.1,0,0,1-9.1-9.1V29.9A9.1,9.1,0,0,1,58,20.8Z transform=\"translate(136.8 72.6) rotate(-180)\" style=fill:#dedede /><path d=M69.3,41.7l4.4-7.6a1,1,0,0,0-.9-1.5H63.9a1,1,0,0,0-.8,1.5l4.4,7.6A1,1,0,0,0,69.3,41.7Z style=fill:#b7b7b7 /><rect x=3 y=59.9 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect x=3 y=68.9 width=72.9 height=2.55 style=fill:#e2e2e2 /><polygon points=\"63.2 0 64.9 3.3 68.6 3.9 65.9 6.5 66.5 10.2 63.2 8.4 59.9 10.2 60.5 6.5 57.9 3.9 61.6 3.3 63.2 0\" style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.form_group.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=FormGroupWidgetContent>\r\n        <div class=form-group-container f-role=\"\">\r\n            <div class=form-group>\r\n                <label for=email class=control-label>Email address</label>\r\n                <input type=email class=form-control id=email placeholder=\"Enter email\">\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Select-->\r\n    <div id=SelectWidget>\r\n        <div class=\"_1content widget-select\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 89.6 72.4\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect y=41.3 width=87.9 height=31.08 rx=9.1 style=fill:#f2f2f2 /><rect width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=7.8 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=15.7 width=89.6 height=2.55 style=fill:#e2e2e2 /><rect y=23.5 width=72.9 height=2.55 style=fill:#e2e2e2 /><path d=M58,41.3H87.9a0,0,0,0,1,0,0V72.4a0,0,0,0,1,0,0H58a9.1,9.1,0,0,1-9.1-9.1V50.5A9.1,9.1,0,0,1,58,41.3Z transform=\"translate(136.8 113.8) rotate(-180)\" style=fill:#dedede /><path d=M69.3,62.3l4.4-7.7a1,1,0,0,0-.9-1.5H63.9a1,1,0,0,0-.8,1.5l4.4,7.7A1,1,0,0,0,69.3,62.3Z style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.select.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=SelectWidgetContent>\r\n        <div class=select-container f-role=\"\">\r\n            <select class=form-control>\r\n                <option>{language.wpanel.widgets.select.description1}</option>\r\n                <option>{language.wpanel.widgets.select.description2}</option>\r\n                <option>{language.wpanel.widgets.select.description3}</option>\r\n                <option>{language.wpanel.widgets.select.description4}</option>\r\n                <option>{language.wpanel.widgets.select.description5}</option>\r\n            </select>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Form-->\r\n    <div id=FormWidget>\r\n        <div class=\"_1content widget-form\">\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <svg xmlns=http://www.w3.org/2000/svg viewBox=\"0 0 82.8 75.4\"><g id=Layer_2 data-name=\"Layer 2\"><g id=Layer_1-2 data-name=\"Layer 1\"><rect width=82.8 height=75.44 rx=4.8 style=fill:#f2f2f2 /><rect x=12.7 y=13.2 width=55 height=17.51 rx=8.8 style=fill:#fff /><path d=M52.1,13.2H67.7a0,0,0,0,1,0,0V30.7a0,0,0,0,1,0,0H52.1a8.8,8.8,0,0,1-8.8-8.8v0a8.8,8.8,0,0,1,8.8-8.8Z transform=\"translate(111.1 43.9) rotate(-180)\" style=fill:#dedede /><path d=M56.4,24.5l2-3.1a1,1,0,0,0-.8-1.6H53.5a1,1,0,0,0-.8,1.6l2,3.1A1,1,0,0,0,56.4,24.5Z style=fill:#b7b7b7 /><rect x=12.4 y=45.2 width=55.6 height=17.57 rx=8.8 style=fill:#fff /><rect x=22.8 y=37.8 width=1.8 height=14.95 style=fill:#b7b7b7 /><rect x=17.5 y=35.7 width=12.5 height=2.04 rx=1 style=fill:#b7b7b7 /><rect x=17.5 y=52.7 width=12.5 height=2.04 rx=1 style=fill:#b7b7b7 /></g></g></svg>\r\n                    </div>\r\n                </div>\r\n                <div class=\"body__title body__title--cs ng-binding\">{language.wpanel.widgets.form.title}</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div id=FormWidgetContent>\r\n        <div class=form-container f-role=\"\">\r\n            <form accept-charset=UTF-8 action=https://example.com method=POST class=clearfix style=\"\">\r\n                <div class=\"col-xs-12 form-group\">\r\n                    <label class=control-label>{language.wpanel.widgets.form.description1}</label>\r\n                    <input class=form-control size=4 type=text>\r\n                </div>\r\n                <div class=\"col-xs-12 form-group card required\">\r\n                    <label class=control-label>{language.wpanel.widgets.form.description2}</label>\r\n                    <input autocomplete=off class=\"form-control card-number\" size=20 type=text>\r\n                </div>\r\n                <div class=\"col-xs-12 form-group card required\">\r\n                    <label class=control-label>{language.wpanel.widgets.form.description3}</label>\r\n                    <input autocomplete=off class=form-control size=20 type=text>\r\n                </div>\r\n                <div class=\"col-xs-4 form-group cvc required\">\r\n                    <label class=control-label>{language.wpanel.widgets.form.description4}</label>\r\n                    <input autocomplete=off class=\"form-control card-cvc\" placeholder=\"ex. 311\" size=4 type=text>\r\n                </div>\r\n                <div class=\"col-xs-4 form-group expiration required\">\r\n                    <label class=control-label>{language.wpanel.widgets.form.description5}</label>\r\n                    <input class=\"form-control card-expiry-month\" placeholder=MM size=2 type=text>\r\n                </div>\r\n                <div class=\"col-xs-4 form-group expiration required\">\r\n                    <label class=control-label>&nbsp;</label>\r\n                    <input class=\"form-control card-expiry-year\" placeholder=YYYY size=4 type=text>\r\n                </div>\r\n                <div class=\"col-md-12 form-group\">\r\n                    <hr>\r\n                    <button data-style=style_1 class=\"form-control btn btn-primary submit-button\" type=submit> {language.wpanel.widgets.form.description6}</button>\r\n                </div>\r\n            </form>\r\n        </div>\r\n    </div>\r\n\r\n    <!--Custom-->\r\n    <div id=CustomWidget>\r\n        <div class=\"_1content widget-text\" title=[NAME]>\r\n            <div class=panel__body title={language.wpanel.widgets.title.title}>\r\n                <span class=widget-custom-tag><i class={builder-icon-user}></i></span>\r\n                <span class=remove-widget-button><i class={builder-icon-trash-alt}></i></span>\r\n                <div class=image-drag>\r\n                    <div ng-bind-html=::getModuleIcon(module) class=ng-binding>\r\n                        <i class={builder-icon-code} style=font-size:36px;display:inline-block></i>\r\n                    </div>\r\n                </div>\r\n                <div class=body__title>[NAME]</div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n";

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/* AUTO-GENERATED. DO NOT MODIFY. */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.

 JS Beautifier
---------------


  Written by Einar Lielmanis, <einar@beautifier.io>
      https://beautifier.io/

  Originally converted to javascript by Vital, <vital76@gmail.com>
  "End braces on own line" added by Chris J. Shull, <chrisjshull@gmail.com>
  Parsing improvements for brace-less statements by Liam Newman <bitwiseman@beautifier.io>


  Usage:
    js_beautify(js_source_text);
    js_beautify(js_source_text, options);

  The options are:
    indent_size (default 4)          - indentation size,
    indent_char (default space)      - character to indent with,
    preserve_newlines (default true) - whether existing line breaks should be preserved,
    max_preserve_newlines (default unlimited) - maximum number of line breaks to be preserved in one chunk,

    jslint_happy (default false) - if true, then jslint-stricter mode is enforced.

            jslint_happy        !jslint_happy
            ---------------------------------
            function ()         function()

            switch () {         switch() {
            case 1:               case 1:
              break;                break;
            }                   }

    space_after_anon_function (default false) - should the space before an anonymous function's parens be added, "function()" vs "function ()",
          NOTE: This option is overriden by jslint_happy (i.e. if jslint_happy is true, space_after_anon_function is true by design)

    brace_style (default "collapse") - "collapse" | "expand" | "end-expand" | "none" | any of the former + ",preserve-inline"
            put braces on the same line as control statements (default), or put braces on own line (Allman / ANSI style), or just put end braces on own line, or attempt to keep them where they are.
            preserve-inline will try to preserve inline blocks of curly braces

    space_before_conditional (default true) - should the space before conditional statement be added, "if(true)" vs "if (true)",

    unescape_strings (default false) - should printable characters in strings encoded in \xNN notation be unescaped, "example" vs "\x65\x78\x61\x6d\x70\x6c\x65"

    wrap_line_length (default unlimited) - lines should wrap at next opportunity after this number of characters.
          NOTE: This is not a hard limit. Lines will continue until a point where a newline would
                be preserved if it were present.

    end_with_newline (default false)  - end output with a newline


    e.g

    js_beautify(js_source_text, {
      'indent_size': 1,
      'indent_char': '\t'
    });

*/

(function() {

/* GENERATED_BUILD_OUTPUT */
var legacy_beautify_js;
/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var Beautifier = __webpack_require__(1).Beautifier,
  Options = __webpack_require__(5).Options;

function js_beautify(js_source_text, options) {
  var beautifier = new Beautifier(js_source_text, options);
  return beautifier.beautify();
}

module.exports = js_beautify;
module.exports.defaultOptions = function() {
  return new Options();
};


/***/ }),
/* 1 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var Output = __webpack_require__(2).Output;
var Token = __webpack_require__(3).Token;
var acorn = __webpack_require__(4);
var Options = __webpack_require__(5).Options;
var Tokenizer = __webpack_require__(7).Tokenizer;
var line_starters = __webpack_require__(7).line_starters;
var positionable_operators = __webpack_require__(7).positionable_operators;
var TOKEN = __webpack_require__(7).TOKEN;


function in_array(what, arr) {
  return arr.indexOf(what) !== -1;
}

function ltrim(s) {
  return s.replace(/^\s+/g, '');
}

function generateMapFromStrings(list) {
  var result = {};
  for (var x = 0; x < list.length; x++) {
    // make the mapped names underscored instead of dash
    result[list[x].replace(/-/g, '_')] = list[x];
  }
  return result;
}

function reserved_word(token, word) {
  return token && token.type === TOKEN.RESERVED && token.text === word;
}

function reserved_array(token, words) {
  return token && token.type === TOKEN.RESERVED && in_array(token.text, words);
}
// Unsure of what they mean, but they work. Worth cleaning up in future.
var special_words = ['case', 'return', 'do', 'if', 'throw', 'else', 'await', 'break', 'continue', 'async'];

var validPositionValues = ['before-newline', 'after-newline', 'preserve-newline'];

// Generate map from array
var OPERATOR_POSITION = generateMapFromStrings(validPositionValues);

var OPERATOR_POSITION_BEFORE_OR_PRESERVE = [OPERATOR_POSITION.before_newline, OPERATOR_POSITION.preserve_newline];

var MODE = {
  BlockStatement: 'BlockStatement', // 'BLOCK'
  Statement: 'Statement', // 'STATEMENT'
  ObjectLiteral: 'ObjectLiteral', // 'OBJECT',
  ArrayLiteral: 'ArrayLiteral', //'[EXPRESSION]',
  ForInitializer: 'ForInitializer', //'(FOR-EXPRESSION)',
  Conditional: 'Conditional', //'(COND-EXPRESSION)',
  Expression: 'Expression' //'(EXPRESSION)'
};

function remove_redundant_indentation(output, frame) {
  // This implementation is effective but has some issues:
  //     - can cause line wrap to happen too soon due to indent removal
  //           after wrap points are calculated
  // These issues are minor compared to ugly indentation.

  if (frame.multiline_frame ||
    frame.mode === MODE.ForInitializer ||
    frame.mode === MODE.Conditional) {
    return;
  }

  // remove one indent from each line inside this section
  output.remove_indent(frame.start_line_index);
}

// we could use just string.split, but
// IE doesn't like returning empty strings
function split_linebreaks(s) {
  //return s.split(/\x0d\x0a|\x0a/);

  s = s.replace(acorn.allLineBreaks, '\n');
  var out = [],
    idx = s.indexOf("\n");
  while (idx !== -1) {
    out.push(s.substring(0, idx));
    s = s.substring(idx + 1);
    idx = s.indexOf("\n");
  }
  if (s.length) {
    out.push(s);
  }
  return out;
}

function is_array(mode) {
  return mode === MODE.ArrayLiteral;
}

function is_expression(mode) {
  return in_array(mode, [MODE.Expression, MODE.ForInitializer, MODE.Conditional]);
}

function all_lines_start_with(lines, c) {
  for (var i = 0; i < lines.length; i++) {
    var line = lines[i].trim();
    if (line.charAt(0) !== c) {
      return false;
    }
  }
  return true;
}

function each_line_matches_indent(lines, indent) {
  var i = 0,
    len = lines.length,
    line;
  for (; i < len; i++) {
    line = lines[i];
    // allow empty lines to pass through
    if (line && line.indexOf(indent) !== 0) {
      return false;
    }
  }
  return true;
}


function Beautifier(source_text, options) {
  options = options || {};
  this._source_text = source_text || '';

  this._output = null;
  this._tokens = null;
  this._last_last_text = null;
  this._flags = null;
  this._previous_flags = null;

  this._flag_store = null;
  this._options = new Options(options);
}

Beautifier.prototype.create_flags = function(flags_base, mode) {
  var next_indent_level = 0;
  if (flags_base) {
    next_indent_level = flags_base.indentation_level;
    if (!this._output.just_added_newline() &&
      flags_base.line_indent_level > next_indent_level) {
      next_indent_level = flags_base.line_indent_level;
    }
  }

  var next_flags = {
    mode: mode,
    parent: flags_base,
    last_token: flags_base ? flags_base.last_token : new Token(TOKEN.START_BLOCK, ''), // last token text
    last_word: flags_base ? flags_base.last_word : '', // last TOKEN.WORD passed
    declaration_statement: false,
    declaration_assignment: false,
    multiline_frame: false,
    inline_frame: false,
    if_block: false,
    else_block: false,
    do_block: false,
    do_while: false,
    import_block: false,
    in_case_statement: false, // switch(..){ INSIDE HERE }
    in_case: false, // we're on the exact line with "case 0:"
    case_body: false, // the indented case-action block
    indentation_level: next_indent_level,
    alignment: 0,
    line_indent_level: flags_base ? flags_base.line_indent_level : next_indent_level,
    start_line_index: this._output.get_line_number(),
    ternary_depth: 0
  };
  return next_flags;
};

Beautifier.prototype._reset = function(source_text) {
  var baseIndentString = source_text.match(/^[\t ]*/)[0];

  this._last_last_text = ''; // pre-last token text
  this._output = new Output(this._options, baseIndentString);

  // If testing the ignore directive, start with output disable set to true
  this._output.raw = this._options.test_output_raw;


  // Stack of parsing/formatting states, including MODE.
  // We tokenize, parse, and output in an almost purely a forward-only stream of token input
  // and formatted output.  This makes the beautifier less accurate than full parsers
  // but also far more tolerant of syntax errors.
  //
  // For example, the default mode is MODE.BlockStatement. If we see a '{' we push a new frame of type
  // MODE.BlockStatement on the the stack, even though it could be object literal.  If we later
  // encounter a ":", we'll switch to to MODE.ObjectLiteral.  If we then see a ";",
  // most full parsers would die, but the beautifier gracefully falls back to
  // MODE.BlockStatement and continues on.
  this._flag_store = [];
  this.set_mode(MODE.BlockStatement);
  var tokenizer = new Tokenizer(source_text, this._options);
  this._tokens = tokenizer.tokenize();
  return source_text;
};

Beautifier.prototype.beautify = function() {
  // if disabled, return the input unchanged.
  if (this._options.disabled) {
    return this._source_text;
  }

  var sweet_code;
  var source_text = this._reset(this._source_text);

  var eol = this._options.eol;
  if (this._options.eol === 'auto') {
    eol = '\n';
    if (source_text && acorn.lineBreak.test(source_text || '')) {
      eol = source_text.match(acorn.lineBreak)[0];
    }
  }

  var current_token = this._tokens.next();
  while (current_token) {
    this.handle_token(current_token);

    this._last_last_text = this._flags.last_token.text;
    this._flags.last_token = current_token;

    current_token = this._tokens.next();
  }

  sweet_code = this._output.get_code(eol);

  return sweet_code;
};

Beautifier.prototype.handle_token = function(current_token, preserve_statement_flags) {
  if (current_token.type === TOKEN.START_EXPR) {
    this.handle_start_expr(current_token);
  } else if (current_token.type === TOKEN.END_EXPR) {
    this.handle_end_expr(current_token);
  } else if (current_token.type === TOKEN.START_BLOCK) {
    this.handle_start_block(current_token);
  } else if (current_token.type === TOKEN.END_BLOCK) {
    this.handle_end_block(current_token);
  } else if (current_token.type === TOKEN.WORD) {
    this.handle_word(current_token);
  } else if (current_token.type === TOKEN.RESERVED) {
    this.handle_word(current_token);
  } else if (current_token.type === TOKEN.SEMICOLON) {
    this.handle_semicolon(current_token);
  } else if (current_token.type === TOKEN.STRING) {
    this.handle_string(current_token);
  } else if (current_token.type === TOKEN.EQUALS) {
    this.handle_equals(current_token);
  } else if (current_token.type === TOKEN.OPERATOR) {
    this.handle_operator(current_token);
  } else if (current_token.type === TOKEN.COMMA) {
    this.handle_comma(current_token);
  } else if (current_token.type === TOKEN.BLOCK_COMMENT) {
    this.handle_block_comment(current_token, preserve_statement_flags);
  } else if (current_token.type === TOKEN.COMMENT) {
    this.handle_comment(current_token, preserve_statement_flags);
  } else if (current_token.type === TOKEN.DOT) {
    this.handle_dot(current_token);
  } else if (current_token.type === TOKEN.EOF) {
    this.handle_eof(current_token);
  } else if (current_token.type === TOKEN.UNKNOWN) {
    this.handle_unknown(current_token, preserve_statement_flags);
  } else {
    this.handle_unknown(current_token, preserve_statement_flags);
  }
};

Beautifier.prototype.handle_whitespace_and_comments = function(current_token, preserve_statement_flags) {
  var newlines = current_token.newlines;
  var keep_whitespace = this._options.keep_array_indentation && is_array(this._flags.mode);

  if (current_token.comments_before) {
    var comment_token = current_token.comments_before.next();
    while (comment_token) {
      // The cleanest handling of inline comments is to treat them as though they aren't there.
      // Just continue formatting and the behavior should be logical.
      // Also ignore unknown tokens.  Again, this should result in better behavior.
      this.handle_whitespace_and_comments(comment_token, preserve_statement_flags);
      this.handle_token(comment_token, preserve_statement_flags);
      comment_token = current_token.comments_before.next();
    }
  }

  if (keep_whitespace) {
    for (var i = 0; i < newlines; i += 1) {
      this.print_newline(i > 0, preserve_statement_flags);
    }
  } else {
    if (this._options.max_preserve_newlines && newlines > this._options.max_preserve_newlines) {
      newlines = this._options.max_preserve_newlines;
    }

    if (this._options.preserve_newlines) {
      if (newlines > 1) {
        this.print_newline(false, preserve_statement_flags);
        for (var j = 1; j < newlines; j += 1) {
          this.print_newline(true, preserve_statement_flags);
        }
      }
    }
  }

};

var newline_restricted_tokens = ['async', 'break', 'continue', 'return', 'throw', 'yield'];

Beautifier.prototype.allow_wrap_or_preserved_newline = function(current_token, force_linewrap) {
  force_linewrap = (force_linewrap === undefined) ? false : force_linewrap;

  // Never wrap the first token on a line
  if (this._output.just_added_newline()) {
    return;
  }

  var shouldPreserveOrForce = (this._options.preserve_newlines && current_token.newlines) || force_linewrap;
  var operatorLogicApplies = in_array(this._flags.last_token.text, positionable_operators) ||
    in_array(current_token.text, positionable_operators);

  if (operatorLogicApplies) {
    var shouldPrintOperatorNewline = (
        in_array(this._flags.last_token.text, positionable_operators) &&
        in_array(this._options.operator_position, OPERATOR_POSITION_BEFORE_OR_PRESERVE)
      ) ||
      in_array(current_token.text, positionable_operators);
    shouldPreserveOrForce = shouldPreserveOrForce && shouldPrintOperatorNewline;
  }

  if (shouldPreserveOrForce) {
    this.print_newline(false, true);
  } else if (this._options.wrap_line_length) {
    if (reserved_array(this._flags.last_token, newline_restricted_tokens)) {
      // These tokens should never have a newline inserted
      // between them and the following expression.
      return;
    }
    this._output.set_wrap_point();
  }
};

Beautifier.prototype.print_newline = function(force_newline, preserve_statement_flags) {
  if (!preserve_statement_flags) {
    if (this._flags.last_token.text !== ';' && this._flags.last_token.text !== ',' && this._flags.last_token.text !== '=' && (this._flags.last_token.type !== TOKEN.OPERATOR || this._flags.last_token.text === '--' || this._flags.last_token.text === '++')) {
      var next_token = this._tokens.peek();
      while (this._flags.mode === MODE.Statement &&
        !(this._flags.if_block && reserved_word(next_token, 'else')) &&
        !this._flags.do_block) {
        this.restore_mode();
      }
    }
  }

  if (this._output.add_new_line(force_newline)) {
    this._flags.multiline_frame = true;
  }
};

Beautifier.prototype.print_token_line_indentation = function(current_token) {
  if (this._output.just_added_newline()) {
    if (this._options.keep_array_indentation &&
      current_token.newlines &&
      (current_token.text === '[' || is_array(this._flags.mode))) {
      this._output.current_line.set_indent(-1);
      this._output.current_line.push(current_token.whitespace_before);
      this._output.space_before_token = false;
    } else if (this._output.set_indent(this._flags.indentation_level, this._flags.alignment)) {
      this._flags.line_indent_level = this._flags.indentation_level;
    }
  }
};

Beautifier.prototype.print_token = function(current_token) {
  if (this._output.raw) {
    this._output.add_raw_token(current_token);
    return;
  }

  if (this._options.comma_first && current_token.previous && current_token.previous.type === TOKEN.COMMA &&
    this._output.just_added_newline()) {
    if (this._output.previous_line.last() === ',') {
      var popped = this._output.previous_line.pop();
      // if the comma was already at the start of the line,
      // pull back onto that line and reprint the indentation
      if (this._output.previous_line.is_empty()) {
        this._output.previous_line.push(popped);
        this._output.trim(true);
        this._output.current_line.pop();
        this._output.trim();
      }

      // add the comma in front of the next token
      this.print_token_line_indentation(current_token);
      this._output.add_token(',');
      this._output.space_before_token = true;
    }
  }

  this.print_token_line_indentation(current_token);
  this._output.non_breaking_space = true;
  this._output.add_token(current_token.text);
  if (this._output.previous_token_wrapped) {
    this._flags.multiline_frame = true;
  }
};

Beautifier.prototype.indent = function() {
  this._flags.indentation_level += 1;
  this._output.set_indent(this._flags.indentation_level, this._flags.alignment);
};

Beautifier.prototype.deindent = function() {
  if (this._flags.indentation_level > 0 &&
    ((!this._flags.parent) || this._flags.indentation_level > this._flags.parent.indentation_level)) {
    this._flags.indentation_level -= 1;
    this._output.set_indent(this._flags.indentation_level, this._flags.alignment);
  }
};

Beautifier.prototype.set_mode = function(mode) {
  if (this._flags) {
    this._flag_store.push(this._flags);
    this._previous_flags = this._flags;
  } else {
    this._previous_flags = this.create_flags(null, mode);
  }

  this._flags = this.create_flags(this._previous_flags, mode);
  this._output.set_indent(this._flags.indentation_level, this._flags.alignment);
};


Beautifier.prototype.restore_mode = function() {
  if (this._flag_store.length > 0) {
    this._previous_flags = this._flags;
    this._flags = this._flag_store.pop();
    if (this._previous_flags.mode === MODE.Statement) {
      remove_redundant_indentation(this._output, this._previous_flags);
    }
    this._output.set_indent(this._flags.indentation_level, this._flags.alignment);
  }
};

Beautifier.prototype.start_of_object_property = function() {
  return this._flags.parent.mode === MODE.ObjectLiteral && this._flags.mode === MODE.Statement && (
    (this._flags.last_token.text === ':' && this._flags.ternary_depth === 0) || (reserved_array(this._flags.last_token, ['get', 'set'])));
};

Beautifier.prototype.start_of_statement = function(current_token) {
  var start = false;
  start = start || reserved_array(this._flags.last_token, ['var', 'let', 'const']) && current_token.type === TOKEN.WORD;
  start = start || reserved_word(this._flags.last_token, 'do');
  start = start || (!(this._flags.parent.mode === MODE.ObjectLiteral && this._flags.mode === MODE.Statement)) && reserved_array(this._flags.last_token, newline_restricted_tokens) && !current_token.newlines;
  start = start || reserved_word(this._flags.last_token, 'else') &&
    !(reserved_word(current_token, 'if') && !current_token.comments_before);
  start = start || (this._flags.last_token.type === TOKEN.END_EXPR && (this._previous_flags.mode === MODE.ForInitializer || this._previous_flags.mode === MODE.Conditional));
  start = start || (this._flags.last_token.type === TOKEN.WORD && this._flags.mode === MODE.BlockStatement &&
    !this._flags.in_case &&
    !(current_token.text === '--' || current_token.text === '++') &&
    this._last_last_text !== 'function' &&
    current_token.type !== TOKEN.WORD && current_token.type !== TOKEN.RESERVED);
  start = start || (this._flags.mode === MODE.ObjectLiteral && (
    (this._flags.last_token.text === ':' && this._flags.ternary_depth === 0) || reserved_array(this._flags.last_token, ['get', 'set'])));

  if (start) {
    this.set_mode(MODE.Statement);
    this.indent();

    this.handle_whitespace_and_comments(current_token, true);

    // Issue #276:
    // If starting a new statement with [if, for, while, do], push to a new line.
    // if (a) if (b) if(c) d(); else e(); else f();
    if (!this.start_of_object_property()) {
      this.allow_wrap_or_preserved_newline(current_token,
        reserved_array(current_token, ['do', 'for', 'if', 'while']));
    }
    return true;
  }
  return false;
};

Beautifier.prototype.handle_start_expr = function(current_token) {
  // The conditional starts the statement if appropriate.
  if (!this.start_of_statement(current_token)) {
    this.handle_whitespace_and_comments(current_token);
  }

  var next_mode = MODE.Expression;
  if (current_token.text === '[') {

    if (this._flags.last_token.type === TOKEN.WORD || this._flags.last_token.text === ')') {
      // this is array index specifier, break immediately
      // a[x], fn()[x]
      if (reserved_array(this._flags.last_token, line_starters)) {
        this._output.space_before_token = true;
      }
      this.print_token(current_token);
      this.set_mode(next_mode);
      this.indent();
      if (this._options.space_in_paren) {
        this._output.space_before_token = true;
      }
      return;
    }

    next_mode = MODE.ArrayLiteral;
    if (is_array(this._flags.mode)) {
      if (this._flags.last_token.text === '[' ||
        (this._flags.last_token.text === ',' && (this._last_last_text === ']' || this._last_last_text === '}'))) {
        // ], [ goes to new line
        // }, [ goes to new line
        if (!this._options.keep_array_indentation) {
          this.print_newline();
        }
      }
    }

    if (!in_array(this._flags.last_token.type, [TOKEN.START_EXPR, TOKEN.END_EXPR, TOKEN.WORD, TOKEN.OPERATOR, TOKEN.DOT])) {
      this._output.space_before_token = true;
    }
  } else {
    if (this._flags.last_token.type === TOKEN.RESERVED) {
      if (this._flags.last_token.text === 'for') {
        this._output.space_before_token = this._options.space_before_conditional;
        next_mode = MODE.ForInitializer;
      } else if (in_array(this._flags.last_token.text, ['if', 'while', 'switch'])) {
        this._output.space_before_token = this._options.space_before_conditional;
        next_mode = MODE.Conditional;
      } else if (in_array(this._flags.last_word, ['await', 'async'])) {
        // Should be a space between await and an IIFE, or async and an arrow function
        this._output.space_before_token = true;
      } else if (this._flags.last_token.text === 'import' && current_token.whitespace_before === '') {
        this._output.space_before_token = false;
      } else if (in_array(this._flags.last_token.text, line_starters) || this._flags.last_token.text === 'catch') {
        this._output.space_before_token = true;
      }
    } else if (this._flags.last_token.type === TOKEN.EQUALS || this._flags.last_token.type === TOKEN.OPERATOR) {
      // Support of this kind of newline preservation.
      // a = (b &&
      //     (c || d));
      if (!this.start_of_object_property()) {
        this.allow_wrap_or_preserved_newline(current_token);
      }
    } else if (this._flags.last_token.type === TOKEN.WORD) {
      this._output.space_before_token = false;

      // function name() vs function name ()
      // function* name() vs function* name ()
      // async name() vs async name ()
      // In ES6, you can also define the method properties of an object
      // var obj = {a: function() {}}
      // It can be abbreviated
      // var obj = {a() {}}
      // var obj = { a() {}} vs var obj = { a () {}}
      // var obj = { * a() {}} vs var obj = { * a () {}}
      var peek_back_two = this._tokens.peek(-3);
      if (this._options.space_after_named_function && peek_back_two) {
        // peek starts at next character so -1 is current token
        var peek_back_three = this._tokens.peek(-4);
        if (reserved_array(peek_back_two, ['async', 'function']) ||
          (peek_back_two.text === '*' && reserved_array(peek_back_three, ['async', 'function']))) {
          this._output.space_before_token = true;
        } else if (this._flags.mode === MODE.ObjectLiteral) {
          if ((peek_back_two.text === '{' || peek_back_two.text === ',') ||
            (peek_back_two.text === '*' && (peek_back_three.text === '{' || peek_back_three.text === ','))) {
            this._output.space_before_token = true;
          }
        }
      }
    } else {
      // Support preserving wrapped arrow function expressions
      // a.b('c',
      //     () => d.e
      // )
      this.allow_wrap_or_preserved_newline(current_token);
    }

    // function() vs function ()
    // yield*() vs yield* ()
    // function*() vs function* ()
    if ((this._flags.last_token.type === TOKEN.RESERVED && (this._flags.last_word === 'function' || this._flags.last_word === 'typeof')) ||
      (this._flags.last_token.text === '*' &&
        (in_array(this._last_last_text, ['function', 'yield']) ||
          (this._flags.mode === MODE.ObjectLiteral && in_array(this._last_last_text, ['{', ',']))))) {
      this._output.space_before_token = this._options.space_after_anon_function;
    }
  }

  if (this._flags.last_token.text === ';' || this._flags.last_token.type === TOKEN.START_BLOCK) {
    this.print_newline();
  } else if (this._flags.last_token.type === TOKEN.END_EXPR || this._flags.last_token.type === TOKEN.START_EXPR || this._flags.last_token.type === TOKEN.END_BLOCK || this._flags.last_token.text === '.' || this._flags.last_token.type === TOKEN.COMMA) {
    // do nothing on (( and )( and ][ and ]( and .(
    // TODO: Consider whether forcing this is required.  Review failing tests when removed.
    this.allow_wrap_or_preserved_newline(current_token, current_token.newlines);
  }

  this.print_token(current_token);
  this.set_mode(next_mode);
  if (this._options.space_in_paren) {
    this._output.space_before_token = true;
  }

  // In all cases, if we newline while inside an expression it should be indented.
  this.indent();
};

Beautifier.prototype.handle_end_expr = function(current_token) {
  // statements inside expressions are not valid syntax, but...
  // statements must all be closed when their container closes
  while (this._flags.mode === MODE.Statement) {
    this.restore_mode();
  }

  this.handle_whitespace_and_comments(current_token);

  if (this._flags.multiline_frame) {
    this.allow_wrap_or_preserved_newline(current_token,
      current_token.text === ']' && is_array(this._flags.mode) && !this._options.keep_array_indentation);
  }

  if (this._options.space_in_paren) {
    if (this._flags.last_token.type === TOKEN.START_EXPR && !this._options.space_in_empty_paren) {
      // () [] no inner space in empty parens like these, ever, ref #320
      this._output.trim();
      this._output.space_before_token = false;
    } else {
      this._output.space_before_token = true;
    }
  }
  this.deindent();
  this.print_token(current_token);
  this.restore_mode();

  remove_redundant_indentation(this._output, this._previous_flags);

  // do {} while () // no statement required after
  if (this._flags.do_while && this._previous_flags.mode === MODE.Conditional) {
    this._previous_flags.mode = MODE.Expression;
    this._flags.do_block = false;
    this._flags.do_while = false;

  }
};

Beautifier.prototype.handle_start_block = function(current_token) {
  this.handle_whitespace_and_comments(current_token);

  // Check if this is should be treated as a ObjectLiteral
  var next_token = this._tokens.peek();
  var second_token = this._tokens.peek(1);
  if (this._flags.last_word === 'switch' && this._flags.last_token.type === TOKEN.END_EXPR) {
    this.set_mode(MODE.BlockStatement);
    this._flags.in_case_statement = true;
  } else if (this._flags.case_body) {
    this.set_mode(MODE.BlockStatement);
  } else if (second_token && (
      (in_array(second_token.text, [':', ',']) && in_array(next_token.type, [TOKEN.STRING, TOKEN.WORD, TOKEN.RESERVED])) ||
      (in_array(next_token.text, ['get', 'set', '...']) && in_array(second_token.type, [TOKEN.WORD, TOKEN.RESERVED]))
    )) {
    // We don't support TypeScript,but we didn't break it for a very long time.
    // We'll try to keep not breaking it.
    if (!in_array(this._last_last_text, ['class', 'interface'])) {
      this.set_mode(MODE.ObjectLiteral);
    } else {
      this.set_mode(MODE.BlockStatement);
    }
  } else if (this._flags.last_token.type === TOKEN.OPERATOR && this._flags.last_token.text === '=>') {
    // arrow function: (param1, paramN) => { statements }
    this.set_mode(MODE.BlockStatement);
  } else if (in_array(this._flags.last_token.type, [TOKEN.EQUALS, TOKEN.START_EXPR, TOKEN.COMMA, TOKEN.OPERATOR]) ||
    reserved_array(this._flags.last_token, ['return', 'throw', 'import', 'default'])
  ) {
    // Detecting shorthand function syntax is difficult by scanning forward,
    //     so check the surrounding context.
    // If the block is being returned, imported, export default, passed as arg,
    //     assigned with = or assigned in a nested object, treat as an ObjectLiteral.
    this.set_mode(MODE.ObjectLiteral);
  } else {
    this.set_mode(MODE.BlockStatement);
  }

  var empty_braces = !next_token.comments_before && next_token.text === '}';
  var empty_anonymous_function = empty_braces && this._flags.last_word === 'function' &&
    this._flags.last_token.type === TOKEN.END_EXPR;

  if (this._options.brace_preserve_inline) // check for inline, set inline_frame if so
  {
    // search forward for a newline wanted inside this block
    var index = 0;
    var check_token = null;
    this._flags.inline_frame = true;
    do {
      index += 1;
      check_token = this._tokens.peek(index - 1);
      if (check_token.newlines) {
        this._flags.inline_frame = false;
        break;
      }
    } while (check_token.type !== TOKEN.EOF &&
      !(check_token.type === TOKEN.END_BLOCK && check_token.opened === current_token));
  }

  if ((this._options.brace_style === "expand" ||
      (this._options.brace_style === "none" && current_token.newlines)) &&
    !this._flags.inline_frame) {
    if (this._flags.last_token.type !== TOKEN.OPERATOR &&
      (empty_anonymous_function ||
        this._flags.last_token.type === TOKEN.EQUALS ||
        (reserved_array(this._flags.last_token, special_words) && this._flags.last_token.text !== 'else'))) {
      this._output.space_before_token = true;
    } else {
      this.print_newline(false, true);
    }
  } else { // collapse || inline_frame
    if (is_array(this._previous_flags.mode) && (this._flags.last_token.type === TOKEN.START_EXPR || this._flags.last_token.type === TOKEN.COMMA)) {
      if (this._flags.last_token.type === TOKEN.COMMA || this._options.space_in_paren) {
        this._output.space_before_token = true;
      }

      if (this._flags.last_token.type === TOKEN.COMMA || (this._flags.last_token.type === TOKEN.START_EXPR && this._flags.inline_frame)) {
        this.allow_wrap_or_preserved_newline(current_token);
        this._previous_flags.multiline_frame = this._previous_flags.multiline_frame || this._flags.multiline_frame;
        this._flags.multiline_frame = false;
      }
    }
    if (this._flags.last_token.type !== TOKEN.OPERATOR && this._flags.last_token.type !== TOKEN.START_EXPR) {
      if (this._flags.last_token.type === TOKEN.START_BLOCK && !this._flags.inline_frame) {
        this.print_newline();
      } else {
        this._output.space_before_token = true;
      }
    }
  }
  this.print_token(current_token);
  this.indent();

  // Except for specific cases, open braces are followed by a new line.
  if (!empty_braces && !(this._options.brace_preserve_inline && this._flags.inline_frame)) {
    this.print_newline();
  }
};

Beautifier.prototype.handle_end_block = function(current_token) {
  // statements must all be closed when their container closes
  this.handle_whitespace_and_comments(current_token);

  while (this._flags.mode === MODE.Statement) {
    this.restore_mode();
  }

  var empty_braces = this._flags.last_token.type === TOKEN.START_BLOCK;

  if (this._flags.inline_frame && !empty_braces) { // try inline_frame (only set if this._options.braces-preserve-inline) first
    this._output.space_before_token = true;
  } else if (this._options.brace_style === "expand") {
    if (!empty_braces) {
      this.print_newline();
    }
  } else {
    // skip {}
    if (!empty_braces) {
      if (is_array(this._flags.mode) && this._options.keep_array_indentation) {
        // we REALLY need a newline here, but newliner would skip that
        this._options.keep_array_indentation = false;
        this.print_newline();
        this._options.keep_array_indentation = true;

      } else {
        this.print_newline();
      }
    }
  }
  this.restore_mode();
  this.print_token(current_token);
};

Beautifier.prototype.handle_word = function(current_token) {
  if (current_token.type === TOKEN.RESERVED) {
    if (in_array(current_token.text, ['set', 'get']) && this._flags.mode !== MODE.ObjectLiteral) {
      current_token.type = TOKEN.WORD;
    } else if (current_token.text === 'import' && this._tokens.peek().text === '(') {
      current_token.type = TOKEN.WORD;
    } else if (in_array(current_token.text, ['as', 'from']) && !this._flags.import_block) {
      current_token.type = TOKEN.WORD;
    } else if (this._flags.mode === MODE.ObjectLiteral) {
      var next_token = this._tokens.peek();
      if (next_token.text === ':') {
        current_token.type = TOKEN.WORD;
      }
    }
  }

  if (this.start_of_statement(current_token)) {
    // The conditional starts the statement if appropriate.
    if (reserved_array(this._flags.last_token, ['var', 'let', 'const']) && current_token.type === TOKEN.WORD) {
      this._flags.declaration_statement = true;
    }
  } else if (current_token.newlines && !is_expression(this._flags.mode) &&
    (this._flags.last_token.type !== TOKEN.OPERATOR || (this._flags.last_token.text === '--' || this._flags.last_token.text === '++')) &&
    this._flags.last_token.type !== TOKEN.EQUALS &&
    (this._options.preserve_newlines || !reserved_array(this._flags.last_token, ['var', 'let', 'const', 'set', 'get']))) {
    this.handle_whitespace_and_comments(current_token);
    this.print_newline();
  } else {
    this.handle_whitespace_and_comments(current_token);
  }

  if (this._flags.do_block && !this._flags.do_while) {
    if (reserved_word(current_token, 'while')) {
      // do {} ## while ()
      this._output.space_before_token = true;
      this.print_token(current_token);
      this._output.space_before_token = true;
      this._flags.do_while = true;
      return;
    } else {
      // do {} should always have while as the next word.
      // if we don't see the expected while, recover
      this.print_newline();
      this._flags.do_block = false;
    }
  }

  // if may be followed by else, or not
  // Bare/inline ifs are tricky
  // Need to unwind the modes correctly: if (a) if (b) c(); else d(); else e();
  if (this._flags.if_block) {
    if (!this._flags.else_block && reserved_word(current_token, 'else')) {
      this._flags.else_block = true;
    } else {
      while (this._flags.mode === MODE.Statement) {
        this.restore_mode();
      }
      this._flags.if_block = false;
      this._flags.else_block = false;
    }
  }

  if (this._flags.in_case_statement && reserved_array(current_token, ['case', 'default'])) {
    this.print_newline();
    if (this._flags.last_token.type !== TOKEN.END_BLOCK && (this._flags.case_body || this._options.jslint_happy)) {
      // switch cases following one another
      this.deindent();
    }
    this._flags.case_body = false;

    this.print_token(current_token);
    this._flags.in_case = true;
    return;
  }

  if (this._flags.last_token.type === TOKEN.COMMA || this._flags.last_token.type === TOKEN.START_EXPR || this._flags.last_token.type === TOKEN.EQUALS || this._flags.last_token.type === TOKEN.OPERATOR) {
    if (!this.start_of_object_property()) {
      this.allow_wrap_or_preserved_newline(current_token);
    }
  }

  if (reserved_word(current_token, 'function')) {
    if (in_array(this._flags.last_token.text, ['}', ';']) ||
      (this._output.just_added_newline() && !(in_array(this._flags.last_token.text, ['(', '[', '{', ':', '=', ',']) || this._flags.last_token.type === TOKEN.OPERATOR))) {
      // make sure there is a nice clean space of at least one blank line
      // before a new function definition
      if (!this._output.just_added_blankline() && !current_token.comments_before) {
        this.print_newline();
        this.print_newline(true);
      }
    }
    if (this._flags.last_token.type === TOKEN.RESERVED || this._flags.last_token.type === TOKEN.WORD) {
      if (reserved_array(this._flags.last_token, ['get', 'set', 'new', 'export']) ||
        reserved_array(this._flags.last_token, newline_restricted_tokens)) {
        this._output.space_before_token = true;
      } else if (reserved_word(this._flags.last_token, 'default') && this._last_last_text === 'export') {
        this._output.space_before_token = true;
      } else if (this._flags.last_token.text === 'declare') {
        // accomodates Typescript declare function formatting
        this._output.space_before_token = true;
      } else {
        this.print_newline();
      }
    } else if (this._flags.last_token.type === TOKEN.OPERATOR || this._flags.last_token.text === '=') {
      // foo = function
      this._output.space_before_token = true;
    } else if (!this._flags.multiline_frame && (is_expression(this._flags.mode) || is_array(this._flags.mode))) {
      // (function
    } else {
      this.print_newline();
    }

    this.print_token(current_token);
    this._flags.last_word = current_token.text;
    return;
  }

  var prefix = 'NONE';

  if (this._flags.last_token.type === TOKEN.END_BLOCK) {

    if (this._previous_flags.inline_frame) {
      prefix = 'SPACE';
    } else if (!reserved_array(current_token, ['else', 'catch', 'finally', 'from'])) {
      prefix = 'NEWLINE';
    } else {
      if (this._options.brace_style === "expand" ||
        this._options.brace_style === "end-expand" ||
        (this._options.brace_style === "none" && current_token.newlines)) {
        prefix = 'NEWLINE';
      } else {
        prefix = 'SPACE';
        this._output.space_before_token = true;
      }
    }
  } else if (this._flags.last_token.type === TOKEN.SEMICOLON && this._flags.mode === MODE.BlockStatement) {
    // TODO: Should this be for STATEMENT as well?
    prefix = 'NEWLINE';
  } else if (this._flags.last_token.type === TOKEN.SEMICOLON && is_expression(this._flags.mode)) {
    prefix = 'SPACE';
  } else if (this._flags.last_token.type === TOKEN.STRING) {
    prefix = 'NEWLINE';
  } else if (this._flags.last_token.type === TOKEN.RESERVED || this._flags.last_token.type === TOKEN.WORD ||
    (this._flags.last_token.text === '*' &&
      (in_array(this._last_last_text, ['function', 'yield']) ||
        (this._flags.mode === MODE.ObjectLiteral && in_array(this._last_last_text, ['{', ',']))))) {
    prefix = 'SPACE';
  } else if (this._flags.last_token.type === TOKEN.START_BLOCK) {
    if (this._flags.inline_frame) {
      prefix = 'SPACE';
    } else {
      prefix = 'NEWLINE';
    }
  } else if (this._flags.last_token.type === TOKEN.END_EXPR) {
    this._output.space_before_token = true;
    prefix = 'NEWLINE';
  }

  if (reserved_array(current_token, line_starters) && this._flags.last_token.text !== ')') {
    if (this._flags.inline_frame || this._flags.last_token.text === 'else' || this._flags.last_token.text === 'export') {
      prefix = 'SPACE';
    } else {
      prefix = 'NEWLINE';
    }

  }

  if (reserved_array(current_token, ['else', 'catch', 'finally'])) {
    if ((!(this._flags.last_token.type === TOKEN.END_BLOCK && this._previous_flags.mode === MODE.BlockStatement) ||
        this._options.brace_style === "expand" ||
        this._options.brace_style === "end-expand" ||
        (this._options.brace_style === "none" && current_token.newlines)) &&
      !this._flags.inline_frame) {
      this.print_newline();
    } else {
      this._output.trim(true);
      var line = this._output.current_line;
      // If we trimmed and there's something other than a close block before us
      // put a newline back in.  Handles '} // comment' scenario.
      if (line.last() !== '}') {
        this.print_newline();
      }
      this._output.space_before_token = true;
    }
  } else if (prefix === 'NEWLINE') {
    if (reserved_array(this._flags.last_token, special_words)) {
      // no newline between 'return nnn'
      this._output.space_before_token = true;
    } else if (this._flags.last_token.text === 'declare' && reserved_array(current_token, ['var', 'let', 'const'])) {
      // accomodates Typescript declare formatting
      this._output.space_before_token = true;
    } else if (this._flags.last_token.type !== TOKEN.END_EXPR) {
      if ((this._flags.last_token.type !== TOKEN.START_EXPR || !reserved_array(current_token, ['var', 'let', 'const'])) && this._flags.last_token.text !== ':') {
        // no need to force newline on 'var': for (var x = 0...)
        if (reserved_word(current_token, 'if') && reserved_word(current_token.previous, 'else')) {
          // no newline for } else if {
          this._output.space_before_token = true;
        } else {
          this.print_newline();
        }
      }
    } else if (reserved_array(current_token, line_starters) && this._flags.last_token.text !== ')') {
      this.print_newline();
    }
  } else if (this._flags.multiline_frame && is_array(this._flags.mode) && this._flags.last_token.text === ',' && this._last_last_text === '}') {
    this.print_newline(); // }, in lists get a newline treatment
  } else if (prefix === 'SPACE') {
    this._output.space_before_token = true;
  }
  if (current_token.previous && (current_token.previous.type === TOKEN.WORD || current_token.previous.type === TOKEN.RESERVED)) {
    this._output.space_before_token = true;
  }
  this.print_token(current_token);
  this._flags.last_word = current_token.text;

  if (current_token.type === TOKEN.RESERVED) {
    if (current_token.text === 'do') {
      this._flags.do_block = true;
    } else if (current_token.text === 'if') {
      this._flags.if_block = true;
    } else if (current_token.text === 'import') {
      this._flags.import_block = true;
    } else if (this._flags.import_block && reserved_word(current_token, 'from')) {
      this._flags.import_block = false;
    }
  }
};

Beautifier.prototype.handle_semicolon = function(current_token) {
  if (this.start_of_statement(current_token)) {
    // The conditional starts the statement if appropriate.
    // Semicolon can be the start (and end) of a statement
    this._output.space_before_token = false;
  } else {
    this.handle_whitespace_and_comments(current_token);
  }

  var next_token = this._tokens.peek();
  while (this._flags.mode === MODE.Statement &&
    !(this._flags.if_block && reserved_word(next_token, 'else')) &&
    !this._flags.do_block) {
    this.restore_mode();
  }

  // hacky but effective for the moment
  if (this._flags.import_block) {
    this._flags.import_block = false;
  }
  this.print_token(current_token);
};

Beautifier.prototype.handle_string = function(current_token) {
  if (current_token.text.startsWith("`") && current_token.newlines === 0 && current_token.whitespace_before === '' && (current_token.previous.text === ')' || this._flags.last_token.type === TOKEN.WORD)) {
    //Conditional for detectign backtick strings
  } else if (this.start_of_statement(current_token)) {
    // The conditional starts the statement if appropriate.
    // One difference - strings want at least a space before
    this._output.space_before_token = true;
  } else {
    this.handle_whitespace_and_comments(current_token);
    if (this._flags.last_token.type === TOKEN.RESERVED || this._flags.last_token.type === TOKEN.WORD || this._flags.inline_frame) {
      this._output.space_before_token = true;
    } else if (this._flags.last_token.type === TOKEN.COMMA || this._flags.last_token.type === TOKEN.START_EXPR || this._flags.last_token.type === TOKEN.EQUALS || this._flags.last_token.type === TOKEN.OPERATOR) {
      if (!this.start_of_object_property()) {
        this.allow_wrap_or_preserved_newline(current_token);
      }
    } else if ((current_token.text.startsWith("`") && this._flags.last_token.type === TOKEN.END_EXPR && (current_token.previous.text === ']' || current_token.previous.text === ')') && current_token.newlines === 0)) {
      this._output.space_before_token = true;
    } else {
      this.print_newline();
    }
  }
  this.print_token(current_token);
};

Beautifier.prototype.handle_equals = function(current_token) {
  if (this.start_of_statement(current_token)) {
    // The conditional starts the statement if appropriate.
  } else {
    this.handle_whitespace_and_comments(current_token);
  }

  if (this._flags.declaration_statement) {
    // just got an '=' in a var-line, different formatting/line-breaking, etc will now be done
    this._flags.declaration_assignment = true;
  }
  this._output.space_before_token = true;
  this.print_token(current_token);
  this._output.space_before_token = true;
};

Beautifier.prototype.handle_comma = function(current_token) {
  this.handle_whitespace_and_comments(current_token, true);

  this.print_token(current_token);
  this._output.space_before_token = true;
  if (this._flags.declaration_statement) {
    if (is_expression(this._flags.parent.mode)) {
      // do not break on comma, for(var a = 1, b = 2)
      this._flags.declaration_assignment = false;
    }

    if (this._flags.declaration_assignment) {
      this._flags.declaration_assignment = false;
      this.print_newline(false, true);
    } else if (this._options.comma_first) {
      // for comma-first, we want to allow a newline before the comma
      // to turn into a newline after the comma, which we will fixup later
      this.allow_wrap_or_preserved_newline(current_token);
    }
  } else if (this._flags.mode === MODE.ObjectLiteral ||
    (this._flags.mode === MODE.Statement && this._flags.parent.mode === MODE.ObjectLiteral)) {
    if (this._flags.mode === MODE.Statement) {
      this.restore_mode();
    }

    if (!this._flags.inline_frame) {
      this.print_newline();
    }
  } else if (this._options.comma_first) {
    // EXPR or DO_BLOCK
    // for comma-first, we want to allow a newline before the comma
    // to turn into a newline after the comma, which we will fixup later
    this.allow_wrap_or_preserved_newline(current_token);
  }
};

Beautifier.prototype.handle_operator = function(current_token) {
  var isGeneratorAsterisk = current_token.text === '*' &&
    (reserved_array(this._flags.last_token, ['function', 'yield']) ||
      (in_array(this._flags.last_token.type, [TOKEN.START_BLOCK, TOKEN.COMMA, TOKEN.END_BLOCK, TOKEN.SEMICOLON]))
    );
  var isUnary = in_array(current_token.text, ['-', '+']) && (
    in_array(this._flags.last_token.type, [TOKEN.START_BLOCK, TOKEN.START_EXPR, TOKEN.EQUALS, TOKEN.OPERATOR]) ||
    in_array(this._flags.last_token.text, line_starters) ||
    this._flags.last_token.text === ','
  );

  if (this.start_of_statement(current_token)) {
    // The conditional starts the statement if appropriate.
  } else {
    var preserve_statement_flags = !isGeneratorAsterisk;
    this.handle_whitespace_and_comments(current_token, preserve_statement_flags);
  }

  if (reserved_array(this._flags.last_token, special_words)) {
    // "return" had a special handling in TK_WORD. Now we need to return the favor
    this._output.space_before_token = true;
    this.print_token(current_token);
    return;
  }

  // hack for actionscript's import .*;
  if (current_token.text === '*' && this._flags.last_token.type === TOKEN.DOT) {
    this.print_token(current_token);
    return;
  }

  if (current_token.text === '::') {
    // no spaces around exotic namespacing syntax operator
    this.print_token(current_token);
    return;
  }

  // Allow line wrapping between operators when operator_position is
  //   set to before or preserve
  if (this._flags.last_token.type === TOKEN.OPERATOR && in_array(this._options.operator_position, OPERATOR_POSITION_BEFORE_OR_PRESERVE)) {
    this.allow_wrap_or_preserved_newline(current_token);
  }

  if (current_token.text === ':' && this._flags.in_case) {
    this.print_token(current_token);

    this._flags.in_case = false;
    this._flags.case_body = true;
    if (this._tokens.peek().type !== TOKEN.START_BLOCK) {
      this.indent();
      this.print_newline();
    } else {
      this._output.space_before_token = true;
    }
    return;
  }

  var space_before = true;
  var space_after = true;
  var in_ternary = false;
  if (current_token.text === ':') {
    if (this._flags.ternary_depth === 0) {
      // Colon is invalid javascript outside of ternary and object, but do our best to guess what was meant.
      space_before = false;
    } else {
      this._flags.ternary_depth -= 1;
      in_ternary = true;
    }
  } else if (current_token.text === '?') {
    this._flags.ternary_depth += 1;
  }

  // let's handle the operator_position option prior to any conflicting logic
  if (!isUnary && !isGeneratorAsterisk && this._options.preserve_newlines && in_array(current_token.text, positionable_operators)) {
    var isColon = current_token.text === ':';
    var isTernaryColon = (isColon && in_ternary);
    var isOtherColon = (isColon && !in_ternary);

    switch (this._options.operator_position) {
      case OPERATOR_POSITION.before_newline:
        // if the current token is : and it's not a ternary statement then we set space_before to false
        this._output.space_before_token = !isOtherColon;

        this.print_token(current_token);

        if (!isColon || isTernaryColon) {
          this.allow_wrap_or_preserved_newline(current_token);
        }

        this._output.space_before_token = true;
        return;

      case OPERATOR_POSITION.after_newline:
        // if the current token is anything but colon, or (via deduction) it's a colon and in a ternary statement,
        //   then print a newline.

        this._output.space_before_token = true;

        if (!isColon || isTernaryColon) {
          if (this._tokens.peek().newlines) {
            this.print_newline(false, true);
          } else {
            this.allow_wrap_or_preserved_newline(current_token);
          }
        } else {
          this._output.space_before_token = false;
        }

        this.print_token(current_token);

        this._output.space_before_token = true;
        return;

      case OPERATOR_POSITION.preserve_newline:
        if (!isOtherColon) {
          this.allow_wrap_or_preserved_newline(current_token);
        }

        // if we just added a newline, or the current token is : and it's not a ternary statement,
        //   then we set space_before to false
        space_before = !(this._output.just_added_newline() || isOtherColon);

        this._output.space_before_token = space_before;
        this.print_token(current_token);
        this._output.space_before_token = true;
        return;
    }
  }

  if (isGeneratorAsterisk) {
    this.allow_wrap_or_preserved_newline(current_token);
    space_before = false;
    var next_token = this._tokens.peek();
    space_after = next_token && in_array(next_token.type, [TOKEN.WORD, TOKEN.RESERVED]);
  } else if (current_token.text === '...') {
    this.allow_wrap_or_preserved_newline(current_token);
    space_before = this._flags.last_token.type === TOKEN.START_BLOCK;
    space_after = false;
  } else if (in_array(current_token.text, ['--', '++', '!', '~']) || isUnary) {
    // unary operators (and binary +/- pretending to be unary) special cases
    if (this._flags.last_token.type === TOKEN.COMMA || this._flags.last_token.type === TOKEN.START_EXPR) {
      this.allow_wrap_or_preserved_newline(current_token);
    }

    space_before = false;
    space_after = false;

    // http://www.ecma-international.org/ecma-262/5.1/#sec-7.9.1
    // if there is a newline between -- or ++ and anything else we should preserve it.
    if (current_token.newlines && (current_token.text === '--' || current_token.text === '++')) {
      this.print_newline(false, true);
    }

    if (this._flags.last_token.text === ';' && is_expression(this._flags.mode)) {
      // for (;; ++i)
      //        ^^^
      space_before = true;
    }

    if (this._flags.last_token.type === TOKEN.RESERVED) {
      space_before = true;
    } else if (this._flags.last_token.type === TOKEN.END_EXPR) {
      space_before = !(this._flags.last_token.text === ']' && (current_token.text === '--' || current_token.text === '++'));
    } else if (this._flags.last_token.type === TOKEN.OPERATOR) {
      // a++ + ++b;
      // a - -b
      space_before = in_array(current_token.text, ['--', '-', '++', '+']) && in_array(this._flags.last_token.text, ['--', '-', '++', '+']);
      // + and - are not unary when preceeded by -- or ++ operator
      // a-- + b
      // a * +b
      // a - -b
      if (in_array(current_token.text, ['+', '-']) && in_array(this._flags.last_token.text, ['--', '++'])) {
        space_after = true;
      }
    }


    if (((this._flags.mode === MODE.BlockStatement && !this._flags.inline_frame) || this._flags.mode === MODE.Statement) &&
      (this._flags.last_token.text === '{' || this._flags.last_token.text === ';')) {
      // { foo; --i }
      // foo(); --bar;
      this.print_newline();
    }
  }

  this._output.space_before_token = this._output.space_before_token || space_before;
  this.print_token(current_token);
  this._output.space_before_token = space_after;
};

Beautifier.prototype.handle_block_comment = function(current_token, preserve_statement_flags) {
  if (this._output.raw) {
    this._output.add_raw_token(current_token);
    if (current_token.directives && current_token.directives.preserve === 'end') {
      // If we're testing the raw output behavior, do not allow a directive to turn it off.
      this._output.raw = this._options.test_output_raw;
    }
    return;
  }

  if (current_token.directives) {
    this.print_newline(false, preserve_statement_flags);
    this.print_token(current_token);
    if (current_token.directives.preserve === 'start') {
      this._output.raw = true;
    }
    this.print_newline(false, true);
    return;
  }

  // inline block
  if (!acorn.newline.test(current_token.text) && !current_token.newlines) {
    this._output.space_before_token = true;
    this.print_token(current_token);
    this._output.space_before_token = true;
    return;
  } else {
    this.print_block_commment(current_token, preserve_statement_flags);
  }
};

Beautifier.prototype.print_block_commment = function(current_token, preserve_statement_flags) {
  var lines = split_linebreaks(current_token.text);
  var j; // iterator for this case
  var javadoc = false;
  var starless = false;
  var lastIndent = current_token.whitespace_before;
  var lastIndentLength = lastIndent.length;

  // block comment starts with a new line
  this.print_newline(false, preserve_statement_flags);

  // first line always indented
  this.print_token_line_indentation(current_token);
  this._output.add_token(lines[0]);
  this.print_newline(false, preserve_statement_flags);


  if (lines.length > 1) {
    lines = lines.slice(1);
    javadoc = all_lines_start_with(lines, '*');
    starless = each_line_matches_indent(lines, lastIndent);

    if (javadoc) {
      this._flags.alignment = 1;
    }

    for (j = 0; j < lines.length; j++) {
      if (javadoc) {
        // javadoc: reformat and re-indent
        this.print_token_line_indentation(current_token);
        this._output.add_token(ltrim(lines[j]));
      } else if (starless && lines[j]) {
        // starless: re-indent non-empty content, avoiding trim
        this.print_token_line_indentation(current_token);
        this._output.add_token(lines[j].substring(lastIndentLength));
      } else {
        // normal comments output raw
        this._output.current_line.set_indent(-1);
        this._output.add_token(lines[j]);
      }

      // for comments on their own line or  more than one line, make sure there's a new line after
      this.print_newline(false, preserve_statement_flags);
    }

    this._flags.alignment = 0;
  }
};


Beautifier.prototype.handle_comment = function(current_token, preserve_statement_flags) {
  if (current_token.newlines) {
    this.print_newline(false, preserve_statement_flags);
  } else {
    this._output.trim(true);
  }

  this._output.space_before_token = true;
  this.print_token(current_token);
  this.print_newline(false, preserve_statement_flags);
};

Beautifier.prototype.handle_dot = function(current_token) {
  if (this.start_of_statement(current_token)) {
    // The conditional starts the statement if appropriate.
  } else {
    this.handle_whitespace_and_comments(current_token, true);
  }

  if (reserved_array(this._flags.last_token, special_words)) {
    this._output.space_before_token = false;
  } else {
    // allow preserved newlines before dots in general
    // force newlines on dots after close paren when break_chained - for bar().baz()
    this.allow_wrap_or_preserved_newline(current_token,
      this._flags.last_token.text === ')' && this._options.break_chained_methods);
  }

  // Only unindent chained method dot if this dot starts a new line.
  // Otherwise the automatic extra indentation removal will handle the over indent
  if (this._options.unindent_chained_methods && this._output.just_added_newline()) {
    this.deindent();
  }

  this.print_token(current_token);
};

Beautifier.prototype.handle_unknown = function(current_token, preserve_statement_flags) {
  this.print_token(current_token);

  if (current_token.text[current_token.text.length - 1] === '\n') {
    this.print_newline(false, preserve_statement_flags);
  }
};

Beautifier.prototype.handle_eof = function(current_token) {
  // Unwind any open statements
  while (this._flags.mode === MODE.Statement) {
    this.restore_mode();
  }
  this.handle_whitespace_and_comments(current_token);
};

module.exports.Beautifier = Beautifier;


/***/ }),
/* 2 */
/***/ (function(module) {

/*jshint node:true */
/*
  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



function OutputLine(parent) {
  this.__parent = parent;
  this.__character_count = 0;
  // use indent_count as a marker for this.__lines that have preserved indentation
  this.__indent_count = -1;
  this.__alignment_count = 0;
  this.__wrap_point_index = 0;
  this.__wrap_point_character_count = 0;
  this.__wrap_point_indent_count = -1;
  this.__wrap_point_alignment_count = 0;

  this.__items = [];
}

OutputLine.prototype.clone_empty = function() {
  var line = new OutputLine(this.__parent);
  line.set_indent(this.__indent_count, this.__alignment_count);
  return line;
};

OutputLine.prototype.item = function(index) {
  if (index < 0) {
    return this.__items[this.__items.length + index];
  } else {
    return this.__items[index];
  }
};

OutputLine.prototype.has_match = function(pattern) {
  for (var lastCheckedOutput = this.__items.length - 1; lastCheckedOutput >= 0; lastCheckedOutput--) {
    if (this.__items[lastCheckedOutput].match(pattern)) {
      return true;
    }
  }
  return false;
};

OutputLine.prototype.set_indent = function(indent, alignment) {
  if (this.is_empty()) {
    this.__indent_count = indent || 0;
    this.__alignment_count = alignment || 0;
    this.__character_count = this.__parent.get_indent_size(this.__indent_count, this.__alignment_count);
  }
};

OutputLine.prototype._set_wrap_point = function() {
  if (this.__parent.wrap_line_length) {
    this.__wrap_point_index = this.__items.length;
    this.__wrap_point_character_count = this.__character_count;
    this.__wrap_point_indent_count = this.__parent.next_line.__indent_count;
    this.__wrap_point_alignment_count = this.__parent.next_line.__alignment_count;
  }
};

OutputLine.prototype._should_wrap = function() {
  return this.__wrap_point_index &&
    this.__character_count > this.__parent.wrap_line_length &&
    this.__wrap_point_character_count > this.__parent.next_line.__character_count;
};

OutputLine.prototype._allow_wrap = function() {
  if (this._should_wrap()) {
    this.__parent.add_new_line();
    var next = this.__parent.current_line;
    next.set_indent(this.__wrap_point_indent_count, this.__wrap_point_alignment_count);
    next.__items = this.__items.slice(this.__wrap_point_index);
    this.__items = this.__items.slice(0, this.__wrap_point_index);

    next.__character_count += this.__character_count - this.__wrap_point_character_count;
    this.__character_count = this.__wrap_point_character_count;

    if (next.__items[0] === " ") {
      next.__items.splice(0, 1);
      next.__character_count -= 1;
    }
    return true;
  }
  return false;
};

OutputLine.prototype.is_empty = function() {
  return this.__items.length === 0;
};

OutputLine.prototype.last = function() {
  if (!this.is_empty()) {
    return this.__items[this.__items.length - 1];
  } else {
    return null;
  }
};

OutputLine.prototype.push = function(item) {
  this.__items.push(item);
  var last_newline_index = item.lastIndexOf('\n');
  if (last_newline_index !== -1) {
    this.__character_count = item.length - last_newline_index;
  } else {
    this.__character_count += item.length;
  }
};

OutputLine.prototype.pop = function() {
  var item = null;
  if (!this.is_empty()) {
    item = this.__items.pop();
    this.__character_count -= item.length;
  }
  return item;
};


OutputLine.prototype._remove_indent = function() {
  if (this.__indent_count > 0) {
    this.__indent_count -= 1;
    this.__character_count -= this.__parent.indent_size;
  }
};

OutputLine.prototype._remove_wrap_indent = function() {
  if (this.__wrap_point_indent_count > 0) {
    this.__wrap_point_indent_count -= 1;
  }
};
OutputLine.prototype.trim = function() {
  while (this.last() === ' ') {
    this.__items.pop();
    this.__character_count -= 1;
  }
};

OutputLine.prototype.toString = function() {
  var result = '';
  if (this.is_empty()) {
    if (this.__parent.indent_empty_lines) {
      result = this.__parent.get_indent_string(this.__indent_count);
    }
  } else {
    result = this.__parent.get_indent_string(this.__indent_count, this.__alignment_count);
    result += this.__items.join('');
  }
  return result;
};

function IndentStringCache(options, baseIndentString) {
  this.__cache = [''];
  this.__indent_size = options.indent_size;
  this.__indent_string = options.indent_char;
  if (!options.indent_with_tabs) {
    this.__indent_string = new Array(options.indent_size + 1).join(options.indent_char);
  }

  // Set to null to continue support for auto detection of base indent
  baseIndentString = baseIndentString || '';
  if (options.indent_level > 0) {
    baseIndentString = new Array(options.indent_level + 1).join(this.__indent_string);
  }

  this.__base_string = baseIndentString;
  this.__base_string_length = baseIndentString.length;
}

IndentStringCache.prototype.get_indent_size = function(indent, column) {
  var result = this.__base_string_length;
  column = column || 0;
  if (indent < 0) {
    result = 0;
  }
  result += indent * this.__indent_size;
  result += column;
  return result;
};

IndentStringCache.prototype.get_indent_string = function(indent_level, column) {
  var result = this.__base_string;
  column = column || 0;
  if (indent_level < 0) {
    indent_level = 0;
    result = '';
  }
  column += indent_level * this.__indent_size;
  this.__ensure_cache(column);
  result += this.__cache[column];
  return result;
};

IndentStringCache.prototype.__ensure_cache = function(column) {
  while (column >= this.__cache.length) {
    this.__add_column();
  }
};

IndentStringCache.prototype.__add_column = function() {
  var column = this.__cache.length;
  var indent = 0;
  var result = '';
  if (this.__indent_size && column >= this.__indent_size) {
    indent = Math.floor(column / this.__indent_size);
    column -= indent * this.__indent_size;
    result = new Array(indent + 1).join(this.__indent_string);
  }
  if (column) {
    result += new Array(column + 1).join(' ');
  }

  this.__cache.push(result);
};

function Output(options, baseIndentString) {
  this.__indent_cache = new IndentStringCache(options, baseIndentString);
  this.raw = false;
  this._end_with_newline = options.end_with_newline;
  this.indent_size = options.indent_size;
  this.wrap_line_length = options.wrap_line_length;
  this.indent_empty_lines = options.indent_empty_lines;
  this.__lines = [];
  this.previous_line = null;
  this.current_line = null;
  this.next_line = new OutputLine(this);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = false;
  // initialize
  this.__add_outputline();
}

Output.prototype.__add_outputline = function() {
  this.previous_line = this.current_line;
  this.current_line = this.next_line.clone_empty();
  this.__lines.push(this.current_line);
};

Output.prototype.get_line_number = function() {
  return this.__lines.length;
};

Output.prototype.get_indent_string = function(indent, column) {
  return this.__indent_cache.get_indent_string(indent, column);
};

Output.prototype.get_indent_size = function(indent, column) {
  return this.__indent_cache.get_indent_size(indent, column);
};

Output.prototype.is_empty = function() {
  return !this.previous_line && this.current_line.is_empty();
};

Output.prototype.add_new_line = function(force_newline) {
  // never newline at the start of file
  // otherwise, newline only if we didn't just add one or we're forced
  if (this.is_empty() ||
    (!force_newline && this.just_added_newline())) {
    return false;
  }

  // if raw output is enabled, don't print additional newlines,
  // but still return True as though you had
  if (!this.raw) {
    this.__add_outputline();
  }
  return true;
};

Output.prototype.get_code = function(eol) {
  this.trim(true);

  // handle some edge cases where the last tokens
  // has text that ends with newline(s)
  var last_item = this.current_line.pop();
  if (last_item) {
    if (last_item[last_item.length - 1] === '\n') {
      last_item = last_item.replace(/\n+$/g, '');
    }
    this.current_line.push(last_item);
  }

  if (this._end_with_newline) {
    this.__add_outputline();
  }

  var sweet_code = this.__lines.join('\n');

  if (eol !== '\n') {
    sweet_code = sweet_code.replace(/[\n]/g, eol);
  }
  return sweet_code;
};

Output.prototype.set_wrap_point = function() {
  this.current_line._set_wrap_point();
};

Output.prototype.set_indent = function(indent, alignment) {
  indent = indent || 0;
  alignment = alignment || 0;

  // Next line stores alignment values
  this.next_line.set_indent(indent, alignment);

  // Never indent your first output indent at the start of the file
  if (this.__lines.length > 1) {
    this.current_line.set_indent(indent, alignment);
    return true;
  }

  this.current_line.set_indent();
  return false;
};

Output.prototype.add_raw_token = function(token) {
  for (var x = 0; x < token.newlines; x++) {
    this.__add_outputline();
  }
  this.current_line.set_indent(-1);
  this.current_line.push(token.whitespace_before);
  this.current_line.push(token.text);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = false;
};

Output.prototype.add_token = function(printable_token) {
  this.__add_space_before_token();
  this.current_line.push(printable_token);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = this.current_line._allow_wrap();
};

Output.prototype.__add_space_before_token = function() {
  if (this.space_before_token && !this.just_added_newline()) {
    if (!this.non_breaking_space) {
      this.set_wrap_point();
    }
    this.current_line.push(' ');
  }
};

Output.prototype.remove_indent = function(index) {
  var output_length = this.__lines.length;
  while (index < output_length) {
    this.__lines[index]._remove_indent();
    index++;
  }
  this.current_line._remove_wrap_indent();
};

Output.prototype.trim = function(eat_newlines) {
  eat_newlines = (eat_newlines === undefined) ? false : eat_newlines;

  this.current_line.trim();

  while (eat_newlines && this.__lines.length > 1 &&
    this.current_line.is_empty()) {
    this.__lines.pop();
    this.current_line = this.__lines[this.__lines.length - 1];
    this.current_line.trim();
  }

  this.previous_line = this.__lines.length > 1 ?
    this.__lines[this.__lines.length - 2] : null;
};

Output.prototype.just_added_newline = function() {
  return this.current_line.is_empty();
};

Output.prototype.just_added_blankline = function() {
  return this.is_empty() ||
    (this.current_line.is_empty() && this.previous_line.is_empty());
};

Output.prototype.ensure_empty_line_above = function(starts_with, ends_with) {
  var index = this.__lines.length - 2;
  while (index >= 0) {
    var potentialEmptyLine = this.__lines[index];
    if (potentialEmptyLine.is_empty()) {
      break;
    } else if (potentialEmptyLine.item(0).indexOf(starts_with) !== 0 &&
      potentialEmptyLine.item(-1) !== ends_with) {
      this.__lines.splice(index + 1, 0, new OutputLine(this));
      this.previous_line = this.__lines[this.__lines.length - 2];
      break;
    }
    index--;
  }
};

module.exports.Output = Output;


/***/ }),
/* 3 */
/***/ (function(module) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



function Token(type, text, newlines, whitespace_before) {
  this.type = type;
  this.text = text;

  // comments_before are
  // comments that have a new line before them
  // and may or may not have a newline after
  // this is a set of comments before
  this.comments_before = null; /* inline comment*/


  // this.comments_after =  new TokenStream(); // no new line before and newline after
  this.newlines = newlines || 0;
  this.whitespace_before = whitespace_before || '';
  this.parent = null;
  this.next = null;
  this.previous = null;
  this.opened = null;
  this.closed = null;
  this.directives = null;
}


module.exports.Token = Token;


/***/ }),
/* 4 */
/***/ (function(__unused_webpack_module, exports) {

/* jshint node: true, curly: false */
// Parts of this section of code is taken from acorn.
//
// Acorn was written by Marijn Haverbeke and released under an MIT
// license. The Unicode regexps (for identifiers and whitespace) were
// taken from [Esprima](http://esprima.org) by Ariya Hidayat.
//
// Git repositories for Acorn are available at
//
//     http://marijnhaverbeke.nl/git/acorn
//     https://github.com/marijnh/acorn.git

// ## Character categories




// acorn used char codes to squeeze the last bit of performance out
// Beautifier is okay without that, so we're using regex
// permit # (23), $ (36), and @ (64). @ is used in ES7 decorators.
// 65 through 91 are uppercase letters.
// permit _ (95).
// 97 through 123 are lowercase letters.
var baseASCIIidentifierStartChars = "\\x23\\x24\\x40\\x41-\\x5a\\x5f\\x61-\\x7a";

// inside an identifier @ is not allowed but 0-9 are.
var baseASCIIidentifierChars = "\\x24\\x30-\\x39\\x41-\\x5a\\x5f\\x61-\\x7a";

// Big ugly regular expressions that match characters in the
// whitespace, identifier, and identifier-start categories. These
// are only applied when a character is found to actually have a
// code point above 128.
var nonASCIIidentifierStartChars = "\\xaa\\xb5\\xba\\xc0-\\xd6\\xd8-\\xf6\\xf8-\\u02c1\\u02c6-\\u02d1\\u02e0-\\u02e4\\u02ec\\u02ee\\u0370-\\u0374\\u0376\\u0377\\u037a-\\u037d\\u0386\\u0388-\\u038a\\u038c\\u038e-\\u03a1\\u03a3-\\u03f5\\u03f7-\\u0481\\u048a-\\u0527\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05d0-\\u05ea\\u05f0-\\u05f2\\u0620-\\u064a\\u066e\\u066f\\u0671-\\u06d3\\u06d5\\u06e5\\u06e6\\u06ee\\u06ef\\u06fa-\\u06fc\\u06ff\\u0710\\u0712-\\u072f\\u074d-\\u07a5\\u07b1\\u07ca-\\u07ea\\u07f4\\u07f5\\u07fa\\u0800-\\u0815\\u081a\\u0824\\u0828\\u0840-\\u0858\\u08a0\\u08a2-\\u08ac\\u0904-\\u0939\\u093d\\u0950\\u0958-\\u0961\\u0971-\\u0977\\u0979-\\u097f\\u0985-\\u098c\\u098f\\u0990\\u0993-\\u09a8\\u09aa-\\u09b0\\u09b2\\u09b6-\\u09b9\\u09bd\\u09ce\\u09dc\\u09dd\\u09df-\\u09e1\\u09f0\\u09f1\\u0a05-\\u0a0a\\u0a0f\\u0a10\\u0a13-\\u0a28\\u0a2a-\\u0a30\\u0a32\\u0a33\\u0a35\\u0a36\\u0a38\\u0a39\\u0a59-\\u0a5c\\u0a5e\\u0a72-\\u0a74\\u0a85-\\u0a8d\\u0a8f-\\u0a91\\u0a93-\\u0aa8\\u0aaa-\\u0ab0\\u0ab2\\u0ab3\\u0ab5-\\u0ab9\\u0abd\\u0ad0\\u0ae0\\u0ae1\\u0b05-\\u0b0c\\u0b0f\\u0b10\\u0b13-\\u0b28\\u0b2a-\\u0b30\\u0b32\\u0b33\\u0b35-\\u0b39\\u0b3d\\u0b5c\\u0b5d\\u0b5f-\\u0b61\\u0b71\\u0b83\\u0b85-\\u0b8a\\u0b8e-\\u0b90\\u0b92-\\u0b95\\u0b99\\u0b9a\\u0b9c\\u0b9e\\u0b9f\\u0ba3\\u0ba4\\u0ba8-\\u0baa\\u0bae-\\u0bb9\\u0bd0\\u0c05-\\u0c0c\\u0c0e-\\u0c10\\u0c12-\\u0c28\\u0c2a-\\u0c33\\u0c35-\\u0c39\\u0c3d\\u0c58\\u0c59\\u0c60\\u0c61\\u0c85-\\u0c8c\\u0c8e-\\u0c90\\u0c92-\\u0ca8\\u0caa-\\u0cb3\\u0cb5-\\u0cb9\\u0cbd\\u0cde\\u0ce0\\u0ce1\\u0cf1\\u0cf2\\u0d05-\\u0d0c\\u0d0e-\\u0d10\\u0d12-\\u0d3a\\u0d3d\\u0d4e\\u0d60\\u0d61\\u0d7a-\\u0d7f\\u0d85-\\u0d96\\u0d9a-\\u0db1\\u0db3-\\u0dbb\\u0dbd\\u0dc0-\\u0dc6\\u0e01-\\u0e30\\u0e32\\u0e33\\u0e40-\\u0e46\\u0e81\\u0e82\\u0e84\\u0e87\\u0e88\\u0e8a\\u0e8d\\u0e94-\\u0e97\\u0e99-\\u0e9f\\u0ea1-\\u0ea3\\u0ea5\\u0ea7\\u0eaa\\u0eab\\u0ead-\\u0eb0\\u0eb2\\u0eb3\\u0ebd\\u0ec0-\\u0ec4\\u0ec6\\u0edc-\\u0edf\\u0f00\\u0f40-\\u0f47\\u0f49-\\u0f6c\\u0f88-\\u0f8c\\u1000-\\u102a\\u103f\\u1050-\\u1055\\u105a-\\u105d\\u1061\\u1065\\u1066\\u106e-\\u1070\\u1075-\\u1081\\u108e\\u10a0-\\u10c5\\u10c7\\u10cd\\u10d0-\\u10fa\\u10fc-\\u1248\\u124a-\\u124d\\u1250-\\u1256\\u1258\\u125a-\\u125d\\u1260-\\u1288\\u128a-\\u128d\\u1290-\\u12b0\\u12b2-\\u12b5\\u12b8-\\u12be\\u12c0\\u12c2-\\u12c5\\u12c8-\\u12d6\\u12d8-\\u1310\\u1312-\\u1315\\u1318-\\u135a\\u1380-\\u138f\\u13a0-\\u13f4\\u1401-\\u166c\\u166f-\\u167f\\u1681-\\u169a\\u16a0-\\u16ea\\u16ee-\\u16f0\\u1700-\\u170c\\u170e-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176c\\u176e-\\u1770\\u1780-\\u17b3\\u17d7\\u17dc\\u1820-\\u1877\\u1880-\\u18a8\\u18aa\\u18b0-\\u18f5\\u1900-\\u191c\\u1950-\\u196d\\u1970-\\u1974\\u1980-\\u19ab\\u19c1-\\u19c7\\u1a00-\\u1a16\\u1a20-\\u1a54\\u1aa7\\u1b05-\\u1b33\\u1b45-\\u1b4b\\u1b83-\\u1ba0\\u1bae\\u1baf\\u1bba-\\u1be5\\u1c00-\\u1c23\\u1c4d-\\u1c4f\\u1c5a-\\u1c7d\\u1ce9-\\u1cec\\u1cee-\\u1cf1\\u1cf5\\u1cf6\\u1d00-\\u1dbf\\u1e00-\\u1f15\\u1f18-\\u1f1d\\u1f20-\\u1f45\\u1f48-\\u1f4d\\u1f50-\\u1f57\\u1f59\\u1f5b\\u1f5d\\u1f5f-\\u1f7d\\u1f80-\\u1fb4\\u1fb6-\\u1fbc\\u1fbe\\u1fc2-\\u1fc4\\u1fc6-\\u1fcc\\u1fd0-\\u1fd3\\u1fd6-\\u1fdb\\u1fe0-\\u1fec\\u1ff2-\\u1ff4\\u1ff6-\\u1ffc\\u2071\\u207f\\u2090-\\u209c\\u2102\\u2107\\u210a-\\u2113\\u2115\\u2119-\\u211d\\u2124\\u2126\\u2128\\u212a-\\u212d\\u212f-\\u2139\\u213c-\\u213f\\u2145-\\u2149\\u214e\\u2160-\\u2188\\u2c00-\\u2c2e\\u2c30-\\u2c5e\\u2c60-\\u2ce4\\u2ceb-\\u2cee\\u2cf2\\u2cf3\\u2d00-\\u2d25\\u2d27\\u2d2d\\u2d30-\\u2d67\\u2d6f\\u2d80-\\u2d96\\u2da0-\\u2da6\\u2da8-\\u2dae\\u2db0-\\u2db6\\u2db8-\\u2dbe\\u2dc0-\\u2dc6\\u2dc8-\\u2dce\\u2dd0-\\u2dd6\\u2dd8-\\u2dde\\u2e2f\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303c\\u3041-\\u3096\\u309d-\\u309f\\u30a1-\\u30fa\\u30fc-\\u30ff\\u3105-\\u312d\\u3131-\\u318e\\u31a0-\\u31ba\\u31f0-\\u31ff\\u3400-\\u4db5\\u4e00-\\u9fcc\\ua000-\\ua48c\\ua4d0-\\ua4fd\\ua500-\\ua60c\\ua610-\\ua61f\\ua62a\\ua62b\\ua640-\\ua66e\\ua67f-\\ua697\\ua6a0-\\ua6ef\\ua717-\\ua71f\\ua722-\\ua788\\ua78b-\\ua78e\\ua790-\\ua793\\ua7a0-\\ua7aa\\ua7f8-\\ua801\\ua803-\\ua805\\ua807-\\ua80a\\ua80c-\\ua822\\ua840-\\ua873\\ua882-\\ua8b3\\ua8f2-\\ua8f7\\ua8fb\\ua90a-\\ua925\\ua930-\\ua946\\ua960-\\ua97c\\ua984-\\ua9b2\\ua9cf\\uaa00-\\uaa28\\uaa40-\\uaa42\\uaa44-\\uaa4b\\uaa60-\\uaa76\\uaa7a\\uaa80-\\uaaaf\\uaab1\\uaab5\\uaab6\\uaab9-\\uaabd\\uaac0\\uaac2\\uaadb-\\uaadd\\uaae0-\\uaaea\\uaaf2-\\uaaf4\\uab01-\\uab06\\uab09-\\uab0e\\uab11-\\uab16\\uab20-\\uab26\\uab28-\\uab2e\\uabc0-\\uabe2\\uac00-\\ud7a3\\ud7b0-\\ud7c6\\ud7cb-\\ud7fb\\uf900-\\ufa6d\\ufa70-\\ufad9\\ufb00-\\ufb06\\ufb13-\\ufb17\\ufb1d\\ufb1f-\\ufb28\\ufb2a-\\ufb36\\ufb38-\\ufb3c\\ufb3e\\ufb40\\ufb41\\ufb43\\ufb44\\ufb46-\\ufbb1\\ufbd3-\\ufd3d\\ufd50-\\ufd8f\\ufd92-\\ufdc7\\ufdf0-\\ufdfb\\ufe70-\\ufe74\\ufe76-\\ufefc\\uff21-\\uff3a\\uff41-\\uff5a\\uff66-\\uffbe\\uffc2-\\uffc7\\uffca-\\uffcf\\uffd2-\\uffd7\\uffda-\\uffdc";
var nonASCIIidentifierChars = "\\u0300-\\u036f\\u0483-\\u0487\\u0591-\\u05bd\\u05bf\\u05c1\\u05c2\\u05c4\\u05c5\\u05c7\\u0610-\\u061a\\u0620-\\u0649\\u0672-\\u06d3\\u06e7-\\u06e8\\u06fb-\\u06fc\\u0730-\\u074a\\u0800-\\u0814\\u081b-\\u0823\\u0825-\\u0827\\u0829-\\u082d\\u0840-\\u0857\\u08e4-\\u08fe\\u0900-\\u0903\\u093a-\\u093c\\u093e-\\u094f\\u0951-\\u0957\\u0962-\\u0963\\u0966-\\u096f\\u0981-\\u0983\\u09bc\\u09be-\\u09c4\\u09c7\\u09c8\\u09d7\\u09df-\\u09e0\\u0a01-\\u0a03\\u0a3c\\u0a3e-\\u0a42\\u0a47\\u0a48\\u0a4b-\\u0a4d\\u0a51\\u0a66-\\u0a71\\u0a75\\u0a81-\\u0a83\\u0abc\\u0abe-\\u0ac5\\u0ac7-\\u0ac9\\u0acb-\\u0acd\\u0ae2-\\u0ae3\\u0ae6-\\u0aef\\u0b01-\\u0b03\\u0b3c\\u0b3e-\\u0b44\\u0b47\\u0b48\\u0b4b-\\u0b4d\\u0b56\\u0b57\\u0b5f-\\u0b60\\u0b66-\\u0b6f\\u0b82\\u0bbe-\\u0bc2\\u0bc6-\\u0bc8\\u0bca-\\u0bcd\\u0bd7\\u0be6-\\u0bef\\u0c01-\\u0c03\\u0c46-\\u0c48\\u0c4a-\\u0c4d\\u0c55\\u0c56\\u0c62-\\u0c63\\u0c66-\\u0c6f\\u0c82\\u0c83\\u0cbc\\u0cbe-\\u0cc4\\u0cc6-\\u0cc8\\u0cca-\\u0ccd\\u0cd5\\u0cd6\\u0ce2-\\u0ce3\\u0ce6-\\u0cef\\u0d02\\u0d03\\u0d46-\\u0d48\\u0d57\\u0d62-\\u0d63\\u0d66-\\u0d6f\\u0d82\\u0d83\\u0dca\\u0dcf-\\u0dd4\\u0dd6\\u0dd8-\\u0ddf\\u0df2\\u0df3\\u0e34-\\u0e3a\\u0e40-\\u0e45\\u0e50-\\u0e59\\u0eb4-\\u0eb9\\u0ec8-\\u0ecd\\u0ed0-\\u0ed9\\u0f18\\u0f19\\u0f20-\\u0f29\\u0f35\\u0f37\\u0f39\\u0f41-\\u0f47\\u0f71-\\u0f84\\u0f86-\\u0f87\\u0f8d-\\u0f97\\u0f99-\\u0fbc\\u0fc6\\u1000-\\u1029\\u1040-\\u1049\\u1067-\\u106d\\u1071-\\u1074\\u1082-\\u108d\\u108f-\\u109d\\u135d-\\u135f\\u170e-\\u1710\\u1720-\\u1730\\u1740-\\u1750\\u1772\\u1773\\u1780-\\u17b2\\u17dd\\u17e0-\\u17e9\\u180b-\\u180d\\u1810-\\u1819\\u1920-\\u192b\\u1930-\\u193b\\u1951-\\u196d\\u19b0-\\u19c0\\u19c8-\\u19c9\\u19d0-\\u19d9\\u1a00-\\u1a15\\u1a20-\\u1a53\\u1a60-\\u1a7c\\u1a7f-\\u1a89\\u1a90-\\u1a99\\u1b46-\\u1b4b\\u1b50-\\u1b59\\u1b6b-\\u1b73\\u1bb0-\\u1bb9\\u1be6-\\u1bf3\\u1c00-\\u1c22\\u1c40-\\u1c49\\u1c5b-\\u1c7d\\u1cd0-\\u1cd2\\u1d00-\\u1dbe\\u1e01-\\u1f15\\u200c\\u200d\\u203f\\u2040\\u2054\\u20d0-\\u20dc\\u20e1\\u20e5-\\u20f0\\u2d81-\\u2d96\\u2de0-\\u2dff\\u3021-\\u3028\\u3099\\u309a\\ua640-\\ua66d\\ua674-\\ua67d\\ua69f\\ua6f0-\\ua6f1\\ua7f8-\\ua800\\ua806\\ua80b\\ua823-\\ua827\\ua880-\\ua881\\ua8b4-\\ua8c4\\ua8d0-\\ua8d9\\ua8f3-\\ua8f7\\ua900-\\ua909\\ua926-\\ua92d\\ua930-\\ua945\\ua980-\\ua983\\ua9b3-\\ua9c0\\uaa00-\\uaa27\\uaa40-\\uaa41\\uaa4c-\\uaa4d\\uaa50-\\uaa59\\uaa7b\\uaae0-\\uaae9\\uaaf2-\\uaaf3\\uabc0-\\uabe1\\uabec\\uabed\\uabf0-\\uabf9\\ufb20-\\ufb28\\ufe00-\\ufe0f\\ufe20-\\ufe26\\ufe33\\ufe34\\ufe4d-\\ufe4f\\uff10-\\uff19\\uff3f";
//var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
//var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");

var identifierStart = "(?:\\\\u[0-9a-fA-F]{4}|[" + baseASCIIidentifierStartChars + nonASCIIidentifierStartChars + "])";
var identifierChars = "(?:\\\\u[0-9a-fA-F]{4}|[" + baseASCIIidentifierChars + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "])*";

exports.identifier = new RegExp(identifierStart + identifierChars, 'g');
exports.identifierStart = new RegExp(identifierStart);
exports.identifierMatch = new RegExp("(?:\\\\u[0-9a-fA-F]{4}|[" + baseASCIIidentifierChars + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "])+");

var nonASCIIwhitespace = /[\u1680\u180e\u2000-\u200a\u202f\u205f\u3000\ufeff]/; // jshint ignore:line

// Whether a single character denotes a newline.

exports.newline = /[\n\r\u2028\u2029]/;

// Matches a whole line break (where CRLF is considered a single
// line break). Used to count lines.

// in javascript, these two differ
// in python they are the same, different methods are called on them
exports.lineBreak = new RegExp('\r\n|' + exports.newline.source);
exports.allLineBreaks = new RegExp(exports.lineBreak.source, 'g');


/***/ }),
/* 5 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var BaseOptions = __webpack_require__(6).Options;

var validPositionValues = ['before-newline', 'after-newline', 'preserve-newline'];

function Options(options) {
  BaseOptions.call(this, options, 'js');

  // compatibility, re
  var raw_brace_style = this.raw_options.brace_style || null;
  if (raw_brace_style === "expand-strict") { //graceful handling of deprecated option
    this.raw_options.brace_style = "expand";
  } else if (raw_brace_style === "collapse-preserve-inline") { //graceful handling of deprecated option
    this.raw_options.brace_style = "collapse,preserve-inline";
  } else if (this.raw_options.braces_on_own_line !== undefined) { //graceful handling of deprecated option
    this.raw_options.brace_style = this.raw_options.braces_on_own_line ? "expand" : "collapse";
    // } else if (!raw_brace_style) { //Nothing exists to set it
    //   raw_brace_style = "collapse";
  }

  //preserve-inline in delimited string will trigger brace_preserve_inline, everything
  //else is considered a brace_style and the last one only will have an effect

  var brace_style_split = this._get_selection_list('brace_style', ['collapse', 'expand', 'end-expand', 'none', 'preserve-inline']);

  this.brace_preserve_inline = false; //Defaults in case one or other was not specified in meta-option
  this.brace_style = "collapse";

  for (var bs = 0; bs < brace_style_split.length; bs++) {
    if (brace_style_split[bs] === "preserve-inline") {
      this.brace_preserve_inline = true;
    } else {
      this.brace_style = brace_style_split[bs];
    }
  }

  this.unindent_chained_methods = this._get_boolean('unindent_chained_methods');
  this.break_chained_methods = this._get_boolean('break_chained_methods');
  this.space_in_paren = this._get_boolean('space_in_paren');
  this.space_in_empty_paren = this._get_boolean('space_in_empty_paren');
  this.jslint_happy = this._get_boolean('jslint_happy');
  this.space_after_anon_function = this._get_boolean('space_after_anon_function');
  this.space_after_named_function = this._get_boolean('space_after_named_function');
  this.keep_array_indentation = this._get_boolean('keep_array_indentation');
  this.space_before_conditional = this._get_boolean('space_before_conditional', true);
  this.unescape_strings = this._get_boolean('unescape_strings');
  this.e4x = this._get_boolean('e4x');
  this.comma_first = this._get_boolean('comma_first');
  this.operator_position = this._get_selection('operator_position', validPositionValues);

  // For testing of beautify preserve:start directive
  this.test_output_raw = this._get_boolean('test_output_raw');

  // force this._options.space_after_anon_function to true if this._options.jslint_happy
  if (this.jslint_happy) {
    this.space_after_anon_function = true;
  }

}
Options.prototype = new BaseOptions();



module.exports.Options = Options;


/***/ }),
/* 6 */
/***/ (function(module) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



function Options(options, merge_child_field) {
  this.raw_options = _mergeOpts(options, merge_child_field);

  // Support passing the source text back with no change
  this.disabled = this._get_boolean('disabled');

  this.eol = this._get_characters('eol', 'auto');
  this.end_with_newline = this._get_boolean('end_with_newline');
  this.indent_size = this._get_number('indent_size', 4);
  this.indent_char = this._get_characters('indent_char', ' ');
  this.indent_level = this._get_number('indent_level');

  this.preserve_newlines = this._get_boolean('preserve_newlines', true);
  this.max_preserve_newlines = this._get_number('max_preserve_newlines', 32786);
  if (!this.preserve_newlines) {
    this.max_preserve_newlines = 0;
  }

  this.indent_with_tabs = this._get_boolean('indent_with_tabs', this.indent_char === '\t');
  if (this.indent_with_tabs) {
    this.indent_char = '\t';

    // indent_size behavior changed after 1.8.6
    // It used to be that indent_size would be
    // set to 1 for indent_with_tabs. That is no longer needed and
    // actually doesn't make sense - why not use spaces? Further,
    // that might produce unexpected behavior - tabs being used
    // for single-column alignment. So, when indent_with_tabs is true
    // and indent_size is 1, reset indent_size to 4.
    if (this.indent_size === 1) {
      this.indent_size = 4;
    }
  }

  // Backwards compat with 1.3.x
  this.wrap_line_length = this._get_number('wrap_line_length', this._get_number('max_char'));

  this.indent_empty_lines = this._get_boolean('indent_empty_lines');

  // valid templating languages ['django', 'erb', 'handlebars', 'php', 'smarty']
  // For now, 'auto' = all off for javascript, all on for html (and inline javascript).
  // other values ignored
  this.templating = this._get_selection_list('templating', ['auto', 'none', 'django', 'erb', 'handlebars', 'php', 'smarty'], ['auto']);
}

Options.prototype._get_array = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = default_value || [];
  if (typeof option_value === 'object') {
    if (option_value !== null && typeof option_value.concat === 'function') {
      result = option_value.concat();
    }
  } else if (typeof option_value === 'string') {
    result = option_value.split(/[^a-zA-Z0-9_\/\-]+/);
  }
  return result;
};

Options.prototype._get_boolean = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = option_value === undefined ? !!default_value : !!option_value;
  return result;
};

Options.prototype._get_characters = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = default_value || '';
  if (typeof option_value === 'string') {
    result = option_value.replace(/\\r/, '\r').replace(/\\n/, '\n').replace(/\\t/, '\t');
  }
  return result;
};

Options.prototype._get_number = function(name, default_value) {
  var option_value = this.raw_options[name];
  default_value = parseInt(default_value, 10);
  if (isNaN(default_value)) {
    default_value = 0;
  }
  var result = parseInt(option_value, 10);
  if (isNaN(result)) {
    result = default_value;
  }
  return result;
};

Options.prototype._get_selection = function(name, selection_list, default_value) {
  var result = this._get_selection_list(name, selection_list, default_value);
  if (result.length !== 1) {
    throw new Error(
      "Invalid Option Value: The option '" + name + "' can only be one of the following values:\n" +
      selection_list + "\nYou passed in: '" + this.raw_options[name] + "'");
  }

  return result[0];
};


Options.prototype._get_selection_list = function(name, selection_list, default_value) {
  if (!selection_list || selection_list.length === 0) {
    throw new Error("Selection list cannot be empty.");
  }

  default_value = default_value || [selection_list[0]];
  if (!this._is_valid_selection(default_value, selection_list)) {
    throw new Error("Invalid Default Value!");
  }

  var result = this._get_array(name, default_value);
  if (!this._is_valid_selection(result, selection_list)) {
    throw new Error(
      "Invalid Option Value: The option '" + name + "' can contain only the following values:\n" +
      selection_list + "\nYou passed in: '" + this.raw_options[name] + "'");
  }

  return result;
};

Options.prototype._is_valid_selection = function(result, selection_list) {
  return result.length && selection_list.length &&
    !result.some(function(item) { return selection_list.indexOf(item) === -1; });
};


// merges child options up with the parent options object
// Example: obj = {a: 1, b: {a: 2}}
//          mergeOpts(obj, 'b')
//
//          Returns: {a: 2}
function _mergeOpts(allOptions, childFieldName) {
  var finalOpts = {};
  allOptions = _normalizeOpts(allOptions);
  var name;

  for (name in allOptions) {
    if (name !== childFieldName) {
      finalOpts[name] = allOptions[name];
    }
  }

  //merge in the per type settings for the childFieldName
  if (childFieldName && allOptions[childFieldName]) {
    for (name in allOptions[childFieldName]) {
      finalOpts[name] = allOptions[childFieldName][name];
    }
  }
  return finalOpts;
}

function _normalizeOpts(options) {
  var convertedOpts = {};
  var key;

  for (key in options) {
    var newKey = key.replace(/-/g, "_");
    convertedOpts[newKey] = options[key];
  }
  return convertedOpts;
}

module.exports.Options = Options;
module.exports.normalizeOpts = _normalizeOpts;
module.exports.mergeOpts = _mergeOpts;


/***/ }),
/* 7 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var InputScanner = __webpack_require__(8).InputScanner;
var BaseTokenizer = __webpack_require__(9).Tokenizer;
var BASETOKEN = __webpack_require__(9).TOKEN;
var Directives = __webpack_require__(13).Directives;
var acorn = __webpack_require__(4);
var Pattern = __webpack_require__(12).Pattern;
var TemplatablePattern = __webpack_require__(14).TemplatablePattern;


function in_array(what, arr) {
  return arr.indexOf(what) !== -1;
}


var TOKEN = {
  START_EXPR: 'TK_START_EXPR',
  END_EXPR: 'TK_END_EXPR',
  START_BLOCK: 'TK_START_BLOCK',
  END_BLOCK: 'TK_END_BLOCK',
  WORD: 'TK_WORD',
  RESERVED: 'TK_RESERVED',
  SEMICOLON: 'TK_SEMICOLON',
  STRING: 'TK_STRING',
  EQUALS: 'TK_EQUALS',
  OPERATOR: 'TK_OPERATOR',
  COMMA: 'TK_COMMA',
  BLOCK_COMMENT: 'TK_BLOCK_COMMENT',
  COMMENT: 'TK_COMMENT',
  DOT: 'TK_DOT',
  UNKNOWN: 'TK_UNKNOWN',
  START: BASETOKEN.START,
  RAW: BASETOKEN.RAW,
  EOF: BASETOKEN.EOF
};


var directives_core = new Directives(/\/\*/, /\*\//);

var number_pattern = /0[xX][0123456789abcdefABCDEF]*|0[oO][01234567]*|0[bB][01]*|\d+n|(?:\.\d+|\d+\.?\d*)(?:[eE][+-]?\d+)?/;

var digit = /[0-9]/;

// Dot "." must be distinguished from "..." and decimal
var dot_pattern = /[^\d\.]/;

var positionable_operators = (
  ">>> === !== " +
  "<< && >= ** != == <= >> || ?? |> " +
  "< / - + > : & % ? ^ | *").split(' ');

// IMPORTANT: this must be sorted longest to shortest or tokenizing many not work.
// Also, you must update possitionable operators separately from punct
var punct =
  ">>>= " +
  "... >>= <<= === >>> !== **= " +
  "=> ^= :: /= << <= == && -= >= >> != -- += ** || ?? ++ %= &= *= |= |> " +
  "= ! ? > < : / ^ - + * & % ~ |";

punct = punct.replace(/[-[\]{}()*+?.,\\^$|#]/g, "\\$&");
// ?. but not if followed by a number 
punct = '\\?\\.(?!\\d) ' + punct;
punct = punct.replace(/ /g, '|');

var punct_pattern = new RegExp(punct);

// words which should always start on new line.
var line_starters = 'continue,try,throw,return,var,let,const,if,switch,case,default,for,while,break,function,import,export'.split(',');
var reserved_words = line_starters.concat(['do', 'in', 'of', 'else', 'get', 'set', 'new', 'catch', 'finally', 'typeof', 'yield', 'async', 'await', 'from', 'as']);
var reserved_word_pattern = new RegExp('^(?:' + reserved_words.join('|') + ')$');

// var template_pattern = /(?:(?:<\?php|<\?=)[\s\S]*?\?>)|(?:<%[\s\S]*?%>)/g;

var in_html_comment;

var Tokenizer = function(input_string, options) {
  BaseTokenizer.call(this, input_string, options);

  this._patterns.whitespace = this._patterns.whitespace.matching(
    /\u00A0\u1680\u180e\u2000-\u200a\u202f\u205f\u3000\ufeff/.source,
    /\u2028\u2029/.source);

  var pattern_reader = new Pattern(this._input);
  var templatable = new TemplatablePattern(this._input)
    .read_options(this._options);

  this.__patterns = {
    template: templatable,
    identifier: templatable.starting_with(acorn.identifier).matching(acorn.identifierMatch),
    number: pattern_reader.matching(number_pattern),
    punct: pattern_reader.matching(punct_pattern),
    // comment ends just before nearest linefeed or end of file
    comment: pattern_reader.starting_with(/\/\//).until(/[\n\r\u2028\u2029]/),
    //  /* ... */ comment ends with nearest */ or end of file
    block_comment: pattern_reader.starting_with(/\/\*/).until_after(/\*\//),
    html_comment_start: pattern_reader.matching(/<!--/),
    html_comment_end: pattern_reader.matching(/-->/),
    include: pattern_reader.starting_with(/#include/).until_after(acorn.lineBreak),
    shebang: pattern_reader.starting_with(/#!/).until_after(acorn.lineBreak),
    xml: pattern_reader.matching(/[\s\S]*?<(\/?)([-a-zA-Z:0-9_.]+|{[\s\S]+?}|!\[CDATA\[[\s\S]*?\]\]|)(\s+{[\s\S]+?}|\s+[-a-zA-Z:0-9_.]+|\s+[-a-zA-Z:0-9_.]+\s*=\s*('[^']*'|"[^"]*"|{[\s\S]+?}))*\s*(\/?)\s*>/),
    single_quote: templatable.until(/['\\\n\r\u2028\u2029]/),
    double_quote: templatable.until(/["\\\n\r\u2028\u2029]/),
    template_text: templatable.until(/[`\\$]/),
    template_expression: templatable.until(/[`}\\]/)
  };

};
Tokenizer.prototype = new BaseTokenizer();

Tokenizer.prototype._is_comment = function(current_token) {
  return current_token.type === TOKEN.COMMENT || current_token.type === TOKEN.BLOCK_COMMENT || current_token.type === TOKEN.UNKNOWN;
};

Tokenizer.prototype._is_opening = function(current_token) {
  return current_token.type === TOKEN.START_BLOCK || current_token.type === TOKEN.START_EXPR;
};

Tokenizer.prototype._is_closing = function(current_token, open_token) {
  return (current_token.type === TOKEN.END_BLOCK || current_token.type === TOKEN.END_EXPR) &&
    (open_token && (
      (current_token.text === ']' && open_token.text === '[') ||
      (current_token.text === ')' && open_token.text === '(') ||
      (current_token.text === '}' && open_token.text === '{')));
};

Tokenizer.prototype._reset = function() {
  in_html_comment = false;
};

Tokenizer.prototype._get_next_token = function(previous_token, open_token) { // jshint unused:false
  var token = null;
  this._readWhitespace();
  var c = this._input.peek();

  if (c === null) {
    return this._create_token(TOKEN.EOF, '');
  }

  token = token || this._read_non_javascript(c);
  token = token || this._read_string(c);
  token = token || this._read_word(previous_token);
  token = token || this._read_singles(c);
  token = token || this._read_comment(c);
  token = token || this._read_regexp(c, previous_token);
  token = token || this._read_xml(c, previous_token);
  token = token || this._read_punctuation();
  token = token || this._create_token(TOKEN.UNKNOWN, this._input.next());

  return token;
};

Tokenizer.prototype._read_word = function(previous_token) {
  var resulting_string;
  resulting_string = this.__patterns.identifier.read();
  if (resulting_string !== '') {
    resulting_string = resulting_string.replace(acorn.allLineBreaks, '\n');
    if (!(previous_token.type === TOKEN.DOT ||
        (previous_token.type === TOKEN.RESERVED && (previous_token.text === 'set' || previous_token.text === 'get'))) &&
      reserved_word_pattern.test(resulting_string)) {
      if (resulting_string === 'in' || resulting_string === 'of') { // hack for 'in' and 'of' operators
        return this._create_token(TOKEN.OPERATOR, resulting_string);
      }
      return this._create_token(TOKEN.RESERVED, resulting_string);
    }
    return this._create_token(TOKEN.WORD, resulting_string);
  }

  resulting_string = this.__patterns.number.read();
  if (resulting_string !== '') {
    return this._create_token(TOKEN.WORD, resulting_string);
  }
};

Tokenizer.prototype._read_singles = function(c) {
  var token = null;
  if (c === '(' || c === '[') {
    token = this._create_token(TOKEN.START_EXPR, c);
  } else if (c === ')' || c === ']') {
    token = this._create_token(TOKEN.END_EXPR, c);
  } else if (c === '{') {
    token = this._create_token(TOKEN.START_BLOCK, c);
  } else if (c === '}') {
    token = this._create_token(TOKEN.END_BLOCK, c);
  } else if (c === ';') {
    token = this._create_token(TOKEN.SEMICOLON, c);
  } else if (c === '.' && dot_pattern.test(this._input.peek(1))) {
    token = this._create_token(TOKEN.DOT, c);
  } else if (c === ',') {
    token = this._create_token(TOKEN.COMMA, c);
  }

  if (token) {
    this._input.next();
  }
  return token;
};

Tokenizer.prototype._read_punctuation = function() {
  var resulting_string = this.__patterns.punct.read();

  if (resulting_string !== '') {
    if (resulting_string === '=') {
      return this._create_token(TOKEN.EQUALS, resulting_string);
    } else if (resulting_string === '?.') {
      return this._create_token(TOKEN.DOT, resulting_string);
    } else {
      return this._create_token(TOKEN.OPERATOR, resulting_string);
    }
  }
};

Tokenizer.prototype._read_non_javascript = function(c) {
  var resulting_string = '';

  if (c === '#') {
    if (this._is_first_token()) {
      resulting_string = this.__patterns.shebang.read();

      if (resulting_string) {
        return this._create_token(TOKEN.UNKNOWN, resulting_string.trim() + '\n');
      }
    }

    // handles extendscript #includes
    resulting_string = this.__patterns.include.read();

    if (resulting_string) {
      return this._create_token(TOKEN.UNKNOWN, resulting_string.trim() + '\n');
    }

    c = this._input.next();

    // Spidermonkey-specific sharp variables for circular references. Considered obsolete.
    var sharp = '#';
    if (this._input.hasNext() && this._input.testChar(digit)) {
      do {
        c = this._input.next();
        sharp += c;
      } while (this._input.hasNext() && c !== '#' && c !== '=');
      if (c === '#') {
        //
      } else if (this._input.peek() === '[' && this._input.peek(1) === ']') {
        sharp += '[]';
        this._input.next();
        this._input.next();
      } else if (this._input.peek() === '{' && this._input.peek(1) === '}') {
        sharp += '{}';
        this._input.next();
        this._input.next();
      }
      return this._create_token(TOKEN.WORD, sharp);
    }

    this._input.back();

  } else if (c === '<' && this._is_first_token()) {
    resulting_string = this.__patterns.html_comment_start.read();
    if (resulting_string) {
      while (this._input.hasNext() && !this._input.testChar(acorn.newline)) {
        resulting_string += this._input.next();
      }
      in_html_comment = true;
      return this._create_token(TOKEN.COMMENT, resulting_string);
    }
  } else if (in_html_comment && c === '-') {
    resulting_string = this.__patterns.html_comment_end.read();
    if (resulting_string) {
      in_html_comment = false;
      return this._create_token(TOKEN.COMMENT, resulting_string);
    }
  }

  return null;
};

Tokenizer.prototype._read_comment = function(c) {
  var token = null;
  if (c === '/') {
    var comment = '';
    if (this._input.peek(1) === '*') {
      // peek for comment /* ... */
      comment = this.__patterns.block_comment.read();
      var directives = directives_core.get_directives(comment);
      if (directives && directives.ignore === 'start') {
        comment += directives_core.readIgnored(this._input);
      }
      comment = comment.replace(acorn.allLineBreaks, '\n');
      token = this._create_token(TOKEN.BLOCK_COMMENT, comment);
      token.directives = directives;
    } else if (this._input.peek(1) === '/') {
      // peek for comment // ...
      comment = this.__patterns.comment.read();
      token = this._create_token(TOKEN.COMMENT, comment);
    }
  }
  return token;
};

Tokenizer.prototype._read_string = function(c) {
  if (c === '`' || c === "'" || c === '"') {
    var resulting_string = this._input.next();
    this.has_char_escapes = false;

    if (c === '`') {
      resulting_string += this._read_string_recursive('`', true, '${');
    } else {
      resulting_string += this._read_string_recursive(c);
    }

    if (this.has_char_escapes && this._options.unescape_strings) {
      resulting_string = unescape_string(resulting_string);
    }

    if (this._input.peek() === c) {
      resulting_string += this._input.next();
    }

    resulting_string = resulting_string.replace(acorn.allLineBreaks, '\n');

    return this._create_token(TOKEN.STRING, resulting_string);
  }

  return null;
};

Tokenizer.prototype._allow_regexp_or_xml = function(previous_token) {
  // regex and xml can only appear in specific locations during parsing
  return (previous_token.type === TOKEN.RESERVED && in_array(previous_token.text, ['return', 'case', 'throw', 'else', 'do', 'typeof', 'yield'])) ||
    (previous_token.type === TOKEN.END_EXPR && previous_token.text === ')' &&
      previous_token.opened.previous.type === TOKEN.RESERVED && in_array(previous_token.opened.previous.text, ['if', 'while', 'for'])) ||
    (in_array(previous_token.type, [TOKEN.COMMENT, TOKEN.START_EXPR, TOKEN.START_BLOCK, TOKEN.START,
      TOKEN.END_BLOCK, TOKEN.OPERATOR, TOKEN.EQUALS, TOKEN.EOF, TOKEN.SEMICOLON, TOKEN.COMMA
    ]));
};

Tokenizer.prototype._read_regexp = function(c, previous_token) {

  if (c === '/' && this._allow_regexp_or_xml(previous_token)) {
    // handle regexp
    //
    var resulting_string = this._input.next();
    var esc = false;

    var in_char_class = false;
    while (this._input.hasNext() &&
      ((esc || in_char_class || this._input.peek() !== c) &&
        !this._input.testChar(acorn.newline))) {
      resulting_string += this._input.peek();
      if (!esc) {
        esc = this._input.peek() === '\\';
        if (this._input.peek() === '[') {
          in_char_class = true;
        } else if (this._input.peek() === ']') {
          in_char_class = false;
        }
      } else {
        esc = false;
      }
      this._input.next();
    }

    if (this._input.peek() === c) {
      resulting_string += this._input.next();

      // regexps may have modifiers /regexp/MOD , so fetch those, too
      // Only [gim] are valid, but if the user puts in garbage, do what we can to take it.
      resulting_string += this._input.read(acorn.identifier);
    }
    return this._create_token(TOKEN.STRING, resulting_string);
  }
  return null;
};

Tokenizer.prototype._read_xml = function(c, previous_token) {

  if (this._options.e4x && c === "<" && this._allow_regexp_or_xml(previous_token)) {
    var xmlStr = '';
    var match = this.__patterns.xml.read_match();
    // handle e4x xml literals
    //
    if (match) {
      // Trim root tag to attempt to
      var rootTag = match[2].replace(/^{\s+/, '{').replace(/\s+}$/, '}');
      var isCurlyRoot = rootTag.indexOf('{') === 0;
      var depth = 0;
      while (match) {
        var isEndTag = !!match[1];
        var tagName = match[2];
        var isSingletonTag = (!!match[match.length - 1]) || (tagName.slice(0, 8) === "![CDATA[");
        if (!isSingletonTag &&
          (tagName === rootTag || (isCurlyRoot && tagName.replace(/^{\s+/, '{').replace(/\s+}$/, '}')))) {
          if (isEndTag) {
            --depth;
          } else {
            ++depth;
          }
        }
        xmlStr += match[0];
        if (depth <= 0) {
          break;
        }
        match = this.__patterns.xml.read_match();
      }
      // if we didn't close correctly, keep unformatted.
      if (!match) {
        xmlStr += this._input.match(/[\s\S]*/g)[0];
      }
      xmlStr = xmlStr.replace(acorn.allLineBreaks, '\n');
      return this._create_token(TOKEN.STRING, xmlStr);
    }
  }

  return null;
};

function unescape_string(s) {
  // You think that a regex would work for this
  // return s.replace(/\\x([0-9a-f]{2})/gi, function(match, val) {
  //         return String.fromCharCode(parseInt(val, 16));
  //     })
  // However, dealing with '\xff', '\\xff', '\\\xff' makes this more fun.
  var out = '',
    escaped = 0;

  var input_scan = new InputScanner(s);
  var matched = null;

  while (input_scan.hasNext()) {
    // Keep any whitespace, non-slash characters
    // also keep slash pairs.
    matched = input_scan.match(/([\s]|[^\\]|\\\\)+/g);

    if (matched) {
      out += matched[0];
    }

    if (input_scan.peek() === '\\') {
      input_scan.next();
      if (input_scan.peek() === 'x') {
        matched = input_scan.match(/x([0-9A-Fa-f]{2})/g);
      } else if (input_scan.peek() === 'u') {
        matched = input_scan.match(/u([0-9A-Fa-f]{4})/g);
      } else {
        out += '\\';
        if (input_scan.hasNext()) {
          out += input_scan.next();
        }
        continue;
      }

      // If there's some error decoding, return the original string
      if (!matched) {
        return s;
      }

      escaped = parseInt(matched[1], 16);

      if (escaped > 0x7e && escaped <= 0xff && matched[0].indexOf('x') === 0) {
        // we bail out on \x7f..\xff,
        // leaving whole string escaped,
        // as it's probably completely binary
        return s;
      } else if (escaped >= 0x00 && escaped < 0x20) {
        // leave 0x00...0x1f escaped
        out += '\\' + matched[0];
        continue;
      } else if (escaped === 0x22 || escaped === 0x27 || escaped === 0x5c) {
        // single-quote, apostrophe, backslash - escape these
        out += '\\' + String.fromCharCode(escaped);
      } else {
        out += String.fromCharCode(escaped);
      }
    }
  }

  return out;
}

// handle string
//
Tokenizer.prototype._read_string_recursive = function(delimiter, allow_unescaped_newlines, start_sub) {
  var current_char;
  var pattern;
  if (delimiter === '\'') {
    pattern = this.__patterns.single_quote;
  } else if (delimiter === '"') {
    pattern = this.__patterns.double_quote;
  } else if (delimiter === '`') {
    pattern = this.__patterns.template_text;
  } else if (delimiter === '}') {
    pattern = this.__patterns.template_expression;
  }

  var resulting_string = pattern.read();
  var next = '';
  while (this._input.hasNext()) {
    next = this._input.next();
    if (next === delimiter ||
      (!allow_unescaped_newlines && acorn.newline.test(next))) {
      this._input.back();
      break;
    } else if (next === '\\' && this._input.hasNext()) {
      current_char = this._input.peek();

      if (current_char === 'x' || current_char === 'u') {
        this.has_char_escapes = true;
      } else if (current_char === '\r' && this._input.peek(1) === '\n') {
        this._input.next();
      }
      next += this._input.next();
    } else if (start_sub) {
      if (start_sub === '${' && next === '$' && this._input.peek() === '{') {
        next += this._input.next();
      }

      if (start_sub === next) {
        if (delimiter === '`') {
          next += this._read_string_recursive('}', allow_unescaped_newlines, '`');
        } else {
          next += this._read_string_recursive('`', allow_unescaped_newlines, '${');
        }
        if (this._input.hasNext()) {
          next += this._input.next();
        }
      }
    }
    next += pattern.read();
    resulting_string += next;
  }

  return resulting_string;
};

module.exports.Tokenizer = Tokenizer;
module.exports.TOKEN = TOKEN;
module.exports.positionable_operators = positionable_operators.slice();
module.exports.line_starters = line_starters.slice();


/***/ }),
/* 8 */
/***/ (function(module) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var regexp_has_sticky = RegExp.prototype.hasOwnProperty('sticky');

function InputScanner(input_string) {
  this.__input = input_string || '';
  this.__input_length = this.__input.length;
  this.__position = 0;
}

InputScanner.prototype.restart = function() {
  this.__position = 0;
};

InputScanner.prototype.back = function() {
  if (this.__position > 0) {
    this.__position -= 1;
  }
};

InputScanner.prototype.hasNext = function() {
  return this.__position < this.__input_length;
};

InputScanner.prototype.next = function() {
  var val = null;
  if (this.hasNext()) {
    val = this.__input.charAt(this.__position);
    this.__position += 1;
  }
  return val;
};

InputScanner.prototype.peek = function(index) {
  var val = null;
  index = index || 0;
  index += this.__position;
  if (index >= 0 && index < this.__input_length) {
    val = this.__input.charAt(index);
  }
  return val;
};

// This is a JavaScript only helper function (not in python)
// Javascript doesn't have a match method
// and not all implementation support "sticky" flag.
// If they do not support sticky then both this.match() and this.test() method
// must get the match and check the index of the match.
// If sticky is supported and set, this method will use it.
// Otherwise it will check that global is set, and fall back to the slower method.
InputScanner.prototype.__match = function(pattern, index) {
  pattern.lastIndex = index;
  var pattern_match = pattern.exec(this.__input);

  if (pattern_match && !(regexp_has_sticky && pattern.sticky)) {
    if (pattern_match.index !== index) {
      pattern_match = null;
    }
  }

  return pattern_match;
};

InputScanner.prototype.test = function(pattern, index) {
  index = index || 0;
  index += this.__position;

  if (index >= 0 && index < this.__input_length) {
    return !!this.__match(pattern, index);
  } else {
    return false;
  }
};

InputScanner.prototype.testChar = function(pattern, index) {
  // test one character regex match
  var val = this.peek(index);
  pattern.lastIndex = 0;
  return val !== null && pattern.test(val);
};

InputScanner.prototype.match = function(pattern) {
  var pattern_match = this.__match(pattern, this.__position);
  if (pattern_match) {
    this.__position += pattern_match[0].length;
  } else {
    pattern_match = null;
  }
  return pattern_match;
};

InputScanner.prototype.read = function(starting_pattern, until_pattern, until_after) {
  var val = '';
  var match;
  if (starting_pattern) {
    match = this.match(starting_pattern);
    if (match) {
      val += match[0];
    }
  }
  if (until_pattern && (match || !starting_pattern)) {
    val += this.readUntil(until_pattern, until_after);
  }
  return val;
};

InputScanner.prototype.readUntil = function(pattern, until_after) {
  var val = '';
  var match_index = this.__position;
  pattern.lastIndex = this.__position;
  var pattern_match = pattern.exec(this.__input);
  if (pattern_match) {
    match_index = pattern_match.index;
    if (until_after) {
      match_index += pattern_match[0].length;
    }
  } else {
    match_index = this.__input_length;
  }

  val = this.__input.substring(this.__position, match_index);
  this.__position = match_index;
  return val;
};

InputScanner.prototype.readUntilAfter = function(pattern) {
  return this.readUntil(pattern, true);
};

InputScanner.prototype.get_regexp = function(pattern, match_from) {
  var result = null;
  var flags = 'g';
  if (match_from && regexp_has_sticky) {
    flags = 'y';
  }
  // strings are converted to regexp
  if (typeof pattern === "string" && pattern !== '') {
    // result = new RegExp(pattern.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), flags);
    result = new RegExp(pattern, flags);
  } else if (pattern) {
    result = new RegExp(pattern.source, flags);
  }
  return result;
};

InputScanner.prototype.get_literal_regexp = function(literal_string) {
  return RegExp(literal_string.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));
};

/* css beautifier legacy helpers */
InputScanner.prototype.peekUntilAfter = function(pattern) {
  var start = this.__position;
  var val = this.readUntilAfter(pattern);
  this.__position = start;
  return val;
};

InputScanner.prototype.lookBack = function(testVal) {
  var start = this.__position - 1;
  return start >= testVal.length && this.__input.substring(start - testVal.length, start)
    .toLowerCase() === testVal;
};

module.exports.InputScanner = InputScanner;


/***/ }),
/* 9 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var InputScanner = __webpack_require__(8).InputScanner;
var Token = __webpack_require__(3).Token;
var TokenStream = __webpack_require__(10).TokenStream;
var WhitespacePattern = __webpack_require__(11).WhitespacePattern;

var TOKEN = {
  START: 'TK_START',
  RAW: 'TK_RAW',
  EOF: 'TK_EOF'
};

var Tokenizer = function(input_string, options) {
  this._input = new InputScanner(input_string);
  this._options = options || {};
  this.__tokens = null;

  this._patterns = {};
  this._patterns.whitespace = new WhitespacePattern(this._input);
};

Tokenizer.prototype.tokenize = function() {
  this._input.restart();
  this.__tokens = new TokenStream();

  this._reset();

  var current;
  var previous = new Token(TOKEN.START, '');
  var open_token = null;
  var open_stack = [];
  var comments = new TokenStream();

  while (previous.type !== TOKEN.EOF) {
    current = this._get_next_token(previous, open_token);
    while (this._is_comment(current)) {
      comments.add(current);
      current = this._get_next_token(previous, open_token);
    }

    if (!comments.isEmpty()) {
      current.comments_before = comments;
      comments = new TokenStream();
    }

    current.parent = open_token;

    if (this._is_opening(current)) {
      open_stack.push(open_token);
      open_token = current;
    } else if (open_token && this._is_closing(current, open_token)) {
      current.opened = open_token;
      open_token.closed = current;
      open_token = open_stack.pop();
      current.parent = open_token;
    }

    current.previous = previous;
    previous.next = current;

    this.__tokens.add(current);
    previous = current;
  }

  return this.__tokens;
};


Tokenizer.prototype._is_first_token = function() {
  return this.__tokens.isEmpty();
};

Tokenizer.prototype._reset = function() {};

Tokenizer.prototype._get_next_token = function(previous_token, open_token) { // jshint unused:false
  this._readWhitespace();
  var resulting_string = this._input.read(/.+/g);
  if (resulting_string) {
    return this._create_token(TOKEN.RAW, resulting_string);
  } else {
    return this._create_token(TOKEN.EOF, '');
  }
};

Tokenizer.prototype._is_comment = function(current_token) { // jshint unused:false
  return false;
};

Tokenizer.prototype._is_opening = function(current_token) { // jshint unused:false
  return false;
};

Tokenizer.prototype._is_closing = function(current_token, open_token) { // jshint unused:false
  return false;
};

Tokenizer.prototype._create_token = function(type, text) {
  var token = new Token(type, text,
    this._patterns.whitespace.newline_count,
    this._patterns.whitespace.whitespace_before_token);
  return token;
};

Tokenizer.prototype._readWhitespace = function() {
  return this._patterns.whitespace.read();
};



module.exports.Tokenizer = Tokenizer;
module.exports.TOKEN = TOKEN;


/***/ }),
/* 10 */
/***/ (function(module) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



function TokenStream(parent_token) {
  // private
  this.__tokens = [];
  this.__tokens_length = this.__tokens.length;
  this.__position = 0;
  this.__parent_token = parent_token;
}

TokenStream.prototype.restart = function() {
  this.__position = 0;
};

TokenStream.prototype.isEmpty = function() {
  return this.__tokens_length === 0;
};

TokenStream.prototype.hasNext = function() {
  return this.__position < this.__tokens_length;
};

TokenStream.prototype.next = function() {
  var val = null;
  if (this.hasNext()) {
    val = this.__tokens[this.__position];
    this.__position += 1;
  }
  return val;
};

TokenStream.prototype.peek = function(index) {
  var val = null;
  index = index || 0;
  index += this.__position;
  if (index >= 0 && index < this.__tokens_length) {
    val = this.__tokens[index];
  }
  return val;
};

TokenStream.prototype.add = function(token) {
  if (this.__parent_token) {
    token.parent = this.__parent_token;
  }
  this.__tokens.push(token);
  this.__tokens_length += 1;
};

module.exports.TokenStream = TokenStream;


/***/ }),
/* 11 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var Pattern = __webpack_require__(12).Pattern;

function WhitespacePattern(input_scanner, parent) {
  Pattern.call(this, input_scanner, parent);
  if (parent) {
    this._line_regexp = this._input.get_regexp(parent._line_regexp);
  } else {
    this.__set_whitespace_patterns('', '');
  }

  this.newline_count = 0;
  this.whitespace_before_token = '';
}
WhitespacePattern.prototype = new Pattern();

WhitespacePattern.prototype.__set_whitespace_patterns = function(whitespace_chars, newline_chars) {
  whitespace_chars += '\\t ';
  newline_chars += '\\n\\r';

  this._match_pattern = this._input.get_regexp(
    '[' + whitespace_chars + newline_chars + ']+', true);
  this._newline_regexp = this._input.get_regexp(
    '\\r\\n|[' + newline_chars + ']');
};

WhitespacePattern.prototype.read = function() {
  this.newline_count = 0;
  this.whitespace_before_token = '';

  var resulting_string = this._input.read(this._match_pattern);
  if (resulting_string === ' ') {
    this.whitespace_before_token = ' ';
  } else if (resulting_string) {
    var matches = this.__split(this._newline_regexp, resulting_string);
    this.newline_count = matches.length - 1;
    this.whitespace_before_token = matches[this.newline_count];
  }

  return resulting_string;
};

WhitespacePattern.prototype.matching = function(whitespace_chars, newline_chars) {
  var result = this._create();
  result.__set_whitespace_patterns(whitespace_chars, newline_chars);
  result._update();
  return result;
};

WhitespacePattern.prototype._create = function() {
  return new WhitespacePattern(this._input, this);
};

WhitespacePattern.prototype.__split = function(regexp, input_string) {
  regexp.lastIndex = 0;
  var start_index = 0;
  var result = [];
  var next_match = regexp.exec(input_string);
  while (next_match) {
    result.push(input_string.substring(start_index, next_match.index));
    start_index = next_match.index + next_match[0].length;
    next_match = regexp.exec(input_string);
  }

  if (start_index < input_string.length) {
    result.push(input_string.substring(start_index, input_string.length));
  } else {
    result.push('');
  }

  return result;
};



module.exports.WhitespacePattern = WhitespacePattern;


/***/ }),
/* 12 */
/***/ (function(module) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



function Pattern(input_scanner, parent) {
  this._input = input_scanner;
  this._starting_pattern = null;
  this._match_pattern = null;
  this._until_pattern = null;
  this._until_after = false;

  if (parent) {
    this._starting_pattern = this._input.get_regexp(parent._starting_pattern, true);
    this._match_pattern = this._input.get_regexp(parent._match_pattern, true);
    this._until_pattern = this._input.get_regexp(parent._until_pattern);
    this._until_after = parent._until_after;
  }
}

Pattern.prototype.read = function() {
  var result = this._input.read(this._starting_pattern);
  if (!this._starting_pattern || result) {
    result += this._input.read(this._match_pattern, this._until_pattern, this._until_after);
  }
  return result;
};

Pattern.prototype.read_match = function() {
  return this._input.match(this._match_pattern);
};

Pattern.prototype.until_after = function(pattern) {
  var result = this._create();
  result._until_after = true;
  result._until_pattern = this._input.get_regexp(pattern);
  result._update();
  return result;
};

Pattern.prototype.until = function(pattern) {
  var result = this._create();
  result._until_after = false;
  result._until_pattern = this._input.get_regexp(pattern);
  result._update();
  return result;
};

Pattern.prototype.starting_with = function(pattern) {
  var result = this._create();
  result._starting_pattern = this._input.get_regexp(pattern, true);
  result._update();
  return result;
};

Pattern.prototype.matching = function(pattern) {
  var result = this._create();
  result._match_pattern = this._input.get_regexp(pattern, true);
  result._update();
  return result;
};

Pattern.prototype._create = function() {
  return new Pattern(this._input, this);
};

Pattern.prototype._update = function() {};

module.exports.Pattern = Pattern;


/***/ }),
/* 13 */
/***/ (function(module) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



function Directives(start_block_pattern, end_block_pattern) {
  start_block_pattern = typeof start_block_pattern === 'string' ? start_block_pattern : start_block_pattern.source;
  end_block_pattern = typeof end_block_pattern === 'string' ? end_block_pattern : end_block_pattern.source;
  this.__directives_block_pattern = new RegExp(start_block_pattern + / beautify( \w+[:]\w+)+ /.source + end_block_pattern, 'g');
  this.__directive_pattern = / (\w+)[:](\w+)/g;

  this.__directives_end_ignore_pattern = new RegExp(start_block_pattern + /\sbeautify\signore:end\s/.source + end_block_pattern, 'g');
}

Directives.prototype.get_directives = function(text) {
  if (!text.match(this.__directives_block_pattern)) {
    return null;
  }

  var directives = {};
  this.__directive_pattern.lastIndex = 0;
  var directive_match = this.__directive_pattern.exec(text);

  while (directive_match) {
    directives[directive_match[1]] = directive_match[2];
    directive_match = this.__directive_pattern.exec(text);
  }

  return directives;
};

Directives.prototype.readIgnored = function(input) {
  return input.readUntilAfter(this.__directives_end_ignore_pattern);
};


module.exports.Directives = Directives;


/***/ }),
/* 14 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var Pattern = __webpack_require__(12).Pattern;


var template_names = {
  django: false,
  erb: false,
  handlebars: false,
  php: false,
  smarty: false
};

// This lets templates appear anywhere we would do a readUntil
// The cost is higher but it is pay to play.
function TemplatablePattern(input_scanner, parent) {
  Pattern.call(this, input_scanner, parent);
  this.__template_pattern = null;
  this._disabled = Object.assign({}, template_names);
  this._excluded = Object.assign({}, template_names);

  if (parent) {
    this.__template_pattern = this._input.get_regexp(parent.__template_pattern);
    this._excluded = Object.assign(this._excluded, parent._excluded);
    this._disabled = Object.assign(this._disabled, parent._disabled);
  }
  var pattern = new Pattern(input_scanner);
  this.__patterns = {
    handlebars_comment: pattern.starting_with(/{{!--/).until_after(/--}}/),
    handlebars_unescaped: pattern.starting_with(/{{{/).until_after(/}}}/),
    handlebars: pattern.starting_with(/{{/).until_after(/}}/),
    php: pattern.starting_with(/<\?(?:[= ]|php)/).until_after(/\?>/),
    erb: pattern.starting_with(/<%[^%]/).until_after(/[^%]%>/),
    // django coflicts with handlebars a bit.
    django: pattern.starting_with(/{%/).until_after(/%}/),
    django_value: pattern.starting_with(/{{/).until_after(/}}/),
    django_comment: pattern.starting_with(/{#/).until_after(/#}/),
    smarty: pattern.starting_with(/{(?=[^}{\s\n])/).until_after(/[^\s\n]}/),
    smarty_comment: pattern.starting_with(/{\*/).until_after(/\*}/),
    smarty_literal: pattern.starting_with(/{literal}/).until_after(/{\/literal}/)
  };
}
TemplatablePattern.prototype = new Pattern();

TemplatablePattern.prototype._create = function() {
  return new TemplatablePattern(this._input, this);
};

TemplatablePattern.prototype._update = function() {
  this.__set_templated_pattern();
};

TemplatablePattern.prototype.disable = function(language) {
  var result = this._create();
  result._disabled[language] = true;
  result._update();
  return result;
};

TemplatablePattern.prototype.read_options = function(options) {
  var result = this._create();
  for (var language in template_names) {
    result._disabled[language] = options.templating.indexOf(language) === -1;
  }
  result._update();
  return result;
};

TemplatablePattern.prototype.exclude = function(language) {
  var result = this._create();
  result._excluded[language] = true;
  result._update();
  return result;
};

TemplatablePattern.prototype.read = function() {
  var result = '';
  if (this._match_pattern) {
    result = this._input.read(this._starting_pattern);
  } else {
    result = this._input.read(this._starting_pattern, this.__template_pattern);
  }
  var next = this._read_template();
  while (next) {
    if (this._match_pattern) {
      next += this._input.read(this._match_pattern);
    } else {
      next += this._input.readUntil(this.__template_pattern);
    }
    result += next;
    next = this._read_template();
  }

  if (this._until_after) {
    result += this._input.readUntilAfter(this._until_pattern);
  }
  return result;
};

TemplatablePattern.prototype.__set_templated_pattern = function() {
  var items = [];

  if (!this._disabled.php) {
    items.push(this.__patterns.php._starting_pattern.source);
  }
  if (!this._disabled.handlebars) {
    items.push(this.__patterns.handlebars._starting_pattern.source);
  }
  if (!this._disabled.erb) {
    items.push(this.__patterns.erb._starting_pattern.source);
  }
  if (!this._disabled.django) {
    items.push(this.__patterns.django._starting_pattern.source);
    // The starting pattern for django is more complex because it has different
    // patterns for value, comment, and other sections
    items.push(this.__patterns.django_value._starting_pattern.source);
    items.push(this.__patterns.django_comment._starting_pattern.source);
  }
  if (!this._disabled.smarty) {
    items.push(this.__patterns.smarty._starting_pattern.source);
  }

  if (this._until_pattern) {
    items.push(this._until_pattern.source);
  }
  this.__template_pattern = this._input.get_regexp('(?:' + items.join('|') + ')');
};

TemplatablePattern.prototype._read_template = function() {
  var resulting_string = '';
  var c = this._input.peek();
  if (c === '<') {
    var peek1 = this._input.peek(1);
    //if we're in a comment, do something special
    // We treat all comments as literals, even more than preformatted tags
    // we just look for the appropriate close tag
    if (!this._disabled.php && !this._excluded.php && peek1 === '?') {
      resulting_string = resulting_string ||
        this.__patterns.php.read();
    }
    if (!this._disabled.erb && !this._excluded.erb && peek1 === '%') {
      resulting_string = resulting_string ||
        this.__patterns.erb.read();
    }
  } else if (c === '{') {
    if (!this._disabled.handlebars && !this._excluded.handlebars) {
      resulting_string = resulting_string ||
        this.__patterns.handlebars_comment.read();
      resulting_string = resulting_string ||
        this.__patterns.handlebars_unescaped.read();
      resulting_string = resulting_string ||
        this.__patterns.handlebars.read();
    }
    if (!this._disabled.django) {
      // django coflicts with handlebars a bit.
      if (!this._excluded.django && !this._excluded.handlebars) {
        resulting_string = resulting_string ||
          this.__patterns.django_value.read();
      }
      if (!this._excluded.django) {
        resulting_string = resulting_string ||
          this.__patterns.django_comment.read();
        resulting_string = resulting_string ||
          this.__patterns.django.read();
      }
    }
    if (!this._disabled.smarty) {
      // smarty cannot be enabled with django or handlebars enabled
      if (this._disabled.django && this._disabled.handlebars) {
        resulting_string = resulting_string ||
          this.__patterns.smarty_comment.read();
        resulting_string = resulting_string ||
          this.__patterns.smarty_literal.read();
        resulting_string = resulting_string ||
          this.__patterns.smarty.read();
      }
    }
  }
  return resulting_string;
};


module.exports.TemplatablePattern = TemplatablePattern;


/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__(0);
/******/ 	legacy_beautify_js = __webpack_exports__;
/******/ 	
/******/ })()
;
var js_beautify = legacy_beautify_js;
/* Footer */
if (true) {
    // Add support for AMD ( https://github.com/amdjs/amdjs-api/wiki/AMD#defineamd-property- )
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
        return { js_beautify: js_beautify };
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
} else {}

}());



/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/* AUTO-GENERATED. DO NOT MODIFY. */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.


 CSS Beautifier
---------------

    Written by Harutyun Amirjanyan, (amirjanyan@gmail.com)

    Based on code initially developed by: Einar Lielmanis, <einar@beautifier.io>
        https://beautifier.io/

    Usage:
        css_beautify(source_text);
        css_beautify(source_text, options);

    The options are (default in brackets):
        indent_size (4)                         — indentation size,
        indent_char (space)                     — character to indent with,
        selector_separator_newline (true)       - separate selectors with newline or
                                                  not (e.g. "a,\nbr" or "a, br")
        end_with_newline (false)                - end with a newline
        newline_between_rules (true)            - add a new line after every css rule
        space_around_selector_separator (false) - ensure space around selector separators:
                                                  '>', '+', '~' (e.g. "a>b" -> "a > b")
    e.g

    css_beautify(css_source_text, {
      'indent_size': 1,
      'indent_char': '\t',
      'selector_separator': ' ',
      'end_with_newline': false,
      'newline_between_rules': true,
      'space_around_selector_separator': true
    });
*/

// http://www.w3.org/TR/CSS21/syndata.html#tokenization
// http://www.w3.org/TR/css3-syntax/

(function() {

/* GENERATED_BUILD_OUTPUT */
var legacy_beautify_css;
/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ([
/* 0 */,
/* 1 */,
/* 2 */
/***/ (function(module) {

/*jshint node:true */
/*
  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



function OutputLine(parent) {
  this.__parent = parent;
  this.__character_count = 0;
  // use indent_count as a marker for this.__lines that have preserved indentation
  this.__indent_count = -1;
  this.__alignment_count = 0;
  this.__wrap_point_index = 0;
  this.__wrap_point_character_count = 0;
  this.__wrap_point_indent_count = -1;
  this.__wrap_point_alignment_count = 0;

  this.__items = [];
}

OutputLine.prototype.clone_empty = function() {
  var line = new OutputLine(this.__parent);
  line.set_indent(this.__indent_count, this.__alignment_count);
  return line;
};

OutputLine.prototype.item = function(index) {
  if (index < 0) {
    return this.__items[this.__items.length + index];
  } else {
    return this.__items[index];
  }
};

OutputLine.prototype.has_match = function(pattern) {
  for (var lastCheckedOutput = this.__items.length - 1; lastCheckedOutput >= 0; lastCheckedOutput--) {
    if (this.__items[lastCheckedOutput].match(pattern)) {
      return true;
    }
  }
  return false;
};

OutputLine.prototype.set_indent = function(indent, alignment) {
  if (this.is_empty()) {
    this.__indent_count = indent || 0;
    this.__alignment_count = alignment || 0;
    this.__character_count = this.__parent.get_indent_size(this.__indent_count, this.__alignment_count);
  }
};

OutputLine.prototype._set_wrap_point = function() {
  if (this.__parent.wrap_line_length) {
    this.__wrap_point_index = this.__items.length;
    this.__wrap_point_character_count = this.__character_count;
    this.__wrap_point_indent_count = this.__parent.next_line.__indent_count;
    this.__wrap_point_alignment_count = this.__parent.next_line.__alignment_count;
  }
};

OutputLine.prototype._should_wrap = function() {
  return this.__wrap_point_index &&
    this.__character_count > this.__parent.wrap_line_length &&
    this.__wrap_point_character_count > this.__parent.next_line.__character_count;
};

OutputLine.prototype._allow_wrap = function() {
  if (this._should_wrap()) {
    this.__parent.add_new_line();
    var next = this.__parent.current_line;
    next.set_indent(this.__wrap_point_indent_count, this.__wrap_point_alignment_count);
    next.__items = this.__items.slice(this.__wrap_point_index);
    this.__items = this.__items.slice(0, this.__wrap_point_index);

    next.__character_count += this.__character_count - this.__wrap_point_character_count;
    this.__character_count = this.__wrap_point_character_count;

    if (next.__items[0] === " ") {
      next.__items.splice(0, 1);
      next.__character_count -= 1;
    }
    return true;
  }
  return false;
};

OutputLine.prototype.is_empty = function() {
  return this.__items.length === 0;
};

OutputLine.prototype.last = function() {
  if (!this.is_empty()) {
    return this.__items[this.__items.length - 1];
  } else {
    return null;
  }
};

OutputLine.prototype.push = function(item) {
  this.__items.push(item);
  var last_newline_index = item.lastIndexOf('\n');
  if (last_newline_index !== -1) {
    this.__character_count = item.length - last_newline_index;
  } else {
    this.__character_count += item.length;
  }
};

OutputLine.prototype.pop = function() {
  var item = null;
  if (!this.is_empty()) {
    item = this.__items.pop();
    this.__character_count -= item.length;
  }
  return item;
};


OutputLine.prototype._remove_indent = function() {
  if (this.__indent_count > 0) {
    this.__indent_count -= 1;
    this.__character_count -= this.__parent.indent_size;
  }
};

OutputLine.prototype._remove_wrap_indent = function() {
  if (this.__wrap_point_indent_count > 0) {
    this.__wrap_point_indent_count -= 1;
  }
};
OutputLine.prototype.trim = function() {
  while (this.last() === ' ') {
    this.__items.pop();
    this.__character_count -= 1;
  }
};

OutputLine.prototype.toString = function() {
  var result = '';
  if (this.is_empty()) {
    if (this.__parent.indent_empty_lines) {
      result = this.__parent.get_indent_string(this.__indent_count);
    }
  } else {
    result = this.__parent.get_indent_string(this.__indent_count, this.__alignment_count);
    result += this.__items.join('');
  }
  return result;
};

function IndentStringCache(options, baseIndentString) {
  this.__cache = [''];
  this.__indent_size = options.indent_size;
  this.__indent_string = options.indent_char;
  if (!options.indent_with_tabs) {
    this.__indent_string = new Array(options.indent_size + 1).join(options.indent_char);
  }

  // Set to null to continue support for auto detection of base indent
  baseIndentString = baseIndentString || '';
  if (options.indent_level > 0) {
    baseIndentString = new Array(options.indent_level + 1).join(this.__indent_string);
  }

  this.__base_string = baseIndentString;
  this.__base_string_length = baseIndentString.length;
}

IndentStringCache.prototype.get_indent_size = function(indent, column) {
  var result = this.__base_string_length;
  column = column || 0;
  if (indent < 0) {
    result = 0;
  }
  result += indent * this.__indent_size;
  result += column;
  return result;
};

IndentStringCache.prototype.get_indent_string = function(indent_level, column) {
  var result = this.__base_string;
  column = column || 0;
  if (indent_level < 0) {
    indent_level = 0;
    result = '';
  }
  column += indent_level * this.__indent_size;
  this.__ensure_cache(column);
  result += this.__cache[column];
  return result;
};

IndentStringCache.prototype.__ensure_cache = function(column) {
  while (column >= this.__cache.length) {
    this.__add_column();
  }
};

IndentStringCache.prototype.__add_column = function() {
  var column = this.__cache.length;
  var indent = 0;
  var result = '';
  if (this.__indent_size && column >= this.__indent_size) {
    indent = Math.floor(column / this.__indent_size);
    column -= indent * this.__indent_size;
    result = new Array(indent + 1).join(this.__indent_string);
  }
  if (column) {
    result += new Array(column + 1).join(' ');
  }

  this.__cache.push(result);
};

function Output(options, baseIndentString) {
  this.__indent_cache = new IndentStringCache(options, baseIndentString);
  this.raw = false;
  this._end_with_newline = options.end_with_newline;
  this.indent_size = options.indent_size;
  this.wrap_line_length = options.wrap_line_length;
  this.indent_empty_lines = options.indent_empty_lines;
  this.__lines = [];
  this.previous_line = null;
  this.current_line = null;
  this.next_line = new OutputLine(this);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = false;
  // initialize
  this.__add_outputline();
}

Output.prototype.__add_outputline = function() {
  this.previous_line = this.current_line;
  this.current_line = this.next_line.clone_empty();
  this.__lines.push(this.current_line);
};

Output.prototype.get_line_number = function() {
  return this.__lines.length;
};

Output.prototype.get_indent_string = function(indent, column) {
  return this.__indent_cache.get_indent_string(indent, column);
};

Output.prototype.get_indent_size = function(indent, column) {
  return this.__indent_cache.get_indent_size(indent, column);
};

Output.prototype.is_empty = function() {
  return !this.previous_line && this.current_line.is_empty();
};

Output.prototype.add_new_line = function(force_newline) {
  // never newline at the start of file
  // otherwise, newline only if we didn't just add one or we're forced
  if (this.is_empty() ||
    (!force_newline && this.just_added_newline())) {
    return false;
  }

  // if raw output is enabled, don't print additional newlines,
  // but still return True as though you had
  if (!this.raw) {
    this.__add_outputline();
  }
  return true;
};

Output.prototype.get_code = function(eol) {
  this.trim(true);

  // handle some edge cases where the last tokens
  // has text that ends with newline(s)
  var last_item = this.current_line.pop();
  if (last_item) {
    if (last_item[last_item.length - 1] === '\n') {
      last_item = last_item.replace(/\n+$/g, '');
    }
    this.current_line.push(last_item);
  }

  if (this._end_with_newline) {
    this.__add_outputline();
  }

  var sweet_code = this.__lines.join('\n');

  if (eol !== '\n') {
    sweet_code = sweet_code.replace(/[\n]/g, eol);
  }
  return sweet_code;
};

Output.prototype.set_wrap_point = function() {
  this.current_line._set_wrap_point();
};

Output.prototype.set_indent = function(indent, alignment) {
  indent = indent || 0;
  alignment = alignment || 0;

  // Next line stores alignment values
  this.next_line.set_indent(indent, alignment);

  // Never indent your first output indent at the start of the file
  if (this.__lines.length > 1) {
    this.current_line.set_indent(indent, alignment);
    return true;
  }

  this.current_line.set_indent();
  return false;
};

Output.prototype.add_raw_token = function(token) {
  for (var x = 0; x < token.newlines; x++) {
    this.__add_outputline();
  }
  this.current_line.set_indent(-1);
  this.current_line.push(token.whitespace_before);
  this.current_line.push(token.text);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = false;
};

Output.prototype.add_token = function(printable_token) {
  this.__add_space_before_token();
  this.current_line.push(printable_token);
  this.space_before_token = false;
  this.non_breaking_space = false;
  this.previous_token_wrapped = this.current_line._allow_wrap();
};

Output.prototype.__add_space_before_token = function() {
  if (this.space_before_token && !this.just_added_newline()) {
    if (!this.non_breaking_space) {
      this.set_wrap_point();
    }
    this.current_line.push(' ');
  }
};

Output.prototype.remove_indent = function(index) {
  var output_length = this.__lines.length;
  while (index < output_length) {
    this.__lines[index]._remove_indent();
    index++;
  }
  this.current_line._remove_wrap_indent();
};

Output.prototype.trim = function(eat_newlines) {
  eat_newlines = (eat_newlines === undefined) ? false : eat_newlines;

  this.current_line.trim();

  while (eat_newlines && this.__lines.length > 1 &&
    this.current_line.is_empty()) {
    this.__lines.pop();
    this.current_line = this.__lines[this.__lines.length - 1];
    this.current_line.trim();
  }

  this.previous_line = this.__lines.length > 1 ?
    this.__lines[this.__lines.length - 2] : null;
};

Output.prototype.just_added_newline = function() {
  return this.current_line.is_empty();
};

Output.prototype.just_added_blankline = function() {
  return this.is_empty() ||
    (this.current_line.is_empty() && this.previous_line.is_empty());
};

Output.prototype.ensure_empty_line_above = function(starts_with, ends_with) {
  var index = this.__lines.length - 2;
  while (index >= 0) {
    var potentialEmptyLine = this.__lines[index];
    if (potentialEmptyLine.is_empty()) {
      break;
    } else if (potentialEmptyLine.item(0).indexOf(starts_with) !== 0 &&
      potentialEmptyLine.item(-1) !== ends_with) {
      this.__lines.splice(index + 1, 0, new OutputLine(this));
      this.previous_line = this.__lines[this.__lines.length - 2];
      break;
    }
    index--;
  }
};

module.exports.Output = Output;


/***/ }),
/* 3 */,
/* 4 */,
/* 5 */,
/* 6 */
/***/ (function(module) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



function Options(options, merge_child_field) {
  this.raw_options = _mergeOpts(options, merge_child_field);

  // Support passing the source text back with no change
  this.disabled = this._get_boolean('disabled');

  this.eol = this._get_characters('eol', 'auto');
  this.end_with_newline = this._get_boolean('end_with_newline');
  this.indent_size = this._get_number('indent_size', 4);
  this.indent_char = this._get_characters('indent_char', ' ');
  this.indent_level = this._get_number('indent_level');

  this.preserve_newlines = this._get_boolean('preserve_newlines', true);
  this.max_preserve_newlines = this._get_number('max_preserve_newlines', 32786);
  if (!this.preserve_newlines) {
    this.max_preserve_newlines = 0;
  }

  this.indent_with_tabs = this._get_boolean('indent_with_tabs', this.indent_char === '\t');
  if (this.indent_with_tabs) {
    this.indent_char = '\t';

    // indent_size behavior changed after 1.8.6
    // It used to be that indent_size would be
    // set to 1 for indent_with_tabs. That is no longer needed and
    // actually doesn't make sense - why not use spaces? Further,
    // that might produce unexpected behavior - tabs being used
    // for single-column alignment. So, when indent_with_tabs is true
    // and indent_size is 1, reset indent_size to 4.
    if (this.indent_size === 1) {
      this.indent_size = 4;
    }
  }

  // Backwards compat with 1.3.x
  this.wrap_line_length = this._get_number('wrap_line_length', this._get_number('max_char'));

  this.indent_empty_lines = this._get_boolean('indent_empty_lines');

  // valid templating languages ['django', 'erb', 'handlebars', 'php', 'smarty']
  // For now, 'auto' = all off for javascript, all on for html (and inline javascript).
  // other values ignored
  this.templating = this._get_selection_list('templating', ['auto', 'none', 'django', 'erb', 'handlebars', 'php', 'smarty'], ['auto']);
}

Options.prototype._get_array = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = default_value || [];
  if (typeof option_value === 'object') {
    if (option_value !== null && typeof option_value.concat === 'function') {
      result = option_value.concat();
    }
  } else if (typeof option_value === 'string') {
    result = option_value.split(/[^a-zA-Z0-9_\/\-]+/);
  }
  return result;
};

Options.prototype._get_boolean = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = option_value === undefined ? !!default_value : !!option_value;
  return result;
};

Options.prototype._get_characters = function(name, default_value) {
  var option_value = this.raw_options[name];
  var result = default_value || '';
  if (typeof option_value === 'string') {
    result = option_value.replace(/\\r/, '\r').replace(/\\n/, '\n').replace(/\\t/, '\t');
  }
  return result;
};

Options.prototype._get_number = function(name, default_value) {
  var option_value = this.raw_options[name];
  default_value = parseInt(default_value, 10);
  if (isNaN(default_value)) {
    default_value = 0;
  }
  var result = parseInt(option_value, 10);
  if (isNaN(result)) {
    result = default_value;
  }
  return result;
};

Options.prototype._get_selection = function(name, selection_list, default_value) {
  var result = this._get_selection_list(name, selection_list, default_value);
  if (result.length !== 1) {
    throw new Error(
      "Invalid Option Value: The option '" + name + "' can only be one of the following values:\n" +
      selection_list + "\nYou passed in: '" + this.raw_options[name] + "'");
  }

  return result[0];
};


Options.prototype._get_selection_list = function(name, selection_list, default_value) {
  if (!selection_list || selection_list.length === 0) {
    throw new Error("Selection list cannot be empty.");
  }

  default_value = default_value || [selection_list[0]];
  if (!this._is_valid_selection(default_value, selection_list)) {
    throw new Error("Invalid Default Value!");
  }

  var result = this._get_array(name, default_value);
  if (!this._is_valid_selection(result, selection_list)) {
    throw new Error(
      "Invalid Option Value: The option '" + name + "' can contain only the following values:\n" +
      selection_list + "\nYou passed in: '" + this.raw_options[name] + "'");
  }

  return result;
};

Options.prototype._is_valid_selection = function(result, selection_list) {
  return result.length && selection_list.length &&
    !result.some(function(item) { return selection_list.indexOf(item) === -1; });
};


// merges child options up with the parent options object
// Example: obj = {a: 1, b: {a: 2}}
//          mergeOpts(obj, 'b')
//
//          Returns: {a: 2}
function _mergeOpts(allOptions, childFieldName) {
  var finalOpts = {};
  allOptions = _normalizeOpts(allOptions);
  var name;

  for (name in allOptions) {
    if (name !== childFieldName) {
      finalOpts[name] = allOptions[name];
    }
  }

  //merge in the per type settings for the childFieldName
  if (childFieldName && allOptions[childFieldName]) {
    for (name in allOptions[childFieldName]) {
      finalOpts[name] = allOptions[childFieldName][name];
    }
  }
  return finalOpts;
}

function _normalizeOpts(options) {
  var convertedOpts = {};
  var key;

  for (key in options) {
    var newKey = key.replace(/-/g, "_");
    convertedOpts[newKey] = options[key];
  }
  return convertedOpts;
}

module.exports.Options = Options;
module.exports.normalizeOpts = _normalizeOpts;
module.exports.mergeOpts = _mergeOpts;


/***/ }),
/* 7 */,
/* 8 */
/***/ (function(module) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var regexp_has_sticky = RegExp.prototype.hasOwnProperty('sticky');

function InputScanner(input_string) {
  this.__input = input_string || '';
  this.__input_length = this.__input.length;
  this.__position = 0;
}

InputScanner.prototype.restart = function() {
  this.__position = 0;
};

InputScanner.prototype.back = function() {
  if (this.__position > 0) {
    this.__position -= 1;
  }
};

InputScanner.prototype.hasNext = function() {
  return this.__position < this.__input_length;
};

InputScanner.prototype.next = function() {
  var val = null;
  if (this.hasNext()) {
    val = this.__input.charAt(this.__position);
    this.__position += 1;
  }
  return val;
};

InputScanner.prototype.peek = function(index) {
  var val = null;
  index = index || 0;
  index += this.__position;
  if (index >= 0 && index < this.__input_length) {
    val = this.__input.charAt(index);
  }
  return val;
};

// This is a JavaScript only helper function (not in python)
// Javascript doesn't have a match method
// and not all implementation support "sticky" flag.
// If they do not support sticky then both this.match() and this.test() method
// must get the match and check the index of the match.
// If sticky is supported and set, this method will use it.
// Otherwise it will check that global is set, and fall back to the slower method.
InputScanner.prototype.__match = function(pattern, index) {
  pattern.lastIndex = index;
  var pattern_match = pattern.exec(this.__input);

  if (pattern_match && !(regexp_has_sticky && pattern.sticky)) {
    if (pattern_match.index !== index) {
      pattern_match = null;
    }
  }

  return pattern_match;
};

InputScanner.prototype.test = function(pattern, index) {
  index = index || 0;
  index += this.__position;

  if (index >= 0 && index < this.__input_length) {
    return !!this.__match(pattern, index);
  } else {
    return false;
  }
};

InputScanner.prototype.testChar = function(pattern, index) {
  // test one character regex match
  var val = this.peek(index);
  pattern.lastIndex = 0;
  return val !== null && pattern.test(val);
};

InputScanner.prototype.match = function(pattern) {
  var pattern_match = this.__match(pattern, this.__position);
  if (pattern_match) {
    this.__position += pattern_match[0].length;
  } else {
    pattern_match = null;
  }
  return pattern_match;
};

InputScanner.prototype.read = function(starting_pattern, until_pattern, until_after) {
  var val = '';
  var match;
  if (starting_pattern) {
    match = this.match(starting_pattern);
    if (match) {
      val += match[0];
    }
  }
  if (until_pattern && (match || !starting_pattern)) {
    val += this.readUntil(until_pattern, until_after);
  }
  return val;
};

InputScanner.prototype.readUntil = function(pattern, until_after) {
  var val = '';
  var match_index = this.__position;
  pattern.lastIndex = this.__position;
  var pattern_match = pattern.exec(this.__input);
  if (pattern_match) {
    match_index = pattern_match.index;
    if (until_after) {
      match_index += pattern_match[0].length;
    }
  } else {
    match_index = this.__input_length;
  }

  val = this.__input.substring(this.__position, match_index);
  this.__position = match_index;
  return val;
};

InputScanner.prototype.readUntilAfter = function(pattern) {
  return this.readUntil(pattern, true);
};

InputScanner.prototype.get_regexp = function(pattern, match_from) {
  var result = null;
  var flags = 'g';
  if (match_from && regexp_has_sticky) {
    flags = 'y';
  }
  // strings are converted to regexp
  if (typeof pattern === "string" && pattern !== '') {
    // result = new RegExp(pattern.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'), flags);
    result = new RegExp(pattern, flags);
  } else if (pattern) {
    result = new RegExp(pattern.source, flags);
  }
  return result;
};

InputScanner.prototype.get_literal_regexp = function(literal_string) {
  return RegExp(literal_string.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&'));
};

/* css beautifier legacy helpers */
InputScanner.prototype.peekUntilAfter = function(pattern) {
  var start = this.__position;
  var val = this.readUntilAfter(pattern);
  this.__position = start;
  return val;
};

InputScanner.prototype.lookBack = function(testVal) {
  var start = this.__position - 1;
  return start >= testVal.length && this.__input.substring(start - testVal.length, start)
    .toLowerCase() === testVal;
};

module.exports.InputScanner = InputScanner;


/***/ }),
/* 9 */,
/* 10 */,
/* 11 */,
/* 12 */,
/* 13 */
/***/ (function(module) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



function Directives(start_block_pattern, end_block_pattern) {
  start_block_pattern = typeof start_block_pattern === 'string' ? start_block_pattern : start_block_pattern.source;
  end_block_pattern = typeof end_block_pattern === 'string' ? end_block_pattern : end_block_pattern.source;
  this.__directives_block_pattern = new RegExp(start_block_pattern + / beautify( \w+[:]\w+)+ /.source + end_block_pattern, 'g');
  this.__directive_pattern = / (\w+)[:](\w+)/g;

  this.__directives_end_ignore_pattern = new RegExp(start_block_pattern + /\sbeautify\signore:end\s/.source + end_block_pattern, 'g');
}

Directives.prototype.get_directives = function(text) {
  if (!text.match(this.__directives_block_pattern)) {
    return null;
  }

  var directives = {};
  this.__directive_pattern.lastIndex = 0;
  var directive_match = this.__directive_pattern.exec(text);

  while (directive_match) {
    directives[directive_match[1]] = directive_match[2];
    directive_match = this.__directive_pattern.exec(text);
  }

  return directives;
};

Directives.prototype.readIgnored = function(input) {
  return input.readUntilAfter(this.__directives_end_ignore_pattern);
};


module.exports.Directives = Directives;


/***/ }),
/* 14 */,
/* 15 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var Beautifier = __webpack_require__(16).Beautifier,
  Options = __webpack_require__(17).Options;

function css_beautify(source_text, options) {
  var beautifier = new Beautifier(source_text, options);
  return beautifier.beautify();
}

module.exports = css_beautify;
module.exports.defaultOptions = function() {
  return new Options();
};


/***/ }),
/* 16 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var Options = __webpack_require__(17).Options;
var Output = __webpack_require__(2).Output;
var InputScanner = __webpack_require__(8).InputScanner;
var Directives = __webpack_require__(13).Directives;

var directives_core = new Directives(/\/\*/, /\*\//);

var lineBreak = /\r\n|[\r\n]/;
var allLineBreaks = /\r\n|[\r\n]/g;

// tokenizer
var whitespaceChar = /\s/;
var whitespacePattern = /(?:\s|\n)+/g;
var block_comment_pattern = /\/\*(?:[\s\S]*?)((?:\*\/)|$)/g;
var comment_pattern = /\/\/(?:[^\n\r\u2028\u2029]*)/g;

function Beautifier(source_text, options) {
  this._source_text = source_text || '';
  // Allow the setting of language/file-type specific options
  // with inheritance of overall settings
  this._options = new Options(options);
  this._ch = null;
  this._input = null;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/At-rule
  this.NESTED_AT_RULE = {
    "@page": true,
    "@font-face": true,
    "@keyframes": true,
    // also in CONDITIONAL_GROUP_RULE below
    "@media": true,
    "@supports": true,
    "@document": true
  };
  this.CONDITIONAL_GROUP_RULE = {
    "@media": true,
    "@supports": true,
    "@document": true
  };

}

Beautifier.prototype.eatString = function(endChars) {
  var result = '';
  this._ch = this._input.next();
  while (this._ch) {
    result += this._ch;
    if (this._ch === "\\") {
      result += this._input.next();
    } else if (endChars.indexOf(this._ch) !== -1 || this._ch === "\n") {
      break;
    }
    this._ch = this._input.next();
  }
  return result;
};

// Skips any white space in the source text from the current position.
// When allowAtLeastOneNewLine is true, will output new lines for each
// newline character found; if the user has preserve_newlines off, only
// the first newline will be output
Beautifier.prototype.eatWhitespace = function(allowAtLeastOneNewLine) {
  var result = whitespaceChar.test(this._input.peek());
  var newline_count = 0;
  while (whitespaceChar.test(this._input.peek())) {
    this._ch = this._input.next();
    if (allowAtLeastOneNewLine && this._ch === '\n') {
      if (newline_count === 0 || newline_count < this._options.max_preserve_newlines) {
        newline_count++;
        this._output.add_new_line(true);
      }
    }
  }
  return result;
};

// Nested pseudo-class if we are insideRule
// and the next special character found opens
// a new block
Beautifier.prototype.foundNestedPseudoClass = function() {
  var openParen = 0;
  var i = 1;
  var ch = this._input.peek(i);
  while (ch) {
    if (ch === "{") {
      return true;
    } else if (ch === '(') {
      // pseudoclasses can contain ()
      openParen += 1;
    } else if (ch === ')') {
      if (openParen === 0) {
        return false;
      }
      openParen -= 1;
    } else if (ch === ";" || ch === "}") {
      return false;
    }
    i++;
    ch = this._input.peek(i);
  }
  return false;
};

Beautifier.prototype.print_string = function(output_string) {
  this._output.set_indent(this._indentLevel);
  this._output.non_breaking_space = true;
  this._output.add_token(output_string);
};

Beautifier.prototype.preserveSingleSpace = function(isAfterSpace) {
  if (isAfterSpace) {
    this._output.space_before_token = true;
  }
};

Beautifier.prototype.indent = function() {
  this._indentLevel++;
};

Beautifier.prototype.outdent = function() {
  if (this._indentLevel > 0) {
    this._indentLevel--;
  }
};

/*_____________________--------------------_____________________*/

Beautifier.prototype.beautify = function() {
  if (this._options.disabled) {
    return this._source_text;
  }

  var source_text = this._source_text;
  var eol = this._options.eol;
  if (eol === 'auto') {
    eol = '\n';
    if (source_text && lineBreak.test(source_text || '')) {
      eol = source_text.match(lineBreak)[0];
    }
  }


  // HACK: newline parsing inconsistent. This brute force normalizes the this._input.
  source_text = source_text.replace(allLineBreaks, '\n');

  // reset
  var baseIndentString = source_text.match(/^[\t ]*/)[0];

  this._output = new Output(this._options, baseIndentString);
  this._input = new InputScanner(source_text);
  this._indentLevel = 0;
  this._nestedLevel = 0;

  this._ch = null;
  var parenLevel = 0;

  var insideRule = false;
  // This is the value side of a property value pair (blue in the following ex)
  // label { content: blue }
  var insidePropertyValue = false;
  var enteringConditionalGroup = false;
  var insideAtExtend = false;
  var insideAtImport = false;
  var topCharacter = this._ch;
  var whitespace;
  var isAfterSpace;
  var previous_ch;

  while (true) {
    whitespace = this._input.read(whitespacePattern);
    isAfterSpace = whitespace !== '';
    previous_ch = topCharacter;
    this._ch = this._input.next();
    if (this._ch === '\\' && this._input.hasNext()) {
      this._ch += this._input.next();
    }
    topCharacter = this._ch;

    if (!this._ch) {
      break;
    } else if (this._ch === '/' && this._input.peek() === '*') {
      // /* css comment */
      // Always start block comments on a new line.
      // This handles scenarios where a block comment immediately
      // follows a property definition on the same line or where
      // minified code is being beautified.
      this._output.add_new_line();
      this._input.back();

      var comment = this._input.read(block_comment_pattern);

      // Handle ignore directive
      var directives = directives_core.get_directives(comment);
      if (directives && directives.ignore === 'start') {
        comment += directives_core.readIgnored(this._input);
      }

      this.print_string(comment);

      // Ensures any new lines following the comment are preserved
      this.eatWhitespace(true);

      // Block comments are followed by a new line so they don't
      // share a line with other properties
      this._output.add_new_line();
    } else if (this._ch === '/' && this._input.peek() === '/') {
      // // single line comment
      // Preserves the space before a comment
      // on the same line as a rule
      this._output.space_before_token = true;
      this._input.back();
      this.print_string(this._input.read(comment_pattern));

      // Ensures any new lines following the comment are preserved
      this.eatWhitespace(true);
    } else if (this._ch === '@') {
      this.preserveSingleSpace(isAfterSpace);

      // deal with less propery mixins @{...}
      if (this._input.peek() === '{') {
        this.print_string(this._ch + this.eatString('}'));
      } else {
        this.print_string(this._ch);

        // strip trailing space, if present, for hash property checks
        var variableOrRule = this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);

        if (variableOrRule.match(/[ :]$/)) {
          // we have a variable or pseudo-class, add it and insert one space before continuing
          variableOrRule = this.eatString(": ").replace(/\s$/, '');
          this.print_string(variableOrRule);
          this._output.space_before_token = true;
        }

        variableOrRule = variableOrRule.replace(/\s$/, '');

        if (variableOrRule === 'extend') {
          insideAtExtend = true;
        } else if (variableOrRule === 'import') {
          insideAtImport = true;
        }

        // might be a nesting at-rule
        if (variableOrRule in this.NESTED_AT_RULE) {
          this._nestedLevel += 1;
          if (variableOrRule in this.CONDITIONAL_GROUP_RULE) {
            enteringConditionalGroup = true;
          }
          // might be less variable
        } else if (!insideRule && parenLevel === 0 && variableOrRule.indexOf(':') !== -1) {
          insidePropertyValue = true;
          this.indent();
        }
      }
    } else if (this._ch === '#' && this._input.peek() === '{') {
      this.preserveSingleSpace(isAfterSpace);
      this.print_string(this._ch + this.eatString('}'));
    } else if (this._ch === '{') {
      if (insidePropertyValue) {
        insidePropertyValue = false;
        this.outdent();
      }

      // when entering conditional groups, only rulesets are allowed
      if (enteringConditionalGroup) {
        enteringConditionalGroup = false;
        insideRule = (this._indentLevel >= this._nestedLevel);
      } else {
        // otherwise, declarations are also allowed
        insideRule = (this._indentLevel >= this._nestedLevel - 1);
      }
      if (this._options.newline_between_rules && insideRule) {
        if (this._output.previous_line && this._output.previous_line.item(-1) !== '{') {
          this._output.ensure_empty_line_above('/', ',');
        }
      }

      this._output.space_before_token = true;

      // The difference in print_string and indent order is necessary to indent the '{' correctly
      if (this._options.brace_style === 'expand') {
        this._output.add_new_line();
        this.print_string(this._ch);
        this.indent();
        this._output.set_indent(this._indentLevel);
      } else {
        this.indent();
        this.print_string(this._ch);
      }

      this.eatWhitespace(true);
      this._output.add_new_line();
    } else if (this._ch === '}') {
      this.outdent();
      this._output.add_new_line();
      if (previous_ch === '{') {
        this._output.trim(true);
      }
      insideAtImport = false;
      insideAtExtend = false;
      if (insidePropertyValue) {
        this.outdent();
        insidePropertyValue = false;
      }
      this.print_string(this._ch);
      insideRule = false;
      if (this._nestedLevel) {
        this._nestedLevel--;
      }

      this.eatWhitespace(true);
      this._output.add_new_line();

      if (this._options.newline_between_rules && !this._output.just_added_blankline()) {
        if (this._input.peek() !== '}') {
          this._output.add_new_line(true);
        }
      }
    } else if (this._ch === ":") {
      if ((insideRule || enteringConditionalGroup) && !(this._input.lookBack("&") || this.foundNestedPseudoClass()) && !this._input.lookBack("(") && !insideAtExtend && parenLevel === 0) {
        // 'property: value' delimiter
        // which could be in a conditional group query
        this.print_string(':');
        if (!insidePropertyValue) {
          insidePropertyValue = true;
          this._output.space_before_token = true;
          this.eatWhitespace(true);
          this.indent();
        }
      } else {
        // sass/less parent reference don't use a space
        // sass nested pseudo-class don't use a space

        // preserve space before pseudoclasses/pseudoelements, as it means "in any child"
        if (this._input.lookBack(" ")) {
          this._output.space_before_token = true;
        }
        if (this._input.peek() === ":") {
          // pseudo-element
          this._ch = this._input.next();
          this.print_string("::");
        } else {
          // pseudo-class
          this.print_string(':');
        }
      }
    } else if (this._ch === '"' || this._ch === '\'') {
      this.preserveSingleSpace(isAfterSpace);
      this.print_string(this._ch + this.eatString(this._ch));
      this.eatWhitespace(true);
    } else if (this._ch === ';') {
      if (parenLevel === 0) {
        if (insidePropertyValue) {
          this.outdent();
          insidePropertyValue = false;
        }
        insideAtExtend = false;
        insideAtImport = false;
        this.print_string(this._ch);
        this.eatWhitespace(true);

        // This maintains single line comments on the same
        // line. Block comments are also affected, but
        // a new line is always output before one inside
        // that section
        if (this._input.peek() !== '/') {
          this._output.add_new_line();
        }
      } else {
        this.print_string(this._ch);
        this.eatWhitespace(true);
        this._output.space_before_token = true;
      }
    } else if (this._ch === '(') { // may be a url
      if (this._input.lookBack("url")) {
        this.print_string(this._ch);
        this.eatWhitespace();
        parenLevel++;
        this.indent();
        this._ch = this._input.next();
        if (this._ch === ')' || this._ch === '"' || this._ch === '\'') {
          this._input.back();
        } else if (this._ch) {
          this.print_string(this._ch + this.eatString(')'));
          if (parenLevel) {
            parenLevel--;
            this.outdent();
          }
        }
      } else {
        this.preserveSingleSpace(isAfterSpace);
        this.print_string(this._ch);
        this.eatWhitespace();
        parenLevel++;
        this.indent();
      }
    } else if (this._ch === ')') {
      if (parenLevel) {
        parenLevel--;
        this.outdent();
      }
      this.print_string(this._ch);
    } else if (this._ch === ',') {
      this.print_string(this._ch);
      this.eatWhitespace(true);
      if (this._options.selector_separator_newline && !insidePropertyValue && parenLevel === 0 && !insideAtImport) {
        this._output.add_new_line();
      } else {
        this._output.space_before_token = true;
      }
    } else if ((this._ch === '>' || this._ch === '+' || this._ch === '~') && !insidePropertyValue && parenLevel === 0) {
      //handle combinator spacing
      if (this._options.space_around_combinator) {
        this._output.space_before_token = true;
        this.print_string(this._ch);
        this._output.space_before_token = true;
      } else {
        this.print_string(this._ch);
        this.eatWhitespace();
        // squash extra whitespace
        if (this._ch && whitespaceChar.test(this._ch)) {
          this._ch = '';
        }
      }
    } else if (this._ch === ']') {
      this.print_string(this._ch);
    } else if (this._ch === '[') {
      this.preserveSingleSpace(isAfterSpace);
      this.print_string(this._ch);
    } else if (this._ch === '=') { // no whitespace before or after
      this.eatWhitespace();
      this.print_string('=');
      if (whitespaceChar.test(this._ch)) {
        this._ch = '';
      }
    } else if (this._ch === '!' && !this._input.lookBack("\\")) { // !important
      this.print_string(' ');
      this.print_string(this._ch);
    } else {
      this.preserveSingleSpace(isAfterSpace);
      this.print_string(this._ch);
    }
  }

  var sweetCode = this._output.get_code(eol);

  return sweetCode;
};

module.exports.Beautifier = Beautifier;


/***/ }),
/* 17 */
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*jshint node:true */
/*

  The MIT License (MIT)

  Copyright (c) 2007-2018 Einar Lielmanis, Liam Newman, and contributors.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation files
  (the "Software"), to deal in the Software without restriction,
  including without limitation the rights to use, copy, modify, merge,
  publish, distribute, sublicense, and/or sell copies of the Software,
  and to permit persons to whom the Software is furnished to do so,
  subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
  SOFTWARE.
*/



var BaseOptions = __webpack_require__(6).Options;

function Options(options) {
  BaseOptions.call(this, options, 'css');

  this.selector_separator_newline = this._get_boolean('selector_separator_newline', true);
  this.newline_between_rules = this._get_boolean('newline_between_rules', true);
  var space_around_selector_separator = this._get_boolean('space_around_selector_separator');
  this.space_around_combinator = this._get_boolean('space_around_combinator') || space_around_selector_separator;

  var brace_style_split = this._get_selection_list('brace_style', ['collapse', 'expand', 'end-expand', 'none', 'preserve-inline']);
  this.brace_style = 'collapse';
  for (var bs = 0; bs < brace_style_split.length; bs++) {
    if (brace_style_split[bs] !== 'expand') {
      // default to collapse, as only collapse|expand is implemented for now
      this.brace_style = 'collapse';
    } else {
      this.brace_style = brace_style_split[bs];
    }
  }
}
Options.prototype = new BaseOptions();



module.exports.Options = Options;


/***/ })
/******/ 	]);
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__(15);
/******/ 	legacy_beautify_css = __webpack_exports__;
/******/ 	
/******/ })()
;
var css_beautify = legacy_beautify_css;
/* Footer */
if (true) {
    // Add support for AMD ( https://github.com/amdjs/amdjs-api/wiki/AMD#defineamd-property- )
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function() {
        return {
            css_beautify: css_beautify
        };
    }).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
} else {}

}());


/***/ }),
/* 8 */
/***/ (function(module, exports) {

module.exports = function(module) {
	if (!module.webpackPolyfill) {
		module.deprecate = function() {};
		module.paths = [];
		// module.parent = undefined by default
		if (!module.children) module.children = [];
		Object.defineProperty(module, "loaded", {
			enumerable: true,
			get: function() {
				return module.l;
			}
		});
		Object.defineProperty(module, "id", {
			enumerable: true,
			get: function() {
				return module.i;
			}
		});
		module.webpackPolyfill = 1;
	}
	return module;
};


/***/ }),
/* 9 */
/***/ (function(module, exports) {

function webpackEmptyContext(req) {
	var e = new Error("Cannot find module '" + req + "'");
	e.code = 'MODULE_NOT_FOUND';
	throw e;
}
webpackEmptyContext.keys = function() { return []; };
webpackEmptyContext.resolve = webpackEmptyContext;
module.exports = webpackEmptyContext;
webpackEmptyContext.id = 9;

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*! jQuery v3.4.1 | (c) JS Foundation and other contributors | jquery.org/license */
!function(e,t){"use strict"; true&&"object"==typeof module.exports?module.exports=e.document?t(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return t(e)}:t(e)}("undefined"!=typeof window?window:this,function(C,e){"use strict";var t=[],E=C.document,r=Object.getPrototypeOf,s=t.slice,g=t.concat,u=t.push,i=t.indexOf,n={},o=n.toString,v=n.hasOwnProperty,a=v.toString,l=a.call(Object),y={},m=function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},x=function(e){return null!=e&&e===e.window},c={type:!0,src:!0,nonce:!0,noModule:!0};function b(e,t,n){var r,i,o=(n=n||E).createElement("script");if(o.text=e,t)for(r in c)(i=t[r]||t.getAttribute&&t.getAttribute(r))&&o.setAttribute(r,i);n.head.appendChild(o).parentNode.removeChild(o)}function w(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?n[o.call(e)]||"object":typeof e}var f="3.4.1",k=function(e,t){return new k.fn.init(e,t)},p=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;function d(e){var t=!!e&&"length"in e&&e.length,n=w(e);return!m(e)&&!x(e)&&("array"===n||0===t||"number"==typeof t&&0<t&&t-1 in e)}k.fn=k.prototype={jquery:f,constructor:k,length:0,toArray:function(){return s.call(this)},get:function(e){return null==e?s.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=k.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return k.each(this,e)},map:function(n){return this.pushStack(k.map(this,function(e,t){return n.call(e,t,e)}))},slice:function(){return this.pushStack(s.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(0<=n&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:u,sort:t.sort,splice:t.splice},k.extend=k.fn.extend=function(){var e,t,n,r,i,o,a=arguments[0]||{},s=1,u=arguments.length,l=!1;for("boolean"==typeof a&&(l=a,a=arguments[s]||{},s++),"object"==typeof a||m(a)||(a={}),s===u&&(a=this,s--);s<u;s++)if(null!=(e=arguments[s]))for(t in e)r=e[t],"__proto__"!==t&&a!==r&&(l&&r&&(k.isPlainObject(r)||(i=Array.isArray(r)))?(n=a[t],o=i&&!Array.isArray(n)?[]:i||k.isPlainObject(n)?n:{},i=!1,a[t]=k.extend(l,o,r)):void 0!==r&&(a[t]=r));return a},k.extend({expando:"jQuery"+(f+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==o.call(e))&&(!(t=r(e))||"function"==typeof(n=v.call(t,"constructor")&&t.constructor)&&a.call(n)===l)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},globalEval:function(e,t){b(e,{nonce:t&&t.nonce})},each:function(e,t){var n,r=0;if(d(e)){for(n=e.length;r<n;r++)if(!1===t.call(e[r],r,e[r]))break}else for(r in e)if(!1===t.call(e[r],r,e[r]))break;return e},trim:function(e){return null==e?"":(e+"").replace(p,"")},makeArray:function(e,t){var n=t||[];return null!=e&&(d(Object(e))?k.merge(n,"string"==typeof e?[e]:e):u.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:i.call(t,e,n)},merge:function(e,t){for(var n=+t.length,r=0,i=e.length;r<n;r++)e[i++]=t[r];return e.length=i,e},grep:function(e,t,n){for(var r=[],i=0,o=e.length,a=!n;i<o;i++)!t(e[i],i)!==a&&r.push(e[i]);return r},map:function(e,t,n){var r,i,o=0,a=[];if(d(e))for(r=e.length;o<r;o++)null!=(i=t(e[o],o,n))&&a.push(i);else for(o in e)null!=(i=t(e[o],o,n))&&a.push(i);return g.apply([],a)},guid:1,support:y}),"function"==typeof Symbol&&(k.fn[Symbol.iterator]=t[Symbol.iterator]),k.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){n["[object "+t+"]"]=t.toLowerCase()});var h=function(n){var e,d,b,o,i,h,f,g,w,u,l,T,C,a,E,v,s,c,y,k="sizzle"+1*new Date,m=n.document,S=0,r=0,p=ue(),x=ue(),N=ue(),A=ue(),D=function(e,t){return e===t&&(l=!0),0},j={}.hasOwnProperty,t=[],q=t.pop,L=t.push,H=t.push,O=t.slice,P=function(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1},R="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",I="(?:\\\\.|[\\w-]|[^\0-\\xa0])+",W="\\["+M+"*("+I+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+M+"*\\]",$=":("+I+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+W+")*)|.*)\\)|)",F=new RegExp(M+"+","g"),B=new RegExp("^"+M+"+|((?:^|[^\\\\])(?:\\\\.)*)"+M+"+$","g"),_=new RegExp("^"+M+"*,"+M+"*"),z=new RegExp("^"+M+"*([>+~]|"+M+")"+M+"*"),U=new RegExp(M+"|>"),X=new RegExp($),V=new RegExp("^"+I+"$"),G={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+W),PSEUDO:new RegExp("^"+$),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+M+"*(even|odd|(([+-]|)(\\d*)n|)"+M+"*(?:([+-]|)"+M+"*(\\d+)|))"+M+"*\\)|)","i"),bool:new RegExp("^(?:"+R+")$","i"),needsContext:new RegExp("^"+M+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+M+"*((?:-\\d)?\\d*)"+M+"*\\)|)(?=[^-]|$)","i")},Y=/HTML$/i,Q=/^(?:input|select|textarea|button)$/i,J=/^h\d$/i,K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\([\\da-f]{1,6}"+M+"?|("+M+")|.)","ig"),ne=function(e,t,n){var r="0x"+t-65536;return r!=r||n?t:r<0?String.fromCharCode(r+65536):String.fromCharCode(r>>10|55296,1023&r|56320)},re=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ie=function(e,t){return t?"\0"===e?"\ufffd":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){T()},ae=be(function(e){return!0===e.disabled&&"fieldset"===e.nodeName.toLowerCase()},{dir:"parentNode",next:"legend"});try{H.apply(t=O.call(m.childNodes),m.childNodes),t[m.childNodes.length].nodeType}catch(e){H={apply:t.length?function(e,t){L.apply(e,O.call(t))}:function(e,t){var n=e.length,r=0;while(e[n++]=t[r++]);e.length=n-1}}}function se(t,e,n,r){var i,o,a,s,u,l,c,f=e&&e.ownerDocument,p=e?e.nodeType:9;if(n=n||[],"string"!=typeof t||!t||1!==p&&9!==p&&11!==p)return n;if(!r&&((e?e.ownerDocument||e:m)!==C&&T(e),e=e||C,E)){if(11!==p&&(u=Z.exec(t)))if(i=u[1]){if(9===p){if(!(a=e.getElementById(i)))return n;if(a.id===i)return n.push(a),n}else if(f&&(a=f.getElementById(i))&&y(e,a)&&a.id===i)return n.push(a),n}else{if(u[2])return H.apply(n,e.getElementsByTagName(t)),n;if((i=u[3])&&d.getElementsByClassName&&e.getElementsByClassName)return H.apply(n,e.getElementsByClassName(i)),n}if(d.qsa&&!A[t+" "]&&(!v||!v.test(t))&&(1!==p||"object"!==e.nodeName.toLowerCase())){if(c=t,f=e,1===p&&U.test(t)){(s=e.getAttribute("id"))?s=s.replace(re,ie):e.setAttribute("id",s=k),o=(l=h(t)).length;while(o--)l[o]="#"+s+" "+xe(l[o]);c=l.join(","),f=ee.test(t)&&ye(e.parentNode)||e}try{return H.apply(n,f.querySelectorAll(c)),n}catch(e){A(t,!0)}finally{s===k&&e.removeAttribute("id")}}}return g(t.replace(B,"$1"),e,n,r)}function ue(){var r=[];return function e(t,n){return r.push(t+" ")>b.cacheLength&&delete e[r.shift()],e[t+" "]=n}}function le(e){return e[k]=!0,e}function ce(e){var t=C.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function fe(e,t){var n=e.split("|"),r=n.length;while(r--)b.attrHandle[n[r]]=t}function pe(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function de(t){return function(e){return"input"===e.nodeName.toLowerCase()&&e.type===t}}function he(n){return function(e){var t=e.nodeName.toLowerCase();return("input"===t||"button"===t)&&e.type===n}}function ge(t){return function(e){return"form"in e?e.parentNode&&!1===e.disabled?"label"in e?"label"in e.parentNode?e.parentNode.disabled===t:e.disabled===t:e.isDisabled===t||e.isDisabled!==!t&&ae(e)===t:e.disabled===t:"label"in e&&e.disabled===t}}function ve(a){return le(function(o){return o=+o,le(function(e,t){var n,r=a([],e.length,o),i=r.length;while(i--)e[n=r[i]]&&(e[n]=!(t[n]=e[n]))})})}function ye(e){return e&&"undefined"!=typeof e.getElementsByTagName&&e}for(e in d=se.support={},i=se.isXML=function(e){var t=e.namespaceURI,n=(e.ownerDocument||e).documentElement;return!Y.test(t||n&&n.nodeName||"HTML")},T=se.setDocument=function(e){var t,n,r=e?e.ownerDocument||e:m;return r!==C&&9===r.nodeType&&r.documentElement&&(a=(C=r).documentElement,E=!i(C),m!==C&&(n=C.defaultView)&&n.top!==n&&(n.addEventListener?n.addEventListener("unload",oe,!1):n.attachEvent&&n.attachEvent("onunload",oe)),d.attributes=ce(function(e){return e.className="i",!e.getAttribute("className")}),d.getElementsByTagName=ce(function(e){return e.appendChild(C.createComment("")),!e.getElementsByTagName("*").length}),d.getElementsByClassName=K.test(C.getElementsByClassName),d.getById=ce(function(e){return a.appendChild(e).id=k,!C.getElementsByName||!C.getElementsByName(k).length}),d.getById?(b.filter.ID=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n=t.getElementById(e);return n?[n]:[]}}):(b.filter.ID=function(e){var n=e.replace(te,ne);return function(e){var t="undefined"!=typeof e.getAttributeNode&&e.getAttributeNode("id");return t&&t.value===n}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n,r,i,o=t.getElementById(e);if(o){if((n=o.getAttributeNode("id"))&&n.value===e)return[o];i=t.getElementsByName(e),r=0;while(o=i[r++])if((n=o.getAttributeNode("id"))&&n.value===e)return[o]}return[]}}),b.find.TAG=d.getElementsByTagName?function(e,t){return"undefined"!=typeof t.getElementsByTagName?t.getElementsByTagName(e):d.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},b.find.CLASS=d.getElementsByClassName&&function(e,t){if("undefined"!=typeof t.getElementsByClassName&&E)return t.getElementsByClassName(e)},s=[],v=[],(d.qsa=K.test(C.querySelectorAll))&&(ce(function(e){a.appendChild(e).innerHTML="<a id='"+k+"'></a><select id='"+k+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&v.push("[*^$]="+M+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||v.push("\\["+M+"*(?:value|"+R+")"),e.querySelectorAll("[id~="+k+"-]").length||v.push("~="),e.querySelectorAll(":checked").length||v.push(":checked"),e.querySelectorAll("a#"+k+"+*").length||v.push(".#.+[+~]")}),ce(function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=C.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&v.push("name"+M+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&v.push(":enabled",":disabled"),a.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&v.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),v.push(",.*:")})),(d.matchesSelector=K.test(c=a.matches||a.webkitMatchesSelector||a.mozMatchesSelector||a.oMatchesSelector||a.msMatchesSelector))&&ce(function(e){d.disconnectedMatch=c.call(e,"*"),c.call(e,"[s!='']:x"),s.push("!=",$)}),v=v.length&&new RegExp(v.join("|")),s=s.length&&new RegExp(s.join("|")),t=K.test(a.compareDocumentPosition),y=t||K.test(a.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},D=t?function(e,t){if(e===t)return l=!0,0;var n=!e.compareDocumentPosition-!t.compareDocumentPosition;return n||(1&(n=(e.ownerDocument||e)===(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!d.sortDetached&&t.compareDocumentPosition(e)===n?e===C||e.ownerDocument===m&&y(m,e)?-1:t===C||t.ownerDocument===m&&y(m,t)?1:u?P(u,e)-P(u,t):0:4&n?-1:1)}:function(e,t){if(e===t)return l=!0,0;var n,r=0,i=e.parentNode,o=t.parentNode,a=[e],s=[t];if(!i||!o)return e===C?-1:t===C?1:i?-1:o?1:u?P(u,e)-P(u,t):0;if(i===o)return pe(e,t);n=e;while(n=n.parentNode)a.unshift(n);n=t;while(n=n.parentNode)s.unshift(n);while(a[r]===s[r])r++;return r?pe(a[r],s[r]):a[r]===m?-1:s[r]===m?1:0}),C},se.matches=function(e,t){return se(e,null,null,t)},se.matchesSelector=function(e,t){if((e.ownerDocument||e)!==C&&T(e),d.matchesSelector&&E&&!A[t+" "]&&(!s||!s.test(t))&&(!v||!v.test(t)))try{var n=c.call(e,t);if(n||d.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(e){A(t,!0)}return 0<se(t,C,null,[e]).length},se.contains=function(e,t){return(e.ownerDocument||e)!==C&&T(e),y(e,t)},se.attr=function(e,t){(e.ownerDocument||e)!==C&&T(e);var n=b.attrHandle[t.toLowerCase()],r=n&&j.call(b.attrHandle,t.toLowerCase())?n(e,t,!E):void 0;return void 0!==r?r:d.attributes||!E?e.getAttribute(t):(r=e.getAttributeNode(t))&&r.specified?r.value:null},se.escape=function(e){return(e+"").replace(re,ie)},se.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},se.uniqueSort=function(e){var t,n=[],r=0,i=0;if(l=!d.detectDuplicates,u=!d.sortStable&&e.slice(0),e.sort(D),l){while(t=e[i++])t===e[i]&&(r=n.push(i));while(r--)e.splice(n[r],1)}return u=null,e},o=se.getText=function(e){var t,n="",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=o(e)}else if(3===i||4===i)return e.nodeValue}else while(t=e[r++])n+=o(t);return n},(b=se.selectors={cacheLength:50,createPseudo:le,match:G,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(te,ne),e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||se.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&se.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return G.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&X.test(n)&&(t=h(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=p[e+" "];return t||(t=new RegExp("(^|"+M+")"+e+"("+M+"|$)"))&&p(e,function(e){return t.test("string"==typeof e.className&&e.className||"undefined"!=typeof e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(n,r,i){return function(e){var t=se.attr(e,n);return null==t?"!="===r:!r||(t+="","="===r?t===i:"!="===r?t!==i:"^="===r?i&&0===t.indexOf(i):"*="===r?i&&-1<t.indexOf(i):"$="===r?i&&t.slice(-i.length)===i:"~="===r?-1<(" "+t.replace(F," ")+" ").indexOf(i):"|="===r&&(t===i||t.slice(0,i.length+1)===i+"-"))}},CHILD:function(h,e,t,g,v){var y="nth"!==h.slice(0,3),m="last"!==h.slice(-4),x="of-type"===e;return 1===g&&0===v?function(e){return!!e.parentNode}:function(e,t,n){var r,i,o,a,s,u,l=y!==m?"nextSibling":"previousSibling",c=e.parentNode,f=x&&e.nodeName.toLowerCase(),p=!n&&!x,d=!1;if(c){if(y){while(l){a=e;while(a=a[l])if(x?a.nodeName.toLowerCase()===f:1===a.nodeType)return!1;u=l="only"===h&&!u&&"nextSibling"}return!0}if(u=[m?c.firstChild:c.lastChild],m&&p){d=(s=(r=(i=(o=(a=c)[k]||(a[k]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===S&&r[1])&&r[2],a=s&&c.childNodes[s];while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if(1===a.nodeType&&++d&&a===e){i[h]=[S,s,d];break}}else if(p&&(d=s=(r=(i=(o=(a=e)[k]||(a[k]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===S&&r[1]),!1===d)while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if((x?a.nodeName.toLowerCase()===f:1===a.nodeType)&&++d&&(p&&((i=(o=a[k]||(a[k]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]=[S,d]),a===e))break;return(d-=v)===g||d%g==0&&0<=d/g}}},PSEUDO:function(e,o){var t,a=b.pseudos[e]||b.setFilters[e.toLowerCase()]||se.error("unsupported pseudo: "+e);return a[k]?a(o):1<a.length?(t=[e,e,"",o],b.setFilters.hasOwnProperty(e.toLowerCase())?le(function(e,t){var n,r=a(e,o),i=r.length;while(i--)e[n=P(e,r[i])]=!(t[n]=r[i])}):function(e){return a(e,0,t)}):a}},pseudos:{not:le(function(e){var r=[],i=[],s=f(e.replace(B,"$1"));return s[k]?le(function(e,t,n,r){var i,o=s(e,null,r,[]),a=e.length;while(a--)(i=o[a])&&(e[a]=!(t[a]=i))}):function(e,t,n){return r[0]=e,s(r,null,n,i),r[0]=null,!i.pop()}}),has:le(function(t){return function(e){return 0<se(t,e).length}}),contains:le(function(t){return t=t.replace(te,ne),function(e){return-1<(e.textContent||o(e)).indexOf(t)}}),lang:le(function(n){return V.test(n||"")||se.error("unsupported lang: "+n),n=n.replace(te,ne).toLowerCase(),function(e){var t;do{if(t=E?e.lang:e.getAttribute("xml:lang")||e.getAttribute("lang"))return(t=t.toLowerCase())===n||0===t.indexOf(n+"-")}while((e=e.parentNode)&&1===e.nodeType);return!1}}),target:function(e){var t=n.location&&n.location.hash;return t&&t.slice(1)===e.id},root:function(e){return e===a},focus:function(e){return e===C.activeElement&&(!C.hasFocus||C.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:ge(!1),disabled:ge(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!b.pseudos.empty(e)},header:function(e){return J.test(e.nodeName)},input:function(e){return Q.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:ve(function(){return[0]}),last:ve(function(e,t){return[t-1]}),eq:ve(function(e,t,n){return[n<0?n+t:n]}),even:ve(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:ve(function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e}),lt:ve(function(e,t,n){for(var r=n<0?n+t:t<n?t:n;0<=--r;)e.push(r);return e}),gt:ve(function(e,t,n){for(var r=n<0?n+t:n;++r<t;)e.push(r);return e})}}).pseudos.nth=b.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})b.pseudos[e]=de(e);for(e in{submit:!0,reset:!0})b.pseudos[e]=he(e);function me(){}function xe(e){for(var t=0,n=e.length,r="";t<n;t++)r+=e[t].value;return r}function be(s,e,t){var u=e.dir,l=e.next,c=l||u,f=t&&"parentNode"===c,p=r++;return e.first?function(e,t,n){while(e=e[u])if(1===e.nodeType||f)return s(e,t,n);return!1}:function(e,t,n){var r,i,o,a=[S,p];if(n){while(e=e[u])if((1===e.nodeType||f)&&s(e,t,n))return!0}else while(e=e[u])if(1===e.nodeType||f)if(i=(o=e[k]||(e[k]={}))[e.uniqueID]||(o[e.uniqueID]={}),l&&l===e.nodeName.toLowerCase())e=e[u]||e;else{if((r=i[c])&&r[0]===S&&r[1]===p)return a[2]=r[2];if((i[c]=a)[2]=s(e,t,n))return!0}return!1}}function we(i){return 1<i.length?function(e,t,n){var r=i.length;while(r--)if(!i[r](e,t,n))return!1;return!0}:i[0]}function Te(e,t,n,r,i){for(var o,a=[],s=0,u=e.length,l=null!=t;s<u;s++)(o=e[s])&&(n&&!n(o,r,i)||(a.push(o),l&&t.push(s)));return a}function Ce(d,h,g,v,y,e){return v&&!v[k]&&(v=Ce(v)),y&&!y[k]&&(y=Ce(y,e)),le(function(e,t,n,r){var i,o,a,s=[],u=[],l=t.length,c=e||function(e,t,n){for(var r=0,i=t.length;r<i;r++)se(e,t[r],n);return n}(h||"*",n.nodeType?[n]:n,[]),f=!d||!e&&h?c:Te(c,s,d,n,r),p=g?y||(e?d:l||v)?[]:t:f;if(g&&g(f,p,n,r),v){i=Te(p,u),v(i,[],n,r),o=i.length;while(o--)(a=i[o])&&(p[u[o]]=!(f[u[o]]=a))}if(e){if(y||d){if(y){i=[],o=p.length;while(o--)(a=p[o])&&i.push(f[o]=a);y(null,p=[],i,r)}o=p.length;while(o--)(a=p[o])&&-1<(i=y?P(e,a):s[o])&&(e[i]=!(t[i]=a))}}else p=Te(p===t?p.splice(l,p.length):p),y?y(null,t,p,r):H.apply(t,p)})}function Ee(e){for(var i,t,n,r=e.length,o=b.relative[e[0].type],a=o||b.relative[" "],s=o?1:0,u=be(function(e){return e===i},a,!0),l=be(function(e){return-1<P(i,e)},a,!0),c=[function(e,t,n){var r=!o&&(n||t!==w)||((i=t).nodeType?u(e,t,n):l(e,t,n));return i=null,r}];s<r;s++)if(t=b.relative[e[s].type])c=[be(we(c),t)];else{if((t=b.filter[e[s].type].apply(null,e[s].matches))[k]){for(n=++s;n<r;n++)if(b.relative[e[n].type])break;return Ce(1<s&&we(c),1<s&&xe(e.slice(0,s-1).concat({value:" "===e[s-2].type?"*":""})).replace(B,"$1"),t,s<n&&Ee(e.slice(s,n)),n<r&&Ee(e=e.slice(n)),n<r&&xe(e))}c.push(t)}return we(c)}return me.prototype=b.filters=b.pseudos,b.setFilters=new me,h=se.tokenize=function(e,t){var n,r,i,o,a,s,u,l=x[e+" "];if(l)return t?0:l.slice(0);a=e,s=[],u=b.preFilter;while(a){for(o in n&&!(r=_.exec(a))||(r&&(a=a.slice(r[0].length)||a),s.push(i=[])),n=!1,(r=z.exec(a))&&(n=r.shift(),i.push({value:n,type:r[0].replace(B," ")}),a=a.slice(n.length)),b.filter)!(r=G[o].exec(a))||u[o]&&!(r=u[o](r))||(n=r.shift(),i.push({value:n,type:o,matches:r}),a=a.slice(n.length));if(!n)break}return t?a.length:a?se.error(e):x(e,s).slice(0)},f=se.compile=function(e,t){var n,v,y,m,x,r,i=[],o=[],a=N[e+" "];if(!a){t||(t=h(e)),n=t.length;while(n--)(a=Ee(t[n]))[k]?i.push(a):o.push(a);(a=N(e,(v=o,m=0<(y=i).length,x=0<v.length,r=function(e,t,n,r,i){var o,a,s,u=0,l="0",c=e&&[],f=[],p=w,d=e||x&&b.find.TAG("*",i),h=S+=null==p?1:Math.random()||.1,g=d.length;for(i&&(w=t===C||t||i);l!==g&&null!=(o=d[l]);l++){if(x&&o){a=0,t||o.ownerDocument===C||(T(o),n=!E);while(s=v[a++])if(s(o,t||C,n)){r.push(o);break}i&&(S=h)}m&&((o=!s&&o)&&u--,e&&c.push(o))}if(u+=l,m&&l!==u){a=0;while(s=y[a++])s(c,f,t,n);if(e){if(0<u)while(l--)c[l]||f[l]||(f[l]=q.call(r));f=Te(f)}H.apply(r,f),i&&!e&&0<f.length&&1<u+y.length&&se.uniqueSort(r)}return i&&(S=h,w=p),c},m?le(r):r))).selector=e}return a},g=se.select=function(e,t,n,r){var i,o,a,s,u,l="function"==typeof e&&e,c=!r&&h(e=l.selector||e);if(n=n||[],1===c.length){if(2<(o=c[0]=c[0].slice(0)).length&&"ID"===(a=o[0]).type&&9===t.nodeType&&E&&b.relative[o[1].type]){if(!(t=(b.find.ID(a.matches[0].replace(te,ne),t)||[])[0]))return n;l&&(t=t.parentNode),e=e.slice(o.shift().value.length)}i=G.needsContext.test(e)?0:o.length;while(i--){if(a=o[i],b.relative[s=a.type])break;if((u=b.find[s])&&(r=u(a.matches[0].replace(te,ne),ee.test(o[0].type)&&ye(t.parentNode)||t))){if(o.splice(i,1),!(e=r.length&&xe(o)))return H.apply(n,r),n;break}}}return(l||f(e,c))(r,t,!E,n,!t||ee.test(e)&&ye(t.parentNode)||t),n},d.sortStable=k.split("").sort(D).join("")===k,d.detectDuplicates=!!l,T(),d.sortDetached=ce(function(e){return 1&e.compareDocumentPosition(C.createElement("fieldset"))}),ce(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||fe("type|href|height|width",function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),d.attributes&&ce(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||fe("value",function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue}),ce(function(e){return null==e.getAttribute("disabled")})||fe(R,function(e,t,n){var r;if(!n)return!0===e[t]?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null}),se}(C);k.find=h,k.expr=h.selectors,k.expr[":"]=k.expr.pseudos,k.uniqueSort=k.unique=h.uniqueSort,k.text=h.getText,k.isXMLDoc=h.isXML,k.contains=h.contains,k.escapeSelector=h.escape;var T=function(e,t,n){var r=[],i=void 0!==n;while((e=e[t])&&9!==e.nodeType)if(1===e.nodeType){if(i&&k(e).is(n))break;r.push(e)}return r},S=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},N=k.expr.match.needsContext;function A(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var D=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function j(e,n,r){return m(n)?k.grep(e,function(e,t){return!!n.call(e,t,e)!==r}):n.nodeType?k.grep(e,function(e){return e===n!==r}):"string"!=typeof n?k.grep(e,function(e){return-1<i.call(n,e)!==r}):k.filter(n,e,r)}k.filter=function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?k.find.matchesSelector(r,e)?[r]:[]:k.find.matches(e,k.grep(t,function(e){return 1===e.nodeType}))},k.fn.extend({find:function(e){var t,n,r=this.length,i=this;if("string"!=typeof e)return this.pushStack(k(e).filter(function(){for(t=0;t<r;t++)if(k.contains(i[t],this))return!0}));for(n=this.pushStack([]),t=0;t<r;t++)k.find(e,i[t],n);return 1<r?k.uniqueSort(n):n},filter:function(e){return this.pushStack(j(this,e||[],!1))},not:function(e){return this.pushStack(j(this,e||[],!0))},is:function(e){return!!j(this,"string"==typeof e&&N.test(e)?k(e):e||[],!1).length}});var q,L=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(k.fn.init=function(e,t,n){var r,i;if(!e)return this;if(n=n||q,"string"==typeof e){if(!(r="<"===e[0]&&">"===e[e.length-1]&&3<=e.length?[null,e,null]:L.exec(e))||!r[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(r[1]){if(t=t instanceof k?t[0]:t,k.merge(this,k.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:E,!0)),D.test(r[1])&&k.isPlainObject(t))for(r in t)m(this[r])?this[r](t[r]):this.attr(r,t[r]);return this}return(i=E.getElementById(r[2]))&&(this[0]=i,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):m(e)?void 0!==n.ready?n.ready(e):e(k):k.makeArray(e,this)}).prototype=k.fn,q=k(E);var H=/^(?:parents|prev(?:Until|All))/,O={children:!0,contents:!0,next:!0,prev:!0};function P(e,t){while((e=e[t])&&1!==e.nodeType);return e}k.fn.extend({has:function(e){var t=k(e,this),n=t.length;return this.filter(function(){for(var e=0;e<n;e++)if(k.contains(this,t[e]))return!0})},closest:function(e,t){var n,r=0,i=this.length,o=[],a="string"!=typeof e&&k(e);if(!N.test(e))for(;r<i;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(a?-1<a.index(n):1===n.nodeType&&k.find.matchesSelector(n,e))){o.push(n);break}return this.pushStack(1<o.length?k.uniqueSort(o):o)},index:function(e){return e?"string"==typeof e?i.call(k(e),this[0]):i.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(k.uniqueSort(k.merge(this.get(),k(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),k.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return T(e,"parentNode")},parentsUntil:function(e,t,n){return T(e,"parentNode",n)},next:function(e){return P(e,"nextSibling")},prev:function(e){return P(e,"previousSibling")},nextAll:function(e){return T(e,"nextSibling")},prevAll:function(e){return T(e,"previousSibling")},nextUntil:function(e,t,n){return T(e,"nextSibling",n)},prevUntil:function(e,t,n){return T(e,"previousSibling",n)},siblings:function(e){return S((e.parentNode||{}).firstChild,e)},children:function(e){return S(e.firstChild)},contents:function(e){return"undefined"!=typeof e.contentDocument?e.contentDocument:(A(e,"template")&&(e=e.content||e),k.merge([],e.childNodes))}},function(r,i){k.fn[r]=function(e,t){var n=k.map(this,i,e);return"Until"!==r.slice(-5)&&(t=e),t&&"string"==typeof t&&(n=k.filter(t,n)),1<this.length&&(O[r]||k.uniqueSort(n),H.test(r)&&n.reverse()),this.pushStack(n)}});var R=/[^\x20\t\r\n\f]+/g;function M(e){return e}function I(e){throw e}function W(e,t,n,r){var i;try{e&&m(i=e.promise)?i.call(e).done(t).fail(n):e&&m(i=e.then)?i.call(e,t,n):t.apply(void 0,[e].slice(r))}catch(e){n.apply(void 0,[e])}}k.Callbacks=function(r){var e,n;r="string"==typeof r?(e=r,n={},k.each(e.match(R)||[],function(e,t){n[t]=!0}),n):k.extend({},r);var i,t,o,a,s=[],u=[],l=-1,c=function(){for(a=a||r.once,o=i=!0;u.length;l=-1){t=u.shift();while(++l<s.length)!1===s[l].apply(t[0],t[1])&&r.stopOnFalse&&(l=s.length,t=!1)}r.memory||(t=!1),i=!1,a&&(s=t?[]:"")},f={add:function(){return s&&(t&&!i&&(l=s.length-1,u.push(t)),function n(e){k.each(e,function(e,t){m(t)?r.unique&&f.has(t)||s.push(t):t&&t.length&&"string"!==w(t)&&n(t)})}(arguments),t&&!i&&c()),this},remove:function(){return k.each(arguments,function(e,t){var n;while(-1<(n=k.inArray(t,s,n)))s.splice(n,1),n<=l&&l--}),this},has:function(e){return e?-1<k.inArray(e,s):0<s.length},empty:function(){return s&&(s=[]),this},disable:function(){return a=u=[],s=t="",this},disabled:function(){return!s},lock:function(){return a=u=[],t||i||(s=t=""),this},locked:function(){return!!a},fireWith:function(e,t){return a||(t=[e,(t=t||[]).slice?t.slice():t],u.push(t),i||c()),this},fire:function(){return f.fireWith(this,arguments),this},fired:function(){return!!o}};return f},k.extend({Deferred:function(e){var o=[["notify","progress",k.Callbacks("memory"),k.Callbacks("memory"),2],["resolve","done",k.Callbacks("once memory"),k.Callbacks("once memory"),0,"resolved"],["reject","fail",k.Callbacks("once memory"),k.Callbacks("once memory"),1,"rejected"]],i="pending",a={state:function(){return i},always:function(){return s.done(arguments).fail(arguments),this},"catch":function(e){return a.then(null,e)},pipe:function(){var i=arguments;return k.Deferred(function(r){k.each(o,function(e,t){var n=m(i[t[4]])&&i[t[4]];s[t[1]](function(){var e=n&&n.apply(this,arguments);e&&m(e.promise)?e.promise().progress(r.notify).done(r.resolve).fail(r.reject):r[t[0]+"With"](this,n?[e]:arguments)})}),i=null}).promise()},then:function(t,n,r){var u=0;function l(i,o,a,s){return function(){var n=this,r=arguments,e=function(){var e,t;if(!(i<u)){if((e=a.apply(n,r))===o.promise())throw new TypeError("Thenable self-resolution");t=e&&("object"==typeof e||"function"==typeof e)&&e.then,m(t)?s?t.call(e,l(u,o,M,s),l(u,o,I,s)):(u++,t.call(e,l(u,o,M,s),l(u,o,I,s),l(u,o,M,o.notifyWith))):(a!==M&&(n=void 0,r=[e]),(s||o.resolveWith)(n,r))}},t=s?e:function(){try{e()}catch(e){k.Deferred.exceptionHook&&k.Deferred.exceptionHook(e,t.stackTrace),u<=i+1&&(a!==I&&(n=void 0,r=[e]),o.rejectWith(n,r))}};i?t():(k.Deferred.getStackHook&&(t.stackTrace=k.Deferred.getStackHook()),C.setTimeout(t))}}return k.Deferred(function(e){o[0][3].add(l(0,e,m(r)?r:M,e.notifyWith)),o[1][3].add(l(0,e,m(t)?t:M)),o[2][3].add(l(0,e,m(n)?n:I))}).promise()},promise:function(e){return null!=e?k.extend(e,a):a}},s={};return k.each(o,function(e,t){var n=t[2],r=t[5];a[t[1]]=n.add,r&&n.add(function(){i=r},o[3-e][2].disable,o[3-e][3].disable,o[0][2].lock,o[0][3].lock),n.add(t[3].fire),s[t[0]]=function(){return s[t[0]+"With"](this===s?void 0:this,arguments),this},s[t[0]+"With"]=n.fireWith}),a.promise(s),e&&e.call(s,s),s},when:function(e){var n=arguments.length,t=n,r=Array(t),i=s.call(arguments),o=k.Deferred(),a=function(t){return function(e){r[t]=this,i[t]=1<arguments.length?s.call(arguments):e,--n||o.resolveWith(r,i)}};if(n<=1&&(W(e,o.done(a(t)).resolve,o.reject,!n),"pending"===o.state()||m(i[t]&&i[t].then)))return o.then();while(t--)W(i[t],a(t),o.reject);return o.promise()}});var $=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;k.Deferred.exceptionHook=function(e,t){C.console&&C.console.warn&&e&&$.test(e.name)&&C.console.warn("jQuery.Deferred exception: "+e.message,e.stack,t)},k.readyException=function(e){C.setTimeout(function(){throw e})};var F=k.Deferred();function B(){E.removeEventListener("DOMContentLoaded",B),C.removeEventListener("load",B),k.ready()}k.fn.ready=function(e){return F.then(e)["catch"](function(e){k.readyException(e)}),this},k.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--k.readyWait:k.isReady)||(k.isReady=!0)!==e&&0<--k.readyWait||F.resolveWith(E,[k])}}),k.ready.then=F.then,"complete"===E.readyState||"loading"!==E.readyState&&!E.documentElement.doScroll?C.setTimeout(k.ready):(E.addEventListener("DOMContentLoaded",B),C.addEventListener("load",B));var _=function(e,t,n,r,i,o,a){var s=0,u=e.length,l=null==n;if("object"===w(n))for(s in i=!0,n)_(e,t,s,n[s],!0,o,a);else if(void 0!==r&&(i=!0,m(r)||(a=!0),l&&(a?(t.call(e,r),t=null):(l=t,t=function(e,t,n){return l.call(k(e),n)})),t))for(;s<u;s++)t(e[s],n,a?r:r.call(e[s],s,t(e[s],n)));return i?e:l?t.call(e):u?t(e[0],n):o},z=/^-ms-/,U=/-([a-z])/g;function X(e,t){return t.toUpperCase()}function V(e){return e.replace(z,"ms-").replace(U,X)}var G=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function Y(){this.expando=k.expando+Y.uid++}Y.uid=1,Y.prototype={cache:function(e){var t=e[this.expando];return t||(t={},G(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var r,i=this.cache(e);if("string"==typeof t)i[V(t)]=n;else for(r in t)i[V(r)]=t[r];return i},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][V(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,r=e[this.expando];if(void 0!==r){if(void 0!==t){n=(t=Array.isArray(t)?t.map(V):(t=V(t))in r?[t]:t.match(R)||[]).length;while(n--)delete r[t[n]]}(void 0===t||k.isEmptyObject(r))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!k.isEmptyObject(t)}};var Q=new Y,J=new Y,K=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,Z=/[A-Z]/g;function ee(e,t,n){var r,i;if(void 0===n&&1===e.nodeType)if(r="data-"+t.replace(Z,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(r))){try{n="true"===(i=n)||"false"!==i&&("null"===i?null:i===+i+""?+i:K.test(i)?JSON.parse(i):i)}catch(e){}J.set(e,t,n)}else n=void 0;return n}k.extend({hasData:function(e){return J.hasData(e)||Q.hasData(e)},data:function(e,t,n){return J.access(e,t,n)},removeData:function(e,t){J.remove(e,t)},_data:function(e,t,n){return Q.access(e,t,n)},_removeData:function(e,t){Q.remove(e,t)}}),k.fn.extend({data:function(n,e){var t,r,i,o=this[0],a=o&&o.attributes;if(void 0===n){if(this.length&&(i=J.get(o),1===o.nodeType&&!Q.get(o,"hasDataAttrs"))){t=a.length;while(t--)a[t]&&0===(r=a[t].name).indexOf("data-")&&(r=V(r.slice(5)),ee(o,r,i[r]));Q.set(o,"hasDataAttrs",!0)}return i}return"object"==typeof n?this.each(function(){J.set(this,n)}):_(this,function(e){var t;if(o&&void 0===e)return void 0!==(t=J.get(o,n))?t:void 0!==(t=ee(o,n))?t:void 0;this.each(function(){J.set(this,n,e)})},null,e,1<arguments.length,null,!0)},removeData:function(e){return this.each(function(){J.remove(this,e)})}}),k.extend({queue:function(e,t,n){var r;if(e)return t=(t||"fx")+"queue",r=Q.get(e,t),n&&(!r||Array.isArray(n)?r=Q.access(e,t,k.makeArray(n)):r.push(n)),r||[]},dequeue:function(e,t){t=t||"fx";var n=k.queue(e,t),r=n.length,i=n.shift(),o=k._queueHooks(e,t);"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,function(){k.dequeue(e,t)},o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return Q.get(e,n)||Q.access(e,n,{empty:k.Callbacks("once memory").add(function(){Q.remove(e,[t+"queue",n])})})}}),k.fn.extend({queue:function(t,n){var e=2;return"string"!=typeof t&&(n=t,t="fx",e--),arguments.length<e?k.queue(this[0],t):void 0===n?this:this.each(function(){var e=k.queue(this,t,n);k._queueHooks(this,t),"fx"===t&&"inprogress"!==e[0]&&k.dequeue(this,t)})},dequeue:function(e){return this.each(function(){k.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=k.Deferred(),o=this,a=this.length,s=function(){--r||i.resolveWith(o,[o])};"string"!=typeof e&&(t=e,e=void 0),e=e||"fx";while(a--)(n=Q.get(o[a],e+"queueHooks"))&&n.empty&&(r++,n.empty.add(s));return s(),i.promise(t)}});var te=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,ne=new RegExp("^(?:([+-])=|)("+te+")([a-z%]*)$","i"),re=["Top","Right","Bottom","Left"],ie=E.documentElement,oe=function(e){return k.contains(e.ownerDocument,e)},ae={composed:!0};ie.getRootNode&&(oe=function(e){return k.contains(e.ownerDocument,e)||e.getRootNode(ae)===e.ownerDocument});var se=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&oe(e)&&"none"===k.css(e,"display")},ue=function(e,t,n,r){var i,o,a={};for(o in t)a[o]=e.style[o],e.style[o]=t[o];for(o in i=n.apply(e,r||[]),t)e.style[o]=a[o];return i};function le(e,t,n,r){var i,o,a=20,s=r?function(){return r.cur()}:function(){return k.css(e,t,"")},u=s(),l=n&&n[3]||(k.cssNumber[t]?"":"px"),c=e.nodeType&&(k.cssNumber[t]||"px"!==l&&+u)&&ne.exec(k.css(e,t));if(c&&c[3]!==l){u/=2,l=l||c[3],c=+u||1;while(a--)k.style(e,t,c+l),(1-o)*(1-(o=s()/u||.5))<=0&&(a=0),c/=o;c*=2,k.style(e,t,c+l),n=n||[]}return n&&(c=+c||+u||0,i=n[1]?c+(n[1]+1)*n[2]:+n[2],r&&(r.unit=l,r.start=c,r.end=i)),i}var ce={};function fe(e,t){for(var n,r,i,o,a,s,u,l=[],c=0,f=e.length;c<f;c++)(r=e[c]).style&&(n=r.style.display,t?("none"===n&&(l[c]=Q.get(r,"display")||null,l[c]||(r.style.display="")),""===r.style.display&&se(r)&&(l[c]=(u=a=o=void 0,a=(i=r).ownerDocument,s=i.nodeName,(u=ce[s])||(o=a.body.appendChild(a.createElement(s)),u=k.css(o,"display"),o.parentNode.removeChild(o),"none"===u&&(u="block"),ce[s]=u)))):"none"!==n&&(l[c]="none",Q.set(r,"display",n)));for(c=0;c<f;c++)null!=l[c]&&(e[c].style.display=l[c]);return e}k.fn.extend({show:function(){return fe(this,!0)},hide:function(){return fe(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){se(this)?k(this).show():k(this).hide()})}});var pe=/^(?:checkbox|radio)$/i,de=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i,he=/^$|^module$|\/(?:java|ecma)script/i,ge={option:[1,"<select multiple='multiple'>","</select>"],thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ve(e,t){var n;return n="undefined"!=typeof e.getElementsByTagName?e.getElementsByTagName(t||"*"):"undefined"!=typeof e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&A(e,t)?k.merge([e],n):n}function ye(e,t){for(var n=0,r=e.length;n<r;n++)Q.set(e[n],"globalEval",!t||Q.get(t[n],"globalEval"))}ge.optgroup=ge.option,ge.tbody=ge.tfoot=ge.colgroup=ge.caption=ge.thead,ge.th=ge.td;var me,xe,be=/<|&#?\w+;/;function we(e,t,n,r,i){for(var o,a,s,u,l,c,f=t.createDocumentFragment(),p=[],d=0,h=e.length;d<h;d++)if((o=e[d])||0===o)if("object"===w(o))k.merge(p,o.nodeType?[o]:o);else if(be.test(o)){a=a||f.appendChild(t.createElement("div")),s=(de.exec(o)||["",""])[1].toLowerCase(),u=ge[s]||ge._default,a.innerHTML=u[1]+k.htmlPrefilter(o)+u[2],c=u[0];while(c--)a=a.lastChild;k.merge(p,a.childNodes),(a=f.firstChild).textContent=""}else p.push(t.createTextNode(o));f.textContent="",d=0;while(o=p[d++])if(r&&-1<k.inArray(o,r))i&&i.push(o);else if(l=oe(o),a=ve(f.appendChild(o),"script"),l&&ye(a),n){c=0;while(o=a[c++])he.test(o.type||"")&&n.push(o)}return f}me=E.createDocumentFragment().appendChild(E.createElement("div")),(xe=E.createElement("input")).setAttribute("type","radio"),xe.setAttribute("checked","checked"),xe.setAttribute("name","t"),me.appendChild(xe),y.checkClone=me.cloneNode(!0).cloneNode(!0).lastChild.checked,me.innerHTML="<textarea>x</textarea>",y.noCloneChecked=!!me.cloneNode(!0).lastChild.defaultValue;var Te=/^key/,Ce=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,Ee=/^([^.]*)(?:\.(.+)|)/;function ke(){return!0}function Se(){return!1}function Ne(e,t){return e===function(){try{return E.activeElement}catch(e){}}()==("focus"===t)}function Ae(e,t,n,r,i,o){var a,s;if("object"==typeof t){for(s in"string"!=typeof n&&(r=r||n,n=void 0),t)Ae(e,s,n,r,t[s],o);return e}if(null==r&&null==i?(i=n,r=n=void 0):null==i&&("string"==typeof n?(i=r,r=void 0):(i=r,r=n,n=void 0)),!1===i)i=Se;else if(!i)return e;return 1===o&&(a=i,(i=function(e){return k().off(e),a.apply(this,arguments)}).guid=a.guid||(a.guid=k.guid++)),e.each(function(){k.event.add(this,t,i,r,n)})}function De(e,i,o){o?(Q.set(e,i,!1),k.event.add(e,i,{namespace:!1,handler:function(e){var t,n,r=Q.get(this,i);if(1&e.isTrigger&&this[i]){if(r.length)(k.event.special[i]||{}).delegateType&&e.stopPropagation();else if(r=s.call(arguments),Q.set(this,i,r),t=o(this,i),this[i](),r!==(n=Q.get(this,i))||t?Q.set(this,i,!1):n={},r!==n)return e.stopImmediatePropagation(),e.preventDefault(),n.value}else r.length&&(Q.set(this,i,{value:k.event.trigger(k.extend(r[0],k.Event.prototype),r.slice(1),this)}),e.stopImmediatePropagation())}})):void 0===Q.get(e,i)&&k.event.add(e,i,ke)}k.event={global:{},add:function(t,e,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Q.get(t);if(v){n.handler&&(n=(o=n).handler,i=o.selector),i&&k.find.matchesSelector(ie,i),n.guid||(n.guid=k.guid++),(u=v.events)||(u=v.events={}),(a=v.handle)||(a=v.handle=function(e){return"undefined"!=typeof k&&k.event.triggered!==e.type?k.event.dispatch.apply(t,arguments):void 0}),l=(e=(e||"").match(R)||[""]).length;while(l--)d=g=(s=Ee.exec(e[l])||[])[1],h=(s[2]||"").split(".").sort(),d&&(f=k.event.special[d]||{},d=(i?f.delegateType:f.bindType)||d,f=k.event.special[d]||{},c=k.extend({type:d,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&k.expr.match.needsContext.test(i),namespace:h.join(".")},o),(p=u[d])||((p=u[d]=[]).delegateCount=0,f.setup&&!1!==f.setup.call(t,r,h,a)||t.addEventListener&&t.addEventListener(d,a)),f.add&&(f.add.call(t,c),c.handler.guid||(c.handler.guid=n.guid)),i?p.splice(p.delegateCount++,0,c):p.push(c),k.event.global[d]=!0)}},remove:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Q.hasData(e)&&Q.get(e);if(v&&(u=v.events)){l=(t=(t||"").match(R)||[""]).length;while(l--)if(d=g=(s=Ee.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d){f=k.event.special[d]||{},p=u[d=(r?f.delegateType:f.bindType)||d]||[],s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),a=o=p.length;while(o--)c=p[o],!i&&g!==c.origType||n&&n.guid!==c.guid||s&&!s.test(c.namespace)||r&&r!==c.selector&&("**"!==r||!c.selector)||(p.splice(o,1),c.selector&&p.delegateCount--,f.remove&&f.remove.call(e,c));a&&!p.length&&(f.teardown&&!1!==f.teardown.call(e,h,v.handle)||k.removeEvent(e,d,v.handle),delete u[d])}else for(d in u)k.event.remove(e,d+t[l],n,r,!0);k.isEmptyObject(u)&&Q.remove(e,"handle events")}},dispatch:function(e){var t,n,r,i,o,a,s=k.event.fix(e),u=new Array(arguments.length),l=(Q.get(this,"events")||{})[s.type]||[],c=k.event.special[s.type]||{};for(u[0]=s,t=1;t<arguments.length;t++)u[t]=arguments[t];if(s.delegateTarget=this,!c.preDispatch||!1!==c.preDispatch.call(this,s)){a=k.event.handlers.call(this,s,l),t=0;while((i=a[t++])&&!s.isPropagationStopped()){s.currentTarget=i.elem,n=0;while((o=i.handlers[n++])&&!s.isImmediatePropagationStopped())s.rnamespace&&!1!==o.namespace&&!s.rnamespace.test(o.namespace)||(s.handleObj=o,s.data=o.data,void 0!==(r=((k.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,u))&&!1===(s.result=r)&&(s.preventDefault(),s.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,s),s.result}},handlers:function(e,t){var n,r,i,o,a,s=[],u=t.delegateCount,l=e.target;if(u&&l.nodeType&&!("click"===e.type&&1<=e.button))for(;l!==this;l=l.parentNode||this)if(1===l.nodeType&&("click"!==e.type||!0!==l.disabled)){for(o=[],a={},n=0;n<u;n++)void 0===a[i=(r=t[n]).selector+" "]&&(a[i]=r.needsContext?-1<k(i,this).index(l):k.find(i,this,null,[l]).length),a[i]&&o.push(r);o.length&&s.push({elem:l,handlers:o})}return l=this,u<t.length&&s.push({elem:l,handlers:t.slice(u)}),s},addProp:function(t,e){Object.defineProperty(k.Event.prototype,t,{enumerable:!0,configurable:!0,get:m(e)?function(){if(this.originalEvent)return e(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[t]},set:function(e){Object.defineProperty(this,t,{enumerable:!0,configurable:!0,writable:!0,value:e})}})},fix:function(e){return e[k.expando]?e:new k.Event(e)},special:{load:{noBubble:!0},click:{setup:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&De(t,"click",ke),!1},trigger:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&De(t,"click"),!0},_default:function(e){var t=e.target;return pe.test(t.type)&&t.click&&A(t,"input")&&Q.get(t,"click")||A(t,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},k.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},k.Event=function(e,t){if(!(this instanceof k.Event))return new k.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?ke:Se,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&k.extend(this,t),this.timeStamp=e&&e.timeStamp||Date.now(),this[k.expando]=!0},k.Event.prototype={constructor:k.Event,isDefaultPrevented:Se,isPropagationStopped:Se,isImmediatePropagationStopped:Se,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=ke,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=ke,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=ke,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},k.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,"char":!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(e){var t=e.button;return null==e.which&&Te.test(e.type)?null!=e.charCode?e.charCode:e.keyCode:!e.which&&void 0!==t&&Ce.test(e.type)?1&t?1:2&t?3:4&t?2:0:e.which}},k.event.addProp),k.each({focus:"focusin",blur:"focusout"},function(e,t){k.event.special[e]={setup:function(){return De(this,e,Ne),!1},trigger:function(){return De(this,e),!0},delegateType:t}}),k.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,i){k.event.special[e]={delegateType:i,bindType:i,handle:function(e){var t,n=e.relatedTarget,r=e.handleObj;return n&&(n===this||k.contains(this,n))||(e.type=r.origType,t=r.handler.apply(this,arguments),e.type=i),t}}}),k.fn.extend({on:function(e,t,n,r){return Ae(this,e,t,n,r)},one:function(e,t,n,r){return Ae(this,e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj)return r=e.handleObj,k(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler),this;if("object"==typeof e){for(i in e)this.off(i,t,e[i]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=Se),this.each(function(){k.event.remove(this,e,n,t)})}});var je=/<(?!area|br|col|embed|hr|img|input|link|meta|param)(([a-z][^\/\0>\x20\t\r\n\f]*)[^>]*)\/>/gi,qe=/<script|<style|<link/i,Le=/checked\s*(?:[^=]|=\s*.checked.)/i,He=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function Oe(e,t){return A(e,"table")&&A(11!==t.nodeType?t:t.firstChild,"tr")&&k(e).children("tbody")[0]||e}function Pe(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function Re(e){return"true/"===(e.type||"").slice(0,5)?e.type=e.type.slice(5):e.removeAttribute("type"),e}function Me(e,t){var n,r,i,o,a,s,u,l;if(1===t.nodeType){if(Q.hasData(e)&&(o=Q.access(e),a=Q.set(t,o),l=o.events))for(i in delete a.handle,a.events={},l)for(n=0,r=l[i].length;n<r;n++)k.event.add(t,i,l[i][n]);J.hasData(e)&&(s=J.access(e),u=k.extend({},s),J.set(t,u))}}function Ie(n,r,i,o){r=g.apply([],r);var e,t,a,s,u,l,c=0,f=n.length,p=f-1,d=r[0],h=m(d);if(h||1<f&&"string"==typeof d&&!y.checkClone&&Le.test(d))return n.each(function(e){var t=n.eq(e);h&&(r[0]=d.call(this,e,t.html())),Ie(t,r,i,o)});if(f&&(t=(e=we(r,n[0].ownerDocument,!1,n,o)).firstChild,1===e.childNodes.length&&(e=t),t||o)){for(s=(a=k.map(ve(e,"script"),Pe)).length;c<f;c++)u=e,c!==p&&(u=k.clone(u,!0,!0),s&&k.merge(a,ve(u,"script"))),i.call(n[c],u,c);if(s)for(l=a[a.length-1].ownerDocument,k.map(a,Re),c=0;c<s;c++)u=a[c],he.test(u.type||"")&&!Q.access(u,"globalEval")&&k.contains(l,u)&&(u.src&&"module"!==(u.type||"").toLowerCase()?k._evalUrl&&!u.noModule&&k._evalUrl(u.src,{nonce:u.nonce||u.getAttribute("nonce")}):b(u.textContent.replace(He,""),u,l))}return n}function We(e,t,n){for(var r,i=t?k.filter(t,e):e,o=0;null!=(r=i[o]);o++)n||1!==r.nodeType||k.cleanData(ve(r)),r.parentNode&&(n&&oe(r)&&ye(ve(r,"script")),r.parentNode.removeChild(r));return e}k.extend({htmlPrefilter:function(e){return e.replace(je,"<$1></$2>")},clone:function(e,t,n){var r,i,o,a,s,u,l,c=e.cloneNode(!0),f=oe(e);if(!(y.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||k.isXMLDoc(e)))for(a=ve(c),r=0,i=(o=ve(e)).length;r<i;r++)s=o[r],u=a[r],void 0,"input"===(l=u.nodeName.toLowerCase())&&pe.test(s.type)?u.checked=s.checked:"input"!==l&&"textarea"!==l||(u.defaultValue=s.defaultValue);if(t)if(n)for(o=o||ve(e),a=a||ve(c),r=0,i=o.length;r<i;r++)Me(o[r],a[r]);else Me(e,c);return 0<(a=ve(c,"script")).length&&ye(a,!f&&ve(e,"script")),c},cleanData:function(e){for(var t,n,r,i=k.event.special,o=0;void 0!==(n=e[o]);o++)if(G(n)){if(t=n[Q.expando]){if(t.events)for(r in t.events)i[r]?k.event.remove(n,r):k.removeEvent(n,r,t.handle);n[Q.expando]=void 0}n[J.expando]&&(n[J.expando]=void 0)}}}),k.fn.extend({detach:function(e){return We(this,e,!0)},remove:function(e){return We(this,e)},text:function(e){return _(this,function(e){return void 0===e?k.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)})},null,e,arguments.length)},append:function(){return Ie(this,arguments,function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||Oe(this,e).appendChild(e)})},prepend:function(){return Ie(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=Oe(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return Ie(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return Ie(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(k.cleanData(ve(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map(function(){return k.clone(this,e,t)})},html:function(e){return _(this,function(e){var t=this[0]||{},n=0,r=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!qe.test(e)&&!ge[(de.exec(e)||["",""])[1].toLowerCase()]){e=k.htmlPrefilter(e);try{for(;n<r;n++)1===(t=this[n]||{}).nodeType&&(k.cleanData(ve(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var n=[];return Ie(this,arguments,function(e){var t=this.parentNode;k.inArray(this,n)<0&&(k.cleanData(ve(this)),t&&t.replaceChild(e,this))},n)}}),k.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,a){k.fn[e]=function(e){for(var t,n=[],r=k(e),i=r.length-1,o=0;o<=i;o++)t=o===i?this:this.clone(!0),k(r[o])[a](t),u.apply(n,t.get());return this.pushStack(n)}});var $e=new RegExp("^("+te+")(?!px)[a-z%]+$","i"),Fe=function(e){var t=e.ownerDocument.defaultView;return t&&t.opener||(t=C),t.getComputedStyle(e)},Be=new RegExp(re.join("|"),"i");function _e(e,t,n){var r,i,o,a,s=e.style;return(n=n||Fe(e))&&(""!==(a=n.getPropertyValue(t)||n[t])||oe(e)||(a=k.style(e,t)),!y.pixelBoxStyles()&&$e.test(a)&&Be.test(t)&&(r=s.width,i=s.minWidth,o=s.maxWidth,s.minWidth=s.maxWidth=s.width=a,a=n.width,s.width=r,s.minWidth=i,s.maxWidth=o)),void 0!==a?a+"":a}function ze(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function e(){if(u){s.style.cssText="position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0",u.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%",ie.appendChild(s).appendChild(u);var e=C.getComputedStyle(u);n="1%"!==e.top,a=12===t(e.marginLeft),u.style.right="60%",o=36===t(e.right),r=36===t(e.width),u.style.position="absolute",i=12===t(u.offsetWidth/3),ie.removeChild(s),u=null}}function t(e){return Math.round(parseFloat(e))}var n,r,i,o,a,s=E.createElement("div"),u=E.createElement("div");u.style&&(u.style.backgroundClip="content-box",u.cloneNode(!0).style.backgroundClip="",y.clearCloneStyle="content-box"===u.style.backgroundClip,k.extend(y,{boxSizingReliable:function(){return e(),r},pixelBoxStyles:function(){return e(),o},pixelPosition:function(){return e(),n},reliableMarginLeft:function(){return e(),a},scrollboxSize:function(){return e(),i}}))}();var Ue=["Webkit","Moz","ms"],Xe=E.createElement("div").style,Ve={};function Ge(e){var t=k.cssProps[e]||Ve[e];return t||(e in Xe?e:Ve[e]=function(e){var t=e[0].toUpperCase()+e.slice(1),n=Ue.length;while(n--)if((e=Ue[n]+t)in Xe)return e}(e)||e)}var Ye=/^(none|table(?!-c[ea]).+)/,Qe=/^--/,Je={position:"absolute",visibility:"hidden",display:"block"},Ke={letterSpacing:"0",fontWeight:"400"};function Ze(e,t,n){var r=ne.exec(t);return r?Math.max(0,r[2]-(n||0))+(r[3]||"px"):t}function et(e,t,n,r,i,o){var a="width"===t?1:0,s=0,u=0;if(n===(r?"border":"content"))return 0;for(;a<4;a+=2)"margin"===n&&(u+=k.css(e,n+re[a],!0,i)),r?("content"===n&&(u-=k.css(e,"padding"+re[a],!0,i)),"margin"!==n&&(u-=k.css(e,"border"+re[a]+"Width",!0,i))):(u+=k.css(e,"padding"+re[a],!0,i),"padding"!==n?u+=k.css(e,"border"+re[a]+"Width",!0,i):s+=k.css(e,"border"+re[a]+"Width",!0,i));return!r&&0<=o&&(u+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-o-u-s-.5))||0),u}function tt(e,t,n){var r=Fe(e),i=(!y.boxSizingReliable()||n)&&"border-box"===k.css(e,"boxSizing",!1,r),o=i,a=_e(e,t,r),s="offset"+t[0].toUpperCase()+t.slice(1);if($e.test(a)){if(!n)return a;a="auto"}return(!y.boxSizingReliable()&&i||"auto"===a||!parseFloat(a)&&"inline"===k.css(e,"display",!1,r))&&e.getClientRects().length&&(i="border-box"===k.css(e,"boxSizing",!1,r),(o=s in e)&&(a=e[s])),(a=parseFloat(a)||0)+et(e,t,n||(i?"border":"content"),o,r,a)+"px"}function nt(e,t,n,r,i){return new nt.prototype.init(e,t,n,r,i)}k.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=_e(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{},style:function(e,t,n,r){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var i,o,a,s=V(t),u=Qe.test(t),l=e.style;if(u||(t=Ge(s)),a=k.cssHooks[t]||k.cssHooks[s],void 0===n)return a&&"get"in a&&void 0!==(i=a.get(e,!1,r))?i:l[t];"string"===(o=typeof n)&&(i=ne.exec(n))&&i[1]&&(n=le(e,t,i),o="number"),null!=n&&n==n&&("number"!==o||u||(n+=i&&i[3]||(k.cssNumber[s]?"":"px")),y.clearCloneStyle||""!==n||0!==t.indexOf("background")||(l[t]="inherit"),a&&"set"in a&&void 0===(n=a.set(e,n,r))||(u?l.setProperty(t,n):l[t]=n))}},css:function(e,t,n,r){var i,o,a,s=V(t);return Qe.test(t)||(t=Ge(s)),(a=k.cssHooks[t]||k.cssHooks[s])&&"get"in a&&(i=a.get(e,!0,n)),void 0===i&&(i=_e(e,t,r)),"normal"===i&&t in Ke&&(i=Ke[t]),""===n||n?(o=parseFloat(i),!0===n||isFinite(o)?o||0:i):i}}),k.each(["height","width"],function(e,u){k.cssHooks[u]={get:function(e,t,n){if(t)return!Ye.test(k.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?tt(e,u,n):ue(e,Je,function(){return tt(e,u,n)})},set:function(e,t,n){var r,i=Fe(e),o=!y.scrollboxSize()&&"absolute"===i.position,a=(o||n)&&"border-box"===k.css(e,"boxSizing",!1,i),s=n?et(e,u,n,a,i):0;return a&&o&&(s-=Math.ceil(e["offset"+u[0].toUpperCase()+u.slice(1)]-parseFloat(i[u])-et(e,u,"border",!1,i)-.5)),s&&(r=ne.exec(t))&&"px"!==(r[3]||"px")&&(e.style[u]=t,t=k.css(e,u)),Ze(0,t,s)}}}),k.cssHooks.marginLeft=ze(y.reliableMarginLeft,function(e,t){if(t)return(parseFloat(_e(e,"marginLeft"))||e.getBoundingClientRect().left-ue(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}),k.each({margin:"",padding:"",border:"Width"},function(i,o){k.cssHooks[i+o]={expand:function(e){for(var t=0,n={},r="string"==typeof e?e.split(" "):[e];t<4;t++)n[i+re[t]+o]=r[t]||r[t-2]||r[0];return n}},"margin"!==i&&(k.cssHooks[i+o].set=Ze)}),k.fn.extend({css:function(e,t){return _(this,function(e,t,n){var r,i,o={},a=0;if(Array.isArray(t)){for(r=Fe(e),i=t.length;a<i;a++)o[t[a]]=k.css(e,t[a],!1,r);return o}return void 0!==n?k.style(e,t,n):k.css(e,t)},e,t,1<arguments.length)}}),((k.Tween=nt).prototype={constructor:nt,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||k.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(k.cssNumber[n]?"":"px")},cur:function(){var e=nt.propHooks[this.prop];return e&&e.get?e.get(this):nt.propHooks._default.get(this)},run:function(e){var t,n=nt.propHooks[this.prop];return this.options.duration?this.pos=t=k.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):nt.propHooks._default.set(this),this}}).init.prototype=nt.prototype,(nt.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=k.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){k.fx.step[e.prop]?k.fx.step[e.prop](e):1!==e.elem.nodeType||!k.cssHooks[e.prop]&&null==e.elem.style[Ge(e.prop)]?e.elem[e.prop]=e.now:k.style(e.elem,e.prop,e.now+e.unit)}}}).scrollTop=nt.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},k.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},k.fx=nt.prototype.init,k.fx.step={};var rt,it,ot,at,st=/^(?:toggle|show|hide)$/,ut=/queueHooks$/;function lt(){it&&(!1===E.hidden&&C.requestAnimationFrame?C.requestAnimationFrame(lt):C.setTimeout(lt,k.fx.interval),k.fx.tick())}function ct(){return C.setTimeout(function(){rt=void 0}),rt=Date.now()}function ft(e,t){var n,r=0,i={height:e};for(t=t?1:0;r<4;r+=2-t)i["margin"+(n=re[r])]=i["padding"+n]=e;return t&&(i.opacity=i.width=e),i}function pt(e,t,n){for(var r,i=(dt.tweeners[t]||[]).concat(dt.tweeners["*"]),o=0,a=i.length;o<a;o++)if(r=i[o].call(n,t,e))return r}function dt(o,e,t){var n,a,r=0,i=dt.prefilters.length,s=k.Deferred().always(function(){delete u.elem}),u=function(){if(a)return!1;for(var e=rt||ct(),t=Math.max(0,l.startTime+l.duration-e),n=1-(t/l.duration||0),r=0,i=l.tweens.length;r<i;r++)l.tweens[r].run(n);return s.notifyWith(o,[l,n,t]),n<1&&i?t:(i||s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l]),!1)},l=s.promise({elem:o,props:k.extend({},e),opts:k.extend(!0,{specialEasing:{},easing:k.easing._default},t),originalProperties:e,originalOptions:t,startTime:rt||ct(),duration:t.duration,tweens:[],createTween:function(e,t){var n=k.Tween(o,l.opts,e,t,l.opts.specialEasing[e]||l.opts.easing);return l.tweens.push(n),n},stop:function(e){var t=0,n=e?l.tweens.length:0;if(a)return this;for(a=!0;t<n;t++)l.tweens[t].run(1);return e?(s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l,e])):s.rejectWith(o,[l,e]),this}}),c=l.props;for(!function(e,t){var n,r,i,o,a;for(n in e)if(i=t[r=V(n)],o=e[n],Array.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),(a=k.cssHooks[r])&&"expand"in a)for(n in o=a.expand(o),delete e[r],o)n in e||(e[n]=o[n],t[n]=i);else t[r]=i}(c,l.opts.specialEasing);r<i;r++)if(n=dt.prefilters[r].call(l,o,c,l.opts))return m(n.stop)&&(k._queueHooks(l.elem,l.opts.queue).stop=n.stop.bind(n)),n;return k.map(c,pt,l),m(l.opts.start)&&l.opts.start.call(o,l),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always),k.fx.timer(k.extend(u,{elem:o,anim:l,queue:l.opts.queue})),l}k.Animation=k.extend(dt,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return le(n.elem,e,ne.exec(t),n),n}]},tweener:function(e,t){m(e)?(t=e,e=["*"]):e=e.match(R);for(var n,r=0,i=e.length;r<i;r++)n=e[r],dt.tweeners[n]=dt.tweeners[n]||[],dt.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var r,i,o,a,s,u,l,c,f="width"in t||"height"in t,p=this,d={},h=e.style,g=e.nodeType&&se(e),v=Q.get(e,"fxshow");for(r in n.queue||(null==(a=k._queueHooks(e,"fx")).unqueued&&(a.unqueued=0,s=a.empty.fire,a.empty.fire=function(){a.unqueued||s()}),a.unqueued++,p.always(function(){p.always(function(){a.unqueued--,k.queue(e,"fx").length||a.empty.fire()})})),t)if(i=t[r],st.test(i)){if(delete t[r],o=o||"toggle"===i,i===(g?"hide":"show")){if("show"!==i||!v||void 0===v[r])continue;g=!0}d[r]=v&&v[r]||k.style(e,r)}if((u=!k.isEmptyObject(t))||!k.isEmptyObject(d))for(r in f&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(l=v&&v.display)&&(l=Q.get(e,"display")),"none"===(c=k.css(e,"display"))&&(l?c=l:(fe([e],!0),l=e.style.display||l,c=k.css(e,"display"),fe([e]))),("inline"===c||"inline-block"===c&&null!=l)&&"none"===k.css(e,"float")&&(u||(p.done(function(){h.display=l}),null==l&&(c=h.display,l="none"===c?"":c)),h.display="inline-block")),n.overflow&&(h.overflow="hidden",p.always(function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]})),u=!1,d)u||(v?"hidden"in v&&(g=v.hidden):v=Q.access(e,"fxshow",{display:l}),o&&(v.hidden=!g),g&&fe([e],!0),p.done(function(){for(r in g||fe([e]),Q.remove(e,"fxshow"),d)k.style(e,r,d[r])})),u=pt(g?v[r]:0,r,p),r in v||(v[r]=u.start,g&&(u.end=u.start,u.start=0))}],prefilter:function(e,t){t?dt.prefilters.unshift(e):dt.prefilters.push(e)}}),k.speed=function(e,t,n){var r=e&&"object"==typeof e?k.extend({},e):{complete:n||!n&&t||m(e)&&e,duration:e,easing:n&&t||t&&!m(t)&&t};return k.fx.off?r.duration=0:"number"!=typeof r.duration&&(r.duration in k.fx.speeds?r.duration=k.fx.speeds[r.duration]:r.duration=k.fx.speeds._default),null!=r.queue&&!0!==r.queue||(r.queue="fx"),r.old=r.complete,r.complete=function(){m(r.old)&&r.old.call(this),r.queue&&k.dequeue(this,r.queue)},r},k.fn.extend({fadeTo:function(e,t,n,r){return this.filter(se).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(t,e,n,r){var i=k.isEmptyObject(t),o=k.speed(e,n,r),a=function(){var e=dt(this,k.extend({},t),o);(i||Q.get(this,"finish"))&&e.stop(!0)};return a.finish=a,i||!1===o.queue?this.each(a):this.queue(o.queue,a)},stop:function(i,e,o){var a=function(e){var t=e.stop;delete e.stop,t(o)};return"string"!=typeof i&&(o=e,e=i,i=void 0),e&&!1!==i&&this.queue(i||"fx",[]),this.each(function(){var e=!0,t=null!=i&&i+"queueHooks",n=k.timers,r=Q.get(this);if(t)r[t]&&r[t].stop&&a(r[t]);else for(t in r)r[t]&&r[t].stop&&ut.test(t)&&a(r[t]);for(t=n.length;t--;)n[t].elem!==this||null!=i&&n[t].queue!==i||(n[t].anim.stop(o),e=!1,n.splice(t,1));!e&&o||k.dequeue(this,i)})},finish:function(a){return!1!==a&&(a=a||"fx"),this.each(function(){var e,t=Q.get(this),n=t[a+"queue"],r=t[a+"queueHooks"],i=k.timers,o=n?n.length:0;for(t.finish=!0,k.queue(this,a,[]),r&&r.stop&&r.stop.call(this,!0),e=i.length;e--;)i[e].elem===this&&i[e].queue===a&&(i[e].anim.stop(!0),i.splice(e,1));for(e=0;e<o;e++)n[e]&&n[e].finish&&n[e].finish.call(this);delete t.finish})}}),k.each(["toggle","show","hide"],function(e,r){var i=k.fn[r];k.fn[r]=function(e,t,n){return null==e||"boolean"==typeof e?i.apply(this,arguments):this.animate(ft(r,!0),e,t,n)}}),k.each({slideDown:ft("show"),slideUp:ft("hide"),slideToggle:ft("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,r){k.fn[e]=function(e,t,n){return this.animate(r,e,t,n)}}),k.timers=[],k.fx.tick=function(){var e,t=0,n=k.timers;for(rt=Date.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||k.fx.stop(),rt=void 0},k.fx.timer=function(e){k.timers.push(e),k.fx.start()},k.fx.interval=13,k.fx.start=function(){it||(it=!0,lt())},k.fx.stop=function(){it=null},k.fx.speeds={slow:600,fast:200,_default:400},k.fn.delay=function(r,e){return r=k.fx&&k.fx.speeds[r]||r,e=e||"fx",this.queue(e,function(e,t){var n=C.setTimeout(e,r);t.stop=function(){C.clearTimeout(n)}})},ot=E.createElement("input"),at=E.createElement("select").appendChild(E.createElement("option")),ot.type="checkbox",y.checkOn=""!==ot.value,y.optSelected=at.selected,(ot=E.createElement("input")).value="t",ot.type="radio",y.radioValue="t"===ot.value;var ht,gt=k.expr.attrHandle;k.fn.extend({attr:function(e,t){return _(this,k.attr,e,t,1<arguments.length)},removeAttr:function(e){return this.each(function(){k.removeAttr(this,e)})}}),k.extend({attr:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return"undefined"==typeof e.getAttribute?k.prop(e,t,n):(1===o&&k.isXMLDoc(e)||(i=k.attrHooks[t.toLowerCase()]||(k.expr.match.bool.test(t)?ht:void 0)),void 0!==n?null===n?void k.removeAttr(e,t):i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:(e.setAttribute(t,n+""),n):i&&"get"in i&&null!==(r=i.get(e,t))?r:null==(r=k.find.attr(e,t))?void 0:r)},attrHooks:{type:{set:function(e,t){if(!y.radioValue&&"radio"===t&&A(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,r=0,i=t&&t.match(R);if(i&&1===e.nodeType)while(n=i[r++])e.removeAttribute(n)}}),ht={set:function(e,t,n){return!1===t?k.removeAttr(e,n):e.setAttribute(n,n),n}},k.each(k.expr.match.bool.source.match(/\w+/g),function(e,t){var a=gt[t]||k.find.attr;gt[t]=function(e,t,n){var r,i,o=t.toLowerCase();return n||(i=gt[o],gt[o]=r,r=null!=a(e,t,n)?o:null,gt[o]=i),r}});var vt=/^(?:input|select|textarea|button)$/i,yt=/^(?:a|area)$/i;function mt(e){return(e.match(R)||[]).join(" ")}function xt(e){return e.getAttribute&&e.getAttribute("class")||""}function bt(e){return Array.isArray(e)?e:"string"==typeof e&&e.match(R)||[]}k.fn.extend({prop:function(e,t){return _(this,k.prop,e,t,1<arguments.length)},removeProp:function(e){return this.each(function(){delete this[k.propFix[e]||e]})}}),k.extend({prop:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return 1===o&&k.isXMLDoc(e)||(t=k.propFix[t]||t,i=k.propHooks[t]),void 0!==n?i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:e[t]=n:i&&"get"in i&&null!==(r=i.get(e,t))?r:e[t]},propHooks:{tabIndex:{get:function(e){var t=k.find.attr(e,"tabindex");return t?parseInt(t,10):vt.test(e.nodeName)||yt.test(e.nodeName)&&e.href?0:-1}}},propFix:{"for":"htmlFor","class":"className"}}),y.optSelected||(k.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),k.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){k.propFix[this.toLowerCase()]=this}),k.fn.extend({addClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){k(this).addClass(t.call(this,e,xt(this)))});if((e=bt(t)).length)while(n=this[u++])if(i=xt(n),r=1===n.nodeType&&" "+mt(i)+" "){a=0;while(o=e[a++])r.indexOf(" "+o+" ")<0&&(r+=o+" ");i!==(s=mt(r))&&n.setAttribute("class",s)}return this},removeClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){k(this).removeClass(t.call(this,e,xt(this)))});if(!arguments.length)return this.attr("class","");if((e=bt(t)).length)while(n=this[u++])if(i=xt(n),r=1===n.nodeType&&" "+mt(i)+" "){a=0;while(o=e[a++])while(-1<r.indexOf(" "+o+" "))r=r.replace(" "+o+" "," ");i!==(s=mt(r))&&n.setAttribute("class",s)}return this},toggleClass:function(i,t){var o=typeof i,a="string"===o||Array.isArray(i);return"boolean"==typeof t&&a?t?this.addClass(i):this.removeClass(i):m(i)?this.each(function(e){k(this).toggleClass(i.call(this,e,xt(this),t),t)}):this.each(function(){var e,t,n,r;if(a){t=0,n=k(this),r=bt(i);while(e=r[t++])n.hasClass(e)?n.removeClass(e):n.addClass(e)}else void 0!==i&&"boolean"!==o||((e=xt(this))&&Q.set(this,"__className__",e),this.setAttribute&&this.setAttribute("class",e||!1===i?"":Q.get(this,"__className__")||""))})},hasClass:function(e){var t,n,r=0;t=" "+e+" ";while(n=this[r++])if(1===n.nodeType&&-1<(" "+mt(xt(n))+" ").indexOf(t))return!0;return!1}});var wt=/\r/g;k.fn.extend({val:function(n){var r,e,i,t=this[0];return arguments.length?(i=m(n),this.each(function(e){var t;1===this.nodeType&&(null==(t=i?n.call(this,e,k(this).val()):n)?t="":"number"==typeof t?t+="":Array.isArray(t)&&(t=k.map(t,function(e){return null==e?"":e+""})),(r=k.valHooks[this.type]||k.valHooks[this.nodeName.toLowerCase()])&&"set"in r&&void 0!==r.set(this,t,"value")||(this.value=t))})):t?(r=k.valHooks[t.type]||k.valHooks[t.nodeName.toLowerCase()])&&"get"in r&&void 0!==(e=r.get(t,"value"))?e:"string"==typeof(e=t.value)?e.replace(wt,""):null==e?"":e:void 0}}),k.extend({valHooks:{option:{get:function(e){var t=k.find.attr(e,"value");return null!=t?t:mt(k.text(e))}},select:{get:function(e){var t,n,r,i=e.options,o=e.selectedIndex,a="select-one"===e.type,s=a?null:[],u=a?o+1:i.length;for(r=o<0?u:a?o:0;r<u;r++)if(((n=i[r]).selected||r===o)&&!n.disabled&&(!n.parentNode.disabled||!A(n.parentNode,"optgroup"))){if(t=k(n).val(),a)return t;s.push(t)}return s},set:function(e,t){var n,r,i=e.options,o=k.makeArray(t),a=i.length;while(a--)((r=i[a]).selected=-1<k.inArray(k.valHooks.option.get(r),o))&&(n=!0);return n||(e.selectedIndex=-1),o}}}}),k.each(["radio","checkbox"],function(){k.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=-1<k.inArray(k(e).val(),t)}},y.checkOn||(k.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})}),y.focusin="onfocusin"in C;var Tt=/^(?:focusinfocus|focusoutblur)$/,Ct=function(e){e.stopPropagation()};k.extend(k.event,{trigger:function(e,t,n,r){var i,o,a,s,u,l,c,f,p=[n||E],d=v.call(e,"type")?e.type:e,h=v.call(e,"namespace")?e.namespace.split("."):[];if(o=f=a=n=n||E,3!==n.nodeType&&8!==n.nodeType&&!Tt.test(d+k.event.triggered)&&(-1<d.indexOf(".")&&(d=(h=d.split(".")).shift(),h.sort()),u=d.indexOf(":")<0&&"on"+d,(e=e[k.expando]?e:new k.Event(d,"object"==typeof e&&e)).isTrigger=r?2:3,e.namespace=h.join("."),e.rnamespace=e.namespace?new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,e.result=void 0,e.target||(e.target=n),t=null==t?[e]:k.makeArray(t,[e]),c=k.event.special[d]||{},r||!c.trigger||!1!==c.trigger.apply(n,t))){if(!r&&!c.noBubble&&!x(n)){for(s=c.delegateType||d,Tt.test(s+d)||(o=o.parentNode);o;o=o.parentNode)p.push(o),a=o;a===(n.ownerDocument||E)&&p.push(a.defaultView||a.parentWindow||C)}i=0;while((o=p[i++])&&!e.isPropagationStopped())f=o,e.type=1<i?s:c.bindType||d,(l=(Q.get(o,"events")||{})[e.type]&&Q.get(o,"handle"))&&l.apply(o,t),(l=u&&o[u])&&l.apply&&G(o)&&(e.result=l.apply(o,t),!1===e.result&&e.preventDefault());return e.type=d,r||e.isDefaultPrevented()||c._default&&!1!==c._default.apply(p.pop(),t)||!G(n)||u&&m(n[d])&&!x(n)&&((a=n[u])&&(n[u]=null),k.event.triggered=d,e.isPropagationStopped()&&f.addEventListener(d,Ct),n[d](),e.isPropagationStopped()&&f.removeEventListener(d,Ct),k.event.triggered=void 0,a&&(n[u]=a)),e.result}},simulate:function(e,t,n){var r=k.extend(new k.Event,n,{type:e,isSimulated:!0});k.event.trigger(r,null,t)}}),k.fn.extend({trigger:function(e,t){return this.each(function(){k.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n)return k.event.trigger(e,t,n,!0)}}),y.focusin||k.each({focus:"focusin",blur:"focusout"},function(n,r){var i=function(e){k.event.simulate(r,e.target,k.event.fix(e))};k.event.special[r]={setup:function(){var e=this.ownerDocument||this,t=Q.access(e,r);t||e.addEventListener(n,i,!0),Q.access(e,r,(t||0)+1)},teardown:function(){var e=this.ownerDocument||this,t=Q.access(e,r)-1;t?Q.access(e,r,t):(e.removeEventListener(n,i,!0),Q.remove(e,r))}}});var Et=C.location,kt=Date.now(),St=/\?/;k.parseXML=function(e){var t;if(!e||"string"!=typeof e)return null;try{t=(new C.DOMParser).parseFromString(e,"text/xml")}catch(e){t=void 0}return t&&!t.getElementsByTagName("parsererror").length||k.error("Invalid XML: "+e),t};var Nt=/\[\]$/,At=/\r?\n/g,Dt=/^(?:submit|button|image|reset|file)$/i,jt=/^(?:input|select|textarea|keygen)/i;function qt(n,e,r,i){var t;if(Array.isArray(e))k.each(e,function(e,t){r||Nt.test(n)?i(n,t):qt(n+"["+("object"==typeof t&&null!=t?e:"")+"]",t,r,i)});else if(r||"object"!==w(e))i(n,e);else for(t in e)qt(n+"["+t+"]",e[t],r,i)}k.param=function(e,t){var n,r=[],i=function(e,t){var n=m(t)?t():t;r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(null==e)return"";if(Array.isArray(e)||e.jquery&&!k.isPlainObject(e))k.each(e,function(){i(this.name,this.value)});else for(n in e)qt(n,e[n],t,i);return r.join("&")},k.fn.extend({serialize:function(){return k.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=k.prop(this,"elements");return e?k.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!k(this).is(":disabled")&&jt.test(this.nodeName)&&!Dt.test(e)&&(this.checked||!pe.test(e))}).map(function(e,t){var n=k(this).val();return null==n?null:Array.isArray(n)?k.map(n,function(e){return{name:t.name,value:e.replace(At,"\r\n")}}):{name:t.name,value:n.replace(At,"\r\n")}}).get()}});var Lt=/%20/g,Ht=/#.*$/,Ot=/([?&])_=[^&]*/,Pt=/^(.*?):[ \t]*([^\r\n]*)$/gm,Rt=/^(?:GET|HEAD)$/,Mt=/^\/\//,It={},Wt={},$t="*/".concat("*"),Ft=E.createElement("a");function Bt(o){return function(e,t){"string"!=typeof e&&(t=e,e="*");var n,r=0,i=e.toLowerCase().match(R)||[];if(m(t))while(n=i[r++])"+"===n[0]?(n=n.slice(1)||"*",(o[n]=o[n]||[]).unshift(t)):(o[n]=o[n]||[]).push(t)}}function _t(t,i,o,a){var s={},u=t===Wt;function l(e){var r;return s[e]=!0,k.each(t[e]||[],function(e,t){var n=t(i,o,a);return"string"!=typeof n||u||s[n]?u?!(r=n):void 0:(i.dataTypes.unshift(n),l(n),!1)}),r}return l(i.dataTypes[0])||!s["*"]&&l("*")}function zt(e,t){var n,r,i=k.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((i[n]?e:r||(r={}))[n]=t[n]);return r&&k.extend(!0,e,r),e}Ft.href=Et.href,k.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:Et.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(Et.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":$t,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":k.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?zt(zt(e,k.ajaxSettings),t):zt(k.ajaxSettings,e)},ajaxPrefilter:Bt(It),ajaxTransport:Bt(Wt),ajax:function(e,t){"object"==typeof e&&(t=e,e=void 0),t=t||{};var c,f,p,n,d,r,h,g,i,o,v=k.ajaxSetup({},t),y=v.context||v,m=v.context&&(y.nodeType||y.jquery)?k(y):k.event,x=k.Deferred(),b=k.Callbacks("once memory"),w=v.statusCode||{},a={},s={},u="canceled",T={readyState:0,getResponseHeader:function(e){var t;if(h){if(!n){n={};while(t=Pt.exec(p))n[t[1].toLowerCase()+" "]=(n[t[1].toLowerCase()+" "]||[]).concat(t[2])}t=n[e.toLowerCase()+" "]}return null==t?null:t.join(", ")},getAllResponseHeaders:function(){return h?p:null},setRequestHeader:function(e,t){return null==h&&(e=s[e.toLowerCase()]=s[e.toLowerCase()]||e,a[e]=t),this},overrideMimeType:function(e){return null==h&&(v.mimeType=e),this},statusCode:function(e){var t;if(e)if(h)T.always(e[T.status]);else for(t in e)w[t]=[w[t],e[t]];return this},abort:function(e){var t=e||u;return c&&c.abort(t),l(0,t),this}};if(x.promise(T),v.url=((e||v.url||Et.href)+"").replace(Mt,Et.protocol+"//"),v.type=t.method||t.type||v.method||v.type,v.dataTypes=(v.dataType||"*").toLowerCase().match(R)||[""],null==v.crossDomain){r=E.createElement("a");try{r.href=v.url,r.href=r.href,v.crossDomain=Ft.protocol+"//"+Ft.host!=r.protocol+"//"+r.host}catch(e){v.crossDomain=!0}}if(v.data&&v.processData&&"string"!=typeof v.data&&(v.data=k.param(v.data,v.traditional)),_t(It,v,t,T),h)return T;for(i in(g=k.event&&v.global)&&0==k.active++&&k.event.trigger("ajaxStart"),v.type=v.type.toUpperCase(),v.hasContent=!Rt.test(v.type),f=v.url.replace(Ht,""),v.hasContent?v.data&&v.processData&&0===(v.contentType||"").indexOf("application/x-www-form-urlencoded")&&(v.data=v.data.replace(Lt,"+")):(o=v.url.slice(f.length),v.data&&(v.processData||"string"==typeof v.data)&&(f+=(St.test(f)?"&":"?")+v.data,delete v.data),!1===v.cache&&(f=f.replace(Ot,"$1"),o=(St.test(f)?"&":"?")+"_="+kt+++o),v.url=f+o),v.ifModified&&(k.lastModified[f]&&T.setRequestHeader("If-Modified-Since",k.lastModified[f]),k.etag[f]&&T.setRequestHeader("If-None-Match",k.etag[f])),(v.data&&v.hasContent&&!1!==v.contentType||t.contentType)&&T.setRequestHeader("Content-Type",v.contentType),T.setRequestHeader("Accept",v.dataTypes[0]&&v.accepts[v.dataTypes[0]]?v.accepts[v.dataTypes[0]]+("*"!==v.dataTypes[0]?", "+$t+"; q=0.01":""):v.accepts["*"]),v.headers)T.setRequestHeader(i,v.headers[i]);if(v.beforeSend&&(!1===v.beforeSend.call(y,T,v)||h))return T.abort();if(u="abort",b.add(v.complete),T.done(v.success),T.fail(v.error),c=_t(Wt,v,t,T)){if(T.readyState=1,g&&m.trigger("ajaxSend",[T,v]),h)return T;v.async&&0<v.timeout&&(d=C.setTimeout(function(){T.abort("timeout")},v.timeout));try{h=!1,c.send(a,l)}catch(e){if(h)throw e;l(-1,e)}}else l(-1,"No Transport");function l(e,t,n,r){var i,o,a,s,u,l=t;h||(h=!0,d&&C.clearTimeout(d),c=void 0,p=r||"",T.readyState=0<e?4:0,i=200<=e&&e<300||304===e,n&&(s=function(e,t,n){var r,i,o,a,s=e.contents,u=e.dataTypes;while("*"===u[0])u.shift(),void 0===r&&(r=e.mimeType||t.getResponseHeader("Content-Type"));if(r)for(i in s)if(s[i]&&s[i].test(r)){u.unshift(i);break}if(u[0]in n)o=u[0];else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}a||(a=i)}o=o||a}if(o)return o!==u[0]&&u.unshift(o),n[o]}(v,T,n)),s=function(e,t,n,r){var i,o,a,s,u,l={},c=e.dataTypes.slice();if(c[1])for(a in e.converters)l[a.toLowerCase()]=e.converters[a];o=c.shift();while(o)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!u&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u=o,o=c.shift())if("*"===o)o=u;else if("*"!==u&&u!==o){if(!(a=l[u+" "+o]||l["* "+o]))for(i in l)if((s=i.split(" "))[1]===o&&(a=l[u+" "+s[0]]||l["* "+s[0]])){!0===a?a=l[i]:!0!==l[i]&&(o=s[0],c.unshift(s[1]));break}if(!0!==a)if(a&&e["throws"])t=a(t);else try{t=a(t)}catch(e){return{state:"parsererror",error:a?e:"No conversion from "+u+" to "+o}}}return{state:"success",data:t}}(v,s,T,i),i?(v.ifModified&&((u=T.getResponseHeader("Last-Modified"))&&(k.lastModified[f]=u),(u=T.getResponseHeader("etag"))&&(k.etag[f]=u)),204===e||"HEAD"===v.type?l="nocontent":304===e?l="notmodified":(l=s.state,o=s.data,i=!(a=s.error))):(a=l,!e&&l||(l="error",e<0&&(e=0))),T.status=e,T.statusText=(t||l)+"",i?x.resolveWith(y,[o,l,T]):x.rejectWith(y,[T,l,a]),T.statusCode(w),w=void 0,g&&m.trigger(i?"ajaxSuccess":"ajaxError",[T,v,i?o:a]),b.fireWith(y,[T,l]),g&&(m.trigger("ajaxComplete",[T,v]),--k.active||k.event.trigger("ajaxStop")))}return T},getJSON:function(e,t,n){return k.get(e,t,n,"json")},getScript:function(e,t){return k.get(e,void 0,t,"script")}}),k.each(["get","post"],function(e,i){k[i]=function(e,t,n,r){return m(t)&&(r=r||n,n=t,t=void 0),k.ajax(k.extend({url:e,type:i,dataType:r,data:t,success:n},k.isPlainObject(e)&&e))}}),k._evalUrl=function(e,t){return k.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(e){k.globalEval(e,t)}})},k.fn.extend({wrapAll:function(e){var t;return this[0]&&(m(e)&&(e=e.call(this[0])),t=k(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstElementChild)e=e.firstElementChild;return e}).append(this)),this},wrapInner:function(n){return m(n)?this.each(function(e){k(this).wrapInner(n.call(this,e))}):this.each(function(){var e=k(this),t=e.contents();t.length?t.wrapAll(n):e.append(n)})},wrap:function(t){var n=m(t);return this.each(function(e){k(this).wrapAll(n?t.call(this,e):t)})},unwrap:function(e){return this.parent(e).not("body").each(function(){k(this).replaceWith(this.childNodes)}),this}}),k.expr.pseudos.hidden=function(e){return!k.expr.pseudos.visible(e)},k.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},k.ajaxSettings.xhr=function(){try{return new C.XMLHttpRequest}catch(e){}};var Ut={0:200,1223:204},Xt=k.ajaxSettings.xhr();y.cors=!!Xt&&"withCredentials"in Xt,y.ajax=Xt=!!Xt,k.ajaxTransport(function(i){var o,a;if(y.cors||Xt&&!i.crossDomain)return{send:function(e,t){var n,r=i.xhr();if(r.open(i.type,i.url,i.async,i.username,i.password),i.xhrFields)for(n in i.xhrFields)r[n]=i.xhrFields[n];for(n in i.mimeType&&r.overrideMimeType&&r.overrideMimeType(i.mimeType),i.crossDomain||e["X-Requested-With"]||(e["X-Requested-With"]="XMLHttpRequest"),e)r.setRequestHeader(n,e[n]);o=function(e){return function(){o&&(o=a=r.onload=r.onerror=r.onabort=r.ontimeout=r.onreadystatechange=null,"abort"===e?r.abort():"error"===e?"number"!=typeof r.status?t(0,"error"):t(r.status,r.statusText):t(Ut[r.status]||r.status,r.statusText,"text"!==(r.responseType||"text")||"string"!=typeof r.responseText?{binary:r.response}:{text:r.responseText},r.getAllResponseHeaders()))}},r.onload=o(),a=r.onerror=r.ontimeout=o("error"),void 0!==r.onabort?r.onabort=a:r.onreadystatechange=function(){4===r.readyState&&C.setTimeout(function(){o&&a()})},o=o("abort");try{r.send(i.hasContent&&i.data||null)}catch(e){if(o)throw e}},abort:function(){o&&o()}}}),k.ajaxPrefilter(function(e){e.crossDomain&&(e.contents.script=!1)}),k.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return k.globalEval(e),e}}}),k.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),k.ajaxTransport("script",function(n){var r,i;if(n.crossDomain||n.scriptAttrs)return{send:function(e,t){r=k("<script>").attr(n.scriptAttrs||{}).prop({charset:n.scriptCharset,src:n.url}).on("load error",i=function(e){r.remove(),i=null,e&&t("error"===e.type?404:200,e.type)}),E.head.appendChild(r[0])},abort:function(){i&&i()}}});var Vt,Gt=[],Yt=/(=)\?(?=&|$)|\?\?/;k.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Gt.pop()||k.expando+"_"+kt++;return this[e]=!0,e}}),k.ajaxPrefilter("json jsonp",function(e,t,n){var r,i,o,a=!1!==e.jsonp&&(Yt.test(e.url)?"url":"string"==typeof e.data&&0===(e.contentType||"").indexOf("application/x-www-form-urlencoded")&&Yt.test(e.data)&&"data");if(a||"jsonp"===e.dataTypes[0])return r=e.jsonpCallback=m(e.jsonpCallback)?e.jsonpCallback():e.jsonpCallback,a?e[a]=e[a].replace(Yt,"$1"+r):!1!==e.jsonp&&(e.url+=(St.test(e.url)?"&":"?")+e.jsonp+"="+r),e.converters["script json"]=function(){return o||k.error(r+" was not called"),o[0]},e.dataTypes[0]="json",i=C[r],C[r]=function(){o=arguments},n.always(function(){void 0===i?k(C).removeProp(r):C[r]=i,e[r]&&(e.jsonpCallback=t.jsonpCallback,Gt.push(r)),o&&m(i)&&i(o[0]),o=i=void 0}),"script"}),y.createHTMLDocument=((Vt=E.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===Vt.childNodes.length),k.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(y.createHTMLDocument?((r=(t=E.implementation.createHTMLDocument("")).createElement("base")).href=E.location.href,t.head.appendChild(r)):t=E),o=!n&&[],(i=D.exec(e))?[t.createElement(i[1])]:(i=we([e],t,o),o&&o.length&&k(o).remove(),k.merge([],i.childNodes)));var r,i,o},k.fn.load=function(e,t,n){var r,i,o,a=this,s=e.indexOf(" ");return-1<s&&(r=mt(e.slice(s)),e=e.slice(0,s)),m(t)?(n=t,t=void 0):t&&"object"==typeof t&&(i="POST"),0<a.length&&k.ajax({url:e,type:i||"GET",dataType:"html",data:t}).done(function(e){o=arguments,a.html(r?k("<div>").append(k.parseHTML(e)).find(r):e)}).always(n&&function(e,t){a.each(function(){n.apply(this,o||[e.responseText,t,e])})}),this},k.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){k.fn[t]=function(e){return this.on(t,e)}}),k.expr.pseudos.animated=function(t){return k.grep(k.timers,function(e){return t===e.elem}).length},k.offset={setOffset:function(e,t,n){var r,i,o,a,s,u,l=k.css(e,"position"),c=k(e),f={};"static"===l&&(e.style.position="relative"),s=c.offset(),o=k.css(e,"top"),u=k.css(e,"left"),("absolute"===l||"fixed"===l)&&-1<(o+u).indexOf("auto")?(a=(r=c.position()).top,i=r.left):(a=parseFloat(o)||0,i=parseFloat(u)||0),m(t)&&(t=t.call(e,n,k.extend({},s))),null!=t.top&&(f.top=t.top-s.top+a),null!=t.left&&(f.left=t.left-s.left+i),"using"in t?t.using.call(e,f):c.css(f)}},k.fn.extend({offset:function(t){if(arguments.length)return void 0===t?this:this.each(function(e){k.offset.setOffset(this,t,e)});var e,n,r=this[0];return r?r.getClientRects().length?(e=r.getBoundingClientRect(),n=r.ownerDocument.defaultView,{top:e.top+n.pageYOffset,left:e.left+n.pageXOffset}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n,r=this[0],i={top:0,left:0};if("fixed"===k.css(r,"position"))t=r.getBoundingClientRect();else{t=this.offset(),n=r.ownerDocument,e=r.offsetParent||n.documentElement;while(e&&(e===n.body||e===n.documentElement)&&"static"===k.css(e,"position"))e=e.parentNode;e&&e!==r&&1===e.nodeType&&((i=k(e).offset()).top+=k.css(e,"borderTopWidth",!0),i.left+=k.css(e,"borderLeftWidth",!0))}return{top:t.top-i.top-k.css(r,"marginTop",!0),left:t.left-i.left-k.css(r,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent;while(e&&"static"===k.css(e,"position"))e=e.offsetParent;return e||ie})}}),k.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(t,i){var o="pageYOffset"===i;k.fn[t]=function(e){return _(this,function(e,t,n){var r;if(x(e)?r=e:9===e.nodeType&&(r=e.defaultView),void 0===n)return r?r[i]:e[t];r?r.scrollTo(o?r.pageXOffset:n,o?n:r.pageYOffset):e[t]=n},t,e,arguments.length)}}),k.each(["top","left"],function(e,n){k.cssHooks[n]=ze(y.pixelPosition,function(e,t){if(t)return t=_e(e,n),$e.test(t)?k(e).position()[n]+"px":t})}),k.each({Height:"height",Width:"width"},function(a,s){k.each({padding:"inner"+a,content:s,"":"outer"+a},function(r,o){k.fn[o]=function(e,t){var n=arguments.length&&(r||"boolean"!=typeof e),i=r||(!0===e||!0===t?"margin":"border");return _(this,function(e,t,n){var r;return x(e)?0===o.indexOf("outer")?e["inner"+a]:e.document.documentElement["client"+a]:9===e.nodeType?(r=e.documentElement,Math.max(e.body["scroll"+a],r["scroll"+a],e.body["offset"+a],r["offset"+a],r["client"+a])):void 0===n?k.css(e,t,i):k.style(e,t,n,i)},s,n?e:void 0,n)}})}),k.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(e,n){k.fn[n]=function(e,t){return 0<arguments.length?this.on(n,null,e,t):this.trigger(n)}}),k.fn.extend({hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),k.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)}}),k.proxy=function(e,t){var n,r,i;if("string"==typeof t&&(n=e[t],t=e,e=n),m(e))return r=s.call(arguments,2),(i=function(){return e.apply(t||this,r.concat(s.call(arguments)))}).guid=e.guid=e.guid||k.guid++,i},k.holdReady=function(e){e?k.readyWait++:k.ready(!0)},k.isArray=Array.isArray,k.parseJSON=JSON.parse,k.nodeName=A,k.isFunction=m,k.isWindow=x,k.camelCase=V,k.type=w,k.now=Date.now,k.isNumeric=function(e){var t=k.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))}, true&&!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function(){return k}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));var Qt=C.jQuery,Jt=C.$;return k.noConflict=function(e){return C.$===k&&(C.$=Jt),e&&C.jQuery===k&&(C.jQuery=Qt),k},e||(C.jQuery=C.$=k),k});


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = "<link href=\"https://fonts.googleapis.com/icon?family=Material+Icons\" rel=stylesheet>\r\n<link href=\"https://fonts.googleapis.com/icon?family=Material+Icons+Outlined\" rel=stylesheet>\r\n\r\n<div class=loading-page-overlay style=position:fixed;display:flex;justify-content:center;align-items:center;text-align:center;width:100%;height:100%;top:0;left:0;background:#eee;z-index:1000>\r\n    <div>\r\n        <div><img width=60px src=" + __webpack_require__(16) + " /></div>\r\n        <label style=margin-bottom:0;margin-top:-5px;font-size:95%>Starting....</label>\r\n    </div>\r\n</div>\r\n\r\n<div class=wrapper>\r\n    <div class=\"top container-fluid\">\r\n        <div class=row>\r\n            <div class=\"col-md-6 top-left float-left\">\r\n                <ul class=menu-bar>\r\n                    <li>\r\n                        <div class=logo>\r\n                            <img class=logo-img src=" + __webpack_require__(209) + ">\r\n                        </div>\r\n                    </li>\r\n                    <li>\r\n                        <div class=\"action-menu design-menu\">\r\n                            <span class=action-design>{language.menubar.items.design}</span>\r\n                            <span class=material-icons>expand_more</span>\r\n                            <ul class=\"design display\">\r\n                                <li><a class=design-new href=#> {language.menubar.items.designs.new} </a></li>\r\n                                <li><a class=design-clear href=#> {language.menubar.items.designs.clear} </a></li>\r\n                                <li><a class=design-from-template href=#> {language.menubar.items.designs.new_template} </a></li>\r\n                                <li><a class=design-upload-template href=#> {language.menubar.items.designs.upload_template} </a></li>\r\n                                <li><a class=save-design href=#> {language.menubar.items.designs.save} </a></li>\r\n                                <li><a class=\"design-exit back\" href=# data-method=POST> {language.menubar.items.designs.exit} </a></li>\r\n                            </ul>\r\n                        </div>\r\n                    </li>\r\n                    <li class=choose-template-menu>\r\n                        <div class=\"action-menu action-choose-template\">\r\n                            <span class=choose>{language.menubar.items.change_template}</span>\r\n                            <span class=material-icons>expand_more</span>\r\n                            <div class=show-list-template>\r\n                                <ul class=\"display-template display\">\r\n\r\n                                </ul>\r\n                            </div>\r\n                            <!--show thumbnail image template-->\r\n                            <div class=template-thumbnail>\r\n                                <img class=img-template src=/ />\r\n                            </div>\r\n                        </div>\r\n                    </li>\r\n                    <li>\r\n                        <div class=\"action-menu action action-preview preview-page\">\r\n                            <span class=ac>{language.menubar.items.preview}</span>\r\n                            <span class=material-icons>expand_more</span>\r\n                            <ul class=display>\r\n                                <li><a class=preview-design-desktop href=#> {language.menubar.items.previews.desktop} </a></li>\r\n                                <li><a class=preview-design-mobile href=#> {language.menubar.items.previews.mobile} </a></li>\r\n                            </ul>\r\n                        </div>\r\n                    </li>\r\n                    <li>\r\n                        <div class=\"action-menu view-mode\">\r\n                            <span class=ac id=show-mode>{language.menubar.items.mode_design}</span>\r\n                            <span class=material-icons>expand_more</span>\r\n                            <ul class=display-view-mode>\r\n                                <li><a class=view-mode-design href=#> {language.menubar.items.mode_designs.design} </a></li>\r\n                                <li><a class=view-mode-source href=#> {language.menubar.items.mode_designs.source} </a></li>\r\n                            </ul>\r\n                        </div>\r\n                    </li>\r\n                </ul>\r\n            </div>\r\n            <div class=\"col-md-6 top-right float-right\">\r\n                <div class=\"mode-device ml-auto\" style=\"\">\r\n                    <li class=\"device mode-mobile\" data-mode=mode-mobile title={language.menubar.items.devices.mobile}>\r\n                        <span class=\"material-icons-outlined icon-mode\" style=color:#969696>smartphone</span>\r\n                    </li>\r\n                    <li class=\"device mode-tablet\" data-mode=mode-tablet title={language.menubar.items.devices.tablet}>\r\n                        <span class=\"material-icons-outlined icon-mode\" style=color:#969696>tablet_android</span>\r\n                    </li>\r\n                    <li class=\"device mode-desktop\" data-mode=mode-desktop title={language.menubar.items.devices.desktop}>\r\n                        <span class=\"material-icons-outlined icon-mode\">computer</span>\r\n                    </li>\r\n                </div>\r\n                <ul class=icons>\r\n                    <li class=ask-help>\r\n                        <span class=\"material-icons-outlined icon mr-1\">help_outline</span>\r\n                        <span class=help>{language.menubar.items.help}</span>\r\n                    </li>\r\n                </ul>\r\n                <!--<div class=\"sync\">\r\n                    <button class=\"btn btn-primary btn-sync\"><i class=\"fab fa-google\"></i> {language.menubar.items.sync} </button>\r\n                    <span class=\"choose-sync\"><i class=\"{builder-icon-angle-down}\"></span>\r\n                    <ul class=\"action-sync\">\r\n                        <li class=\"synchronization google-driver\" data-sync=\"google-driver\" data-title=\"{language.menubar.items.syncs.google_driver.title}\" disable=\"disable\">\r\n                            {language.menubar.items.syncs.google_driver}\r\n                        </li>\r\n                        <li class=\"synchronization dropbox\" data-sync=\"dropbox\" data-title=\"{language.menubar.items.syncs.dropbox}\">\r\n                            {language.menubar.items.syncs.dropbox}\r\n                        </li>\r\n                        <li class=\"synchronization one-driver\" data-sync=\"one-driver\" data-title=\"{language.menubar.items.syncs.one_driver}\">\r\n                            {language.menubar.items.syncs.one_driver}\r\n                        </li>\r\n                        <li class=\"setting\">\r\n                            {language.menubar.items.syncs.setting}\r\n                        </li>\r\n                    </ul>\r\n                </div>\r\n                \r\n                <div class=\"lang\">\r\n                    <button class=\"btn btn-primary btn-sync\"><i class=\"fab fa-google\"></i> {language.menubar.items.lang} </button>\r\n                    <span class=\"choose-lang\"><i class=\"{builder-icon-angle-down}\"></span>\r\n                    <ul class=\"action-lang\">\r\n                        <li class=\"change-language lang-en\" data-lang=\"english\" data-title=\"{language.menubar.items.lang.eng}\" disable=\"disable\">\r\n                            {language.menubar.items.lang.eng}\r\n                        </li>\r\n                        <li class=\"change-language lang-vi\" data-lang=\"vietname\" data-title=\"{language.menubar.items.lang.vie}\">\r\n                            {language.menubar.items.lang.vie}\r\n                        </li>\r\n                        <li class=\"change-language lang-jp\" data-lang=\"japan\" data-title=\"{language.menubar.items.lang.jpa}\">\r\n                            {language.menubar.items.lang.jpa}\r\n                        </li>\r\n                        <li class=\"setting\">\r\n                            {language.menubar.items.lang.setting}\r\n                        </li>\r\n                    </ul>\r\n                </div>-->\r\n                <div class=\"d-flex align-items-center\">\r\n                    <a class=save-design href=#>\r\n                        <button class=\"btn btn-primary btn-save menu-bar-action\">{language.menubar.items.save}</button>\r\n                    </a>                    \r\n                    <a class=save-and-close href=#>\r\n                        <button class=\"btn btn-primary btn-save-and-close menu-bar-action\">{language.menubar.items.save_and_close}</button>\r\n                    </a>\r\n                    <a class=export-button href=#>\r\n                        <button class=\"btn btn-primary btn-export menu-bar-action\">{language.export}</button>\r\n                    </a>\r\n                    <a class=builder-close href=#>\r\n                        <button class=\"btn btn-primary btn-close menu-bar-action\"><i class={builder-icon-cross}></i></button>\r\n                    </a>\r\n                </div>                \r\n            </div>\r\n        </div>\r\n    </div><!-- end top-->\r\n    <div class=\"content container-fluid\">\r\n        <div class=\"\">\r\n            <div class=content-container>\r\n                <div class=content-left name=editable id=editable contenteditable=true>\r\n                    <div class=content-background>\r\n                        <iframe class=\"col-lg-12 col-md-12 col-sm-12\" id=builder_iframe width=100% height=100% onload='this.style.height=this.contentDocument.body.scrollHeight+\"px\"' scrolling=no style=\"\"></iframe>\r\n                    </div>\r\n                </div><!-- end content-left -->\r\n            </div>\r\n            \r\n            <div class=side-panel-container>\r\n                <div id=builder_sidebar class=content-right>\r\n                    <nav class=\"\" style=\"\">\r\n                        <div class=\"nav nav-tabs\" id=nav-tab role=tablist>\r\n                            <a class=\"nav-item nav-link active\" id=nav-home-tab data-toggle=tab href=#nav-home role=tab aria-controls=nav-content aria-selected=true>\r\n                                <span class=\"flex align-items-center\">\r\n                                    <span class=\"material-icons-outlined mr-2\">developer_board</span>\r\n                                    <span>{language.navbar.contents.widgets}</span>\r\n                                </span>\r\n                            </a>\r\n                            <a style=display:none class=\"nav-item nav-link\" id=nav-layouts-tab data-toggle=tab href=#nav-layouts role=tab aria-controls=nav-row aria-selected=false>\r\n                                <span class=\"flex align-items-center\">\r\n                                    <span class=\"material-icons-outlined mr-2\">local_offer</span>\r\n                                    <span>{language.navbar.contents.layouts}</span>\r\n                                </span>\r\n                            </a>\r\n                            <a class=\"nav-item nav-link\" id=nav-contact-tab data-toggle=tab href=#nav-contact role=tab aria-controls=nav-setting aria-selected=false>\r\n                                <span class=\"flex align-items-center\">\r\n                                    <span class=\"material-icons-outlined mr-2\">local_offer</span>\r\n                                    <span>{language.navbar.contents.tags}</span>\r\n                                </span>\r\n                            </a>\r\n                            <a href=javascript:; class=\"nav-item nav-link\" id=nav-profile-tab>\r\n                                <span class=\"flex align-items-center\">\r\n                                    <span class=\"material-icons-outlined mr-2\">settings</span>\r\n                                    <span>{language.navbar.contents.setting}</span>\r\n                                </span>\r\n                            </a>\r\n                        </div>\r\n                    </nav>\r\n                    <div class=tab-content id=nav-tabContent>\r\n                        <div class=\"tab-pane fade show active\" id=nav-home role=tabpanel aria-labelledby=nav-home-tab>\r\n                            <div class=\"container modules widgets-sections\">\r\n                                <div class=\"widgets-section widgets-form\">\r\n                                    <label class=block-title>{language.section.form_elements}</label>\r\n                                    <div class=\"widgets-form-container fields-container\">\r\n                                    <div class=\"text-center full-width\">\r\n                                        {language.navbar.contents.loading}\r\n                                        </div>\r\n                                        <!--load khoi xoay -->\r\n                                    </div>\r\n                                </div>                            \r\n                                <div class=\"widgets-section widgets-other mb-4\">\r\n                                    <label class=block-title>{language.section.general}</label>\r\n                                    <div class=content_widget_container>\r\n                                        {language.navbar.contents.loading}\r\n                                        <!--load khoi xoay -->\r\n                                        \r\n                                    </div>\r\n                                    <div class=load-show_more style=display:flex;justify-content:center>\r\n                                        <a class=\"link-widget link-show_more\" title=\"Show more widget\" style=\"cursor:pointer;padding:5px 20px;background:#e5e5e5;border-radius:2px\">{language.navbar.contents.show_more.loading}</a>\r\n                                        <a class=\"link-widget link-hide_less\" title=\"Show less widget\" style=\"cursor:pointer;padding:5px 20px;background:#e5e5e5;border-radius:2px;display:none\">{language.navbar.contents.show_less.loading}</a>\r\n                                    </div>\r\n                                </div>\r\n                                \r\n                            </div>\r\n                            <div class=\"container detail-content\">\r\n                                <div class=properties-pannel-title>\r\n                                    <h4>{language.navbar.contents.content_property}</h4>\r\n                                    <div class=action>\r\n                                        <a class=\"delete builder-remove-selected-button\" href=javascript:; data-toggle=tooltip title={language.navbar.items.actions.delete}>\r\n                                            <span class=material-icons-outlined>delete</span>\r\n                                        </a>\r\n                                        <a class=\"duplicate builder-duplicate-selected-button\" href=javascript:; title={language.navbar.items.actions.duplicate}>\r\n                                            <span class=material-icons-outlined style=font-size:20px>filter_none</span>\r\n                                        </a>\r\n                                        <a class=move href=javascript:; title={language.navbar.items.actions.down}>\r\n                                            <span class=material-icons-outlined>keyboard_arrow_down</span>\r\n                                        </a>\r\n                                    </div>\r\n                                </div>\r\n                                <div class=\"properties-pannel-content attributes-container\">\r\n                                    \r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class=\"tab-pane fade\" id=nav-profile role=tabpanel aria-labelledby=nav-profile-tab>\r\n                            <!-- <div class=\"container rows-module\" style=\"\">\r\n                                <div class=\"row row_widget_container\">\r\n                                    {language.navbar.contents.loading}\r\n                                </div>\r\n                            </div> -->\r\n                        </div>\r\n                        <div class=\"tab-pane fade\" id=nav-layouts role=tabpanel aria-labelledby=nav-layouts-tab>\r\n                            <div class=\"container rows-module\" style=\"\">\r\n                                <div class=\"row row_widget_container\">\r\n                                    {language.navbar.contents.loading}\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                        <div class=\"tab-pane fade\" id=nav-contact role=tabpanel aria-labelledby=nav-contact-tab>\r\n                            <div class=\"container setting-module\">\r\n                                <ul class=tags-value>\r\n\r\n                                </ul>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class=\"col-md-6 view-source\">\r\n                <div id=editor>\r\n                    <!--content template-->\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div><!-- end container-fluid-->\r\n\r\n    <div class=undo-redo>\r\n        <div class=undo-redo-actions>\r\n            <button class=undo-redo-action-history data-toggle=tooltip title={language.bottombar.items.history} style=border-radius:2px>\r\n                <i class=\"{builder-icon-history} history\"></i>\r\n            </button>\r\n            <button class=undo-redo-action-undo data-toggle=tooltip title={language.bottombar.items.undo}>\r\n                <i class=\"{builder-icon-reply} history\"></i>\r\n            </button>\r\n            <button class=\"undo-redo-action-redo disable-redo\" data-toggle=tooltip title={language.bottombar.items.redo}>\r\n                <i class=\"{builder-icon-reply} history\" style=transform:rotateY(165deg)></i>\r\n            </button>\r\n        </div>\r\n\r\n        <!--history-->\r\n        <div ng-if=historyOpen class=\"undo-redo__history--wrapper ng-scope\" style=display:none>\r\n            <div ng-transclude=\"\" mailup-common-scrollbar=\"\" class=ng-isolate-scope style=height:100%;position:relative>\r\n                <div class=\"undo-redo__history undo-redo__history--open ng-scope mailup-common-scrollable-container ps-container ps-theme-default ps-active-y\" data-ps-id=3934d02e-7a69-b8f0-1c88-d7d2783b123d>\r\n                    <ul id=undo-redo__history class=\"\">\r\n                    </ul>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    \r\n    <div class=\"ui-pnotify bg-warning bg-as notification-area\" style=background-color:#d8eacc!important;width:auto;right:10px;top:auto;bottom:39px;opacity:1;display:none;overflow:visible;cursor:auto>\r\n        <div class=\"alert ui-pnotify-container ui-pnotify-shadow\" style=min-height:16px;overflow:hidden;position:relative;padding-left:20px;padding-right:41px;padding-top:20px;padding-bottom:20px>\r\n            <div class=ui-pnotify-text style=font-size:14px>\r\n\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <footer class=footer>\r\n        <div class=container-fluid>\r\n            <div class=\"col-md-6 footer-left\">\r\n                <a href=# class=\"back footer-exit-without-save\">\r\n                    <i class={builder-icon-angle-left}></i><p>{language.bottombar.items.exit}</p>\r\n                </a>\r\n            </div>\r\n            <div class=\"col-md-6 footer-right\">\r\n                <span style=font-size:13px;height:100%;display:flex;align-items:center;justify-content:flex-end>{language.bottombar.items.last_save}</span>\r\n                \r\n            </div>\r\n        </div>\r\n    </footer><!-- end footer-->\r\n    <div class=box-popup-right title=\"Show apps\">\r\n        <span class=\"material-icons-outlined icon\">chevron_left</span>\r\n    </div>\r\n</div><!-- end wrapper-->\r\n";

/***/ }),
/* 12 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
 * jQuery JavaScript Library v3.6.0
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2021-03-02T17:08Z
 */
( function( global, factory ) {

	"use strict";

	if (  true && typeof module.exports === "object" ) {

		// For CommonJS and CommonJS-like environments where a proper `window`
		// is present, execute the factory and get jQuery.
		// For environments that do not have a `window` with a `document`
		// (such as Node.js), expose a factory as module.exports.
		// This accentuates the need for the creation of a real `window`.
		// e.g. var jQuery = require("jquery")(window);
		// See ticket #14549 for more info.
		module.exports = global.document ?
			factory( global, true ) :
			function( w ) {
				if ( !w.document ) {
					throw new Error( "jQuery requires a window with a document" );
				}
				return factory( w );
			};
	} else {
		factory( global );
	}

// Pass this if window is not defined yet
} )( typeof window !== "undefined" ? window : this, function( window, noGlobal ) {

// Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
// throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
// arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
// enough that all such attempts are guarded in a try block.
"use strict";

var arr = [];

var getProto = Object.getPrototypeOf;

var slice = arr.slice;

var flat = arr.flat ? function( array ) {
	return arr.flat.call( array );
} : function( array ) {
	return arr.concat.apply( [], array );
};


var push = arr.push;

var indexOf = arr.indexOf;

var class2type = {};

var toString = class2type.toString;

var hasOwn = class2type.hasOwnProperty;

var fnToString = hasOwn.toString;

var ObjectFunctionString = fnToString.call( Object );

var support = {};

var isFunction = function isFunction( obj ) {

		// Support: Chrome <=57, Firefox <=52
		// In some browsers, typeof returns "function" for HTML <object> elements
		// (i.e., `typeof document.createElement( "object" ) === "function"`).
		// We don't want to classify *any* DOM node as a function.
		// Support: QtWeb <=3.8.5, WebKit <=534.34, wkhtmltopdf tool <=0.12.5
		// Plus for old WebKit, typeof returns "function" for HTML collections
		// (e.g., `typeof document.getElementsByTagName("div") === "function"`). (gh-4756)
		return typeof obj === "function" && typeof obj.nodeType !== "number" &&
			typeof obj.item !== "function";
	};


var isWindow = function isWindow( obj ) {
		return obj != null && obj === obj.window;
	};


var document = window.document;



	var preservedScriptAttributes = {
		type: true,
		src: true,
		nonce: true,
		noModule: true
	};

	function DOMEval( code, node, doc ) {
		doc = doc || document;

		var i, val,
			script = doc.createElement( "script" );

		script.text = code;
		if ( node ) {
			for ( i in preservedScriptAttributes ) {

				// Support: Firefox 64+, Edge 18+
				// Some browsers don't support the "nonce" property on scripts.
				// On the other hand, just using `getAttribute` is not enough as
				// the `nonce` attribute is reset to an empty string whenever it
				// becomes browsing-context connected.
				// See https://github.com/whatwg/html/issues/2369
				// See https://html.spec.whatwg.org/#nonce-attributes
				// The `node.getAttribute` check was added for the sake of
				// `jQuery.globalEval` so that it can fake a nonce-containing node
				// via an object.
				val = node[ i ] || node.getAttribute && node.getAttribute( i );
				if ( val ) {
					script.setAttribute( i, val );
				}
			}
		}
		doc.head.appendChild( script ).parentNode.removeChild( script );
	}


function toType( obj ) {
	if ( obj == null ) {
		return obj + "";
	}

	// Support: Android <=2.3 only (functionish RegExp)
	return typeof obj === "object" || typeof obj === "function" ?
		class2type[ toString.call( obj ) ] || "object" :
		typeof obj;
}
/* global Symbol */
// Defining this global in .eslintrc.json would create a danger of using the global
// unguarded in another place, it seems safer to define global only for this module



var
	version = "3.6.0",

	// Define a local copy of jQuery
	jQuery = function( selector, context ) {

		// The jQuery object is actually just the init constructor 'enhanced'
		// Need init if jQuery is called (just allow error to be thrown if not included)
		return new jQuery.fn.init( selector, context );
	};

jQuery.fn = jQuery.prototype = {

	// The current version of jQuery being used
	jquery: version,

	constructor: jQuery,

	// The default length of a jQuery object is 0
	length: 0,

	toArray: function() {
		return slice.call( this );
	},

	// Get the Nth element in the matched element set OR
	// Get the whole matched element set as a clean array
	get: function( num ) {

		// Return all the elements in a clean array
		if ( num == null ) {
			return slice.call( this );
		}

		// Return just the one element from the set
		return num < 0 ? this[ num + this.length ] : this[ num ];
	},

	// Take an array of elements and push it onto the stack
	// (returning the new matched element set)
	pushStack: function( elems ) {

		// Build a new jQuery matched element set
		var ret = jQuery.merge( this.constructor(), elems );

		// Add the old object onto the stack (as a reference)
		ret.prevObject = this;

		// Return the newly-formed element set
		return ret;
	},

	// Execute a callback for every element in the matched set.
	each: function( callback ) {
		return jQuery.each( this, callback );
	},

	map: function( callback ) {
		return this.pushStack( jQuery.map( this, function( elem, i ) {
			return callback.call( elem, i, elem );
		} ) );
	},

	slice: function() {
		return this.pushStack( slice.apply( this, arguments ) );
	},

	first: function() {
		return this.eq( 0 );
	},

	last: function() {
		return this.eq( -1 );
	},

	even: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return ( i + 1 ) % 2;
		} ) );
	},

	odd: function() {
		return this.pushStack( jQuery.grep( this, function( _elem, i ) {
			return i % 2;
		} ) );
	},

	eq: function( i ) {
		var len = this.length,
			j = +i + ( i < 0 ? len : 0 );
		return this.pushStack( j >= 0 && j < len ? [ this[ j ] ] : [] );
	},

	end: function() {
		return this.prevObject || this.constructor();
	},

	// For internal use only.
	// Behaves like an Array's method, not like a jQuery method.
	push: push,
	sort: arr.sort,
	splice: arr.splice
};

jQuery.extend = jQuery.fn.extend = function() {
	var options, name, src, copy, copyIsArray, clone,
		target = arguments[ 0 ] || {},
		i = 1,
		length = arguments.length,
		deep = false;

	// Handle a deep copy situation
	if ( typeof target === "boolean" ) {
		deep = target;

		// Skip the boolean and the target
		target = arguments[ i ] || {};
		i++;
	}

	// Handle case when target is a string or something (possible in deep copy)
	if ( typeof target !== "object" && !isFunction( target ) ) {
		target = {};
	}

	// Extend jQuery itself if only one argument is passed
	if ( i === length ) {
		target = this;
		i--;
	}

	for ( ; i < length; i++ ) {

		// Only deal with non-null/undefined values
		if ( ( options = arguments[ i ] ) != null ) {

			// Extend the base object
			for ( name in options ) {
				copy = options[ name ];

				// Prevent Object.prototype pollution
				// Prevent never-ending loop
				if ( name === "__proto__" || target === copy ) {
					continue;
				}

				// Recurse if we're merging plain objects or arrays
				if ( deep && copy && ( jQuery.isPlainObject( copy ) ||
					( copyIsArray = Array.isArray( copy ) ) ) ) {
					src = target[ name ];

					// Ensure proper type for the source value
					if ( copyIsArray && !Array.isArray( src ) ) {
						clone = [];
					} else if ( !copyIsArray && !jQuery.isPlainObject( src ) ) {
						clone = {};
					} else {
						clone = src;
					}
					copyIsArray = false;

					// Never move original objects, clone them
					target[ name ] = jQuery.extend( deep, clone, copy );

				// Don't bring in undefined values
				} else if ( copy !== undefined ) {
					target[ name ] = copy;
				}
			}
		}
	}

	// Return the modified object
	return target;
};

jQuery.extend( {

	// Unique for each copy of jQuery on the page
	expando: "jQuery" + ( version + Math.random() ).replace( /\D/g, "" ),

	// Assume jQuery is ready without the ready module
	isReady: true,

	error: function( msg ) {
		throw new Error( msg );
	},

	noop: function() {},

	isPlainObject: function( obj ) {
		var proto, Ctor;

		// Detect obvious negatives
		// Use toString instead of jQuery.type to catch host objects
		if ( !obj || toString.call( obj ) !== "[object Object]" ) {
			return false;
		}

		proto = getProto( obj );

		// Objects with no prototype (e.g., `Object.create( null )`) are plain
		if ( !proto ) {
			return true;
		}

		// Objects with prototype are plain iff they were constructed by a global Object function
		Ctor = hasOwn.call( proto, "constructor" ) && proto.constructor;
		return typeof Ctor === "function" && fnToString.call( Ctor ) === ObjectFunctionString;
	},

	isEmptyObject: function( obj ) {
		var name;

		for ( name in obj ) {
			return false;
		}
		return true;
	},

	// Evaluates a script in a provided context; falls back to the global one
	// if not specified.
	globalEval: function( code, options, doc ) {
		DOMEval( code, { nonce: options && options.nonce }, doc );
	},

	each: function( obj, callback ) {
		var length, i = 0;

		if ( isArrayLike( obj ) ) {
			length = obj.length;
			for ( ; i < length; i++ ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		} else {
			for ( i in obj ) {
				if ( callback.call( obj[ i ], i, obj[ i ] ) === false ) {
					break;
				}
			}
		}

		return obj;
	},

	// results is for internal usage only
	makeArray: function( arr, results ) {
		var ret = results || [];

		if ( arr != null ) {
			if ( isArrayLike( Object( arr ) ) ) {
				jQuery.merge( ret,
					typeof arr === "string" ?
						[ arr ] : arr
				);
			} else {
				push.call( ret, arr );
			}
		}

		return ret;
	},

	inArray: function( elem, arr, i ) {
		return arr == null ? -1 : indexOf.call( arr, elem, i );
	},

	// Support: Android <=4.0 only, PhantomJS 1 only
	// push.apply(_, arraylike) throws on ancient WebKit
	merge: function( first, second ) {
		var len = +second.length,
			j = 0,
			i = first.length;

		for ( ; j < len; j++ ) {
			first[ i++ ] = second[ j ];
		}

		first.length = i;

		return first;
	},

	grep: function( elems, callback, invert ) {
		var callbackInverse,
			matches = [],
			i = 0,
			length = elems.length,
			callbackExpect = !invert;

		// Go through the array, only saving the items
		// that pass the validator function
		for ( ; i < length; i++ ) {
			callbackInverse = !callback( elems[ i ], i );
			if ( callbackInverse !== callbackExpect ) {
				matches.push( elems[ i ] );
			}
		}

		return matches;
	},

	// arg is for internal usage only
	map: function( elems, callback, arg ) {
		var length, value,
			i = 0,
			ret = [];

		// Go through the array, translating each of the items to their new values
		if ( isArrayLike( elems ) ) {
			length = elems.length;
			for ( ; i < length; i++ ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}

		// Go through every key on the object,
		} else {
			for ( i in elems ) {
				value = callback( elems[ i ], i, arg );

				if ( value != null ) {
					ret.push( value );
				}
			}
		}

		// Flatten any nested arrays
		return flat( ret );
	},

	// A global GUID counter for objects
	guid: 1,

	// jQuery.support is not used in Core but other projects attach their
	// properties to it so it needs to exist.
	support: support
} );

if ( typeof Symbol === "function" ) {
	jQuery.fn[ Symbol.iterator ] = arr[ Symbol.iterator ];
}

// Populate the class2type map
jQuery.each( "Boolean Number String Function Array Date RegExp Object Error Symbol".split( " " ),
	function( _i, name ) {
		class2type[ "[object " + name + "]" ] = name.toLowerCase();
	} );

function isArrayLike( obj ) {

	// Support: real iOS 8.2 only (not reproducible in simulator)
	// `in` check used to prevent JIT error (gh-2145)
	// hasOwn isn't used here due to false negatives
	// regarding Nodelist length in IE
	var length = !!obj && "length" in obj && obj.length,
		type = toType( obj );

	if ( isFunction( obj ) || isWindow( obj ) ) {
		return false;
	}

	return type === "array" || length === 0 ||
		typeof length === "number" && length > 0 && ( length - 1 ) in obj;
}
var Sizzle =
/*!
 * Sizzle CSS Selector Engine v2.3.6
 * https://sizzlejs.com/
 *
 * Copyright JS Foundation and other contributors
 * Released under the MIT license
 * https://js.foundation/
 *
 * Date: 2021-02-16
 */
( function( window ) {
var i,
	support,
	Expr,
	getText,
	isXML,
	tokenize,
	compile,
	select,
	outermostContext,
	sortInput,
	hasDuplicate,

	// Local document vars
	setDocument,
	document,
	docElem,
	documentIsHTML,
	rbuggyQSA,
	rbuggyMatches,
	matches,
	contains,

	// Instance-specific data
	expando = "sizzle" + 1 * new Date(),
	preferredDoc = window.document,
	dirruns = 0,
	done = 0,
	classCache = createCache(),
	tokenCache = createCache(),
	compilerCache = createCache(),
	nonnativeSelectorCache = createCache(),
	sortOrder = function( a, b ) {
		if ( a === b ) {
			hasDuplicate = true;
		}
		return 0;
	},

	// Instance methods
	hasOwn = ( {} ).hasOwnProperty,
	arr = [],
	pop = arr.pop,
	pushNative = arr.push,
	push = arr.push,
	slice = arr.slice,

	// Use a stripped-down indexOf as it's faster than native
	// https://jsperf.com/thor-indexof-vs-for/5
	indexOf = function( list, elem ) {
		var i = 0,
			len = list.length;
		for ( ; i < len; i++ ) {
			if ( list[ i ] === elem ) {
				return i;
			}
		}
		return -1;
	},

	booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|" +
		"ismap|loop|multiple|open|readonly|required|scoped",

	// Regular expressions

	// http://www.w3.org/TR/css3-selectors/#whitespace
	whitespace = "[\\x20\\t\\r\\n\\f]",

	// https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
	identifier = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace +
		"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",

	// Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
	attributes = "\\[" + whitespace + "*(" + identifier + ")(?:" + whitespace +

		// Operator (capture 2)
		"*([*^$|!~]?=)" + whitespace +

		// "Attribute values must be CSS identifiers [capture 5]
		// or strings [capture 3 or capture 4]"
		"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + identifier + "))|)" +
		whitespace + "*\\]",

	pseudos = ":(" + identifier + ")(?:\\((" +

		// To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
		// 1. quoted (capture 3; capture 4 or capture 5)
		"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +

		// 2. simple (capture 6)
		"((?:\\\\.|[^\\\\()[\\]]|" + attributes + ")*)|" +

		// 3. anything else (capture 2)
		".*" +
		")\\)|)",

	// Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
	rwhitespace = new RegExp( whitespace + "+", "g" ),
	rtrim = new RegExp( "^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" +
		whitespace + "+$", "g" ),

	rcomma = new RegExp( "^" + whitespace + "*," + whitespace + "*" ),
	rcombinators = new RegExp( "^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace +
		"*" ),
	rdescend = new RegExp( whitespace + "|>" ),

	rpseudo = new RegExp( pseudos ),
	ridentifier = new RegExp( "^" + identifier + "$" ),

	matchExpr = {
		"ID": new RegExp( "^#(" + identifier + ")" ),
		"CLASS": new RegExp( "^\\.(" + identifier + ")" ),
		"TAG": new RegExp( "^(" + identifier + "|[*])" ),
		"ATTR": new RegExp( "^" + attributes ),
		"PSEUDO": new RegExp( "^" + pseudos ),
		"CHILD": new RegExp( "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
			whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" +
			whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i" ),
		"bool": new RegExp( "^(?:" + booleans + ")$", "i" ),

		// For use in libraries implementing .is()
		// We use this for POS matching in `select`
		"needsContext": new RegExp( "^" + whitespace +
			"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace +
			"*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i" )
	},

	rhtml = /HTML$/i,
	rinputs = /^(?:input|select|textarea|button)$/i,
	rheader = /^h\d$/i,

	rnative = /^[^{]+\{\s*\[native \w/,

	// Easily-parseable/retrievable ID or TAG or CLASS selectors
	rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,

	rsibling = /[+~]/,

	// CSS escapes
	// http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
	runescape = new RegExp( "\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\([^\\r\\n\\f])", "g" ),
	funescape = function( escape, nonHex ) {
		var high = "0x" + escape.slice( 1 ) - 0x10000;

		return nonHex ?

			// Strip the backslash prefix from a non-hex escape sequence
			nonHex :

			// Replace a hexadecimal escape sequence with the encoded Unicode code point
			// Support: IE <=11+
			// For values outside the Basic Multilingual Plane (BMP), manually construct a
			// surrogate pair
			high < 0 ?
				String.fromCharCode( high + 0x10000 ) :
				String.fromCharCode( high >> 10 | 0xD800, high & 0x3FF | 0xDC00 );
	},

	// CSS string/identifier serialization
	// https://drafts.csswg.org/cssom/#common-serializing-idioms
	rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
	fcssescape = function( ch, asCodePoint ) {
		if ( asCodePoint ) {

			// U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
			if ( ch === "\0" ) {
				return "\uFFFD";
			}

			// Control characters and (dependent upon position) numbers get escaped as code points
			return ch.slice( 0, -1 ) + "\\" +
				ch.charCodeAt( ch.length - 1 ).toString( 16 ) + " ";
		}

		// Other potentially-special ASCII characters get backslash-escaped
		return "\\" + ch;
	},

	// Used for iframes
	// See setDocument()
	// Removing the function wrapper causes a "Permission Denied"
	// error in IE
	unloadHandler = function() {
		setDocument();
	},

	inDisabledFieldset = addCombinator(
		function( elem ) {
			return elem.disabled === true && elem.nodeName.toLowerCase() === "fieldset";
		},
		{ dir: "parentNode", next: "legend" }
	);

// Optimize for push.apply( _, NodeList )
try {
	push.apply(
		( arr = slice.call( preferredDoc.childNodes ) ),
		preferredDoc.childNodes
	);

	// Support: Android<4.0
	// Detect silently failing push.apply
	// eslint-disable-next-line no-unused-expressions
	arr[ preferredDoc.childNodes.length ].nodeType;
} catch ( e ) {
	push = { apply: arr.length ?

		// Leverage slice if possible
		function( target, els ) {
			pushNative.apply( target, slice.call( els ) );
		} :

		// Support: IE<9
		// Otherwise append directly
		function( target, els ) {
			var j = target.length,
				i = 0;

			// Can't trust NodeList.length
			while ( ( target[ j++ ] = els[ i++ ] ) ) {}
			target.length = j - 1;
		}
	};
}

function Sizzle( selector, context, results, seed ) {
	var m, i, elem, nid, match, groups, newSelector,
		newContext = context && context.ownerDocument,

		// nodeType defaults to 9, since context defaults to document
		nodeType = context ? context.nodeType : 9;

	results = results || [];

	// Return early from calls with invalid selector or context
	if ( typeof selector !== "string" || !selector ||
		nodeType !== 1 && nodeType !== 9 && nodeType !== 11 ) {

		return results;
	}

	// Try to shortcut find operations (as opposed to filters) in HTML documents
	if ( !seed ) {
		setDocument( context );
		context = context || document;

		if ( documentIsHTML ) {

			// If the selector is sufficiently simple, try using a "get*By*" DOM method
			// (excepting DocumentFragment context, where the methods don't exist)
			if ( nodeType !== 11 && ( match = rquickExpr.exec( selector ) ) ) {

				// ID selector
				if ( ( m = match[ 1 ] ) ) {

					// Document context
					if ( nodeType === 9 ) {
						if ( ( elem = context.getElementById( m ) ) ) {

							// Support: IE, Opera, Webkit
							// TODO: identify versions
							// getElementById can match elements by name instead of ID
							if ( elem.id === m ) {
								results.push( elem );
								return results;
							}
						} else {
							return results;
						}

					// Element context
					} else {

						// Support: IE, Opera, Webkit
						// TODO: identify versions
						// getElementById can match elements by name instead of ID
						if ( newContext && ( elem = newContext.getElementById( m ) ) &&
							contains( context, elem ) &&
							elem.id === m ) {

							results.push( elem );
							return results;
						}
					}

				// Type selector
				} else if ( match[ 2 ] ) {
					push.apply( results, context.getElementsByTagName( selector ) );
					return results;

				// Class selector
				} else if ( ( m = match[ 3 ] ) && support.getElementsByClassName &&
					context.getElementsByClassName ) {

					push.apply( results, context.getElementsByClassName( m ) );
					return results;
				}
			}

			// Take advantage of querySelectorAll
			if ( support.qsa &&
				!nonnativeSelectorCache[ selector + " " ] &&
				( !rbuggyQSA || !rbuggyQSA.test( selector ) ) &&

				// Support: IE 8 only
				// Exclude object elements
				( nodeType !== 1 || context.nodeName.toLowerCase() !== "object" ) ) {

				newSelector = selector;
				newContext = context;

				// qSA considers elements outside a scoping root when evaluating child or
				// descendant combinators, which is not what we want.
				// In such cases, we work around the behavior by prefixing every selector in the
				// list with an ID selector referencing the scope context.
				// The technique has to be used as well when a leading combinator is used
				// as such selectors are not recognized by querySelectorAll.
				// Thanks to Andrew Dupont for this technique.
				if ( nodeType === 1 &&
					( rdescend.test( selector ) || rcombinators.test( selector ) ) ) {

					// Expand context for sibling selectors
					newContext = rsibling.test( selector ) && testContext( context.parentNode ) ||
						context;

					// We can use :scope instead of the ID hack if the browser
					// supports it & if we're not changing the context.
					if ( newContext !== context || !support.scope ) {

						// Capture the context ID, setting it first if necessary
						if ( ( nid = context.getAttribute( "id" ) ) ) {
							nid = nid.replace( rcssescape, fcssescape );
						} else {
							context.setAttribute( "id", ( nid = expando ) );
						}
					}

					// Prefix every selector in the list
					groups = tokenize( selector );
					i = groups.length;
					while ( i-- ) {
						groups[ i ] = ( nid ? "#" + nid : ":scope" ) + " " +
							toSelector( groups[ i ] );
					}
					newSelector = groups.join( "," );
				}

				try {
					push.apply( results,
						newContext.querySelectorAll( newSelector )
					);
					return results;
				} catch ( qsaError ) {
					nonnativeSelectorCache( selector, true );
				} finally {
					if ( nid === expando ) {
						context.removeAttribute( "id" );
					}
				}
			}
		}
	}

	// All others
	return select( selector.replace( rtrim, "$1" ), context, results, seed );
}

/**
 * Create key-value caches of limited size
 * @returns {function(string, object)} Returns the Object data after storing it on itself with
 *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
 *	deleting the oldest entry
 */
function createCache() {
	var keys = [];

	function cache( key, value ) {

		// Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
		if ( keys.push( key + " " ) > Expr.cacheLength ) {

			// Only keep the most recent entries
			delete cache[ keys.shift() ];
		}
		return ( cache[ key + " " ] = value );
	}
	return cache;
}

/**
 * Mark a function for special use by Sizzle
 * @param {Function} fn The function to mark
 */
function markFunction( fn ) {
	fn[ expando ] = true;
	return fn;
}

/**
 * Support testing using an element
 * @param {Function} fn Passed the created element and returns a boolean result
 */
function assert( fn ) {
	var el = document.createElement( "fieldset" );

	try {
		return !!fn( el );
	} catch ( e ) {
		return false;
	} finally {

		// Remove from its parent by default
		if ( el.parentNode ) {
			el.parentNode.removeChild( el );
		}

		// release memory in IE
		el = null;
	}
}

/**
 * Adds the same handler for all of the specified attrs
 * @param {String} attrs Pipe-separated list of attributes
 * @param {Function} handler The method that will be applied
 */
function addHandle( attrs, handler ) {
	var arr = attrs.split( "|" ),
		i = arr.length;

	while ( i-- ) {
		Expr.attrHandle[ arr[ i ] ] = handler;
	}
}

/**
 * Checks document order of two siblings
 * @param {Element} a
 * @param {Element} b
 * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
 */
function siblingCheck( a, b ) {
	var cur = b && a,
		diff = cur && a.nodeType === 1 && b.nodeType === 1 &&
			a.sourceIndex - b.sourceIndex;

	// Use IE sourceIndex if available on both nodes
	if ( diff ) {
		return diff;
	}

	// Check if b follows a
	if ( cur ) {
		while ( ( cur = cur.nextSibling ) ) {
			if ( cur === b ) {
				return -1;
			}
		}
	}

	return a ? 1 : -1;
}

/**
 * Returns a function to use in pseudos for input types
 * @param {String} type
 */
function createInputPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return name === "input" && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for buttons
 * @param {String} type
 */
function createButtonPseudo( type ) {
	return function( elem ) {
		var name = elem.nodeName.toLowerCase();
		return ( name === "input" || name === "button" ) && elem.type === type;
	};
}

/**
 * Returns a function to use in pseudos for :enabled/:disabled
 * @param {Boolean} disabled true for :disabled; false for :enabled
 */
function createDisabledPseudo( disabled ) {

	// Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
	return function( elem ) {

		// Only certain elements can match :enabled or :disabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
		// https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
		if ( "form" in elem ) {

			// Check for inherited disabledness on relevant non-disabled elements:
			// * listed form-associated elements in a disabled fieldset
			//   https://html.spec.whatwg.org/multipage/forms.html#category-listed
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
			// * option elements in a disabled optgroup
			//   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
			// All such elements have a "form" property.
			if ( elem.parentNode && elem.disabled === false ) {

				// Option elements defer to a parent optgroup if present
				if ( "label" in elem ) {
					if ( "label" in elem.parentNode ) {
						return elem.parentNode.disabled === disabled;
					} else {
						return elem.disabled === disabled;
					}
				}

				// Support: IE 6 - 11
				// Use the isDisabled shortcut property to check for disabled fieldset ancestors
				return elem.isDisabled === disabled ||

					// Where there is no isDisabled, check manually
					/* jshint -W018 */
					elem.isDisabled !== !disabled &&
					inDisabledFieldset( elem ) === disabled;
			}

			return elem.disabled === disabled;

		// Try to winnow out elements that can't be disabled before trusting the disabled property.
		// Some victims get caught in our net (label, legend, menu, track), but it shouldn't
		// even exist on them, let alone have a boolean value.
		} else if ( "label" in elem ) {
			return elem.disabled === disabled;
		}

		// Remaining elements are neither :enabled nor :disabled
		return false;
	};
}

/**
 * Returns a function to use in pseudos for positionals
 * @param {Function} fn
 */
function createPositionalPseudo( fn ) {
	return markFunction( function( argument ) {
		argument = +argument;
		return markFunction( function( seed, matches ) {
			var j,
				matchIndexes = fn( [], seed.length, argument ),
				i = matchIndexes.length;

			// Match elements found at the specified indexes
			while ( i-- ) {
				if ( seed[ ( j = matchIndexes[ i ] ) ] ) {
					seed[ j ] = !( matches[ j ] = seed[ j ] );
				}
			}
		} );
	} );
}

/**
 * Checks a node for validity as a Sizzle context
 * @param {Element|Object=} context
 * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
 */
function testContext( context ) {
	return context && typeof context.getElementsByTagName !== "undefined" && context;
}

// Expose support vars for convenience
support = Sizzle.support = {};

/**
 * Detects XML nodes
 * @param {Element|Object} elem An element or a document
 * @returns {Boolean} True iff elem is a non-HTML XML node
 */
isXML = Sizzle.isXML = function( elem ) {
	var namespace = elem && elem.namespaceURI,
		docElem = elem && ( elem.ownerDocument || elem ).documentElement;

	// Support: IE <=8
	// Assume HTML when documentElement doesn't yet exist, such as inside loading iframes
	// https://bugs.jquery.com/ticket/4833
	return !rhtml.test( namespace || docElem && docElem.nodeName || "HTML" );
};

/**
 * Sets document-related variables once based on the current document
 * @param {Element|Object} [doc] An element or document object to use to set the document
 * @returns {Object} Returns the current document
 */
setDocument = Sizzle.setDocument = function( node ) {
	var hasCompare, subWindow,
		doc = node ? node.ownerDocument || node : preferredDoc;

	// Return early if doc is invalid or already selected
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( doc == document || doc.nodeType !== 9 || !doc.documentElement ) {
		return document;
	}

	// Update global variables
	document = doc;
	docElem = document.documentElement;
	documentIsHTML = !isXML( document );

	// Support: IE 9 - 11+, Edge 12 - 18+
	// Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( preferredDoc != document &&
		( subWindow = document.defaultView ) && subWindow.top !== subWindow ) {

		// Support: IE 11, Edge
		if ( subWindow.addEventListener ) {
			subWindow.addEventListener( "unload", unloadHandler, false );

		// Support: IE 9 - 10 only
		} else if ( subWindow.attachEvent ) {
			subWindow.attachEvent( "onunload", unloadHandler );
		}
	}

	// Support: IE 8 - 11+, Edge 12 - 18+, Chrome <=16 - 25 only, Firefox <=3.6 - 31 only,
	// Safari 4 - 5 only, Opera <=11.6 - 12.x only
	// IE/Edge & older browsers don't support the :scope pseudo-class.
	// Support: Safari 6.0 only
	// Safari 6.0 supports :scope but it's an alias of :root there.
	support.scope = assert( function( el ) {
		docElem.appendChild( el ).appendChild( document.createElement( "div" ) );
		return typeof el.querySelectorAll !== "undefined" &&
			!el.querySelectorAll( ":scope fieldset div" ).length;
	} );

	/* Attributes
	---------------------------------------------------------------------- */

	// Support: IE<8
	// Verify that getAttribute really returns attributes and not properties
	// (excepting IE8 booleans)
	support.attributes = assert( function( el ) {
		el.className = "i";
		return !el.getAttribute( "className" );
	} );

	/* getElement(s)By*
	---------------------------------------------------------------------- */

	// Check if getElementsByTagName("*") returns only elements
	support.getElementsByTagName = assert( function( el ) {
		el.appendChild( document.createComment( "" ) );
		return !el.getElementsByTagName( "*" ).length;
	} );

	// Support: IE<9
	support.getElementsByClassName = rnative.test( document.getElementsByClassName );

	// Support: IE<10
	// Check if getElementById returns elements by name
	// The broken getElementById methods don't pick up programmatically-set names,
	// so use a roundabout getElementsByName test
	support.getById = assert( function( el ) {
		docElem.appendChild( el ).id = expando;
		return !document.getElementsByName || !document.getElementsByName( expando ).length;
	} );

	// ID filter and find
	if ( support.getById ) {
		Expr.filter[ "ID" ] = function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				return elem.getAttribute( "id" ) === attrId;
			};
		};
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var elem = context.getElementById( id );
				return elem ? [ elem ] : [];
			}
		};
	} else {
		Expr.filter[ "ID" ] =  function( id ) {
			var attrId = id.replace( runescape, funescape );
			return function( elem ) {
				var node = typeof elem.getAttributeNode !== "undefined" &&
					elem.getAttributeNode( "id" );
				return node && node.value === attrId;
			};
		};

		// Support: IE 6 - 7 only
		// getElementById is not reliable as a find shortcut
		Expr.find[ "ID" ] = function( id, context ) {
			if ( typeof context.getElementById !== "undefined" && documentIsHTML ) {
				var node, i, elems,
					elem = context.getElementById( id );

				if ( elem ) {

					// Verify the id attribute
					node = elem.getAttributeNode( "id" );
					if ( node && node.value === id ) {
						return [ elem ];
					}

					// Fall back on getElementsByName
					elems = context.getElementsByName( id );
					i = 0;
					while ( ( elem = elems[ i++ ] ) ) {
						node = elem.getAttributeNode( "id" );
						if ( node && node.value === id ) {
							return [ elem ];
						}
					}
				}

				return [];
			}
		};
	}

	// Tag
	Expr.find[ "TAG" ] = support.getElementsByTagName ?
		function( tag, context ) {
			if ( typeof context.getElementsByTagName !== "undefined" ) {
				return context.getElementsByTagName( tag );

			// DocumentFragment nodes don't have gEBTN
			} else if ( support.qsa ) {
				return context.querySelectorAll( tag );
			}
		} :

		function( tag, context ) {
			var elem,
				tmp = [],
				i = 0,

				// By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
				results = context.getElementsByTagName( tag );

			// Filter out possible comments
			if ( tag === "*" ) {
				while ( ( elem = results[ i++ ] ) ) {
					if ( elem.nodeType === 1 ) {
						tmp.push( elem );
					}
				}

				return tmp;
			}
			return results;
		};

	// Class
	Expr.find[ "CLASS" ] = support.getElementsByClassName && function( className, context ) {
		if ( typeof context.getElementsByClassName !== "undefined" && documentIsHTML ) {
			return context.getElementsByClassName( className );
		}
	};

	/* QSA/matchesSelector
	---------------------------------------------------------------------- */

	// QSA and matchesSelector support

	// matchesSelector(:active) reports false when true (IE9/Opera 11.5)
	rbuggyMatches = [];

	// qSa(:focus) reports false when true (Chrome 21)
	// We allow this because of a bug in IE8/9 that throws an error
	// whenever `document.activeElement` is accessed on an iframe
	// So, we allow :focus to pass through QSA all the time to avoid the IE error
	// See https://bugs.jquery.com/ticket/13378
	rbuggyQSA = [];

	if ( ( support.qsa = rnative.test( document.querySelectorAll ) ) ) {

		// Build QSA regex
		// Regex strategy adopted from Diego Perini
		assert( function( el ) {

			var input;

			// Select is set to empty string on purpose
			// This is to test IE's treatment of not explicitly
			// setting a boolean content attribute,
			// since its presence should be enough
			// https://bugs.jquery.com/ticket/12359
			docElem.appendChild( el ).innerHTML = "<a id='" + expando + "'></a>" +
				"<select id='" + expando + "-\r\\' msallowcapture=''>" +
				"<option selected=''></option></select>";

			// Support: IE8, Opera 11-12.16
			// Nothing should be selected when empty strings follow ^= or $= or *=
			// The test attribute must be unknown in Opera but "safe" for WinRT
			// https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
			if ( el.querySelectorAll( "[msallowcapture^='']" ).length ) {
				rbuggyQSA.push( "[*^$]=" + whitespace + "*(?:''|\"\")" );
			}

			// Support: IE8
			// Boolean attributes and "value" are not treated correctly
			if ( !el.querySelectorAll( "[selected]" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*(?:value|" + booleans + ")" );
			}

			// Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
			if ( !el.querySelectorAll( "[id~=" + expando + "-]" ).length ) {
				rbuggyQSA.push( "~=" );
			}

			// Support: IE 11+, Edge 15 - 18+
			// IE 11/Edge don't find elements on a `[name='']` query in some cases.
			// Adding a temporary attribute to the document before the selection works
			// around the issue.
			// Interestingly, IE 10 & older don't seem to have the issue.
			input = document.createElement( "input" );
			input.setAttribute( "name", "" );
			el.appendChild( input );
			if ( !el.querySelectorAll( "[name='']" ).length ) {
				rbuggyQSA.push( "\\[" + whitespace + "*name" + whitespace + "*=" +
					whitespace + "*(?:''|\"\")" );
			}

			// Webkit/Opera - :checked should return selected option elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			// IE8 throws error here and will not see later tests
			if ( !el.querySelectorAll( ":checked" ).length ) {
				rbuggyQSA.push( ":checked" );
			}

			// Support: Safari 8+, iOS 8+
			// https://bugs.webkit.org/show_bug.cgi?id=136851
			// In-page `selector#id sibling-combinator selector` fails
			if ( !el.querySelectorAll( "a#" + expando + "+*" ).length ) {
				rbuggyQSA.push( ".#.+[+~]" );
			}

			// Support: Firefox <=3.6 - 5 only
			// Old Firefox doesn't throw on a badly-escaped identifier.
			el.querySelectorAll( "\\\f" );
			rbuggyQSA.push( "[\\r\\n\\f]" );
		} );

		assert( function( el ) {
			el.innerHTML = "<a href='' disabled='disabled'></a>" +
				"<select disabled='disabled'><option/></select>";

			// Support: Windows 8 Native Apps
			// The type and name attributes are restricted during .innerHTML assignment
			var input = document.createElement( "input" );
			input.setAttribute( "type", "hidden" );
			el.appendChild( input ).setAttribute( "name", "D" );

			// Support: IE8
			// Enforce case-sensitivity of name attribute
			if ( el.querySelectorAll( "[name=d]" ).length ) {
				rbuggyQSA.push( "name" + whitespace + "*[*^$|!~]?=" );
			}

			// FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
			// IE8 throws error here and will not see later tests
			if ( el.querySelectorAll( ":enabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: IE9-11+
			// IE's :disabled selector does not pick up the children of disabled fieldsets
			docElem.appendChild( el ).disabled = true;
			if ( el.querySelectorAll( ":disabled" ).length !== 2 ) {
				rbuggyQSA.push( ":enabled", ":disabled" );
			}

			// Support: Opera 10 - 11 only
			// Opera 10-11 does not throw on post-comma invalid pseudos
			el.querySelectorAll( "*,:x" );
			rbuggyQSA.push( ",.*:" );
		} );
	}

	if ( ( support.matchesSelector = rnative.test( ( matches = docElem.matches ||
		docElem.webkitMatchesSelector ||
		docElem.mozMatchesSelector ||
		docElem.oMatchesSelector ||
		docElem.msMatchesSelector ) ) ) ) {

		assert( function( el ) {

			// Check to see if it's possible to do matchesSelector
			// on a disconnected node (IE 9)
			support.disconnectedMatch = matches.call( el, "*" );

			// This should fail with an exception
			// Gecko does not error, returns false instead
			matches.call( el, "[s!='']:x" );
			rbuggyMatches.push( "!=", pseudos );
		} );
	}

	rbuggyQSA = rbuggyQSA.length && new RegExp( rbuggyQSA.join( "|" ) );
	rbuggyMatches = rbuggyMatches.length && new RegExp( rbuggyMatches.join( "|" ) );

	/* Contains
	---------------------------------------------------------------------- */
	hasCompare = rnative.test( docElem.compareDocumentPosition );

	// Element contains another
	// Purposefully self-exclusive
	// As in, an element does not contain itself
	contains = hasCompare || rnative.test( docElem.contains ) ?
		function( a, b ) {
			var adown = a.nodeType === 9 ? a.documentElement : a,
				bup = b && b.parentNode;
			return a === bup || !!( bup && bup.nodeType === 1 && (
				adown.contains ?
					adown.contains( bup ) :
					a.compareDocumentPosition && a.compareDocumentPosition( bup ) & 16
			) );
		} :
		function( a, b ) {
			if ( b ) {
				while ( ( b = b.parentNode ) ) {
					if ( b === a ) {
						return true;
					}
				}
			}
			return false;
		};

	/* Sorting
	---------------------------------------------------------------------- */

	// Document order sorting
	sortOrder = hasCompare ?
	function( a, b ) {

		// Flag for duplicate removal
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		// Sort on method existence if only one input has compareDocumentPosition
		var compare = !a.compareDocumentPosition - !b.compareDocumentPosition;
		if ( compare ) {
			return compare;
		}

		// Calculate position if both inputs belong to the same document
		// Support: IE 11+, Edge 17 - 18+
		// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
		// two documents; shallow comparisons work.
		// eslint-disable-next-line eqeqeq
		compare = ( a.ownerDocument || a ) == ( b.ownerDocument || b ) ?
			a.compareDocumentPosition( b ) :

			// Otherwise we know they are disconnected
			1;

		// Disconnected nodes
		if ( compare & 1 ||
			( !support.sortDetached && b.compareDocumentPosition( a ) === compare ) ) {

			// Choose the first element that is related to our preferred document
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( a == document || a.ownerDocument == preferredDoc &&
				contains( preferredDoc, a ) ) {
				return -1;
			}

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			// eslint-disable-next-line eqeqeq
			if ( b == document || b.ownerDocument == preferredDoc &&
				contains( preferredDoc, b ) ) {
				return 1;
			}

			// Maintain original order
			return sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;
		}

		return compare & 4 ? -1 : 1;
	} :
	function( a, b ) {

		// Exit early if the nodes are identical
		if ( a === b ) {
			hasDuplicate = true;
			return 0;
		}

		var cur,
			i = 0,
			aup = a.parentNode,
			bup = b.parentNode,
			ap = [ a ],
			bp = [ b ];

		// Parentless nodes are either documents or disconnected
		if ( !aup || !bup ) {

			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			return a == document ? -1 :
				b == document ? 1 :
				/* eslint-enable eqeqeq */
				aup ? -1 :
				bup ? 1 :
				sortInput ?
				( indexOf( sortInput, a ) - indexOf( sortInput, b ) ) :
				0;

		// If the nodes are siblings, we can do a quick check
		} else if ( aup === bup ) {
			return siblingCheck( a, b );
		}

		// Otherwise we need full lists of their ancestors for comparison
		cur = a;
		while ( ( cur = cur.parentNode ) ) {
			ap.unshift( cur );
		}
		cur = b;
		while ( ( cur = cur.parentNode ) ) {
			bp.unshift( cur );
		}

		// Walk down the tree looking for a discrepancy
		while ( ap[ i ] === bp[ i ] ) {
			i++;
		}

		return i ?

			// Do a sibling check if the nodes have a common ancestor
			siblingCheck( ap[ i ], bp[ i ] ) :

			// Otherwise nodes in our document sort first
			// Support: IE 11+, Edge 17 - 18+
			// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
			// two documents; shallow comparisons work.
			/* eslint-disable eqeqeq */
			ap[ i ] == preferredDoc ? -1 :
			bp[ i ] == preferredDoc ? 1 :
			/* eslint-enable eqeqeq */
			0;
	};

	return document;
};

Sizzle.matches = function( expr, elements ) {
	return Sizzle( expr, null, null, elements );
};

Sizzle.matchesSelector = function( elem, expr ) {
	setDocument( elem );

	if ( support.matchesSelector && documentIsHTML &&
		!nonnativeSelectorCache[ expr + " " ] &&
		( !rbuggyMatches || !rbuggyMatches.test( expr ) ) &&
		( !rbuggyQSA     || !rbuggyQSA.test( expr ) ) ) {

		try {
			var ret = matches.call( elem, expr );

			// IE 9's matchesSelector returns false on disconnected nodes
			if ( ret || support.disconnectedMatch ||

				// As well, disconnected nodes are said to be in a document
				// fragment in IE 9
				elem.document && elem.document.nodeType !== 11 ) {
				return ret;
			}
		} catch ( e ) {
			nonnativeSelectorCache( expr, true );
		}
	}

	return Sizzle( expr, document, null, [ elem ] ).length > 0;
};

Sizzle.contains = function( context, elem ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( context.ownerDocument || context ) != document ) {
		setDocument( context );
	}
	return contains( context, elem );
};

Sizzle.attr = function( elem, name ) {

	// Set document vars if needed
	// Support: IE 11+, Edge 17 - 18+
	// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
	// two documents; shallow comparisons work.
	// eslint-disable-next-line eqeqeq
	if ( ( elem.ownerDocument || elem ) != document ) {
		setDocument( elem );
	}

	var fn = Expr.attrHandle[ name.toLowerCase() ],

		// Don't get fooled by Object.prototype properties (jQuery #13807)
		val = fn && hasOwn.call( Expr.attrHandle, name.toLowerCase() ) ?
			fn( elem, name, !documentIsHTML ) :
			undefined;

	return val !== undefined ?
		val :
		support.attributes || !documentIsHTML ?
			elem.getAttribute( name ) :
			( val = elem.getAttributeNode( name ) ) && val.specified ?
				val.value :
				null;
};

Sizzle.escape = function( sel ) {
	return ( sel + "" ).replace( rcssescape, fcssescape );
};

Sizzle.error = function( msg ) {
	throw new Error( "Syntax error, unrecognized expression: " + msg );
};

/**
 * Document sorting and removing duplicates
 * @param {ArrayLike} results
 */
Sizzle.uniqueSort = function( results ) {
	var elem,
		duplicates = [],
		j = 0,
		i = 0;

	// Unless we *know* we can detect duplicates, assume their presence
	hasDuplicate = !support.detectDuplicates;
	sortInput = !support.sortStable && results.slice( 0 );
	results.sort( sortOrder );

	if ( hasDuplicate ) {
		while ( ( elem = results[ i++ ] ) ) {
			if ( elem === results[ i ] ) {
				j = duplicates.push( i );
			}
		}
		while ( j-- ) {
			results.splice( duplicates[ j ], 1 );
		}
	}

	// Clear input after sorting to release objects
	// See https://github.com/jquery/sizzle/pull/225
	sortInput = null;

	return results;
};

/**
 * Utility function for retrieving the text value of an array of DOM nodes
 * @param {Array|Element} elem
 */
getText = Sizzle.getText = function( elem ) {
	var node,
		ret = "",
		i = 0,
		nodeType = elem.nodeType;

	if ( !nodeType ) {

		// If no nodeType, this is expected to be an array
		while ( ( node = elem[ i++ ] ) ) {

			// Do not traverse comment nodes
			ret += getText( node );
		}
	} else if ( nodeType === 1 || nodeType === 9 || nodeType === 11 ) {

		// Use textContent for elements
		// innerText usage removed for consistency of new lines (jQuery #11153)
		if ( typeof elem.textContent === "string" ) {
			return elem.textContent;
		} else {

			// Traverse its children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				ret += getText( elem );
			}
		}
	} else if ( nodeType === 3 || nodeType === 4 ) {
		return elem.nodeValue;
	}

	// Do not include comment or processing instruction nodes

	return ret;
};

Expr = Sizzle.selectors = {

	// Can be adjusted by the user
	cacheLength: 50,

	createPseudo: markFunction,

	match: matchExpr,

	attrHandle: {},

	find: {},

	relative: {
		">": { dir: "parentNode", first: true },
		" ": { dir: "parentNode" },
		"+": { dir: "previousSibling", first: true },
		"~": { dir: "previousSibling" }
	},

	preFilter: {
		"ATTR": function( match ) {
			match[ 1 ] = match[ 1 ].replace( runescape, funescape );

			// Move the given value to match[3] whether quoted or unquoted
			match[ 3 ] = ( match[ 3 ] || match[ 4 ] ||
				match[ 5 ] || "" ).replace( runescape, funescape );

			if ( match[ 2 ] === "~=" ) {
				match[ 3 ] = " " + match[ 3 ] + " ";
			}

			return match.slice( 0, 4 );
		},

		"CHILD": function( match ) {

			/* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
			match[ 1 ] = match[ 1 ].toLowerCase();

			if ( match[ 1 ].slice( 0, 3 ) === "nth" ) {

				// nth-* requires argument
				if ( !match[ 3 ] ) {
					Sizzle.error( match[ 0 ] );
				}

				// numeric x and y parameters for Expr.filter.CHILD
				// remember that false/true cast respectively to 0/1
				match[ 4 ] = +( match[ 4 ] ?
					match[ 5 ] + ( match[ 6 ] || 1 ) :
					2 * ( match[ 3 ] === "even" || match[ 3 ] === "odd" ) );
				match[ 5 ] = +( ( match[ 7 ] + match[ 8 ] ) || match[ 3 ] === "odd" );

				// other types prohibit arguments
			} else if ( match[ 3 ] ) {
				Sizzle.error( match[ 0 ] );
			}

			return match;
		},

		"PSEUDO": function( match ) {
			var excess,
				unquoted = !match[ 6 ] && match[ 2 ];

			if ( matchExpr[ "CHILD" ].test( match[ 0 ] ) ) {
				return null;
			}

			// Accept quoted arguments as-is
			if ( match[ 3 ] ) {
				match[ 2 ] = match[ 4 ] || match[ 5 ] || "";

			// Strip excess characters from unquoted arguments
			} else if ( unquoted && rpseudo.test( unquoted ) &&

				// Get excess from tokenize (recursively)
				( excess = tokenize( unquoted, true ) ) &&

				// advance to the next closing parenthesis
				( excess = unquoted.indexOf( ")", unquoted.length - excess ) - unquoted.length ) ) {

				// excess is a negative index
				match[ 0 ] = match[ 0 ].slice( 0, excess );
				match[ 2 ] = unquoted.slice( 0, excess );
			}

			// Return only captures needed by the pseudo filter method (type and argument)
			return match.slice( 0, 3 );
		}
	},

	filter: {

		"TAG": function( nodeNameSelector ) {
			var nodeName = nodeNameSelector.replace( runescape, funescape ).toLowerCase();
			return nodeNameSelector === "*" ?
				function() {
					return true;
				} :
				function( elem ) {
					return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
				};
		},

		"CLASS": function( className ) {
			var pattern = classCache[ className + " " ];

			return pattern ||
				( pattern = new RegExp( "(^|" + whitespace +
					")" + className + "(" + whitespace + "|$)" ) ) && classCache(
						className, function( elem ) {
							return pattern.test(
								typeof elem.className === "string" && elem.className ||
								typeof elem.getAttribute !== "undefined" &&
									elem.getAttribute( "class" ) ||
								""
							);
				} );
		},

		"ATTR": function( name, operator, check ) {
			return function( elem ) {
				var result = Sizzle.attr( elem, name );

				if ( result == null ) {
					return operator === "!=";
				}
				if ( !operator ) {
					return true;
				}

				result += "";

				/* eslint-disable max-len */

				return operator === "=" ? result === check :
					operator === "!=" ? result !== check :
					operator === "^=" ? check && result.indexOf( check ) === 0 :
					operator === "*=" ? check && result.indexOf( check ) > -1 :
					operator === "$=" ? check && result.slice( -check.length ) === check :
					operator === "~=" ? ( " " + result.replace( rwhitespace, " " ) + " " ).indexOf( check ) > -1 :
					operator === "|=" ? result === check || result.slice( 0, check.length + 1 ) === check + "-" :
					false;
				/* eslint-enable max-len */

			};
		},

		"CHILD": function( type, what, _argument, first, last ) {
			var simple = type.slice( 0, 3 ) !== "nth",
				forward = type.slice( -4 ) !== "last",
				ofType = what === "of-type";

			return first === 1 && last === 0 ?

				// Shortcut for :nth-*(n)
				function( elem ) {
					return !!elem.parentNode;
				} :

				function( elem, _context, xml ) {
					var cache, uniqueCache, outerCache, node, nodeIndex, start,
						dir = simple !== forward ? "nextSibling" : "previousSibling",
						parent = elem.parentNode,
						name = ofType && elem.nodeName.toLowerCase(),
						useCache = !xml && !ofType,
						diff = false;

					if ( parent ) {

						// :(first|last|only)-(child|of-type)
						if ( simple ) {
							while ( dir ) {
								node = elem;
								while ( ( node = node[ dir ] ) ) {
									if ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) {

										return false;
									}
								}

								// Reverse direction for :only-* (if we haven't yet done so)
								start = dir = type === "only" && !start && "nextSibling";
							}
							return true;
						}

						start = [ forward ? parent.firstChild : parent.lastChild ];

						// non-xml :nth-child(...) stores cache data on `parent`
						if ( forward && useCache ) {

							// Seek `elem` from a previously-cached index

							// ...in a gzip-friendly way
							node = parent;
							outerCache = node[ expando ] || ( node[ expando ] = {} );

							// Support: IE <9 only
							// Defend against cloned attroperties (jQuery gh-1709)
							uniqueCache = outerCache[ node.uniqueID ] ||
								( outerCache[ node.uniqueID ] = {} );

							cache = uniqueCache[ type ] || [];
							nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
							diff = nodeIndex && cache[ 2 ];
							node = nodeIndex && parent.childNodes[ nodeIndex ];

							while ( ( node = ++nodeIndex && node && node[ dir ] ||

								// Fallback to seeking `elem` from the start
								( diff = nodeIndex = 0 ) || start.pop() ) ) {

								// When found, cache indexes on `parent` and break
								if ( node.nodeType === 1 && ++diff && node === elem ) {
									uniqueCache[ type ] = [ dirruns, nodeIndex, diff ];
									break;
								}
							}

						} else {

							// Use previously-cached element index if available
							if ( useCache ) {

								// ...in a gzip-friendly way
								node = elem;
								outerCache = node[ expando ] || ( node[ expando ] = {} );

								// Support: IE <9 only
								// Defend against cloned attroperties (jQuery gh-1709)
								uniqueCache = outerCache[ node.uniqueID ] ||
									( outerCache[ node.uniqueID ] = {} );

								cache = uniqueCache[ type ] || [];
								nodeIndex = cache[ 0 ] === dirruns && cache[ 1 ];
								diff = nodeIndex;
							}

							// xml :nth-child(...)
							// or :nth-last-child(...) or :nth(-last)?-of-type(...)
							if ( diff === false ) {

								// Use the same loop as above to seek `elem` from the start
								while ( ( node = ++nodeIndex && node && node[ dir ] ||
									( diff = nodeIndex = 0 ) || start.pop() ) ) {

									if ( ( ofType ?
										node.nodeName.toLowerCase() === name :
										node.nodeType === 1 ) &&
										++diff ) {

										// Cache the index of each encountered element
										if ( useCache ) {
											outerCache = node[ expando ] ||
												( node[ expando ] = {} );

											// Support: IE <9 only
											// Defend against cloned attroperties (jQuery gh-1709)
											uniqueCache = outerCache[ node.uniqueID ] ||
												( outerCache[ node.uniqueID ] = {} );

											uniqueCache[ type ] = [ dirruns, diff ];
										}

										if ( node === elem ) {
											break;
										}
									}
								}
							}
						}

						// Incorporate the offset, then check against cycle size
						diff -= last;
						return diff === first || ( diff % first === 0 && diff / first >= 0 );
					}
				};
		},

		"PSEUDO": function( pseudo, argument ) {

			// pseudo-class names are case-insensitive
			// http://www.w3.org/TR/selectors/#pseudo-classes
			// Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
			// Remember that setFilters inherits from pseudos
			var args,
				fn = Expr.pseudos[ pseudo ] || Expr.setFilters[ pseudo.toLowerCase() ] ||
					Sizzle.error( "unsupported pseudo: " + pseudo );

			// The user may use createPseudo to indicate that
			// arguments are needed to create the filter function
			// just as Sizzle does
			if ( fn[ expando ] ) {
				return fn( argument );
			}

			// But maintain support for old signatures
			if ( fn.length > 1 ) {
				args = [ pseudo, pseudo, "", argument ];
				return Expr.setFilters.hasOwnProperty( pseudo.toLowerCase() ) ?
					markFunction( function( seed, matches ) {
						var idx,
							matched = fn( seed, argument ),
							i = matched.length;
						while ( i-- ) {
							idx = indexOf( seed, matched[ i ] );
							seed[ idx ] = !( matches[ idx ] = matched[ i ] );
						}
					} ) :
					function( elem ) {
						return fn( elem, 0, args );
					};
			}

			return fn;
		}
	},

	pseudos: {

		// Potentially complex pseudos
		"not": markFunction( function( selector ) {

			// Trim the selector passed to compile
			// to avoid treating leading and trailing
			// spaces as combinators
			var input = [],
				results = [],
				matcher = compile( selector.replace( rtrim, "$1" ) );

			return matcher[ expando ] ?
				markFunction( function( seed, matches, _context, xml ) {
					var elem,
						unmatched = matcher( seed, null, xml, [] ),
						i = seed.length;

					// Match elements unmatched by `matcher`
					while ( i-- ) {
						if ( ( elem = unmatched[ i ] ) ) {
							seed[ i ] = !( matches[ i ] = elem );
						}
					}
				} ) :
				function( elem, _context, xml ) {
					input[ 0 ] = elem;
					matcher( input, null, xml, results );

					// Don't keep the element (issue #299)
					input[ 0 ] = null;
					return !results.pop();
				};
		} ),

		"has": markFunction( function( selector ) {
			return function( elem ) {
				return Sizzle( selector, elem ).length > 0;
			};
		} ),

		"contains": markFunction( function( text ) {
			text = text.replace( runescape, funescape );
			return function( elem ) {
				return ( elem.textContent || getText( elem ) ).indexOf( text ) > -1;
			};
		} ),

		// "Whether an element is represented by a :lang() selector
		// is based solely on the element's language value
		// being equal to the identifier C,
		// or beginning with the identifier C immediately followed by "-".
		// The matching of C against the element's language value is performed case-insensitively.
		// The identifier C does not have to be a valid language name."
		// http://www.w3.org/TR/selectors/#lang-pseudo
		"lang": markFunction( function( lang ) {

			// lang value must be a valid identifier
			if ( !ridentifier.test( lang || "" ) ) {
				Sizzle.error( "unsupported lang: " + lang );
			}
			lang = lang.replace( runescape, funescape ).toLowerCase();
			return function( elem ) {
				var elemLang;
				do {
					if ( ( elemLang = documentIsHTML ?
						elem.lang :
						elem.getAttribute( "xml:lang" ) || elem.getAttribute( "lang" ) ) ) {

						elemLang = elemLang.toLowerCase();
						return elemLang === lang || elemLang.indexOf( lang + "-" ) === 0;
					}
				} while ( ( elem = elem.parentNode ) && elem.nodeType === 1 );
				return false;
			};
		} ),

		// Miscellaneous
		"target": function( elem ) {
			var hash = window.location && window.location.hash;
			return hash && hash.slice( 1 ) === elem.id;
		},

		"root": function( elem ) {
			return elem === docElem;
		},

		"focus": function( elem ) {
			return elem === document.activeElement &&
				( !document.hasFocus || document.hasFocus() ) &&
				!!( elem.type || elem.href || ~elem.tabIndex );
		},

		// Boolean properties
		"enabled": createDisabledPseudo( false ),
		"disabled": createDisabledPseudo( true ),

		"checked": function( elem ) {

			// In CSS3, :checked should return both checked and selected elements
			// http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
			var nodeName = elem.nodeName.toLowerCase();
			return ( nodeName === "input" && !!elem.checked ) ||
				( nodeName === "option" && !!elem.selected );
		},

		"selected": function( elem ) {

			// Accessing this property makes selected-by-default
			// options in Safari work properly
			if ( elem.parentNode ) {
				// eslint-disable-next-line no-unused-expressions
				elem.parentNode.selectedIndex;
			}

			return elem.selected === true;
		},

		// Contents
		"empty": function( elem ) {

			// http://www.w3.org/TR/selectors/#empty-pseudo
			// :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
			//   but not by others (comment: 8; processing instruction: 7; etc.)
			// nodeType < 6 works because attributes (2) do not appear as children
			for ( elem = elem.firstChild; elem; elem = elem.nextSibling ) {
				if ( elem.nodeType < 6 ) {
					return false;
				}
			}
			return true;
		},

		"parent": function( elem ) {
			return !Expr.pseudos[ "empty" ]( elem );
		},

		// Element/input types
		"header": function( elem ) {
			return rheader.test( elem.nodeName );
		},

		"input": function( elem ) {
			return rinputs.test( elem.nodeName );
		},

		"button": function( elem ) {
			var name = elem.nodeName.toLowerCase();
			return name === "input" && elem.type === "button" || name === "button";
		},

		"text": function( elem ) {
			var attr;
			return elem.nodeName.toLowerCase() === "input" &&
				elem.type === "text" &&

				// Support: IE<8
				// New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
				( ( attr = elem.getAttribute( "type" ) ) == null ||
					attr.toLowerCase() === "text" );
		},

		// Position-in-collection
		"first": createPositionalPseudo( function() {
			return [ 0 ];
		} ),

		"last": createPositionalPseudo( function( _matchIndexes, length ) {
			return [ length - 1 ];
		} ),

		"eq": createPositionalPseudo( function( _matchIndexes, length, argument ) {
			return [ argument < 0 ? argument + length : argument ];
		} ),

		"even": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 0;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"odd": createPositionalPseudo( function( matchIndexes, length ) {
			var i = 1;
			for ( ; i < length; i += 2 ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"lt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ?
				argument + length :
				argument > length ?
					length :
					argument;
			for ( ; --i >= 0; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} ),

		"gt": createPositionalPseudo( function( matchIndexes, length, argument ) {
			var i = argument < 0 ? argument + length : argument;
			for ( ; ++i < length; ) {
				matchIndexes.push( i );
			}
			return matchIndexes;
		} )
	}
};

Expr.pseudos[ "nth" ] = Expr.pseudos[ "eq" ];

// Add button/input type pseudos
for ( i in { radio: true, checkbox: true, file: true, password: true, image: true } ) {
	Expr.pseudos[ i ] = createInputPseudo( i );
}
for ( i in { submit: true, reset: true } ) {
	Expr.pseudos[ i ] = createButtonPseudo( i );
}

// Easy API for creating new setFilters
function setFilters() {}
setFilters.prototype = Expr.filters = Expr.pseudos;
Expr.setFilters = new setFilters();

tokenize = Sizzle.tokenize = function( selector, parseOnly ) {
	var matched, match, tokens, type,
		soFar, groups, preFilters,
		cached = tokenCache[ selector + " " ];

	if ( cached ) {
		return parseOnly ? 0 : cached.slice( 0 );
	}

	soFar = selector;
	groups = [];
	preFilters = Expr.preFilter;

	while ( soFar ) {

		// Comma and first run
		if ( !matched || ( match = rcomma.exec( soFar ) ) ) {
			if ( match ) {

				// Don't consume trailing commas as valid
				soFar = soFar.slice( match[ 0 ].length ) || soFar;
			}
			groups.push( ( tokens = [] ) );
		}

		matched = false;

		// Combinators
		if ( ( match = rcombinators.exec( soFar ) ) ) {
			matched = match.shift();
			tokens.push( {
				value: matched,

				// Cast descendant combinators to space
				type: match[ 0 ].replace( rtrim, " " )
			} );
			soFar = soFar.slice( matched.length );
		}

		// Filters
		for ( type in Expr.filter ) {
			if ( ( match = matchExpr[ type ].exec( soFar ) ) && ( !preFilters[ type ] ||
				( match = preFilters[ type ]( match ) ) ) ) {
				matched = match.shift();
				tokens.push( {
					value: matched,
					type: type,
					matches: match
				} );
				soFar = soFar.slice( matched.length );
			}
		}

		if ( !matched ) {
			break;
		}
	}

	// Return the length of the invalid excess
	// if we're just parsing
	// Otherwise, throw an error or return tokens
	return parseOnly ?
		soFar.length :
		soFar ?
			Sizzle.error( selector ) :

			// Cache the tokens
			tokenCache( selector, groups ).slice( 0 );
};

function toSelector( tokens ) {
	var i = 0,
		len = tokens.length,
		selector = "";
	for ( ; i < len; i++ ) {
		selector += tokens[ i ].value;
	}
	return selector;
}

function addCombinator( matcher, combinator, base ) {
	var dir = combinator.dir,
		skip = combinator.next,
		key = skip || dir,
		checkNonElements = base && key === "parentNode",
		doneName = done++;

	return combinator.first ?

		// Check against closest ancestor/preceding element
		function( elem, context, xml ) {
			while ( ( elem = elem[ dir ] ) ) {
				if ( elem.nodeType === 1 || checkNonElements ) {
					return matcher( elem, context, xml );
				}
			}
			return false;
		} :

		// Check against all ancestor/preceding elements
		function( elem, context, xml ) {
			var oldCache, uniqueCache, outerCache,
				newCache = [ dirruns, doneName ];

			// We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
			if ( xml ) {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						if ( matcher( elem, context, xml ) ) {
							return true;
						}
					}
				}
			} else {
				while ( ( elem = elem[ dir ] ) ) {
					if ( elem.nodeType === 1 || checkNonElements ) {
						outerCache = elem[ expando ] || ( elem[ expando ] = {} );

						// Support: IE <9 only
						// Defend against cloned attroperties (jQuery gh-1709)
						uniqueCache = outerCache[ elem.uniqueID ] ||
							( outerCache[ elem.uniqueID ] = {} );

						if ( skip && skip === elem.nodeName.toLowerCase() ) {
							elem = elem[ dir ] || elem;
						} else if ( ( oldCache = uniqueCache[ key ] ) &&
							oldCache[ 0 ] === dirruns && oldCache[ 1 ] === doneName ) {

							// Assign to newCache so results back-propagate to previous elements
							return ( newCache[ 2 ] = oldCache[ 2 ] );
						} else {

							// Reuse newcache so results back-propagate to previous elements
							uniqueCache[ key ] = newCache;

							// A match means we're done; a fail means we have to keep checking
							if ( ( newCache[ 2 ] = matcher( elem, context, xml ) ) ) {
								return true;
							}
						}
					}
				}
			}
			return false;
		};
}

function elementMatcher( matchers ) {
	return matchers.length > 1 ?
		function( elem, context, xml ) {
			var i = matchers.length;
			while ( i-- ) {
				if ( !matchers[ i ]( elem, context, xml ) ) {
					return false;
				}
			}
			return true;
		} :
		matchers[ 0 ];
}

function multipleContexts( selector, contexts, results ) {
	var i = 0,
		len = contexts.length;
	for ( ; i < len; i++ ) {
		Sizzle( selector, contexts[ i ], results );
	}
	return results;
}

function condense( unmatched, map, filter, context, xml ) {
	var elem,
		newUnmatched = [],
		i = 0,
		len = unmatched.length,
		mapped = map != null;

	for ( ; i < len; i++ ) {
		if ( ( elem = unmatched[ i ] ) ) {
			if ( !filter || filter( elem, context, xml ) ) {
				newUnmatched.push( elem );
				if ( mapped ) {
					map.push( i );
				}
			}
		}
	}

	return newUnmatched;
}

function setMatcher( preFilter, selector, matcher, postFilter, postFinder, postSelector ) {
	if ( postFilter && !postFilter[ expando ] ) {
		postFilter = setMatcher( postFilter );
	}
	if ( postFinder && !postFinder[ expando ] ) {
		postFinder = setMatcher( postFinder, postSelector );
	}
	return markFunction( function( seed, results, context, xml ) {
		var temp, i, elem,
			preMap = [],
			postMap = [],
			preexisting = results.length,

			// Get initial elements from seed or context
			elems = seed || multipleContexts(
				selector || "*",
				context.nodeType ? [ context ] : context,
				[]
			),

			// Prefilter to get matcher input, preserving a map for seed-results synchronization
			matcherIn = preFilter && ( seed || !selector ) ?
				condense( elems, preMap, preFilter, context, xml ) :
				elems,

			matcherOut = matcher ?

				// If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
				postFinder || ( seed ? preFilter : preexisting || postFilter ) ?

					// ...intermediate processing is necessary
					[] :

					// ...otherwise use results directly
					results :
				matcherIn;

		// Find primary matches
		if ( matcher ) {
			matcher( matcherIn, matcherOut, context, xml );
		}

		// Apply postFilter
		if ( postFilter ) {
			temp = condense( matcherOut, postMap );
			postFilter( temp, [], context, xml );

			// Un-match failing elements by moving them back to matcherIn
			i = temp.length;
			while ( i-- ) {
				if ( ( elem = temp[ i ] ) ) {
					matcherOut[ postMap[ i ] ] = !( matcherIn[ postMap[ i ] ] = elem );
				}
			}
		}

		if ( seed ) {
			if ( postFinder || preFilter ) {
				if ( postFinder ) {

					// Get the final matcherOut by condensing this intermediate into postFinder contexts
					temp = [];
					i = matcherOut.length;
					while ( i-- ) {
						if ( ( elem = matcherOut[ i ] ) ) {

							// Restore matcherIn since elem is not yet a final match
							temp.push( ( matcherIn[ i ] = elem ) );
						}
					}
					postFinder( null, ( matcherOut = [] ), temp, xml );
				}

				// Move matched elements from seed to results to keep them synchronized
				i = matcherOut.length;
				while ( i-- ) {
					if ( ( elem = matcherOut[ i ] ) &&
						( temp = postFinder ? indexOf( seed, elem ) : preMap[ i ] ) > -1 ) {

						seed[ temp ] = !( results[ temp ] = elem );
					}
				}
			}

		// Add elements to results, through postFinder if defined
		} else {
			matcherOut = condense(
				matcherOut === results ?
					matcherOut.splice( preexisting, matcherOut.length ) :
					matcherOut
			);
			if ( postFinder ) {
				postFinder( null, results, matcherOut, xml );
			} else {
				push.apply( results, matcherOut );
			}
		}
	} );
}

function matcherFromTokens( tokens ) {
	var checkContext, matcher, j,
		len = tokens.length,
		leadingRelative = Expr.relative[ tokens[ 0 ].type ],
		implicitRelative = leadingRelative || Expr.relative[ " " ],
		i = leadingRelative ? 1 : 0,

		// The foundational matcher ensures that elements are reachable from top-level context(s)
		matchContext = addCombinator( function( elem ) {
			return elem === checkContext;
		}, implicitRelative, true ),
		matchAnyContext = addCombinator( function( elem ) {
			return indexOf( checkContext, elem ) > -1;
		}, implicitRelative, true ),
		matchers = [ function( elem, context, xml ) {
			var ret = ( !leadingRelative && ( xml || context !== outermostContext ) ) || (
				( checkContext = context ).nodeType ?
					matchContext( elem, context, xml ) :
					matchAnyContext( elem, context, xml ) );

			// Avoid hanging onto element (issue #299)
			checkContext = null;
			return ret;
		} ];

	for ( ; i < len; i++ ) {
		if ( ( matcher = Expr.relative[ tokens[ i ].type ] ) ) {
			matchers = [ addCombinator( elementMatcher( matchers ), matcher ) ];
		} else {
			matcher = Expr.filter[ tokens[ i ].type ].apply( null, tokens[ i ].matches );

			// Return special upon seeing a positional matcher
			if ( matcher[ expando ] ) {

				// Find the next relative operator (if any) for proper handling
				j = ++i;
				for ( ; j < len; j++ ) {
					if ( Expr.relative[ tokens[ j ].type ] ) {
						break;
					}
				}
				return setMatcher(
					i > 1 && elementMatcher( matchers ),
					i > 1 && toSelector(

					// If the preceding token was a descendant combinator, insert an implicit any-element `*`
					tokens
						.slice( 0, i - 1 )
						.concat( { value: tokens[ i - 2 ].type === " " ? "*" : "" } )
					).replace( rtrim, "$1" ),
					matcher,
					i < j && matcherFromTokens( tokens.slice( i, j ) ),
					j < len && matcherFromTokens( ( tokens = tokens.slice( j ) ) ),
					j < len && toSelector( tokens )
				);
			}
			matchers.push( matcher );
		}
	}

	return elementMatcher( matchers );
}

function matcherFromGroupMatchers( elementMatchers, setMatchers ) {
	var bySet = setMatchers.length > 0,
		byElement = elementMatchers.length > 0,
		superMatcher = function( seed, context, xml, results, outermost ) {
			var elem, j, matcher,
				matchedCount = 0,
				i = "0",
				unmatched = seed && [],
				setMatched = [],
				contextBackup = outermostContext,

				// We must always have either seed elements or outermost context
				elems = seed || byElement && Expr.find[ "TAG" ]( "*", outermost ),

				// Use integer dirruns iff this is the outermost matcher
				dirrunsUnique = ( dirruns += contextBackup == null ? 1 : Math.random() || 0.1 ),
				len = elems.length;

			if ( outermost ) {

				// Support: IE 11+, Edge 17 - 18+
				// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
				// two documents; shallow comparisons work.
				// eslint-disable-next-line eqeqeq
				outermostContext = context == document || context || outermost;
			}

			// Add elements passing elementMatchers directly to results
			// Support: IE<9, Safari
			// Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
			for ( ; i !== len && ( elem = elems[ i ] ) != null; i++ ) {
				if ( byElement && elem ) {
					j = 0;

					// Support: IE 11+, Edge 17 - 18+
					// IE/Edge sometimes throw a "Permission denied" error when strict-comparing
					// two documents; shallow comparisons work.
					// eslint-disable-next-line eqeqeq
					if ( !context && elem.ownerDocument != document ) {
						setDocument( elem );
						xml = !documentIsHTML;
					}
					while ( ( matcher = elementMatchers[ j++ ] ) ) {
						if ( matcher( elem, context || document, xml ) ) {
							results.push( elem );
							break;
						}
					}
					if ( outermost ) {
						dirruns = dirrunsUnique;
					}
				}

				// Track unmatched elements for set filters
				if ( bySet ) {

					// They will have gone through all possible matchers
					if ( ( elem = !matcher && elem ) ) {
						matchedCount--;
					}

					// Lengthen the array for every element, matched or not
					if ( seed ) {
						unmatched.push( elem );
					}
				}
			}

			// `i` is now the count of elements visited above, and adding it to `matchedCount`
			// makes the latter nonnegative.
			matchedCount += i;

			// Apply set filters to unmatched elements
			// NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
			// equals `i`), unless we didn't visit _any_ elements in the above loop because we have
			// no element matchers and no seed.
			// Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
			// case, which will result in a "00" `matchedCount` that differs from `i` but is also
			// numerically zero.
			if ( bySet && i !== matchedCount ) {
				j = 0;
				while ( ( matcher = setMatchers[ j++ ] ) ) {
					matcher( unmatched, setMatched, context, xml );
				}

				if ( seed ) {

					// Reintegrate element matches to eliminate the need for sorting
					if ( matchedCount > 0 ) {
						while ( i-- ) {
							if ( !( unmatched[ i ] || setMatched[ i ] ) ) {
								setMatched[ i ] = pop.call( results );
							}
						}
					}

					// Discard index placeholder values to get only actual matches
					setMatched = condense( setMatched );
				}

				// Add matches to results
				push.apply( results, setMatched );

				// Seedless set matches succeeding multiple successful matchers stipulate sorting
				if ( outermost && !seed && setMatched.length > 0 &&
					( matchedCount + setMatchers.length ) > 1 ) {

					Sizzle.uniqueSort( results );
				}
			}

			// Override manipulation of globals by nested matchers
			if ( outermost ) {
				dirruns = dirrunsUnique;
				outermostContext = contextBackup;
			}

			return unmatched;
		};

	return bySet ?
		markFunction( superMatcher ) :
		superMatcher;
}

compile = Sizzle.compile = function( selector, match /* Internal Use Only */ ) {
	var i,
		setMatchers = [],
		elementMatchers = [],
		cached = compilerCache[ selector + " " ];

	if ( !cached ) {

		// Generate a function of recursive functions that can be used to check each element
		if ( !match ) {
			match = tokenize( selector );
		}
		i = match.length;
		while ( i-- ) {
			cached = matcherFromTokens( match[ i ] );
			if ( cached[ expando ] ) {
				setMatchers.push( cached );
			} else {
				elementMatchers.push( cached );
			}
		}

		// Cache the compiled function
		cached = compilerCache(
			selector,
			matcherFromGroupMatchers( elementMatchers, setMatchers )
		);

		// Save selector and tokenization
		cached.selector = selector;
	}
	return cached;
};

/**
 * A low-level selection function that works with Sizzle's compiled
 *  selector functions
 * @param {String|Function} selector A selector or a pre-compiled
 *  selector function built with Sizzle.compile
 * @param {Element} context
 * @param {Array} [results]
 * @param {Array} [seed] A set of elements to match against
 */
select = Sizzle.select = function( selector, context, results, seed ) {
	var i, tokens, token, type, find,
		compiled = typeof selector === "function" && selector,
		match = !seed && tokenize( ( selector = compiled.selector || selector ) );

	results = results || [];

	// Try to minimize operations if there is only one selector in the list and no seed
	// (the latter of which guarantees us context)
	if ( match.length === 1 ) {

		// Reduce context if the leading compound selector is an ID
		tokens = match[ 0 ] = match[ 0 ].slice( 0 );
		if ( tokens.length > 2 && ( token = tokens[ 0 ] ).type === "ID" &&
			context.nodeType === 9 && documentIsHTML && Expr.relative[ tokens[ 1 ].type ] ) {

			context = ( Expr.find[ "ID" ]( token.matches[ 0 ]
				.replace( runescape, funescape ), context ) || [] )[ 0 ];
			if ( !context ) {
				return results;

			// Precompiled matchers will still verify ancestry, so step up a level
			} else if ( compiled ) {
				context = context.parentNode;
			}

			selector = selector.slice( tokens.shift().value.length );
		}

		// Fetch a seed set for right-to-left matching
		i = matchExpr[ "needsContext" ].test( selector ) ? 0 : tokens.length;
		while ( i-- ) {
			token = tokens[ i ];

			// Abort if we hit a combinator
			if ( Expr.relative[ ( type = token.type ) ] ) {
				break;
			}
			if ( ( find = Expr.find[ type ] ) ) {

				// Search, expanding context for leading sibling combinators
				if ( ( seed = find(
					token.matches[ 0 ].replace( runescape, funescape ),
					rsibling.test( tokens[ 0 ].type ) && testContext( context.parentNode ) ||
						context
				) ) ) {

					// If seed is empty or no tokens remain, we can return early
					tokens.splice( i, 1 );
					selector = seed.length && toSelector( tokens );
					if ( !selector ) {
						push.apply( results, seed );
						return results;
					}

					break;
				}
			}
		}
	}

	// Compile and execute a filtering function if one is not provided
	// Provide `match` to avoid retokenization if we modified the selector above
	( compiled || compile( selector, match ) )(
		seed,
		context,
		!documentIsHTML,
		results,
		!context || rsibling.test( selector ) && testContext( context.parentNode ) || context
	);
	return results;
};

// One-time assignments

// Sort stability
support.sortStable = expando.split( "" ).sort( sortOrder ).join( "" ) === expando;

// Support: Chrome 14-35+
// Always assume duplicates if they aren't passed to the comparison function
support.detectDuplicates = !!hasDuplicate;

// Initialize against the default document
setDocument();

// Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
// Detached nodes confoundingly follow *each other*
support.sortDetached = assert( function( el ) {

	// Should return 1, but returns 4 (following)
	return el.compareDocumentPosition( document.createElement( "fieldset" ) ) & 1;
} );

// Support: IE<8
// Prevent attribute/property "interpolation"
// https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
if ( !assert( function( el ) {
	el.innerHTML = "<a href='#'></a>";
	return el.firstChild.getAttribute( "href" ) === "#";
} ) ) {
	addHandle( "type|href|height|width", function( elem, name, isXML ) {
		if ( !isXML ) {
			return elem.getAttribute( name, name.toLowerCase() === "type" ? 1 : 2 );
		}
	} );
}

// Support: IE<9
// Use defaultValue in place of getAttribute("value")
if ( !support.attributes || !assert( function( el ) {
	el.innerHTML = "<input/>";
	el.firstChild.setAttribute( "value", "" );
	return el.firstChild.getAttribute( "value" ) === "";
} ) ) {
	addHandle( "value", function( elem, _name, isXML ) {
		if ( !isXML && elem.nodeName.toLowerCase() === "input" ) {
			return elem.defaultValue;
		}
	} );
}

// Support: IE<9
// Use getAttributeNode to fetch booleans when getAttribute lies
if ( !assert( function( el ) {
	return el.getAttribute( "disabled" ) == null;
} ) ) {
	addHandle( booleans, function( elem, name, isXML ) {
		var val;
		if ( !isXML ) {
			return elem[ name ] === true ? name.toLowerCase() :
				( val = elem.getAttributeNode( name ) ) && val.specified ?
					val.value :
					null;
		}
	} );
}

return Sizzle;

} )( window );



jQuery.find = Sizzle;
jQuery.expr = Sizzle.selectors;

// Deprecated
jQuery.expr[ ":" ] = jQuery.expr.pseudos;
jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
jQuery.text = Sizzle.getText;
jQuery.isXMLDoc = Sizzle.isXML;
jQuery.contains = Sizzle.contains;
jQuery.escapeSelector = Sizzle.escape;




var dir = function( elem, dir, until ) {
	var matched = [],
		truncate = until !== undefined;

	while ( ( elem = elem[ dir ] ) && elem.nodeType !== 9 ) {
		if ( elem.nodeType === 1 ) {
			if ( truncate && jQuery( elem ).is( until ) ) {
				break;
			}
			matched.push( elem );
		}
	}
	return matched;
};


var siblings = function( n, elem ) {
	var matched = [];

	for ( ; n; n = n.nextSibling ) {
		if ( n.nodeType === 1 && n !== elem ) {
			matched.push( n );
		}
	}

	return matched;
};


var rneedsContext = jQuery.expr.match.needsContext;



function nodeName( elem, name ) {

	return elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase();

}
var rsingleTag = ( /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i );



// Implement the identical functionality for filter and not
function winnow( elements, qualifier, not ) {
	if ( isFunction( qualifier ) ) {
		return jQuery.grep( elements, function( elem, i ) {
			return !!qualifier.call( elem, i, elem ) !== not;
		} );
	}

	// Single element
	if ( qualifier.nodeType ) {
		return jQuery.grep( elements, function( elem ) {
			return ( elem === qualifier ) !== not;
		} );
	}

	// Arraylike of elements (jQuery, arguments, Array)
	if ( typeof qualifier !== "string" ) {
		return jQuery.grep( elements, function( elem ) {
			return ( indexOf.call( qualifier, elem ) > -1 ) !== not;
		} );
	}

	// Filtered directly for both simple and complex selectors
	return jQuery.filter( qualifier, elements, not );
}

jQuery.filter = function( expr, elems, not ) {
	var elem = elems[ 0 ];

	if ( not ) {
		expr = ":not(" + expr + ")";
	}

	if ( elems.length === 1 && elem.nodeType === 1 ) {
		return jQuery.find.matchesSelector( elem, expr ) ? [ elem ] : [];
	}

	return jQuery.find.matches( expr, jQuery.grep( elems, function( elem ) {
		return elem.nodeType === 1;
	} ) );
};

jQuery.fn.extend( {
	find: function( selector ) {
		var i, ret,
			len = this.length,
			self = this;

		if ( typeof selector !== "string" ) {
			return this.pushStack( jQuery( selector ).filter( function() {
				for ( i = 0; i < len; i++ ) {
					if ( jQuery.contains( self[ i ], this ) ) {
						return true;
					}
				}
			} ) );
		}

		ret = this.pushStack( [] );

		for ( i = 0; i < len; i++ ) {
			jQuery.find( selector, self[ i ], ret );
		}

		return len > 1 ? jQuery.uniqueSort( ret ) : ret;
	},
	filter: function( selector ) {
		return this.pushStack( winnow( this, selector || [], false ) );
	},
	not: function( selector ) {
		return this.pushStack( winnow( this, selector || [], true ) );
	},
	is: function( selector ) {
		return !!winnow(
			this,

			// If this is a positional/relative selector, check membership in the returned set
			// so $("p:first").is("p:last") won't return true for a doc with two "p".
			typeof selector === "string" && rneedsContext.test( selector ) ?
				jQuery( selector ) :
				selector || [],
			false
		).length;
	}
} );


// Initialize a jQuery object


// A central reference to the root jQuery(document)
var rootjQuery,

	// A simple way to check for HTML strings
	// Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
	// Strict HTML recognition (#11290: must start with <)
	// Shortcut simple #id case for speed
	rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,

	init = jQuery.fn.init = function( selector, context, root ) {
		var match, elem;

		// HANDLE: $(""), $(null), $(undefined), $(false)
		if ( !selector ) {
			return this;
		}

		// Method init() accepts an alternate rootjQuery
		// so migrate can support jQuery.sub (gh-2101)
		root = root || rootjQuery;

		// Handle HTML strings
		if ( typeof selector === "string" ) {
			if ( selector[ 0 ] === "<" &&
				selector[ selector.length - 1 ] === ">" &&
				selector.length >= 3 ) {

				// Assume that strings that start and end with <> are HTML and skip the regex check
				match = [ null, selector, null ];

			} else {
				match = rquickExpr.exec( selector );
			}

			// Match html or make sure no context is specified for #id
			if ( match && ( match[ 1 ] || !context ) ) {

				// HANDLE: $(html) -> $(array)
				if ( match[ 1 ] ) {
					context = context instanceof jQuery ? context[ 0 ] : context;

					// Option to run scripts is true for back-compat
					// Intentionally let the error be thrown if parseHTML is not present
					jQuery.merge( this, jQuery.parseHTML(
						match[ 1 ],
						context && context.nodeType ? context.ownerDocument || context : document,
						true
					) );

					// HANDLE: $(html, props)
					if ( rsingleTag.test( match[ 1 ] ) && jQuery.isPlainObject( context ) ) {
						for ( match in context ) {

							// Properties of context are called as methods if possible
							if ( isFunction( this[ match ] ) ) {
								this[ match ]( context[ match ] );

							// ...and otherwise set as attributes
							} else {
								this.attr( match, context[ match ] );
							}
						}
					}

					return this;

				// HANDLE: $(#id)
				} else {
					elem = document.getElementById( match[ 2 ] );

					if ( elem ) {

						// Inject the element directly into the jQuery object
						this[ 0 ] = elem;
						this.length = 1;
					}
					return this;
				}

			// HANDLE: $(expr, $(...))
			} else if ( !context || context.jquery ) {
				return ( context || root ).find( selector );

			// HANDLE: $(expr, context)
			// (which is just equivalent to: $(context).find(expr)
			} else {
				return this.constructor( context ).find( selector );
			}

		// HANDLE: $(DOMElement)
		} else if ( selector.nodeType ) {
			this[ 0 ] = selector;
			this.length = 1;
			return this;

		// HANDLE: $(function)
		// Shortcut for document ready
		} else if ( isFunction( selector ) ) {
			return root.ready !== undefined ?
				root.ready( selector ) :

				// Execute immediately if ready is not present
				selector( jQuery );
		}

		return jQuery.makeArray( selector, this );
	};

// Give the init function the jQuery prototype for later instantiation
init.prototype = jQuery.fn;

// Initialize central reference
rootjQuery = jQuery( document );


var rparentsprev = /^(?:parents|prev(?:Until|All))/,

	// Methods guaranteed to produce a unique set when starting from a unique set
	guaranteedUnique = {
		children: true,
		contents: true,
		next: true,
		prev: true
	};

jQuery.fn.extend( {
	has: function( target ) {
		var targets = jQuery( target, this ),
			l = targets.length;

		return this.filter( function() {
			var i = 0;
			for ( ; i < l; i++ ) {
				if ( jQuery.contains( this, targets[ i ] ) ) {
					return true;
				}
			}
		} );
	},

	closest: function( selectors, context ) {
		var cur,
			i = 0,
			l = this.length,
			matched = [],
			targets = typeof selectors !== "string" && jQuery( selectors );

		// Positional selectors never match, since there's no _selection_ context
		if ( !rneedsContext.test( selectors ) ) {
			for ( ; i < l; i++ ) {
				for ( cur = this[ i ]; cur && cur !== context; cur = cur.parentNode ) {

					// Always skip document fragments
					if ( cur.nodeType < 11 && ( targets ?
						targets.index( cur ) > -1 :

						// Don't pass non-elements to Sizzle
						cur.nodeType === 1 &&
							jQuery.find.matchesSelector( cur, selectors ) ) ) {

						matched.push( cur );
						break;
					}
				}
			}
		}

		return this.pushStack( matched.length > 1 ? jQuery.uniqueSort( matched ) : matched );
	},

	// Determine the position of an element within the set
	index: function( elem ) {

		// No argument, return index in parent
		if ( !elem ) {
			return ( this[ 0 ] && this[ 0 ].parentNode ) ? this.first().prevAll().length : -1;
		}

		// Index in selector
		if ( typeof elem === "string" ) {
			return indexOf.call( jQuery( elem ), this[ 0 ] );
		}

		// Locate the position of the desired element
		return indexOf.call( this,

			// If it receives a jQuery object, the first element is used
			elem.jquery ? elem[ 0 ] : elem
		);
	},

	add: function( selector, context ) {
		return this.pushStack(
			jQuery.uniqueSort(
				jQuery.merge( this.get(), jQuery( selector, context ) )
			)
		);
	},

	addBack: function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	}
} );

function sibling( cur, dir ) {
	while ( ( cur = cur[ dir ] ) && cur.nodeType !== 1 ) {}
	return cur;
}

jQuery.each( {
	parent: function( elem ) {
		var parent = elem.parentNode;
		return parent && parent.nodeType !== 11 ? parent : null;
	},
	parents: function( elem ) {
		return dir( elem, "parentNode" );
	},
	parentsUntil: function( elem, _i, until ) {
		return dir( elem, "parentNode", until );
	},
	next: function( elem ) {
		return sibling( elem, "nextSibling" );
	},
	prev: function( elem ) {
		return sibling( elem, "previousSibling" );
	},
	nextAll: function( elem ) {
		return dir( elem, "nextSibling" );
	},
	prevAll: function( elem ) {
		return dir( elem, "previousSibling" );
	},
	nextUntil: function( elem, _i, until ) {
		return dir( elem, "nextSibling", until );
	},
	prevUntil: function( elem, _i, until ) {
		return dir( elem, "previousSibling", until );
	},
	siblings: function( elem ) {
		return siblings( ( elem.parentNode || {} ).firstChild, elem );
	},
	children: function( elem ) {
		return siblings( elem.firstChild );
	},
	contents: function( elem ) {
		if ( elem.contentDocument != null &&

			// Support: IE 11+
			// <object> elements with no `data` attribute has an object
			// `contentDocument` with a `null` prototype.
			getProto( elem.contentDocument ) ) {

			return elem.contentDocument;
		}

		// Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
		// Treat the template element as a regular one in browsers that
		// don't support it.
		if ( nodeName( elem, "template" ) ) {
			elem = elem.content || elem;
		}

		return jQuery.merge( [], elem.childNodes );
	}
}, function( name, fn ) {
	jQuery.fn[ name ] = function( until, selector ) {
		var matched = jQuery.map( this, fn, until );

		if ( name.slice( -5 ) !== "Until" ) {
			selector = until;
		}

		if ( selector && typeof selector === "string" ) {
			matched = jQuery.filter( selector, matched );
		}

		if ( this.length > 1 ) {

			// Remove duplicates
			if ( !guaranteedUnique[ name ] ) {
				jQuery.uniqueSort( matched );
			}

			// Reverse order for parents* and prev-derivatives
			if ( rparentsprev.test( name ) ) {
				matched.reverse();
			}
		}

		return this.pushStack( matched );
	};
} );
var rnothtmlwhite = ( /[^\x20\t\r\n\f]+/g );



// Convert String-formatted options into Object-formatted ones
function createOptions( options ) {
	var object = {};
	jQuery.each( options.match( rnothtmlwhite ) || [], function( _, flag ) {
		object[ flag ] = true;
	} );
	return object;
}

/*
 * Create a callback list using the following parameters:
 *
 *	options: an optional list of space-separated options that will change how
 *			the callback list behaves or a more traditional option object
 *
 * By default a callback list will act like an event callback list and can be
 * "fired" multiple times.
 *
 * Possible options:
 *
 *	once:			will ensure the callback list can only be fired once (like a Deferred)
 *
 *	memory:			will keep track of previous values and will call any callback added
 *					after the list has been fired right away with the latest "memorized"
 *					values (like a Deferred)
 *
 *	unique:			will ensure a callback can only be added once (no duplicate in the list)
 *
 *	stopOnFalse:	interrupt callings when a callback returns false
 *
 */
jQuery.Callbacks = function( options ) {

	// Convert options from String-formatted to Object-formatted if needed
	// (we check in cache first)
	options = typeof options === "string" ?
		createOptions( options ) :
		jQuery.extend( {}, options );

	var // Flag to know if list is currently firing
		firing,

		// Last fire value for non-forgettable lists
		memory,

		// Flag to know if list was already fired
		fired,

		// Flag to prevent firing
		locked,

		// Actual callback list
		list = [],

		// Queue of execution data for repeatable lists
		queue = [],

		// Index of currently firing callback (modified by add/remove as needed)
		firingIndex = -1,

		// Fire callbacks
		fire = function() {

			// Enforce single-firing
			locked = locked || options.once;

			// Execute callbacks for all pending executions,
			// respecting firingIndex overrides and runtime changes
			fired = firing = true;
			for ( ; queue.length; firingIndex = -1 ) {
				memory = queue.shift();
				while ( ++firingIndex < list.length ) {

					// Run callback and check for early termination
					if ( list[ firingIndex ].apply( memory[ 0 ], memory[ 1 ] ) === false &&
						options.stopOnFalse ) {

						// Jump to end and forget the data so .add doesn't re-fire
						firingIndex = list.length;
						memory = false;
					}
				}
			}

			// Forget the data if we're done with it
			if ( !options.memory ) {
				memory = false;
			}

			firing = false;

			// Clean up if we're done firing for good
			if ( locked ) {

				// Keep an empty list if we have data for future add calls
				if ( memory ) {
					list = [];

				// Otherwise, this object is spent
				} else {
					list = "";
				}
			}
		},

		// Actual Callbacks object
		self = {

			// Add a callback or a collection of callbacks to the list
			add: function() {
				if ( list ) {

					// If we have memory from a past run, we should fire after adding
					if ( memory && !firing ) {
						firingIndex = list.length - 1;
						queue.push( memory );
					}

					( function add( args ) {
						jQuery.each( args, function( _, arg ) {
							if ( isFunction( arg ) ) {
								if ( !options.unique || !self.has( arg ) ) {
									list.push( arg );
								}
							} else if ( arg && arg.length && toType( arg ) !== "string" ) {

								// Inspect recursively
								add( arg );
							}
						} );
					} )( arguments );

					if ( memory && !firing ) {
						fire();
					}
				}
				return this;
			},

			// Remove a callback from the list
			remove: function() {
				jQuery.each( arguments, function( _, arg ) {
					var index;
					while ( ( index = jQuery.inArray( arg, list, index ) ) > -1 ) {
						list.splice( index, 1 );

						// Handle firing indexes
						if ( index <= firingIndex ) {
							firingIndex--;
						}
					}
				} );
				return this;
			},

			// Check if a given callback is in the list.
			// If no argument is given, return whether or not list has callbacks attached.
			has: function( fn ) {
				return fn ?
					jQuery.inArray( fn, list ) > -1 :
					list.length > 0;
			},

			// Remove all callbacks from the list
			empty: function() {
				if ( list ) {
					list = [];
				}
				return this;
			},

			// Disable .fire and .add
			// Abort any current/pending executions
			// Clear all callbacks and values
			disable: function() {
				locked = queue = [];
				list = memory = "";
				return this;
			},
			disabled: function() {
				return !list;
			},

			// Disable .fire
			// Also disable .add unless we have memory (since it would have no effect)
			// Abort any pending executions
			lock: function() {
				locked = queue = [];
				if ( !memory && !firing ) {
					list = memory = "";
				}
				return this;
			},
			locked: function() {
				return !!locked;
			},

			// Call all callbacks with the given context and arguments
			fireWith: function( context, args ) {
				if ( !locked ) {
					args = args || [];
					args = [ context, args.slice ? args.slice() : args ];
					queue.push( args );
					if ( !firing ) {
						fire();
					}
				}
				return this;
			},

			// Call all the callbacks with the given arguments
			fire: function() {
				self.fireWith( this, arguments );
				return this;
			},

			// To know if the callbacks have already been called at least once
			fired: function() {
				return !!fired;
			}
		};

	return self;
};


function Identity( v ) {
	return v;
}
function Thrower( ex ) {
	throw ex;
}

function adoptValue( value, resolve, reject, noValue ) {
	var method;

	try {

		// Check for promise aspect first to privilege synchronous behavior
		if ( value && isFunction( ( method = value.promise ) ) ) {
			method.call( value ).done( resolve ).fail( reject );

		// Other thenab