<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'mautic/mautic';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'aws/aws-crt-php' => 'v1.2.4@eb0c6e4e142224a10b08f49ebf87f32611d162b2',
  'aws/aws-sdk-php' => '3.298.2@626f731c38e06ea483025334512f4c2afea1739d',
  'bandwidth-throttle/token-bucket' => '2.0.0@a0c31a4d0fbcf0c1a68c895fc91bf71455bcec08',
  'barryvdh/elfinder-flysystem-driver' => 'v0.4.3@064d5b2c89ca185f3736e7e5c906d76d3632b30c',
  'beberlei/doctrineextensions' => 'v1.3.0@008f162f191584a6c37c03a803f718802ba9dd9a',
  'brick/math' => '0.11.0@0ad82ce168c82ba30d1c01ec86116ab52f589478',
  'composer/ca-bundle' => '1.4.0@b66d11b7479109ab547f9405b97205640b17d385',
  'composer/class-map-generator' => '1.1.0@953cc4ea32e0c31f2185549c7d216d7921f03da9',
  'composer/composer' => '2.6.6@683557bd2466072777309d039534bb1332d0dda5',
  'composer/installers' => 'v1.12.0@d20a64ed3c94748397ff5973488761b22f6d3f19',
  'composer/metadata-minifier' => '1.0.0@c549d23829536f0d0e984aaabbf02af91f443207',
  'composer/package-versions-deprecated' => '1.11.99.1@7413f0b55a051e89485c5cb9f765fe24bb02a7b6',
  'composer/pcre' => '3.1.1@00104306927c7a0919b4ced2aaa6782c1e61a3c9',
  'composer/semver' => '3.4.0@35e8d0af4486141bc745f23a29cc2091eb624a32',
  'composer/spdx-licenses' => '1.5.8@560bdcf8deb88ae5d611c80a2de8ea9d0358cc0a',
  'composer/xdebug-handler' => '3.0.3@ced299686f41dce890debac69273b47ffe98a40c',
  'doctrine/annotations' => '2.0.1@e157ef3f3124bbf6fe7ce0ffd109e8a8ef284e7f',
  'doctrine/cache' => '2.2.0@1ca8f21980e770095a31456042471a57bc4c68fb',
  'doctrine/collections' => '1.8.0@2b44dd4cbca8b5744327de78bafef5945c7e7b5e',
  'doctrine/common' => '3.4.3@8b5e5650391f851ed58910b3e3d48a71062eeced',
  'doctrine/data-fixtures' => '1.7.0@bbcb74f2ac6dbe81a14b3c3687d7623490a0448f',
  'doctrine/dbal' => '3.7.2@0ac3c270590e54910715e9a1a044cc368df282b2',
  'doctrine/deprecations' => '1.1.3@dfbaa3c2d2e9a9df1118213f3b8b0c597bb99fab',
  'doctrine/doctrine-bundle' => '2.11.1@4089f1424b724786c062aea50aae5f773449b94b',
  'doctrine/doctrine-fixtures-bundle' => '3.5.1@c808a0c85c38c8ee265cc8405b456c1d2b38567d',
  'doctrine/doctrine-migrations-bundle' => '3.3.0@1dd42906a5fb9c5960723e2ebb45c68006493835',
  'doctrine/event-manager' => '1.2.0@95aa4cb529f1e96576f3fda9f5705ada4056a520',
  'doctrine/inflector' => '2.0.9@2930cd5ef353871c821d5c43ed030d39ac8cfe65',
  'doctrine/instantiator' => '1.5.0@0a0fa9780f5d4e507415a065172d26a98d02047b',
  'doctrine/lexer' => '2.1.0@39ab8fcf5a51ce4b85ca97c7a7d033eb12831124',
  'doctrine/migrations' => '3.5.5@4b1e2b6ba71d21d0c5be22ed03b6fc954d20b204',
  'doctrine/orm' => '2.18.0@f2176a9ce56cafdfd1624d54bfdb076819083d5b',
  'doctrine/persistence' => '3.2.0@63fee8c33bef740db6730eb2a750cd3da6495603',
  'doctrine/sql-formatter' => '1.1.3@25a06c7bf4c6b8218f47928654252863ffc890a5',
  'egulias/email-validator' => '3.2.6@e5997fa97e8790cdae03a9cbd5e78e45e3c7bda7',
  'exercise/htmlpurifier-bundle' => '4.1.2@526c98e5b6ca712874d6422b98f32233b81f4c19',
  'ezyang/htmlpurifier' => 'v4.17.0@bbc513d79acf6691fa9cf10f192c90dd2957f18c',
  'friendsofphp/proxy-manager-lts' => 'v1.0.16@ecadbdc9052e4ad08c60c8a02268712e50427f7c',
  'friendsofsymfony/oauth-server-bundle' => 'dev-upgrade-2@dc8ff343363cf794d30eb1a123610d186a43f162',
  'friendsofsymfony/oauth2-php' => '1.3.1@546f869d68fb79b284752e6787263d797165dba4',
  'friendsofsymfony/rest-bundle' => '3.6.0@e01be8113d4451adb3cbb29d7d2cc96bbc698179',
  'gaufrette/aws-s3-adapter' => 'v0.4.0@a37143f592d5cb0ba124451439af6e6da6784d89',
  'gaufrette/extras' => 'v0.1.0@a2af9a8c53591a4c43a38249e17bcdefdcea8a23',
  'geoip2/geoip2' => 'v2.13.0@6a41d8fbd6b90052bc34dff3b4252d0f88067b23',
  'giggsey/libphonenumber-for-php' => '8.13.29@b8fa0daf0c27bb6fdb5940e0288f203be7e5cfd4',
  'giggsey/locale' => '2.5@e6d4540109a01dd2bc7334cdc842d6a6a67cf239',
  'guzzlehttp/guzzle' => '7.8.1@41042bc7ab002487b876a0683fc8dce04ddce104',
  'guzzlehttp/oauth-subscriber' => '0.6.0@8d6cab29f8397e5712d00a383eeead36108a3c1f',
  'guzzlehttp/promises' => '2.0.2@bbff78d96034045e58e13dedd6ad91b5d1253223',
  'guzzlehttp/psr7' => '2.6.2@45b30f99ac27b5ca93cb4831afe16285f57b8221',
  'helios-ag/fm-elfinder-bundle' => '12.5@49a5317b7495da6f16356624d8efa28c8e76661b',
  'intervention/image' => '2.7.2@04be355f8d6734c826045d02a1079ad658322dad',
  'ip2location/ip2location-php' => '7.2.5@5f637f2e95e51861b9d969aa98f4e5868074f922',
  'jbroadway/urlify' => '1.2.4-stable@d0fafbaa1dc14e8039cdf5c72a932a8d1de1750e',
  'jms/metadata' => '2.8.0@7ca240dcac0c655eb15933ee55736ccd2ea0d7a6',
  'jms/serializer' => '3.29.1@111451f43abb448ce297361a8ab96a9591e848cd',
  'jms/serializer-bundle' => '5.4.0@6fa2dd0083e00fe21c5da171556d7ecabc14b437',
  'joomla/filter' => '1.4.4@09733d70db6c6d91e53e0e0d0fcde9b8638175c4',
  'joomla/string' => '1.4.6@728ba9e39a8f1bd15b75ab878f57fa505184b8ab',
  'justinrainbow/json-schema' => 'v5.2.13@fbbe7e5d79f618997bc3332a6f49246036c45793',
  'kamermans/guzzle-oauth2-subscriber' => 'v1.0.13@10b5cf242c5167afd16f1c1f243ac5be689ecd4c',
  'knplabs/gaufrette' => 'v0.9.0@786247eba04d4693e88a80ca9fdabb634675dcac',
  'knplabs/knp-menu' => 'v3.4.0@bf7d89a7ef406fd2ec1aae6f30f722e844bf6d31',
  'knplabs/knp-menu-bundle' => 'v3.2.0@a0b4224f872d74ae939589eb1ccf0e11291370a9',
  'laminas/laminas-code' => '4.7.1@91aabc066d5620428120800c0eafc0411e441a62',
  'league/flysystem' => '3.24.0@b25a361508c407563b34fac6f64a8a17a8819675',
  'league/flysystem-local' => '3.23.1@b884d2bf9b53bb4804a56d2df4902bb51e253f00',
  'league/mime-type-detection' => '1.15.0@ce0f4d1e8a6f4eb0ddff33f57c69c50fd09f4301',
  'leezy/pheanstalk-bundle' => 'dev-master@972a5c154e52fd04ec70c13519ddb73dec819700',
  'lightsaml/sp-bundle' => 'dev-symfony5@91f36a54b223d5405e6e41ea612d640360d35554',
  'lightsaml/symfony-bridge' => 'dev-symfony5@26f58d33a52b357dea90f6361d29d7321987be77',
  'litesaml/lightsaml' => 'v4.1.6@b6aa6f41c3a051a52e39ddc3a7b753a8601bee69',
  'maennchen/zipstream-php' => '2.4.0@3fa72e4c71a43f9e9118752a5c90e476a8dc9eb3',
  'malkusch/lock' => 'v1.4@96cd2d82180fc87bd8ad45aac25486f82d9fbf4b',
  'markbaker/complex' => '3.0.2@95c56caa1cf5c766ad6d65b6344b807c1e8405b9',
  'markbaker/matrix' => '3.0.1@728434227fe21be27ff6d86621a1b13107a2562c',
  'matomo/device-detector' => '4.3.1@88e5419ee1448ccb9537e287dd09836ff9d2de3b',
  'matthiasmullie/minify' => '1.3.71@ae42a47d7fecc1fbb7277b2f2d84c37a33edc3b1',
  'matthiasmullie/path-converter' => '1.1.3@e7d13b2c7e2f2268e1424aaed02085518afa02d9',
  'mautic/core-lib' => '5.0.0-dev@a2fefb6250e5d342a5148891c216cf3bc9f3521b',
  'maxmind-db/reader' => 'v1.11.1@1e66f73ffcf25e17c7a910a1317e9720a95497c7',
  'maxmind/web-service-common' => 'v0.9.0@4dc5a3e8df38aea4ca3b1096cee3a038094e9b53',
  'monolog/monolog' => '2.9.2@437cb3628f4cf6042cc10ae97fc2b8472e48ca1f',
  'mtdowling/jmespath.php' => '2.7.0@bbb69a935c2cbb0c03d7f481a238027430f6440b',
  'mustangostang/spyc' => '0.6.3@4627c838b16550b666d15aeae1e5289dd5b77da0',
  'myclabs/php-enum' => '1.8.4@a867478eae49c9f59ece437ae7f9506bfaa27483',
  'nikic/php-parser' => 'v4.18.0@1bcbb2179f97633e98bbbc87044ee2611c7d7999',
  'noxlogic/ratelimit-bundle' => 'v1.19.0@f5fe8e0ae8e1481f16c7c9ad89fae66c89512d37',
  'oneup/uploader-bundle' => '3.2.1@b11ea2060d4d76b7202d24ae170162b70c7a88b6',
  'paragonie/constant_time_encoding' => 'v2.6.3@58c3f47f650c94ec05a151692652a868995d2938',
  'paragonie/random_compat' => 'v2.0.21@96c132c7f2f7bc3230723b66e89f8f150b29d5ae',
  'pda/pheanstalk' => 'v4.0.5@1459f2f62dddfe28902e0584708417dddd79bd70',
  'php-amqplib/php-amqplib' => 'v3.6.0@fb84e99589de0904a25861451b0552f806284ee5',
  'php-amqplib/rabbitmq-bundle' => '2.14.0@a80937c30214ffb36683c27edb226ed59492bd08',
  'php-http/guzzle7-adapter' => '1.0.0@fb075a71dbfa4847cf0c2938c4e5a9c478ef8b01',
  'php-http/httplug' => '2.4.0@625ad742c360c8ac580fcc647a1541d29e257f67',
  'php-http/promise' => '1.3.0@2916a606d3b390f4e9e8e2b8dd68581508be0f07',
  'phpoffice/phpspreadsheet' => '1.27.1@ef4e6ef74990239946d3983451a9bbed5ef1be5d',
  'phpseclib/phpseclib' => '3.0.35@4b1827beabce71953ca479485c0ae9c51287f2fe',
  'phpstan/phpdoc-parser' => '1.25.0@bd84b629c8de41aa2ae82c067c955e06f1b00240',
  'predis/predis' => 'v1.1.10@a2fb02d738bedadcffdbb07efa3a5e7bd57f8d6e',
  'psr/cache' => '2.0.0@213f9dbc5b9bfbc4f8db86d2838dc968752ce13b',
  'psr/container' => '1.1.2@513e0666f7216c7459170d56df27dfcefe1689ea',
  'psr/event-dispatcher' => '1.0.0@dbefd12671e8a14ec7f180cab83036ed26714bb0',
  'psr/http-client' => '1.0.3@bb5906edc1c324c9a05aa0873d40117941e5fa90',
  'psr/http-factory' => '1.0.2@e616d01114759c4c489f93b099585439f795fe35',
  'psr/http-message' => '1.1@cb6ce4845ce34a8ad9e68117c10ee90a29919eba',
  'psr/log' => '1.1.4@d49695b909c3b7628b6289db5479a1c204601f11',
  'psr/simple-cache' => '2.0.0@8707bf3cea6f710bf6ef05491234e3ab06f6432a',
  'psy/psysh' => 'v0.10.12@a0d9981aa07ecfcbea28e4bfa868031cca121e7d',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'ramsey/collection' => '1.3.0@ad7475d1c9e70b190ecffc58f2d989416af339b4',
  'ramsey/uuid' => '4.7.5@5f0df49ae5ad6efb7afa69e6bfab4e5b1e080d8e',
  'react/promise' => 'v3.1.0@e563d55d1641de1dea9f5e84f3cccc66d2bfe02c',
  'robrichards/xmlseclibs' => '3.1.1@f8f19e58f26cdb42c54b214ff8a820760292f8df',
  'seld/jsonlint' => '1.10.1@76d449a358ece77d6f1d6331c68453e657172202',
  'seld/phar-utils' => '1.2.1@ea2f4014f163c1be4c601b9b7bd6af81ba8d701c',
  'seld/signal-handler' => '2.0.2@04a6112e883ad76c0ada8e4a9f7520bbfdb6bb98',
  'sensio/framework-extra-bundle' => 'v6.2.10@2f886f4b31f23c76496901acaedfedb6936ba61f',
  'simshaun/recurr' => 'v5.0.2@1aff62e6e0ee875b3f2487352542605123ee9172',
  'stack/builder' => 'v1.0.6@a4faaa6f532c6086bc66c29e1bc6c29593e1ca7c',
  'studio-42/elfinder' => '2.1.65@5535a8677558c44a20c19ff9b97ec37702f9c44d',
  'symfony/amqp-messenger' => 'v5.4.35@41d9dadbfd9edd0906c9a8d6b614f2fab274408f',
  'symfony/asset' => 'v5.4.35@0e98032106d18e57f57176d616e3fae80db7a845',
  'symfony/cache' => 'v5.4.35@db1adb004e2da984085d0178964eb6f319d3cba1',
  'symfony/cache-contracts' => 'v2.5.2@64be4a7acb83b6f2bf6de9a02cee6dad41277ebc',
  'symfony/config' => 'v5.4.35@6b763438a22a4f20885e994ad6702f6a3f25430e',
  'symfony/console' => 'v5.4.35@dbdf6adcb88d5f83790e1efb57ef4074309d3931',
  'symfony/css-selector' => 'v5.4.35@9e615d367e2bed41f633abb383948c96a2dbbfae',
  'symfony/dependency-injection' => 'v5.4.35@45474d527212ca67cdb93f6c5e6da68f4bc67118',
  'symfony/deprecation-contracts' => 'v3.0.2@26954b3d62a6c5fd0ea8a2a00c0353a14978d05c',
  'symfony/doctrine-bridge' => 'v5.4.35@f1c8d1f75ede8ba6810498666159c50ca05beec0',
  'symfony/doctrine-messenger' => 'v5.4.35@21351af73e7dbe9db64f4b6bb15af6f55c78bf6e',
  'symfony/dotenv' => 'v5.4.35@4de488440104b99d2e7c0717ee432e760b061e32',
  'symfony/error-handler' => 'v5.4.35@39225b1e47fdd91a6924b1e7d7a4523da2e1894b',
  'symfony/event-dispatcher' => 'v5.4.35@7a69a85c7ea5bdd1e875806a99c51a87d3a74b38',
  'symfony/event-dispatcher-contracts' => 'v3.0.2@7bc61cc2db649b4637d331240c5346dcc7708051',
  'symfony/expression-language' => 'v5.4.35@d59441c10a5a73cd9d4d778b8253595a16f6716d',
  'symfony/filesystem' => 'v5.4.35@5a553607d4ffbfa9c0ab62facadea296c9db7086',
  'symfony/finder' => 'v5.4.35@abe6d6f77d9465fed3cd2d029b29d03b56b56435',
  'symfony/form' => 'v5.4.35@c827d421caccf467ef1a969e7412a8755fa88093',
  'symfony/framework-bundle' => 'v5.4.35@89805687f360133f18bdedfb32138ce0ddd5383c',
  'symfony/http-client' => 'v5.4.35@53e4cc088a5f3466dc77c9f121f17e8e02ecc9c3',
  'symfony/http-client-contracts' => 'v2.5.2@ba6a9f0e8f3edd190520ee3b9a958596b6ca2e70',
  'symfony/http-foundation' => 'v5.4.35@f2ab692a22aef1cd54beb893aa0068bdfb093928',
  'symfony/http-kernel' => 'v5.4.35@949bc7721c83fa9f81fc6c9697db0aa340c64f4d',
  'symfony/intl' => 'v5.4.35@2fb503f81cd8032a624c55764d1fbaf893aa3cf4',
  'symfony/lock' => 'v5.4.35@b8b0d5b283af0e117e7ef6141b5b7e5efb20b247',
  'symfony/mailer' => 'v5.4.35@664724b0fb4646dee30859d0ed9131a2d7633320',
  'symfony/messenger' => 'v5.4.35@3c1eda00d7e9879558397fe8c8cfaea24b0de4e0',
  'symfony/mime' => 'v5.4.35@ee94d9b538f93abbbc1ee4ccff374593117b04a9',
  'symfony/monolog-bridge' => 'v5.4.35@83e7438fd2ead9af4fd2fac7bb9b6fc0e8823387',
  'symfony/monolog-bundle' => 'v3.5.0@dd80460fcfe1fa2050a7103ad818e9d0686ce6fd',
  'symfony/options-resolver' => 'v5.4.21@4fe5cf6ede71096839f0e4b4444d65dd3a7c1eb9',
  'symfony/password-hasher' => 'v6.0.19@2ae49765c5328307e82c0ee2898a39c071ef5bc8',
  'symfony/polyfill-ctype' => 'v1.28.0@ea208ce43cbb04af6867b4fdddb1bdbf84cc28cb',
  'symfony/polyfill-intl-grapheme' => 'v1.28.0@875e90aeea2777b6f135677f618529449334a612',
  'symfony/polyfill-intl-icu' => 'v1.28.0@e46b4da57951a16053cd751f63f4a24292788157',
  'symfony/polyfill-intl-idn' => 'v1.28.0@ecaafce9f77234a6a449d29e49267ba10499116d',
  'symfony/polyfill-intl-normalizer' => 'v1.28.0@8c4ad05dd0120b6a53c1ca374dca2ad0a1c4ed92',
  'symfony/polyfill-mbstring' => 'v1.28.0@42292d99c55abe617799667f454222c54c60e229',
  'symfony/polyfill-php72' => 'v1.28.0@70f4aebd92afca2f865444d30a4d2151c13c3179',
  'symfony/polyfill-php73' => 'v1.28.0@fe2f306d1d9d346a7fee353d0d5012e401e984b5',
  'symfony/polyfill-php80' => 'v1.28.0@6caa57379c4aec19c0a12a38b59b26487dcfe4b5',
  'symfony/polyfill-php81' => 'v1.28.0@7581cd600fa9fd681b797d00b02f068e2f13263b',
  'symfony/process' => 'v5.4.35@cbc28e34015ad50166fc2f9c8962d28d0fe861eb',
  'symfony/property-access' => 'v5.4.35@f1341758d8046cfff0ac748a0cad238f917191d4',
  'symfony/property-info' => 'v6.0.19@e6dfb2223b21768d3b2ae033a5e1f9d205184d45',
  'symfony/redis-messenger' => 'v6.0.19@75183a574bae512ae38beb0f3e623e6c4d708789',
  'symfony/routing' => 'v5.4.35@86c5a06a61ddaf17efa1403542e3d7146af96203',
  'symfony/security-acl' => 'v3.0.4@dc8f10b3bda34e9ddcad49edc7accf61f31fce43',
  'symfony/security-bundle' => 'v5.4.35@ed194715515a87d0f9c80b8696baf37ae18beb81',
  'symfony/security-core' => 'v5.4.35@3cbacefb2a350ed39950f93c8a054c2eb625fb69',
  'symfony/security-csrf' => 'v5.4.35@6728ed79d7f9aae3b86fca7ea554f1c46bae1e0b',
  'symfony/security-guard' => 'v5.4.35@b6fb8c88f7cd544db761de2d1c3618cbc5c1b9e7',
  'symfony/security-http' => 'v5.4.35@274a6aef49a0e1707bcb57217251885be749b6d8',
  'symfony/service-contracts' => 'v2.5.2@4b426aac47d6427cc1a1d0f7e2ac724627f5966c',
  'symfony/stopwatch' => 'v5.4.35@887762aa99ff16f65dc8b48aafead415f942d407',
  'symfony/string' => 'v6.0.19@d9e72497367c23e08bf94176d2be45b00a9d232a',
  'symfony/templating' => 'v5.4.35@3af084088a5dffacaa979a634a8aa4553b2013fe',
  'symfony/translation' => 'v5.4.35@77d7d1e46f52827585e65e6cd6f52a2542e59c72',
  'symfony/translation-contracts' => 'v2.5.2@136b19dd05cdf0709db6537d058bcab6dd6e2dbe',
  'symfony/twig-bridge' => 'v5.4.35@e6ae362b7c4f1d6e99f61f59b0c93b9f027b4c73',
  'symfony/twig-bundle' => 'v5.4.35@f59b91e23c7c790e71a187c3fa4aefdc5391d682',
  'symfony/validator' => 'v5.4.35@4993e9b5b17e23e7ad9dc2e3b31412f5c4679385',
  'symfony/var-dumper' => 'v5.4.35@ce4685b30e47d94dfc990c5566285ff99ddf012b',
  'symfony/var-exporter' => 'v6.0.19@df56f53818c2d5d9f683f4ad2e365ba73a3b69d2',
  'symfony/yaml' => 'v5.4.35@e78db7f5c70a21f0417a31f414c4a95fe76c07e4',
  'theofidry/psysh-bundle' => '4.4.0@c3d3807420961a0c70db3ff1b2527b7138ccf412',
  'tightenco/collect' => 'v8.83.27@07eed6cf7441c7a69c379fdcb118eec1a1fdd0e6',
  'twig/twig' => 'v3.8.0@9d15f0ac07f44dc4217883ec6ae02fd555c6f71d',
  'twilio/sdk' => '5.42.2@0cfcb871b18a9c427dd9e8f0ed7458d43009b48a',
  'voku/portable-ascii' => '2.0.1@b56450eed252f6801410d810c8e1727224ae0743',
  'voku/stop-words' => '2.0.1@8e63c0af20f800b1600783764e0ce19e53969f71',
  'wikimedia/less.php' => 'v4.1.1@7c814ca156716e7b46ad84ac038bf298ff91cbb4',
  'willdurand/jsonp-callback-validator' => 'v2.0.0@738c36e91d4d7e0ff0cac145f77057e0fb88526e',
  'willdurand/negotiation' => '3.1.0@68e9ea0553ef6e2ee8db5c1d98829f111e623ec2',
  'mautic/grapes-js-builder-bundle' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-clearbit' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-cloudstorage' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-crm' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-emailmarketing' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-focus' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-fullcontact' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-gmail' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-outlook' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-social' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-zapier' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/plugin-tagmanager' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-coffee' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-mauve' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-nature' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-aurora' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-blank' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-brienz' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-cards' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-confirmme' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-fresh-center' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-fresh-fixed' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-fresh-left' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-fresh-wide' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-goldstar' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-neopolitan' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-oxygen' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-paprika' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-skyline' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-sparse' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-sunday' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/theme-vibrant' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
  'mautic/mautic' => '5.0.4@4676457f5ac7c9d13308b119a28bbe527cb542ce',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!class_exists(InstalledVersions::class, false) || !InstalledVersions::getRawData()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (class_exists(InstalledVersions::class, false) && InstalledVersions::getRawData()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }
}
